import React from 'react';
import { View, Image, ActivityIndicator, StyleSheet } from 'react-native';

export default function LoadingScreen() {
  return (
    <View style={loadingStyles.container}>
      <Image source={require('../assets/logo.png')} style={loadingStyles.logo} />
      <ActivityIndicator size="large" color="#007AFF" style={loadingStyles.loader} />
    </View>
  );
}

const loadingStyles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center', backgroundColor: '#fff' },
  logo: { width: 200, height: 200, marginBottom: 30, resizeMode: 'contain' },
  loader: { marginTop: 20 }
});
