import React, { useState, useEffect } from 'react';
import { View, Text, TextInput, TouchableOpacity, Alert, Image } from 'react-native';
import { useNavigation } from '@react-navigation/native';
import { login, isLoggedIn } from '../auth';
import AsyncStorage from '@react-native-async-storage/async-storage';
import styles from '../styles/styles';

export default function LoginScreen() {
  const navigation = useNavigation();
  const [username, setUsername] = useState('');
  const [password, setPassword] = useState('');

  useEffect(() => {
    const checkSession = async () => {
      const logged = await isLoggedIn();
      if (logged) navigation.replace('Home');
    };
    checkSession();
  }, []);

  const handleLogin = async () => {
    if (!username || !password) {
      return Alert.alert('Error', 'Please field all the gaps');
    }
    try {
      const response = await fetch('http://51.210.149.28:5000/api/login', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ username, password }),
      });
      const data = await response.json();
      if (response.ok && data.success) {
        await login();
        navigation.replace('Home');
      } else {
        Alert.alert('Error', data.message || 'Wrong ID/Password');
      }
    } catch (e) {
      Alert.alert('Error', 'Impossible to connect');
    }
  };

  return (
    <View style={styles.container}>
  <Image source={require('../assets/loopbin.png')} style={styles.logoHome} />    
  <Image source={require('../assets/logo.png')} style={styles.logo} />
  <Text style={styles.title}>Connexion</Text>

  <TextInput
    style={styles.input}
    placeholder="Username"
    onChangeText={setUsername}
    value={username}
    autoCapitalize="none"
  />
  <TextInput
    style={styles.input}
    placeholder="Password"
    secureTextEntry
    onChangeText={setPassword}
    value={password}
  />
  <TouchableOpacity style={styles.button} onPress={handleLogin}>
    <Text style={styles.buttonText}>Log In</Text>
  </TouchableOpacity>
  <View style={{ flexDirection: 'row', marginTop: 20 }}>
    <Text style={{ color: 'black' }}>First visit? </Text>
    <TouchableOpacity onPress={() => navigation.navigate('Signup')}>
      <Text style={styles.link}>Sign Up</Text>
    </TouchableOpacity>
  </View>
</View>

  );
}
