// styles.js
import { StyleSheet, Dimensions } from 'react-native';
const { width } = Dimensions.get('window');

export default StyleSheet.create({
  container: { flex: 1, backgroundColor: '#f2f2f2', alignItems: 'center', justifyContent: 'center' },
  logo: { width: 150, height: 150, resizeMode: 'contain', marginBottom: 20 },
  logoSmall: { width: 80, height: 80, resizeMode: 'contain', marginBottom: 150, marginTop: -50 },
  logoHome: { width: 70, height: 70, resizeMode: 'contain', marginBottom: 20 },
  title: { fontSize: 24, marginBottom: 20, fontWeight: 'bold', color: '#BBBD9A' },
  input: { width: '80%', borderWidth: 1, borderColor: '#CCC', padding: 12, borderRadius: 8, marginBottom: 15, backgroundColor: '#FFF' },
  button: { backgroundColor: '#BBBD9A', padding: 14, borderRadius: 8, width: '80%', alignItems: 'center', marginBottom: 10 },
  link: { color: '#BBBD9A', fontWeight: 'bold' },
  buttonContainer: { width: '100%', alignItems: 'center', gap: 15 },
  mainButton: { backgroundColor: '#BBBD9A', paddingVertical: 20, borderRadius: 14, width: '90%', alignItems: 'center', elevation: 3 },
  BButton: { backgroundColor: '#c7c3d4', paddingVertical: 20, borderRadius: 14, width: '90%', alignItems: 'center', elevation: 3 },
  buttonText: { color: '#FFF', fontSize: 20, fontWeight: 'bold' },
  SUSButton: { position: 'absolute', top: 50, left: 20, backgroundColor: '#c7c3d4', paddingVertical: 8, paddingHorizontal: 16, borderRadius: 8 },
  logoutText: { color: '#FFF', fontWeight: '600' },
  logoutButton: { position: 'absolute', top: 50, right: 20, backgroundColor: '#BBBD9A', paddingVertical: 8, paddingHorizontal: 16, borderRadius: 8 },
  banner: { backgroundColor: '#BBBD9A', position: 'absolute', bottom: 0, width: '100%', height: 50, justifyContent: 'center', overflow: 'hidden', paddingLeft: 10 },
  bannerText: { fontSize: 16, fontWeight: 'bold' },
  card: { backgroundColor: '#F3F3F3', borderRadius: 16, padding: 20, shadowColor: '#000', shadowOpacity: 0.1, shadowOffset: { width: 0, height: 4 }, shadowRadius: 8, elevation: 3 },
  cardTitle: { fontSize: 20, fontWeight: 'bold', color: '#333' },
  cardMessage: { marginTop: 8, fontSize: 16, color: '#666' },
  statusText: { textAlign: 'center', marginTop: 7, fontSize: 16 },
  statusTextOK: { textAlign: 'center', marginTop: 7, fontSize: 16, color: 'green' },
  statusTextWarning: { textAlign: 'center', marginTop: 7, fontSize: 16, color: '#DAA520' },
  statusTextDanger: { textAlign: 'center', marginTop: 7, fontSize: 16, color: '#D9534F' },
  fanButton: {
    alignItems: 'center',
    marginTop: 40,
  },

  fanIcon: {
    width: 50,
    height: 50,
    marginBottom: 5,
    },
  buttonText: {color : '#333', fontSize: 14, fontWeight:'bold', alignItems: 'center' },

});
