import React, { useEffect, useState } from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator } from '@react-navigation/native-stack';
import { enableScreens } from 'react-native-screens';
import LoginScreen from './screens/LoginScreen';
import SignupScreen from './screens/SignupScreen';
import HomeScreen from './screens/HomeScreen';
import LoadingScreen from './screens/LoadingScreen';
import { isLoggedIn } from './auth';
import SensorScreen from './screens/Sensors';
import Sensor2Screen from './screens/Sensors2';
import SurveyScreen from './screens/SurveyScreen';

enableScreens();
const Stack = createNativeStackNavigator();

export default function App() {
  const [initialRoute, setInitialRoute] = useState(null);

  useEffect(() => {
    const checkLogin = async () => {
      const logged = await isLoggedIn();
      setInitialRoute(logged ? 'Home' : 'Login');
    };
    checkLogin();
  }, []);

  if (initialRoute === null) {
    return <LoadingScreen />;
  }

  return (
    <NavigationContainer>
      <Stack.Navigator screenOptions={{ headerShown: false }} initialRouteName={initialRoute}>
        <Stack.Screen name="Login" component={LoginScreen} />
        <Stack.Screen name="Signup" component={SignupScreen} />
        <Stack.Screen name="Home" component={HomeScreen} />
        <Stack.Screen name="Sensors" component={SensorScreen} />
        <Stack.Screen name="Sensors2" component={Sensor2Screen} />
        <Stack.Screen name="Survey" component={SurveyScreen}/>
      </Stack.Navigator>
    </NavigationContainer>
  );
}
