/**
 * Lighthouse v12.1.0 (Jun 18 2024)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   Copyright 2023 Google LLC
 * @license  Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
"use strict";(()=>{var Mq=Object.create;var Rc=Object.defineProperty;var Pq=Object.getOwnPropertyDescriptor;var Lq=Object.getOwnPropertyNames;var Oq=Object.getPrototypeOf,Bq=Object.prototype.hasOwnProperty;var s=(e,t)=>Rc(e,"name",{value:t,configurable:!0});var y=(e,t)=>()=>(e&&(t=e(e=0)),t);var P=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),x=(e,t)=>{for(var n in t)Rc(e,n,{get:t[n],enumerable:!0})},_C=(e,t,n,r)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of Lq(t))!Bq.call(e,a)&&a!==n&&Rc(e,a,{get:()=>t[a],enumerable:!(r=Pq(t,a))||r.enumerable});return e};var Bt=(e,t,n)=>(n=e!=null?Mq(Oq(e)):{},_C(t||!e||!e.__esModule?Rc(n,"default",{value:e,enumerable:!0}):n,e)),Uq=e=>_C(Rc({},"__esModule",{value:!0}),e);function IC(){throw new Error("setTimeout has not been defined")}function NC(){throw new Error("clearTimeout has not been defined")}function MC(e){if(Sa===setTimeout)return setTimeout(e,0);if((Sa===IC||!Sa)&&setTimeout)return Sa=setTimeout,setTimeout(e,0);try{return Sa(e,0)}catch{try{return Sa.call(null,e,0)}catch{return Sa.call(this,e,0)}}}function jq(e){if(Ca===clearTimeout)return clearTimeout(e);if((Ca===NC||!Ca)&&clearTimeout)return Ca=clearTimeout,clearTimeout(e);try{return Ca(e)}catch{try{return Ca.call(null,e)}catch{return Ca.call(this,e)}}}function qq(){!Ri||!xo||(Ri=!1,xo.length?Kr=xo.concat(Kr):nm=-1,Kr.length&&PC())}function PC(){if(!Ri){var e=MC(qq);Ri=!0;for(var t=Kr.length;t;){for(xo=Kr,Kr=[];++nm<t;)xo&&xo[nm].run();nm=-1,t=Kr.length}xo=null,Ri=!1,jq(e)}}function rn(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];Kr.push(new LC(e,t)),Kr.length===1&&!Ri&&MC(PC)}function LC(e,t){this.fun=e,this.array=t}function So(){}
function az(e){throw new Error("process.binding is not supported")}function oz(){return"/"}function iz(e){throw new Error("process.chdir is not supported")}function sz(){return 0}function uz(e){var t=cz.call(Fi)*.001,n=Math.floor(t),r=Math.floor(t%1*1e9);return e&&(n=n-e[0],r=r-e[1],r<0&&(n--,r+=1e9)),[n,r]}function dz(){var e=new Date,t=e-lz;return t/1e3}var Sa,Ca,Kr,Ri,xo,nm,zq,Hq,Wq,Gq,Vq,$q,Yq,Kq,Xq,Zq,Jq,Qq,ez,tz,nz,rz,Fi,cz,lz,an,ka=y(()=>{l();s(IC,"defaultSetTimout");s(NC,"defaultClearTimeout");Sa=IC,Ca=NC;typeof globalThis.setTimeout=="function"&&(Sa=setTimeout);typeof globalThis.clearTimeout=="function"&&(Ca=clearTimeout);s(MC,"runTimeout");s(jq,"runClearTimeout");Kr=[],Ri=!1,nm=-1;s(qq,"cleanUpNextTick");s(PC,"drainQueue");s(rn,"nextTick");s(LC,"Item");LC.prototype.run=function(){this.fun.apply(null,this.array)};zq="browser",Hq="browser",Wq=!0,Gq={},Vq=[],$q="",Yq={},Kq={},Xq={};s(So,"noop");Zq=So,Jq=So,Qq=So,ez=So,tz=So,nz=So,rz=So;s(az,"binding");s(oz,"cwd");s(iz,"chdir");s(
sz,"umask");Fi=globalThis.performance||{},cz=Fi.now||Fi.mozNow||Fi.msNow||Fi.oNow||Fi.webkitNow||function(){return new Date().getTime()};s(uz,"hrtime");lz=new Date;s(dz,"uptime");an={nextTick:rn,title:zq,browser:Wq,env:Gq,argv:Vq,version:$q,versions:Yq,on:Zq,addListener:Jq,once:Qq,off:ez,removeListener:tz,removeAllListeners:nz,emit:rz,binding:az,cwd:oz,chdir:iz,umask:sz,hrtime:uz,platform:Hq,release:Kq,config:Xq,uptime:dz}});var l=y(()=>{"use strict";ka();globalThis.process=an});function jC(){s1=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,n=e.length;t<n;++t)wr[t]=e[t],Un[e.charCodeAt(t)]=t;Un[45]=62,Un[95]=63}function pz(e){s1||jC();var t,n,r,a,o,i,c=e.length;if(c%4>0)throw new Error("Invalid string. Length must be a multiple of 4");o=e[c-2]==="="?2:e[c-1]==="="?1:0,i=new mz(c*3/4-o),r=o>0?c-4:c;var u=0;for(t=0,n=0;t<r;t+=4,n+=3)a=Un[e.charCodeAt(t)]<<18|Un[e.charCodeAt(t+1)]<<12|Un[e.charCodeAt(t+2)]<<6|Un[e.charCodeAt(t+3)],i[u++]=a>>16&255,i[u++]=a>>8&255,i[u++]=a&255;return o===2?(a=Un[e.charCodeAt(t)]<<2|Un[e.charCodeAt(t+1)]>>4,i[u++]=a&255):o===1&&(a=Un[e.charCodeAt(t)]<<10|Un[e.charCodeAt(t+1)]<<4|Un[e.charCodeAt(t+2)]>>2,i[u++]=a>>8&255,i[u++]=a&255),i}function fz(e){return wr[e>>18&63]+wr[e>>12&63]+wr[e>>6&63]+wr[e&63]}function hz(e,t,n){for(var r,a=[],o=t;o<n;o+=3)r=(e[o]<<16)+(e[o+1]<<8)+e[o+2],a.push(fz(r));return a.join("")}function OC(e){s1||jC();for(var t,n=e.length,r=n%3,a="",o=[],i=16383,c=0,u=n-r;c<u;c+=
i)o.push(hz(e,c,c+i>u?u:c+i));return r===1?(t=e[n-1],a+=wr[t>>2],a+=wr[t<<4&63],a+="=="):r===2&&(t=(e[n-2]<<8)+e[n-1],a+=wr[t>>10],a+=wr[t>>4&63],a+=wr[t<<2&63],a+="="),o.push(a),o.join("")}function om(e,t,n,r,a){var o,i,c=a*8-r-1,u=(1<<c)-1,d=u>>1,m=-7,p=n?a-1:0,h=n?-1:1,f=e[t+p];for(p+=h,o=f&(1<<-m)-1,f>>=-m,m+=c;m>0;o=o*256+e[t+p],p+=h,m-=8);for(i=o&(1<<-m)-1,o>>=-m,m+=r;m>0;i=i*256+e[t+p],p+=h,m-=8);if(o===0)o=1-d;else{if(o===u)return i?NaN:(f?-1:1)*(1/0);i=i+Math.pow(2,r),o=o-d}return(f?-1:1)*i*Math.pow(2,o-r)}function qC(e,t,n,r,a,o){var i,c,u,d=o*8-a-1,m=(1<<d)-1,p=m>>1,h=a===23?Math.pow(2,-24)-Math.pow(2,-77):0,f=r?0:o-1,g=r?1:-1,v=t<0||t===0&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(c=isNaN(t)?1:0,i=m):(i=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-i))<1&&(i--,u*=2),i+p>=1?t+=h/u:t+=h*Math.pow(2,1-p),t*u>=2&&(i++,u/=2),i+p>=m?(c=0,i=m):i+p>=1?(c=(t*u-1)*Math.pow(2,a),i=i+p):(c=t*Math.pow(2,p-1)*Math.pow(2,a),i=0));a>=8;e[n+f]=c&255,f+=g,c/=256,a-=8);for(i=i<<a|c,d+=
a;d>0;e[n+f]=i&255,f+=g,i/=256,d-=8);e[n+f-g]|=v*128}function rm(){return z.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function Xr(e,t){if(rm()<t)throw new RangeError("Invalid typed array length");return z.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=z.prototype):(e===null&&(e=new z(t)),e.length=t),e}function z(e,t,n){if(!z.TYPED_ARRAY_SUPPORT&&!(this instanceof z))return new z(e,t,n);if(typeof e=="number"){if(typeof t=="string")throw new Error("If encoding is specified then the first argument must be a string");return c1(this,e)}return HC(this,e,t,n)}function HC(e,t,n,r){if(typeof t=="number")throw new TypeError('"value" argument must not be a number');return typeof ArrayBuffer<"u"&&t instanceof ArrayBuffer?wz(e,t,n,r):typeof t=="string"?bz(e,t,n):Dz(e,t)}function WC(e){if(typeof e!="number")throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function vz(e,t,n,r){return WC(t),t<=0?Xr(e,t):n!==void 0?typeof r==
"string"?Xr(e,t).fill(n,r):Xr(e,t).fill(n):Xr(e,t)}function c1(e,t){if(WC(t),e=Xr(e,t<0?0:u1(t)|0),!z.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function bz(e,t,n){if((typeof n!="string"||n==="")&&(n="utf8"),!z.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=GC(t,n)|0;e=Xr(e,r);var a=e.write(t,n);return a!==r&&(e=e.slice(0,a)),e}function i1(e,t){var n=t.length<0?0:u1(t.length)|0;e=Xr(e,n);for(var r=0;r<n;r+=1)e[r]=t[r]&255;return e}function wz(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return n===void 0&&r===void 0?t=new Uint8Array(t):r===void 0?t=new Uint8Array(t,n):t=new Uint8Array(t,n,r),z.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=z.prototype):e=i1(e,t),e}function Dz(e,t){if(Dr(t)){var n=u1(t.length)|0;return e=Xr(e,n),e.length===0||t.copy(e,0,0,n),e}if(t){if(typeof ArrayBuffer<"u"&&t.buffer instanceof ArrayBuffer||
"length"in t)return typeof t.length!="number"||jz(t.length)?Xr(e,0):i1(e,t);if(t.type==="Buffer"&&zC(t.data))return i1(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function u1(e){if(e>=rm())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+rm().toString(16)+" bytes");return e|0}function Dr(e){return!!(e!=null&&e._isBuffer)}function GC(e,t){if(Dr(e))return e.length;if(typeof ArrayBuffer<"u"&&typeof ArrayBuffer.isView=="function"&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;typeof e!="string"&&(e=""+e);var n=e.length;if(n===0)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return am(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return n*2;case"hex":return n>>>1;case"base64":return JC(e).length;default:if(r)return am(e).length;t=(""+t).toLowerCase(),r=!0}}function Ez(e,t,n){var r=!1;
if((t===void 0||t<0)&&(t=0),t>this.length||((n===void 0||n>this.length)&&(n=this.length),n<=0)||(n>>>=0,t>>>=0,n<=t))return"";for(e||(e="utf8");;)switch(e){case"hex":return Iz(this,t,n);case"utf8":case"utf-8":return YC(this,t,n);case"ascii":return Az(this,t,n);case"latin1":case"binary":return _z(this,t,n);case"base64":return Fz(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return Nz(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function Co(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function VC(e,t,n,r,a){if(e.length===0)return-1;if(typeof n=="string"?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=a?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(a)return-1;n=e.length-1}else if(n<0)if(a)n=0;else return-1;if(typeof t=="string"&&(t=z.from(t,r)),Dr(t))return t.length===0?-1:BC(e,t,n,r,a);if(typeof t=="number")return t=t&255,z.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf=="function"?
a?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):BC(e,[t],n,r,a);throw new TypeError("val must be string, number or Buffer")}function BC(e,t,n,r,a){var o=1,i=e.length,c=t.length;if(r!==void 0&&(r=String(r).toLowerCase(),r==="ucs2"||r==="ucs-2"||r==="utf16le"||r==="utf-16le")){if(e.length<2||t.length<2)return-1;o=2,i/=2,c/=2,n/=2}function u(f,g){return o===1?f[g]:f.readUInt16BE(g*o)}s(u,"read");var d;if(a){var m=-1;for(d=n;d<i;d++)if(u(e,d)===u(t,m===-1?0:d-m)){if(m===-1&&(m=d),d-m+1===c)return m*o}else m!==-1&&(d-=d-m),m=-1}else for(n+c>i&&(n=i-c),d=n;d>=0;d--){for(var p=!0,h=0;h<c;h++)if(u(e,d+h)!==u(t,h)){p=!1;break}if(p)return d}return-1}function Tz(e,t,n,r){n=Number(n)||0;var a=e.length-n;r?(r=Number(r),r>a&&(r=a)):r=a;var o=t.length;if(o%2!==0)throw new TypeError("Invalid hex string");r>o/2&&(r=o/2);for(var i=0;i<r;++i){var c=parseInt(t.substr(i*2,2),16);if(isNaN(c))return i;e[n+i]=c}return i}function xz(e,t,n,r){return cm(am(t,e.length-n),e,
n,r)}function $C(e,t,n,r){return cm(Bz(t),e,n,r)}function Sz(e,t,n,r){return $C(e,t,n,r)}function Cz(e,t,n,r){return cm(JC(t),e,n,r)}function kz(e,t,n,r){return cm(Uz(t,e.length-n),e,n,r)}function Fz(e,t,n){return t===0&&n===e.length?OC(e):OC(e.slice(t,n))}function YC(e,t,n){n=Math.min(e.length,n);for(var r=[],a=t;a<n;){var o=e[a],i=null,c=o>239?4:o>223?3:o>191?2:1;if(a+c<=n){var u,d,m,p;switch(c){case 1:o<128&&(i=o);break;case 2:u=e[a+1],(u&192)===128&&(p=(o&31)<<6|u&63,p>127&&(i=p));break;case 3:u=e[a+1],d=e[a+2],(u&192)===128&&(d&192)===128&&(p=(o&15)<<12|(u&63)<<6|d&63,p>2047&&(p<55296||p>57343)&&(i=p));break;case 4:u=e[a+1],d=e[a+2],m=e[a+3],(u&192)===128&&(d&192)===128&&(m&192)===128&&(p=(o&15)<<18|(u&63)<<12|(d&63)<<6|m&63,p>65535&&p<1114112&&(i=p))}}i===null?(i=65533,c=1):i>65535&&(i-=65536,r.push(i>>>10&1023|55296),i=56320|i&1023),r.push(i),a+=c}return Rz(r)}function Rz(e){var t=e.length;if(t<=UC)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.
apply(String,e.slice(r,r+=UC));return n}function Az(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]&127);return r}function _z(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]);return r}function Iz(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var a="",o=t;o<n;++o)a+=Oz(e[o]);return a}function Nz(e,t,n){for(var r=e.slice(t,n),a="",o=0;o<r.length;o+=2)a+=String.fromCharCode(r[o]+r[o+1]*256);return a}function Gt(e,t,n){if(e%1!==0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function Cn(e,t,n,r,a,o){if(!Dr(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<o)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function im(e,t,n,r){t<0&&(t=65535+t+1);for(var a=0,o=Math.min(e.length-n,2);a<o;++a)e[n+a]=(t&255<<8*(r?a:1-a))>>>(r?a:1-a)*
8}function sm(e,t,n,r){t<0&&(t=4294967295+t+1);for(var a=0,o=Math.min(e.length-n,4);a<o;++a)e[n+a]=t>>>(r?a:3-a)*8&255}function KC(e,t,n,r,a,o){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function XC(e,t,n,r,a){return a||KC(e,t,n,4),qC(e,t,n,r,23,4),n+4}function ZC(e,t,n,r,a){return a||KC(e,t,n,8),qC(e,t,n,r,52,8),n+8}function Pz(e){if(e=Lz(e).replace(Mz,""),e.length<2)return"";for(;e.length%4!==0;)e=e+"=";return e}function Lz(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function Oz(e){return e<16?"0"+e.toString(16):e.toString(16)}function am(e,t){t=t||1/0;for(var n,r=e.length,a=null,o=[],i=0;i<r;++i){if(n=e.charCodeAt(i),n>55295&&n<57344){if(!a){if(n>56319){(t-=3)>-1&&o.push(239,191,189);continue}else if(i+1===r){(t-=3)>-1&&o.push(239,191,189);continue}a=n;continue}if(n<56320){(t-=3)>-1&&o.push(239,191,189),a=n;continue}n=(a-55296<<10|n-56320)+65536}else a&&(t-=3)>-1&&o.push(239,191,189);if(a=null,n<128){if((t-=1)<
0)break;o.push(n)}else if(n<2048){if((t-=2)<0)break;o.push(n>>6|192,n&63|128)}else if(n<65536){if((t-=3)<0)break;o.push(n>>12|224,n>>6&63|128,n&63|128)}else if(n<1114112){if((t-=4)<0)break;o.push(n>>18|240,n>>12&63|128,n>>6&63|128,n&63|128)}else throw new Error("Invalid code point")}return o}function Bz(e){for(var t=[],n=0;n<e.length;++n)t.push(e.charCodeAt(n)&255);return t}function Uz(e,t){for(var n,r,a,o=[],i=0;i<e.length&&!((t-=2)<0);++i)n=e.charCodeAt(i),r=n>>8,a=n%256,o.push(a),o.push(r);return o}function JC(e){return pz(Pz(e))}function cm(e,t,n,r){for(var a=0;a<r&&!(a+n>=t.length||a>=e.length);++a)t[a+n]=e[a];return a}function jz(e){return e!==e}function qz(e){return e!=null&&(!!e._isBuffer||QC(e)||zz(e))}function QC(e){return!!e.constructor&&typeof e.constructor.isBuffer=="function"&&e.constructor.isBuffer(e)}function zz(e){return typeof e.readFloatLE=="function"&&typeof e.slice=="function"&&QC(e.slice(0,0))}var wr,Un,mz,s1,gz,zC,yz,l1e,UC,Mz,Ai=y(()=>{l();wr=[],Un=[],mz=typeof Uint8Array<
"u"?Uint8Array:Array,s1=!1;s(jC,"init");s(pz,"toByteArray");s(fz,"tripletToBase64");s(hz,"encodeChunk");s(OC,"fromByteArray");s(om,"read");s(qC,"write");gz={}.toString,zC=Array.isArray||function(e){return gz.call(e)=="[object Array]"};yz=50;z.TYPED_ARRAY_SUPPORT=globalThis.TYPED_ARRAY_SUPPORT!==void 0?globalThis.TYPED_ARRAY_SUPPORT:!0;l1e=rm();s(rm,"kMaxLength");s(Xr,"createBuffer");s(z,"Buffer");z.poolSize=8192;z._augment=function(e){return e.__proto__=z.prototype,e};s(HC,"from");z.from=function(e,t,n){return HC(null,e,t,n)};z.TYPED_ARRAY_SUPPORT&&(z.prototype.__proto__=Uint8Array.prototype,z.__proto__=Uint8Array,typeof Symbol<"u"&&Symbol.species&&z[Symbol.species]);s(WC,"assertSize");s(vz,"alloc");z.alloc=function(e,t,n){return vz(null,e,t,n)};s(c1,"allocUnsafe");z.allocUnsafe=function(e){return c1(null,e)};z.allocUnsafeSlow=function(e){return c1(null,e)};s(bz,"fromString");s(i1,"fromArrayLike");s(wz,"fromArrayBuffer");s(Dz,"fromObject");s(u1,"checked");z.isBuffer=qz;s(Dr,"internalIs\
Buffer");z.compare=s(function(t,n){if(!Dr(t)||!Dr(n))throw new TypeError("Arguments must be Buffers");if(t===n)return 0;for(var r=t.length,a=n.length,o=0,i=Math.min(r,a);o<i;++o)if(t[o]!==n[o]){r=t[o],a=n[o];break}return r<a?-1:a<r?1:0},"compare");z.isEncoding=s(function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},"isEncoding");z.concat=s(function(t,n){if(!zC(t))throw new TypeError('"list" argument must be an Array of Buffers');if(t.length===0)return z.alloc(0);var r;if(n===void 0)for(n=0,r=0;r<t.length;++r)n+=t[r].length;var a=z.allocUnsafe(n),o=0;for(r=0;r<t.length;++r){var i=t[r];if(!Dr(i))throw new TypeError('"list" argument must be an Array of Buffers');i.copy(a,o),o+=i.length}return a},"concat");s(GC,"byteLength");z.byteLength=GC;s(Ez,"slowToString");z.prototype._isBuffer=!0;s(Co,"swap");z.prototype.swap16=s(function(){var t=this.
length;if(t%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var n=0;n<t;n+=2)Co(this,n,n+1);return this},"swap16");z.prototype.swap32=s(function(){var t=this.length;if(t%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var n=0;n<t;n+=4)Co(this,n,n+3),Co(this,n+1,n+2);return this},"swap32");z.prototype.swap64=s(function(){var t=this.length;if(t%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var n=0;n<t;n+=8)Co(this,n,n+7),Co(this,n+1,n+6),Co(this,n+2,n+5),Co(this,n+3,n+4);return this},"swap64");z.prototype.toString=s(function(){var t=this.length|0;return t===0?"":arguments.length===0?YC(this,0,t):Ez.apply(this,arguments)},"toString");z.prototype.equals=s(function(t){if(!Dr(t))throw new TypeError("Argument must be a Buffer");return this===t?!0:z.compare(this,t)===0},"equals");z.prototype.inspect=s(function(){var t="",n=yz;return this.length>0&&(t=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>
n&&(t+=" ... ")),"<Buffer "+t+">"},"inspect");z.prototype.compare=s(function(t,n,r,a,o){if(!Dr(t))throw new TypeError("Argument must be a Buffer");if(n===void 0&&(n=0),r===void 0&&(r=t?t.length:0),a===void 0&&(a=0),o===void 0&&(o=this.length),n<0||r>t.length||a<0||o>this.length)throw new RangeError("out of range index");if(a>=o&&n>=r)return 0;if(a>=o)return-1;if(n>=r)return 1;if(n>>>=0,r>>>=0,a>>>=0,o>>>=0,this===t)return 0;for(var i=o-a,c=r-n,u=Math.min(i,c),d=this.slice(a,o),m=t.slice(n,r),p=0;p<u;++p)if(d[p]!==m[p]){i=d[p],c=m[p];break}return i<c?-1:c<i?1:0},"compare");s(VC,"bidirectionalIndexOf");s(BC,"arrayIndexOf");z.prototype.includes=s(function(t,n,r){return this.indexOf(t,n,r)!==-1},"includes");z.prototype.indexOf=s(function(t,n,r){return VC(this,t,n,r,!0)},"indexOf");z.prototype.lastIndexOf=s(function(t,n,r){return VC(this,t,n,r,!1)},"lastIndexOf");s(Tz,"hexWrite");s(xz,"utf8Write");s($C,"asciiWrite");s(Sz,"latin1Write");s(Cz,"base64Write");s(kz,"ucs2Write");z.prototype.write=
s(function(t,n,r,a){if(n===void 0)a="utf8",r=this.length,n=0;else if(r===void 0&&typeof n=="string")a=n,r=this.length,n=0;else if(isFinite(n))n=n|0,isFinite(r)?(r=r|0,a===void 0&&(a="utf8")):(a=r,r=void 0);else throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");var o=this.length-n;if((r===void 0||r>o)&&(r=o),t.length>0&&(r<0||n<0)||n>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var i=!1;;)switch(a){case"hex":return Tz(this,t,n,r);case"utf8":case"utf-8":return xz(this,t,n,r);case"ascii":return $C(this,t,n,r);case"latin1":case"binary":return Sz(this,t,n,r);case"base64":return Cz(this,t,n,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return kz(this,t,n,r);default:if(i)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),i=!0}},"write");z.prototype.toJSON=s(function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},"toJSON");s(Fz,"base64Slice");s(YC,"utf8\
Slice");UC=4096;s(Rz,"decodeCodePointsArray");s(Az,"asciiSlice");s(_z,"latin1Slice");s(Iz,"hexSlice");s(Nz,"utf16leSlice");z.prototype.slice=s(function(t,n){var r=this.length;t=~~t,n=n===void 0?r:~~n,t<0?(t+=r,t<0&&(t=0)):t>r&&(t=r),n<0?(n+=r,n<0&&(n=0)):n>r&&(n=r),n<t&&(n=t);var a;if(z.TYPED_ARRAY_SUPPORT)a=this.subarray(t,n),a.__proto__=z.prototype;else{var o=n-t;a=new z(o,void 0);for(var i=0;i<o;++i)a[i]=this[i+t]}return a},"slice");s(Gt,"checkOffset");z.prototype.readUIntLE=s(function(t,n,r){t=t|0,n=n|0,r||Gt(t,n,this.length);for(var a=this[t],o=1,i=0;++i<n&&(o*=256);)a+=this[t+i]*o;return a},"readUIntLE");z.prototype.readUIntBE=s(function(t,n,r){t=t|0,n=n|0,r||Gt(t,n,this.length);for(var a=this[t+--n],o=1;n>0&&(o*=256);)a+=this[t+--n]*o;return a},"readUIntBE");z.prototype.readUInt8=s(function(t,n){return n||Gt(t,1,this.length),this[t]},"readUInt8");z.prototype.readUInt16LE=s(function(t,n){return n||Gt(t,2,this.length),this[t]|this[t+1]<<8},"readUInt16LE");z.prototype.readUInt16BE=
s(function(t,n){return n||Gt(t,2,this.length),this[t]<<8|this[t+1]},"readUInt16BE");z.prototype.readUInt32LE=s(function(t,n){return n||Gt(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+this[t+3]*16777216},"readUInt32LE");z.prototype.readUInt32BE=s(function(t,n){return n||Gt(t,4,this.length),this[t]*16777216+(this[t+1]<<16|this[t+2]<<8|this[t+3])},"readUInt32BE");z.prototype.readIntLE=s(function(t,n,r){t=t|0,n=n|0,r||Gt(t,n,this.length);for(var a=this[t],o=1,i=0;++i<n&&(o*=256);)a+=this[t+i]*o;return o*=128,a>=o&&(a-=Math.pow(2,8*n)),a},"readIntLE");z.prototype.readIntBE=s(function(t,n,r){t=t|0,n=n|0,r||Gt(t,n,this.length);for(var a=n,o=1,i=this[t+--a];a>0&&(o*=256);)i+=this[t+--a]*o;return o*=128,i>=o&&(i-=Math.pow(2,8*n)),i},"readIntBE");z.prototype.readInt8=s(function(t,n){return n||Gt(t,1,this.length),this[t]&128?(255-this[t]+1)*-1:this[t]},"readInt8");z.prototype.readInt16LE=s(function(t,n){n||Gt(t,2,this.length);var r=this[t]|this[t+1]<<8;return r&32768?r|4294901760:r},"rea\
dInt16LE");z.prototype.readInt16BE=s(function(t,n){n||Gt(t,2,this.length);var r=this[t+1]|this[t]<<8;return r&32768?r|4294901760:r},"readInt16BE");z.prototype.readInt32LE=s(function(t,n){return n||Gt(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},"readInt32LE");z.prototype.readInt32BE=s(function(t,n){return n||Gt(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},"readInt32BE");z.prototype.readFloatLE=s(function(t,n){return n||Gt(t,4,this.length),om(this,t,!0,23,4)},"readFloatLE");z.prototype.readFloatBE=s(function(t,n){return n||Gt(t,4,this.length),om(this,t,!1,23,4)},"readFloatBE");z.prototype.readDoubleLE=s(function(t,n){return n||Gt(t,8,this.length),om(this,t,!0,52,8)},"readDoubleLE");z.prototype.readDoubleBE=s(function(t,n){return n||Gt(t,8,this.length),om(this,t,!1,52,8)},"readDoubleBE");s(Cn,"checkInt");z.prototype.writeUIntLE=s(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*r)-1;Cn(this,t,n,r,o,0)}var i=1,c=0;for(this[n]=t&255;++c<
r&&(i*=256);)this[n+c]=t/i&255;return n+r},"writeUIntLE");z.prototype.writeUIntBE=s(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*r)-1;Cn(this,t,n,r,o,0)}var i=r-1,c=1;for(this[n+i]=t&255;--i>=0&&(c*=256);)this[n+i]=t/c&255;return n+r},"writeUIntBE");z.prototype.writeUInt8=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,1,255,0),z.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[n]=t&255,n+1},"writeUInt8");s(im,"objectWriteUInt16");z.prototype.writeUInt16LE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,2,65535,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):im(this,t,n,!0),n+2},"writeUInt16LE");z.prototype.writeUInt16BE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,2,65535,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):im(this,t,n,!1),n+2},"writeUInt16BE");s(sm,"objectWriteUInt32");z.prototype.writeUInt32LE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,4,4294967295,0),z.TYPED_ARRAY_SUPPORT?(this[n+3]=t>>>24,this[n+2]=t>>>16,this[n+1]=t>>>8,
this[n]=t&255):sm(this,t,n,!0),n+4},"writeUInt32LE");z.prototype.writeUInt32BE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,4,4294967295,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):sm(this,t,n,!1),n+4},"writeUInt32BE");z.prototype.writeIntLE=s(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Cn(this,t,n,r,o-1,-o)}var i=0,c=1,u=0;for(this[n]=t&255;++i<r&&(c*=256);)t<0&&u===0&&this[n+i-1]!==0&&(u=1),this[n+i]=(t/c>>0)-u&255;return n+r},"writeIntLE");z.prototype.writeIntBE=s(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Cn(this,t,n,r,o-1,-o)}var i=r-1,c=1,u=0;for(this[n+i]=t&255;--i>=0&&(c*=256);)t<0&&u===0&&this[n+i+1]!==0&&(u=1),this[n+i]=(t/c>>0)-u&255;return n+r},"writeIntBE");z.prototype.writeInt8=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,1,127,-128),z.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[n]=t&255,n+1},"writeInt8");z.prototype.writeInt16LE=s(function(t,n,r){return t=+t,n=n|0,
r||Cn(this,t,n,2,32767,-32768),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):im(this,t,n,!0),n+2},"writeInt16LE");z.prototype.writeInt16BE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,2,32767,-32768),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):im(this,t,n,!1),n+2},"writeInt16BE");z.prototype.writeInt32LE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,4,2147483647,-2147483648),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8,this[n+2]=t>>>16,this[n+3]=t>>>24):sm(this,t,n,!0),n+4},"writeInt32LE");z.prototype.writeInt32BE=s(function(t,n,r){return t=+t,n=n|0,r||Cn(this,t,n,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):sm(this,t,n,!1),n+4},"writeInt32BE");s(KC,"checkIEEE754");s(XC,"writeFloat");z.prototype.writeFloatLE=s(function(t,n,r){return XC(this,t,n,!0,r)},"writeFloatLE");z.prototype.writeFloatBE=s(function(t,n,r){return XC(this,t,n,!1,r)},"writeFloatBE");s(ZC,"w\
riteDouble");z.prototype.writeDoubleLE=s(function(t,n,r){return ZC(this,t,n,!0,r)},"writeDoubleLE");z.prototype.writeDoubleBE=s(function(t,n,r){return ZC(this,t,n,!1,r)},"writeDoubleBE");z.prototype.copy=s(function(t,n,r,a){if(r||(r=0),!a&&a!==0&&(a=this.length),n>=t.length&&(n=t.length),n||(n=0),a>0&&a<r&&(a=r),a===r||t.length===0||this.length===0)return 0;if(n<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-n<a-r&&(a=t.length-n+r);var o=a-r,i;if(this===t&&r<n&&n<a)for(i=o-1;i>=0;--i)t[i+n]=this[i+r];else if(o<1e3||!z.TYPED_ARRAY_SUPPORT)for(i=0;i<o;++i)t[i+n]=this[i+r];else Uint8Array.prototype.set.call(t,this.subarray(r,r+o),n);return o},"copy");z.prototype.fill=s(function(t,n,r,a){if(typeof t=="string"){if(typeof n=="string"?(a=n,n=0,r=this.length):typeof r=="string"&&(a=r,r=this.length),t.length===1){var o=t.charCodeAt(
0);o<256&&(t=o)}if(a!==void 0&&typeof a!="string")throw new TypeError("encoding must be a string");if(typeof a=="string"&&!z.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else typeof t=="number"&&(t=t&255);if(n<0||this.length<n||this.length<r)throw new RangeError("Out of range index");if(r<=n)return this;n=n>>>0,r=r===void 0?this.length:r>>>0,t||(t=0);var i;if(typeof t=="number")for(i=n;i<r;++i)this[i]=t;else{var c=Dr(t)?t:am(new z(t,a).toString()),u=c.length;for(i=0;i<r-n;++i)this[i+n]=c[i%u]}return this},"fill");Mz=/[^+\/0-9A-Za-z-_]/g;s(Pz,"base64clean");s(Lz,"stringtrim");s(Oz,"toHex");s(am,"utf8ToBytes");s(Bz,"asciiToBytes");s(Uz,"utf16leToBytes");s(JC,"base64ToBytes");s(cm,"blitBuffer");s(jz,"isnan");s(qz,"isBuffer");s(QC,"isFastBuffer");s(zz,"isSlowBuffer")});function Fa(){}function We(){We.init.call(this)}function ek(e){return e._maxListeners===void 0?We.defaultMaxListeners:e._maxListeners}function Hz(e,t,n){if(t)e.call(n);else for(var r=e.length,a=Ac(e,r),o=0;o<r;++o)a[o].call(n)}function Wz(e,t,n,r){if(t)e.call(n,r);else for(var a=e.length,o=Ac(e,a),i=0;i<a;++i)o[i].call(n,r)}function Gz(e,t,n,r,a){if(t)e.call(n,r,a);else for(var o=e.length,i=Ac(e,o),c=0;c<o;++c)i[c].call(n,r,a)}function Vz(e,t,n,r,a,o){if(t)e.call(n,r,a,o);else for(var i=e.length,c=Ac(e,i),u=0;u<i;++u)c[u].call(n,r,a,o)}function $z(e,t,n,r){if(t)e.apply(n,r);else for(var a=e.length,o=Ac(e,a),i=0;i<a;++i)o[i].apply(n,r)}function tk(e,t,n,r){var a,o,i;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(o=e._events,o?(o.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),o=e._events),i=o[t]):(o=e._events=new Fa,e._eventsCount=0),!i)i=o[t]=n,++e._eventsCount;else if(typeof i=="function"?i=o[t]=r?[n,i]:[i,n]:r?i.unshift(n):i.push(
n),!i.warned&&(a=ek(e),a&&a>0&&i.length>a)){i.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+i.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=i.length,Yz(c)}return e}function Yz(e){typeof console.warn=="function"?console.warn(e):console.log(e)}function nk(e,t,n){var r=!1;function a(){e.removeListener(t,a),r||(r=!0,n.apply(e,arguments))}return s(a,"g"),a.listener=n,a}function rk(e){var t=this._events;if(t){var n=t[e];if(typeof n=="function")return 1;if(n)return n.length}return 0}function Kz(e,t){for(var n=t,r=n+1,a=e.length;r<a;n+=1,r+=1)e[n]=e[r];e.pop()}function Ac(e,t){for(var n=new Array(t);t--;)n[t]=e[t];return n}function Xz(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}var l1,jn,Zr=y(()=>{"use strict";l();s(Fa,"EventHandlers");Fa.prototype=Object.create(null);s(We,"EventEmitter");jn=We;We.EventEmitter=We;We.usingDomains=
!1;We.prototype.domain=void 0;We.prototype._events=void 0;We.prototype._maxListeners=void 0;We.defaultMaxListeners=10;We.init=function(){this.domain=null,We.usingDomains&&l1.active&&!(this instanceof l1.Domain)&&(this.domain=l1.active),(!this._events||this._events===Object.getPrototypeOf(this)._events)&&(this._events=new Fa,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0};We.prototype.setMaxListeners=s(function(t){if(typeof t!="number"||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},"setMaxListeners");s(ek,"$getMaxListeners");We.prototype.getMaxListeners=s(function(){return ek(this)},"getMaxListeners");s(Hz,"emitNone");s(Wz,"emitOne");s(Gz,"emitTwo");s(Vz,"emitThree");s($z,"emitMany");We.prototype.emit=s(function(t){var n,r,a,o,i,c,u,d=!1,m=t==="error";if(c=this._events,c)m=m&&c.error==null;else if(!m)return!1;if(u=this.domain,m){if(n=arguments[1],u)n||(n=new Error('Uncaught, unspecified "error" event')),
n.domainEmitter=this,n.domain=u,n.domainThrown=!1,u.emit("error",n);else{if(n instanceof Error)throw n;var p=new Error('Uncaught, unspecified "error" event. ('+n+")");throw p.context=n,p}return!1}if(r=c[t],!r)return!1;var h=typeof r=="function";switch(a=arguments.length,a){case 1:Hz(r,h,this);break;case 2:Wz(r,h,this,arguments[1]);break;case 3:Gz(r,h,this,arguments[1],arguments[2]);break;case 4:Vz(r,h,this,arguments[1],arguments[2],arguments[3]);break;default:for(o=new Array(a-1),i=1;i<a;i++)o[i-1]=arguments[i];$z(r,h,this,o)}return d&&u.exit(),!0},"emit");s(tk,"_addListener");s(Yz,"emitWarning");We.prototype.addListener=s(function(t,n){return tk(this,t,n,!1)},"addListener");We.prototype.on=We.prototype.addListener;We.prototype.prependListener=s(function(t,n){return tk(this,t,n,!0)},"prependListener");s(nk,"_onceWrap");We.prototype.once=s(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.on(t,nk(this,t,n)),this},"once");We.prototype.
prependOnceListener=s(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.prependListener(t,nk(this,t,n)),this},"prependOnceListener");We.prototype.removeListener=s(function(t,n){var r,a,o,i,c;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(a=this._events,!a)return this;if(r=a[t],!r)return this;if(r===n||r.listener&&r.listener===n)--this._eventsCount===0?this._events=new Fa:(delete a[t],a.removeListener&&this.emit("removeListener",t,r.listener||n));else if(typeof r!="function"){for(o=-1,i=r.length;i-- >0;)if(r[i]===n||r[i].listener&&r[i].listener===n){c=r[i].listener,o=i;break}if(o<0)return this;if(r.length===1){if(r[0]=void 0,--this._eventsCount===0)return this._events=new Fa,this;delete a[t]}else Kz(r,o);a.removeListener&&this.emit("removeListener",t,c||n)}return this},"removeListener");We.prototype.off=function(e,t){return this.removeListener(e,t)};We.prototype.removeAllListeners=s(function(t){
var n,r;if(r=this._events,!r)return this;if(!r.removeListener)return arguments.length===0?(this._events=new Fa,this._eventsCount=0):r[t]&&(--this._eventsCount===0?this._events=new Fa:delete r[t]),this;if(arguments.length===0){for(var a=Object.keys(r),o=0,i;o<a.length;++o)i=a[o],i!=="removeListener"&&this.removeAllListeners(i);return this.removeAllListeners("removeListener"),this._events=new Fa,this._eventsCount=0,this}if(n=r[t],typeof n=="function")this.removeListener(t,n);else if(n)do this.removeListener(t,n[n.length-1]);while(n[0]);return this},"removeAllListeners");We.prototype.listeners=s(function(t){var n,r,a=this._events;return a?(n=a[t],n?typeof n=="function"?r=[n.listener||n]:r=Xz(n):r=[]):r=[],r},"listeners");We.listenerCount=function(e,t){return typeof e.listenerCount=="function"?e.listenerCount(t):rk.call(e,t)};We.prototype.listenerCount=rk;s(rk,"listenerCount");We.prototype.eventNames=s(function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]},"eventNames");s(
Kz,"spliceOne");s(Ac,"arrayClone");s(Xz,"unwrapListeners")});var ok=P((y1e,ak)=>{l();var _i=1e3,Ii=_i*60,Ni=Ii*60,ko=Ni*24,Zz=ko*7,Jz=ko*365.25;ak.exports=function(e,t){t=t||{};var n=typeof e;if(n==="string"&&e.length>0)return Qz(e);if(n==="number"&&isFinite(e))return t.long?tH(e):eH(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function Qz(e){if(e=String(e),!(e.length>100)){var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(t){var n=parseFloat(t[1]),r=(t[2]||"ms").toLowerCase();switch(r){case"years":case"year":case"yrs":case"yr":case"y":return n*Jz;case"weeks":case"week":case"w":return n*Zz;case"days":case"day":case"d":return n*ko;case"hours":case"hour":case"hrs":case"hr":case"h":return n*Ni;case"minutes":case"minute":case"mins":case"min":case"m":return n*Ii;case"seconds":case"second":case"secs":case"sec":case"s":return n*_i;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:
return}}}}s(Qz,"parse");function eH(e){var t=Math.abs(e);return t>=ko?Math.round(e/ko)+"d":t>=Ni?Math.round(e/Ni)+"h":t>=Ii?Math.round(e/Ii)+"m":t>=_i?Math.round(e/_i)+"s":e+"ms"}s(eH,"fmtShort");function tH(e){var t=Math.abs(e);return t>=ko?um(e,t,ko,"day"):t>=Ni?um(e,t,Ni,"hour"):t>=Ii?um(e,t,Ii,"minute"):t>=_i?um(e,t,_i,"second"):e+" ms"}s(tH,"fmtLong");function um(e,t,n,r){var a=t>=n*1.5;return Math.round(e/n)+" "+r+(a?"s":"")}s(um,"plural")});var sk=P((w1e,ik)=>{l();function nH(e){n.debug=n,n.default=n,n.coerce=u,n.disable=o,n.enable=a,n.enabled=i,n.humanize=ok(),n.destroy=d,Object.keys(e).forEach(m=>{n[m]=e[m]}),n.names=[],n.skips=[],n.formatters={};function t(m){let p=0;for(let h=0;h<m.length;h++)p=(p<<5)-p+m.charCodeAt(h),p|=0;return n.colors[Math.abs(p)%n.colors.length]}s(t,"selectColor"),n.selectColor=t;function n(m){let p,h=null,f,g;function v(...w){if(!v.enabled)return;let E=v,T=Number(new Date),S=T-(p||T);E.diff=S,E.prev=p,E.curr=T,p=T,w[0]=n.coerce(w[0]),typeof w[0]!="string"&&w.unshift("%O");let C=0;w[0]=w[0].replace(/%([a-zA-Z%])/g,(L,M)=>{if(L==="%%")return"%";C++;let W=n.formatters[M];if(typeof W=="function"){let te=w[C];L=W.call(E,te),w.splice(C,1),C--}return L}),n.formatArgs.call(E,w),(E.log||n.log).apply(E,w)}return s(v,"debug"),v.namespace=m,v.useColors=n.useColors(),v.color=n.selectColor(m),v.extend=r,v.destroy=n.destroy,Object.defineProperty(v,"enabled",{enumerable:!0,configurable:!1,get:()=>h!==null?h:(f!==
n.namespaces&&(f=n.namespaces,g=n.enabled(m)),g),set:w=>{h=w}}),typeof n.init=="function"&&n.init(v),v}s(n,"createDebug");function r(m,p){let h=n(this.namespace+(typeof p>"u"?":":p)+m);return h.log=this.log,h}s(r,"extend");function a(m){n.save(m),n.namespaces=m,n.names=[],n.skips=[];let p,h=(typeof m=="string"?m:"").split(/[\s,]+/),f=h.length;for(p=0;p<f;p++)h[p]&&(m=h[p].replace(/\*/g,".*?"),m[0]==="-"?n.skips.push(new RegExp("^"+m.slice(1)+"$")):n.names.push(new RegExp("^"+m+"$")))}s(a,"enable");function o(){let m=[...n.names.map(c),...n.skips.map(c).map(p=>"-"+p)].join(",");return n.enable(""),m}s(o,"disable");function i(m){if(m[m.length-1]==="*")return!0;let p,h;for(p=0,h=n.skips.length;p<h;p++)if(n.skips[p].test(m))return!1;for(p=0,h=n.names.length;p<h;p++)if(n.names[p].test(m))return!0;return!1}s(i,"enabled");function c(m){return m.toString().substring(2,m.toString().length-2).replace(/\.\*\?$/,"*")}s(c,"toNamespace");function u(m){return m instanceof Error?m.stack||m.message:m}s(
u,"coerce");function d(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return s(d,"destroy"),n.enable(n.load()),n}s(nH,"setup");ik.exports=nH});var ck=P((Mn,lm)=>{l();Mn.formatArgs=aH;Mn.save=oH;Mn.load=iH;Mn.useColors=rH;Mn.storage=sH();Mn.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})();Mn.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#F\
F33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function rH(){return typeof window<"u"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)?!0:typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)?!1:typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}s(rH,"useColors");function aH(e){if(e[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+e[0]+(this.useColors?"%c ":" ")+"+"+lm.exports.humanize(this.diff),!this.useColors)return;let t="color: "+this.color;e.splice(
1,0,t,"color: inherit");let n=0,r=0;e[0].replace(/%[a-zA-Z%]/g,a=>{a!=="%%"&&(n++,a==="%c"&&(r=n))}),e.splice(r,0,t)}s(aH,"formatArgs");Mn.log=console.debug||console.log||(()=>{});function oH(e){try{e?Mn.storage.setItem("debug",e):Mn.storage.removeItem("debug")}catch{}}s(oH,"save");function iH(){let e;try{e=Mn.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}s(iH,"load");function sH(){try{return localStorage}catch{}}s(sH,"localstorage");lm.exports=sk()(Mn);var{formatters:cH}=lm.exports;cH.j=function(e){try{return JSON.stringify(e)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}});function dm(e){if(!e)throw new Error("name must be non-empty")}function uH(e,t){for(var n=0,r=e.length,a;n<r;)a=n+r>>>1,e[a].startTime<t.startTime?n=a+1:r=a;e.splice(n,0,t)}var vn,uk,fm,hm,_c,gm,mm,pm,lk=y(()=>{l();vn=typeof performance<"u"&&performance,uk=vn&&vn.now?function(){return vn.now()}:function(){return Date.now()};s(dm,"throwIfEmpty");s(uH,"insertSorted");vn&&vn.mark&&vn.getEntriesByName&&vn.getEntriesByType&&vn.clearMeasures?(fm=s(function(e){dm(e),vn.mark("start "+e)},"mark"),hm=s(function(e){dm(e),vn.mark("end "+e),vn.measure(e,"start "+e,"end "+e);var t=vn.getEntriesByName(e);return t[t.length-1]},"stop"),_c=s(function(){return vn.getEntriesByType("measure")},"getEntries"),gm=s(function(){vn.clearMarks(),vn.clearMeasures()},"clear")):(mm={},pm=[],fm=s(function(e){dm(e);var t=uk();mm["$"+e]=t},"mark"),hm=s(function(e){dm(e);var t=uk(),n=mm["$"+e];if(!n)throw new Error("no known mark: "+e);var r={startTime:n,name:e,duration:t-n,entryType:"measure"};return uH(pm,r),r},"stop"),
_c=s(function(){return pm},"getEntries"),gm=s(function(){mm={},pm=[]},"clear"))});var Aa,Ra,Mi,Pi,d1,dk,dH,mk,Li,N,Ae=y(()=>{l();ka();Zr();Aa=Bt(ck());lk();Ra=an.platform==="win32",Mi=an.browser,Pi={red:Mi?"crimson":1,yellow:Mi?"gold":3,cyan:Mi?"darkturquoise":6,green:Mi?"forestgreen":2,blue:Mi?"steelblue":4,magenta:Mi?"palevioletred":5};Aa.default.colors=[Pi.cyan,Pi.green,Pi.blue,Pi.magenta];d1=class extends We{static{s(this,"Emitter")}issueStatus(t,n){(t==="status"||t==="statusEnd")&&this.emit(t,[t,...n])}issueWarning(t,n){this.emit("warning",[t,...n])}},dk={},dH=25,Li=class e{static{s(this,"Log")}static _logToStdErr(t,n){e.loggerfn(t)(...n)}static loggerfn(t){t=`LH:${t}`;let n=dk[t];return n||(n=(0,Aa.default)(t),dk[t]=n,t.endsWith("error")?n.color=Pi.red:t.endsWith("warn")&&(n.color=Pi.yellow)),n}static setLevel(t){switch(mk=t,t){case"silent":Aa.default.enable("-LH:*");break;case"verbose":Aa.default.enable("LH:*");break;case"warn":Aa.default.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":Aa.default.enable("-LH:*, LH:*:error");break;default:Aa.default.enable(
"LH:*, -LH:*:verbose")}}static formatProtocol(t,n,r){let a=!an||an.browser?1/0:an.stdout.columns,o=n.method||"?????",i=a-o.length-t.length-dH,c=n.params&&o!=="IO.read"?JSON.stringify(n.params).substr(0,i):"";e._logToStdErr(`${t}:${r||""}`,[o,c])}static isVerbose(){return mk==="verbose"}static time({msg:t,id:n,args:r=[]},a="log"){fm(n),e[a]("status",t,...r)}static timeEnd({msg:t,id:n,args:r=[]},a="verbose"){e[a]("statusEnd",t,...r),hm(n)}static log(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(t,n)}static warn(t,...n){return e.events.issueWarning(t,n),e._logToStdErr(`${t}:warn`,n)}static error(t,...n){return e._logToStdErr(`${t}:error`,n)}static verbose(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(`${t}:verbose`,n)}static greenify(t){return`${e.green}${t}${e.reset}`}static redify(t){return`${e.red}${t}${e.reset}`}static get green(){return"\x1B[32m"}static get red(){return"\x1B[31m"}static get yellow(){return"\x1B[33m"}static get purple(){return"\x1B[95m"}static get reset(){
return"\x1B[0m"}static get bold(){return"\x1B[1m"}static get dim(){return"\x1B[2m"}static get tick(){return Ra?"√":"✓"}static get cross(){return Ra?"×":"✘"}static get whiteSmallSquare(){return Ra?"·":"▫"}static get heavyHorizontal(){return Ra?"─":"━"}static get heavyVertical(){return Ra?"│ ":"┃ "}static get heavyUpAndRight(){return Ra?"└":"┗"}static get heavyVerticalAndRight(){return Ra?"├":"┣"}static get heavyDownAndHorizontal(){return Ra?"┬":"┳"}static get doubleLightHorizontal(){return"──"}};Li.events=new d1;Li.takeTimeEntries=()=>{let e=_c();return gm(),e};Li.getTimeEntries=()=>_c();N=Li});var on=y(()=>{"use strict";l();});var m1,J,Ye=y(()=>{"use strict";l();on();m1=class{static{s(this,"BaseGatherer")}meta={supportedModes:[]};startInstrumentation(t){}startSensitiveInstrumentation(t){}stopSensitiveInstrumentation(t){}stopInstrumentation(t){}getArtifact(t){}},J=m1});var mH,pH,fH,hH,gH,yH,Jt,Jr=y(()=>{"use strict";l();Ae();mH=/^(chrome|https?):/,pH=16,fH="RunTask",hH="ThreadControllerImpl::RunTask",gH="ThreadControllerImpl::DoWork",yH="TaskQueueManager::ProcessTaskFromWorkQueue",Jt=class e{static{s(this,"TraceProcessor")}static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(t){return t.name!=="navigationStart"?!1:t.args.data?.documentLoaderURL===void 0?!0:t.args.data?.documentLoaderURL?mH.test(t.args.data.documentLoaderURL):!1}static _sortTimestampEventGroup(t,n,r,a){
let o=s(p=>n[p],"lookupArrayIndexByTsIndex"),i=s(p=>a[o(p)],"lookupEventByTsIndex"),c=[],u=[],d=[];for(let p of t){let h=o(p),f=i(p);f.ph==="E"?c.push(h):f.ph==="X"||f.ph==="B"?u.push(h):d.push(h)}let m=new Map;for(let p of u){let h=a[p];if(h.ph==="X")m.set(p,h.dur);else{let f=Number.MAX_SAFE_INTEGER,g=0,v=r+t.length;for(let w=v;w<n.length;w++){let E=i(w);if(E.name===h.name&&E.pid===h.pid&&E.tid===h.tid)if(E.ph==="E"&&g===0){f=E.ts-h.ts;break}else E.ph==="E"?g--:E.ph==="B"&&g++}m.set(p,f)}}return u.sort((p,h)=>(m.get(h)||0)-(m.get(p)||0)||p-h),d.sort((p,h)=>p-h),[...c,...u,...d]}static filteredTraceSort(t,n){let r=[];for(let o=0;o<t.length;o++)n(t[o])&&r.push(o);r.sort((o,i)=>t[o].ts-t[i].ts);for(let o=0;o<r.length-1;o++){let i=t[r[o]].ts,c=[o];for(let d=o+1;d<r.length&&t[r[d]].ts===i;d++)c.push(d);if(c.length===1)continue;let u=e._sortTimestampEventGroup(c,r,o,t);r.splice(o,u.length,...u),o+=c.length-1}let a=[];for(let o=0;o<r.length;o++)a.push(t[r[o]]);return a}static assertHasToplevelEvents(t){
if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(t,n,r,a=0){let o=0;for(let h=0;h<t.length;h++)o+=t[h];o-=a;let i=n-o,c=0,u=i,d=[],m=-1,p=t.length+1;a>0&&p--;for(let h of r){let f=h*n;for(;u<f&&m<t.length-1;)i+=c,p-=c<0?-1:1,a>0&&a<t[m+1]?(c=-a,a=0):(m++,c=t[m]),u=i+Math.abs(c)*p;d.push({percentile:h,time:Math.max(0,(f-i)/p)+pH})}return d}static getRiskToResponsiveness(t,n,r,a=[.5,.75,.9,.99,1]){let o=r-n;a.sort((c,u)=>c-u);let i=this.getMainThreadTopLevelEventDurations(t,n,r);return this._riskPercentiles(i.durations,o,a,i.clippedLength)}static getMainThreadTopLevelEventDurations(t,n=0,r=1/0){let a=[],o=0;for(let i of t){if(i.end<n||i.start>r)continue;let c=i.duration,u=i.start;u<n&&(u=n,c=i.end-n),i.end>r&&(o=c-(r-u)),a.push(c)}return a.sort((i,c)=>i-c),{durations:a,clippedLength:o}}static getMainThreadTopLevelEvents(t,n=0,r=1/0){let a=[],o;for(let i of t.mainThreadEvents){if(!this.isScheduleableTask(i)||!i.dur)continue;
let c=(i.ts-t.timeOriginEvt.ts)/1e3,u=(i.ts+i.dur-t.timeOriginEvt.ts)/1e3;c>r||u<n||(o&&c<o.end&&(o.end=c-.001),o={start:c,end:u,duration:i.dur/1e3},a.push(o))}return a}static findMainFrameIds(t){let n=t.find(i=>i.name==="TracingStartedInBrowser");if(n?.args.data?.frames){let i=n.args.data.frames.find(d=>!d.parent),c=i?.frame,u=i?.processId;if(u&&c)return{startingPid:u,frameId:c}}let r=t.find(i=>i.name==="TracingStartedInPage");if(r?.args?.data){let i=r.args.data.page;if(i)return{startingPid:r.pid,frameId:i}}let a=t.find(i=>this._isNavigationStartOfInterest(i)&&i.args.data?.isLoadingMainFrame),o=t.find(i=>i.name==="ResourceSendRequest");if(a?.args?.data&&o&&o.pid===a.pid&&o.tid===a.tid){let i=a.args.frame;if(i)return{startingPid:a.pid,frameId:i}}throw this.createNoTracingStartedError()}static findMainFramePidTids(t,n){let r=n.filter(i=>(i.name==="FrameCommittedInBrowser"||i.name==="ProcessReadyInBrowser")&&i.args?.data?.frame===t.frameId&&i?.args?.data?.processId),a=r.length?r.map(i=>i?.
args?.data?.processId):[t.startingPid],o=new Map;for(let i of new Set(a)){let c=n.filter(m=>m.cat==="__metadata"&&m.pid===i&&m.ph==="M"&&m.name==="thread_name"),u=c.find(m=>m.args.name==="CrRendererMain");u||(u=c.find(m=>m.args.name==="CrBrowserMain"));let d=u?.tid;if(!d)throw new Error("Unable to determine tid for renderer process");o.set(i,d)}return o}static isScheduleableTask(t){return t.name===fH||t.name===hH||t.name===gH||t.name===yH}static isLCPEvent(t){return t.name!=="largestContentfulPaint::Invalidate"&&t.name!=="largestContentfulPaint::Candidate"?!1:!!t.args?.frame}static isLCPCandidateEvent(t){return!!(t.name==="largestContentfulPaint::Candidate"&&t.args?.frame&&t.args.data&&t.args.data.size!==void 0)}static getFrameId(t){return t.args?.data?.frame||t.args.data?.frameID||t.args.frame}static computeValidLCPAllFrames(t,n){let r=t.filter(this.isLCPEvent).reverse(),a=new Map;for(let i of r){if(i.ts<=n.ts)break;let c=i.args.frame;a.has(c)||a.set(c,i)}let o;for(let i of a.values())
this.isLCPCandidateEvent(i)&&(!o||i.args.data.size>o.args.data.size)&&(o=i);return{lcp:o,invalidated:!!(!o&&a.size)}}static resolveRootFrames(t){let n=new Map;for(let a of t)a.parent&&n.set(a.id,a.parent);let r=new Map;for(let a of t){let o=a.id;for(;n.has(o);)o=n.get(o);if(o===void 0)throw new Error("Unexpected undefined frameId");r.set(a.id,o)}return r}static processTrace(t,n){let{timeOriginDeterminationMethod:r="auto"}=n||{},a=this.filteredTraceSort(t.traceEvents,C=>C.cat.includes("blink.user_timing")||C.cat.includes("loading")||C.cat.includes("devtools.timeline")||C.cat==="__metadata"),o=this.findMainFrameIds(a),i=this.findMainFramePidTids(o,a),c=e.filteredTraceSort(t.traceEvents,C=>i.has(C.pid)),u=new Map,d=a.find(C=>C.name==="TracingStartedInBrowser")?.args?.data?.frames;if(d)for(let C of d)u.set(C.frame,{id:C.frame,url:C.url,parent:C.parent});a.filter(C=>!!(C.name==="FrameCommittedInBrowser"&&C.args.data?.frame&&C.args.data.url!==void 0)).forEach(C=>{u.set(C.args.data.frame,{id:C.
args.data.frame,url:C.args.data.url,parent:C.args.data.parent})});let m=[...u.values()],p=this.resolveRootFrames(m),h=[...p.entries()].filter(([,C])=>C===o.frameId).map(([C])=>C);function f(C){return e.getFrameId(C)===o.frameId}s(f,"associatedToMainFrame");function g(C){let F=e.getFrameId(C);return F?h.includes(F):!1}s(g,"associatedToAllFrames");let v=a.filter(C=>f(C)),w=[];p.has(o.frameId)?w=a.filter(C=>g(C)):(N.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),p.set(o.frameId,o.frameId),w=v);let E=this.computeTimeOrigin({keyEvents:a,frameEvents:v,mainFrameInfo:o},r),T=c.filter(C=>C.tid===i.get(C.pid)),S=this.computeTraceEnd(t.traceEvents,E);return{frames:m,mainThreadEvents:T,frameEvents:v,frameTreeEvents:w,processEvents:c,mainFrameInfo:o,timeOriginEvt:E,timings:{timeOrigin:0,traceEnd:S.timing},timestamps:{timeOrigin:E.ts,traceEnd:S.timestamp},_keyEvents:a,_rendererPidToTid:i}}static processNavigation(t){let{frameEvents:n,frameTreeEvents:r,
timeOriginEvt:a,timings:o,timestamps:i}=t,c=this.computeNavigationTimingsForFrame(n,{timeOriginEvt:a}),u=r.find(h=>h.name==="firstContentfulPaint"&&h.ts>a.ts);if(!u)throw this.createNoFirstContentfulPaintError();let d=this.computeValidLCPAllFrames(r,a).lcp,m=s(h=>(h-a.ts)/1e3,"getTiming"),p=s(h=>h===void 0?void 0:m(h),"maybeGetTiming");return{timings:{timeOrigin:o.timeOrigin,firstPaint:c.timings.firstPaint,firstContentfulPaint:c.timings.firstContentfulPaint,firstContentfulPaintAllFrames:m(u.ts),largestContentfulPaint:c.timings.largestContentfulPaint,largestContentfulPaintAllFrames:p(d?.ts),load:c.timings.load,domContentLoaded:c.timings.domContentLoaded,traceEnd:o.traceEnd},timestamps:{timeOrigin:i.timeOrigin,firstPaint:c.timestamps.firstPaint,firstContentfulPaint:c.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:u.ts,largestContentfulPaint:c.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:d?.ts,load:c.timestamps.load,domContentLoaded:c.timestamps.domContentLoaded,
traceEnd:i.traceEnd},firstPaintEvt:c.firstPaintEvt,firstContentfulPaintEvt:c.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:u,largestContentfulPaintEvt:c.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:d,loadEvt:c.loadEvt,domContentLoadedEvt:c.domContentLoadedEvt,lcpInvalidated:c.lcpInvalidated}}static computeTraceEnd(t,n){let r=-1/0;for(let a of t)r=Math.max(a.ts+(a.dur||0),r);return{timestamp:r,timing:(r-n.ts)/1e3}}static computeTimeOrigin(t,n){let r=s(()=>t.frameEvents.filter(this._isNavigationStartOfInterest).pop(),"lastNavigationStart"),a=s(()=>t.keyEvents.find(i=>i.name==="clock_sync"&&i.args.sync_id===e.TIMESPAN_MARKER_ID),"lighthouseMarker");switch(n){case"firstResourceSendRequest":{let o=t.keyEvents.find(i=>i.name!=="ResourceSendRequest"?!1:(i.args.data||{}).frame===t.mainFrameInfo.frameId);if(!o)throw this.createNoResourceSendRequestError();return o}case"lastNavigationStart":{let o=r();if(!o)throw this.createNoNavstartError();return o}case"lighthouseMar\
ker":{let o=a();if(!o)throw this.createNoLighthouseMarkerError();return o}case"auto":{let o=a()||r();if(!o)throw this.createNoNavstartError();return o}}}static computeNavigationTimingsForFrame(t,n){let{timeOriginEvt:r}=n,a=t.find(g=>g.name==="firstPaint"&&g.ts>r.ts),o=t.find(g=>g.name==="firstContentfulPaint"&&g.ts>r.ts);if(!o)throw this.createNoFirstContentfulPaintError();let i=this.computeValidLCPAllFrames(t,r),c=t.find(g=>g.name==="loadEventEnd"&&g.ts>r.ts),u=t.find(g=>g.name==="domContentLoadedEventEnd"&&g.ts>r.ts),d=s(g=>g?.ts,"getTimestamp"),m={timeOrigin:r.ts,firstPaint:d(a),firstContentfulPaint:o.ts,largestContentfulPaint:d(i.lcp),load:d(c),domContentLoaded:d(u)},p=s(g=>(g-r.ts)/1e3,"getTiming"),h=s(g=>g===void 0?void 0:p(g),"maybeGetTiming");return{timings:{timeOrigin:0,firstPaint:h(m.firstPaint),firstContentfulPaint:p(m.firstContentfulPaint),largestContentfulPaint:h(m.largestContentfulPaint),load:h(m.load),domContentLoaded:h(m.domContentLoaded)},timestamps:m,timeOriginEvt:r,firstPaintEvt:a,
firstContentfulPaintEvt:o,largestContentfulPaintEvt:i.lcp,loadEvt:c,domContentLoadedEvt:u,lcpInvalidated:i.invalidated}}}});var pk={};x(pk,{default:()=>or});var p1,or,Fo=y(()=>{"use strict";l();Ye();Jr();p1=class e extends J{static{s(this,"Trace")}_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo","disabled-by-default-devtools.timeline.invalidationTracking"]}static async endTraceAndCollectEvents(t){let n=[],r=s(function(a){n.push(...a.value)},"dataListener");return t.on("Tracing.dataCollected",r),new Promise((a,o)=>{t.once("Tracing.tracingComplete",i=>{t.off("Tracing.dataCollected",r),a({traceEvents:n})}),t.sendCommand("Tracing.end").catch(o)})}static symbol=Symbol("Trace");meta={symbol:e.symbol,supportedModes:["timespan","navigation"]};async startSensitiveInstrumentation({driver:t,gatherMode:n,
settings:r}){let a=e.getDefaultTraceCategories().concat(r.additionalTraceCategories||[]);await t.defaultSession.sendCommand("Page.enable"),await t.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),n==="timespan"&&await t.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:Jt.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:t}){this._trace=await e.endTraceAndCollectEvents(t.defaultSession)}getDebugData(){return this._trace}getArtifact(){return this._trace}},or=p1});var fk={};x(fk,{default:()=>qn});var qn,Qr=y(()=>{l();qn={}});function hk(e,t){for(var n=0,r=e.length-1;r>=0;r--){var a=e[r];a==="."?e.splice(r,1):a===".."?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function f1(){for(var e="",t=!1,n=arguments.length-1;n>=-1&&!t;n--){var r=n>=0?arguments[n]:"/";if(typeof r!="string")throw new TypeError("Arguments to path.resolve must be strings");if(!r)continue;e=r+"/"+e,t=r.charAt(0)==="/"}return e=hk(g1(e.split("/"),function(a){return!!a}),!t).join("/"),(t?"/":"")+e||"."}function gk(e){var t=yk(e),n=CH(e,-1)==="/";return e=hk(g1(e.split("/"),function(r){return!!r}),!t).join("/"),!e&&!t&&(e="."),e&&n&&(e+="/"),(t?"/":"")+e}function yk(e){return e.charAt(0)==="/"}function bH(){var e=Array.prototype.slice.call(arguments,0);return gk(g1(e,function(t,n){if(typeof t!="string")throw new TypeError("Arguments to path.join must be strings");return t}).join("/"))}function wH(e,t){e=f1(e).substr(1),t=f1(t).substr(1);function n(d){for(var m=0;m<d.length&&d[m]==="";m++);for(var p=d.length-
1;p>=0&&d[p]==="";p--);return m>p?[]:d.slice(m,p-m+1)}s(n,"trim");for(var r=n(e.split("/")),a=n(t.split("/")),o=Math.min(r.length,a.length),i=o,c=0;c<o;c++)if(r[c]!==a[c]){i=c;break}for(var u=[],c=i;c<r.length;c++)u.push("..");return u=u.concat(a.slice(i)),u.join("/")}function TH(e){var t=h1(e),n=t[0],r=t[1];return!n&&!r?".":(r&&(r=r.substr(0,r.length-1)),n+r)}function xH(e,t){var n=h1(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n}function SH(e){return h1(e)[3]}function g1(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}var vH,h1,DH,EH,xt,CH,_a=y(()=>{l();s(hk,"normalizeArray");vH=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,h1=s(function(e){return vH.exec(e).slice(1)},"splitPath");s(f1,"resolve");s(gk,"normalize");s(yk,"isAbsolute");s(bH,"join");s(wH,"relative");DH="/",EH=":";s(TH,"dirname");s(xH,"basename");s(SH,"extname");xt={extname:SH,basename:xH,dirname:TH,sep:DH,delimiter:EH,
relative:wH,join:bH,isAbsolute:yk,normalize:gk,resolve:f1};s(g1,"filter");CH="ab".substr(-1)==="b"?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return t<0&&(t=e.length+t),e.substr(t,n)}});var bk=P((K1e,vk)=>{l();function kH(){this.__data__=[],this.size=0}s(kH,"listCacheClear");vk.exports=kH});var y1=P((J1e,wk)=>{l();function FH(e,t){return e===t||e!==e&&t!==t}s(FH,"eq");wk.exports=FH});var Ic=P((tge,Dk)=>{l();var RH=y1();function AH(e,t){for(var n=e.length;n--;)if(RH(e[n][0],t))return n;return-1}s(AH,"assocIndexOf");Dk.exports=AH});var Tk=P((age,Ek)=>{l();var _H=Ic(),IH=Array.prototype,NH=IH.splice;function MH(e){var t=this.__data__,n=_H(t,e);if(n<0)return!1;var r=t.length-1;return n==r?t.pop():NH.call(t,n,1),--this.size,!0}s(MH,"listCacheDelete");Ek.exports=MH});var Sk=P((sge,xk)=>{l();var PH=Ic();function LH(e){var t=this.__data__,n=PH(t,e);return n<0?void 0:t[n][1]}s(LH,"listCacheGet");xk.exports=LH});var kk=P((lge,Ck)=>{l();var OH=Ic();function BH(e){return OH(this.__data__,e)>-1}s(BH,"listCacheHas");Ck.exports=BH});var Rk=P((pge,Fk)=>{l();var UH=Ic();function jH(e,t){var n=this.__data__,r=UH(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this}s(jH,"listCacheSet");Fk.exports=jH});var Nc=P((gge,Ak)=>{l();var qH=bk(),zH=Tk(),HH=Sk(),WH=kk(),GH=Rk();function Oi(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(Oi,"ListCache");Oi.prototype.clear=qH;Oi.prototype.delete=zH;Oi.prototype.get=HH;Oi.prototype.has=WH;Oi.prototype.set=GH;Ak.exports=Oi});var Ik=P((bge,_k)=>{l();var VH=Nc();function $H(){this.__data__=new VH,this.size=0}s($H,"stackClear");_k.exports=$H});var Mk=P((Ege,Nk)=>{l();function YH(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n}s(YH,"stackDelete");Nk.exports=YH});var Lk=P((Sge,Pk)=>{l();function KH(e){return this.__data__.get(e)}s(KH,"stackGet");Pk.exports=KH});var Bk=P((Fge,Ok)=>{l();function XH(e){return this.__data__.has(e)}s(XH,"stackHas");Ok.exports=XH});var v1=P((_ge,Uk)=>{l();var ZH=typeof globalThis=="object"&&globalThis&&globalThis.Object===Object&&globalThis;Uk.exports=ZH});var Er=P((Nge,jk)=>{l();var JH=v1(),QH=typeof self=="object"&&self&&self.Object===Object&&self,eW=JH||QH||Function("return this")();jk.exports=eW});var ym=P((Pge,qk)=>{l();var tW=Er(),nW=tW.Symbol;qk.exports=nW});var Gk=P((Oge,Wk)=>{l();var zk=ym(),Hk=Object.prototype,rW=Hk.hasOwnProperty,aW=Hk.toString,Mc=zk?zk.toStringTag:void 0;function oW(e){var t=rW.call(e,Mc),n=e[Mc];try{e[Mc]=void 0;var r=!0}catch{}var a=aW.call(e);return r&&(t?e[Mc]=n:delete e[Mc]),a}s(oW,"getRawTag");Wk.exports=oW});var $k=P((jge,Vk)=>{l();var iW=Object.prototype,sW=iW.toString;function cW(e){return sW.call(e)}s(cW,"objectToString");Vk.exports=cW});var Pc=P((Hge,Xk)=>{l();var Yk=ym(),uW=Gk(),lW=$k(),dW="[object Null]",mW="[object Undefined]",Kk=Yk?Yk.toStringTag:void 0;function pW(e){return e==null?e===void 0?mW:dW:Kk&&Kk in Object(e)?uW(e):lW(e)}s(pW,"baseGetTag");Xk.exports=pW});var b1=P((Vge,Zk)=>{l();function fW(e){var t=typeof e;return e!=null&&(t=="object"||t=="function")}s(fW,"isObject");Zk.exports=fW});var w1=P((Kge,Jk)=>{l();var hW=Pc(),gW=b1(),yW="[object AsyncFunction]",vW="[object Function]",bW="[object GeneratorFunction]",wW="[object Proxy]";function DW(e){if(!gW(e))return!1;var t=hW(e);return t==vW||t==bW||t==yW||t==wW}s(DW,"isFunction");Jk.exports=DW});var eF=P((Jge,Qk)=>{l();var EW=Er(),TW=EW["__core-js_shared__"];Qk.exports=TW});var rF=P((eye,nF)=>{l();var D1=eF(),tF=function(){var e=/[^.]+$/.exec(D1&&D1.keys&&D1.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}();function xW(e){return!!tF&&tF in e}s(xW,"isMasked");nF.exports=xW});var E1=P((rye,aF)=>{l();var SW=Function.prototype,CW=SW.toString;function kW(e){if(e!=null){try{return CW.call(e)}catch{}try{return e+""}catch{}}return""}s(kW,"toSource");aF.exports=kW});var iF=P((iye,oF)=>{l();var FW=w1(),RW=rF(),AW=b1(),_W=E1(),IW=/[\\^$.*+?()[\]{}|]/g,NW=/^\[object .+?Constructor\]$/,MW=Function.prototype,PW=Object.prototype,LW=MW.toString,OW=PW.hasOwnProperty,BW=RegExp("^"+LW.call(OW).replace(IW,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function UW(e){if(!AW(e)||RW(e))return!1;var t=FW(e)?BW:NW;return t.test(_W(e))}s(UW,"baseIsNative");oF.exports=UW});var cF=P((uye,sF)=>{l();function jW(e,t){return e?.[t]}s(jW,"getValue");sF.exports=jW});var Ro=P((mye,uF)=>{l();var qW=iF(),zW=cF();function HW(e,t){var n=zW(e,t);return qW(n)?n:void 0}s(HW,"getNative");uF.exports=HW});var vm=P((hye,lF)=>{l();var WW=Ro(),GW=Er(),VW=WW(GW,"Map");lF.exports=VW});var Lc=P((yye,dF)=>{l();var $W=Ro(),YW=$W(Object,"create");dF.exports=YW});var fF=P((bye,pF)=>{l();var mF=Lc();function KW(){this.__data__=mF?mF(null):{},this.size=0}s(KW,"hashClear");pF.exports=KW});var gF=P((Eye,hF)=>{l();function XW(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}s(XW,"hashDelete");hF.exports=XW});var vF=P((Sye,yF)=>{l();var ZW=Lc(),JW="__lodash_hash_undefined__",QW=Object.prototype,eG=QW.hasOwnProperty;function tG(e){var t=this.__data__;if(ZW){var n=t[e];return n===JW?void 0:n}return eG.call(t,e)?t[e]:void 0}s(tG,"hashGet");yF.exports=tG});var wF=P((Fye,bF)=>{l();var nG=Lc(),rG=Object.prototype,aG=rG.hasOwnProperty;function oG(e){var t=this.__data__;return nG?t[e]!==void 0:aG.call(t,e)}s(oG,"hashHas");bF.exports=oG});var EF=P((_ye,DF)=>{l();var iG=Lc(),sG="__lodash_hash_undefined__";function cG(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=iG&&t===void 0?sG:t,this}s(cG,"hashSet");DF.exports=cG});var xF=P((Mye,TF)=>{l();var uG=fF(),lG=gF(),dG=vF(),mG=wF(),pG=EF();function Bi(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(Bi,"Hash");Bi.prototype.clear=uG;Bi.prototype.delete=lG;Bi.prototype.get=dG;Bi.prototype.has=mG;Bi.prototype.set=pG;TF.exports=Bi});var kF=P((Oye,CF)=>{l();var SF=xF(),fG=Nc(),hG=vm();function gG(){this.size=0,this.__data__={hash:new SF,map:new(hG||fG),string:new SF}}s(gG,"mapCacheClear");CF.exports=gG});var RF=P((jye,FF)=>{l();function yG(e){var t=typeof e;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?e!=="__proto__":e===null}s(yG,"isKeyable");FF.exports=yG});var Oc=P((Hye,AF)=>{l();var vG=RF();function bG(e,t){var n=e.__data__;return vG(t)?n[typeof t=="string"?"string":"hash"]:n.map}s(bG,"getMapData");AF.exports=bG});var IF=P((Vye,_F)=>{l();var wG=Oc();function DG(e){var t=wG(this,e).delete(e);return this.size-=t?1:0,t}s(DG,"mapCacheDelete");_F.exports=DG});var MF=P((Kye,NF)=>{l();var EG=Oc();function TG(e){return EG(this,e).get(e)}s(TG,"mapCacheGet");NF.exports=TG});var LF=P((Jye,PF)=>{l();var xG=Oc();function SG(e){return xG(this,e).has(e)}s(SG,"mapCacheHas");PF.exports=SG});var BF=P((tve,OF)=>{l();var CG=Oc();function kG(e,t){var n=CG(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this}s(kG,"mapCacheSet");OF.exports=kG});var T1=P((ave,UF)=>{l();var FG=kF(),RG=IF(),AG=MF(),_G=LF(),IG=BF();function Ui(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(Ui,"MapCache");Ui.prototype.clear=FG;Ui.prototype.delete=RG;Ui.prototype.get=AG;Ui.prototype.has=_G;Ui.prototype.set=IG;UF.exports=Ui});var qF=P((sve,jF)=>{l();var NG=Nc(),MG=vm(),PG=T1(),LG=200;function OG(e,t){var n=this.__data__;if(n instanceof NG){var r=n.__data__;if(!MG||r.length<LG-1)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new PG(r)}return n.set(e,t),this.size=n.size,this}s(OG,"stackSet");jF.exports=OG});var HF=P((lve,zF)=>{l();var BG=Nc(),UG=Ik(),jG=Mk(),qG=Lk(),zG=Bk(),HG=qF();function ji(e){var t=this.__data__=new BG(e);this.size=t.size}s(ji,"Stack");ji.prototype.clear=UG;ji.prototype.delete=jG;ji.prototype.get=qG;ji.prototype.has=zG;ji.prototype.set=HG;zF.exports=ji});var GF=P((pve,WF)=>{l();var WG="__lodash_hash_undefined__";function GG(e){return this.__data__.set(e,WG),this}s(GG,"setCacheAdd");WF.exports=GG});var $F=P((gve,VF)=>{l();function VG(e){return this.__data__.has(e)}s(VG,"setCacheHas");VF.exports=VG});var KF=P((bve,YF)=>{l();var $G=T1(),YG=GF(),KG=$F();function bm(e){var t=-1,n=e==null?0:e.length;for(this.__data__=new $G;++t<n;)this.add(e[t])}s(bm,"SetCache");bm.prototype.add=bm.prototype.push=YG;bm.prototype.has=KG;YF.exports=bm});var ZF=P((Eve,XF)=>{l();function XG(e,t){for(var n=-1,r=e==null?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}s(XG,"arraySome");XF.exports=XG});var QF=P((Sve,JF)=>{l();function ZG(e,t){return e.has(t)}s(ZG,"cacheHas");JF.exports=ZG});var x1=P((Fve,eR)=>{l();var JG=KF(),QG=ZF(),eV=QF(),tV=1,nV=2;function rV(e,t,n,r,a,o){var i=n&tV,c=e.length,u=t.length;if(c!=u&&!(i&&u>c))return!1;var d=o.get(e),m=o.get(t);if(d&&m)return d==t&&m==e;var p=-1,h=!0,f=n&nV?new JG:void 0;for(o.set(e,t),o.set(t,e);++p<c;){var g=e[p],v=t[p];if(r)var w=i?r(v,g,p,t,e,o):r(g,v,p,e,t,o);if(w!==void 0){if(w)continue;h=!1;break}if(f){if(!QG(t,function(E,T){if(!eV(f,T)&&(g===E||a(g,E,n,r,o)))return f.push(T)})){h=!1;break}}else if(!(g===v||a(g,v,n,r,o))){h=!1;break}}return o.delete(e),o.delete(t),h}s(rV,"equalArrays");eR.exports=rV});var nR=P((_ve,tR)=>{l();var aV=Er(),oV=aV.Uint8Array;tR.exports=oV});var aR=P((Nve,rR)=>{l();function iV(e){var t=-1,n=Array(e.size);return e.forEach(function(r,a){n[++t]=[a,r]}),n}s(iV,"mapToArray");rR.exports=iV});var iR=P((Lve,oR)=>{l();function sV(e){var t=-1,n=Array(e.size);return e.forEach(function(r){n[++t]=r}),n}s(sV,"setToArray");oR.exports=sV});var dR=P((Uve,lR)=>{l();var sR=ym(),cR=nR(),cV=y1(),uV=x1(),lV=aR(),dV=iR(),mV=1,pV=2,fV="[object Boolean]",hV="[object Date]",gV="[object Error]",yV="[object Map]",vV="[object Number]",bV="[object RegExp]",wV="[object Set]",DV="[object String]",EV="[object Symbol]",TV="[object ArrayBuffer]",xV="[object DataView]",uR=sR?sR.prototype:void 0,S1=uR?uR.valueOf:void 0;function SV(e,t,n,r,a,o,i){switch(n){case xV:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case TV:return!(e.byteLength!=t.byteLength||!o(new cR(e),new cR(t)));case fV:case hV:case vV:return cV(+e,+t);case gV:return e.name==t.name&&e.message==t.message;case bV:case DV:return e==t+"";case yV:var c=lV;case wV:var u=r&mV;if(c||(c=dV),e.size!=t.size&&!u)return!1;var d=i.get(e);if(d)return d==t;r|=pV,i.set(e,t);var m=uV(c(e),c(t),r,a,o,i);return i.delete(e),m;case EV:if(S1)return S1.call(e)==S1.call(t)}return!1}s(SV,"equalByTag");lR.exports=SV});var pR=P((zve,mR)=>{l();function CV(e,t){for(var n=-1,r=t.length,a=e.length;++n<r;)e[a+n]=t[n];return e}s(CV,"arrayPush");mR.exports=CV});var wm=P((Gve,fR)=>{l();var kV=Array.isArray;fR.exports=kV});var gR=P(($ve,hR)=>{l();var FV=pR(),RV=wm();function AV(e,t,n){var r=t(e);return RV(e)?r:FV(r,n(e))}s(AV,"baseGetAllKeys");hR.exports=AV});var vR=P((Xve,yR)=>{l();function _V(e,t){for(var n=-1,r=e==null?0:e.length,a=0,o=[];++n<r;){var i=e[n];t(i,n,e)&&(o[a++]=i)}return o}s(_V,"arrayFilter");yR.exports=_V});var wR=P((Qve,bR)=>{l();function IV(){return[]}s(IV,"stubArray");bR.exports=IV});var TR=P((nbe,ER)=>{l();var NV=vR(),MV=wR(),PV=Object.prototype,LV=PV.propertyIsEnumerable,DR=Object.getOwnPropertySymbols,OV=DR?function(e){return e==null?[]:(e=Object(e),NV(DR(e),function(t){return LV.call(e,t)}))}:MV;ER.exports=OV});var SR=P((abe,xR)=>{l();function BV(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}s(BV,"baseTimes");xR.exports=BV});var Bc=P((sbe,CR)=>{l();function UV(e){return e!=null&&typeof e=="object"}s(UV,"isObjectLike");CR.exports=UV});var FR=P((lbe,kR)=>{l();var jV=Pc(),qV=Bc(),zV="[object Arguments]";function HV(e){return qV(e)&&jV(e)==zV}s(HV,"baseIsArguments");kR.exports=HV});var IR=P((pbe,_R)=>{l();var RR=FR(),WV=Bc(),AR=Object.prototype,GV=AR.hasOwnProperty,VV=AR.propertyIsEnumerable,$V=RR(function(){return arguments}())?RR:function(e){return WV(e)&&GV.call(e,"callee")&&!VV.call(e,"callee")};_R.exports=$V});var MR=P((hbe,NR)=>{l();function YV(){return!1}s(YV,"stubFalse");NR.exports=YV});var C1=P((Uc,qi)=>{l();var KV=Er(),XV=MR(),OR=typeof Uc=="object"&&Uc&&!Uc.nodeType&&Uc,PR=OR&&typeof qi=="object"&&qi&&!qi.nodeType&&qi,ZV=PR&&PR.exports===OR,LR=ZV?KV.Buffer:void 0,JV=LR?LR.isBuffer:void 0,QV=JV||XV;qi.exports=QV});var UR=P((bbe,BR)=>{l();var e$=9007199254740991,t$=/^(?:0|[1-9]\d*)$/;function n$(e,t){var n=typeof e;return t=t??e$,!!t&&(n=="number"||n!="symbol"&&t$.test(e))&&e>-1&&e%1==0&&e<t}s(n$,"isIndex");BR.exports=n$});var k1=P((Ebe,jR)=>{l();var r$=9007199254740991;function a$(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=r$}s(a$,"isLength");jR.exports=a$});var zR=P((Sbe,qR)=>{l();var o$=Pc(),i$=k1(),s$=Bc(),c$="[object Arguments]",u$="[object Array]",l$="[object Boolean]",d$="[object Date]",m$="[object Error]",p$="[object Function]",f$="[object Map]",h$="[object Number]",g$="[object Object]",y$="[object RegExp]",v$="[object Set]",b$="[object String]",w$="[object WeakMap]",D$="[object ArrayBuffer]",E$="[object DataView]",T$="[object Float32Array]",x$="[object Float64Array]",S$="[object Int8Array]",C$="[object Int16Array]",k$="[object Int32Array]",F$="[object Uint8Array]",R$="[object Uint8ClampedArray]",A$="[object Uint16Array]",_$="[object Uint32Array]",wt={};wt[T$]=wt[x$]=wt[S$]=wt[C$]=wt[k$]=wt[F$]=wt[R$]=wt[A$]=wt[_$]=!0;wt[c$]=wt[u$]=wt[D$]=wt[l$]=wt[E$]=wt[d$]=wt[m$]=wt[p$]=wt[f$]=wt[h$]=wt[g$]=wt[y$]=wt[v$]=wt[b$]=wt[w$]=!1;function I$(e){return s$(e)&&i$(e.length)&&!!wt[o$(e)]}s(I$,"baseIsTypedArray");qR.exports=I$});var WR=P((Fbe,HR)=>{l();function N$(e){return function(t){return e(t)}}s(N$,"baseUnary");HR.exports=N$});var VR=P((jc,zi)=>{l();var M$=v1(),GR=typeof jc=="object"&&jc&&!jc.nodeType&&jc,qc=GR&&typeof zi=="object"&&zi&&!zi.nodeType&&zi,P$=qc&&qc.exports===GR,F1=P$&&M$.process,L$=function(){try{var e=qc&&qc.require&&qc.require("util").types;return e||F1&&F1.binding&&F1.binding("util")}catch{}}();zi.exports=L$});var R1=P((Ibe,KR)=>{l();var O$=zR(),B$=WR(),$R=VR(),YR=$R&&$R.isTypedArray,U$=YR?B$(YR):O$;KR.exports=U$});var ZR=P((Mbe,XR)=>{l();var j$=SR(),q$=IR(),z$=wm(),H$=C1(),W$=UR(),G$=R1(),V$=Object.prototype,$$=V$.hasOwnProperty;function Y$(e,t){var n=z$(e),r=!n&&q$(e),a=!n&&!r&&H$(e),o=!n&&!r&&!a&&G$(e),i=n||r||a||o,c=i?j$(e.length,String):[],u=c.length;for(var d in e)(t||$$.call(e,d))&&!(i&&(d=="length"||a&&(d=="offset"||d=="parent")||o&&(d=="buffer"||d=="byteLength"||d=="byteOffset")||W$(d,u)))&&c.push(d);return c}s(Y$,"arrayLikeKeys");XR.exports=Y$});var QR=P((Obe,JR)=>{l();var K$=Object.prototype;function X$(e){var t=e&&e.constructor,n=typeof t=="function"&&t.prototype||K$;return e===n}s(X$,"isPrototype");JR.exports=X$});var tA=P((jbe,eA)=>{l();function Z$(e,t){return function(n){return e(t(n))}}s(Z$,"overArg");eA.exports=Z$});var rA=P((Hbe,nA)=>{l();var J$=tA(),Q$=J$(Object.keys,Object);nA.exports=Q$});var oA=P((Gbe,aA)=>{l();var eY=QR(),tY=rA(),nY=Object.prototype,rY=nY.hasOwnProperty;function aY(e){if(!eY(e))return tY(e);var t=[];for(var n in Object(e))rY.call(e,n)&&n!="constructor"&&t.push(n);return t}s(aY,"baseKeys");aA.exports=aY});var sA=P((Ybe,iA)=>{l();var oY=w1(),iY=k1();function sY(e){return e!=null&&iY(e.length)&&!oY(e)}s(sY,"isArrayLike");iA.exports=sY});var uA=P((Zbe,cA)=>{l();var cY=ZR(),uY=oA(),lY=sA();function dY(e){return lY(e)?cY(e):uY(e)}s(dY,"keys");cA.exports=dY});var dA=P((e0e,lA)=>{l();var mY=gR(),pY=TR(),fY=uA();function hY(e){return mY(e,fY,pY)}s(hY,"getAllKeys");lA.exports=hY});var fA=P((r0e,pA)=>{l();var mA=dA(),gY=1,yY=Object.prototype,vY=yY.hasOwnProperty;function bY(e,t,n,r,a,o){var i=n&gY,c=mA(e),u=c.length,d=mA(t),m=d.length;if(u!=m&&!i)return!1;for(var p=u;p--;){var h=c[p];if(!(i?h in t:vY.call(t,h)))return!1}var f=o.get(e),g=o.get(t);if(f&&g)return f==t&&g==e;var v=!0;o.set(e,t),o.set(t,e);for(var w=i;++p<u;){h=c[p];var E=e[h],T=t[h];if(r)var S=i?r(T,E,h,t,e,o):r(E,T,h,e,t,o);if(!(S===void 0?E===T||a(E,T,n,r,o):S)){v=!1;break}w||(w=h=="constructor")}if(v&&!w){var C=e.constructor,F=t.constructor;C!=F&&"constructor"in e&&"constructor"in t&&!(typeof C=="function"&&C instanceof C&&typeof F=="function"&&F instanceof F)&&(v=!1)}return o.delete(e),o.delete(t),v}s(bY,"equalObjects");pA.exports=bY});var gA=P((i0e,hA)=>{l();var wY=Ro(),DY=Er(),EY=wY(DY,"DataView");hA.exports=EY});var vA=P((c0e,yA)=>{l();var TY=Ro(),xY=Er(),SY=TY(xY,"Promise");yA.exports=SY});var wA=P((l0e,bA)=>{l();var CY=Ro(),kY=Er(),FY=CY(kY,"Set");bA.exports=FY});var EA=P((m0e,DA)=>{l();var RY=Ro(),AY=Er(),_Y=RY(AY,"WeakMap");DA.exports=_Y});var AA=P((f0e,RA)=>{l();var A1=gA(),_1=vm(),I1=vA(),N1=wA(),M1=EA(),FA=Pc(),Hi=E1(),TA="[object Map]",IY="[object Object]",xA="[object Promise]",SA="[object Set]",CA="[object WeakMap]",kA="[object DataView]",NY=Hi(A1),MY=Hi(_1),PY=Hi(I1),LY=Hi(N1),OY=Hi(M1),Ao=FA;(A1&&Ao(new A1(new ArrayBuffer(1)))!=kA||_1&&Ao(new _1)!=TA||I1&&Ao(I1.resolve())!=xA||N1&&Ao(new N1)!=SA||M1&&Ao(new M1)!=CA)&&(Ao=s(function(e){var t=FA(e),n=t==IY?e.constructor:void 0,r=n?Hi(n):"";if(r)switch(r){case NY:return kA;case MY:return TA;case PY:return xA;case LY:return SA;case OY:return CA}return t},"getTag"));RA.exports=Ao});var BA=P((y0e,OA)=>{l();var P1=HF(),BY=x1(),UY=dR(),jY=fA(),_A=AA(),IA=wm(),NA=C1(),qY=R1(),zY=1,MA="[object Arguments]",PA="[object Array]",Dm="[object Object]",HY=Object.prototype,LA=HY.hasOwnProperty;function WY(e,t,n,r,a,o){var i=IA(e),c=IA(t),u=i?PA:_A(e),d=c?PA:_A(t);u=u==MA?Dm:u,d=d==MA?Dm:d;var m=u==Dm,p=d==Dm,h=u==d;if(h&&NA(e)){if(!NA(t))return!1;i=!0,m=!1}if(h&&!m)return o||(o=new P1),i||qY(e)?BY(e,t,n,r,a,o):UY(e,t,u,n,r,a,o);if(!(n&zY)){var f=m&&LA.call(e,"__wrapped__"),g=p&&LA.call(t,"__wrapped__");if(f||g){var v=f?e.value():e,w=g?t.value():t;return o||(o=new P1),a(v,w,n,r,o)}}return h?(o||(o=new P1),jY(e,t,n,r,a,o)):!1}s(WY,"baseIsEqualDeep");OA.exports=WY});var zA=P((w0e,qA)=>{l();var GY=BA(),UA=Bc();function jA(e,t,n,r,a){return e===t?!0:e==null||t==null||!UA(e)&&!UA(t)?e!==e&&t!==t:GY(e,t,n,r,jA,a)}s(jA,"baseIsEqual");qA.exports=jA});var zc=P((T0e,HA)=>{l();var VY=zA();function $Y(e,t){return VY(e,t)}s($Y,"isEqual");HA.exports=$Y});var WA,GA=y(()=>{"use strict";l();ka();WA=!!an.env.CI||an.env.NODE_ENV==="test"});function ZY(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,o=-1.453152027,i=1.061405429,u=1/(1+.3275911*e),d=u*(n+u*(r+u*(a+u*(o+u*i))));return t*(1-d*Math.exp(-e*e))}function VA({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),o=Math.log(a),i=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(i),u=o*r/c,d=(1-ZY(u))/2,m;return n<=t?m=Math.max(.9,Math.min(1,d)):n<=e?m=Math.max(KY,Math.min(YY,d)):m=Math.max(0,Math.min(XY,d)),m}function $A(e,t,n,r,a){let o=(r-t)/(n-e);return t+(a-e)*o}var YY,KY,XY,L1=y(()=>{"use strict";l();YY=.8999999999999999,KY=.5,XY=.49999999999999994;s(ZY,"erf");s(VA,"getLogNormalScore");s($A,"linearInterpolation")});var ea,QY,YA,eK,tK,_e,Pn=y(()=>{"use strict";l();L1();ea="…",QY=" ",YA=.9,eK={PASS:{label:"pass",minScore:YA},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},tK=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"],_e=class e{static{s(this,"Util")}static get RATINGS(){return eK}static get PASS_THRESHOLD(){return YA}static get MS_DISPLAY_VALUE(){return`%10d${QY}ms`}static getFinalDisplayedUrl(t){if(t.finalDisplayedUrl)return t.finalDisplayedUrl;if(t.finalUrl)return t.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(t){return t.mainDocumentUrl||t.finalUrl}static getFullPageScreenshot(t){return t.fullPageScreenshot?t.fullPageScreenshot:t.audits["full-page-screenshot"]?.details}static getEntityFromUrl(t,n){return n&&n.find(a=>a.origins.find(o=>t.startsWith(o)))||e.getPseudoRootDomain(t)}static splitMarkdownCodeSpans(t){let n=[],
r=t.split(/`(.*?)`/g);for(let a=0;a<r.length;a++){let o=r[a];if(!o)continue;let i=a%2!==0;n.push({isCode:i,text:o})}return n}static splitMarkdownLink(t){let n=[],r=t.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;r.length;){let[a,o,i]=r.splice(0,3);a&&n.push({isLink:!1,text:a}),o&&i&&n.push({isLink:!0,text:o,linkHref:i})}return n}static truncate(t,n,r="…"){if(t.length<=n)return t;let o=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(t)[Symbol.iterator](),i=0;for(let c=0;c<=n-r.length;c++){let u=o.next();if(u.done)return t;i=u.value.index}for(let c=0;c<r.length;c++)if(o.next().done)return t;return t.slice(0,i)+r}static getURLDisplayName(t,n){n=n||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0};let r=n.numPathParts!==void 0?n.numPathParts:2,a=n.preserveQuery!==void 0?n.preserveQuery:!0,o=n.preserveHost||!1,i;if(t.protocol==="about:"||t.protocol==="data:")i=t.href;else{i=t.pathname;let u=i.split("/").filter(d=>d.length);r&&u.length>r&&(i=ea+u.slice(-1*r).join(
"/")),o&&(i=`${t.host}/${i.replace(/^\//,"")}`),a&&(i=`${i}${t.search}`)}let c=64;if(t.protocol!=="data:"&&(i=i.slice(0,200),i=i.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ea}`),i=i.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${ea}`),i=i.replace(/(\d{3})\d{6,}/g,`$1${ea}`),i=i.replace(/\u2026+/g,ea),i.length>c&&i.includes("?")&&(i=i.replace(/\?([^=]*)(=)?.*/,`?$1$2${ea}`),i.length>c&&(i=i.replace(/\?.*/,`?${ea}`)))),i.length>c){let u=i.lastIndexOf(".");u>=0?i=i.slice(0,c-1-(i.length-u))+`${ea}${i.slice(u)}`:i=i.slice(0,c-1)+ea}return i}static getChromeExtensionOrigin(t){let n=new URL(t);return n.protocol+"//"+n.host}static parseURL(t){let n=new URL(t);return{file:e.getURLDisplayName(n),hostname:n.hostname,origin:n.protocol==="chrome-extension:"?e.getChromeExtensionOrigin(t):n.origin}}static createOrReturnURL(t){return t instanceof URL?t:new URL(t)}static getPseudoTld(t){let n=t.split(".").slice(-2);return tK.includes(n[0])?`.${n.join(".")}`:
`.${n[n.length-1]}`}static getPseudoRootDomain(t){let n=e.createOrReturnURL(t).hostname,a=e.getPseudoTld(n).split(".");return n.split(".").slice(-a.length).join(".")}static filterRelevantLines(t,n,r){if(n.length===0)return t.slice(0,r*2+1);let a=3,o=new Set;return n=n.sort((i,c)=>(i.lineNumber||0)-(c.lineNumber||0)),n.forEach(({lineNumber:i})=>{let c=i-r,u=i+r;for(;c<1;)c++,u++;o.has(c-a-1)&&(c-=a);for(let d=c;d<=u;d++){let m=d;o.add(m)}}),t.filter(i=>o.has(i.lineNumber))}static computeLogNormalScore(t,n){let r=VA(t,n);return r>.9&&(r+=.05*(r-.9)),Math.floor(r*100)/100}}});var nK,rK,aK,b,$=y(()=>{"use strict";l();on();GA();Pn();nK="defaultPass",rK={FCP:50,LCP:50,INP:50,TBT:50,CLS:.001},aK=s(e=>Math.round(e*100)/100,"clampTo2Decimals"),b=class e{static{s(this,"Audit")}static get DEFAULT_PASS(){return nK}static get SCORING_MODES(){return{NUMERIC:"numeric",METRIC_SAVINGS:"metricSavings",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(t,n){throw new Error("audit() method must be overridden")}static computeLogNormalScore(t,n){return _e.computeLogNormalScore(t,n)}static assertHeadingKeysExist(t,n){if(n.length&&WA)for(let r of t){if(r.key===null)continue;let a=r.key;if(!n.some(o=>a in o))throw new Error(`"${r.key}" is missing from items`)}}static makeTableDetails(t,n,r={}){let{wastedBytes:a,wastedMs:o,sortedBy:i,skipSumming:c,isEntityGrouped:u}=r,d=a||o?{wastedBytes:a,wastedMs:o}:
void 0;return n.length===0?{type:"table",headings:[],items:[],summary:d}:(e.assertHeadingKeysExist(t,n),{type:"table",headings:t,items:n,summary:d,sortedBy:i,skipSumming:c,isEntityGrouped:u})}static makeListDetails(t){return{type:"list",items:t}}static makeSnippetDetails({content:t,title:n,lineMessages:r,generalMessages:a,node:o,maxLineLength:i=200,maxLinesAroundMessage:c=20}){let u=e._makeSnippetLinesArray(t,i);return{type:"snippet",lines:_e.filterRelevantLines(u,r,c),title:n,lineMessages:r,generalMessages:a,lineCount:u.length,node:o}}static _makeSnippetLinesArray(t,n){return t.split(`
`).map((r,a)=>{let o=a+1,i={content:_e.truncate(r,n),lineNumber:o};return r.length>n&&(i.truncated=!0),i})}static makeOpportunityDetails(t,n,r){e.assertHeadingKeysExist(t,n);let{overallSavingsMs:a,overallSavingsBytes:o,sortedBy:i,skipSumming:c,isEntityGrouped:u}=r;return{type:"opportunity",headings:n.length===0?[]:t,items:n,overallSavingsMs:a,overallSavingsBytes:o,sortedBy:i,skipSumming:c,isEntityGrouped:u}}static makeNodeItem(t){return{type:"node",lhId:t.lhId,path:t.devtoolsNodePath,selector:t.selector,boundingRect:t.boundingRect,snippet:t.snippet,nodeLabel:t.nodeLabel}}static _findOriginalLocation(t,n,r){let a=t?.map.findEntry(n,r);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(t,n,r,a){return{type:"source-location",url:t,urlProvider:"network",line:n,column:r,original:a&&this._findOriginalLocation(a,n,r)}}static makeSourceLocationFromConsoleMessage(t,n){if(!t.url)return;let r=t.lineNumber||0,a=t.columnNumber||0;return this.
makeSourceLocation(t.url,r,a,n)}static _normalizeAuditScore(t,n,r){if(n===e.SCORING_MODES.INFORMATIVE)return 1;if(n!==e.SCORING_MODES.BINARY&&n!==e.SCORING_MODES.NUMERIC&&n!==e.SCORING_MODES.METRIC_SAVINGS)return null;if(t===null||!Number.isFinite(t))throw new Error(`Invalid score for ${r}: ${t}`);if(t>1)throw new Error(`Audit score for ${r} is > 1`);if(t<0)throw new Error(`Audit score for ${r} is < 0`);return t=aK(t),t}static _quantizeMetricSavings(t){if(!t)return;let n={...t};for(let r of Object.keys(t)){let a=t[r];if(a===void 0)continue;a=Math.max(a,0);let o=rK[r];o!==void 0&&(a=Math.round(a/o)*o),n[r]=a}return n}static generateErrorAuditResult(t,n,r){return e.generateAuditResult(t,{score:null,errorMessage:n,errorStack:r})}static generateAuditResult(t,n){if(n.score===void 0)throw new Error("generateAuditResult requires a score");let r=t.meta.scoreDisplayMode||e.SCORING_MODES.BINARY,a=n.score;n.errorMessage!==void 0?r=e.SCORING_MODES.ERROR:n.notApplicable?r=e.SCORING_MODES.NOT_APPLICABLE:
n.scoreDisplayMode&&(r=n.scoreDisplayMode);let o=e._quantizeMetricSavings(n.metricSavings),i=Object.values(o||{}).some(d=>d);r===e.SCORING_MODES.METRIC_SAVINGS&&(a&&a>=_e.PASS_THRESHOLD?a=1:i?a=0:a=.5),a=e._normalizeAuditScore(a,r,t.meta.id);let c=t.meta.title;t.meta.failureTitle&&a!==null&&a<_e.PASS_THRESHOLD&&(c=t.meta.failureTitle);let u="numericUnit"in n?n:void 0;return{id:t.meta.id,title:c,description:t.meta.description,score:a,scoreDisplayMode:r,numericValue:u?.numericValue,numericUnit:u?.numericUnit,displayValue:n.displayValue,explanation:n.explanation,errorMessage:n.errorMessage,errorStack:n.errorStack,warnings:n.warnings,scoringOptions:n.scoringOptions,metricSavings:o,details:n.details,guidanceLevel:t.meta.guidanceLevel}}static makeMetricComputationDataInput(t,n){let r=t.traces[e.DEFAULT_PASS],a=t.devtoolsLogs[e.DEFAULT_PASS],o=t.GatherContext;return{trace:r,devtoolsLog:a,gatherContext:o,settings:n.settings,URL:t.URL}}}});var oK,Em,KA=y(()=>{"use strict";l();$();oK=s(e=>Math.round(e*100)/100,"clampTo2Decimals"),Em=class e{static{s(this,"ReportScoring")}static arithmeticMean(t){if(t=t.filter(r=>r.weight>0),t.some(r=>r.score===null))return null;let n=t.reduce((r,a)=>{let o=a.score,i=a.weight;return{weight:r.weight+i,sum:r.sum+o*i}},{weight:0,sum:0});return oK(n.sum/n.weight||0)}static scoreAllCategories(t,n){let r={};for(let[a,o]of Object.entries(t)){let i=o.auditRefs.map(d=>{let m={...d},p=n[m.id];return(p.scoreDisplayMode===b.SCORING_MODES.NOT_APPLICABLE||p.scoreDisplayMode===b.SCORING_MODES.INFORMATIVE||p.scoreDisplayMode===b.SCORING_MODES.MANUAL)&&(m.weight=0),m}),c=i.map(d=>({score:n[d.id].score,weight:d.weight})),u=e.arithmeticMean(c);r[a]={...o,auditRefs:i,id:a,score:u}}return r}}});function Hc(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");O1(e,t);function n(){this.constructor=e}s(n,"__"),e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}function XA(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var a=0,r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(n[r[a]]=e[r[a]]);return n}function Tm(e,t,n){if(n||arguments.length===2)for(var r=0,a=t.length,o;r<a;r++)(o||!(r in t))&&(o||(o=Array.prototype.slice.call(t,0,r)),o[r]=t[r]);return e.concat(o||Array.prototype.slice.call(t))}var O1,ir,B1=y(()=>{l();O1=s(function(e,t){return O1=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,r){n.__proto__=r}||function(n,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(n[a]=
r[a])},O1(e,t)},"extendStatics");s(Hc,"__extends");ir=s(function(){return ir=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),ir.apply(this,arguments)},"__assign");s(XA,"__rest");s(Tm,"__spreadArray")});var Wi,U1=y(()=>{l();Wi=s(function(){return Wi=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Wi.apply(this,arguments)},"__assign")});var Ge,j1=y(()=>{l();(function(e){e[e.EXPECT_ARGUMENT_CLOSING_BRACE=1]="EXPECT_ARGUMENT_CLOSING_BRACE",e[e.EMPTY_ARGUMENT=2]="EMPTY_ARGUMENT",e[e.MALFORMED_ARGUMENT=3]="MALFORMED_ARGUMENT",e[e.EXPECT_ARGUMENT_TYPE=4]="EXPECT_ARGUMENT_TYPE",e[e.INVALID_ARGUMENT_TYPE=5]="INVALID_ARGUMENT_TYPE",e[e.EXPECT_ARGUMENT_STYLE=6]="EXPECT_ARGUMENT_STYLE",e[e.INVALID_NUMBER_SKELETON=7]="INVALID_NUMBER_SKELETON",e[e.INVALID_DATE_TIME_SKELETON=8]="INVALID_DATE_TIME_SKELETON",e[e.EXPECT_NUMBER_SKELETON=9]="EXPECT_NUMBER_SKELETON",e[e.EXPECT_DATE_TIME_SKELETON=10]="EXPECT_DATE_TIME_SKELETON",e[e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE=11]="UNCLOSED_QUOTE_IN_ARGUMENT_STYLE",e[e.EXPECT_SELECT_ARGUMENT_OPTIONS=12]="EXPECT_SELECT_ARGUMENT_OPTIONS",e[e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE=13]="EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE=14]="INVALID_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR=15]="EXPECT_SELECT_ARGUMENT_SELECTOR",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR=
16]="EXPECT_PLURAL_ARGUMENT_SELECTOR",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT=17]="EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT=18]="EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT",e[e.INVALID_PLURAL_ARGUMENT_SELECTOR=19]="INVALID_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR=20]="DUPLICATE_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_SELECT_ARGUMENT_SELECTOR=21]="DUPLICATE_SELECT_ARGUMENT_SELECTOR",e[e.MISSING_OTHER_CLAUSE=22]="MISSING_OTHER_CLAUSE",e[e.INVALID_TAG=23]="INVALID_TAG",e[e.INVALID_TAG_NAME=25]="INVALID_TAG_NAME",e[e.UNMATCHED_CLOSING_TAG=26]="UNMATCHED_CLOSING_TAG",e[e.UNCLOSED_TAG=27]="UNCLOSED_TAG"})(Ge||(Ge={}))});function q1(e){return e.type===Dt.literal}function ZA(e){return e.type===Dt.argument}function xm(e){return e.type===Dt.number}function Sm(e){return e.type===Dt.date}function Cm(e){return e.type===Dt.time}function km(e){return e.type===Dt.select}function Fm(e){return e.type===Dt.plural}function JA(e){return e.type===Dt.pound}function Rm(e){return e.type===Dt.tag}function Am(e){return!!(e&&typeof e=="object"&&e.type===_o.number)}function Wc(e){return!!(e&&typeof e=="object"&&e.type===_o.dateTime)}var Dt,_o,_m=y(()=>{l();(function(e){e[e.literal=0]="literal",e[e.argument=1]="argument",e[e.number=2]="number",e[e.date=3]="date",e[e.time=4]="time",e[e.select=5]="select",e[e.plural=6]="plural",e[e.pound=7]="pound",e[e.tag=8]="tag"})(Dt||(Dt={}));(function(e){e[e.number=0]="number",e[e.dateTime=1]="dateTime"})(_o||(_o={}));s(q1,"isLiteralElement");s(ZA,"isArgumentElement");s(xm,"isNumberElement");s(Sm,"isDateElement");s(Cm,"isTimeElement");s(km,"isSelectElement");s(Fm,"isPluralElement");s(JA,"\
isPoundElement");s(Rm,"isTagElement");s(Am,"isNumberSkeleton");s(Wc,"isDateTimeSkeleton")});var z1,QA=y(()=>{l();z1=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/});function e_(e){var t={};return e.replace(iK,function(n){var r=n.length;switch(n[0]){case"G":t.era=r===4?"long":r===5?"narrow":"short";break;case"y":t.year=r===2?"2-digit":"numeric";break;case"Y":case"u":case"U":case"r":throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");case"q":case"Q":throw new RangeError("`q/Q` (quarter) patterns are not supported");case"M":case"L":t.month=["numeric","2-digit","short","long","narrow"][r-1];break;case"w":case"W":throw new RangeError("`w/W` (week) patterns are not supported");case"d":t.day=["numeric","2-digit"][r-1];break;case"D":case"F":case"g":throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");case"E":t.weekday=r===4?"short":r===5?"narrow":"short";break;case"e":if(r<4)throw new RangeError("`e..eee` (weekday) patterns are not supported");t.weekday=["short","long","narrow","short"][r-4];break;case"c":if(r<4)throw new RangeError("`c..ccc` (weekday) patterns are not supported");t.weekday=["s\
hort","long","narrow","short"][r-4];break;case"a":t.hour12=!0;break;case"b":case"B":throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");case"h":t.hourCycle="h12",t.hour=["numeric","2-digit"][r-1];break;case"H":t.hourCycle="h23",t.hour=["numeric","2-digit"][r-1];break;case"K":t.hourCycle="h11",t.hour=["numeric","2-digit"][r-1];break;case"k":t.hourCycle="h24",t.hour=["numeric","2-digit"][r-1];break;case"j":case"J":case"C":throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");case"m":t.minute=["numeric","2-digit"][r-1];break;case"s":t.second=["numeric","2-digit"][r-1];break;case"S":case"A":throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");case"z":t.timeZoneName=r<4?"short":"long";break;case"Z":case"O":case"v":case"V":case"X":case"x":throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead")}return""}),t}var iK,t_=y(()=>{l();iK=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
s(e_,"parseDateTimeSkeleton")});var Ft,n_=y(()=>{l();Ft=s(function(){return Ft=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Ft.apply(this,arguments)},"__assign")});var r_,a_=y(()=>{l();r_=/[\t-\r \x85\u200E\u200F\u2028\u2029]/i});function c_(e){if(e.length===0)throw new Error("Number skeleton cannot be empty");for(var t=e.split(r_).filter(function(h){return h.length>0}),n=[],r=0,a=t;r<a.length;r++){var o=a[r],i=o.split("/");if(i.length===0)throw new Error("Invalid number skeleton");for(var c=i[0],u=i.slice(1),d=0,m=u;d<m.length;d++){var p=m[d];if(p.length===0)throw new Error("Invalid number skeleton")}n.push({stem:c,options:u})}return n}function sK(e){return e.replace(/^(.*?)-/,"")}function i_(e){var t={};return e[e.length-1]==="r"?t.roundingPriority="morePrecision":e[e.length-1]==="s"&&(t.roundingPriority="lessPrecision"),e.replace(u_,function(n,r,a){return typeof a!="string"?(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length):a==="+"?t.minimumSignificantDigits=r.length:r[0]==="#"?t.maximumSignificantDigits=r.length:(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length+(typeof a=="string"?a.length:0)),""}),t}function d_(e){switch(e){case"sign-auto":return{signDisplay:"a\
uto"};case"sign-accounting":case"()":return{currencySign:"accounting"};case"sign-always":case"+!":return{signDisplay:"always"};case"sign-accounting-always":case"()!":return{signDisplay:"always",currencySign:"accounting"};case"sign-except-zero":case"+?":return{signDisplay:"exceptZero"};case"sign-accounting-except-zero":case"()?":return{signDisplay:"exceptZero",currencySign:"accounting"};case"sign-never":case"+_":return{signDisplay:"never"}}}function uK(e){var t;if(e[0]==="E"&&e[1]==="E"?(t={notation:"engineering"},e=e.slice(2)):e[0]==="E"&&(t={notation:"scientific"},e=e.slice(1)),t){var n=e.slice(0,2);if(n==="+!"?(t.signDisplay="always",e=e.slice(2)):n==="+?"&&(t.signDisplay="exceptZero",e=e.slice(2)),!l_.test(e))throw new Error("Malformed concise eng/scientific notation");t.minimumIntegerDigits=e.length}return t}function s_(e){var t={},n=d_(e);return n||t}function m_(e){for(var t={},n=0,r=e;n<r.length;n++){var a=r[n];switch(a.stem){case"percent":case"%":t.style="percent";continue;case"\
%x100":t.style="percent",t.scale=100;continue;case"currency":t.style="currency",t.currency=a.options[0];continue;case"group-off":case",_":t.useGrouping=!1;continue;case"precision-integer":case".":t.maximumFractionDigits=0;continue;case"measure-unit":case"unit":t.style="unit",t.unit=sK(a.options[0]);continue;case"compact-short":case"K":t.notation="compact",t.compactDisplay="short";continue;case"compact-long":case"KK":t.notation="compact",t.compactDisplay="long";continue;case"scientific":t=Ft(Ft(Ft({},t),{notation:"scientific"}),a.options.reduce(function(u,d){return Ft(Ft({},u),s_(d))},{}));continue;case"engineering":t=Ft(Ft(Ft({},t),{notation:"engineering"}),a.options.reduce(function(u,d){return Ft(Ft({},u),s_(d))},{}));continue;case"notation-simple":t.notation="standard";continue;case"unit-width-narrow":t.currencyDisplay="narrowSymbol",t.unitDisplay="narrow";continue;case"unit-width-short":t.currencyDisplay="code",t.unitDisplay="short";continue;case"unit-width-full-name":t.currencyDisplay=
"name",t.unitDisplay="long";continue;case"unit-width-iso-code":t.currencyDisplay="symbol";continue;case"scale":t.scale=parseFloat(a.options[0]);continue;case"integer-width":if(a.options.length>1)throw new RangeError("integer-width stems only accept a single optional option");a.options[0].replace(cK,function(u,d,m,p,h,f){if(d)t.minimumIntegerDigits=m.length;else{if(p&&h)throw new Error("We currently do not support maximum integer digits");if(f)throw new Error("We currently do not support exact integer digits")}return""});continue}if(l_.test(a.stem)){t.minimumIntegerDigits=a.stem.length;continue}if(o_.test(a.stem)){if(a.options.length>1)throw new RangeError("Fraction-precision stems only accept a single optional option");a.stem.replace(o_,function(u,d,m,p,h,f){return m==="*"?t.minimumFractionDigits=d.length:p&&p[0]==="#"?t.maximumFractionDigits=p.length:h&&f?(t.minimumFractionDigits=h.length,t.maximumFractionDigits=h.length+f.length):(t.minimumFractionDigits=d.length,t.maximumFractionDigits=
d.length),""});var o=a.options[0];o==="w"?t=Ft(Ft({},t),{trailingZeroDisplay:"stripIfInteger"}):o&&(t=Ft(Ft({},t),i_(o)));continue}if(u_.test(a.stem)){t=Ft(Ft({},t),i_(a.stem));continue}var i=d_(a.stem);i&&(t=Ft(Ft({},t),i));var c=uK(a.stem);c&&(t=Ft(Ft({},t),c))}return t}var o_,u_,cK,l_,p_=y(()=>{l();n_();a_();s(c_,"parseNumberSkeletonFromString");s(sK,"icuUnitToEcma");o_=/^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g,u_=/^(@+)?(\+|#+)?[rs]?$/g,cK=/(\*)(0+)|(#+)(0+)|(0+)/g,l_=/^(0+)$/;s(i_,"parseSignificantPrecision");s(d_,"parseSign");s(uK,"parseConciseScientificAndEngineeringStem");s(s_,"parseNotationOptions");s(m_,"parseNumberSkeleton")});var f_=y(()=>{l();t_();p_()});var Gc,h_=y(()=>{l();Gc={"001":["H","h"],AC:["H","h","hb","hB"],AD:["H","hB"],AE:["h","hB","hb","H"],AF:["H","hb","hB","h"],AG:["h","hb","H","hB"],AI:["H","h","hb","hB"],AL:["h","H","hB"],AM:["H","hB"],AO:["H","hB"],AR:["H","h","hB","hb"],AS:["h","H"],AT:["H","hB"],AU:["h","hb","H","hB"],AW:["H","hB"],AX:["H"],AZ:["H","hB","h"],BA:["H","hB","h"],BB:["h","hb","H","hB"],BD:["h","hB","H"],BE:["H","hB"],BF:["H","hB"],BG:["H","hB","h"],BH:["h","hB","hb","H"],BJ:["H","hB"],BL:["H","hB"],BM:["h","hb","H","hB"],BN:["hb","hB","h","H"],BO:["H","hB","h","hb"],BQ:["H"],BR:["H","hB"],BS:["h","hb","H","hB"],BT:["h","H"],BW:["H","h","hb","hB"],BZ:["H","h","hb","hB"],CA:["h","hb","H","hB"],CC:["H","h","hb","hB"],CD:["hB","H"],CF:["H","h","hB"],CG:["H","hB"],CH:["H","hB","h"],CI:["H","hB"],CK:["H","h","hb","hB"],CL:["H","h","hB","hb"],CM:["H","h","hB"],CN:["H","hB","hb","h"],CO:["h","H","hB","hb"],CP:["H"],CR:["H","h","hB","hb"],CU:["H","h","hB","hb"],CV:["H","hB"],CX:["H","h","hb","hB"],CY:["h","H","h\
b","hB"],CZ:["H"],DE:["H","hB"],DG:["H","h","hb","hB"],DJ:["h","H"],DK:["H"],DM:["h","hb","H","hB"],DO:["h","H","hB","hb"],DZ:["h","hB","hb","H"],EA:["H","h","hB","hb"],EC:["H","hB","h","hb"],EE:["H","hB"],EG:["h","hB","hb","H"],EH:["h","hB","hb","H"],ER:["h","H"],ES:["H","hB","h","hb"],ET:["hB","hb","h","H"],FI:["H"],FJ:["h","hb","H","hB"],FK:["H","h","hb","hB"],FM:["h","hb","H","hB"],FR:["H","hB"],GA:["H","hB"],GB:["H","h","hb","hB"],GD:["h","hb","H","hB"],GE:["H","hB","h"],GF:["H","hB"],GG:["H","h","hb","hB"],GH:["h","H"],GI:["H","h","hb","hB"],GM:["h","hb","H","hB"],GN:["H","hB"],GP:["H","hB"],GQ:["H","hB","h","hb"],GR:["h","H","hb","hB"],GT:["H","h","hB","hb"],GU:["h","hb","H","hB"],GW:["H","hB"],GY:["h","hb","H","hB"],HK:["h","hB","hb","H"],HN:["H","h","hB","hb"],HR:["H","hB"],IC:["H","h","hB","hb"],ID:["H"],IE:["H","h","hb","hB"],IL:["H","hB"],IM:["H","h","hb","hB"],IN:["h","H"],IO:["H","h","hb","hB"],IQ:["h","hB","hb","H"],IR:["hB","H"],IS:["H"],IT:["H","hB"],JE:["H","h","hb","\
hB"],JM:["h","hb","H","hB"],JO:["h","hB","hb","H"],JP:["H","h","K"],KE:["hB","hb","H","h"],KG:["H","h","hB","hb"],KH:["hB","h","H","hb"],KI:["h","hb","H","hB"],KM:["H","h","hB","hb"],KN:["h","hb","H","hB"],KP:["h","H","hB","hb"],KR:["h","H","hB","hb"],KW:["h","hB","hb","H"],KY:["h","hb","H","hB"],KZ:["H","hB"],LA:["H","hb","hB","h"],LB:["h","hB","hb","H"],LC:["h","hb","H","hB"],LI:["H","hB","h"],LK:["H","h","hB","hb"],LR:["h","hb","H","hB"],LS:["h","H"],LT:["H","h","hb","hB"],LU:["H","h","hB"],LV:["H","hB","hb","h"],LY:["h","hB","hb","H"],MA:["H","h","hB","hb"],MC:["H","hB"],MD:["H","hB"],ME:["H","hB","h"],MF:["H","hB"],MH:["h","hb","H","hB"],MK:["H","h","hb","hB"],ML:["H"],MM:["hB","hb","H","h"],MN:["H","h","hb","hB"],MO:["h","hB","hb","H"],MP:["h","hb","H","hB"],MQ:["H","hB"],MR:["h","hB","hb","H"],MS:["H","h","hb","hB"],MW:["h","hb","H","hB"],MX:["H","h","hB","hb"],MY:["hb","hB","h","H"],MZ:["H","hB"],NA:["h","H","hB","hb"],NC:["H","hB"],NE:["H"],NF:["H","h","hb","hB"],NG:["H","h","\
hb","hB"],NI:["H","h","hB","hb"],NL:["H","hB"],NP:["H","h","hB"],NR:["H","h","hb","hB"],NU:["H","h","hb","hB"],NZ:["h","hb","H","hB"],OM:["h","hB","hb","H"],PA:["h","H","hB","hb"],PE:["H","hB","h","hb"],PF:["H","h","hB"],PG:["h","H"],PH:["h","hB","hb","H"],PK:["h","hB","H"],PM:["H","hB"],PN:["H","h","hb","hB"],PR:["h","H","hB","hb"],PS:["h","hB","hb","H"],PT:["H","hB"],PW:["h","H"],PY:["H","h","hB","hb"],QA:["h","hB","hb","H"],RE:["H","hB"],RO:["H","hB"],RS:["H","hB","h"],RU:["H"],SA:["h","hB","hb","H"],SB:["h","hb","H","hB"],SC:["H","h","hB"],SD:["h","hB","hb","H"],SE:["H"],SG:["h","hb","H","hB"],SH:["H","h","hb","hB"],SI:["H","hB"],SJ:["H"],SK:["H"],SL:["h","hb","H","hB"],SM:["H","h","hB"],SN:["H","h","hB"],SO:["h","H"],SR:["H","hB"],SS:["h","hb","H","hB"],ST:["H","hB"],SV:["H","h","hB","hb"],SX:["H","h","hb","hB"],SY:["h","hB","hb","H"],SZ:["h","hb","H","hB"],TA:["H","h","hb","hB"],TC:["h","hb","H","hB"],TD:["h","H","hB"],TF:["H","h","hB"],TG:["H","hB"],TL:["H","hB","hb","h"],TN:["h",
"hB","hb","H"],TO:["h","H"],TR:["H","hB"],TT:["h","hb","H","hB"],TW:["hB","hb","h","H"],TZ:["hB","hb","H","h"],UA:["H","hB","h"],UG:["hB","hb","H","h"],UM:["h","hb","H","hB"],US:["h","hb","H","hB"],UY:["H","h","hB","hb"],UZ:["H","hB","h"],VA:["H","h","hB"],VC:["h","hb","H","hB"],VE:["h","H","hB","hb"],VG:["h","hb","H","hB"],VI:["h","hb","H","hB"],VU:["h","H"],WF:["H","hB"],WS:["h","H"],XK:["H","hB","h"],YE:["h","hB","hb","H"],YT:["H","hB"],ZA:["H","h","hb","hB"],ZM:["h","hb","H","hB"],"af-ZA":["H","h","hB","hb"],"ar-001":["h","hB","hb","H"],"ca-ES":["H","h","hB"],"en-001":["h","hb","H","hB"],"es-BO":["H","h","hB","hb"],"es-BR":["H","h","hB","hb"],"es-EC":["H","h","hB","hb"],"es-ES":["H","h","hB","hb"],"es-GQ":["H","h","hB","hb"],"es-PE":["H","h","hB","hb"],"fr-CA":["H","h","hB"],"gl-ES":["H","h","hB"],"gu-IN":["hB","hb","h","H"],"hi-IN":["hB","h","H"],"it-CH":["H","h","hB"],"it-IT":["H","h","hB"],"kn-IN":["hB","h","H"],"ml-IN":["hB","h","H"],"mr-IN":["hB","hb","h","H"],"pa-IN":["hB","h\
b","h","H"],"ta-IN":["hB","h","hb","H"],"te-IN":["hB","h","H"],"zu-ZA":["H","hB","hb","h"]}});function g_(e,t){for(var n="",r=0;r<e.length;r++){var a=e.charAt(r);if(a==="j"){for(var o=0;r+1<e.length&&e.charAt(r+1)===a;)o++,r++;var i=1+(o&1),c=o<2?1:3+(o>>1),u="a",d=lK(t);for((d=="H"||d=="k")&&(c=0);c-- >0;)n+=u;for(;i-- >0;)n=d+n}else a==="J"?n+="H":n+=a}return n}function lK(e){var t=e.hourCycle;if(t===void 0&&e.hourCycles&&e.hourCycles.length&&(t=e.hourCycles[0]),t)switch(t){case"h24":return"k";case"h23":return"H";case"h12":return"h";case"h11":return"K";default:throw new Error("Invalid hourCycle")}var n=e.language,r;n!=="root"&&(r=e.maximize().region);var a=Gc[r||""]||Gc[n||""]||Gc["".concat(n,"-001")]||Gc["001"];return a[0]}var y_=y(()=>{l();h_();s(g_,"getBestPattern");s(lK,"getDefaultHourSymbolFromLocale")});function Qe(e,t){return{start:e,end:t}}function E_(e,t){return new RegExp(e,t)}function Y1(e){return e>=97&&e<=122||e>=65&&e<=90}function TK(e){return Y1(e)||e===47}function xK(e){return e===45||e===46||e>=48&&e<=57||e===95||e>=97&&e<=122||e>=65&&e<=90||e==183||e>=192&&e<=214||e>=216&&e<=246||e>=248&&e<=893||e>=895&&e<=8191||e>=8204&&e<=8205||e>=8255&&e<=8256||e>=8304&&e<=8591||e>=11264&&e<=12271||e>=12289&&e<=55295||e>=63744&&e<=64975||e>=65008&&e<=65533||e>=65536&&e<=983039}function x_(e){return e>=9&&e<=13||e===32||e===133||e>=8206&&e<=8207||e===8232||e===8233}function SK(e){return e>=33&&e<=35||e===36||e>=37&&e<=39||e===40||e===41||e===42||e===43||e===44||e===45||e>=46&&e<=47||e>=58&&e<=59||e>=60&&e<=62||e>=63&&e<=64||e===91||e===92||e===93||e===94||e===96||e===123||e===124||e===125||e===126||e===161||e>=162&&e<=165||e===166||e===167||e===169||e===171||e===172||e===174||e===176||e===177||e===182||e===187||e===191||e===215||e===247||e>=8208&&e<=8213||e>=8214&&e<=8215||e===8216||e===
8217||e===8218||e>=8219&&e<=8220||e===8221||e===8222||e===8223||e>=8224&&e<=8231||e>=8240&&e<=8248||e===8249||e===8250||e>=8251&&e<=8254||e>=8257&&e<=8259||e===8260||e===8261||e===8262||e>=8263&&e<=8273||e===8274||e===8275||e>=8277&&e<=8286||e>=8592&&e<=8596||e>=8597&&e<=8601||e>=8602&&e<=8603||e>=8604&&e<=8607||e===8608||e>=8609&&e<=8610||e===8611||e>=8612&&e<=8613||e===8614||e>=8615&&e<=8621||e===8622||e>=8623&&e<=8653||e>=8654&&e<=8655||e>=8656&&e<=8657||e===8658||e===8659||e===8660||e>=8661&&e<=8691||e>=8692&&e<=8959||e>=8960&&e<=8967||e===8968||e===8969||e===8970||e===8971||e>=8972&&e<=8991||e>=8992&&e<=8993||e>=8994&&e<=9e3||e===9001||e===9002||e>=9003&&e<=9083||e===9084||e>=9085&&e<=9114||e>=9115&&e<=9139||e>=9140&&e<=9179||e>=9180&&e<=9185||e>=9186&&e<=9254||e>=9255&&e<=9279||e>=9280&&e<=9290||e>=9291&&e<=9311||e>=9472&&e<=9654||e===9655||e>=9656&&e<=9664||e===9665||e>=9666&&e<=9719||e>=9720&&e<=9727||e>=9728&&e<=9838||e===9839||e>=9840&&e<=10087||e===10088||e===10089||e===10090||
e===10091||e===10092||e===10093||e===10094||e===10095||e===10096||e===10097||e===10098||e===10099||e===10100||e===10101||e>=10132&&e<=10175||e>=10176&&e<=10180||e===10181||e===10182||e>=10183&&e<=10213||e===10214||e===10215||e===10216||e===10217||e===10218||e===10219||e===10220||e===10221||e===10222||e===10223||e>=10224&&e<=10239||e>=10240&&e<=10495||e>=10496&&e<=10626||e===10627||e===10628||e===10629||e===10630||e===10631||e===10632||e===10633||e===10634||e===10635||e===10636||e===10637||e===10638||e===10639||e===10640||e===10641||e===10642||e===10643||e===10644||e===10645||e===10646||e===10647||e===10648||e>=10649&&e<=10711||e===10712||e===10713||e===10714||e===10715||e>=10716&&e<=10747||e===10748||e===10749||e>=10750&&e<=11007||e>=11008&&e<=11055||e>=11056&&e<=11076||e>=11077&&e<=11078||e>=11079&&e<=11084||e>=11085&&e<=11123||e>=11124&&e<=11125||e>=11126&&e<=11157||e===11158||e>=11159&&e<=11263||e>=11776&&e<=11777||e===11778||e===11779||e===11780||e===11781||e>=11782&&e<=11784||e===
11785||e===11786||e===11787||e===11788||e===11789||e>=11790&&e<=11798||e===11799||e>=11800&&e<=11801||e===11802||e===11803||e===11804||e===11805||e>=11806&&e<=11807||e===11808||e===11809||e===11810||e===11811||e===11812||e===11813||e===11814||e===11815||e===11816||e===11817||e>=11818&&e<=11822||e===11823||e>=11824&&e<=11833||e>=11834&&e<=11835||e>=11836&&e<=11839||e===11840||e===11841||e===11842||e>=11843&&e<=11855||e>=11856&&e<=11857||e===11858||e>=11859&&e<=11903||e>=12289&&e<=12291||e===12296||e===12297||e===12298||e===12299||e===12300||e===12301||e===12302||e===12303||e===12304||e===12305||e>=12306&&e<=12307||e===12308||e===12309||e===12310||e===12311||e===12312||e===12313||e===12314||e===12315||e===12316||e===12317||e>=12318&&e<=12319||e===12320||e===12336||e===64830||e===64831||e>=65093&&e<=65094}var H1,dK,mK,pK,fK,hK,gK,yK,vK,bK,wK,G1,v_,b_,V1,w_,D_,DK,EK,$1,W1,T_,S_=y(()=>{l();U1();j1();_m();QA();f_();y_();dK=new RegExp("^".concat(z1.source,"*")),mK=new RegExp("".concat(z1.source,
"*$"));s(Qe,"createLocation");pK=!!String.prototype.startsWith&&"_a".startsWith("a",1),fK=!!String.fromCodePoint,hK=!!Object.fromEntries,gK=!!String.prototype.codePointAt,yK=!!String.prototype.trimStart,vK=!!String.prototype.trimEnd,bK=!!Number.isSafeInteger,wK=bK?Number.isSafeInteger:function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e&&Math.abs(e)<=9007199254740991},G1=!0;try{v_=E_("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),G1=((H1=v_.exec("a"))===null||H1===void 0?void 0:H1[0])==="a"}catch{G1=!1}b_=s(pK?function(t,n,r){return t.startsWith(n,r)}:function(t,n,r){return t.slice(r,r+n.length)===n},"startsWith"),V1=fK?String.fromCodePoint:s(function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];for(var r="",a=t.length,o=0,i;a>o;){if(i=t[o++],i>1114111)throw RangeError(i+" is not a valid code point");r+=i<65536?String.fromCharCode(i):String.fromCharCode(((i-=65536)>>10)+55296,i%1024+56320)}return r},"fromCodePoint"),w_=hK?Object.fromEntries:s(function(t){
for(var n={},r=0,a=t;r<a.length;r++){var o=a[r],i=o[0],c=o[1];n[i]=c}return n},"fromEntries"),D_=s(gK?function(t,n){return t.codePointAt(n)}:function(t,n){var r=t.length;if(!(n<0||n>=r)){var a=t.charCodeAt(n),o;return a<55296||a>56319||n+1===r||(o=t.charCodeAt(n+1))<56320||o>57343?a:(a-55296<<10)+(o-56320)+65536}},"codePointAt"),DK=s(yK?function(t){return t.trimStart()}:function(t){return t.replace(dK,"")},"trimStart"),EK=s(vK?function(t){return t.trimEnd()}:function(t){return t.replace(mK,"")},"trimEnd");s(E_,"RE");G1?(W1=E_("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),$1=s(function(t,n){var r;W1.lastIndex=n;var a=W1.exec(t);return(r=a[1])!==null&&r!==void 0?r:""},"matchIdentifierAtIndex")):$1=s(function(t,n){for(var r=[];;){var a=D_(t,n);if(a===void 0||x_(a)||SK(a))break;r.push(a),n+=a>=65536?2:1}return V1.apply(void 0,r)},"matchIdentifierAtIndex");T_=function(){function e(t,n){n===void 0&&(n={}),this.message=t,this.position={offset:0,line:1,column:1},this.ignoreTag=!!n.ignoreTag,
this.locale=n.locale,this.requiresOtherClause=!!n.requiresOtherClause,this.shouldParseSkeletons=!!n.shouldParseSkeletons}return s(e,"Parser"),e.prototype.parse=function(){if(this.offset()!==0)throw Error("parser can only be used once");return this.parseMessage(0,"",!1)},e.prototype.parseMessage=function(t,n,r){for(var a=[];!this.isEOF();){var o=this.char();if(o===123){var i=this.parseArgument(t,r);if(i.err)return i;a.push(i.val)}else{if(o===125&&t>0)break;if(o===35&&(n==="plural"||n==="selectordinal")){var c=this.clonePosition();this.bump(),a.push({type:Dt.pound,location:Qe(c,this.clonePosition())})}else if(o===60&&!this.ignoreTag&&this.peek()===47){if(r)break;return this.error(Ge.UNMATCHED_CLOSING_TAG,Qe(this.clonePosition(),this.clonePosition()))}else if(o===60&&!this.ignoreTag&&Y1(this.peek()||0)){var i=this.parseTag(t,n);if(i.err)return i;a.push(i.val)}else{var i=this.parseLiteral(t,n);if(i.err)return i;a.push(i.val)}}}return{val:a,err:null}},e.prototype.parseTag=function(t,n){var r=this.
clonePosition();this.bump();var a=this.parseTagName();if(this.bumpSpace(),this.bumpIf("/>"))return{val:{type:Dt.literal,value:"<".concat(a,"/>"),location:Qe(r,this.clonePosition())},err:null};if(this.bumpIf(">")){var o=this.parseMessage(t+1,n,!0);if(o.err)return o;var i=o.val,c=this.clonePosition();if(this.bumpIf("</")){if(this.isEOF()||!Y1(this.char()))return this.error(Ge.INVALID_TAG,Qe(c,this.clonePosition()));var u=this.clonePosition(),d=this.parseTagName();return a!==d?this.error(Ge.UNMATCHED_CLOSING_TAG,Qe(u,this.clonePosition())):(this.bumpSpace(),this.bumpIf(">")?{val:{type:Dt.tag,value:a,children:i,location:Qe(r,this.clonePosition())},err:null}:this.error(Ge.INVALID_TAG,Qe(c,this.clonePosition())))}else return this.error(Ge.UNCLOSED_TAG,Qe(r,this.clonePosition()))}else return this.error(Ge.INVALID_TAG,Qe(r,this.clonePosition()))},e.prototype.parseTagName=function(){var t=this.offset();for(this.bump();!this.isEOF()&&xK(this.char());)this.bump();return this.message.slice(t,this.
offset())},e.prototype.parseLiteral=function(t,n){for(var r=this.clonePosition(),a="";;){var o=this.tryParseQuote(n);if(o){a+=o;continue}var i=this.tryParseUnquoted(t,n);if(i){a+=i;continue}var c=this.tryParseLeftAngleBracket();if(c){a+=c;continue}break}var u=Qe(r,this.clonePosition());return{val:{type:Dt.literal,value:a,location:u},err:null}},e.prototype.tryParseLeftAngleBracket=function(){return!this.isEOF()&&this.char()===60&&(this.ignoreTag||!TK(this.peek()||0))?(this.bump(),"<"):null},e.prototype.tryParseQuote=function(t){if(this.isEOF()||this.char()!==39)return null;switch(this.peek()){case 39:return this.bump(),this.bump(),"'";case 123:case 60:case 62:case 125:break;case 35:if(t==="plural"||t==="selectordinal")break;return null;default:return null}this.bump();var n=[this.char()];for(this.bump();!this.isEOF();){var r=this.char();if(r===39)if(this.peek()===39)n.push(39),this.bump();else{this.bump();break}else n.push(r);this.bump()}return V1.apply(void 0,n)},e.prototype.tryParseUnquoted=
function(t,n){if(this.isEOF())return null;var r=this.char();return r===60||r===123||r===35&&(n==="plural"||n==="selectordinal")||r===125&&t>0?null:(this.bump(),V1(r))},e.prototype.parseArgument=function(t,n){var r=this.clonePosition();if(this.bump(),this.bumpSpace(),this.isEOF())return this.error(Ge.EXPECT_ARGUMENT_CLOSING_BRACE,Qe(r,this.clonePosition()));if(this.char()===125)return this.bump(),this.error(Ge.EMPTY_ARGUMENT,Qe(r,this.clonePosition()));var a=this.parseIdentifierIfPossible().value;if(!a)return this.error(Ge.MALFORMED_ARGUMENT,Qe(r,this.clonePosition()));if(this.bumpSpace(),this.isEOF())return this.error(Ge.EXPECT_ARGUMENT_CLOSING_BRACE,Qe(r,this.clonePosition()));switch(this.char()){case 125:return this.bump(),{val:{type:Dt.argument,value:a,location:Qe(r,this.clonePosition())},err:null};case 44:return this.bump(),this.bumpSpace(),this.isEOF()?this.error(Ge.EXPECT_ARGUMENT_CLOSING_BRACE,Qe(r,this.clonePosition())):this.parseArgumentOptions(t,n,a,r);default:return this.error(
Ge.MALFORMED_ARGUMENT,Qe(r,this.clonePosition()))}},e.prototype.parseIdentifierIfPossible=function(){var t=this.clonePosition(),n=this.offset(),r=$1(this.message,n),a=n+r.length;this.bumpTo(a);var o=this.clonePosition(),i=Qe(t,o);return{value:r,location:i}},e.prototype.parseArgumentOptions=function(t,n,r,a){var o,i=this.clonePosition(),c=this.parseIdentifierIfPossible().value,u=this.clonePosition();switch(c){case"":return this.error(Ge.EXPECT_ARGUMENT_TYPE,Qe(i,u));case"number":case"date":case"time":{this.bumpSpace();var d=null;if(this.bumpIf(",")){this.bumpSpace();var m=this.clonePosition(),p=this.parseSimpleArgStyleIfPossible();if(p.err)return p;var h=EK(p.val);if(h.length===0)return this.error(Ge.EXPECT_ARGUMENT_STYLE,Qe(this.clonePosition(),this.clonePosition()));var f=Qe(m,this.clonePosition());d={style:h,styleLocation:f}}var g=this.tryParseArgumentClose(a);if(g.err)return g;var v=Qe(a,this.clonePosition());if(d&&b_(d?.style,"::",0)){var w=DK(d.style.slice(2));if(c==="number"){var p=this.
parseNumberSkeletonFromString(w,d.styleLocation);return p.err?p:{val:{type:Dt.number,value:r,location:v,style:p.val},err:null}}else{if(w.length===0)return this.error(Ge.EXPECT_DATE_TIME_SKELETON,v);var E=w;this.locale&&(E=g_(w,this.locale));var h={type:_o.dateTime,pattern:E,location:d.styleLocation,parsedOptions:this.shouldParseSkeletons?e_(E):{}},T=c==="date"?Dt.date:Dt.time;return{val:{type:T,value:r,location:v,style:h},err:null}}}return{val:{type:c==="number"?Dt.number:c==="date"?Dt.date:Dt.time,value:r,location:v,style:(o=d?.style)!==null&&o!==void 0?o:null},err:null}}case"plural":case"selectordinal":case"select":{var S=this.clonePosition();if(this.bumpSpace(),!this.bumpIf(","))return this.error(Ge.EXPECT_SELECT_ARGUMENT_OPTIONS,Qe(S,Wi({},S)));this.bumpSpace();var C=this.parseIdentifierIfPossible(),F=0;if(c!=="select"&&C.value==="offset"){if(!this.bumpIf(":"))return this.error(Ge.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Qe(this.clonePosition(),this.clonePosition()));this.bumpSpace();var p=this.
tryParseDecimalInteger(Ge.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Ge.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);if(p.err)return p;this.bumpSpace(),C=this.parseIdentifierIfPossible(),F=p.val}var L=this.tryParsePluralOrSelectOptions(t,c,n,C);if(L.err)return L;var g=this.tryParseArgumentClose(a);if(g.err)return g;var M=Qe(a,this.clonePosition());return c==="select"?{val:{type:Dt.select,value:r,options:w_(L.val),location:M},err:null}:{val:{type:Dt.plural,value:r,options:w_(L.val),offset:F,pluralType:c==="plural"?"cardinal":"ordinal",location:M},err:null}}default:return this.error(Ge.INVALID_ARGUMENT_TYPE,Qe(i,u))}},e.prototype.tryParseArgumentClose=function(t){return this.isEOF()||this.char()!==125?this.error(Ge.EXPECT_ARGUMENT_CLOSING_BRACE,Qe(t,this.clonePosition())):(this.bump(),{val:!0,err:null})},e.prototype.parseSimpleArgStyleIfPossible=function(){for(var t=0,n=this.clonePosition();!this.isEOF();){var r=this.char();switch(r){case 39:{this.bump();var a=this.clonePosition();if(!this.bumpUntil("\
'"))return this.error(Ge.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE,Qe(a,this.clonePosition()));this.bump();break}case 123:{t+=1,this.bump();break}case 125:{if(t>0)t-=1;else return{val:this.message.slice(n.offset,this.offset()),err:null};break}default:this.bump();break}}return{val:this.message.slice(n.offset,this.offset()),err:null}},e.prototype.parseNumberSkeletonFromString=function(t,n){var r=[];try{r=c_(t)}catch{return this.error(Ge.INVALID_NUMBER_SKELETON,n)}return{val:{type:_o.number,tokens:r,location:n,parsedOptions:this.shouldParseSkeletons?m_(r):{}},err:null}},e.prototype.tryParsePluralOrSelectOptions=function(t,n,r,a){for(var o,i=!1,c=[],u=new Set,d=a.value,m=a.location;;){if(d.length===0){var p=this.clonePosition();if(n!=="select"&&this.bumpIf("=")){var h=this.tryParseDecimalInteger(Ge.EXPECT_PLURAL_ARGUMENT_SELECTOR,Ge.INVALID_PLURAL_ARGUMENT_SELECTOR);if(h.err)return h;m=Qe(p,this.clonePosition()),d=this.message.slice(p.offset,this.offset())}else break}if(u.has(d))return this.error(n===
"select"?Ge.DUPLICATE_SELECT_ARGUMENT_SELECTOR:Ge.DUPLICATE_PLURAL_ARGUMENT_SELECTOR,m);d==="other"&&(i=!0),this.bumpSpace();var f=this.clonePosition();if(!this.bumpIf("{"))return this.error(n==="select"?Ge.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT:Ge.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT,Qe(this.clonePosition(),this.clonePosition()));var g=this.parseMessage(t+1,n,r);if(g.err)return g;var v=this.tryParseArgumentClose(f);if(v.err)return v;c.push([d,{value:g.val,location:Qe(f,this.clonePosition())}]),u.add(d),this.bumpSpace(),o=this.parseIdentifierIfPossible(),d=o.value,m=o.location}return c.length===0?this.error(n==="select"?Ge.EXPECT_SELECT_ARGUMENT_SELECTOR:Ge.EXPECT_PLURAL_ARGUMENT_SELECTOR,Qe(this.clonePosition(),this.clonePosition())):this.requiresOtherClause&&!i?this.error(Ge.MISSING_OTHER_CLAUSE,Qe(this.clonePosition(),this.clonePosition())):{val:c,err:null}},e.prototype.tryParseDecimalInteger=function(t,n){var r=1,a=this.clonePosition();this.bumpIf("+")||this.bumpIf("-")&&(r=-1);
for(var o=!1,i=0;!this.isEOF();){var c=this.char();if(c>=48&&c<=57)o=!0,i=i*10+(c-48),this.bump();else break}var u=Qe(a,this.clonePosition());return o?(i*=r,wK(i)?{val:i,err:null}:this.error(n,u)):this.error(t,u)},e.prototype.offset=function(){return this.position.offset},e.prototype.isEOF=function(){return this.offset()===this.message.length},e.prototype.clonePosition=function(){return{offset:this.position.offset,line:this.position.line,column:this.position.column}},e.prototype.char=function(){var t=this.position.offset;if(t>=this.message.length)throw Error("out of bound");var n=D_(this.message,t);if(n===void 0)throw Error("Offset ".concat(t," is at invalid UTF-16 code unit boundary"));return n},e.prototype.error=function(t,n){return{val:null,err:{kind:t,message:this.message,location:n}}},e.prototype.bump=function(){if(!this.isEOF()){var t=this.char();t===10?(this.position.line+=1,this.position.column=1,this.position.offset+=1):(this.position.column+=1,this.position.offset+=t<65536?1:
2)}},e.prototype.bumpIf=function(t){if(b_(this.message,t,this.offset())){for(var n=0;n<t.length;n++)this.bump();return!0}return!1},e.prototype.bumpUntil=function(t){var n=this.offset(),r=this.message.indexOf(t,n);return r>=0?(this.bumpTo(r),!0):(this.bumpTo(this.message.length),!1)},e.prototype.bumpTo=function(t){if(this.offset()>t)throw Error("targetOffset ".concat(t," must be greater than or equal to the current offset ").concat(this.offset()));for(t=Math.min(t,this.message.length);;){var n=this.offset();if(n===t)break;if(n>t)throw Error("targetOffset ".concat(t," is at invalid UTF-16 code unit boundary"));if(this.bump(),this.isEOF())break}},e.prototype.bumpSpace=function(){for(;!this.isEOF()&&x_(this.char());)this.bump()},e.prototype.peek=function(){if(this.isEOF())return null;var t=this.char(),n=this.offset(),r=this.message.charCodeAt(n+(t>=65536?2:1));return r??null},e}();s(Y1,"_isAlpha");s(TK,"_isAlphaOrSlash");s(xK,"_isPotentialElementNameChar");s(x_,"_isWhiteSpace");s(SK,"_isPa\
tternSyntax")});function K1(e){e.forEach(function(t){if(delete t.location,km(t)||Fm(t))for(var n in t.options)delete t.options[n].location,K1(t.options[n].value);else xm(t)&&Am(t.style)||(Sm(t)||Cm(t))&&Wc(t.style)?delete t.style.location:Rm(t)&&K1(t.children)})}function C_(e,t){t===void 0&&(t={}),t=Wi({shouldParseSkeletons:!0,requiresOtherClause:!0},t);var n=new T_(e,t).parse();if(n.err){var r=SyntaxError(Ge[n.err.kind]);throw r.location=n.err.location,r.originalMessage=n.err.message,r}return t?.captureLocation||K1(n.val),n.val}var X1=y(()=>{l();U1();j1();S_();_m();_m();s(K1,"pruneLocation");s(C_,"parse")});function Im(e,t){var n=t&&t.cache?t.cache:_K,r=t&&t.serializer?t.serializer:AK,a=t&&t.strategy?t.strategy:kK;return a(e,{cache:n,serializer:r})}function CK(e){return e==null||typeof e=="number"||typeof e=="boolean"}function k_(e,t,n,r){var a=CK(r)?r:n(r),o=t.get(a);return typeof o>"u"&&(o=e.call(this,r),t.set(a,o)),o}function F_(e,t,n){var r=Array.prototype.slice.call(arguments,3),a=n(r),o=t.get(a);return typeof o>"u"&&(o=e.apply(this,r),t.set(a,o)),o}function Z1(e,t,n,r,a){return n.bind(t,e,r,a)}function kK(e,t){var n=e.length===1?k_:F_;return Z1(e,this,n,t.cache.create(),t.serializer)}function FK(e,t){return Z1(e,this,F_,t.cache.create(),t.serializer)}function RK(e,t){return Z1(e,this,k_,t.cache.create(),t.serializer)}function J1(){this.cache=Object.create(null)}var AK,_K,Nm,R_=y(()=>{l();s(Im,"memoize");s(CK,"isPrimitive");s(k_,"monadic");s(F_,"variadic");s(Z1,"assemble");s(kK,"strategyDefault");s(FK,"strategyVariadic");s(RK,"strategyMonadic");AK=s(function(){return JSON.stringify(arguments)},
"serializerDefault");s(J1,"ObjectWithoutPrototypeCache");J1.prototype.get=function(e){return this.cache[e]};J1.prototype.set=function(e,t){this.cache[e]=t};_K={create:s(function(){return new J1},"create")},Nm={variadic:FK,monadic:RK}});var Io,Vc,Q1,A_,__,eg=y(()=>{l();B1();(function(e){e.MISSING_VALUE="MISSING_VALUE",e.INVALID_VALUE="INVALID_VALUE",e.MISSING_INTL_API="MISSING_INTL_API"})(Io||(Io={}));Vc=function(e){Hc(t,e);function t(n,r,a){var o=e.call(this,n)||this;return o.code=r,o.originalMessage=a,o}return s(t,"FormatError"),t.prototype.toString=function(){return"[formatjs Error: ".concat(this.code,"] ").concat(this.message)},t}(Error),Q1=function(e){Hc(t,e);function t(n,r,a,o){return e.call(this,'Invalid values for "'.concat(n,'": "').concat(r,'". Options are "').concat(Object.keys(a).join('", "'),'"'),Io.INVALID_VALUE,o)||this}return s(t,"InvalidValueError"),t}(Vc),A_=function(e){Hc(t,e);function t(n,r,a){return e.call(this,'Value for "'.concat(n,'" must be of type ').concat(r),Io.INVALID_VALUE,a)||this}return s(t,"InvalidValueTypeError"),t}(Vc),__=function(e){Hc(t,e);function t(n,r){return e.call(this,'The intl string context variable "'.concat(n,'" was not provided to the string "').concat(r,'"'),Io.MISSING_VALUE,
r)||this}return s(t,"MissingValueError"),t}(Vc)});function IK(e){return e.length<2?e:e.reduce(function(t,n){var r=t[t.length-1];return!r||r.type!==sn.literal||n.type!==sn.literal?t.push(n):r.value+=n.value,t},[])}function NK(e){return typeof e=="function"}function $c(e,t,n,r,a,o,i){if(e.length===1&&q1(e[0]))return[{type:sn.literal,value:e[0].value}];for(var c=[],u=0,d=e;u<d.length;u++){var m=d[u];if(q1(m)){c.push({type:sn.literal,value:m.value});continue}if(JA(m)){typeof o=="number"&&c.push({type:sn.literal,value:n.getNumberFormat(t).format(o)});continue}var p=m.value;if(!(a&&p in a))throw new __(p,i);var h=a[p];if(ZA(m)){(!h||typeof h=="string"||typeof h=="number")&&(h=typeof h=="string"||typeof h=="number"?String(h):""),c.push({type:typeof h=="string"?sn.literal:sn.object,value:h});continue}if(Sm(m)){var f=typeof m.style=="string"?r.date[m.style]:Wc(m.style)?m.style.parsedOptions:void 0;c.push({type:sn.literal,value:n.getDateTimeFormat(t,f).format(h)});continue}if(Cm(m)){var f=typeof m.style=="string"?r.time[m.style]:Wc(m.style)?m.style.
parsedOptions:r.time.medium;c.push({type:sn.literal,value:n.getDateTimeFormat(t,f).format(h)});continue}if(xm(m)){var f=typeof m.style=="string"?r.number[m.style]:Am(m.style)?m.style.parsedOptions:void 0;f&&f.scale&&(h=h*(f.scale||1)),c.push({type:sn.literal,value:n.getNumberFormat(t,f).format(h)});continue}if(Rm(m)){var g=m.children,v=m.value,w=a[v];if(!NK(w))throw new A_(v,"function",i);var E=$c(g,t,n,r,a,o),T=w(E.map(function(F){return F.value}));Array.isArray(T)||(T=[T]),c.push.apply(c,T.map(function(F){return{type:typeof F=="string"?sn.literal:sn.object,value:F}}))}if(km(m)){var S=m.options[h]||m.options.other;if(!S)throw new Q1(m.value,h,Object.keys(m.options),i);c.push.apply(c,$c(S.value,t,n,r,a));continue}if(Fm(m)){var S=m.options["=".concat(h)];if(!S){if(!Intl.PluralRules)throw new Vc(`Intl.PluralRules is not available in this environment.
Try polyfilling it using "@formatjs/intl-pluralrules"
`,Io.MISSING_INTL_API,i);var C=n.getPluralRules(t,{type:m.pluralType}).select(h-(m.offset||0));S=m.options[C]||m.options.other}if(!S)throw new Q1(m.value,h,Object.keys(m.options),i);c.push.apply(c,$c(S.value,t,n,r,a,h-(m.offset||0)));continue}}return IK(c)}var sn,tg=y(()=>{l();X1();eg();(function(e){e[e.literal=0]="literal",e[e.object=1]="object"})(sn||(sn={}));s(IK,"mergeLiteral");s(NK,"isFormatXMLElementFn");s($c,"formatToParts")});function MK(e,t){return t?ir(ir(ir({},e||{}),t||{}),Object.keys(e).reduce(function(n,r){return n[r]=ir(ir({},e[r]),t[r]||{}),n},{})):e}function PK(e,t){return t?Object.keys(e).reduce(function(n,r){return n[r]=MK(e[r],t[r]),n},ir({},e)):e}function ng(e){return{create:function(){return{get:function(t){return e[t]},set:function(t,n){e[t]=n}}}}}function LK(e){return e===void 0&&(e={number:{},dateTime:{},pluralRules:{}}),{getNumberFormat:Im(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.NumberFormat).bind.apply(t,Tm([void 0],n,!1)))},{cache:ng(e.number),strategy:Nm.variadic}),getDateTimeFormat:Im(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.DateTimeFormat).bind.apply(t,Tm([void 0],n,!1)))},{cache:ng(e.dateTime),strategy:Nm.variadic}),getPluralRules:Im(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.PluralRules).bind.apply(t,Tm([void 0],n,!1)))},{cache:ng(e.pluralRules),
strategy:Nm.variadic})}}var I_,rg=y(()=>{l();B1();X1();R_();tg();s(MK,"mergeConfig");s(PK,"mergeConfigs");s(ng,"createFastMemoizeCache");s(LK,"createDefaultFormatters");I_=function(){function e(t,n,r,a){n===void 0&&(n=e.defaultLocale);var o=this;if(this.formatterCache={number:{},dateTime:{},pluralRules:{}},this.format=function(d){var m=o.formatToParts(d);if(m.length===1)return m[0].value;var p=m.reduce(function(h,f){return!h.length||f.type!==sn.literal||typeof h[h.length-1]!="string"?h.push(f.value):h[h.length-1]+=f.value,h},[]);return p.length<=1?p[0]||"":p},this.formatToParts=function(d){return $c(o.ast,o.locales,o.formatters,o.formats,d,void 0,o.message)},this.resolvedOptions=function(){var d;return{locale:((d=o.resolvedLocale)===null||d===void 0?void 0:d.toString())||Intl.NumberFormat.supportedLocalesOf(o.locales)[0]}},this.getAst=function(){return o.ast},this.locales=n,this.resolvedLocale=e.resolveLocale(n),typeof t=="string"){if(this.message=t,!e.__parse)throw new TypeError("Intl\
MessageFormat.__parse must be set to process `message` of type `string`");var i=a||{},c=i.formatters,u=XA(i,["formatters"]);this.ast=e.__parse(t,ir(ir({},u),{locale:this.resolvedLocale}))}else this.ast=t;if(!Array.isArray(this.ast))throw new TypeError("A message must be provided as a String or AST.");this.formats=PK(e.formats,r),this.formatters=a&&a.formatters||LK(this.formatterCache)}return s(e,"IntlMessageFormat"),Object.defineProperty(e,"defaultLocale",{get:function(){return e.memoizedDefaultLocale||(e.memoizedDefaultLocale=new Intl.NumberFormat().resolvedOptions().locale),e.memoizedDefaultLocale},enumerable:!1,configurable:!0}),e.memoizedDefaultLocale=null,e.resolveLocale=function(t){if(!(typeof Intl.Locale>"u")){var n=Intl.NumberFormat.supportedLocalesOf(t);return n.length>0?new Intl.Locale(n[0]):new Intl.Locale(typeof t=="string"?t:t[0])}},e.__parse=C_,e.formats={number:{integer:{maximumFractionDigits:0},currency:{style:"currency"},percent:{style:"percent"}},date:{short:{month:"n\
umeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},e}()});var ag,N_=y(()=>{l();rg();tg();rg();eg();ag=I_});var No,Gi=y(()=>{l();No=s(()=>({resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}}),"createRequire")});var OK,BK,Mo,Yc=y(()=>{l();OK=globalThis.URL,BK=s(e=>e,"fileURLToPath"),Mo={URL:OK,fileURLToPath:BK}});function M_(e){return Mo.fileURLToPath(e.url)}var Po=y(()=>{"use strict";l();Gi();Yc();_a();s(M_,"getModulePath")});function og(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function P_(e){return typeof e=="object"&&e!==null}var L_=y(()=>{"use strict";l();s(og,"isObjectOfUnknownValues");s(P_,"isObjectOrArrayOfUnknownValues")});var O_,B_=y(()=>{l();O_={}});function j_(e,t=new Map){for(let n of e)if(!(n.type===Mm.literal||n.type===Mm.pound)&&(t.set(n.value,n),n.type===Mm.plural))for(let r of Object.values(n.options))j_(r.value,t);return t}function qK(e,t={},n){let r=j_(e.getAst()),a={};for(let[o,i]of r){if(!(o in t))throw new Error(`ICU Message "${n}" contains a value reference ("${o}") that wasn't provided`);let c=t[o];if(i.type!==Mm.number){a[o]=c;continue}if(typeof c!="number")throw new Error(`ICU Message "${n}" contains a numeric reference ("${o}") but provided value was not a number`);i.style==="milliseconds"?a[o]=Math.round(c/10)*10:i.style==="seconds"&&o==="timeInMs"?a[o]=Math.round(c/100)/10:i.style==="bytes"?a[o]=c/1024:a[o]=c}for(let o of Object.keys(t))if(!(o in a)){if(o==="errorCode"){a.errorCode=t.errorCode;continue}throw new Error(`Provided value "${o}" does not match any placeholder in ICU message "${n}"`)}return a}function zK(e){return e.replace(/'/g,"''").replace(/\\{/g,"'{").replace(/\\}/g,"'}")}function sg(e,t,n){e=zK(e);
let r=n==="en-XA"||n==="en-XL"?"de-DE":n,a=ag.IntlMessageFormat||ag,o=new a(e,r,jK,{ignoreTag:!0}),i=qK(o,t,e),c=o.format(i);if(typeof c!="string")throw new Error("unexpected formatted result");return c}function HK(e,t){let r=z_(t)[e.i18nId];return r?sg(r.message,e.values,t):e.formattedDefault}function q_(e){let t=z_(e),n=Object.keys(t).filter(a=>a.startsWith("report/renderer/report-utils.js")),r={};for(let a of n){let{filename:o,key:i}=GK(a);if(!o.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${a}`);r[i]=t[a].message}return r}function $i(e){if(!og(e))return!1;let{i18nId:t,values:n,formattedDefault:r}=e;if(typeof t!="string"||typeof r!="string")return!1;if(n!==void 0){if(!og(n))return!1;for(let a of Object.values(n))if(typeof a!="string"&&typeof a!="number")return!1}return U_.test(t)}function Lo(e,t){if($i(e))return HK(e,t);if(typeof e=="string")return e;throw new Error("Attempted to format invalid icuMessage type")}function WK(e){let t="";for(let n of e)if(/^[a-z]+$/i.
test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function cg(e,t){function n(a,o,i=[]){if(P_(a))for(let[c,u]of Object.entries(a)){let d=i.concat([c]);if($i(u)){let m=Lo(u,t),p=o[u.i18nId]||[],h=WK(d);p.push(u.values?{values:u.values,path:h}:h),a[c]=m,o[u.i18nId]=p}else n(u,o,d)}}s(n,"replaceInObject");let r={};return n(e,r),r}function z_(e){let t=ig[e];if(!t){if(e===Vi)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function H_(){return UK}function W_(){return[...new Set([...Object.keys(ig),Vi])].sort()}function G_(e,t){ig[e]=t}function GK(e){if(!U_.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);let[t,n]=e.split(" | ");return{filename:t,key:n}}var Mm,ig,Vi,UK,U_,jK,ta=y(()=>{"use strict";l();Qr();N_();Po();L_();B_();Mm={literal:0,argument:1,number:2,date:3,time:4,select:5,plural:6,pound:7,tag:8},ig=O_,Vi="en-US",UK=["ar-XB.json","ar.json","bg.json","ca.json","cs.jso\
n","da.json","de.json","el.json","en-GB.json","en-US.json","en-XA.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter(e=>e.endsWith(".json")&&!e.endsWith(".ctc.json")).map(e=>e.replace(".json","")).sort(),U_=/ | [^\s]+$/,jK={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};s(j_,"collectAllCustomElementsFromICU");s(qK,"_preformatValues");s(zK,"escapeIcuMessage");s(sg,"formatMessage");s(HK,"_localizeIcuMessage");s(q_,"getRendererFormattedStrings");s($i,"isIcuMessage");s(Lo,"getFormatted");s(WK,"\
_formatPathAsString");s(cg,"replaceIcuMessages");s(z_,"_getLocaleMessages");s(H_,"getCanonicalLocales");s(W_,"getAvailableLocales");s(G_,"registerLocaleData");s(GK,"getIcuMessageIdParts")});var $_=P((jDe,V_)=>{l();var VK='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',$K={"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.dev/d\
ocumentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).","unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [Lear\
n more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."};V_.exports={id:"amp",title:"AMP",icon:VK,UIStrings:$K}});var K_=P((zDe,Y_)=>{l();var YK='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',KK={"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).","unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect your b\
undles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."};Y_.exports={id:"angular",title:"Angular",icon:YK,UIStrings:KK}});var Z_=P((WDe,X_)=>{l();var XK='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',ZK={"unused-css-rules":"\
Consider removing unused CSS rules and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documentation link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your Drupal site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only enqueue a stylesheet if it is actually used on the page.","unused-javascript":"Consider removing unused JavaScript assets and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documentation \
link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your Drupal site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only enqueue a script if it is actually used on the page.","modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your site.","offscreen-images":"Install [a Drupal module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=\
im_vid_3%3A67&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=%22lazy+load%22&solrsort=iss_project_release_usage+desc&op=Search) that can lazy load images. Such modules provide the ability to defer any offscreen images to improve performance.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) to reduce the size of images loaded on your page. If you are using Views to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.","render-blocking-resources":"Consider using a module to inline critical CSS and JavaScript, and use the defer attribute for non-critical CSS or JavaScript.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page.  Ensure your Drupal site is running at least Drupal 10.1 for improved asset aggregation support.',"unmi\
nified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page.  Ensure your Drupal site is running at least Drupal 10.1 for improved asset aggregation support.',"efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » Development" page. Read about [Drupal cache and optimizing for performance](https://www.drupal.org/docs/7/managing-site-performance-and-scalability/caching-to-improve-performance/caching-overview#s-drupal-performance-resources).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=optimize+images&solrsort=iss_project_release_usage+desc&op=Search) that automatica\
lly optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above) for all images rendered on the site.","uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above). Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","server-response-time":"Themes, modules, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization module, and/or upgrading your server. Your hosting servers should make use of PHP opcode caching, memory-caching to reduce database que\
ry times such as Redis or Memcached, as well as optimized application logic to prepare pages faster.","uses-rel-preconnect":"Preconnect or dns-prefetch resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=dns-prefetch&solrsort=iss_project_release_usage+desc&op=Search) that provides facilities for user agent resource hints.","font-display":"Specify `@font-display` when defining custom fonts in your theme."};X_.exports={id:"drupal",title:"Drupal",icon:XK,UIStrings:ZK}});var Q_=P((VDe,J_)=>{l();var JK='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',QK={"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.","modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/spee\
d) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Critical CSS` and `Script Delay` to defer non-critical JS/CSS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.","uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` to c\
onvert images to WebP.","uses-responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/speed/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.","font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensure t\
ext is user-visible while webfonts are loading."};J_.exports={id:"ezoic",title:"Ezoic",icon:JK,UIStrings:QK}});var tI=P((YDe,eI)=>{l();var eX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',tX={"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).","modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plug\
in-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).","uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component an\
d set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."};eI.exports={id:"gatsby",title:"Gatsby",icon:eX,UIStrings:tX}});var rI=P((XDe,nI)=>{"use strict";l();var nX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l61\
.7 61.4 23.4-24.3-48.6-49.4"/></svg>',rX={"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.","offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that provide\
s the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla extensi\
ons](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the ext\
ension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).","uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider finding \
a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."};nI.exports={id:"joomla",title:"Joomla",icon:nX,UIStrings:rX}});var oI=P((JDe,aI)=>{l();var aX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',oX={"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.","u\
nminified-css":`Enable the "Minify CSS Files" option in your store's Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).`,"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).","uses-rel-prec\
onnect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."};aI.exports={id:"magento",title:"Magento",icon:aX,UIStrings:oX}});var sI=P((eEe,iI)=>{l();var iX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1.8\
6 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',sX={"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/basic-features/script).","unused-javascript":"Use `W\
ebpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)","uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/going-to-production#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/advanced-features/measuring-performance).","prioritize-lcp-image":'\
Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."};iI.exports={id:"next.js",title:"Next.js",icon:iX,UIStrings:sX}});var uI=P((nEe,cI)=>{l();var cX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="142" height="54"><g fill="none" fill-rule="evenodd"><g fill="%231B004E"><path d="M19.486 53.24h-3.891L4.682 39.247v13.936H0V32.946h5.444l9.475 12.398V32.946h4.567zM21.346 32.94h4.647v3.57h-4.647v-3.57Zm0 5.477h4.647V53.18h-4.647V38.417ZM40.569 53.183H36c-3.408 0-4.991-1.625-4.991-4.697v-6.22h-3.777V38.42h3.777v-5.474h4.598v5.474h4.958v3.846h-4.958v4.588c0 1.597.477 2.252 2.197 2.252h2.764v4.077ZM46.688 53.183h-4.57V38.42h4.57v2.308c.31-.686 1.351-2.336 4.425-2.336h3.13v4.56h-4.004c-2.593 0-3.55.967-3.55 3.019v7.212ZM70.612 45.802c0 4.56-3.409 7.75-8.01 7.75s-8.006-3.19-8.006-7.75c0-4.56 3.408-7.755 8.006-7.755 4.598 0 8.01 3.195 8.01 7.755Zm-4.599 0c0-2.14-1.35-3.733-3.408-3.733-2.057 0-3.44 1.594-3.44 3.733 0 2.139 1.41 3.733 3.44 3.733 2.03 0 3.408-1.598 3.408-3.733ZM72.47 32.946h11.7c4.543 0 7.192 2.28 7.192 6.526 0 4.247-2.649 6.577-7.191 6.577h-6.935v7.125h-4.765V32.946Zm4.766 4.218v4\
.676h6.485c1.832 0 2.736-.883 2.736-2.34 0-1.565-.904-2.336-2.736-2.336h-6.485ZM102.662 51.016c-.254.485-1.636 2.48-4.71 2.48-3.665 0-6.627-2.906-6.627-7.694 0-4.789 2.962-7.667 6.656-7.667 2.962 0 4.372 1.851 4.626 2.336v-2.05h4.567v14.762h-4.512v-2.167Zm-3.327-8.932c-2.03 0-3.384 1.594-3.384 3.733 0 2.14 1.354 3.733 3.384 3.733s3.327-1.597 3.327-3.733-1.298-3.733-3.327-3.733ZM119.184 43.578a2.98 2.98 0 0 0-2.749-1.494c-1.918 0-3.13 1.594-3.13 3.733 0 2.14 1.24 3.758 3.158 3.758 1.807 0 2.625-1.168 2.764-1.51h4.4c-.143 2.052-2.116 5.5-7.275 5.5-4.286 0-7.641-3.078-7.641-7.75 0-4.673 3.328-7.755 7.585-7.755 5.159 0 7.105 3.392 7.33 5.53l-4.442-.012ZM129.712 46.6v6.577h-4.567V32.194h4.567v11.998l5.838-5.784h5.751l-6.994 6.811 7.362 7.952h-5.921z"/></g><g fill="%2325F5CE"><path d="M49.159 4.65c12.832 0 23.235 10.41 23.235 23.251h4.648C77.042 12.491 64.558 0 49.159 0c-15.4 0-27.883 12.492-27.883 27.901h4.647c0-12.841 10.403-23.25 23.236-23.25Z"/><path d="M44.852 25.793a3.632 3.632 0 0 1 2\
.6-5.097L63.8 16.951 50.426 27.09a3.626 3.626 0 0 1-5.574-1.296Z"/></g></g></svg>',uX={"unused-css-rules":"Enable [`Reduce Unused CSS`](https://support.nitropack.io/hc/en-us/articles/360020418457-Reduce-Unused-CSS) to remove CSS rules that are not applicable to this page.","modern-image-formats":"Use [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/16547237162513) to automatically convert your images to WebP.","offscreen-images":"Defer offscreen images by enabling [`Automatic Image Lazy Loading`](https://support.nitropack.io/hc/en-us/articles/12457493524369-NitroPack-Lazy-Loading-Feature-for-Images).","render-blocking-resources":"Enable [`Remove render-blocking resources`](https://support.nitropack.io/hc/en-us/articles/13820893500049-How-to-Deal-with-Render-Blocking-Resources-in-NitroPack) in NitroPack for faster initial load times.","unminified-css":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your C\
aching settings to reduce the size of your CSS, HTML, and JavaScript files for faster load times.","unminified-javascript":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your Caching settings to reduce the size of your JS, HTML, and CSS files for faster load times.","unused-javascript":"Configure [`Delayed Scripts`](https://support.nitropack.io/hc/en-us/articles/1500002600942-Delayed-Scripts) in NitroPack to delay loading of scripts until they are needed.","uses-long-cache-ttl":"Go to the [`Improve Server Response Time`](https://support.nitropack.io/hc/en-us/articles/1500002321821-Improve-Server-Response-Time) feature in the `Caching` menu and adjust your page cache expiration time to improve loading times and user experience.","uses-optimized-images":"Automatically compress, optimize, and convert your images into WebP by enabling the [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/14177271695121-How-t\
o-serve-images-in-next-gen-formats-using-NitroPack) setting.","uses-text-compression":"Use [`Gzip compression`](https://support.nitropack.io/hc/en-us/articles/13229297479313-Enabling-GZIP-compression) in NitroPack to reduce the size of the files that are sent to the browser.","uses-responsive-images":"Enable [`Adaptive Image Sizing`](https://support.nitropack.io/hc/en-us/articles/10123833029905-How-to-Enable-Adaptive-Image-Sizing-For-Your-Site) to preemptively optimize your images and make them match the dimensions of the containers they’re displayed in across all devices.","server-response-time":"Improve server response time and optimize perceived performance by activating [`Instant Load`](https://support.nitropack.io/hc/en-us/articles/16547340617361).","dom-size":"Contact your account manager to enable [`HTML Lazy Load`](https://support.nitropack.io/hc/en-us/articles/17144942904337). Configuring it will prioritize and optimize your page rendering performance.","font-display":"Use t\
he [`Override Font Rendering Behavior`](https://support.nitropack.io/hc/en-us/articles/16547358865041) option in NitroPack to set a desired value for the CSS font-display rule."};cI.exports={id:"nitropack",title:"NitroPack",icon:cX,UIStrings:uX}});var dI=P((aEe,lI)=>{l();var lX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 512 512"><path fill="%2300DC82" d="M281.44 397.667h156.88c5.006 0 9.798-1.759 14.133-4.244.336-2.481 8.805-5.596 11.307-9.894 2.502-4.297 4.242-9.173 4.24-14.134-.002-4.962-1.734-9.836-4.24-14.131l-106-182.321c-2.502-4.297-5.559-7.413-9.893-9.894-4.335-2.48-10.542-4.24-15.547-4.24-5.005 0-9.799 1.76-14.133 4.24-4.335 2.481-7.392 5.597-9.894 9.894l-26.853 46.64-53.707-90.457c-2.504-4.296-5.557-8.823-9.893-11.303-4.336-2.481-9.127-2.827-14.133-2.827-5.006 0-9.798.346-14.134 2.827-4.335 2.48-8.802 7.007-11.306 11.303L46.827 355.268c-2.506 4.295-2.8259.169-2.827 14.131-.002 4.961.325 9.836 2.827 14.134 2.502 4.297 6.97 7.413 11.306 9.894 4.336 2.481 9.127 4.24 14.134 4.24H171.2c39.201 0 67.734-17.585 87.627-50.88L306.88 263.4l25.44-43.813 77.733 132.853H306.88l-25.44 45.227ZM169.787 352.44h-69.254l103.174-178.08L256 263.4l-34.639 60.384c-13.21 21.603-28.272 28.656-51.574 28.6\
56Z"/></svg>',dX={"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxt.com/usage/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxt.com/usage/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxt.com/usage/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxt.com/usage/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxt.com/usage/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxt.com/usage/nuxt-img#width-height)."};lI.exports={id:"nuxt",title:"Nuxt",icon:lX,UIStrings:dX}});var pI=P((iEe,mI)=>{l();var mX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',pX={"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the websi\
te. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).","offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the ab\
ility to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.","unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that can\
 speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.","unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the scrip\
t. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.","uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-time":"\
Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."};mI.exports={id:"octobercms",title:"October CMS",icon:mX,UIStrings:pX}});var hI=P((cEe,fI)=>{l();var fX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8\
-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.\
7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',hX={"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unminifi\
ed-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://www.smooth-code.com/open-source/loadable-components/docs/getting-started/).","server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, minimi\
ze usage of the `<Redirect>` component for [route navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)","dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-effe\
cts) only until certain dependencies have changed if you are using the `Effect` hook to improve runtime performance.'};fI.exports={id:"react",title:"React",icon:fX,UIStrings:hX}});var yI=P((lEe,gI)=>{l();var gX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 28"><path fill-rule="evenodd" d="M0 .032s2.796-.356 4.66 1.31C5.81 2.37 6.145 4.008 6.145 4.008L9.952 18.96l3.165-12.239c.309-1.301.864-2.909 1.743-3.997 1.121-1.385 3.398-1.472 3.641-1.472.242 0 2.519.087 3.639 1.472.88 1.088 1.435 2.696 1.744 3.997l3.165 12.239 3.806-14.953s.336-1.638 1.486-2.666C34.205-.324 37 .032 37 .032l-7.289 27.945s-2.404.176-3.607-.446c-1.58-.816-2.332-1.447-3.289-5.249l-.099-.395c-.349-1.399-.883-3.59-1.424-5.813l-.162-.667-.162-.664c-.779-3.198-1.497-6.143-1.612-6.517-.108-.351-.236-1.187-.855-1.187-.607 0-.746.837-.857 1.187-.13.412-.99 3.955-1.856 7.514l-.162.667c-.512 2.107-1.01 4.151-1.341 5.48l-.1.395c-.956 3.802-1.708 4.433-3.288 5.249-1.204.622-3.608.446-3.608.446zM43.998 5v.995L44 5.994v16.628c-.014 3.413-.373 4.17-1.933 4.956-1.213.61-3.067.379-3.067.379V9.332c0-.935.315-1.548 1.477-2.098.693-.329 1.34-.58 2.012-.953C43.54 5.703 43.998 5 43.998\
 5zM46 .125s3.877-.673 5.797 1.107c1.228 1.14 2.602 3.19 2.602 3.19l3.38 4.965c.164.258.378.54.72.54.343 0 .558-.282.722-.54l3.38-4.965s1.374-2.05 2.602-3.19C67.123-.548 71 .125 71 .125l-9.186 13.923 9.161 13.881-.032.004c-.38.045-4.036.423-5.855-1.266-1.229-1.138-2.487-2.992-2.487-2.992l-3.38-4.964c-.164-.26-.379-.54-.721-.54-.343 0-.557.28-.721.54l-3.38 4.964s-1.19 1.854-2.418 2.992c-1.92 1.783-5.957 1.262-5.957 1.262l9.161-13.88zM43.96 0H44c0 1.91-.186 3.042-1.387 3.923-.384.28-1.048.71-1.826.992C39.719 5.304 39 6 39 6c0-3.476.53-4.734 1.95-5.48.865-.452 2.272-.514 2.82-.52z"></path></svg>',yX={"modern-image-formats":"Upload images using `Wix Media Manager` to ensure they are automatically served as WebP. Find [more ways to optimize](https://support.wix.com/en/article/site-performance-optimizing-your-media) your site's media.","render-blocking-resources":"When [adding third-party code](https://support.wix.com/en/article/site-performance-using-third-party-code-on-your-site) in the `C\
ustom Code` tab of your site's dashboard, make sure it's deferred or loaded at the end of the code body. Where possible, use Wix’s [integrations](https://support.wix.com/en/article/about-marketing-integrations) to embed marketing tools on your site. ","efficient-animated-content":"Place videos inside `VideoBoxes`, customize them using `Video Masks` or add `Transparent Videos`. [Learn more](https://support.wix.com/en/article/wix-video-about-wix-video).","unused-javascript":"Review any third-party code you've added to your site in the `Custom Code` tab of your site's dashboard and only keep the services that are necessary to your site. [Find out more](https://support.wix.com/en/article/site-performance-removing-unused-javascript).","server-response-time":"Wix utilizes CDNs and caching to serve responses as fast as possible for most visitors. Consider [manually enabling caching](https://support.wix.com/en/article/site-performance-caching-pages-to-optimize-loading-speed) for your site, e\
specially if using `Velo`."};gI.exports={id:"wix",title:"Wix",icon:gX,UIStrings:yX}});var bI=P((mEe,vI)=>{l();var vX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',bX={"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plugin\
s that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.","offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the number \
of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.","unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may al\
so want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordpres\
s.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.","uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Themes, plugins, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin, and/or upgrading your server."};vI.exports={id:"wordpress",title:"WordPress",icon:vX,UIStrings:bX}});var DI=P((fEe,wI)=>{l();var wX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.306c\
1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L240.\
6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',DX={"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP Roc\
ket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.","render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascript-m\
inify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.","uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":`Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add "dns-prefetch" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds "preconnect" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.`,"uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.","offscreen-images":"Enable\
 [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."};wI.exports={id:"wp-rocket",title:"WP Rocket",icon:wX,UIStrings:DX}});var TI=P((gEe,EI)=>{l();var EX=[$_(),K_(),Z_(),Q_(),tI(),rI(),oI(),sI(),uI(),dI(),pI(),hI(),yI(),bI(),DI()];EI.exports=EX});var SI=P((vEe,xI)=>{l();xI.exports=s(function(t,n){if(typeof t=="string"&&n[t])return t;for(var r=[].concat(t||[]),a=0,o=r.length;a<o;++a)for(var i=r[a].split("-");i.length;){var c=i.join("-");if(n[c])return c;i.pop()}},"lookupClosestLocale")});var Pm,TX,CI,Kc=y(()=>{"use strict";l();Qr();_a();Po();Pm=xt.dirname(""),TX=JSON.parse(`{
  "name": "lighthouse",
  "type": "module",
  "version": "12.1.0",
  "description": "Automated auditing, performance metrics, and best practices for the web.",
  "main": "./core/index.js",
  "bin": {
    "lighthouse": "./cli/index.js",
    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",
    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"
  },
  "engines": {
    "node": ">=18.16"
  },
  "scripts": {
    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",
    "postpack": "yarn clean-types",
    "build-all": "npm-run-posix-or-windows build-all:task",
    "build-all:task": "yarn build-report && yarn build-cdt-lib && yarn build-devtools && concurrently 'yarn build-extension' 'yarn build-lr' 'yarn build-viewer' 'yarn build-treemap' 'yarn build-smokehouse-bundle' && yarn build-pack",
    "build-all:task:windows": "yarn build-report && yarn build-cdt-lib && yarn build-extension && yarn build-devtools && yarn build-lr && yarn build-viewer && yarn build-treemap && yarn build-smokehouse-bundle",
    "build-cdt-lib": "node ./build/build-cdt-lib.js",
    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",
    "build-extension-chrome": "node ./build/build-extension.js chrome",
    "build-extension-firefox": "node ./build/build-extension.js firefox",
    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",
    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",
    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",
    "build-pack": "bash build/build-pack.sh",
    "build-report": "node build/build-report-components.js && node build/build-report.js",
    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",
    "build-treemap": "node ./build/build-treemap.js",
    "build-viewer": "node ./build/build-viewer.js",
    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include='*.d.ts' --include='*.d.cts' --exclude='*.map' --exclude='*.tsbuildinfo'",
    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",
    "c8": "bash core/scripts/c8.sh",
    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",
    "clean-types": "git clean -xfq '*.d.ts' '*.d.cts' -e 'node_modules/' -e 'dist/' -e '.tmp/' -e '**/types/'",
    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",
    "smoke": "node -r source-map-support/register cli/test/smokehouse/frontends/smokehouse-bin.js",
    "debug": "node --inspect-brk ./cli/index.js",
    "start": "yarn build-report --standalone && node ./cli/index.js",
    "mocha": "node --loader=testdouble core/test/scripts/run-mocha-tests.js",
    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",
    "test-bundle": "yarn smoke --runner bundle",
    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",
    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",
    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",
    "test-lantern": "bash core/scripts/test-lantern.sh",
    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",
    "test-docs": "yarn --cwd docs/recipes/ test",
    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",
    "unit-core": "yarn mocha core",
    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",
    "unit-lantern-trace": "INTERNAL_LANTERN_USE_TRACE=1 yarn mocha core/test/computed/metrics core/test/audits",
    "unit-report": "yarn mocha --testMatch report/**/*-test.js",
    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",
    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",
    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",
    "unit": "yarn unit-flow && yarn mocha && yarn unit-lantern-trace",
    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit",
    "unit-lantern-trace:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit-lantern-trace",
    "core-unit": "yarn unit-core",
    "cli-unit": "yarn unit-cli",
    "viewer-unit": "yarn unit-viewer",
    "watch": "yarn unit-core --watch",
    "unit:cicoverage": "yarn c8 --all yarn unit:ci && yarn c8 --all yarn unit-lantern-trace:ci",
    "coverage": "yarn unit:cicoverage && c8 report --reporter html",
    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",
    "devtools": "bash core/scripts/roll-to-devtools.sh",
    "chrome": "node core/scripts/manual-chrome-launcher.js",
    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",
    "deploy-treemap": "yarn build-treemap --deploy",
    "deploy-viewer": "yarn build-viewer --deploy",
    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",
    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",
    "timing-trace": "node core/scripts/generate-timing-trace.js",
    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",
    "type-check": "tsc --build ./tsconfig-all.json",
    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",
    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",
    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",
    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",
    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",
    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",
    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",
    "open-devtools": "bash core/scripts/open-devtools.sh",
    "run-devtools": "node core/scripts/pptr-run-devtools.js",
    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",
    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",
    "computeBenchmarkIndex": "./core/scripts/benchmark.js",
    "save-latest-run": "./core/scripts/save-latest-run.sh",
    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",
    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",
    "static-server": "node cli/test/fixtures/static-server.js",
    "serve-dist": "cd dist && python3 -m http.server 7878",
    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",
    "serve-treemap": "yarn serve-gh-pages",
    "serve-viewer": "yarn serve-gh-pages",
    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js"
  },
  "devDependencies": {
    "@build-tracker/cli": "^1.0.0-beta.15",
    "@esbuild-kit/esm-loader": "^2.1.1",
    "@esbuild-plugins/node-modules-polyfill": "^0.1.4",
    "@formatjs/icu-messageformat-parser": "^2.6.2",
    "@jest/fake-timers": "^28.1.0",
    "@testing-library/preact": "^3.1.1",
    "@testing-library/preact-hooks": "^1.1.0",
    "@types/archiver": "^2.1.2",
    "@types/chrome": "^0.0.154",
    "@types/configstore": "^4.0.0",
    "@types/cpy": "^5.1.0",
    "@types/debug": "^4.1.7",
    "@types/eslint": "^8.2.1",
    "@types/estree": "^0.0.50",
    "@types/gh-pages": "^2.0.0",
    "@types/google.analytics": "0.0.39",
    "@types/jpeg-js": "^0.3.7",
    "@types/jsdom": "^16.2.13",
    "@types/lodash": "^4.14.178",
    "@types/mocha": "^9.0.0",
    "@types/node": "*",
    "@types/pako": "^1.0.1",
    "@types/resize-observer-browser": "^0.1.1",
    "@types/resolve": "^1.20.2",
    "@types/semver": "^5.5.0",
    "@types/tabulator-tables": "^4.9.1",
    "@types/ws": "^7.0.0",
    "@types/yargs": "^17.0.8",
    "@types/yargs-parser": "^20.2.1",
    "@typescript-eslint/eslint-plugin": "^5.48.0",
    "@typescript-eslint/parser": "^5.48.0",
    "acorn": "^8.5.0",
    "angular": "^1.7.4",
    "archiver": "^3.0.0",
    "builtin-modules": "^3.3.0",
    "c8": "^7.11.3",
    "chalk": "^2.4.1",
    "chrome-devtools-frontend": "1.0.1153166",
    "concurrently": "^6.4.0",
    "conventional-changelog-cli": "^2.1.1",
    "cpy": "^8.1.2",
    "cross-env": "^7.0.2",
    "csv-validator": "^0.0.3",
    "es-main": "^1.2.0",
    "esbuild": "0.19.11",
    "eslint": "^8.4.1",
    "eslint-config-google": "^0.14.0",
    "eslint-formatter-codeframe": "^7.32.1",
    "eslint-plugin-import": "^2.25.3",
    "eslint-plugin-local-rules": "1.1.0",
    "event-target-shim": "^6.0.2",
    "expect": "^28.1.0",
    "firebase": "^9.0.2",
    "gh-pages": "^2.0.1",
    "glob": "^7.1.3",
    "idb-keyval": "2.2.0",
    "jest-mock": "^27.3.0",
    "jest-snapshot": "^28.1.0",
    "jsdom": "^12.2.0",
    "lighthouse-plugin-soft-navigation": "^1.0.1",
    "magic-string": "^0.25.7",
    "mime-types": "^2.1.30",
    "mocha": "^10.0.0",
    "node-fetch": "^2.6.1",
    "npm-run-posix-or-windows": "^2.0.2",
    "pako": "^2.0.3",
    "preact": "^10.7.2",
    "pretty-json-stringify": "^0.0.2",
    "puppeteer": "^22.11.1",
    "resolve": "^1.22.1",
    "rollup": "^2.52.7",
    "rollup-plugin-polyfill-node": "^0.12.0",
    "source-map-support": "^0.5.21",
    "tabulator-tables": "^4.9.3",
    "terser": "^5.18.2",
    "testdouble": "^3.18.0",
    "typed-query-selector": "^2.6.1",
    "typescript": "^5.0.4",
    "wait-for-expect": "^3.0.2",
    "webtreemap-cdt": "^3.2.1"
  },
  "dependencies": {
    "@paulirish/trace_engine": "^0.0.23",
    "@sentry/node": "^6.17.4",
    "axe-core": "^4.9.1",
    "chrome-launcher": "^1.1.2",
    "configstore": "^5.0.1",
    "csp_evaluator": "1.1.1",
    "devtools-protocol": "0.0.1312386",
    "enquirer": "^2.3.6",
    "http-link-header": "^1.1.1",
    "intl-messageformat": "^10.5.3",
    "jpeg-js": "^0.4.4",
    "js-library-detector": "^6.7.0",
    "lighthouse-logger": "^2.0.1",
    "lighthouse-stack-packs": "1.12.1",
    "lodash": "^4.17.21",
    "lookup-closest-locale": "6.2.0",
    "metaviewport-parser": "0.3.0",
    "open": "^8.4.0",
    "parse-cache-control": "1.0.1",
    "puppeteer-core": "^22.11.1",
    "robots-parser": "^3.0.1",
    "semver": "^5.3.0",
    "speedline-core": "^1.4.3",
    "third-party-web": "^0.24.3",
    "tldts-icann": "^6.1.16",
    "ws": "^7.0.0",
    "yargs": "^17.3.1",
    "yargs-parser": "^21.0.0"
  },
  "resolutions": {
    "puppeteer/**/devtools-protocol": "0.0.1312386",
    "puppeteer-core/**/devtools-protocol": "0.0.1312386"
  },
  "repository": "GoogleChrome/lighthouse",
  "keywords": [
    "google",
    "chrome",
    "devtools"
  ],
  "author": "Google LLC",
  "license": "Apache-2.0",
  "bugs": {
    "url": "https://github.com/GoogleChrome/lighthouse/issues"
  },
  "homepage": "https://github.com/GoogleChrome/lighthouse#readme"
}
`),CI=TX.version});function Lm(e,t){if(typeof Intl!="object")throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help");let n=Intl.getCanonicalLocales(e),r=Intl.NumberFormat.supportedLocalesOf(n),a=t||W_(),o=Object.fromEntries(a.map(c=>[c,{}])),i=(0,kI.default)(r,o);return i||(Intl.NumberFormat.supportedLocalesOf("es").length===0&&N.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),N.warn("i18n",`locale(s) '${e}' not available. Falling back to default '${Vi}'`)),i||Vi}function D(e,t={}){e.startsWith("file://")&&(e=Mo.fileURLToPath(e)),xt.isAbsolute(e)&&(e=xt.relative(Pm,e));let n={...k,...t};return s((a,o)=>{let i=Object.keys(n).find(m=>n[m]===a);if(!i)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(i in t?e:xt.relative(Pm,M_({url:"\
core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${i}`,values:o,formattedDefault:sg(a,o,Vi)}},"getIcuMessageFn")}function Tr(e){return typeof e=="string"||$i(e)}var kI,k,A=y(()=>{"use strict";l();_a();Yc();kI=Bt(SI(),1);Ae();ta();Kc();ta();Po();k={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnElement:"\
Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};s(Lm,"lookupLocale");s(D,"createIcuMessageFn");s(Tr,"is\
StringOrIcuMessage")});function RI(e){if(!e)return[];let t=[];for(let n of e){let r=lg.find(u=>u.requiredStacks.includes(`${n.detector}:${n.id}`));if(!r)continue;let a=FI.default.find(u=>u.id===r.packId);if(!a){N.warn("StackPacks",`'${r.packId}' stack pack was matched but is not found in stack-packs lib`);continue}let o=D(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),i={},c=a.UIStrings;for(let u in c)c[u]&&(i[u]=o(c[u]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:i})}return t.sort((n,r)=>{let a=lg.findIndex(i=>i.packId===n.id),o=lg.findIndex(i=>i.packId===r.id);return a-o})}var FI,lg,AI=y(()=>{"use strict";l();Ae();FI=Bt(TI(),1);A();lg=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wix",requiredStacks:["js:wix"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"nitropack",requiredStacks:["js:nitropack"]},
{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:@angular/core"]},{packId:"react",requiredStacks:["js:react"]}];s(RI,"getStackPacks")});var dg,It,_I=y(()=>{l();typeof Object.create=="function"?dg=s(function(t,n){t.super_=n,t.prototype=Object.create(n.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})},"inherits"):dg=s(function(t,n){t.super_=n;var r=s(function(){},"TempCtor");r.prototype=n.prototype,t.prototype=new r,t.prototype.constructor=t},"inherits");It=dg});function kX(e){if(!wg(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(Na(arguments[n]));return t.join(" ")}for(var n=1,r=arguments,a=r.length,o=String(e).replace(CX,function(c){if(c==="%%")return"%";if(n>=a)return c;switch(c){case"%s":return String(r[n++]);case"%d":return Number(r[n++]);case"%j":try{return JSON.stringify(r[n++])}catch{return"[Circular]"}default:return c}}),i=r[n];n<a;i=r[++n])bg(i)||!Xc(i)?o+=" "+i:o+=" "+Na(i);return o}function vg(e,t){if(Ia(globalThis.process))return function(){return vg(e,t).apply(this,arguments)};if(an.noDeprecation===!0)return e;var n=!1;function r(){if(!n){if(an.throwDeprecation)throw new Error(t);an.traceDeprecation?console.trace(t):console.error(t),n=!0}return e.apply(this,arguments)}return s(r,"deprecated"),r}function NI(e){if(Ia(mg)&&(mg=an.env.NODE_DEBUG||""),e=e.toUpperCase(),!Om[e])if(new RegExp("\\b"+e+"\\b","i").test(mg)){var t=0;Om[e]=function(){var n=kX.apply(null,arguments);console.error("%s %d: %s",e,t,n)}}else Om[e]=function(){};
return Om[e]}function Na(e,t){var n={seen:[],stylize:RX};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),MI(t)?n.showHidden=t:t&&LX(n,t),Ia(n.showHidden)&&(n.showHidden=!1),Ia(n.depth)&&(n.depth=2),Ia(n.colors)&&(n.colors=!1),Ia(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=FX),Bm(n,e,n.depth)}function FX(e,t){var n=Na.styles[t];return n?"\x1B["+Na.colors[n][0]+"m"+e+"\x1B["+Na.colors[n][1]+"m":e}function RX(e,t){return e}function AX(e){var t={};return e.forEach(function(n,r){t[n]=!0}),t}function Bm(e,t,n){if(e.customInspect&&t&&gg(t.inspect)&&t.inspect!==Na&&!(t.constructor&&t.constructor.prototype===t)){var r=t.inspect(n,e);return wg(r)||(r=Bm(e,r,n)),r}var a=_X(e,t);if(a)return a;var o=Object.keys(t),i=AX(o);if(e.showHidden&&(o=Object.getOwnPropertyNames(t)),hg(t)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return pg(t);if(o.length===0){if(gg(t)){var c=t.name?": "+t.name:"";return e.stylize("[Function"+c+"]","\
special")}if(fg(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(II(t))return e.stylize(Date.prototype.toString.call(t),"date");if(hg(t))return pg(t)}var u="",d=!1,m=["{","}"];if(MX(t)&&(d=!0,m=["[","]"]),gg(t)){var p=t.name?": "+t.name:"";u=" [Function"+p+"]"}if(fg(t)&&(u=" "+RegExp.prototype.toString.call(t)),II(t)&&(u=" "+Date.prototype.toUTCString.call(t)),hg(t)&&(u=" "+pg(t)),o.length===0&&(!d||t.length==0))return m[0]+u+m[1];if(n<0)return fg(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special");e.seen.push(t);var h;return d?h=IX(e,t,n,i,o):h=o.map(function(f){return yg(e,t,n,i,f,d)}),e.seen.pop(),NX(h,u,m)}function _X(e,t){if(Ia(t))return e.stylize("undefined","undefined");if(wg(t)){var n="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(n,"string")}if(PX(t))return e.stylize(""+t,"number");if(MI(t))return e.stylize(""+t,"boolean");if(bg(t))return e.stylize("null","null")}function pg(e){
return"["+Error.prototype.toString.call(e)+"]"}function IX(e,t,n,r,a){for(var o=[],i=0,c=t.length;i<c;++i)PI(t,String(i))?o.push(yg(e,t,n,r,String(i),!0)):o.push("");return a.forEach(function(u){u.match(/^\d+$/)||o.push(yg(e,t,n,r,u,!0))}),o}function yg(e,t,n,r,a,o){var i,c,u;if(u=Object.getOwnPropertyDescriptor(t,a)||{value:t[a]},u.get?u.set?c=e.stylize("[Getter/Setter]","special"):c=e.stylize("[Getter]","special"):u.set&&(c=e.stylize("[Setter]","special")),PI(r,a)||(i="["+a+"]"),c||(e.seen.indexOf(u.value)<0?(bg(n)?c=Bm(e,u.value,null):c=Bm(e,u.value,n-1),c.indexOf(`
`)>-1&&(o?c=c.split(`
`).map(function(d){return"  "+d}).join(`
`).substr(2):c=`
`+c.split(`
`).map(function(d){return"   "+d}).join(`
`))):c=e.stylize("[Circular]","special")),Ia(i)){if(o&&a.match(/^\d+$/))return c;i=JSON.stringify(""+a),i.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(i=i.substr(1,i.length-2),i=e.stylize(i,"name")):(i=i.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),i=e.stylize(i,"string"))}return i+": "+c}function NX(e,t,n){var r=0,a=e.reduce(function(o,i){return r++,i.indexOf(`
`)>=0&&r++,o+i.replace(/\u001b\[\d\d?m/g,"").length+1},0);return a>60?n[0]+(t===""?"":t+`
 `)+" "+e.join(`,
  `)+" "+n[1]:n[0]+t+" "+e.join(", ")+" "+n[1]}function MX(e){return Array.isArray(e)}function MI(e){return typeof e=="boolean"}function bg(e){return e===null}function PX(e){return typeof e=="number"}function wg(e){return typeof e=="string"}function Ia(e){return e===void 0}function fg(e){return Xc(e)&&Dg(e)==="[object RegExp]"}function Xc(e){return typeof e=="object"&&e!==null}function II(e){return Xc(e)&&Dg(e)==="[object Date]"}function hg(e){return Xc(e)&&(Dg(e)==="[object Error]"||e instanceof Error)}function gg(e){return typeof e=="function"}function Dg(e){return Object.prototype.toString.call(e)}function LX(e,t){if(!t||!Xc(t))return e;for(var n=Object.keys(t),r=n.length;r--;)e[n[r]]=t[n[r]];return e}function PI(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function OX(e){if(typeof e!="function")throw new TypeError('The "original" argument must be of type Function');if(Oo&&e[Oo]){var t=e[Oo];if(typeof t!="function")throw new TypeError('The "util.promisify.custom" argument m\
ust be of type Function');return Object.defineProperty(t,Oo,{value:t,enumerable:!1,writable:!1,configurable:!0}),t}function t(){for(var n,r,a=new Promise(function(c,u){n=c,r=u}),o=[],i=0;i<arguments.length;i++)o.push(arguments[i]);o.push(function(c,u){c?r(c):n(u)});try{e.apply(this,o)}catch(c){r(c)}return a}return s(t,"fn"),Object.setPrototypeOf(t,Object.getPrototypeOf(e)),Oo&&Object.defineProperty(t,Oo,{value:t,enumerable:!1,writable:!1,configurable:!0}),Object.defineProperties(t,SX(e))}var SX,CX,Om,mg,Oo,Ma=y(()=>{l();ka();_I();SX=Object.getOwnPropertyDescriptors||s(function(t){for(var n=Object.keys(t),r={},a=0;a<n.length;a++)r[n[a]]=Object.getOwnPropertyDescriptor(t,n[a]);return r},"getOwnPropertyDescriptors"),CX=/%[sdj%]/g;s(kX,"format");s(vg,"deprecate");Om={};s(NI,"debuglog");s(Na,"inspect");Na.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]};
Na.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};s(FX,"stylizeWithColor");s(RX,"stylizeNoColor");s(AX,"arrayToHash");s(Bm,"formatValue");s(_X,"formatPrimitive");s(pg,"formatError");s(IX,"formatArray");s(yg,"formatProperty");s(NX,"reduceToSingleString");s(MX,"isArray");s(MI,"isBoolean");s(bg,"isNull");s(PX,"isNumber");s(wg,"isString");s(Ia,"isUndefined");s(fg,"isRegExp");s(Xc,"isObject");s(II,"isDate");s(hg,"isError");s(gg,"isFunction");s(Dg,"objectToString");s(LX,"_extend");s(PI,"hasOwnProperty");Oo=typeof Symbol<"u"?Symbol("util.promisify.custom"):void 0;s(OX,"promisify");OX.custom=Oo});function Bo(){this.head=null,this.tail=null,this.length=0}var LI,OI=y(()=>{l();Ai();LI=Bo;s(Bo,"BufferList");Bo.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length};Bo.prototype.unshift=function(e){var t={data:e,next:this.head};this.length===0&&(this.tail=t),this.head=t,++this.length};Bo.prototype.shift=function(){if(this.length!==0){var e=this.head.data;return this.length===1?this.head=this.tail=null:this.head=this.head.next,--this.length,e}};Bo.prototype.clear=function(){this.head=this.tail=null,this.length=0};Bo.prototype.join=function(e){if(this.length===0)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n};Bo.prototype.concat=function(e){if(this.length===0)return z.alloc(0);if(this.length===1)return this.head.data;for(var t=z.allocUnsafe(e>>>0),n=this.head,r=0;n;)n.data.copy(t,r),r+=n.data.length,n=n.next;return t}});function UX(e){if(e&&!BX(e))throw new Error("Unknown encoding: "+e)}function Yi(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),UX(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=qX;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=zX;break;default:this.write=jX;return}this.charBuffer=new z(6),this.charReceived=0,this.charLength=0}function jX(e){return e.toString(this.encoding)}function qX(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function zX(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var BX,BI=y(()=>{l();Ai();BX=z.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};s(UX,"assertEncoding");s(Yi,"StringDecoder");Yi.prototype.write=function(e){for(var t="";this.charLength;){
var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,this.charReceived<this.charLength)return"";e=e.slice(n,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var a=t.charCodeAt(t.length-1);if(a>=55296&&a<=56319){this.charLength+=this.surrogateSize,t="";continue}if(this.charReceived=this.charLength=0,e.length===0)return t;break}this.detectIncompleteChar(e);var r=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,r),r-=this.charReceived),t+=e.toString(this.encoding,0,r);var r=t.length-1,a=t.charCodeAt(r);if(a>=55296&&a<=56319){var o=this.surrogateSize;return this.charLength+=o,this.charReceived+=o,this.charBuffer.copy(this.charBuffer,o,0,o),e.copy(this.charBuffer,0,0,o),t.substring(0,r)}return t};Yi.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(t==1&&n>>5==6){this.
charLength=2;break}if(t<=2&&n>>4==14){this.charLength=3;break}if(t<=3&&n>>3==30){this.charLength=4;break}}this.charReceived=t};Yi.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,r=this.charBuffer,a=this.encoding;t+=r.slice(0,n).toString(a)}return t};s(jX,"passThroughWrite");s(qX,"utf16DetectIncompleteChar");s(zX,"base64DetectIncompleteChar")});function HX(e,t,n){if(typeof e.prependListener=="function")return e.prependListener(t,n);!e._events||!e._events[t]?e.on(t,n):Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]}function WX(e,t){return e.listeners(t).length}function zI(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof cn&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.buffer=new LI,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new Yi(e.encoding),this.encoding=e.encoding)}function St(e){if(!(this instanceof St))return new St(
e);this._readableState=new zI(e,this),this.readable=!0,e&&typeof e.read=="function"&&(this._read=e.read),jn.call(this)}function HI(e,t,n,r,a){var o=$X(t,n);if(o)e.emit("error",o);else if(n===null)t.reading=!1,YX(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!a){var i=new Error("stream.push() after EOF");e.emit("error",i)}else if(t.endEmitted&&a){var c=new Error("stream.unshift() after end event");e.emit("error",c)}else{var u;t.decoder&&!a&&!r&&(n=t.decoder.write(n),u=!t.objectMode&&n.length===0),a||(t.reading=!1),u||(t.flowing&&t.length===0&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,a?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&Um(e))),KX(e,t)}else a||(t.reading=!1);return GX(t)}function GX(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||e.length===0)}function VX(e){return e>=UI?e=UI:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function jI(e,t){return e<=0||t.length===0&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&t.
length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=VX(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function $X(e,t){var n=null;return!Buffer.isBuffer(t)&&typeof t!="string"&&t!==null&&t!==void 0&&!e.objectMode&&(n=new TypeError("Invalid non-string/buffer chunk")),n}function YX(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,Um(e)}}function Um(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(mt("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?rn(qI,e):qI(e))}function qI(e){mt("emit readable"),e.emit("readable"),Tg(e)}function KX(e,t){t.readingMore||(t.readingMore=!0,rn(XX,e,t))}function XX(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(mt("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function ZX(e){return function(){var t=e._readableState;mt("pipeOnDrain",t.awaitDrain),t.awaitDrain&&
t.awaitDrain--,t.awaitDrain===0&&e.listeners("data").length&&(t.flowing=!0,Tg(e))}}function JX(e){mt("readable nexttick read 0"),e.read(0)}function QX(e,t){t.resumeScheduled||(t.resumeScheduled=!0,rn(eZ,e,t))}function eZ(e,t){t.reading||(mt("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),Tg(e),t.flowing&&!t.reading&&e.read(0)}function Tg(e){var t=e._readableState;for(mt("flow",t.flowing);t.flowing&&e.read()!==null;);}function WI(e,t){if(t.length===0)return null;var n;return t.objectMode?n=t.buffer.shift():!e||e>=t.length?(t.decoder?n=t.buffer.join(""):t.buffer.length===1?n=t.buffer.head.data:n=t.buffer.concat(t.length),t.buffer.clear()):n=tZ(e,t.buffer,t.decoder),n}function tZ(e,t,n){var r;return e<t.head.data.length?(r=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):e===t.head.data.length?r=t.shift():r=n?nZ(e,t):rZ(e,t),r}function nZ(e,t){var n=t.head,r=1,a=n.data;for(e-=a.length;n=n.next;){var o=n.data,i=e>o.length?o.length:e;if(i===o.length?
a+=o:a+=o.slice(0,e),e-=i,e===0){i===o.length?(++r,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(i));break}++r}return t.length-=r,a}function rZ(e,t){var n=Buffer.allocUnsafe(e),r=t.head,a=1;for(r.data.copy(n),e-=r.data.length;r=r.next;){var o=r.data,i=e>o.length?o.length:e;if(o.copy(n,n.length-e,0,i),e-=i,e===0){i===o.length?(++a,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=o.slice(i));break}++a}return t.length-=a,n}function Eg(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,rn(aZ,t,e))}function aZ(e,t){!e.endEmitted&&e.length===0&&(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function oZ(e,t){for(var n=0,r=e.length;n<r;n++)t(e[n],n)}function GI(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}var mt,UI,xg=y(()=>{"use strict";l();Zr();Ma();OI();BI();Zc();ka();St.ReadableState=zI;mt=NI("stream");It(St,jn);s(HX,"prependListener");s(WX,"listenerCount");s(zI,"Re\
adableState");s(St,"Readable");St.prototype.push=function(e,t){var n=this._readableState;return!n.objectMode&&typeof e=="string"&&(t=t||n.defaultEncoding,t!==n.encoding&&(e=Buffer.from(e,t),t="")),HI(this,n,e,t,!1)};St.prototype.unshift=function(e){var t=this._readableState;return HI(this,t,e,"",!0)};St.prototype.isPaused=function(){return this._readableState.flowing===!1};s(HI,"readableAddChunk");s(GX,"needMoreData");St.prototype.setEncoding=function(e){return this._readableState.decoder=new Yi(e),this._readableState.encoding=e,this};UI=8388608;s(VX,"computeNewHighWaterMark");s(jI,"howMuchToRead");St.prototype.read=function(e){mt("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(e!==0&&(t.emittedReadable=!1),e===0&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return mt("read: emitReadable",t.length,t.ended),t.length===0&&t.ended?Eg(this):Um(this),null;if(e=jI(e,t),e===0&&t.ended)return t.length===0&&Eg(this),null;var r=t.needReadable;mt("need readable",r),(t.length===
0||t.length-e<t.highWaterMark)&&(r=!0,mt("length less than watermark",r)),t.ended||t.reading?(r=!1,mt("reading or ended",r)):r&&(mt("do read"),t.reading=!0,t.sync=!0,t.length===0&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=jI(n,t)));var a;return e>0?a=WI(e,t):a=null,a===null?(t.needReadable=!0,e=0):t.length-=e,t.length===0&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&Eg(this)),a!==null&&this.emit("data",a),a};s($X,"chunkInvalid");s(YX,"onEofChunk");s(Um,"emitReadable");s(qI,"emitReadable_");s(KX,"maybeReadMore");s(XX,"maybeReadMore_");St.prototype._read=function(e){this.emit("error",new Error("not implemented"))};St.prototype.pipe=function(e,t){var n=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e);break}r.pipesCount+=1,mt("pipe count=%d opts=%j",r.pipesCount,t);var a=!t||t.end!==!1,o=a?c:m;r.endEmitted?rn(o):n.once("end",o),e.on("unpipe",i);function i(E){mt("onunpipe"),E===n&&
m()}s(i,"onunpipe");function c(){mt("onend"),e.end()}s(c,"onend");var u=ZX(n);e.on("drain",u);var d=!1;function m(){mt("cleanup"),e.removeListener("close",g),e.removeListener("finish",v),e.removeListener("drain",u),e.removeListener("error",f),e.removeListener("unpipe",i),n.removeListener("end",c),n.removeListener("end",m),n.removeListener("data",h),d=!0,r.awaitDrain&&(!e._writableState||e._writableState.needDrain)&&u()}s(m,"cleanup");var p=!1;n.on("data",h);function h(E){mt("ondata"),p=!1;var T=e.write(E);T===!1&&!p&&((r.pipesCount===1&&r.pipes===e||r.pipesCount>1&&GI(r.pipes,e)!==-1)&&!d&&(mt("false write response, pause",n._readableState.awaitDrain),n._readableState.awaitDrain++,p=!0),n.pause())}s(h,"ondata");function f(E){mt("onerror",E),w(),e.removeListener("error",f),WX(e,"error")===0&&e.emit("error",E)}s(f,"onerror"),HX(e,"error",f);function g(){e.removeListener("finish",v),w()}s(g,"onclose"),e.once("close",g);function v(){mt("onfinish"),e.removeListener("close",g),w()}s(v,"onfin\
ish"),e.once("finish",v);function w(){mt("unpipe"),n.unpipe(e)}return s(w,"unpipe"),e.emit("pipe",n),r.flowing||(mt("pipe resume"),n.resume()),e};s(ZX,"pipeOnDrain");St.prototype.unpipe=function(e){var t=this._readableState;if(t.pipesCount===0)return this;if(t.pipesCount===1)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var n=t.pipes,r=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;a<r;a++)n[a].emit("unpipe",this);return this}var o=GI(t.pipes,e);return o===-1?this:(t.pipes.splice(o,1),t.pipesCount-=1,t.pipesCount===1&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)};St.prototype.on=function(e,t){var n=jn.prototype.on.call(this,e,t);if(e==="data")this._readableState.flowing!==!1&&this.resume();else if(e==="readable"){var r=this._readableState;!r.endEmitted&&!r.readableListening&&(r.readableListening=r.needReadable=!0,r.emittedReadable=!1,r.reading?r.length&&Um(this,r):rn(JX,this))}return n};St.
prototype.addListener=St.prototype.on;s(JX,"nReadingNextTick");St.prototype.resume=function(){var e=this._readableState;return e.flowing||(mt("resume"),e.flowing=!0,QX(this,e)),this};s(QX,"resume");s(eZ,"resume_");St.prototype.pause=function(){return mt("call pause flowing=%j",this._readableState.flowing),this._readableState.flowing!==!1&&(mt("pause"),this._readableState.flowing=!1,this.emit("pause")),this};s(Tg,"flow");St.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(mt("wrapped end"),t.decoder&&!t.ended){var i=t.decoder.end();i&&i.length&&r.push(i)}r.push(null)}),e.on("data",function(i){if(mt("wrapped data"),t.decoder&&(i=t.decoder.write(i)),!(t.objectMode&&i==null)&&!(!t.objectMode&&(!i||!i.length))){var c=r.push(i);c||(n=!0,e.pause())}});for(var a in e)this[a]===void 0&&typeof e[a]=="function"&&(this[a]=function(i){return function(){return e[i].apply(e,arguments)}}(a));var o=["error","close","destroy","pause","resume"];return oZ(o,function(i){
e.on(i,r.emit.bind(r,i))}),r._read=function(i){mt("wrapped _read",i),n&&(n=!1,e.resume())},r};St._fromList=WI;s(WI,"fromList");s(tZ,"fromListPartial");s(nZ,"copyFromBufferString");s(rZ,"copyFromBuffer");s(Eg,"endReadable");s(aZ,"endReadableNT");s(oZ,"forEach");s(GI,"indexOf")});function iZ(){}function sZ(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function Cg(e,t){Object.defineProperty(this,"buffer",{get:vg(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof cn&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=e.decodeStrings===!1;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(o){fZ(t,o)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new ZI(this)}function Vt(e){
if(!(this instanceof Vt)&&!(this instanceof cn))return new Vt(e);this._writableState=new Cg(e,this),this.writable=!0,e&&(typeof e.write=="function"&&(this._write=e.write),typeof e.writev=="function"&&(this._writev=e.writev)),We.call(this)}function cZ(e,t){var n=new Error("write after end");e.emit("error",n),rn(t,n)}function uZ(e,t,n,r){var a=!0,o=!1;return n===null?o=new TypeError("May not write null values to stream"):!z.isBuffer(n)&&typeof n!="string"&&n!==void 0&&!t.objectMode&&(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),rn(r,o),a=!1),a}function lZ(e,t,n){return!e.objectMode&&e.decodeStrings!==!1&&typeof t=="string"&&(t=z.from(t,n)),t}function dZ(e,t,n,r,a){n=lZ(t,n,r),z.isBuffer(n)&&(r="buffer");var o=t.objectMode?1:n.length;t.length+=o;var i=t.length<t.highWaterMark;if(i||(t.needDrain=!0),t.writing||t.corked){var c=t.lastBufferedRequest;t.lastBufferedRequest=new sZ(n,r,a),c?c.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=
1}else Sg(e,t,!1,o,n,r,a);return i}function Sg(e,t,n,r,a,o,i){t.writelen=r,t.writecb=i,t.writing=!0,t.sync=!0,n?e._writev(a,t.onwrite):e._write(a,o,t.onwrite),t.sync=!1}function mZ(e,t,n,r,a){--t.pendingcb,n?rn(a,r):a(r),e._writableState.errorEmitted=!0,e.emit("error",r)}function pZ(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function fZ(e,t){var n=e._writableState,r=n.sync,a=n.writecb;if(pZ(n),t)mZ(e,n,r,t,a);else{var o=KI(n);!o&&!n.corked&&!n.bufferProcessing&&n.bufferedRequest&&YI(e,n),r?rn(VI,e,n,o,a):VI(e,n,o,a)}}function VI(e,t,n,r){n||hZ(e,t),t.pendingcb--,r(),XI(e,t)}function hZ(e,t){t.length===0&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function YI(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,a=new Array(r),o=t.corkedRequestsFree;o.entry=n;for(var i=0;n;)a[i]=n,n=n.next,i+=1;Sg(e,t,!0,t.length,a,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=o.next,o.next=null):
t.corkedRequestsFree=new ZI(t)}else{for(;n;){var c=n.chunk,u=n.encoding,d=n.callback,m=t.objectMode?1:c.length;if(Sg(e,t,!1,m,c,u,d),n=n.next,t.writing)break}n===null&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function KI(e){return e.ending&&e.length===0&&e.bufferedRequest===null&&!e.finished&&!e.writing}function $I(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function XI(e,t){var n=KI(t);return n&&(t.pendingcb===0?($I(e,t),t.finished=!0,e.emit("finish")):$I(e,t)),n}function gZ(e,t,n){t.ending=!0,XI(e,t),n&&(t.finished?rn(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function ZI(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var r=t.entry;for(t.entry=null;r;){var a=r.callback;e.pendingcb--,a(n),r=r.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}var kg=y(()=>{l();Ma();Ai();Zr();Zc();ka();Vt.WritableState=Cg;It(Vt,We);s(iZ,"nop");s(sZ,"WriteReq");s(Cg,"WritableState");
Cg.prototype.getBuffer=s(function(){for(var t=this.bufferedRequest,n=[];t;)n.push(t),t=t.next;return n},"writableStateGetBuffer");s(Vt,"Writable");Vt.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))};s(cZ,"writeAfterEnd");s(uZ,"validChunk");Vt.prototype.write=function(e,t,n){var r=this._writableState,a=!1;return typeof t=="function"&&(n=t,t=null),z.isBuffer(e)?t="buffer":t||(t=r.defaultEncoding),typeof n!="function"&&(n=iZ),r.ended?cZ(this,n):uZ(this,r,e,n)&&(r.pendingcb++,a=dZ(this,r,e,t,n)),a};Vt.prototype.cork=function(){var e=this._writableState;e.corked++};Vt.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,!e.writing&&!e.corked&&!e.finished&&!e.bufferProcessing&&e.bufferedRequest&&YI(this,e))};Vt.prototype.setDefaultEncoding=s(function(t){if(typeof t=="string"&&(t=t.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((t+"").toLowerCase())>-1))throw new TypeError(
"Unknown encoding: "+t);return this._writableState.defaultEncoding=t,this},"setDefaultEncoding");s(lZ,"decodeChunk");s(dZ,"writeOrBuffer");s(Sg,"doWrite");s(mZ,"onwriteError");s(pZ,"onwriteStateUpdate");s(fZ,"onwrite");s(VI,"afterWrite");s(hZ,"onwriteDrain");s(YI,"clearBuffer");Vt.prototype._write=function(e,t,n){n(new Error("not implemented"))};Vt.prototype._writev=null;Vt.prototype.end=function(e,t,n){var r=this._writableState;typeof e=="function"?(n=e,e=null,t=null):typeof t=="function"&&(n=t,t=null),e!=null&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),!r.ending&&!r.finished&&gZ(this,r,n)};s(KI,"needFinish");s($I,"prefinish");s(XI,"finishMaybe");s(gZ,"endWritable");s(ZI,"CorkedRequest")});function cn(e){if(!(this instanceof cn))return new cn(e);St.call(this,e),Vt.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),this.once("end",yZ)}function yZ(){this.allowHalfOpen||this._writableState.ended||rn(vZ,this)}function vZ(e){e.end()}var JI,qm,jm,Zc=y(()=>{l();Ma();ka();xg();kg();It(cn,St);JI=Object.keys(Vt.prototype);for(jm=0;jm<JI.length;jm++)qm=JI[jm],cn.prototype[qm]||(cn.prototype[qm]=Vt.prototype[qm]);s(cn,"Duplex");s(yZ,"onend");s(vZ,"onEndNT")});function bZ(e){this.afterTransform=function(t,n){return wZ(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function wZ(e,t,n){var r=e._transformState;r.transforming=!1;var a=r.writecb;if(!a)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,n!=null&&e.push(n),a(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark)}function bn(e){if(!(this instanceof bn))return new bn(e);cn.call(this,e),this._transformState=new bZ(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&(typeof e.transform=="function"&&(this._transform=e.transform),typeof e.flush=="function"&&(this._flush=e.flush)),this.once("prefinish",function(){typeof this._flush=="function"?this._flush(function(n){QI(t,n)}):QI(t)})}function QI(e,t){if(t)return e.emit("error",t);var n=e._writableState,r=e._transformState;if(n.length)throw new Error(
"Calling transform done when ws.length != 0");if(r.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}var Fg=y(()=>{l();Zc();Ma();It(bn,cn);s(bZ,"TransformState");s(wZ,"afterTransform");s(bn,"Transform");bn.prototype.push=function(e,t){return this._transformState.needTransform=!1,cn.prototype.push.call(this,e,t)};bn.prototype._transform=function(e,t,n){throw new Error("Not implemented")};bn.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}};bn.prototype._read=function(e){var t=this._transformState;t.writechunk!==null&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0};s(QI,"done")});function Ki(e){if(!(this instanceof Ki))return new Ki(e);bn.call(this,e)}var eN=y(()=>{l();Fg();Ma();It(Ki,bn);s(Ki,"PassThrough");Ki.prototype._transform=function(e,t,n){n(null,e)}});function xr(){jn.call(this)}var Rg,Ag=y(()=>{l();Zr();Ma();Zc();xg();kg();Fg();eN();It(xr,jn);xr.Readable=St;xr.Writable=Vt;xr.Duplex=cn;xr.Transform=bn;xr.PassThrough=Ki;xr.Stream=xr;Rg=xr;s(xr,"Stream");xr.prototype.pipe=function(e,t){var n=this;function r(m){e.writable&&e.write(m)===!1&&n.pause&&n.pause()}s(r,"ondata"),n.on("data",r);function a(){n.readable&&n.resume&&n.resume()}s(a,"ondrain"),e.on("drain",a),!e._isStdio&&(!t||t.end!==!1)&&(n.on("end",i),n.on("close",c));var o=!1;function i(){o||(o=!0,e.end())}s(i,"onend");function c(){o||(o=!0,typeof e.destroy=="function"&&e.destroy())}s(c,"onclose");function u(m){if(d(),jn.listenerCount(this,"error")===0)throw m}s(u,"onerror"),n.on("error",u),e.on("error",u);function d(){n.removeListener("data",r),e.removeListener("drain",a),n.removeListener("end",i),n.removeListener("close",c),n.removeListener("error",u),e.removeListener("error",u),n.removeListener("end",d),n.removeListener("close",d),e.removeListener("close",d)}return s(d,"clean\
up"),n.on("end",d),n.on("close",d),e.on("close",d),e.emit("pipe",n),e}});var zm,_g=y(()=>{l();zm={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}});function DZ(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}var tN,nN=y(()=>{l();s(DZ,"ZStream");tN=DZ});function Xi(e,t,n,r,a){if(t.subarray&&e.subarray){e.set(t.subarray(n,n+r),a);return}for(var o=0;o<r;o++)e[a+o]=t[n+o]}var Ig,na,Ng=y(()=>{"use strict";l();s(Xi,"arraySet");Ig=Uint8Array,na=Uint16Array});function Ji(e){for(var t=e.length;--t>=0;)e[t]=0}function Pg(e,t,n,r,a){this.static_tree=e,this.extra_bits=t,this.extra_base=n,this.elems=r,this.max_length=a,this.has_stree=e&&e.length}function Lg(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function bN(e){return e<256?eu[e]:eu[256+(e>>>7)]}function nu(e,t){e.pending_buf[e.pending++]=t&255,e.pending_buf[e.pending++]=t>>>8&255}function kn(e,t,n){e.bi_valid>Mg-n?(e.bi_buf|=t<<e.bi_valid&65535,nu(e,e.bi_buf),e.bi_buf=t>>Mg-e.bi_valid,e.bi_valid+=n-Mg):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=n)}function Sr(e,t,n){kn(e,n[t*2],n[t*2+1])}function wN(e,t){var n=0;do n|=e&1,e>>>=1,n<<=1;while(--t>0);return n>>>1}function _Z(e){e.bi_valid===16?(nu(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=e.bi_buf&255,e.bi_buf>>=8,e.bi_valid-=8)}function IZ(e,t){var n=t.dyn_tree,r=t.max_code,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,i=t.stat_desc.extra_bits,c=t.stat_desc.extra_base,u=t.stat_desc.max_length,
d,m,p,h,f,g,v=0;for(h=0;h<=Uo;h++)e.bl_count[h]=0;for(n[e.heap[e.heap_max]*2+1]=0,d=e.heap_max+1;d<dN;d++)m=e.heap[d],h=n[n[m*2+1]*2+1]+1,h>u&&(h=u,v++),n[m*2+1]=h,!(m>r)&&(e.bl_count[h]++,f=0,m>=c&&(f=i[m-c]),g=n[m*2],e.opt_len+=g*(h+f),o&&(e.static_len+=g*(a[m*2+1]+f)));if(v!==0){do{for(h=u-1;e.bl_count[h]===0;)h--;e.bl_count[h]--,e.bl_count[h+1]+=2,e.bl_count[u]--,v-=2}while(v>0);for(h=u;h!==0;h--)for(m=e.bl_count[h];m!==0;)p=e.heap[--d],!(p>r)&&(n[p*2+1]!==h&&(e.opt_len+=(h-n[p*2+1])*n[p*2],n[p*2+1]=h),m--)}}function DN(e,t,n){var r=new Array(Uo+1),a=0,o,i;for(o=1;o<=Uo;o++)r[o]=a=a+n[o-1]<<1;for(i=0;i<=t;i++){var c=e[i*2+1];c!==0&&(e[i*2]=wN(r[c]++,c))}}function NZ(){var e,t,n,r,a,o=new Array(Uo+1);for(n=0,r=0;r<jg-1;r++)for(Hg[r]=n,e=0;e<1<<Bg[r];e++)tu[n++]=r;for(tu[n-1]=r,a=0,r=0;r<16;r++)for(Wm[r]=a,e=0;e<1<<Hm[r];e++)eu[a++]=r;for(a>>=7;r<Zi;r++)for(Wm[r]=a<<7,e=0;e<1<<Hm[r]-7;e++)eu[256+a++]=r;for(t=0;t<=Uo;t++)o[t]=0;for(e=0;e<=143;)ra[e*2+1]=8,e++,o[8]++;for(;e<=255;)ra[e*
2+1]=9,e++,o[9]++;for(;e<=279;)ra[e*2+1]=7,e++,o[7]++;for(;e<=287;)ra[e*2+1]=8,e++,o[8]++;for(DN(ra,Qc+1,o),e=0;e<Zi;e++)Jc[e*2+1]=5,Jc[e*2]=wN(e,5);gN=new Pg(ra,Bg,ru+1,Qc,Uo),yN=new Pg(Jc,Hm,0,Zi,Uo),vN=new Pg(new Array(0),RZ,0,qg,FZ)}function EN(e){var t;for(t=0;t<Qc;t++)e.dyn_ltree[t*2]=0;for(t=0;t<Zi;t++)e.dyn_dtree[t*2]=0;for(t=0;t<qg;t++)e.bl_tree[t*2]=0;e.dyn_ltree[zg*2]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function TN(e){e.bi_valid>8?nu(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function MZ(e,t,n,r){TN(e),r&&(nu(e,n),nu(e,~n)),Xi(e.pending_buf,e.window,t,n,e.pending),e.pending+=n}function oN(e,t,n,r){var a=t*2,o=n*2;return e[a]<e[o]||e[a]===e[o]&&r[t]<=r[n]}function Og(e,t,n){for(var r=e.heap[n],a=n<<1;a<=e.heap_len&&(a<e.heap_len&&oN(t,e.heap[a+1],e.heap[a],e.depth)&&a++,!oN(t,r,e.heap[a],e.depth));)e.heap[n]=e.heap[a],n=a,a<<=1;e.heap[n]=r}function iN(e,t,n){var r,a,o=0,i,c;if(e.last_lit!==0)do r=e.pending_buf[e.d_buf+
o*2]<<8|e.pending_buf[e.d_buf+o*2+1],a=e.pending_buf[e.l_buf+o],o++,r===0?Sr(e,a,t):(i=tu[a],Sr(e,i+ru+1,t),c=Bg[i],c!==0&&(a-=Hg[i],kn(e,a,c)),r--,i=bN(r),Sr(e,i,n),c=Hm[i],c!==0&&(r-=Wm[i],kn(e,r,c)));while(o<e.last_lit);Sr(e,zg,t)}function Ug(e,t){var n=t.dyn_tree,r=t.stat_desc.static_tree,a=t.stat_desc.has_stree,o=t.stat_desc.elems,i,c,u=-1,d;for(e.heap_len=0,e.heap_max=dN,i=0;i<o;i++)n[i*2]!==0?(e.heap[++e.heap_len]=u=i,e.depth[i]=0):n[i*2+1]=0;for(;e.heap_len<2;)d=e.heap[++e.heap_len]=u<2?++u:0,n[d*2]=1,e.depth[d]=0,e.opt_len--,a&&(e.static_len-=r[d*2+1]);for(t.max_code=u,i=e.heap_len>>1;i>=1;i--)Og(e,n,i);d=o;do i=e.heap[1],e.heap[1]=e.heap[e.heap_len--],Og(e,n,1),c=e.heap[1],e.heap[--e.heap_max]=i,e.heap[--e.heap_max]=c,n[d*2]=n[i*2]+n[c*2],e.depth[d]=(e.depth[i]>=e.depth[c]?e.depth[i]:e.depth[c])+1,n[i*2+1]=n[c*2+1]=d,e.heap[1]=d++,Og(e,n,1);while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],IZ(e,t),DN(n,u,e.bl_count)}function sN(e,t,n){var r,a=-1,o,i=t[0*2+1],c=0,u=7,d=4;for(i===
0&&(u=138,d=3),t[(n+1)*2+1]=65535,r=0;r<=n;r++)o=i,i=t[(r+1)*2+1],!(++c<u&&o===i)&&(c<d?e.bl_tree[o*2]+=c:o!==0?(o!==a&&e.bl_tree[o*2]++,e.bl_tree[mN*2]++):c<=10?e.bl_tree[pN*2]++:e.bl_tree[fN*2]++,c=0,a=o,i===0?(u=138,d=3):o===i?(u=6,d=3):(u=7,d=4))}function cN(e,t,n){var r,a=-1,o,i=t[0*2+1],c=0,u=7,d=4;for(i===0&&(u=138,d=3),r=0;r<=n;r++)if(o=i,i=t[(r+1)*2+1],!(++c<u&&o===i)){if(c<d)do Sr(e,o,e.bl_tree);while(--c!==0);else o!==0?(o!==a&&(Sr(e,o,e.bl_tree),c--),Sr(e,mN,e.bl_tree),kn(e,c-3,2)):c<=10?(Sr(e,pN,e.bl_tree),kn(e,c-3,3)):(Sr(e,fN,e.bl_tree),kn(e,c-11,7));c=0,a=o,i===0?(u=138,d=3):o===i?(u=6,d=3):(u=7,d=4)}}function PZ(e){var t;for(sN(e,e.dyn_ltree,e.l_desc.max_code),sN(e,e.dyn_dtree,e.d_desc.max_code),Ug(e,e.bl_desc),t=qg-1;t>=3&&e.bl_tree[hN[t]*2+1]===0;t--);return e.opt_len+=3*(t+1)+5+5+4,t}function LZ(e,t,n,r){var a;for(kn(e,t-257,5),kn(e,n-1,5),kn(e,r-4,4),a=0;a<r;a++)kn(e,e.bl_tree[hN[a]*2+1],3);cN(e,e.dyn_ltree,t-1),cN(e,e.dyn_dtree,n-1)}function OZ(e){var t=4093624447,
n;for(n=0;n<=31;n++,t>>>=1)if(t&1&&e.dyn_ltree[n*2]!==0)return rN;if(e.dyn_ltree[9*2]!==0||e.dyn_ltree[10*2]!==0||e.dyn_ltree[13*2]!==0)return aN;for(n=32;n<ru;n++)if(e.dyn_ltree[n*2]!==0)return aN;return rN}function xN(e){uN||(NZ(),uN=!0),e.l_desc=new Lg(e.dyn_ltree,gN),e.d_desc=new Lg(e.dyn_dtree,yN),e.bl_desc=new Lg(e.bl_tree,vN),e.bi_buf=0,e.bi_valid=0,EN(e)}function Wg(e,t,n,r){kn(e,(xZ<<1)+(r?1:0),3),MZ(e,t,n,!0)}function SN(e){kn(e,lN<<1,3),Sr(e,zg,ra),_Z(e)}function CN(e,t,n,r){var a,o,i=0;e.level>0?(e.strm.data_type===TZ&&(e.strm.data_type=OZ(e)),Ug(e,e.l_desc),Ug(e,e.d_desc),i=PZ(e),a=e.opt_len+3+7>>>3,o=e.static_len+3+7>>>3,o<=a&&(a=o)):a=o=n+5,n+4<=a&&t!==-1?Wg(e,t,n,r):e.strategy===EZ||o===a?(kn(e,(lN<<1)+(r?1:0),3),iN(e,ra,Jc)):(kn(e,(SZ<<1)+(r?1:0),3),LZ(e,e.l_desc.max_code+1,e.d_desc.max_code+1,i+1),iN(e,e.dyn_ltree,e.dyn_dtree)),EN(e),r&&TN(e)}function aa(e,t,n){return e.pending_buf[e.d_buf+e.last_lit*2]=t>>>8&255,e.pending_buf[e.d_buf+e.last_lit*2+1]=t&255,e.pending_buf[e.
l_buf+e.last_lit]=n&255,e.last_lit++,t===0?e.dyn_ltree[n*2]++:(e.matches++,t--,e.dyn_ltree[(tu[n]+ru+1)*2]++,e.dyn_dtree[bN(t)*2]++),e.last_lit===e.lit_bufsize-1}var EZ,rN,aN,TZ,xZ,lN,SZ,CZ,kZ,jg,ru,Qc,Zi,qg,dN,Uo,Mg,FZ,zg,mN,pN,fN,Bg,Hm,RZ,hN,AZ,ra,Jc,eu,tu,Hg,Wm,gN,yN,vN,uN,kN=y(()=>{"use strict";l();Ng();EZ=4,rN=0,aN=1,TZ=2;s(Ji,"zero");xZ=0,lN=1,SZ=2,CZ=3,kZ=258,jg=29,ru=256,Qc=ru+1+jg,Zi=30,qg=19,dN=2*Qc+1,Uo=15,Mg=16,FZ=7,zg=256,mN=16,pN=17,fN=18,Bg=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],Hm=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],RZ=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],hN=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],AZ=512,ra=new Array((Qc+2)*2);Ji(ra);Jc=new Array(Zi*2);Ji(Jc);eu=new Array(AZ);Ji(eu);tu=new Array(kZ-CZ+1);Ji(tu);Hg=new Array(jg);Ji(Hg);Wm=new Array(Zi);Ji(Wm);s(Pg,"StaticTreeDesc");s(Lg,"TreeDesc");s(bN,"d_code");s(nu,"put_short");s(kn,"send_bits");s(Sr,"send_code");s(wN,"bi_reverse");s(_Z,"bi_flush");s(IZ,
"gen_bitlen");s(DN,"gen_codes");s(NZ,"tr_static_init");s(EN,"init_block");s(TN,"bi_windup");s(MZ,"copy_block");s(oN,"smaller");s(Og,"pqdownheap");s(iN,"compress_block");s(Ug,"build_tree");s(sN,"scan_tree");s(cN,"send_tree");s(PZ,"build_bl_tree");s(LZ,"send_all_trees");s(OZ,"detect_data_type");uN=!1;s(xN,"_tr_init");s(Wg,"_tr_stored_block");s(SN,"_tr_align");s(CN,"_tr_flush_block");s(aa,"_tr_tally")});function BZ(e,t,n,r){for(var a=e&65535|0,o=e>>>16&65535|0,i=0;n!==0;){i=n>2e3?2e3:n,n-=i;do a=a+t[r++]|0,o=o+a|0;while(--i);a%=65521,o%=65521}return a|o<<16|0}var FN,RN=y(()=>{l();s(BZ,"adler32");FN=BZ});function UZ(){for(var e,t=[],n=0;n<256;n++){e=n;for(var r=0;r<8;r++)e=e&1?3988292384^e>>>1:e>>>1;t[n]=e}return t}function qZ(e,t,n,r){var a=jZ,o=r+n;e^=-1;for(var i=r;i<o;i++)e=e>>>8^a[(e^t[i])&255];return e^-1}var jZ,oa,AN=y(()=>{l();s(UZ,"makeTable");jZ=UZ();s(qZ,"crc32");oa=qZ});function Ba(e,t){return e.msg=zm[t],t}function NN(e){return(e<<1)-(e>4?9:0)}function jo(e){for(var t=e.length;--t>=0;)e[t]=0}function Pa(e){var t=e.state,n=t.pending;n>e.avail_out&&(n=e.avail_out),n!==0&&(Xi(e.output,t.pending_buf,t.pending_out,n,e.next_out),e.next_out+=n,t.pending_out+=n,e.total_out+=n,e.avail_out-=n,t.pending-=n,t.pending===0&&(t.pending_out=0))}function Qt(e,t){CN(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,Pa(e.strm)}function at(e,t){e.pending_buf[e.pending++]=t}function au(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=t&255}function oJ(e,t,n,r){var a=e.avail_in;return a>r&&(a=r),a===0?0:(e.avail_in-=a,Xi(t,e.input,e.next_in,a,n),e.state.wrap===1?e.adler=FN(e.adler,t,a,n):e.state.wrap===2&&(e.adler=oa(e.adler,t,a,n)),e.next_in+=a,e.total_in+=a,a)}function MN(e,t){var n=e.max_chain_length,r=e.strstart,a,o,i=e.prev_length,c=e.nice_match,u=e.strstart>e.w_size-sr?e.strstart-(e.w_size-sr):0,d=e.window,m=e.
w_mask,p=e.prev,h=e.strstart+Oa,f=d[r+i-1],g=d[r+i];e.prev_length>=e.good_match&&(n>>=2),c>e.lookahead&&(c=e.lookahead);do if(a=t,!(d[a+i]!==g||d[a+i-1]!==f||d[a]!==d[r]||d[++a]!==d[r+1])){r+=2,a++;do;while(d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&d[++r]===d[++a]&&r<h);if(o=Oa-(h-r),r=h-Oa,o>i){if(e.match_start=t,i=o,o>=c)break;f=d[r+i-1],g=d[r+i]}}while((t=p[t&m])>u&&--n!==0);return i<=e.lookahead?i:e.lookahead}function su(e){var t=e.w_size,n,r,a,o,i;do{if(o=e.window_size-e.lookahead-e.strstart,e.strstart>=t+(t-sr)){Xi(e.window,e.window,t,t,0),e.match_start-=t,e.strstart-=t,e.block_start-=t,r=e.hash_size,n=r;do a=e.head[--n],e.head[n]=a>=t?a-t:0;while(--r);r=t,n=r;do a=e.prev[--n],e.prev[n]=a>=t?a-t:0;while(--r);o+=t}if(e.strm.avail_in===0)break;if(r=oJ(e.strm,e.window,e.strstart+e.lookahead,o),e.lookahead+=r,e.lookahead+e.insert>=lt)for(i=e.strstart-e.insert,e.ins_h=e.window[i],e.ins_h=(e.ins_h<<e.hash_shift^
e.window[i+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[i+lt-1])&e.hash_mask,e.prev[i&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=i,i++,e.insert--,!(e.lookahead+e.insert<lt)););}while(e.lookahead<sr&&e.strm.avail_in!==0)}function iJ(e,t){var n=65535;for(n>e.pending_buf_size-5&&(n=e.pending_buf_size-5);;){if(e.lookahead<=1){if(su(e),e.lookahead===0&&t===Ho)return qt;if(e.lookahead===0)break}e.strstart+=e.lookahead,e.lookahead=0;var r=e.block_start+n;if((e.strstart===0||e.strstart>=r)&&(e.lookahead=e.strstart-r,e.strstart=r,Qt(e,!1),e.strm.avail_out===0)||e.strstart-e.block_start>=e.w_size-sr&&(Qt(e,!1),e.strm.avail_out===0))return qt}return e.insert=0,t===Ua?(Qt(e,!0),e.strm.avail_out===0?zo:ts):(e.strstart>e.block_start&&(Qt(e,!1),e.strm.avail_out===0),qt)}function Vg(e,t){for(var n,r;;){if(e.lookahead<sr){if(su(e),e.lookahead<sr&&t===Ho)return qt;if(e.lookahead===0)break}if(n=0,e.lookahead>=lt&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+lt-1])&e.hash_mask,
n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),n!==0&&e.strstart-n<=e.w_size-sr&&(e.match_length=MN(e,n)),e.match_length>=lt)if(r=aa(e,e.strstart-e.match_start,e.match_length-lt),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=lt){e.match_length--;do e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+lt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart;while(--e.match_length!==0);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else r=aa(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(r&&(Qt(e,!1),e.strm.avail_out===0))return qt}return e.insert=e.strstart<lt-1?e.strstart:lt-1,t===Ua?(Qt(e,!0),e.strm.avail_out===0?zo:ts):e.last_lit&&(Qt(e,!1),e.strm.avail_out===0)?qt:iu}function Qi(e,t){for(var n,r,a;;){if(e.lookahead<sr){if(su(e),e.lookahead<sr&&t===Ho)return qt;if(e.
lookahead===0)break}if(n=0,e.lookahead>=lt&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+lt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=lt-1,n!==0&&e.prev_length<e.max_lazy_match&&e.strstart-n<=e.w_size-sr&&(e.match_length=MN(e,n),e.match_length<=5&&(e.strategy===VZ||e.match_length===lt&&e.strstart-e.match_start>4096)&&(e.match_length=lt-1)),e.prev_length>=lt&&e.match_length<=e.prev_length){a=e.strstart+e.lookahead-lt,r=aa(e,e.strstart-1-e.prev_match,e.prev_length-lt),e.lookahead-=e.prev_length-1,e.prev_length-=2;do++e.strstart<=a&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+lt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart);while(--e.prev_length!==0);if(e.match_available=0,e.match_length=lt-1,e.strstart++,r&&(Qt(e,!1),e.strm.avail_out===0))return qt}else if(e.match_available){if(r=aa(e,0,e.window[e.strstart-1]),r&&
Qt(e,!1),e.strstart++,e.lookahead--,e.strm.avail_out===0)return qt}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(r=aa(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<lt-1?e.strstart:lt-1,t===Ua?(Qt(e,!0),e.strm.avail_out===0?zo:ts):e.last_lit&&(Qt(e,!1),e.strm.avail_out===0)?qt:iu}function sJ(e,t){for(var n,r,a,o,i=e.window;;){if(e.lookahead<=Oa){if(su(e),e.lookahead<=Oa&&t===Ho)return qt;if(e.lookahead===0)break}if(e.match_length=0,e.lookahead>=lt&&e.strstart>0&&(a=e.strstart-1,r=i[a],r===i[++a]&&r===i[++a]&&r===i[++a])){o=e.strstart+Oa;do;while(r===i[++a]&&r===i[++a]&&r===i[++a]&&r===i[++a]&&r===i[++a]&&r===i[++a]&&r===i[++a]&&r===i[++a]&&a<o);e.match_length=Oa-(o-a),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=lt?(n=aa(e,1,e.match_length-lt),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(n=aa(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),n&&(Qt(e,!1),e.strm.avail_out===
0))return qt}return e.insert=0,t===Ua?(Qt(e,!0),e.strm.avail_out===0?zo:ts):e.last_lit&&(Qt(e,!1),e.strm.avail_out===0)?qt:iu}function cJ(e,t){for(var n;;){if(e.lookahead===0&&(su(e),e.lookahead===0)){if(t===Ho)return qt;break}if(e.match_length=0,n=aa(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,n&&(Qt(e,!1),e.strm.avail_out===0))return qt}return e.insert=0,t===Ua?(Qt(e,!0),e.strm.avail_out===0?zo:ts):e.last_lit&&(Qt(e,!1),e.strm.avail_out===0)?qt:iu}function Cr(e,t,n,r,a){this.good_length=e,this.max_lazy=t,this.nice_length=n,this.max_chain=r,this.func=a}function uJ(e){e.window_size=2*e.w_size,jo(e.head),e.max_lazy_match=es[e.level].max_lazy,e.good_match=es[e.level].good_length,e.nice_match=es[e.level].nice_length,e.max_chain_length=es[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=lt-1,e.match_available=0,e.ins_h=0}function lJ(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.
pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Kg,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new na(tJ*2),this.dyn_dtree=new na((2*QZ+1)*2),this.bl_tree=new na((2*eJ+1)*2),jo(this.dyn_ltree),jo(this.dyn_dtree),jo(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new na(nJ+1),this.heap=new na(2*$g+1),jo(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new na(2*$g+1),jo(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=
0,this.bi_buf=0,this.bi_valid=0}function dJ(e){var t;return!e||!e.state?Ba(e,ja):(e.total_in=e.total_out=0,e.data_type=KZ,t=e.state,t.pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?Xg:qo,e.adler=t.wrap===2?0:1,t.last_flush=Ho,xN(t),La)}function Zg(e){var t=dJ(e);return t===La&&uJ(e.state),t}function PN(e,t,n,r,a,o){if(!e)return ja;var i=1;if(t===GZ&&(t=6),r<0?(i=0,r=-r):r>15&&(i=2,r-=16),a<1||a>XZ||n!==Kg||r<8||r>15||t<0||t>9||o<0||o>YZ)return Ba(e,ja);r===8&&(r=9);var c=new lJ;return e.state=c,c.strm=e,c.wrap=i,c.gzhead=null,c.w_bits=r,c.w_size=1<<c.w_bits,c.w_mask=c.w_size-1,c.hash_bits=a+7,c.hash_size=1<<c.hash_bits,c.hash_mask=c.hash_size-1,c.hash_shift=~~((c.hash_bits+lt-1)/lt),c.window=new Ig(c.w_size*2),c.head=new na(c.hash_size),c.prev=new na(c.w_size),c.lit_bufsize=1<<a+6,c.pending_buf_size=c.lit_bufsize*4,c.pending_buf=new Ig(c.pending_buf_size),c.d_buf=1*c.lit_bufsize,c.l_buf=3*c.lit_bufsize,c.level=t,c.strategy=o,c.method=n,Zg(e)}function LN(e,t){var n,
r,a,o;if(!e||!e.state||t>_N||t<0)return e?Ba(e,ja):ja;if(r=e.state,!e.output||!e.input&&e.avail_in!==0||r.status===ou&&t!==Ua)return Ba(e,e.avail_out===0?Gg:ja);if(r.strm=e,n=r.last_flush,r.last_flush=t,r.status===Xg)if(r.wrap===2)e.adler=0,at(r,31),at(r,139),at(r,8),r.gzhead?(at(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),at(r,r.gzhead.time&255),at(r,r.gzhead.time>>8&255),at(r,r.gzhead.time>>16&255),at(r,r.gzhead.time>>24&255),at(r,r.level===9?2:r.strategy>=Gm||r.level<2?4:0),at(r,r.gzhead.os&255),r.gzhead.extra&&r.gzhead.extra.length&&(at(r,r.gzhead.extra.length&255),at(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(e.adler=oa(e.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=Yg):(at(r,0),at(r,0),at(r,0),at(r,0),at(r,0),at(r,r.level===9?2:r.strategy>=Gm||r.level<2?4:0),at(r,aJ),r.status=qo);else{var i=Kg+(r.w_bits-8<<4)<<8,c=-1;r.strategy>=Gm||r.level<2?c=0:r.level<6?c=1:r.level===6?c=2:c=3,i|=c<<6,r.strstart!==
0&&(i|=rJ),i+=31-i%31,r.status=qo,au(r,i),r.strstart!==0&&(au(r,e.adler>>>16),au(r,e.adler&65535)),e.adler=1}if(r.status===Yg)if(r.gzhead.extra){for(a=r.pending;r.gzindex<(r.gzhead.extra.length&65535)&&!(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),Pa(e),a=r.pending,r.pending===r.pending_buf_size));)at(r,r.gzhead.extra[r.gzindex]&255),r.gzindex++;r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),r.gzindex===r.gzhead.extra.length&&(r.gzindex=0,r.status=Vm)}else r.status=Vm;if(r.status===Vm)if(r.gzhead.name){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),Pa(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.name.length?o=r.gzhead.name.charCodeAt(r.gzindex++)&255:o=0,at(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.gzindex=0,r.status=
$m)}else r.status=$m;if(r.status===$m)if(r.gzhead.comment){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),Pa(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.comment.length?o=r.gzhead.comment.charCodeAt(r.gzindex++)&255:o=0,at(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=oa(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.status=Ym)}else r.status=Ym;if(r.status===Ym&&(r.gzhead.hcrc?(r.pending+2>r.pending_buf_size&&Pa(e),r.pending+2<=r.pending_buf_size&&(at(r,e.adler&255),at(r,e.adler>>8&255),e.adler=0,r.status=qo)):r.status=qo),r.pending!==0){if(Pa(e),e.avail_out===0)return r.last_flush=-1,La}else if(e.avail_in===0&&NN(t)<=NN(n)&&t!==Ua)return Ba(e,Gg);if(r.status===ou&&e.avail_in!==0)return Ba(e,Gg);if(e.avail_in!==0||r.lookahead!==0||t!==Ho&&r.status!==ou){var u=r.strategy===Gm?cJ(r,t):r.strategy===$Z?sJ(r,t):es[r.level].func(r,t);if((u===zo||u===ts)&&(r.status=ou),u===
qt||u===zo)return e.avail_out===0&&(r.last_flush=-1),La;if(u===iu&&(t===zZ?SN(r):t!==_N&&(Wg(r,0,0,!1),t===HZ&&(jo(r.head),r.lookahead===0&&(r.strstart=0,r.block_start=0,r.insert=0))),Pa(e),e.avail_out===0))return r.last_flush=-1,La}return t!==Ua?La:r.wrap<=0?IN:(r.wrap===2?(at(r,e.adler&255),at(r,e.adler>>8&255),at(r,e.adler>>16&255),at(r,e.adler>>24&255),at(r,e.total_in&255),at(r,e.total_in>>8&255),at(r,e.total_in>>16&255),at(r,e.total_in>>24&255)):(au(r,e.adler>>>16),au(r,e.adler&65535)),Pa(e),r.wrap>0&&(r.wrap=-r.wrap),r.pending!==0?La:IN)}function ON(e){var t;return!e||!e.state?ja:(t=e.state.status,t!==Xg&&t!==Yg&&t!==Vm&&t!==$m&&t!==Ym&&t!==qo&&t!==ou?Ba(e,ja):(e.state=null,t===qo?Ba(e,WZ):La))}var Ho,zZ,HZ,Ua,_N,La,IN,ja,WZ,Gg,GZ,VZ,Gm,$Z,YZ,KZ,Kg,XZ,ZZ,JZ,$g,QZ,eJ,tJ,nJ,lt,Oa,sr,rJ,Xg,Yg,Vm,$m,Ym,qo,ou,qt,iu,zo,ts,aJ,es,BN=y(()=>{l();Ng();kN();RN();AN();_g();Ho=0,zZ=1,HZ=3,Ua=4,_N=5,La=0,IN=1,ja=-2,WZ=-3,Gg=-5,GZ=-1,VZ=1,Gm=2,$Z=3,YZ=4,KZ=2,Kg=8,XZ=9,ZZ=29,JZ=256,$g=JZ+1+ZZ,QZ=
30,eJ=19,tJ=2*$g+1,nJ=15,lt=3,Oa=258,sr=Oa+lt+1,rJ=32,Xg=42,Yg=69,Vm=73,$m=91,Ym=103,qo=113,ou=666,qt=1,iu=2,zo=3,ts=4,aJ=3;s(Ba,"err");s(NN,"rank");s(jo,"zero");s(Pa,"flush_pending");s(Qt,"flush_block_only");s(at,"put_byte");s(au,"putShortMSB");s(oJ,"read_buf");s(MN,"longest_match");s(su,"fill_window");s(iJ,"deflate_stored");s(Vg,"deflate_fast");s(Qi,"deflate_slow");s(sJ,"deflate_rle");s(cJ,"deflate_huff");s(Cr,"Config");es=[new Cr(0,0,0,0,iJ),new Cr(4,4,8,4,Vg),new Cr(4,5,16,8,Vg),new Cr(4,6,32,32,Vg),new Cr(4,4,16,16,Qi),new Cr(8,16,32,32,Qi),new Cr(8,16,128,128,Qi),new Cr(8,32,128,256,Qi),new Cr(32,128,258,1024,Qi),new Cr(32,258,258,4096,Qi)];s(uJ,"lm_init");s(lJ,"DeflateState");s(dJ,"deflateResetKeep");s(Zg,"deflateReset");s(PN,"deflateInit2");s(LN,"deflate");s(ON,"deflateEnd")});var UN=y(()=>{l()});var Qm={};x(Qm,{DEFLATE:()=>rs,DEFLATERAW:()=>ns,GUNZIP:()=>Xm,GZIP:()=>cu,INFLATE:()=>Zm,INFLATERAW:()=>uu,NONE:()=>Jg,UNZIP:()=>lu,Z_BEST_COMPRESSION:()=>wJ,Z_BEST_SPEED:()=>bJ,Z_BINARY:()=>kJ,Z_BLOCK:()=>GN,Z_BUF_ERROR:()=>yJ,Z_DATA_ERROR:()=>gJ,Z_DEFAULT_COMPRESSION:()=>DJ,Z_DEFAULT_STRATEGY:()=>CJ,Z_DEFLATED:()=>$N,Z_ERRNO:()=>fJ,Z_FILTERED:()=>EJ,Z_FINISH:()=>WN,Z_FIXED:()=>SJ,Z_FULL_FLUSH:()=>HN,Z_HUFFMAN_ONLY:()=>TJ,Z_NEED_DICT:()=>pJ,Z_NO_COMPRESSION:()=>vJ,Z_NO_FLUSH:()=>jN,Z_OK:()=>Jm,Z_PARTIAL_FLUSH:()=>qN,Z_RLE:()=>xJ,Z_STREAM_END:()=>VN,Z_STREAM_ERROR:()=>hJ,Z_SYNC_FLUSH:()=>zN,Z_TEXT:()=>FJ,Z_TREES:()=>mJ,Z_UNKNOWN:()=>RJ,Zlib:()=>kr});function kr(e){if(e<rs||e>lu)throw new TypeError("Bad argument");this.mode=e,this.init_done=!1,this.write_in_progress=!1,this.pending_close=!1,this.windowBits=0,this.level=0,this.memLevel=0,this.strategy=0,this.dictionary=null}function AJ(e,t){for(var n=0;n<e.length;n++)this[t+n]=e[n]}var Jg,rs,Zm,cu,Xm,ns,uu,lu,jN,qN,zN,HN,WN,GN,mJ,Jm,VN,
pJ,fJ,hJ,gJ,yJ,vJ,bJ,wJ,DJ,EJ,TJ,xJ,SJ,CJ,kJ,FJ,RJ,$N,Km,YN=y(()=>{l();_g();nN();BN();UN();Jg=0,rs=1,Zm=2,cu=3,Xm=4,ns=5,uu=6,lu=7,jN=0,qN=1,zN=2,HN=3,WN=4,GN=5,mJ=6,Jm=0,VN=1,pJ=2,fJ=-1,hJ=-2,gJ=-3,yJ=-5,vJ=0,bJ=1,wJ=9,DJ=-1,EJ=1,TJ=2,xJ=3,SJ=4,CJ=0,kJ=0,FJ=1,RJ=2,$N=8;s(kr,"Zlib");kr.prototype.init=function(e,t,n,r,a){this.windowBits=e,this.level=t,this.memLevel=n,this.strategy=r,(this.mode===cu||this.mode===Xm)&&(this.windowBits+=16),this.mode===lu&&(this.windowBits+=32),(this.mode===ns||this.mode===uu)&&(this.windowBits=-this.windowBits),this.strm=new tN;var o;switch(this.mode){case rs:case cu:case ns:o=PN(this.strm,this.level,$N,this.windowBits,this.memLevel,this.strategy);break;case Zm:case Xm:case uu:case lu:o=(this.strm,this.windowBits,void 0);break;default:throw new Error("Unknown mode "+this.mode)}if(o!==Jm){this._error(o);return}this.write_in_progress=!1,this.init_done=!0};kr.prototype.params=function(){throw new Error("deflateParams Not supported")};kr.prototype._writeCheck=
function(){if(!this.init_done)throw new Error("write before init");if(this.mode===Jg)throw new Error("already finalized");if(this.write_in_progress)throw new Error("write already in progress");if(this.pending_close)throw new Error("close is pending")};kr.prototype.write=function(e,t,n,r,a,o,i){this._writeCheck(),this.write_in_progress=!0;var c=this;return process.nextTick(function(){c.write_in_progress=!1;var u=c._write(e,t,n,r,a,o,i);c.callback(u[0],u[1]),c.pending_close&&c.close()}),this};s(AJ,"bufferSet");kr.prototype.writeSync=function(e,t,n,r,a,o,i){return this._writeCheck(),this._write(e,t,n,r,a,o,i)};kr.prototype._write=function(e,t,n,r,a,o,i){if(this.write_in_progress=!0,e!==jN&&e!==qN&&e!==zN&&e!==HN&&e!==WN&&e!==GN)throw new Error("Invalid flush value");t==null&&(t=new Buffer(0),r=0,n=0),a._set?a.set=a._set:a.set=AJ;var c=this.strm;c.avail_in=r,c.input=t,c.next_in=n,c.avail_out=i,c.output=a,c.next_out=o;var u;switch(this.mode){case rs:case cu:case ns:u=LN(c,e);break;case lu:case Zm:case Xm:case uu:
u=void 0;break;default:throw new Error("Unknown mode "+this.mode)}return u!==VN&&u!==Jm&&this._error(u),this.write_in_progress=!1,[c.avail_in,c.avail_out]};kr.prototype.close=function(){if(this.write_in_progress){this.pending_close=!0;return}this.pending_close=!1,this.mode===rs||this.mode===cu||this.mode===ns?ON(this.strm):(this.strm,void 0),this.mode=Jg};kr.prototype.reset=function(){switch(this.mode){case rs:case ns:Km=Zg(this.strm);break;case Zm:case uu:Km=(this.strm,void 0);break}Km!==Jm&&this._error(Km)};kr.prototype._error=function(e){this.onerror(zm[e]+": "+this.strm.msg,e),this.write_in_progress=!1,this.pending_close&&this.close()}});function _J(e,t){if(!e)throw new Error(t)}function KN(e){return new du(e)}function XN(e,t,n){return typeof t=="function"&&(n=t,t={}),IJ(new du(t),e,n)}function ZN(e,t){return NJ(new ep(t),e)}function IJ(e,t,n){var r=[],a=0;e.on("error",i),e.on("end",c),e.end(t),o();function o(){for(var u;(u=e.read())!==null;)r.push(u),a+=u.length;e.once("readable",o)}s(o,"flow");function i(u){e.removeListener("end",c),e.removeListener("readable",o),n(u)}s(i,"onError");function c(){var u=Buffer.concat(r,a);r=[],n(null,u),e.close()}s(c,"onEnd")}function NJ(e,t){if(typeof t=="string"&&(t=new Buffer(t)),!Buffer.isBuffer(t))throw new TypeError("Not a string or buffer");var n=Q.Z_FINISH;return e._processChunk(t,n)}function ey(e){if(!(this instanceof ey))return new ey(e);Nt.call(this,e,Q.DEFLATE)}function ty(e){if(!(this instanceof ty))return new ty(e);Nt.call(this,e,Q.INFLATE)}function du(e){if(!(this instanceof du))return new du(e);Nt.call(this,e,Q.GZIP)}function ep(e){if(!(this instanceof ep))return new ep(
e);Nt.call(this,e,Q.GUNZIP)}function ny(e){if(!(this instanceof ny))return new ny(e);Nt.call(this,e,Q.DEFLATERAW)}function ry(e){if(!(this instanceof ry))return new ry(e);Nt.call(this,e,Q.INFLATERAW)}function ay(e){if(!(this instanceof ay))return new ay(e);Nt.call(this,e,Q.UNZIP)}function Nt(e,t){if(this._opts=e=e||{},this._chunkSize=e.chunkSize||Q.Z_DEFAULT_CHUNK,bn.call(this,e),e.flush&&e.flush!==Q.Z_NO_FLUSH&&e.flush!==Q.Z_PARTIAL_FLUSH&&e.flush!==Q.Z_SYNC_FLUSH&&e.flush!==Q.Z_FULL_FLUSH&&e.flush!==Q.Z_FINISH&&e.flush!==Q.Z_BLOCK)throw new Error("Invalid flush flag: "+e.flush);if(this._flushFlag=e.flush||Q.Z_NO_FLUSH,e.chunkSize&&(e.chunkSize<Q.Z_MIN_CHUNK||e.chunkSize>Q.Z_MAX_CHUNK))throw new Error("Invalid chunk size: "+e.chunkSize);if(e.windowBits&&(e.windowBits<Q.Z_MIN_WINDOWBITS||e.windowBits>Q.Z_MAX_WINDOWBITS))throw new Error("Invalid windowBits: "+e.windowBits);if(e.level&&(e.level<Q.Z_MIN_LEVEL||e.level>Q.Z_MAX_LEVEL))throw new Error("Invalid compression level: "+e.level);if(e.
memLevel&&(e.memLevel<Q.Z_MIN_MEMLEVEL||e.memLevel>Q.Z_MAX_MEMLEVEL))throw new Error("Invalid memLevel: "+e.memLevel);if(e.strategy&&e.strategy!=Q.Z_FILTERED&&e.strategy!=Q.Z_HUFFMAN_ONLY&&e.strategy!=Q.Z_RLE&&e.strategy!=Q.Z_FIXED&&e.strategy!=Q.Z_DEFAULT_STRATEGY)throw new Error("Invalid strategy: "+e.strategy);if(e.dictionary&&!Buffer.isBuffer(e.dictionary))throw new Error("Invalid dictionary: it should be a Buffer instance");this._binding=new Q.Zlib(t);var n=this;this._hadError=!1,this._binding.onerror=function(o,i){n._binding=null,n._hadError=!0;var c=new Error(o);c.errno=i,c.code=Q.codes[i],n.emit("error",c)};var r=Q.Z_DEFAULT_COMPRESSION;typeof e.level=="number"&&(r=e.level);var a=Q.Z_DEFAULT_STRATEGY;typeof e.strategy=="number"&&(a=e.strategy),this._binding.init(e.windowBits||Q.Z_DEFAULT_WINDOWBITS,r,e.memLevel||Q.Z_DEFAULT_MEMLEVEL,a,e.dictionary),this._buffer=new Buffer(this._chunkSize),this._offset=0,this._closed=!1,this._level=r,this._strategy=a,this.once("end",this.close)}
var Q,Qg,oy=y(()=>{l();Ag();YN();Ma();s(_J,"assert");Q={};Object.keys(Qm).forEach(function(e){Q[e]=Qm[e]});Q.Z_MIN_WINDOWBITS=8;Q.Z_MAX_WINDOWBITS=15;Q.Z_DEFAULT_WINDOWBITS=15;Q.Z_MIN_CHUNK=64;Q.Z_MAX_CHUNK=1/0;Q.Z_DEFAULT_CHUNK=16*1024;Q.Z_MIN_MEMLEVEL=1;Q.Z_MAX_MEMLEVEL=9;Q.Z_DEFAULT_MEMLEVEL=8;Q.Z_MIN_LEVEL=-1;Q.Z_MAX_LEVEL=9;Q.Z_DEFAULT_LEVEL=Q.Z_DEFAULT_COMPRESSION;Qg={Z_OK:Q.Z_OK,Z_STREAM_END:Q.Z_STREAM_END,Z_NEED_DICT:Q.Z_NEED_DICT,Z_ERRNO:Q.Z_ERRNO,Z_STREAM_ERROR:Q.Z_STREAM_ERROR,Z_DATA_ERROR:Q.Z_DATA_ERROR,Z_MEM_ERROR:Q.Z_MEM_ERROR,Z_BUF_ERROR:Q.Z_BUF_ERROR,Z_VERSION_ERROR:Q.Z_VERSION_ERROR};Object.keys(Qg).forEach(function(e){Qg[Qg[e]]=e});s(KN,"createGzip");s(XN,"gzip");s(ZN,"gunzipSync");s(IJ,"zlibBuffer");s(NJ,"zlibBufferSync");s(ey,"Deflate");s(ty,"Inflate");s(du,"Gzip");s(ep,"Gunzip");s(ny,"DeflateRaw");s(ry,"InflateRaw");s(ay,"Unzip");s(Nt,"Zlib");It(Nt,bn);Nt.prototype.params=function(e,t,n){if(e<Q.Z_MIN_LEVEL||e>Q.Z_MAX_LEVEL)throw new RangeError("Invalid compression \
level: "+e);if(t!=Q.Z_FILTERED&&t!=Q.Z_HUFFMAN_ONLY&&t!=Q.Z_RLE&&t!=Q.Z_FIXED&&t!=Q.Z_DEFAULT_STRATEGY)throw new TypeError("Invalid strategy: "+t);if(this._level!==e||this._strategy!==t){var r=this;this.flush(Q.Z_SYNC_FLUSH,function(){r._binding.params(e,t),r._hadError||(r._level=e,r._strategy=t,n&&n())})}else process.nextTick(n)};Nt.prototype.reset=function(){return this._binding.reset()};Nt.prototype._flush=function(e){this._transform(new Buffer(0),"",e)};Nt.prototype.flush=function(e,t){var n=this._writableState;if((typeof e=="function"||e===void 0&&!t)&&(t=e,e=Q.Z_FULL_FLUSH),n.ended)t&&process.nextTick(t);else if(n.ending)t&&this.once("end",t);else if(n.needDrain){var r=this;this.once("drain",function(){r.flush(t)})}else this._flushFlag=e,this.write(new Buffer(0),"",t)};Nt.prototype.close=function(e){if(e&&process.nextTick(e),!this._closed){this._closed=!0,this._binding.close();var t=this;process.nextTick(function(){t.emit("close")})}};Nt.prototype._transform=function(e,t,n){var r,
a=this._writableState,o=a.ending||a.ended,i=o&&(!e||a.length===e.length);if(!e===null&&!Buffer.isBuffer(e))return n(new Error("invalid input"));i?r=Q.Z_FINISH:(r=this._flushFlag,e.length>=a.length&&(this._flushFlag=this._opts.flush||Q.Z_NO_FLUSH)),this._processChunk(e,r,n)};Nt.prototype._processChunk=function(e,t,n){var r=e&&e.length,a=this._chunkSize-this._offset,o=0,i=this,c=typeof n=="function";if(!c){var u=[],d=0,m;this.on("error",function(v){m=v});do var p=this._binding.writeSync(t,e,o,r,this._buffer,this._offset,a);while(!this._hadError&&g(p[0],p[1]));if(this._hadError)throw m;var h=Buffer.concat(u,d);return this.close(),h}var f=this._binding.write(t,e,o,r,this._buffer,this._offset,a);f.buffer=e,f.callback=g;function g(v,w){if(!i._hadError){var E=a-w;if(_J(E>=0,"have should not go down"),E>0){var T=i._buffer.slice(i._offset,i._offset+E);i._offset+=E,c?i.push(T):(u.push(T),d+=T.length)}if((w===0||i._offset>=i._chunkSize)&&(a=i._chunkSize,i._offset=0,i._buffer=new Buffer(i._chunkSize)),
w===0){if(o+=r-v,r=v,!c)return!0;var S=i._binding.write(t,e,o,r,i._buffer,i._offset,i._chunkSize);S.callback=g,S.buffer=e;return}if(!c)return!1;n()}}s(g,"callback")};It(ey,Nt);It(ty,Nt);It(du,Nt);It(ep,Nt);It(ny,Nt);It(ry,Nt);It(ay,Nt)});var tp=y(()=>{"use strict";l();});var Le,JN=y(()=>{"use strict";l();Le=class e{static{s(this,"BaseNode")}static TYPES={NETWORK:"network",CPU:"cpu"};constructor(t){this._id=t,this._isMainDocument=!1,this._dependents=[],this._dependencies=[]}get id(){return this._id}get type(){throw new Error("Unimplemented")}get startTime(){throw new Error("Unimplemented")}get endTime(){throw new Error("Unimplemented")}setIsMainDocument(t){this._isMainDocument=t}isMainDocument(){return this._isMainDocument}getDependents(){return this._dependents.slice()}getNumberOfDependents(){return this._dependents.length}getDependencies(){return this._dependencies.slice()}getNumberOfDependencies(){return this._dependencies.length}getRootNode(){let t=this;for(;t._dependencies.length;)t=t._dependencies[0];return t}addDependent(t){t.addDependency(this)}addDependency(t){if(t===this)throw new Error("Cannot add dependency on itself");this._dependencies.includes(t)||(t._dependents.push(this),this._dependencies.push(t))}removeDependent(t){t.removeDependency(
this)}removeDependency(t){if(!this._dependencies.includes(t))return;let n=t._dependents.indexOf(this);t._dependents.splice(n,1),this._dependencies.splice(this._dependencies.indexOf(t),1)}removeAllDependencies(){for(let t of this._dependencies.slice())this.removeDependency(t)}isDependentOn(t){let n=!1;return this.traverse(r=>{n||(n=r===t)},r=>n?[]:r.getDependencies()),n}cloneWithoutRelationships(){let t=new e(this.id);return t.setIsMainDocument(this._isMainDocument),t}cloneWithRelationships(t){let n=this.getRootNode(),r=new Map;n.traverse(o=>{if(!r.has(o.id)){if(t===void 0){r.set(o.id,o.cloneWithoutRelationships());return}t(o)&&o.traverse(i=>r.set(i.id,i.cloneWithoutRelationships()),i=>i._dependencies.filter(c=>!r.has(c.id)))}}),n.traverse(o=>{let i=r.get(o.id);if(i)for(let c of o._dependencies){let u=r.get(c.id);if(!u)throw new Error("Dependency somehow not cloned");i.addDependency(u)}});let a=r.get(this.id);if(!a)throw new Error("Cloned graph missing node");return a}traverse(t,n){for(let{
node:r,traversalPath:a}of this.traverseGenerator(n))t(r,a)}*traverseGenerator(t){t||(t=s(a=>a.getDependents(),"getNextNodes"));let n=[[this]],r=new Set([this.id]);for(;n.length;){let a=n.shift(),o=a[0];yield{node:o,traversalPath:a};for(let i of t(o))r.has(i.id)||(r.add(i.id),n.push([i,...a]))}}static hasCycle(t,n="both"){if(n==="both")return e.hasCycle(t,"dependents")||e.hasCycle(t,"dependencies");let r=new Set,a=[],o=[t],i=new Map([[t,0]]);for(;o.length;){let c=o.pop();if(a.includes(c))return!0;if(r.has(c))continue;for(;a.length>i.get(c);)a.pop();r.add(c),a.push(c);let u=n==="dependents"?c._dependents:c._dependencies;for(let d of u)o.includes(d)||(o.push(d),i.set(d,a.length))}return!1}canDependOn(t){return t.startTime<=this.startTime}}});var mu,iy=y(()=>{"use strict";l();Oe();mu=class e extends Le{static{s(this,"CPUNode")}constructor(t,n=[],r){let a=`${t.tid}.${t.ts}`;super(a),this._event=t,this._childEvents=n,this._correctedEndTs=r}get type(){return Le.TYPES.CPU}get startTime(){return this._event.ts}get endTime(){return this._correctedEndTs?this._correctedEndTs:this._event.ts+this._event.dur}get duration(){return this.endTime-this.startTime}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some(t=>t.name==="Layout")}getEvaluateScriptURLs(){let t=new Set;for(let n of this._childEvents)n.name==="EvaluateScript"&&(!n.args.data||!n.args.data.url||t.add(n.args.data.url));return t}cloneWithoutRelationships(){return new e(this._event,this._childEvents,this._correctedEndTs)}}});var qa,QN=y(()=>{"use strict";l();qa=class extends Error{static{s(this,"LanternError")}}});var un,eM=y(()=>{"use strict";l();Oe();un=class{static{s(this,"Metric")}static getScriptUrls(t,n){let r=new Set;return t.traverse(a=>{a.type===Le.TYPES.NETWORK&&a.request.resourceType===ln.Script&&n?.(a)&&r.add(a.request.url)}),r}static get COEFFICIENTS(){throw new Error("COEFFICIENTS unimplemented!")}static getScaledCoefficients(t){return this.COEFFICIENTS}static getOptimisticGraph(t,n){throw new Error("Optimistic graph unimplemented!")}static getPessimisticGraph(t,n){throw new Error("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(t,n){return t}static async compute(t,n){let{simulator:r,graph:a,processedNavigation:o}=t,i=this.name.replace("Lantern",""),c=this.getOptimisticGraph(a,o),u=this.getPessimisticGraph(a,o),d={label:`optimistic${i}`},m=r.simulate(c,d);d={label:`pessimistic${i}`};let p=r.simulate(u,d),h=this.getEstimateFromSimulation(m,{...n,optimistic:!0}),f=this.getEstimateFromSimulation(p,{...n,optimistic:!1}),g=this.getScaledCoefficients(r.rtt),v=g.intercept>
0?Math.min(1,h.timeInMs/1e3):1;return{timing:g.intercept*v+g.optimistic*h.timeInMs+g.pessimistic*f.timeInMs,optimisticEstimate:h,pessimisticEstimate:f,optimisticGraph:c,pessimisticGraph:u}}}});function tM(e){let t=e.includes(":")?e.slice(0,e.indexOf(":")):e;return MJ.includes(t)}var MJ,as,sy=y(()=>{"use strict";l();Oe();Oe();MJ=["blob","data","intent","file","filesystem","chrome-extension"];s(tM,"isNonNetworkProtocol");as=class e extends Le{static{s(this,"NetworkNode")}constructor(t){super(t.requestId),this._request=t}get type(){return Le.TYPES.NETWORK}get startTime(){return this._request.rendererStartTime*1e3}get endTime(){return this._request.networkEndTime*1e3}get rawRequest(){return this._request.rawRequest}get request(){return this._request}get initiatorType(){return this._request.initiator&&this._request.initiator.type}get fromDiskCache(){return!!this._request.fromDiskCache}get isNonNetworkProtocol(){return tM(this.request.protocol)||tM(this.request.parsedURL.scheme)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){let t=this._request.priority,n=this._request.resourceType===ln.Script,r=this._request.resourceType===
ln.Document;return t==="VeryHigh"||t==="High"&&n||t==="High"&&r}cloneWithoutRelationships(){let t=new e(this._request);return t.setIsMainDocument(this._isMainDocument),t}}});var PJ,LJ,OJ,BJ,UJ,jJ,Fr,nM=y(()=>{"use strict";l();Oe();sy();iy();PJ="RunTask",LJ="ThreadControllerImpl::RunTask",OJ="ThreadControllerImpl::DoWork",BJ="TaskQueueManager::ProcessTaskFromWorkQueue",UJ=10,jJ=/^video/,Fr=class e{static{s(this,"PageDependencyGraph")}static getNetworkInitiators(t){if(!t.initiator)return[];if(t.initiator.url)return[t.initiator.url];if(t.initiator.type==="script"){let n=new Set,r=t.initiator.stack;for(;r;){let a=r.callFrames||[];for(let o of a)o.url&&n.add(o.url);r=r.parent}return Array.from(n)}return[]}static getNetworkNodeOutput(t){let n=[],r=new Map,a=new Map,o=new Map;return t.forEach(i=>{if(jJ.test(i.mimeType)||i.fromWorker)return;for(;r.has(i.requestId);)i.requestId+=":duplicate";let c=new as(i);n.push(c);let u=a.get(i.url)||[];if(u.push(c),r.set(i.requestId,c),a.set(i.url,u),i.frameId&&i.resourceType===ln.Document&&i.documentURL===i.url){let d=o.has(i.frameId)?null:c;o.set(i.frameId,d)}}),{nodes:n,idToNodeMap:r,urlToNodeMap:a,frameIdToNodeMap:o}}static isScheduleableTask(t){
return t.name===PJ||t.name===LJ||t.name===OJ||t.name===BJ}static assertHasToplevelEvents(t){if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static getCPUNodes(t){let n=[],r=0;for(e.assertHasToplevelEvents(t);r<t.length;){let a=t[r];if(r++,!e.isScheduleableTask(a)||!a.dur)continue;let o,i=[];for(let c=a.ts+a.dur;r<t.length&&t[r].ts<c;r++){let u=t[r];if(e.isScheduleableTask(u)&&u.dur){o=u.ts-1;break}i.push(u)}n.push(new mu(a,i,o))}return n}static linkNetworkNodes(t,n){n.nodes.forEach(r=>{let a=r.request.initiatorRequest||t.request,o=n.idToNodeMap.get(a.requestId)||t,i=!o.isDependentOn(r)&&r.canDependOn(o),c=e.getNetworkInitiators(r.request);if(c.length?c.forEach(d=>{let m=n.urlToNodeMap.get(d)||[];m.length===1&&m[0].startTime<=r.startTime&&!m[0].isDependentOn(r)?r.addDependency(m[0]):i&&o.addDependent(r)}):i&&o.addDependent(r),r!==t&&r.getDependencies().length===0&&r.canDependOn(t)&&r.addDependency(t),!r.request.redirects)return;let u=[...r.request.
redirects,r.request];for(let d=1;d<u.length;d++){let m=n.idToNodeMap.get(u[d-1].requestId),p=n.idToNodeMap.get(u[d].requestId);p&&m&&p.addDependency(m)}})}static linkCPUNodes(t,n,r){let a=new Set([ln.XHR,ln.Fetch,ln.Script]);function o(f,g){let v=n.idToNodeMap.get(g);if(!v||v.startTime<=f.startTime)return;let{request:w}=v,E=w.resourceType||w.redirectDestination?.resourceType;a.has(E)&&f.addDependent(v)}s(o,"addDependentNetworkRequest");function i(f,g){if(!g)return;let v=n.frameIdToNodeMap.get(g);v&&(v.startTime>=f.startTime||f.addDependency(v))}s(i,"addDependencyOnFrame");function c(f,g){if(!g)return;let v=-100*1e3,w=n.urlToNodeMap.get(g)||[],E=null,T=1/0;for(let S of w){if(f.startTime<=S.startTime)return;let C=f.startTime-S.endTime;C>=v&&C<T&&(E=S,T=C)}E&&f.addDependency(E)}s(c,"addDependencyOnUrl");let u=new Map;for(let f of r){for(let g of f.childEvents){if(!g.args.data)continue;let v=g.args.data.url,w=(g.args.data.stackTrace||[]).map(E=>E.url).filter(Boolean);switch(g.name){case"Ti\
merInstall":u.set(g.args.data.timerId,f),w.forEach(E=>c(f,E));break;case"TimerFire":{let E=u.get(g.args.data.timerId);if(!E||E.endTime>f.startTime)break;E.addDependent(f);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":i(f,g.args.data.frame),w.forEach(E=>c(f,E));break;case"EvaluateScript":i(f,g.args.data.frame),c(f,v),w.forEach(E=>c(f,E));break;case"XHRReadyStateChange":if(g.args.data.readyState!==4)break;c(f,v),w.forEach(E=>c(f,E));break;case"FunctionCall":case"v8.compile":i(f,g.args.data.frame),c(f,v);break;case"ParseAuthorStyleSheet":i(f,g.args.data.frame),c(f,g.args.data.styleSheetUrl);break;case"ResourceSendRequest":i(f,g.args.data.frame),o(f,g.args.data.requestId),w.forEach(E=>c(f,E));break}}f.getNumberOfDependencies()===0&&f.canDependOn(t)&&f.addDependency(t)}let d=UJ*1e3,m=!1,p=!1,h=!1;for(let f of r){let g=!1;!m&&f.childEvents.some(v=>v.name==="Layout")&&(g=m=!0),!p&&f.childEvents.some(v=>v.name==="Paint")&&(g=p=!0),!h&&f.childEvents.some(v=>v.name==="ParseHTML")&&
(g=h=!0),!(g||f.duration>=d)&&(f.getNumberOfDependencies()===1||f.getNumberOfDependents()<=1)&&e._pruneNode(f)}}static _pruneNode(t){let n=t.getDependencies(),r=t.getDependents();for(let a of n){t.removeDependency(a);for(let o of r)a.addDependent(o)}for(let a of r)t.removeDependent(a)}static _debugNormalizeRequests(t){for(let a of t)a.rendererStartTime=Math.round(a.rendererStartTime*1e3)/1e3,a.networkRequestTime=Math.round(a.networkRequestTime*1e3)/1e3,a.responseHeadersEndTime=Math.round(a.responseHeadersEndTime*1e3)/1e3,a.networkEndTime=Math.round(a.networkEndTime*1e3)/1e3;for(let a of t)delete a.rawRequest,a.initiatorRequest&&(a.initiatorRequest={id:a.initiatorRequest.requestId}),a.redirectDestination&&(a.redirectDestination={id:a.redirectDestination.requestId}),a.redirectSource&&(a.redirectSource={id:a.redirectSource.requestId}),a.redirects&&(a.redirects=a.redirects.map(o=>o.requestId));let r=t.map(a=>({requestId:a.requestId,connectionId:a.connectionId,connectionReused:a.connectionReused,
url:a.url,protocol:a.protocol,parsedURL:a.parsedURL,documentURL:a.documentURL,rendererStartTime:a.rendererStartTime,networkRequestTime:a.networkRequestTime,responseHeadersEndTime:a.responseHeadersEndTime,networkEndTime:a.networkEndTime,transferSize:a.transferSize,resourceSize:a.resourceSize,fromDiskCache:a.fromDiskCache,fromMemoryCache:a.fromMemoryCache,finished:a.finished,statusCode:a.statusCode,redirectSource:a.redirectSource,redirectDestination:a.redirectDestination,redirects:a.redirects,failed:a.failed,initiator:a.initiator,timing:a.timing?{requestTime:a.timing.requestTime,proxyStart:a.timing.proxyStart,proxyEnd:a.timing.proxyEnd,dnsStart:a.timing.dnsStart,dnsEnd:a.timing.dnsEnd,connectStart:a.timing.connectStart,connectEnd:a.timing.connectEnd,sslStart:a.timing.sslStart,sslEnd:a.timing.sslEnd,workerStart:a.timing.workerStart,workerReady:a.timing.workerReady,workerFetchStart:a.timing.workerFetchStart,workerRespondWithSettled:a.timing.workerRespondWithSettled,sendStart:a.timing.sendStart,
sendEnd:a.timing.sendEnd,pushStart:a.timing.pushStart,pushEnd:a.timing.pushEnd,receiveHeadersStart:a.timing.receiveHeadersStart,receiveHeadersEnd:a.timing.receiveHeadersEnd}:a.timing,resourceType:a.resourceType,mimeType:a.mimeType,priority:a.priority,initiatorRequest:a.initiatorRequest,frameId:a.frameId,fromWorker:a.fromWorker,isLinkPreload:a.isLinkPreload,serverResponseTime:a.serverResponseTime})).filter(a=>!a.fromWorker);process.exit(1)}static createGraph(t,n,r){let a=e.getNetworkNodeOutput(n),o=e.getCPUNodes(t),{requestedUrl:i,mainDocumentUrl:c}=r;if(!i)throw new Error("requestedUrl is required to get the root request");if(!c)throw new Error("mainDocumentUrl is required to get the main resource");let u=zt.NetworkAnalyzer.findResourceForUrl(n,i);if(!u)throw new Error("rootRequest not found");let d=a.idToNodeMap.get(u.requestId);if(!d)throw new Error("rootNode not found");let m=zt.NetworkAnalyzer.findLastDocumentForUrl(n,c);if(!m)throw new Error("mainDocumentRequest not found");let p=a.
idToNodeMap.get(m.requestId);if(!p)throw new Error("mainDocumentNode not found");if(e.linkNetworkNodes(d,a),e.linkCPUNodes(d,a,o),p.setIsMainDocument(!0),as.hasCycle(d))throw new Error("Invalid dependency graph created, cycle detected");return d}static printGraph(t,n=100){function r(d,m,p=" "){return d+p.repeat(Math.max(m-d.length,0))}s(r,"padRight");let a=[];t.traverse(d=>a.push(d)),a.sort((d,m)=>d.startTime-m.startTime);let o=a[0].startTime,u=(a.reduce((d,m)=>Math.max(d,m.endTime),0)-o)/n;a.forEach(d=>{let m=Math.round((d.startTime-o)/u),p=Math.ceil((d.endTime-d.startTime)/u),h=r("",m)+r("",p,"="),f=d.request?d.request.url:d.type;console.log(r(h,n),`| ${f.slice(0,30)}`)})}}});var np,rM=y(()=>{"use strict";l();Oe();np=class extends un{static{s(this,"FirstContentfulPaint")}static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=new Map,i=[];t.traverse(f=>{if(f.type===Le.TYPES.CPU){f.startTime<=n&&i.push(f);let g=f.getEvaluateScriptURLs();for(let v of g){let w=o.get(v)||f;o.set(v,f.startTime<w.startTime?f:w)}}}),i.sort((f,g)=>f.startTime-g.startTime);let c=un.getScriptUrls(t,f=>f.endTime<=n&&r(f)),u=new Set,d=new Set;for(let f of c){let g=o.get(f);if(g){if(i.includes(g)){d.add(g.id);continue}u.add(f)}}let m=i.find(f=>f.didPerformLayout());m&&d.add(m.id);let p=i.find(f=>f.childEvents.some(g=>g.name==="Paint"));p&&d.add(p.id);let h=i.find(f=>f.childEvents.some(g=>g.name==="ParseHTML"));return h&&d.add(h.id),a&&i.filter(a).forEach(f=>d.add(f.id)),{definitelyNotRenderBlockingScriptUrls:u,renderBlockingCpuNodeIds:d}}static getFirstPaintBasedGraph(t,{
cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=this.getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}),{definitelyNotRenderBlockingScriptUrls:i,renderBlockingCpuNodeIds:c}=o;return t.cloneWithRelationships(u=>{if(u.type===Le.TYPES.NETWORK){if((u.endTime>n||u.startTime>n)&&!u.isMainDocument())return!1;let m=u.request.url;return i.has(m)?!1:r(u)}else return c.has(u.id)})}static getOptimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:r=>r.hasRenderBlockingPriority()&&r.initiatorType!=="script"})}static getPessimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:r=>r.hasRenderBlockingPriority()})}}});var qJ,rp,aM=y(()=>{"use strict";l();Oe();qJ=20,rp=class e extends un{static{s(this,"Interactive")}static get COEFFICIENTS(){return{intercept:0,optimistic:.45,pessimistic:.55}}static getOptimisticGraph(t){let n=qJ*1e3;return t.cloneWithRelationships(r=>{if(r.type===Le.TYPES.CPU)return r.duration>n;let a=r.request.resourceType===ln.Image,o=r.request.resourceType===ln.Script;return!a&&(o||r.request.priority==="High"||r.request.priority==="VeryHigh")})}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.lcpResult)throw new Error("missing lcpResult");let r=e.getLastLongTaskEndTime(t.nodeTimings),a=n.optimistic?n.lcpResult.optimisticEstimate.timeInMs:n.lcpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(a,r),nodeTimings:t.nodeTimings}}static async compute(t,n){let r=n?.lcpResult;if(!r)throw new Error("LCP is required to calculate the Interactive metric");let a=await super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static getLastLongTaskEndTime(t,n=50){
return Array.from(t.entries()).filter(([r,a])=>r.type!==Le.TYPES.CPU?!1:a.duration>n).map(([r,a])=>a.endTime).reduce((r,a)=>Math.max(r||0,a||0),0)}}});var ap,oM=y(()=>{"use strict";l();Oe();ap=class e extends un{static{s(this,"LargestContentfulPaint")}static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(t){if(t.type!=="network")return!0;let n=t.request.resourceType==="Image",r=t.request.priority==="Low"||t.request.priority==="VeryLow";return!n||!r}static getOptimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new qa("NO_LCP");return en.FirstContentfulPaint.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:e.isNotLowPriorityImageNode})}static getPessimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new qa("NO_LCP");return en.FirstContentfulPaint.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:a=>!0,additionalCpuNodesToTreatAsRenderBlocking:a=>a.didPerformLayout()})}static getEstimateFromSimulation(t){let n=Array.from(t.nodeTimings.entries()).filter(r=>e.isNotLowPriorityImageNode(r[0])).map(r=>r[1].
endTime);return{timeInMs:Math.max(...n),nodeTimings:t.nodeTimings}}static async compute(t,n){let r=n?.fcpResult;if(!r)throw new Error("FCP is required to calculate the LCP metric");let a=await super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}}});var op,iM=y(()=>{"use strict";l();Oe();op=class e extends un{static{s(this,"MaxPotentialFID")}static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Error("missing fcpResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=e.getTimingsAfterFCP(t.nodeTimings,r);return{timeInMs:Math.max(...a.map(o=>o.duration),16),nodeTimings:t.nodeTimings}}static compute(t,n){if(!n?.fcpResult)throw new Error("FCP is required to calculate the Max Potential FID metric");return super.compute(t,n)}static getTimingsAfterFCP(t,n){return Array.from(t.entries()).filter(([r,a])=>r.type===Le.TYPES.CPU&&a.endTime>n).map(([r,a])=>a)}}});var zJ,ip,sM=y(()=>{"use strict";l();Oe();zJ=150,ip=class e extends un{static{s(this,"SpeedIndex")}static get COEFFICIENTS(){return{intercept:0,optimistic:1.4,pessimistic:.4}}static getScaledCoefficients(t){let n=this.COEFFICIENTS,r=zJ-30,a=Math.max((t-30)/r,0);return{intercept:n.intercept*a,optimistic:.5+(n.optimistic-.5)*a,pessimistic:.5+(n.pessimistic-.5)*a}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Error("missing fcpResult");if(n.observedSpeedIndex===void 0)throw new Error("missing observedSpeedIndex");let r=n.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:n.optimistic?n.observedSpeedIndex:e.computeLayoutBasedSpeedIndex(t.nodeTimings,r),nodeTimings:t.nodeTimings}}static async compute(t,n){let r=n?.fcpResult;if(!r)throw new Error("FCP is required to calculate the SpeedIndex metric");let a=await super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static computeLayoutBasedSpeedIndex(t,n){
let r=[];for(let[i,c]of t.entries())if(i.type===Le.TYPES.CPU&&i.childEvents.some(u=>u.name==="Layout")){let u=Math.max(Math.log2(c.endTime-c.startTime),0);r.push({time:c.endTime,weight:u})}let a=r.map(i=>i.weight*Math.max(i.time,n)).reduce((i,c)=>i+c,0),o=r.map(i=>i.weight).reduce((i,c)=>i+c,0);return o?a/o:n}}});var sp,cM=y(()=>{"use strict";l();Oe();sp=class e extends un{static{s(this,"TotalBlockingTime")}static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Error("missing fcpResult");if(!n.interactiveResult)throw new Error("missing interactiveResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=n.optimistic?n.interactiveResult.optimisticEstimate.timeInMs:n.interactiveResult.pessimisticEstimate.timeInMs,o=ia.BLOCKING_TIME_THRESHOLD,i=e.getTopLevelEvents(t.nodeTimings,o);return{timeInMs:ia.calculateSumOfBlockingTime(i,r,a),nodeTimings:t.nodeTimings}}static async compute(t,n){if(!n?.fcpResult)throw new Error("FCP is required to calculate the TBT metric");if(!n?.fcpResult)throw new Error("Interactive is required to calculate the TBT metric");return super.compute(t,n)}static getTopLevelEvents(t,n){
let r=[];for(let[a,o]of t.entries())a.type===Le.TYPES.CPU&&(o.duration<n||r.push({start:o.startTime,end:o.endTime,duration:o.duration}));return r}}});var en={};x(en,{FirstContentfulPaint:()=>np,Interactive:()=>rp,LargestContentfulPaint:()=>ap,MaxPotentialFID:()=>op,SpeedIndex:()=>ip,TotalBlockingTime:()=>sp});var uM=y(()=>{"use strict";l();tp();rM();aM();oM();iM();sM();cM();});function HJ(e,t){return e.endsWith(t)?e.length===t.length||e[e.length-t.length-1]===".":!1}function WJ(e,t){let n=e.length-t.length-2,r=e.lastIndexOf(".",n);return r===-1?e:e.slice(r+1)}function cy(e,t,n){if(n.validHosts!==null){let a=n.validHosts;for(let o of a)if(HJ(t,o))return o}let r=0;if(t.startsWith("."))for(;r<t.length&&t[r]===".";)r+=1;return e.length===t.length-r?null:WJ(t,e)}var lM=y(()=>{l();s(HJ,"shareSameDomainSuffix");s(WJ,"extractDomainWithSuffix");s(cy,"getDomain")});function uy(e,t){return e.slice(0,-t.length-1)}var dM=y(()=>{l();s(uy,"getDomainWithoutSuffix")});function cp(e,t){let n=0,r=e.length,a=!1;if(!t){if(e.startsWith("data:"))return null;for(;n<e.length&&e.charCodeAt(n)<=32;)n+=1;for(;r>n+1&&e.charCodeAt(r-1)<=32;)r-=1;if(e.charCodeAt(n)===47&&e.charCodeAt(n+1)===47)n+=2;else{let d=e.indexOf(":/",n);if(d!==-1){let m=d-n,p=e.charCodeAt(n),h=e.charCodeAt(n+1),f=e.charCodeAt(n+2),g=e.charCodeAt(n+3),v=e.charCodeAt(n+4);if(!(m===5&&p===104&&h===116&&f===116&&g===112&&v===115)){if(!(m===4&&p===104&&h===116&&f===116&&g===112)){if(!(m===3&&p===119&&h===115&&f===115)){if(!(m===2&&p===119&&h===115))for(let w=n;w<d;w+=1){let E=e.charCodeAt(w)|32;if(!(E>=97&&E<=122||E>=48&&E<=57||E===46||E===45||E===43))return null}}}}for(n=d+2;e.charCodeAt(n)===47;)n+=1}}let i=-1,c=-1,u=-1;for(let d=n;d<r;d+=1){let m=e.charCodeAt(d);if(m===35||m===47||m===63){r=d;break}else m===64?i=d:m===93?c=d:m===58?u=d:m>=65&&m<=90&&(a=!0)}if(i!==-1&&i>n&&i<r&&(n=i+1),e.charCodeAt(n)===91)return c!==-1?e.slice(n+1,c).toLowerCase():null;u!==-1&&u>n&&u<r&&(r=u)}for(;r>n+1&&e.charCodeAt(
r-1)===46;)r-=1;let o=n!==0||r!==e.length?e.slice(n,r):e;return a?o.toLowerCase():o}var mM=y(()=>{l();s(cp,"extractHostname")});function GJ(e){if(e.length<7||e.length>15)return!1;let t=0;for(let n=0;n<e.length;n+=1){let r=e.charCodeAt(n);if(r===46)t+=1;else if(r<48||r>57)return!1}return t===3&&e.charCodeAt(0)!==46&&e.charCodeAt(e.length-1)!==46}function VJ(e){if(e.length<3)return!1;let t=e.startsWith("[")?1:0,n=e.length;if(e[n-1]==="]"&&(n-=1),n-t>39)return!1;let r=!1;for(;t<n;t+=1){let a=e.charCodeAt(t);if(a===58)r=!0;else if(!(a>=48&&a<=57||a>=97&&a<=102||a>=65&&a<=90))return!1}return r}function ly(e){return VJ(e)||GJ(e)}var pM=y(()=>{l();s(GJ,"isProbablyIpv4");s(VJ,"isProbablyIpv6");s(ly,"isIp")});function fM(e){return e>=97&&e<=122||e>=48&&e<=57||e>127}function up(e){if(e.length>255||e.length===0||!fM(e.charCodeAt(0))&&e.charCodeAt(0)!==46&&e.charCodeAt(0)!==95)return!1;let t=-1,n=-1,r=e.length;for(let a=0;a<r;a+=1){let o=e.charCodeAt(a);if(o===46){if(a-t>64||n===46||n===45||n===95)return!1;t=a}else if(!(fM(o)||o===45||o===95))return!1;n=o}return r-t-1<=63&&n!==45}var hM=y(()=>{l();s(fM,"isValidAscii");s(up,"default")});function gM({allowIcannDomains:e=!0,allowPrivateDomains:t=!1,detectIp:n=!0,extractHostname:r=!0,mixedInputs:a=!0,validHosts:o=null,validateHostname:i=!0}){return{allowIcannDomains:e,allowPrivateDomains:t,detectIp:n,extractHostname:r,mixedInputs:a,validHosts:o,validateHostname:i}}function dy(e){return e===void 0?$J:gM(e)}var $J,my=y(()=>{l();s(gM,"setDefaultsImpl");$J=gM({});s(dy,"setDefaults")});function py(e,t){return t.length===e.length?"":e.slice(0,-t.length-1)}var yM=y(()=>{l();s(py,"getSubdomain")});function fy(){return{domain:null,domainWithoutSuffix:null,hostname:null,isIcann:null,isIp:null,isPrivate:null,publicSuffix:null,subdomain:null}}function hy(e){e.domain=null,e.domainWithoutSuffix=null,e.hostname=null,e.isIcann=null,e.isIp=null,e.isPrivate=null,e.publicSuffix=null,e.subdomain=null}function gy(e,t,n,r,a){let o=dy(r);return typeof e!="string"||(o.extractHostname?o.mixedInputs?a.hostname=cp(e,up(e)):a.hostname=cp(e,!1):a.hostname=e,t===0||a.hostname===null)||o.detectIp&&(a.isIp=ly(a.hostname),a.isIp)?a:o.validateHostname&&o.extractHostname&&!up(a.hostname)?(a.hostname=null,a):(n(a.hostname,o,a),t===2||a.publicSuffix===null||(a.domain=cy(a.publicSuffix,a.hostname,o),t===3||a.domain===null)||(a.subdomain=py(a.hostname,a.domain),t===4)||(a.domainWithoutSuffix=uy(a.domain,a.publicSuffix)),a)}var vM=y(()=>{l();lM();dM();mM();pM();hM();my();yM();s(fy,"getEmptyResult");s(hy,"resetResult");s(gy,"parseImpl")});function lp(e,t,n){if(!t.allowPrivateDomains&&e.length>3){let r=e.length-1,a=e.charCodeAt(r),o=e.charCodeAt(r-1),i=e.charCodeAt(r-2),c=e.charCodeAt(r-3);if(a===109&&o===111&&i===99&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="com",!0;if(a===103&&o===114&&i===111&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="org",!0;if(a===117&&o===100&&i===101&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="edu",!0;if(a===118&&o===111&&i===103&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="gov",!0;if(a===116&&o===101&&i===110&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="net",!0;if(a===101&&o===100&&i===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="de",!0}return!1}var bM=y(()=>{l();s(lp,"default")});var yy=y(()=>{l();vM();bM();my()});var wM,DM,EM=y(()=>{l();wM=function(){let e=[1,{}],t=[0,{city:e}];return[0,{ck:[0,{www:e}],jp:[0,{kawasaki:t,kitakyushu:t,kobe:t,nagoya:t,sapporo:t,sendai:t,yokohama:t}]}]}(),DM=function(){let e=[1,{}],t=[1,{com:e,edu:e,gov:e,net:e,mil:e,org:e}],n=[1,{gov:e,com:e,org:e,net:e,edu:e}],r=[1,{gov:e}],a=[1,{com:e}],o=[0,{"*":e}],i=[1,{com:e,edu:e,net:e,org:e}],c=[1,{co:e,net:e,org:e}],u=[1,{co:e,com:e,edu:e,gov:e,net:e,org:e}],d=[1,{com:e,org:e,net:e,edu:e,sch:e,gov:e,mil:e,name:e}],m=[1,{edu:e,biz:e,net:e,org:e,gov:e,info:e,com:e}],p=[1,{gs:e}],h=[0,{nes:e}],f=[1,{k12:e,cc:e,lib:e}],g=[1,{cc:e}],v=[1,{cc:e,lib:e}];return[0,{ac:t,ad:[1,{nom:e}],ae:[1,{co:e,net:e,org:e,sch:e,ac:e,gov:e,mil:e}],aero:[1,{"accident-investigation":e,"accident-prevention":e,aerobatic:e,aeroclub:e,aerodrome:e,agents:e,aircraft:e,airline:e,airport:e,"air-surveillance":e,airtraffic:e,"air-traffic-control":e,ambulance:e,amusement:e,association:e,author:e,ballooning:e,broker:e,caa:e,cargo:e,catering:e,certification:e,
championship:e,charter:e,civilaviation:e,club:e,conference:e,consultant:e,consulting:e,control:e,council:e,crew:e,design:e,dgca:e,educator:e,emergency:e,engine:e,engineer:e,entertainment:e,equipment:e,exchange:e,express:e,federation:e,flight:e,fuel:e,gliding:e,government:e,groundhandling:e,group:e,hanggliding:e,homebuilt:e,insurance:e,journal:e,journalist:e,leasing:e,logistics:e,magazine:e,maintenance:e,media:e,microlight:e,modelling:e,navigation:e,parachuting:e,paragliding:e,"passenger-association":e,pilot:e,press:e,production:e,recreation:e,repbody:e,res:e,research:e,rotorcraft:e,safety:e,scientist:e,services:e,show:e,skydiving:e,software:e,student:e,trader:e,trading:e,trainer:e,union:e,workinggroup:e,works:e}],af:n,ag:[1,{com:e,org:e,net:e,co:e,nom:e}],ai:[1,{off:e,com:e,net:e,org:e}],al:t,am:[1,{co:e,com:e,commune:e,net:e,org:e}],ao:[1,{ed:e,gv:e,og:e,co:e,pb:e,it:e}],aq:e,ar:[1,{bet:e,com:e,coop:e,edu:e,gob:e,gov:e,int:e,mil:e,musica:e,mutual:e,net:e,org:e,senasa:e,tur:e}],arpa:[1,
{e164:e,"in-addr":e,ip6:e,iris:e,uri:e,urn:e}],as:r,asia:e,at:[1,{ac:[1,{sth:e}],co:e,gv:e,or:e}],au:[1,{com:e,net:e,org:e,edu:[1,{act:e,catholic:e,nsw:[1,{schools:e}],nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],gov:[1,{qld:e,sa:e,tas:e,vic:e,wa:e}],asn:e,id:e,info:e,conf:e,oz:e,act:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],aw:a,ax:e,az:[1,{com:e,net:e,int:e,gov:e,org:e,edu:e,info:e,pp:e,mil:e,name:e,pro:e,biz:e}],ba:t,bb:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,net:e,org:e,store:e,tv:e}],bd:o,be:[1,{ac:e}],bf:r,bg:[1,{0:e,1:e,2:e,3:e,4:e,5:e,6:e,7:e,8:e,9:e,a:e,b:e,c:e,d:e,e,f:e,g:e,h:e,i:e,j:e,k:e,l:e,m:e,n:e,o:e,p:e,q:e,r:e,s:e,t:e,u:e,v:e,w:e,x:e,y:e,z:e}],bh:n,bi:[1,{co:e,com:e,edu:e,or:e,org:e}],biz:e,bj:[1,{africa:e,agro:e,architectes:e,assur:e,avocats:e,co:e,com:e,eco:e,econo:e,edu:e,info:e,loisirs:e,money:e,net:e,org:e,ote:e,resto:e,restaurant:e,tourism:e,univ:e}],bm:n,bn:n,bo:[1,{com:e,edu:e,gob:e,int:e,org:e,net:e,mil:e,tv:e,web:e,academia:e,agro:e,arte:e,blog:e,bolivia:e,ciencia:e,cooperativa:e,
democracia:e,deporte:e,ecologia:e,economia:e,empresa:e,indigena:e,industria:e,info:e,medicina:e,movimiento:e,musica:e,natural:e,nombre:e,noticias:e,patria:e,politica:e,profesional:e,plurinacional:e,pueblo:e,revista:e,salud:e,tecnologia:e,tksat:e,transporte:e,wiki:e}],br:[1,{"9guacu":e,abc:e,adm:e,adv:e,agr:e,aju:e,am:e,anani:e,aparecida:e,app:e,arq:e,art:e,ato:e,b:e,barueri:e,belem:e,bhz:e,bib:e,bio:e,blog:e,bmd:e,boavista:e,bsb:e,campinagrande:e,campinas:e,caxias:e,cim:e,cng:e,cnt:e,com:e,contagem:e,coop:e,coz:e,cri:e,cuiaba:e,curitiba:e,def:e,des:e,det:e,dev:e,ecn:e,eco:e,edu:e,emp:e,enf:e,eng:e,esp:e,etc:e,eti:e,far:e,feira:e,flog:e,floripa:e,fm:e,fnd:e,fortal:e,fot:e,foz:e,fst:e,g12:e,geo:e,ggf:e,goiania:e,gov:[1,{ac:e,al:e,am:e,ap:e,ba:e,ce:e,df:e,es:e,go:e,ma:e,mg:e,ms:e,mt:e,pa:e,pb:e,pe:e,pi:e,pr:e,rj:e,rn:e,ro:e,rr:e,rs:e,sc:e,se:e,sp:e,to:e}],gru:e,imb:e,ind:e,inf:e,jab:e,jampa:e,jdf:e,joinville:e,jor:e,jus:e,leg:e,lel:e,log:e,londrina:e,macapa:e,maceio:e,manaus:e,maringa:e,mat:e,
med:e,mil:e,morena:e,mp:e,mus:e,natal:e,net:e,niteroi:e,nom:o,not:e,ntr:e,odo:e,ong:e,org:e,osasco:e,palmas:e,poa:e,ppg:e,pro:e,psc:e,psi:e,pvh:e,qsl:e,radio:e,rec:e,recife:e,rep:e,ribeirao:e,rio:e,riobranco:e,riopreto:e,salvador:e,sampa:e,santamaria:e,santoandre:e,saobernardo:e,saogonca:e,seg:e,sjc:e,slg:e,slz:e,sorocaba:e,srv:e,taxi:e,tc:e,tec:e,teo:e,the:e,tmp:e,trd:e,tur:e,tv:e,udi:e,vet:e,vix:e,vlog:e,wiki:e,zlg:e}],bs:n,bt:n,bv:e,bw:[1,{co:e,org:e}],by:[1,{gov:e,mil:e,com:e,of:e}],bz:n,ca:[1,{ab:e,bc:e,mb:e,nb:e,nf:e,nl:e,ns:e,nt:e,nu:e,on:e,pe:e,qc:e,sk:e,yk:e,gc:e}],cat:e,cc:e,cd:r,cf:e,cg:e,ch:e,ci:[1,{org:e,or:e,com:e,co:e,edu:e,ed:e,ac:e,net:e,go:e,asso:e,"xn--aroport-bya":e,aéroport:e,int:e,presse:e,md:e,gouv:e}],ck:o,cl:[1,{co:e,gob:e,gov:e,mil:e}],cm:[1,{co:e,com:e,gov:e,net:e}],cn:[1,{ac:e,com:e,edu:e,gov:e,net:e,org:e,mil:e,"xn--55qx5d":e,公司:e,"xn--io0a7i":e,网络:e,"xn--od0alg":e,網絡:e,ah:e,bj:e,cq:e,fj:e,gd:e,gs:e,gz:e,gx:e,ha:e,hb:e,he:e,hi:e,hl:e,hn:e,jl:e,
js:e,jx:e,ln:e,nm:e,nx:e,qh:e,sc:e,sd:e,sh:e,sn:e,sx:e,tj:e,xj:e,xz:e,yn:e,zj:e,hk:e,mo:e,tw:e}],co:[1,{arts:e,com:e,edu:e,firm:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rec:e,web:e}],com:e,coop:e,cr:[1,{ac:e,co:e,ed:e,fi:e,go:e,or:e,sa:e}],cu:[1,{com:e,edu:e,org:e,net:e,gov:e,inf:e}],cv:[1,{com:e,edu:e,int:e,nome:e,org:e}],cw:i,cx:r,cy:[1,{ac:e,biz:e,com:e,ekloges:e,gov:e,ltd:e,mil:e,net:e,org:e,press:e,pro:e,tm:e}],cz:e,de:e,dj:e,dk:e,dm:n,do:[1,{art:e,com:e,edu:e,gob:e,gov:e,mil:e,net:e,org:e,sld:e,web:e}],dz:[1,{art:e,asso:e,com:e,edu:e,gov:e,org:e,net:e,pol:e,soc:e,tm:e}],ec:[1,{com:e,info:e,net:e,fin:e,k12:e,med:e,pro:e,org:e,edu:e,gov:e,gob:e,mil:e}],edu:e,ee:[1,{edu:e,gov:e,riik:e,lib:e,med:e,com:e,pri:e,aip:e,org:e,fie:e}],eg:[1,{com:e,edu:e,eun:e,gov:e,mil:e,name:e,net:e,org:e,sci:e}],er:o,es:[1,{com:e,nom:e,org:e,gob:e,edu:e}],et:[1,{com:e,gov:e,org:e,edu:e,biz:e,name:e,info:e,net:e}],eu:e,fi:[1,{aland:e}],fj:[1,{ac:e,biz:e,com:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],
fk:o,fm:i,fo:e,fr:[1,{asso:e,com:e,gouv:e,nom:e,prd:e,tm:e,avoues:e,cci:e,greta:e,"huissier-justice":e}],ga:e,gb:e,gd:[1,{edu:e,gov:e}],ge:[1,{com:e,edu:e,gov:e,org:e,mil:e,net:e,pvt:e}],gf:e,gg:c,gh:[1,{com:e,edu:e,gov:e,org:e,mil:e}],gi:[1,{com:e,ltd:e,gov:e,mod:e,edu:e,org:e}],gl:[1,{co:e,com:e,edu:e,net:e,org:e}],gm:e,gn:[1,{ac:e,com:e,edu:e,gov:e,org:e,net:e}],gov:e,gp:[1,{com:e,net:e,mobi:e,edu:e,org:e,asso:e}],gq:e,gr:n,gs:e,gt:[1,{com:e,edu:e,gob:e,ind:e,mil:e,net:e,org:e}],gu:[1,{com:e,edu:e,gov:e,guam:e,info:e,net:e,org:e,web:e}],gw:e,gy:u,hk:[1,{com:e,edu:e,gov:e,idv:e,net:e,org:e,"xn--55qx5d":e,公司:e,"xn--wcvs22d":e,教育:e,"xn--lcvr32d":e,敎育:e,"xn--mxtq1m":e,政府:e,"xn--gmqw5a":e,個人:e,"xn--ciqpn":e,个人:e,"xn--gmq050i":e,箇人:e,"xn--zf0avx":e,網络:e,"xn--io0a7i":e,网络:e,"xn--mk0axi":e,组織:e,"xn--od0alg":e,網絡:e,"xn--od0aq3b":e,网絡:e,"xn--tn0ag":e,组织:e,"xn--uc0atv":e,組織:e,"xn--uc0ay4a":e,組织:e}],hm:e,hn:[1,{com:e,edu:e,org:e,net:e,
mil:e,gob:e}],hr:[1,{iz:e,from:e,name:e,com:e}],ht:[1,{com:e,shop:e,firm:e,info:e,adult:e,net:e,pro:e,org:e,med:e,art:e,coop:e,pol:e,asso:e,edu:e,rel:e,gouv:e,perso:e}],hu:[1,{2e3:e,co:e,info:e,org:e,priv:e,sport:e,tm:e,agrar:e,bolt:e,casino:e,city:e,erotica:e,erotika:e,film:e,forum:e,games:e,hotel:e,ingatlan:e,jogasz:e,konyvelo:e,lakas:e,media:e,news:e,reklam:e,sex:e,shop:e,suli:e,szex:e,tozsde:e,utazas:e,video:e}],id:[1,{ac:e,biz:e,co:e,desa:e,go:e,mil:e,my:e,net:e,or:e,ponpes:e,sch:e,web:e}],ie:r,il:[1,{ac:e,co:e,gov:e,idf:e,k12:e,muni:e,net:e,org:e}],"xn--4dbrk0ce":[1,{"xn--4dbgdty6c":e,"xn--5dbhl8d":e,"xn--8dbq2a":e,"xn--hebda8b":e}],ישראל:[1,{אקדמיה:e,ישוב:e,צהל:e,ממשל:e}],im:[1,{ac:e,co:[1,{ltd:e,plc:e}],com:e,net:e,org:e,tt:e,tv:e}],in:[1,{"5g":e,"6g":e,ac:e,ai:e,am:e,bihar:e,biz:e,business:e,ca:e,cn:e,co:e,com:e,coop:e,cs:e,delhi:e,dr:e,edu:e,er:e,firm:e,gen:e,gov:e,gujarat:e,ind:e,info:e,int:e,internet:e,io:e,me:e,mil:e,net:e,nic:e,org:e,pg:e,post:e,pro:e,
res:e,travel:e,tv:e,uk:e,up:e,us:e}],info:e,int:[1,{eu:e}],io:a,iq:t,ir:[1,{ac:e,co:e,gov:e,id:e,net:e,org:e,sch:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e}],is:[1,{net:e,com:e,edu:e,gov:e,org:e,int:e}],it:[1,{gov:e,edu:e,abr:e,abruzzo:e,"aosta-valley":e,aostavalley:e,bas:e,basilicata:e,cal:e,calabria:e,cam:e,campania:e,"emilia-romagna":e,emiliaromagna:e,emr:e,"friuli-v-giulia":e,"friuli-ve-giulia":e,"friuli-vegiulia":e,"friuli-venezia-giulia":e,"friuli-veneziagiulia":e,"friuli-vgiulia":e,"friuliv-giulia":e,"friulive-giulia":e,friulivegiulia:e,"friulivenezia-giulia":e,friuliveneziagiulia:e,friulivgiulia:e,fvg:e,laz:e,lazio:e,lig:e,liguria:e,lom:e,lombardia:e,lombardy:e,lucania:e,mar:e,marche:e,mol:e,molise:e,piedmont:e,piemonte:e,pmn:e,pug:e,puglia:e,sar:e,sardegna:e,sardinia:e,sic:e,sicilia:e,sicily:e,taa:e,tos:e,toscana:e,"trentin-sud-tirol":e,"xn--trentin-sd-tirol-rzb":e,"trentin-süd-tirol":e,"trentin-sudtirol":e,"xn--trentin-sdtirol-7vb":e,"trentin-südtirol":e,
"trentin-sued-tirol":e,"trentin-suedtirol":e,"trentino-a-adige":e,"trentino-aadige":e,"trentino-alto-adige":e,"trentino-altoadige":e,"trentino-s-tirol":e,"trentino-stirol":e,"trentino-sud-tirol":e,"xn--trentino-sd-tirol-c3b":e,"trentino-süd-tirol":e,"trentino-sudtirol":e,"xn--trentino-sdtirol-szb":e,"trentino-südtirol":e,"trentino-sued-tirol":e,"trentino-suedtirol":e,trentino:e,"trentinoa-adige":e,trentinoaadige:e,"trentinoalto-adige":e,trentinoaltoadige:e,"trentinos-tirol":e,trentinostirol:e,"trentinosud-tirol":e,"xn--trentinosd-tirol-rzb":e,"trentinosüd-tirol":e,trentinosudtirol:e,"xn--trentinosdtirol-7vb":e,trentinosüdtirol:e,"trentinosued-tirol":e,trentinosuedtirol:e,"trentinsud-tirol":e,"xn--trentinsd-tirol-6vb":e,"trentinsüd-tirol":e,trentinsudtirol:e,"xn--trentinsdtirol-nsb":e,trentinsüdtirol:e,"trentinsued-tirol":e,trentinsuedtirol:e,tuscany:e,umb:e,umbria:e,"val-d-aosta":e,"val-daosta":e,"vald-aosta":e,valdaosta:e,"valle-aosta":e,"valle-d-aosta":e,"valle-daosta":e,valleaosta:e,
"valled-aosta":e,valledaosta:e,"vallee-aoste":e,"xn--valle-aoste-ebb":e,"vallée-aoste":e,"vallee-d-aoste":e,"xn--valle-d-aoste-ehb":e,"vallée-d-aoste":e,valleeaoste:e,"xn--valleaoste-e7a":e,valléeaoste:e,valleedaoste:e,"xn--valledaoste-ebb":e,valléedaoste:e,vao:e,vda:e,ven:e,veneto:e,ag:e,agrigento:e,al:e,alessandria:e,"alto-adige":e,altoadige:e,an:e,ancona:e,"andria-barletta-trani":e,"andria-trani-barletta":e,andriabarlettatrani:e,andriatranibarletta:e,ao:e,aosta:e,aoste:e,ap:e,aq:e,aquila:e,ar:e,arezzo:e,"ascoli-piceno":e,ascolipiceno:e,asti:e,at:e,av:e,avellino:e,ba:e,"balsan-sudtirol":e,"xn--balsan-sdtirol-nsb":e,"balsan-südtirol":e,"balsan-suedtirol":e,balsan:e,bari:e,"barletta-trani-andria":e,barlettatraniandria:e,belluno:e,benevento:e,bergamo:e,bg:e,bi:e,biella:e,bl:e,bn:e,bo:e,bologna:e,"bolzano-altoadige":e,bolzano:e,"bozen-sudtirol":e,"xn--bozen-sdtirol-2ob":e,"bozen-südtirol":e,"bozen-suedtirol":e,bozen:e,br:e,brescia:e,brindisi:e,bs:e,bt:e,"bulsan-sudtirol":e,"xn--bul\
san-sdtirol-nsb":e,"bulsan-südtirol":e,"bulsan-suedtirol":e,bulsan:e,bz:e,ca:e,cagliari:e,caltanissetta:e,"campidano-medio":e,campidanomedio:e,campobasso:e,"carbonia-iglesias":e,carboniaiglesias:e,"carrara-massa":e,carraramassa:e,caserta:e,catania:e,catanzaro:e,cb:e,ce:e,"cesena-forli":e,"xn--cesena-forl-mcb":e,"cesena-forlì":e,cesenaforli:e,"xn--cesenaforl-i8a":e,cesenaforlì:e,ch:e,chieti:e,ci:e,cl:e,cn:e,co:e,como:e,cosenza:e,cr:e,cremona:e,crotone:e,cs:e,ct:e,cuneo:e,cz:e,"dell-ogliastra":e,dellogliastra:e,en:e,enna:e,fc:e,fe:e,fermo:e,ferrara:e,fg:e,fi:e,firenze:e,florence:e,fm:e,foggia:e,"forli-cesena":e,"xn--forl-cesena-fcb":e,"forlì-cesena":e,forlicesena:e,"xn--forlcesena-c8a":e,forlìcesena:e,fr:e,frosinone:e,ge:e,genoa:e,genova:e,go:e,gorizia:e,gr:e,grosseto:e,"iglesias-carbonia":e,iglesiascarbonia:e,im:e,imperia:e,is:e,isernia:e,kr:e,"la-spezia":e,laquila:e,laspezia:e,latina:e,lc:e,le:e,lecce:e,lecco:e,li:e,livorno:e,lo:e,lodi:e,lt:e,lu:e,lucca:e,macerata:e,mantova:e,"mas\
sa-carrara":e,massacarrara:e,matera:e,mb:e,mc:e,me:e,"medio-campidano":e,mediocampidano:e,messina:e,mi:e,milan:e,milano:e,mn:e,mo:e,modena:e,"monza-brianza":e,"monza-e-della-brianza":e,monza:e,monzabrianza:e,monzaebrianza:e,monzaedellabrianza:e,ms:e,mt:e,na:e,naples:e,napoli:e,no:e,novara:e,nu:e,nuoro:e,og:e,ogliastra:e,"olbia-tempio":e,olbiatempio:e,or:e,oristano:e,ot:e,pa:e,padova:e,padua:e,palermo:e,parma:e,pavia:e,pc:e,pd:e,pe:e,perugia:e,"pesaro-urbino":e,pesarourbino:e,pescara:e,pg:e,pi:e,piacenza:e,pisa:e,pistoia:e,pn:e,po:e,pordenone:e,potenza:e,pr:e,prato:e,pt:e,pu:e,pv:e,pz:e,ra:e,ragusa:e,ravenna:e,rc:e,re:e,"reggio-calabria":e,"reggio-emilia":e,reggiocalabria:e,reggioemilia:e,rg:e,ri:e,rieti:e,rimini:e,rm:e,rn:e,ro:e,roma:e,rome:e,rovigo:e,sa:e,salerno:e,sassari:e,savona:e,si:e,siena:e,siracusa:e,so:e,sondrio:e,sp:e,sr:e,ss:e,suedtirol:e,"xn--sdtirol-n2a":e,südtirol:e,sv:e,ta:e,taranto:e,te:e,"tempio-olbia":e,tempioolbia:e,teramo:e,terni:e,tn:e,to:e,torino:e,tp:e,tr:e,"tra\
ni-andria-barletta":e,"trani-barletta-andria":e,traniandriabarletta:e,tranibarlettaandria:e,trapani:e,trento:e,treviso:e,trieste:e,ts:e,turin:e,tv:e,ud:e,udine:e,"urbino-pesaro":e,urbinopesaro:e,va:e,varese:e,vb:e,vc:e,ve:e,venezia:e,venice:e,verbania:e,vercelli:e,verona:e,vi:e,"vibo-valentia":e,vibovalentia:e,vicenza:e,viterbo:e,vr:e,vs:e,vt:e,vv:e}],je:c,jm:o,jo:d,jobs:e,jp:[1,{ac:e,ad:e,co:e,ed:e,go:e,gr:e,lg:e,ne:e,or:e,aichi:[1,{aisai:e,ama:e,anjo:e,asuke:e,chiryu:e,chita:e,fuso:e,gamagori:e,handa:e,hazu:e,hekinan:e,higashiura:e,ichinomiya:e,inazawa:e,inuyama:e,isshiki:e,iwakura:e,kanie:e,kariya:e,kasugai:e,kira:e,kiyosu:e,komaki:e,konan:e,kota:e,mihama:e,miyoshi:e,nishio:e,nisshin:e,obu:e,oguchi:e,oharu:e,okazaki:e,owariasahi:e,seto:e,shikatsu:e,shinshiro:e,shitara:e,tahara:e,takahama:e,tobishima:e,toei:e,togo:e,tokai:e,tokoname:e,toyoake:e,toyohashi:e,toyokawa:e,toyone:e,toyota:e,tsushima:e,yatomi:e}],akita:[1,{akita:e,daisen:e,fujisato:e,gojome:e,hachirogata:e,happou:e,higashinaruse:e,
honjo:e,honjyo:e,ikawa:e,kamikoani:e,kamioka:e,katagami:e,kazuno:e,kitaakita:e,kosaka:e,kyowa:e,misato:e,mitane:e,moriyoshi:e,nikaho:e,noshiro:e,odate:e,oga:e,ogata:e,semboku:e,yokote:e,yurihonjo:e}],aomori:[1,{aomori:e,gonohe:e,hachinohe:e,hashikami:e,hiranai:e,hirosaki:e,itayanagi:e,kuroishi:e,misawa:e,mutsu:e,nakadomari:e,noheji:e,oirase:e,owani:e,rokunohe:e,sannohe:e,shichinohe:e,shingo:e,takko:e,towada:e,tsugaru:e,tsuruta:e}],chiba:[1,{abiko:e,asahi:e,chonan:e,chosei:e,choshi:e,chuo:e,funabashi:e,futtsu:e,hanamigawa:e,ichihara:e,ichikawa:e,ichinomiya:e,inzai:e,isumi:e,kamagaya:e,kamogawa:e,kashiwa:e,katori:e,katsuura:e,kimitsu:e,kisarazu:e,kozaki:e,kujukuri:e,kyonan:e,matsudo:e,midori:e,mihama:e,minamiboso:e,mobara:e,mutsuzawa:e,nagara:e,nagareyama:e,narashino:e,narita:e,noda:e,oamishirasato:e,omigawa:e,onjuku:e,otaki:e,sakae:e,sakura:e,shimofusa:e,shirako:e,shiroi:e,shisui:e,sodegaura:e,sosa:e,tako:e,tateyama:e,togane:e,tohnosho:e,tomisato:e,urayasu:e,yachimata:e,yachiyo:e,yokaichiba:e,
yokoshibahikari:e,yotsukaido:e}],ehime:[1,{ainan:e,honai:e,ikata:e,imabari:e,iyo:e,kamijima:e,kihoku:e,kumakogen:e,masaki:e,matsuno:e,matsuyama:e,namikata:e,niihama:e,ozu:e,saijo:e,seiyo:e,shikokuchuo:e,tobe:e,toon:e,uchiko:e,uwajima:e,yawatahama:e}],fukui:[1,{echizen:e,eiheiji:e,fukui:e,ikeda:e,katsuyama:e,mihama:e,minamiechizen:e,obama:e,ohi:e,ono:e,sabae:e,sakai:e,takahama:e,tsuruga:e,wakasa:e}],fukuoka:[1,{ashiya:e,buzen:e,chikugo:e,chikuho:e,chikujo:e,chikushino:e,chikuzen:e,chuo:e,dazaifu:e,fukuchi:e,hakata:e,higashi:e,hirokawa:e,hisayama:e,iizuka:e,inatsuki:e,kaho:e,kasuga:e,kasuya:e,kawara:e,keisen:e,koga:e,kurate:e,kurogi:e,kurume:e,minami:e,miyako:e,miyama:e,miyawaka:e,mizumaki:e,munakata:e,nakagawa:e,nakama:e,nishi:e,nogata:e,ogori:e,okagaki:e,okawa:e,oki:e,omuta:e,onga:e,onojo:e,oto:e,saigawa:e,sasaguri:e,shingu:e,shinyoshitomi:e,shonai:e,soeda:e,sue:e,tachiarai:e,tagawa:e,takata:e,toho:e,toyotsu:e,tsuiki:e,ukiha:e,umi:e,usui:e,yamada:e,yame:e,yanagawa:e,yukuhashi:e}],fukushima:[
1,{aizubange:e,aizumisato:e,aizuwakamatsu:e,asakawa:e,bandai:e,date:e,fukushima:e,furudono:e,futaba:e,hanawa:e,higashi:e,hirata:e,hirono:e,iitate:e,inawashiro:e,ishikawa:e,iwaki:e,izumizaki:e,kagamiishi:e,kaneyama:e,kawamata:e,kitakata:e,kitashiobara:e,koori:e,koriyama:e,kunimi:e,miharu:e,mishima:e,namie:e,nango:e,nishiaizu:e,nishigo:e,okuma:e,omotego:e,ono:e,otama:e,samegawa:e,shimogo:e,shirakawa:e,showa:e,soma:e,sukagawa:e,taishin:e,tamakawa:e,tanagura:e,tenei:e,yabuki:e,yamato:e,yamatsuri:e,yanaizu:e,yugawa:e}],gifu:[1,{anpachi:e,ena:e,gifu:e,ginan:e,godo:e,gujo:e,hashima:e,hichiso:e,hida:e,higashishirakawa:e,ibigawa:e,ikeda:e,kakamigahara:e,kani:e,kasahara:e,kasamatsu:e,kawaue:e,kitagata:e,mino:e,minokamo:e,mitake:e,mizunami:e,motosu:e,nakatsugawa:e,ogaki:e,sakahogi:e,seki:e,sekigahara:e,shirakawa:e,tajimi:e,takayama:e,tarui:e,toki:e,tomika:e,wanouchi:e,yamagata:e,yaotsu:e,yoro:e}],gunma:[1,{annaka:e,chiyoda:e,fujioka:e,higashiagatsuma:e,isesaki:e,itakura:e,kanna:e,kanra:e,katashina:e,
kawaba:e,kiryu:e,kusatsu:e,maebashi:e,meiwa:e,midori:e,minakami:e,naganohara:e,nakanojo:e,nanmoku:e,numata:e,oizumi:e,ora:e,ota:e,shibukawa:e,shimonita:e,shinto:e,showa:e,takasaki:e,takayama:e,tamamura:e,tatebayashi:e,tomioka:e,tsukiyono:e,tsumagoi:e,ueno:e,yoshioka:e}],hiroshima:[1,{asaminami:e,daiwa:e,etajima:e,fuchu:e,fukuyama:e,hatsukaichi:e,higashihiroshima:e,hongo:e,jinsekikogen:e,kaita:e,kui:e,kumano:e,kure:e,mihara:e,miyoshi:e,naka:e,onomichi:e,osakikamijima:e,otake:e,saka:e,sera:e,seranishi:e,shinichi:e,shobara:e,takehara:e}],hokkaido:[1,{abashiri:e,abira:e,aibetsu:e,akabira:e,akkeshi:e,asahikawa:e,ashibetsu:e,ashoro:e,assabu:e,atsuma:e,bibai:e,biei:e,bifuka:e,bihoro:e,biratori:e,chippubetsu:e,chitose:e,date:e,ebetsu:e,embetsu:e,eniwa:e,erimo:e,esan:e,esashi:e,fukagawa:e,fukushima:e,furano:e,furubira:e,haboro:e,hakodate:e,hamatonbetsu:e,hidaka:e,higashikagura:e,higashikawa:e,hiroo:e,hokuryu:e,hokuto:e,honbetsu:e,horokanai:e,horonobe:e,ikeda:e,imakane:e,ishikari:e,iwamizawa:e,iwanai:e,
kamifurano:e,kamikawa:e,kamishihoro:e,kamisunagawa:e,kamoenai:e,kayabe:e,kembuchi:e,kikonai:e,kimobetsu:e,kitahiroshima:e,kitami:e,kiyosato:e,koshimizu:e,kunneppu:e,kuriyama:e,kuromatsunai:e,kushiro:e,kutchan:e,kyowa:e,mashike:e,matsumae:e,mikasa:e,minamifurano:e,mombetsu:e,moseushi:e,mukawa:e,muroran:e,naie:e,nakagawa:e,nakasatsunai:e,nakatombetsu:e,nanae:e,nanporo:e,nayoro:e,nemuro:e,niikappu:e,niki:e,nishiokoppe:e,noboribetsu:e,numata:e,obihiro:e,obira:e,oketo:e,okoppe:e,otaru:e,otobe:e,otofuke:e,otoineppu:e,oumu:e,ozora:e,pippu:e,rankoshi:e,rebun:e,rikubetsu:e,rishiri:e,rishirifuji:e,saroma:e,sarufutsu:e,shakotan:e,shari:e,shibecha:e,shibetsu:e,shikabe:e,shikaoi:e,shimamaki:e,shimizu:e,shimokawa:e,shinshinotsu:e,shintoku:e,shiranuka:e,shiraoi:e,shiriuchi:e,sobetsu:e,sunagawa:e,taiki:e,takasu:e,takikawa:e,takinoue:e,teshikaga:e,tobetsu:e,tohma:e,tomakomai:e,tomari:e,toya:e,toyako:e,toyotomi:e,toyoura:e,tsubetsu:e,tsukigata:e,urakawa:e,urausu:e,uryu:e,utashinai:e,wakkanai:e,wassamu:e,
yakumo:e,yoichi:e}],hyogo:[1,{aioi:e,akashi:e,ako:e,amagasaki:e,aogaki:e,asago:e,ashiya:e,awaji:e,fukusaki:e,goshiki:e,harima:e,himeji:e,ichikawa:e,inagawa:e,itami:e,kakogawa:e,kamigori:e,kamikawa:e,kasai:e,kasuga:e,kawanishi:e,miki:e,minamiawaji:e,nishinomiya:e,nishiwaki:e,ono:e,sanda:e,sannan:e,sasayama:e,sayo:e,shingu:e,shinonsen:e,shiso:e,sumoto:e,taishi:e,taka:e,takarazuka:e,takasago:e,takino:e,tamba:e,tatsuno:e,toyooka:e,yabu:e,yashiro:e,yoka:e,yokawa:e}],ibaraki:[1,{ami:e,asahi:e,bando:e,chikusei:e,daigo:e,fujishiro:e,hitachi:e,hitachinaka:e,hitachiomiya:e,hitachiota:e,ibaraki:e,ina:e,inashiki:e,itako:e,iwama:e,joso:e,kamisu:e,kasama:e,kashima:e,kasumigaura:e,koga:e,miho:e,mito:e,moriya:e,naka:e,namegata:e,oarai:e,ogawa:e,omitama:e,ryugasaki:e,sakai:e,sakuragawa:e,shimodate:e,shimotsuma:e,shirosato:e,sowa:e,suifu:e,takahagi:e,tamatsukuri:e,tokai:e,tomobe:e,tone:e,toride:e,tsuchiura:e,tsukuba:e,uchihara:e,ushiku:e,yachiyo:e,yamagata:e,yawara:e,yuki:e}],ishikawa:[1,{anamizu:e,hakui:e,
hakusan:e,kaga:e,kahoku:e,kanazawa:e,kawakita:e,komatsu:e,nakanoto:e,nanao:e,nomi:e,nonoichi:e,noto:e,shika:e,suzu:e,tsubata:e,tsurugi:e,uchinada:e,wajima:e}],iwate:[1,{fudai:e,fujisawa:e,hanamaki:e,hiraizumi:e,hirono:e,ichinohe:e,ichinoseki:e,iwaizumi:e,iwate:e,joboji:e,kamaishi:e,kanegasaki:e,karumai:e,kawai:e,kitakami:e,kuji:e,kunohe:e,kuzumaki:e,miyako:e,mizusawa:e,morioka:e,ninohe:e,noda:e,ofunato:e,oshu:e,otsuchi:e,rikuzentakata:e,shiwa:e,shizukuishi:e,sumita:e,tanohata:e,tono:e,yahaba:e,yamada:e}],kagawa:[1,{ayagawa:e,higashikagawa:e,kanonji:e,kotohira:e,manno:e,marugame:e,mitoyo:e,naoshima:e,sanuki:e,tadotsu:e,takamatsu:e,tonosho:e,uchinomi:e,utazu:e,zentsuji:e}],kagoshima:[1,{akune:e,amami:e,hioki:e,isa:e,isen:e,izumi:e,kagoshima:e,kanoya:e,kawanabe:e,kinko:e,kouyama:e,makurazaki:e,matsumoto:e,minamitane:e,nakatane:e,nishinoomote:e,satsumasendai:e,soo:e,tarumizu:e,yusui:e}],kanagawa:[1,{aikawa:e,atsugi:e,ayase:e,chigasaki:e,ebina:e,fujisawa:e,hadano:e,hakone:e,hiratsuka:e,isehara:e,
kaisei:e,kamakura:e,kiyokawa:e,matsuda:e,minamiashigara:e,miura:e,nakai:e,ninomiya:e,odawara:e,oi:e,oiso:e,sagamihara:e,samukawa:e,tsukui:e,yamakita:e,yamato:e,yokosuka:e,yugawara:e,zama:e,zushi:e}],kochi:[1,{aki:e,geisei:e,hidaka:e,higashitsuno:e,ino:e,kagami:e,kami:e,kitagawa:e,kochi:e,mihara:e,motoyama:e,muroto:e,nahari:e,nakamura:e,nankoku:e,nishitosa:e,niyodogawa:e,ochi:e,okawa:e,otoyo:e,otsuki:e,sakawa:e,sukumo:e,susaki:e,tosa:e,tosashimizu:e,toyo:e,tsuno:e,umaji:e,yasuda:e,yusuhara:e}],kumamoto:[1,{amakusa:e,arao:e,aso:e,choyo:e,gyokuto:e,kamiamakusa:e,kikuchi:e,kumamoto:e,mashiki:e,mifune:e,minamata:e,minamioguni:e,nagasu:e,nishihara:e,oguni:e,ozu:e,sumoto:e,takamori:e,uki:e,uto:e,yamaga:e,yamato:e,yatsushiro:e}],kyoto:[1,{ayabe:e,fukuchiyama:e,higashiyama:e,ide:e,ine:e,joyo:e,kameoka:e,kamo:e,kita:e,kizu:e,kumiyama:e,kyotamba:e,kyotanabe:e,kyotango:e,maizuru:e,minami:e,minamiyamashiro:e,miyazu:e,muko:e,nagaokakyo:e,nakagyo:e,nantan:e,oyamazaki:e,sakyo:e,seika:e,tanabe:e,uji:e,
ujitawara:e,wazuka:e,yamashina:e,yawata:e}],mie:[1,{asahi:e,inabe:e,ise:e,kameyama:e,kawagoe:e,kiho:e,kisosaki:e,kiwa:e,komono:e,kumano:e,kuwana:e,matsusaka:e,meiwa:e,mihama:e,minamiise:e,misugi:e,miyama:e,nabari:e,shima:e,suzuka:e,tado:e,taiki:e,taki:e,tamaki:e,toba:e,tsu:e,udono:e,ureshino:e,watarai:e,yokkaichi:e}],miyagi:[1,{furukawa:e,higashimatsushima:e,ishinomaki:e,iwanuma:e,kakuda:e,kami:e,kawasaki:e,marumori:e,matsushima:e,minamisanriku:e,misato:e,murata:e,natori:e,ogawara:e,ohira:e,onagawa:e,osaki:e,rifu:e,semine:e,shibata:e,shichikashuku:e,shikama:e,shiogama:e,shiroishi:e,tagajo:e,taiwa:e,tome:e,tomiya:e,wakuya:e,watari:e,yamamoto:e,zao:e}],miyazaki:[1,{aya:e,ebino:e,gokase:e,hyuga:e,kadogawa:e,kawaminami:e,kijo:e,kitagawa:e,kitakata:e,kitaura:e,kobayashi:e,kunitomi:e,kushima:e,mimata:e,miyakonojo:e,miyazaki:e,morotsuka:e,nichinan:e,nishimera:e,nobeoka:e,saito:e,shiiba:e,shintomi:e,takaharu:e,takanabe:e,takazaki:e,tsuno:e}],nagano:[1,{achi:e,agematsu:e,anan:e,aoki:e,asahi:e,azumino:e,
chikuhoku:e,chikuma:e,chino:e,fujimi:e,hakuba:e,hara:e,hiraya:e,iida:e,iijima:e,iiyama:e,iizuna:e,ikeda:e,ikusaka:e,ina:e,karuizawa:e,kawakami:e,kiso:e,kisofukushima:e,kitaaiki:e,komagane:e,komoro:e,matsukawa:e,matsumoto:e,miasa:e,minamiaiki:e,minamimaki:e,minamiminowa:e,minowa:e,miyada:e,miyota:e,mochizuki:e,nagano:e,nagawa:e,nagiso:e,nakagawa:e,nakano:e,nozawaonsen:e,obuse:e,ogawa:e,okaya:e,omachi:e,omi:e,ookuwa:e,ooshika:e,otaki:e,otari:e,sakae:e,sakaki:e,saku:e,sakuho:e,shimosuwa:e,shinanomachi:e,shiojiri:e,suwa:e,suzaka:e,takagi:e,takamori:e,takayama:e,tateshina:e,tatsuno:e,togakushi:e,togura:e,tomi:e,ueda:e,wada:e,yamagata:e,yamanouchi:e,yasaka:e,yasuoka:e}],nagasaki:[1,{chijiwa:e,futsu:e,goto:e,hasami:e,hirado:e,iki:e,isahaya:e,kawatana:e,kuchinotsu:e,matsuura:e,nagasaki:e,obama:e,omura:e,oseto:e,saikai:e,sasebo:e,seihi:e,shimabara:e,shinkamigoto:e,togitsu:e,tsushima:e,unzen:e}],nara:[1,{ando:e,gose:e,heguri:e,higashiyoshino:e,ikaruga:e,ikoma:e,kamikitayama:e,kanmaki:e,kashiba:e,
kashihara:e,katsuragi:e,kawai:e,kawakami:e,kawanishi:e,koryo:e,kurotaki:e,mitsue:e,miyake:e,nara:e,nosegawa:e,oji:e,ouda:e,oyodo:e,sakurai:e,sango:e,shimoichi:e,shimokitayama:e,shinjo:e,soni:e,takatori:e,tawaramoto:e,tenkawa:e,tenri:e,uda:e,yamatokoriyama:e,yamatotakada:e,yamazoe:e,yoshino:e}],niigata:[1,{aga:e,agano:e,gosen:e,itoigawa:e,izumozaki:e,joetsu:e,kamo:e,kariwa:e,kashiwazaki:e,minamiuonuma:e,mitsuke:e,muika:e,murakami:e,myoko:e,nagaoka:e,niigata:e,ojiya:e,omi:e,sado:e,sanjo:e,seiro:e,seirou:e,sekikawa:e,shibata:e,tagami:e,tainai:e,tochio:e,tokamachi:e,tsubame:e,tsunan:e,uonuma:e,yahiko:e,yoita:e,yuzawa:e}],oita:[1,{beppu:e,bungoono:e,bungotakada:e,hasama:e,hiji:e,himeshima:e,hita:e,kamitsue:e,kokonoe:e,kuju:e,kunisaki:e,kusu:e,oita:e,saiki:e,taketa:e,tsukumi:e,usa:e,usuki:e,yufu:e}],okayama:[1,{akaiwa:e,asakuchi:e,bizen:e,hayashima:e,ibara:e,kagamino:e,kasaoka:e,kibichuo:e,kumenan:e,kurashiki:e,maniwa:e,misaki:e,nagi:e,niimi:e,nishiawakura:e,okayama:e,satosho:e,setouchi:e,shinjo:e,
shoo:e,soja:e,takahashi:e,tamano:e,tsuyama:e,wake:e,yakage:e}],okinawa:[1,{aguni:e,ginowan:e,ginoza:e,gushikami:e,haebaru:e,higashi:e,hirara:e,iheya:e,ishigaki:e,ishikawa:e,itoman:e,izena:e,kadena:e,kin:e,kitadaito:e,kitanakagusuku:e,kumejima:e,kunigami:e,minamidaito:e,motobu:e,nago:e,naha:e,nakagusuku:e,nakijin:e,nanjo:e,nishihara:e,ogimi:e,okinawa:e,onna:e,shimoji:e,taketomi:e,tarama:e,tokashiki:e,tomigusuku:e,tonaki:e,urasoe:e,uruma:e,yaese:e,yomitan:e,yonabaru:e,yonaguni:e,zamami:e}],osaka:[1,{abeno:e,chihayaakasaka:e,chuo:e,daito:e,fujiidera:e,habikino:e,hannan:e,higashiosaka:e,higashisumiyoshi:e,higashiyodogawa:e,hirakata:e,ibaraki:e,ikeda:e,izumi:e,izumiotsu:e,izumisano:e,kadoma:e,kaizuka:e,kanan:e,kashiwara:e,katano:e,kawachinagano:e,kishiwada:e,kita:e,kumatori:e,matsubara:e,minato:e,minoh:e,misaki:e,moriguchi:e,neyagawa:e,nishi:e,nose:e,osakasayama:e,sakai:e,sayama:e,sennan:e,settsu:e,shijonawate:e,shimamoto:e,suita:e,tadaoka:e,taishi:e,tajiri:e,takaishi:e,takatsuki:e,tondabayashi:e,
toyonaka:e,toyono:e,yao:e}],saga:[1,{ariake:e,arita:e,fukudomi:e,genkai:e,hamatama:e,hizen:e,imari:e,kamimine:e,kanzaki:e,karatsu:e,kashima:e,kitagata:e,kitahata:e,kiyama:e,kouhoku:e,kyuragi:e,nishiarita:e,ogi:e,omachi:e,ouchi:e,saga:e,shiroishi:e,taku:e,tara:e,tosu:e,yoshinogari:e}],saitama:[1,{arakawa:e,asaka:e,chichibu:e,fujimi:e,fujimino:e,fukaya:e,hanno:e,hanyu:e,hasuda:e,hatogaya:e,hatoyama:e,hidaka:e,higashichichibu:e,higashimatsuyama:e,honjo:e,ina:e,iruma:e,iwatsuki:e,kamiizumi:e,kamikawa:e,kamisato:e,kasukabe:e,kawagoe:e,kawaguchi:e,kawajima:e,kazo:e,kitamoto:e,koshigaya:e,kounosu:e,kuki:e,kumagaya:e,matsubushi:e,minano:e,misato:e,miyashiro:e,miyoshi:e,moroyama:e,nagatoro:e,namegawa:e,niiza:e,ogano:e,ogawa:e,ogose:e,okegawa:e,omiya:e,otaki:e,ranzan:e,ryokami:e,saitama:e,sakado:e,satte:e,sayama:e,shiki:e,shiraoka:e,soka:e,sugito:e,toda:e,tokigawa:e,tokorozawa:e,tsurugashima:e,urawa:e,warabi:e,yashio:e,yokoze:e,yono:e,yorii:e,yoshida:e,yoshikawa:e,yoshimi:e}],shiga:[1,{aisho:e,gamo:e,
higashiomi:e,hikone:e,koka:e,konan:e,kosei:e,koto:e,kusatsu:e,maibara:e,moriyama:e,nagahama:e,nishiazai:e,notogawa:e,omihachiman:e,otsu:e,ritto:e,ryuoh:e,takashima:e,takatsuki:e,torahime:e,toyosato:e,yasu:e}],shimane:[1,{akagi:e,ama:e,gotsu:e,hamada:e,higashiizumo:e,hikawa:e,hikimi:e,izumo:e,kakinoki:e,masuda:e,matsue:e,misato:e,nishinoshima:e,ohda:e,okinoshima:e,okuizumo:e,shimane:e,tamayu:e,tsuwano:e,unnan:e,yakumo:e,yasugi:e,yatsuka:e}],shizuoka:[1,{arai:e,atami:e,fuji:e,fujieda:e,fujikawa:e,fujinomiya:e,fukuroi:e,gotemba:e,haibara:e,hamamatsu:e,higashiizu:e,ito:e,iwata:e,izu:e,izunokuni:e,kakegawa:e,kannami:e,kawanehon:e,kawazu:e,kikugawa:e,kosai:e,makinohara:e,matsuzaki:e,minamiizu:e,mishima:e,morimachi:e,nishiizu:e,numazu:e,omaezaki:e,shimada:e,shimizu:e,shimoda:e,shizuoka:e,susono:e,yaizu:e,yoshida:e}],tochigi:[1,{ashikaga:e,bato:e,haga:e,ichikai:e,iwafune:e,kaminokawa:e,kanuma:e,karasuyama:e,kuroiso:e,mashiko:e,mibu:e,moka:e,motegi:e,nasu:e,nasushiobara:e,nikko:e,nishikata:e,nogi:e,
ohira:e,ohtawara:e,oyama:e,sakura:e,sano:e,shimotsuke:e,shioya:e,takanezawa:e,tochigi:e,tsuga:e,ujiie:e,utsunomiya:e,yaita:e}],tokushima:[1,{aizumi:e,anan:e,ichiba:e,itano:e,kainan:e,komatsushima:e,matsushige:e,mima:e,minami:e,miyoshi:e,mugi:e,nakagawa:e,naruto:e,sanagochi:e,shishikui:e,tokushima:e,wajiki:e}],tokyo:[1,{adachi:e,akiruno:e,akishima:e,aogashima:e,arakawa:e,bunkyo:e,chiyoda:e,chofu:e,chuo:e,edogawa:e,fuchu:e,fussa:e,hachijo:e,hachioji:e,hamura:e,higashikurume:e,higashimurayama:e,higashiyamato:e,hino:e,hinode:e,hinohara:e,inagi:e,itabashi:e,katsushika:e,kita:e,kiyose:e,kodaira:e,koganei:e,kokubunji:e,komae:e,koto:e,kouzushima:e,kunitachi:e,machida:e,meguro:e,minato:e,mitaka:e,mizuho:e,musashimurayama:e,musashino:e,nakano:e,nerima:e,ogasawara:e,okutama:e,ome:e,oshima:e,ota:e,setagaya:e,shibuya:e,shinagawa:e,shinjuku:e,suginami:e,sumida:e,tachikawa:e,taito:e,tama:e,toshima:e}],tottori:[1,{chizu:e,hino:e,kawahara:e,koge:e,kotoura:e,misasa:e,nanbu:e,nichinan:e,sakaiminato:e,tottori:e,
wakasa:e,yazu:e,yonago:e}],toyama:[1,{asahi:e,fuchu:e,fukumitsu:e,funahashi:e,himi:e,imizu:e,inami:e,johana:e,kamiichi:e,kurobe:e,nakaniikawa:e,namerikawa:e,nanto:e,nyuzen:e,oyabe:e,taira:e,takaoka:e,tateyama:e,toga:e,tonami:e,toyama:e,unazuki:e,uozu:e,yamada:e}],wakayama:[1,{arida:e,aridagawa:e,gobo:e,hashimoto:e,hidaka:e,hirogawa:e,inami:e,iwade:e,kainan:e,kamitonda:e,katsuragi:e,kimino:e,kinokawa:e,kitayama:e,koya:e,koza:e,kozagawa:e,kudoyama:e,kushimoto:e,mihama:e,misato:e,nachikatsuura:e,shingu:e,shirahama:e,taiji:e,tanabe:e,wakayama:e,yuasa:e,yura:e}],yamagata:[1,{asahi:e,funagata:e,higashine:e,iide:e,kahoku:e,kaminoyama:e,kaneyama:e,kawanishi:e,mamurogawa:e,mikawa:e,murayama:e,nagai:e,nakayama:e,nanyo:e,nishikawa:e,obanazawa:e,oe:e,oguni:e,ohkura:e,oishida:e,sagae:e,sakata:e,sakegawa:e,shinjo:e,shirataka:e,shonai:e,takahata:e,tendo:e,tozawa:e,tsuruoka:e,yamagata:e,yamanobe:e,yonezawa:e,yuza:e}],yamaguchi:[1,{abu:e,hagi:e,hikari:e,hofu:e,iwakuni:e,kudamatsu:e,mitou:e,nagato:e,oshima:e,
shimonoseki:e,shunan:e,tabuse:e,tokuyama:e,toyota:e,ube:e,yuu:e}],yamanashi:[1,{chuo:e,doshi:e,fuefuki:e,fujikawa:e,fujikawaguchiko:e,fujiyoshida:e,hayakawa:e,hokuto:e,ichikawamisato:e,kai:e,kofu:e,koshu:e,kosuge:e,"minami-alps":e,minobu:e,nakamichi:e,nanbu:e,narusawa:e,nirasaki:e,nishikatsura:e,oshino:e,otsuki:e,showa:e,tabayama:e,tsuru:e,uenohara:e,yamanakako:e,yamanashi:e}],"xn--4pvxs":e,栃木:e,"xn--vgu402c":e,愛知:e,"xn--c3s14m":e,愛媛:e,"xn--f6qx53a":e,兵庫:e,"xn--8pvr4u":e,熊本:e,"xn--uist22h":e,茨城:e,"xn--djrs72d6uy":e,北海道:e,"xn--mkru45i":e,千葉:e,"xn--0trq7p7nn":e,和歌山:e,"xn--8ltr62k":e,長崎:e,"xn--2m4a15e":e,長野:e,"xn--efvn9s":e,新潟:e,"xn--32vp30h":e,青森:e,"xn--4it797k":e,静岡:e,"xn--1lqs71d":e,東京:e,"xn--5rtp49c":e,石川:e,"xn--5js045d":e,埼玉:e,"xn--ehqz56n":e,三重:e,"xn--1lqs03n":e,京都:e,"xn--qqqt11m":e,佐賀:e,"xn--kbrq7o":e,大分:e,"xn--pssu33l":e,大阪:e,"xn--ntsq17g":e,奈良:e,"xn--uisz3g":e,宮城:e,"xn--6btw5a":e,宮崎:e,
"xn--1ctwo":e,富山:e,"xn--6orx2r":e,山口:e,"xn--rht61e":e,山形:e,"xn--rht27z":e,山梨:e,"xn--djty4k":e,岩手:e,"xn--nit225k":e,岐阜:e,"xn--rht3d":e,岡山:e,"xn--klty5x":e,島根:e,"xn--kltx9a":e,広島:e,"xn--kltp7d":e,徳島:e,"xn--uuwu58a":e,沖縄:e,"xn--zbx025d":e,滋賀:e,"xn--ntso0iqx3a":e,神奈川:e,"xn--elqq16h":e,福井:e,"xn--4it168d":e,福岡:e,"xn--klt787d":e,福島:e,"xn--rny31h":e,秋田:e,"xn--7t0a264c":e,群馬:e,"xn--5rtq34k":e,香川:e,"xn--k7yn95e":e,高知:e,"xn--tor131o":e,鳥取:e,"xn--d5qv7z876c":e,鹿児島:e,kawasaki:o,kitakyushu:o,kobe:o,nagoya:o,sapporo:o,sendai:o,yokohama:o}],ke:[1,{ac:e,co:e,go:e,info:e,me:e,mobi:e,ne:e,or:e,sc:e}],kg:t,kh:o,ki:m,km:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,ass:e,com:e,coop:e,asso:e,presse:e,medecin:e,notaires:e,pharmaciens:e,veterinaire:e,gouv:e}],kn:[1,{net:e,org:e,edu:e,gov:e}],kp:[1,{com:e,edu:e,gov:e,org:e,rep:e,tra:e}],kr:[1,{ac:e,co:e,es:e,go:e,hs:e,kg:e,mil:e,ms:e,ne:e,or:e,pe:e,re:e,sc:e,busan:e,chungbuk:e,
chungnam:e,daegu:e,daejeon:e,gangwon:e,gwangju:e,gyeongbuk:e,gyeonggi:e,gyeongnam:e,incheon:e,jeju:e,jeonbuk:e,jeonnam:e,seoul:e,ulsan:e}],kw:[1,{com:e,edu:e,emb:e,gov:e,ind:e,net:e,org:e}],ky:i,kz:t,la:[1,{int:e,net:e,info:e,edu:e,gov:e,per:e,com:e,org:e}],lb:n,lc:u,li:e,lk:[1,{gov:e,sch:e,net:e,int:e,com:e,org:e,edu:e,ngo:e,soc:e,web:e,ltd:e,assn:e,grp:e,hotel:e,ac:e}],lr:n,ls:[1,{ac:e,biz:e,co:e,edu:e,gov:e,info:e,net:e,org:e,sc:e}],lt:r,lu:e,lv:[1,{com:e,edu:e,gov:e,org:e,mil:e,id:e,net:e,asn:e,conf:e}],ly:[1,{com:e,net:e,gov:e,plc:e,edu:e,sch:e,med:e,org:e,id:e}],ma:[1,{co:e,net:e,gov:e,org:e,ac:e,press:e}],mc:[1,{tm:e,asso:e}],md:e,me:[1,{co:e,net:e,org:e,edu:e,ac:e,gov:e,its:e,priv:e}],mg:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,com:e,co:e}],mh:e,mil:e,mk:[1,{com:e,org:e,net:e,edu:e,gov:e,inf:e,name:e}],ml:[1,{com:e,edu:e,gouv:e,gov:e,net:e,org:e,presse:e}],mm:o,mn:[1,{gov:e,edu:e,org:e}],mo:n,mobi:e,mp:e,mq:e,mr:r,ms:n,mt:i,mu:[1,{com:e,net:e,org:e,gov:e,ac:e,co:e,or:e}],museum:e,
mv:[1,{aero:e,biz:e,com:e,coop:e,edu:e,gov:e,info:e,int:e,mil:e,museum:e,name:e,net:e,org:e,pro:e}],mw:[1,{ac:e,biz:e,co:e,com:e,coop:e,edu:e,gov:e,int:e,museum:e,net:e,org:e}],mx:[1,{com:e,org:e,gob:e,edu:e,net:e}],my:[1,{biz:e,com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e}],mz:[1,{ac:e,adv:e,co:e,edu:e,gov:e,mil:e,net:e,org:e}],na:[1,{info:e,pro:e,name:e,school:e,or:e,dr:e,us:e,mx:e,ca:e,in:e,cc:e,tv:e,ws:e,mobi:e,co:e,com:e,org:e}],name:e,nc:[1,{asso:e,nom:e}],ne:e,net:e,nf:[1,{com:e,net:e,per:e,rec:e,web:e,arts:e,firm:e,info:e,other:e,store:e}],ng:[1,{com:e,edu:e,gov:e,i:e,mil:e,mobi:e,name:e,net:e,org:e,sch:e}],ni:[1,{ac:e,biz:e,co:e,com:e,edu:e,gob:e,in:e,info:e,int:e,mil:e,net:e,nom:e,org:e,web:e}],nl:e,no:[1,{fhs:e,vgs:e,fylkesbibl:e,folkebibl:e,museum:e,idrett:e,priv:e,mil:e,stat:e,dep:e,kommune:e,herad:e,aa:p,ah:p,bu:p,fm:p,hl:p,hm:p,"jan-mayen":p,mr:p,nl:p,nt:p,of:p,ol:p,oslo:p,rl:p,sf:p,st:p,svalbard:p,tm:p,tr:p,va:p,vf:p,akrehamn:e,"xn--krehamn-dxa":e,åkrehamn:e,algard:e,"xn\
--lgrd-poac":e,ålgård:e,arna:e,brumunddal:e,bryne:e,bronnoysund:e,"xn--brnnysund-m8ac":e,brønnøysund:e,drobak:e,"xn--drbak-wua":e,drøbak:e,egersund:e,fetsund:e,floro:e,"xn--flor-jra":e,florø:e,fredrikstad:e,hokksund:e,honefoss:e,"xn--hnefoss-q1a":e,hønefoss:e,jessheim:e,jorpeland:e,"xn--jrpeland-54a":e,jørpeland:e,kirkenes:e,kopervik:e,krokstadelva:e,langevag:e,"xn--langevg-jxa":e,langevåg:e,leirvik:e,mjondalen:e,"xn--mjndalen-64a":e,mjøndalen:e,"mo-i-rana":e,mosjoen:e,"xn--mosjen-eya":e,mosjøen:e,nesoddtangen:e,orkanger:e,osoyro:e,"xn--osyro-wua":e,osøyro:e,raholt:e,"xn--rholt-mra":e,råholt:e,sandnessjoen:e,"xn--sandnessjen-ogb":e,sandnessjøen:e,skedsmokorset:e,slattum:e,spjelkavik:e,stathelle:e,stavern:e,stjordalshalsen:e,"xn--stjrdalshalsen-sqb":e,stjørdalshalsen:e,tananger:e,tranby:e,vossevangen:e,afjord:e,"xn--fjord-lra":e,åfjord:e,agdenes:e,al:e,"xn--l-1fa":e,ål:e,alesund:e,"xn--lesund-hua":e,ålesund:e,alstahaug:e,alta:e,"xn--lt-liac":e,áltá:e,alaheadju:e,"xn-\
-laheadju-7ya":e,álaheadju:e,alvdal:e,amli:e,"xn--mli-tla":e,åmli:e,amot:e,"xn--mot-tla":e,åmot:e,andebu:e,andoy:e,"xn--andy-ira":e,andøy:e,andasuolo:e,ardal:e,"xn--rdal-poa":e,årdal:e,aremark:e,arendal:e,"xn--s-1fa":e,ås:e,aseral:e,"xn--seral-lra":e,åseral:e,asker:e,askim:e,askvoll:e,askoy:e,"xn--asky-ira":e,askøy:e,asnes:e,"xn--snes-poa":e,åsnes:e,audnedaln:e,aukra:e,aure:e,aurland:e,"aurskog-holand":e,"xn--aurskog-hland-jnb":e,"aurskog-høland":e,austevoll:e,austrheim:e,averoy:e,"xn--avery-yua":e,averøy:e,balestrand:e,ballangen:e,balat:e,"xn--blt-elab":e,bálát:e,balsfjord:e,bahccavuotna:e,"xn--bhccavuotna-k7a":e,báhccavuotna:e,bamble:e,bardu:e,beardu:e,beiarn:e,bajddar:e,"xn--bjddar-pta":e,bájddar:e,baidar:e,"xn--bidr-5nac":e,báidár:e,berg:e,bergen:e,berlevag:e,"xn--berlevg-jxa":e,berlevåg:e,bearalvahki:e,"xn--bearalvhki-y4a":e,bearalváhki:e,bindal:e,birkenes:e,bjarkoy:e,"xn--bjarky-fya":e,bjarkøy:e,bjerkreim:e,bjugn:e,bodo:e,"xn--bod-2na":e,bodø:e,badaddja:e,"xn\
--bdddj-mrabd":e,bådåddjå:e,budejju:e,bokn:e,bremanger:e,bronnoy:e,"xn--brnny-wuac":e,brønnøy:e,bygland:e,bykle:e,barum:e,"xn--brum-voa":e,bærum:e,telemark:[0,{bo:e,"xn--b-5ga":e,bø:e}],nordland:[0,{bo:e,"xn--b-5ga":e,bø:e,heroy:e,"xn--hery-ira":e,herøy:e}],bievat:e,"xn--bievt-0qa":e,bievát:e,bomlo:e,"xn--bmlo-gra":e,bømlo:e,batsfjord:e,"xn--btsfjord-9za":e,båtsfjord:e,bahcavuotna:e,"xn--bhcavuotna-s4a":e,báhcavuotna:e,dovre:e,drammen:e,drangedal:e,dyroy:e,"xn--dyry-ira":e,dyrøy:e,donna:e,"xn--dnna-gra":e,dønna:e,eid:e,eidfjord:e,eidsberg:e,eidskog:e,eidsvoll:e,eigersund:e,elverum:e,enebakk:e,engerdal:e,etne:e,etnedal:e,evenes:e,evenassi:e,"xn--eveni-0qa01ga":e,evenášši:e,"evje-og-hornnes":e,farsund:e,fauske:e,fuossko:e,fuoisku:e,fedje:e,fet:e,finnoy:e,"xn--finny-yua":e,finnøy:e,fitjar:e,fjaler:e,fjell:e,flakstad:e,flatanger:e,flekkefjord:e,flesberg:e,flora:e,fla:e,"xn--fl-zia":e,flå:e,folldal:e,forsand:e,fosnes:e,frei:e,frogn:e,froland:e,frosta:e,frana:e,"xn--frna-\
woa":e,fræna:e,froya:e,"xn--frya-hra":e,frøya:e,fusa:e,fyresdal:e,forde:e,"xn--frde-gra":e,førde:e,gamvik:e,gangaviika:e,"xn--ggaviika-8ya47h":e,gáŋgaviika:e,gaular:e,gausdal:e,gildeskal:e,"xn--gildeskl-g0a":e,gildeskål:e,giske:e,gjemnes:e,gjerdrum:e,gjerstad:e,gjesdal:e,gjovik:e,"xn--gjvik-wua":e,gjøvik:e,gloppen:e,gol:e,gran:e,grane:e,granvin:e,gratangen:e,grimstad:e,grong:e,kraanghke:e,"xn--kranghke-b0a":e,kråanghke:e,grue:e,gulen:e,hadsel:e,halden:e,halsa:e,hamar:e,hamaroy:e,habmer:e,"xn--hbmer-xqa":e,hábmer:e,hapmir:e,"xn--hpmir-xqa":e,hápmir:e,hammerfest:e,hammarfeasta:e,"xn--hmmrfeasta-s4ac":e,hámmárfeasta:e,haram:e,hareid:e,harstad:e,hasvik:e,aknoluokta:e,"xn--koluokta-7ya57h":e,ákŋoluokta:e,hattfjelldal:e,aarborte:e,haugesund:e,hemne:e,hemnes:e,hemsedal:e,"more-og-romsdal":[0,{heroy:e,sande:e}],"xn--mre-og-romsdal-qqb":[0,{"xn--hery-ira":e,sande:e}],"møre-og-romsdal":[0,{herøy:e,sande:e}],hitra:e,hjartdal:e,hjelmeland:e,hobol:e,"xn--hobl-ira":e,hobøl:e,hof:e,hol:e,
hole:e,holmestrand:e,holtalen:e,"xn--holtlen-hxa":e,holtålen:e,hornindal:e,horten:e,hurdal:e,hurum:e,hvaler:e,hyllestad:e,hagebostad:e,"xn--hgebostad-g3a":e,hægebostad:e,hoyanger:e,"xn--hyanger-q1a":e,høyanger:e,hoylandet:e,"xn--hylandet-54a":e,høylandet:e,ha:e,"xn--h-2fa":e,hå:e,ibestad:e,inderoy:e,"xn--indery-fya":e,inderøy:e,iveland:e,jevnaker:e,jondal:e,jolster:e,"xn--jlster-bya":e,jølster:e,karasjok:e,karasjohka:e,"xn--krjohka-hwab49j":e,kárášjohka:e,karlsoy:e,galsa:e,"xn--gls-elac":e,gálsá:e,karmoy:e,"xn--karmy-yua":e,karmøy:e,kautokeino:e,guovdageaidnu:e,klepp:e,klabu:e,"xn--klbu-woa":e,klæbu:e,kongsberg:e,kongsvinger:e,kragero:e,"xn--krager-gya":e,kragerø:e,kristiansand:e,kristiansund:e,krodsherad:e,"xn--krdsherad-m8a":e,krødsherad:e,kvalsund:e,rahkkeravju:e,"xn--rhkkervju-01af":e,ráhkkerávju:e,kvam:e,kvinesdal:e,kvinnherad:e,kviteseid:e,kvitsoy:e,"xn--kvitsy-fya":e,kvitsøy:e,kvafjord:e,"xn--kvfjord-nxa":e,kvæfjord:e,giehtavuoatna:e,kvanangen:e,"xn--kvnangen\
-k0a":e,kvænangen:e,navuotna:e,"xn--nvuotna-hwa":e,návuotna:e,kafjord:e,"xn--kfjord-iua":e,kåfjord:e,gaivuotna:e,"xn--givuotna-8ya":e,gáivuotna:e,larvik:e,lavangen:e,lavagis:e,loabat:e,"xn--loabt-0qa":e,loabát:e,lebesby:e,davvesiida:e,leikanger:e,leirfjord:e,leka:e,leksvik:e,lenvik:e,leangaviika:e,"xn--leagaviika-52b":e,leaŋgaviika:e,lesja:e,levanger:e,lier:e,lierne:e,lillehammer:e,lillesand:e,lindesnes:e,lindas:e,"xn--linds-pra":e,lindås:e,lom:e,loppa:e,lahppi:e,"xn--lhppi-xqa":e,láhppi:e,lund:e,lunner:e,luroy:e,"xn--lury-ira":e,lurøy:e,luster:e,lyngdal:e,lyngen:e,ivgu:e,lardal:e,lerdal:e,"xn--lrdal-sra":e,lærdal:e,lodingen:e,"xn--ldingen-q1a":e,lødingen:e,lorenskog:e,"xn--lrenskog-54a":e,lørenskog:e,loten:e,"xn--lten-gra":e,løten:e,malvik:e,masoy:e,"xn--msy-ula0h":e,måsøy:e,muosat:e,"xn--muost-0qa":e,muosát:e,mandal:e,marker:e,marnardal:e,masfjorden:e,meland:e,meldal:e,melhus:e,meloy:e,"xn--mely-ira":e,meløy:e,meraker:e,"xn--merker-kua":e,meråker:e,moareke:e,"xn--mo\
reke-jua":e,moåreke:e,midsund:e,"midtre-gauldal":e,modalen:e,modum:e,molde:e,moskenes:e,moss:e,mosvik:e,malselv:e,"xn--mlselv-iua":e,målselv:e,malatvuopmi:e,"xn--mlatvuopmi-s4a":e,málatvuopmi:e,namdalseid:e,aejrie:e,namsos:e,namsskogan:e,naamesjevuemie:e,"xn--nmesjevuemie-tcba":e,nååmesjevuemie:e,laakesvuemie:e,nannestad:e,narvik:e,narviika:e,naustdal:e,"nedre-eiker":e,akershus:h,buskerud:h,nesna:e,nesodden:e,nesseby:e,unjarga:e,"xn--unjrga-rta":e,unjárga:e,nesset:e,nissedal:e,nittedal:e,"nord-aurdal":e,"nord-fron":e,"nord-odal":e,norddal:e,nordkapp:e,davvenjarga:e,"xn--davvenjrga-y4a":e,davvenjárga:e,"nordre-land":e,nordreisa:e,raisa:e,"xn--risa-5na":e,ráisa:e,"nore-og-uvdal":e,notodden:e,naroy:e,"xn--nry-yla5g":e,nærøy:e,notteroy:e,"xn--nttery-byae":e,nøtterøy:e,odda:e,oksnes:e,"xn--ksnes-uua":e,øksnes:e,oppdal:e,oppegard:e,"xn--oppegrd-ixa":e,oppegård:e,orkdal:e,orland:e,"xn--rland-uua":e,ørland:e,orskog:e,"xn--rskog-uua":e,ørskog:e,orsta:e,"xn--rsta-fra":e,ørsta:e,
hedmark:[0,{os:e,valer:e,"xn--vler-qoa":e,våler:e}],hordaland:[0,{os:e}],osen:e,osteroy:e,"xn--ostery-fya":e,osterøy:e,"ostre-toten":e,"xn--stre-toten-zcb":e,"østre-toten":e,overhalla:e,"ovre-eiker":e,"xn--vre-eiker-k8a":e,"øvre-eiker":e,oyer:e,"xn--yer-zna":e,øyer:e,oygarden:e,"xn--ygarden-p1a":e,øygarden:e,"oystre-slidre":e,"xn--ystre-slidre-ujb":e,"øystre-slidre":e,porsanger:e,porsangu:e,"xn--porsgu-sta26f":e,porsáŋgu:e,porsgrunn:e,radoy:e,"xn--rady-ira":e,radøy:e,rakkestad:e,rana:e,ruovat:e,randaberg:e,rauma:e,rendalen:e,rennebu:e,rennesoy:e,"xn--rennesy-v1a":e,rennesøy:e,rindal:e,ringebu:e,ringerike:e,ringsaker:e,rissa:e,risor:e,"xn--risr-ira":e,risør:e,roan:e,rollag:e,rygge:e,ralingen:e,"xn--rlingen-mxa":e,rælingen:e,rodoy:e,"xn--rdy-0nab":e,rødøy:e,romskog:e,"xn--rmskog-bya":e,rømskog:e,roros:e,"xn--rros-gra":e,røros:e,rost:e,"xn--rst-0na":e,røst:e,royken:e,"xn--ryken-vua":e,røyken:e,royrvik:e,"xn--ryrvik-bya":e,røyrvik:e,rade:e,"xn--rde-ula":e,råde:e,salangen:e,
siellak:e,saltdal:e,salat:e,"xn--slt-elab":e,sálát:e,"xn--slat-5na":e,sálat:e,samnanger:e,vestfold:[0,{sande:e}],sandefjord:e,sandnes:e,sandoy:e,"xn--sandy-yua":e,sandøy:e,sarpsborg:e,sauda:e,sauherad:e,sel:e,selbu:e,selje:e,seljord:e,sigdal:e,siljan:e,sirdal:e,skaun:e,skedsmo:e,ski:e,skien:e,skiptvet:e,skjervoy:e,"xn--skjervy-v1a":e,skjervøy:e,skierva:e,"xn--skierv-uta":e,skiervá:e,skjak:e,"xn--skjk-soa":e,skjåk:e,skodje:e,skanland:e,"xn--sknland-fxa":e,skånland:e,skanit:e,"xn--sknit-yqa":e,skánit:e,smola:e,"xn--smla-hra":e,smøla:e,snillfjord:e,snasa:e,"xn--snsa-roa":e,snåsa:e,snoasa:e,snaase:e,"xn--snase-nra":e,snåase:e,sogndal:e,sokndal:e,sola:e,solund:e,songdalen:e,sortland:e,spydeberg:e,stange:e,stavanger:e,steigen:e,steinkjer:e,stjordal:e,"xn--stjrdal-s1a":e,stjørdal:e,stokke:e,"stor-elvdal":e,stord:e,stordal:e,storfjord:e,omasvuotna:e,strand:e,stranda:e,stryn:e,sula:e,suldal:e,sund:e,sunndal:e,surnadal:e,sveio:e,svelvik:e,sykkylven:e,sogne:e,"xn--sgne-gra":e,søgne:e,
somna:e,"xn--smna-gra":e,sømna:e,"sondre-land":e,"xn--sndre-land-0cb":e,"søndre-land":e,"sor-aurdal":e,"xn--sr-aurdal-l8a":e,"sør-aurdal":e,"sor-fron":e,"xn--sr-fron-q1a":e,"sør-fron":e,"sor-odal":e,"xn--sr-odal-q1a":e,"sør-odal":e,"sor-varanger":e,"xn--sr-varanger-ggb":e,"sør-varanger":e,"matta-varjjat":e,"xn--mtta-vrjjat-k7af":e,"mátta-várjjat":e,sorfold:e,"xn--srfold-bya":e,sørfold:e,sorreisa:e,"xn--srreisa-q1a":e,sørreisa:e,sorum:e,"xn--srum-gra":e,sørum:e,tana:e,deatnu:e,time:e,tingvoll:e,tinn:e,tjeldsund:e,dielddanuorri:e,tjome:e,"xn--tjme-hra":e,tjøme:e,tokke:e,tolga:e,torsken:e,tranoy:e,"xn--trany-yua":e,tranøy:e,tromso:e,"xn--troms-zua":e,tromsø:e,tromsa:e,romsa:e,trondheim:e,troandin:e,trysil:e,trana:e,"xn--trna-woa":e,træna:e,trogstad:e,"xn--trgstad-r1a":e,trøgstad:e,tvedestrand:e,tydal:e,tynset:e,tysfjord:e,divtasvuodna:e,divttasvuotna:e,tysnes:e,tysvar:e,"xn--tysvr-vra":e,tysvær:e,tonsberg:e,"xn--tnsberg-q1a":e,tønsberg:e,ullensaker:e,ullensvang:e,ulvik:e,
utsira:e,vadso:e,"xn--vads-jra":e,vadsø:e,cahcesuolo:e,"xn--hcesuolo-7ya35b":e,čáhcesuolo:e,vaksdal:e,valle:e,vang:e,vanylven:e,vardo:e,"xn--vard-jra":e,vardø:e,varggat:e,"xn--vrggt-xqad":e,várggát:e,vefsn:e,vaapste:e,vega:e,vegarshei:e,"xn--vegrshei-c0a":e,vegårshei:e,vennesla:e,verdal:e,verran:e,vestby:e,vestnes:e,"vestre-slidre":e,"vestre-toten":e,vestvagoy:e,"xn--vestvgy-ixa6o":e,vestvågøy:e,vevelstad:e,vik:e,vikna:e,vindafjord:e,volda:e,voss:e,varoy:e,"xn--vry-yla5g":e,værøy:e,vagan:e,"xn--vgan-qoa":e,vågan:e,voagat:e,vagsoy:e,"xn--vgsy-qoa0j":e,vågsøy:e,vaga:e,"xn--vg-yiab":e,vågå:e,ostfold:[0,{valer:e}],"xn--stfold-9xa":[0,{"xn--vler-qoa":e}],østfold:[0,{våler:e}]}],np:o,nr:m,nu:e,nz:[1,{ac:e,co:e,cri:e,geek:e,gen:e,govt:e,health:e,iwi:e,kiwi:e,maori:e,mil:e,"xn--mori-qsa":e,māori:e,net:e,org:e,parliament:e,school:e}],om:[1,{co:e,com:e,edu:e,gov:e,med:e,museum:e,net:e,org:e,pro:e}],onion:e,org:e,pa:[1,{ac:e,gob:e,com:e,org:e,sld:e,edu:e,net:e,ing:e,abo:e,med:e,
nom:e}],pe:[1,{edu:e,gob:e,nom:e,mil:e,org:e,com:e,net:e}],pf:[1,{com:e,org:e,edu:e}],pg:o,ph:[1,{com:e,net:e,org:e,gov:e,edu:e,ngo:e,mil:e,i:e}],pk:[1,{com:e,net:e,edu:e,org:e,fam:e,biz:e,web:e,gov:e,gob:e,gok:e,gon:e,gop:e,gos:e,info:e}],pl:[1,{com:e,net:e,org:e,aid:e,agro:e,atm:e,auto:e,biz:e,edu:e,gmina:e,gsm:e,info:e,mail:e,miasta:e,media:e,mil:e,nieruchomosci:e,nom:e,pc:e,powiat:e,priv:e,realestate:e,rel:e,sex:e,shop:e,sklep:e,sos:e,szkola:e,targi:e,tm:e,tourism:e,travel:e,turystyka:e,gov:[1,{ap:e,griw:e,ic:e,is:e,kmpsp:e,konsulat:e,kppsp:e,kwp:e,kwpsp:e,mup:e,mw:e,oia:e,oirm:e,oke:e,oow:e,oschr:e,oum:e,pa:e,pinb:e,piw:e,po:e,pr:e,psp:e,psse:e,pup:e,rzgw:e,sa:e,sdn:e,sko:e,so:e,sr:e,starostwo:e,ug:e,ugim:e,um:e,umig:e,upow:e,uppo:e,us:e,uw:e,uzs:e,wif:e,wiih:e,winb:e,wios:e,witd:e,wiw:e,wkz:e,wsa:e,wskr:e,wsse:e,wuoz:e,wzmiuw:e,zp:e,zpisdn:e}],augustow:e,"babia-gora":e,bedzin:e,beskidy:e,bialowieza:e,bialystok:e,bielawa:e,bieszczady:e,boleslawiec:e,bydgoszcz:e,bytom:e,cieszyn:e,czeladz:e,
czest:e,dlugoleka:e,elblag:e,elk:e,glogow:e,gniezno:e,gorlice:e,grajewo:e,ilawa:e,jaworzno:e,"jelenia-gora":e,jgora:e,kalisz:e,"kazimierz-dolny":e,karpacz:e,kartuzy:e,kaszuby:e,katowice:e,kepno:e,ketrzyn:e,klodzko:e,kobierzyce:e,kolobrzeg:e,konin:e,konskowola:e,kutno:e,lapy:e,lebork:e,legnica:e,lezajsk:e,limanowa:e,lomza:e,lowicz:e,lubin:e,lukow:e,malbork:e,malopolska:e,mazowsze:e,mazury:e,mielec:e,mielno:e,mragowo:e,naklo:e,nowaruda:e,nysa:e,olawa:e,olecko:e,olkusz:e,olsztyn:e,opoczno:e,opole:e,ostroda:e,ostroleka:e,ostrowiec:e,ostrowwlkp:e,pila:e,pisz:e,podhale:e,podlasie:e,polkowice:e,pomorze:e,pomorskie:e,prochowice:e,pruszkow:e,przeworsk:e,pulawy:e,radom:e,"rawa-maz":e,rybnik:e,rzeszow:e,sanok:e,sejny:e,slask:e,slupsk:e,sosnowiec:e,"stalowa-wola":e,skoczow:e,starachowice:e,stargard:e,suwalki:e,swidnica:e,swiebodzin:e,swinoujscie:e,szczecin:e,szczytno:e,tarnobrzeg:e,tgory:e,turek:e,tychy:e,ustka:e,walbrzych:e,warmia:e,warszawa:e,waw:e,wegrow:e,wielun:e,wlocl:e,wloclawek:e,wodzislaw:e,
wolomin:e,wroclaw:e,zachpomor:e,zagan:e,zarow:e,zgora:e,zgorzelec:e}],pm:e,pn:[1,{gov:e,co:e,org:e,edu:e,net:e}],post:e,pr:[1,{com:e,net:e,org:e,gov:e,edu:e,isla:e,pro:e,biz:e,info:e,name:e,est:e,prof:e,ac:e}],pro:[1,{aaa:e,aca:e,acct:e,avocat:e,bar:e,cpa:e,eng:e,jur:e,law:e,med:e,recht:e}],ps:[1,{edu:e,gov:e,sec:e,plo:e,com:e,org:e,net:e}],pt:[1,{net:e,gov:e,org:e,edu:e,int:e,publ:e,com:e,nome:e}],pw:[1,{co:e,ne:e,or:e,ed:e,go:e,belau:e}],py:[1,{com:e,coop:e,edu:e,gov:e,mil:e,net:e,org:e}],qa:d,re:[1,{asso:e,com:e,nom:e}],ro:[1,{arts:e,com:e,firm:e,info:e,nom:e,nt:e,org:e,rec:e,store:e,tm:e,www:e}],rs:[1,{ac:e,co:e,edu:e,gov:e,in:e,org:e}],ru:e,rw:[1,{ac:e,co:e,coop:e,gov:e,mil:e,net:e,org:e}],sa:[1,{com:e,net:e,org:e,gov:e,med:e,pub:e,edu:e,sch:e}],sb:n,sc:n,sd:[1,{com:e,net:e,org:e,edu:e,med:e,tv:e,gov:e,info:e}],se:[1,{a:e,ac:e,b:e,bd:e,brand:e,c:e,d:e,e,f:e,fh:e,fhsk:e,fhv:e,g:e,h:e,i:e,k:e,komforb:e,kommunalforbund:e,komvux:e,l:e,lanbib:e,m:e,n:e,naturbruksgymn:e,o:e,org:e,p:e,parti:e,
pp:e,press:e,r:e,s:e,t:e,tm:e,u:e,w:e,x:e,y:e,z:e}],sg:[1,{com:e,net:e,org:e,gov:e,edu:e,per:e}],sh:[1,{com:e,net:e,gov:e,org:e,mil:e}],si:e,sj:e,sk:e,sl:n,sm:e,sn:[1,{art:e,com:e,edu:e,gouv:e,org:e,perso:e,univ:e}],so:[1,{com:e,edu:e,gov:e,me:e,net:e,org:e}],sr:e,ss:[1,{biz:e,com:e,edu:e,gov:e,me:e,net:e,org:e,sch:e}],st:[1,{co:e,com:e,consulado:e,edu:e,embaixada:e,mil:e,net:e,org:e,principe:e,saotome:e,store:e}],su:e,sv:[1,{com:e,edu:e,gob:e,org:e,red:e}],sx:r,sy:t,sz:[1,{co:e,ac:e,org:e}],tc:e,td:e,tel:e,tf:e,tg:e,th:[1,{ac:e,co:e,go:e,in:e,mi:e,net:e,or:e}],tj:[1,{ac:e,biz:e,co:e,com:e,edu:e,go:e,gov:e,int:e,mil:e,name:e,net:e,nic:e,org:e,test:e,web:e}],tk:e,tl:r,tm:[1,{com:e,co:e,org:e,net:e,nom:e,gov:e,mil:e,edu:e}],tn:[1,{com:e,ens:e,fin:e,gov:e,ind:e,info:e,intl:e,mincom:e,nat:e,net:e,org:e,perso:e,tourism:e}],to:t,tr:[1,{av:e,bbs:e,bel:e,biz:e,com:e,dr:e,edu:e,gen:e,gov:e,info:e,mil:e,k12:e,kep:e,name:e,net:e,org:e,pol:e,tel:e,tsk:e,tv:e,web:e,nc:r}],tt:[1,{co:e,com:e,org:e,net:e,
biz:e,info:e,pro:e,int:e,coop:e,jobs:e,mobi:e,travel:e,museum:e,aero:e,name:e,gov:e,edu:e}],tv:e,tw:[1,{edu:e,gov:e,mil:e,com:e,net:e,org:e,idv:e,game:e,ebiz:e,club:e,"xn--zf0ao64a":e,網路:e,"xn--uc0atv":e,組織:e,"xn--czrw28b":e,商業:e}],tz:[1,{ac:e,co:e,go:e,hotel:e,info:e,me:e,mil:e,mobi:e,ne:e,or:e,sc:e,tv:e}],ua:[1,{com:e,edu:e,gov:e,in:e,net:e,org:e,cherkassy:e,cherkasy:e,chernigov:e,chernihiv:e,chernivtsi:e,chernovtsy:e,ck:e,cn:e,cr:e,crimea:e,cv:e,dn:e,dnepropetrovsk:e,dnipropetrovsk:e,donetsk:e,dp:e,if:e,"ivano-frankivsk":e,kh:e,kharkiv:e,kharkov:e,kherson:e,khmelnitskiy:e,khmelnytskyi:e,kiev:e,kirovograd:e,km:e,kr:e,kropyvnytskyi:e,krym:e,ks:e,kv:e,kyiv:e,lg:e,lt:e,lugansk:e,luhansk:e,lutsk:e,lv:e,lviv:e,mk:e,mykolaiv:e,nikolaev:e,od:e,odesa:e,odessa:e,pl:e,poltava:e,rivne:e,rovno:e,rv:e,sb:e,sebastopol:e,sevastopol:e,sm:e,sumy:e,te:e,ternopil:e,uz:e,uzhgorod:e,uzhhorod:e,vinnica:e,vinnytsia:e,vn:e,volyn:e,yalta:e,zakarpattia:e,zaporizhzhe:e,zaporizhzhia:e,zhitomir:e,zhytomyr:e,
zp:e,zt:e}],ug:[1,{co:e,or:e,ac:e,sc:e,go:e,ne:e,com:e,org:e}],uk:[1,{ac:e,co:e,gov:e,ltd:e,me:e,net:e,nhs:e,org:e,plc:e,police:e,sch:o}],us:[1,{dni:e,fed:e,isa:e,kids:e,nsn:e,ak:f,al:f,ar:f,as:f,az:f,ca:f,co:f,ct:f,dc:f,de:g,fl:f,ga:f,gu:f,hi:v,ia:f,id:f,il:f,in:f,ks:f,ky:f,la:f,ma:[1,{k12:[1,{pvt:e,chtr:e,paroch:e}],cc:e,lib:e}],md:f,me:f,mi:[1,{k12:e,cc:e,lib:e,"ann-arbor":e,cog:e,dst:e,eaton:e,gen:e,mus:e,tec:e,washtenaw:e}],mn:f,mo:f,ms:f,mt:f,nc:f,nd:v,ne:f,nh:f,nj:f,nm:f,nv:f,ny:f,oh:f,ok:f,or:f,pa:f,pr:f,ri:v,sc:f,sd:v,tn:f,tx:f,ut:f,vi:f,vt:f,va:f,wa:f,wi:f,wv:g,wy:f}],uy:[1,{com:e,edu:e,gub:e,mil:e,net:e,org:e}],uz:[1,{co:e,com:e,net:e,org:e}],va:e,vc:t,ve:[1,{arts:e,bib:e,co:e,com:e,e12:e,edu:e,firm:e,gob:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rar:e,rec:e,store:e,tec:e,web:e}],vg:e,vi:[1,{co:e,com:e,k12:e,net:e,org:e}],vn:[1,{ac:e,ai:e,biz:e,com:e,edu:e,gov:e,health:e,id:e,info:e,int:e,io:e,name:e,net:e,org:e,pro:e,angiang:e,bacgiang:e,backan:e,baclieu:e,bacninh:e,"bar\
ia-vungtau":e,bentre:e,binhdinh:e,binhduong:e,binhphuoc:e,binhthuan:e,camau:e,cantho:e,caobang:e,daklak:e,daknong:e,danang:e,dienbien:e,dongnai:e,dongthap:e,gialai:e,hagiang:e,haiduong:e,haiphong:e,hanam:e,hanoi:e,hatinh:e,haugiang:e,hoabinh:e,hungyen:e,khanhhoa:e,kiengiang:e,kontum:e,laichau:e,lamdong:e,langson:e,laocai:e,longan:e,namdinh:e,nghean:e,ninhbinh:e,ninhthuan:e,phutho:e,phuyen:e,quangbinh:e,quangnam:e,quangngai:e,quangninh:e,quangtri:e,soctrang:e,sonla:e,tayninh:e,thaibinh:e,thainguyen:e,thanhhoa:e,thanhphohochiminh:e,thuathienhue:e,tiengiang:e,travinh:e,tuyenquang:e,vinhlong:e,vinhphuc:e,yenbai:e}],vu:i,wf:e,ws:n,yt:e,"xn--mgbaam7a8h":e,امارات:e,"xn--y9a3aq":e,հայ:e,"xn--54b7fta0cc":e,বাংলা:e,"xn--90ae":e,бг:e,"xn--mgbcpq6gpa1a":e,البحرين:e,"xn--90ais":e,бел:e,"xn--fiqs8s":e,中国:e,"xn--fiqz9s":e,中國:e,"xn--lgbbat1ad8j":e,الجزائر:e,"xn--wgbh1c":e,مصر:e,"xn--e1a4c":e,ею:e,"xn--qxa6a":e,ευ:e,"xn--mgbah1a3hjkrd":e,موريتانيا:e,
"xn--node":e,გე:e,"xn--qxam":e,ελ:e,"xn--j6w193g":[1,{"xn--55qx5d":e,"xn--wcvs22d":e,"xn--mxtq1m":e,"xn--gmqw5a":e,"xn--od0alg":e,"xn--uc0atv":e}],香港:[1,{公司:e,教育:e,政府:e,個人:e,網絡:e,組織:e}],"xn--2scrj9c":e,ಭಾರತ:e,"xn--3hcrj9c":e,ଭାରତ:e,"xn--45br5cyl":e,ভাৰত:e,"xn--h2breg3eve":e,भारतम्:e,"xn--h2brj9c8c":e,भारोत:e,"xn--mgbgu82a":e,ڀارت:e,"xn--rvc1e0am3e":e,ഭാരതം:e,"xn--h2brj9c":e,भारत:e,"xn--mgbbh1a":e,بارت:e,"xn--mgbbh1a71e":e,بھارت:e,"xn--fpcrj9c3d":e,భారత్:e,"xn--gecrj9c":e,ભારત:e,"xn--s9brj9c":e,ਭਾਰਤ:e,"xn--45brj9c":e,ভারত:e,"xn--xkc2dl3a5ee0h":e,இந்தியா:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e,"xn--mgbtx2b":e,عراق:e,"xn--mgbayh7gpa":e,الاردن:e,"xn--3e0b707e":e,한국:e,"xn--80ao21a":e,қаз:e,"xn--q7ce6a":e,ລາວ:e,"xn--fzc2c9e2c":e,ලංකා:e,"xn--xkc2al3hye2a":e,இலங்கை:e,"\
xn--mgbc0a9azcg":e,المغرب:e,"xn--d1alf":e,мкд:e,"xn--l1acc":e,мон:e,"xn--mix891f":e,澳門:e,"xn--mix082f":e,澳门:e,"xn--mgbx4cd0ab":e,مليسيا:e,"xn--mgb9awbf":e,عمان:e,"xn--mgbai9azgqp6j":e,پاکستان:e,"xn--mgbai9a5eva00b":e,پاكستان:e,"xn--ygbi2ammx":e,فلسطين:e,"xn--90a3ac":[1,{"xn--o1ac":e,"xn--c1avg":e,"xn--90azh":e,"xn--d1at":e,"xn--o1ach":e,"xn--80au":e}],срб:[1,{пр:e,орг:e,обр:e,од:e,упр:e,ак:e}],"xn--p1ai":e,рф:e,"xn--wgbl6a":e,قطر:e,"xn--mgberp4a5d4ar":e,السعودية:e,"xn--mgberp4a5d4a87g":e,السعودیة:e,"xn--mgbqly7c0a67fbc":e,السعودیۃ:e,"xn--mgbqly7cvafr":e,السعوديه:e,"xn--mgbpl2fh":e,سودان:e,"xn--yfro4i67o":e,新加坡:e,"xn--clchc0ea0b2g2a9gcd":e,சிங்கப்பூர்:e,"xn--ogbpf8fl":e,سورية:e,"xn--mgbtf8fl":e,سوريا:e,"xn--o3cw4h":[1,{"xn--12c1fe0br":e,"xn--12co0c3b4eva":e,"xn--h3cuzk1di":e,"xn--o3cyx2a":e,"xn--m3ch0j3a":e,"xn--12cfi8ixb8l":e}],ไทย:[1,
{ศึกษา:e,ธุรกิจ:e,รัฐบาล:e,ทหาร:e,เน็ต:e,องค์กร:e}],"xn--pgbs0dh":e,تونس:e,"xn--kpry57d":e,台灣:e,"xn--kprw13d":e,台湾:e,"xn--nnx388a":e,臺灣:e,"xn--j1amh":e,укр:e,"xn--mgb2ddes":e,اليمن:e,xxx:e,ye:t,za:[0,{ac:e,agric:e,alt:e,co:e,edu:e,gov:e,grondar:e,law:e,mil:e,net:e,ngo:e,nic:e,nis:e,nom:e,org:e,school:e,tm:e,web:e}],zm:[1,{ac:e,biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,net:e,org:e,sch:e}],zw:[1,{ac:e,co:e,gov:e,mil:e,org:e}],aaa:e,aarp:e,abb:e,abbott:e,abbvie:e,abc:e,able:e,abogado:e,abudhabi:e,academy:e,accenture:e,accountant:e,accountants:e,aco:e,actor:e,ads:e,adult:e,aeg:e,aetna:e,afl:e,africa:e,agakhan:e,agency:e,aig:e,airbus:e,airforce:e,airtel:e,akdn:e,alibaba:e,alipay:e,allfinanz:e,allstate:e,ally:e,alsace:e,alstom:e,amazon:e,americanexpress:e,americanfamily:e,amex:e,amfam:e,amica:e,amsterdam:e,analytics:e,android:e,anquan:e,anz:e,aol:e,apartments:e,app:e,apple:e,aquarelle:e,arab:e,aramco:e,archi:e,
army:e,art:e,arte:e,asda:e,associates:e,athleta:e,attorney:e,auction:e,audi:e,audible:e,audio:e,auspost:e,author:e,auto:e,autos:e,aws:e,axa:e,azure:e,baby:e,baidu:e,banamex:e,band:e,bank:e,bar:e,barcelona:e,barclaycard:e,barclays:e,barefoot:e,bargains:e,baseball:e,basketball:e,bauhaus:e,bayern:e,bbc:e,bbt:e,bbva:e,bcg:e,bcn:e,beats:e,beauty:e,beer:e,bentley:e,berlin:e,best:e,bestbuy:e,bet:e,bharti:e,bible:e,bid:e,bike:e,bing:e,bingo:e,bio:e,black:e,blackfriday:e,blockbuster:e,blog:e,bloomberg:e,blue:e,bms:e,bmw:e,bnpparibas:e,boats:e,boehringer:e,bofa:e,bom:e,bond:e,boo:e,book:e,booking:e,bosch:e,bostik:e,boston:e,bot:e,boutique:e,box:e,bradesco:e,bridgestone:e,broadway:e,broker:e,brother:e,brussels:e,build:e,builders:e,business:e,buy:e,buzz:e,bzh:e,cab:e,cafe:e,cal:e,call:e,calvinklein:e,cam:e,camera:e,camp:e,canon:e,capetown:e,capital:e,capitalone:e,car:e,caravan:e,cards:e,care:e,career:e,careers:e,cars:e,casa:e,case:e,cash:e,casino:e,catering:e,catholic:e,cba:e,cbn:e,cbre:e,center:e,
ceo:e,cern:e,cfa:e,cfd:e,chanel:e,channel:e,charity:e,chase:e,chat:e,cheap:e,chintai:e,christmas:e,chrome:e,church:e,cipriani:e,circle:e,cisco:e,citadel:e,citi:e,citic:e,city:e,claims:e,cleaning:e,click:e,clinic:e,clinique:e,clothing:e,cloud:e,club:e,clubmed:e,coach:e,codes:e,coffee:e,college:e,cologne:e,commbank:e,community:e,company:e,compare:e,computer:e,comsec:e,condos:e,construction:e,consulting:e,contact:e,contractors:e,cooking:e,cool:e,corsica:e,country:e,coupon:e,coupons:e,courses:e,cpa:e,credit:e,creditcard:e,creditunion:e,cricket:e,crown:e,crs:e,cruise:e,cruises:e,cuisinella:e,cymru:e,cyou:e,dabur:e,dad:e,dance:e,data:e,date:e,dating:e,datsun:e,day:e,dclk:e,dds:e,deal:e,dealer:e,deals:e,degree:e,delivery:e,dell:e,deloitte:e,delta:e,democrat:e,dental:e,dentist:e,desi:e,design:e,dev:e,dhl:e,diamonds:e,diet:e,digital:e,direct:e,directory:e,discount:e,discover:e,dish:e,diy:e,dnp:e,docs:e,doctor:e,dog:e,domains:e,dot:e,download:e,drive:e,dtv:e,dubai:e,dunlop:e,dupont:e,durban:e,dvag:e,
dvr:e,earth:e,eat:e,eco:e,edeka:e,education:e,email:e,emerck:e,energy:e,engineer:e,engineering:e,enterprises:e,epson:e,equipment:e,ericsson:e,erni:e,esq:e,estate:e,eurovision:e,eus:e,events:e,exchange:e,expert:e,exposed:e,express:e,extraspace:e,fage:e,fail:e,fairwinds:e,faith:e,family:e,fan:e,fans:e,farm:e,farmers:e,fashion:e,fast:e,fedex:e,feedback:e,ferrari:e,ferrero:e,fidelity:e,fido:e,film:e,final:e,finance:e,financial:e,fire:e,firestone:e,firmdale:e,fish:e,fishing:e,fit:e,fitness:e,flickr:e,flights:e,flir:e,florist:e,flowers:e,fly:e,foo:e,food:e,football:e,ford:e,forex:e,forsale:e,forum:e,foundation:e,fox:e,free:e,fresenius:e,frl:e,frogans:e,frontier:e,ftr:e,fujitsu:e,fun:e,fund:e,furniture:e,futbol:e,fyi:e,gal:e,gallery:e,gallo:e,gallup:e,game:e,games:e,gap:e,garden:e,gay:e,gbiz:e,gdn:e,gea:e,gent:e,genting:e,george:e,ggee:e,gift:e,gifts:e,gives:e,giving:e,glass:e,gle:e,global:e,globo:e,gmail:e,gmbh:e,gmo:e,gmx:e,godaddy:e,gold:e,goldpoint:e,golf:e,goo:e,goodyear:e,goog:e,google:e,
gop:e,got:e,grainger:e,graphics:e,gratis:e,green:e,gripe:e,grocery:e,group:e,gucci:e,guge:e,guide:e,guitars:e,guru:e,hair:e,hamburg:e,hangout:e,haus:e,hbo:e,hdfc:e,hdfcbank:e,health:e,healthcare:e,help:e,helsinki:e,here:e,hermes:e,hiphop:e,hisamitsu:e,hitachi:e,hiv:e,hkt:e,hockey:e,holdings:e,holiday:e,homedepot:e,homegoods:e,homes:e,homesense:e,honda:e,horse:e,hospital:e,host:e,hosting:e,hot:e,hotels:e,hotmail:e,house:e,how:e,hsbc:e,hughes:e,hyatt:e,hyundai:e,ibm:e,icbc:e,ice:e,icu:e,ieee:e,ifm:e,ikano:e,imamat:e,imdb:e,immo:e,immobilien:e,inc:e,industries:e,infiniti:e,ing:e,ink:e,institute:e,insurance:e,insure:e,international:e,intuit:e,investments:e,ipiranga:e,irish:e,ismaili:e,ist:e,istanbul:e,itau:e,itv:e,jaguar:e,java:e,jcb:e,jeep:e,jetzt:e,jewelry:e,jio:e,jll:e,jmp:e,jnj:e,joburg:e,jot:e,joy:e,jpmorgan:e,jprs:e,juegos:e,juniper:e,kaufen:e,kddi:e,kerryhotels:e,kerrylogistics:e,kerryproperties:e,kfh:e,kia:e,kids:e,kim:e,kindle:e,kitchen:e,kiwi:e,koeln:e,komatsu:e,kosher:e,kpmg:e,kpn:e,
krd:e,kred:e,kuokgroup:e,kyoto:e,lacaixa:e,lamborghini:e,lamer:e,lancaster:e,land:e,landrover:e,lanxess:e,lasalle:e,lat:e,latino:e,latrobe:e,law:e,lawyer:e,lds:e,lease:e,leclerc:e,lefrak:e,legal:e,lego:e,lexus:e,lgbt:e,lidl:e,life:e,lifeinsurance:e,lifestyle:e,lighting:e,like:e,lilly:e,limited:e,limo:e,lincoln:e,link:e,lipsy:e,live:e,living:e,llc:e,llp:e,loan:e,loans:e,locker:e,locus:e,lol:e,london:e,lotte:e,lotto:e,love:e,lpl:e,lplfinancial:e,ltd:e,ltda:e,lundbeck:e,luxe:e,luxury:e,madrid:e,maif:e,maison:e,makeup:e,man:e,management:e,mango:e,map:e,market:e,marketing:e,markets:e,marriott:e,marshalls:e,mattel:e,mba:e,mckinsey:e,med:e,media:e,meet:e,melbourne:e,meme:e,memorial:e,men:e,menu:e,merckmsd:e,miami:e,microsoft:e,mini:e,mint:e,mit:e,mitsubishi:e,mlb:e,mls:e,mma:e,mobile:e,moda:e,moe:e,moi:e,mom:e,monash:e,money:e,monster:e,mormon:e,mortgage:e,moscow:e,moto:e,motorcycles:e,mov:e,movie:e,msd:e,mtn:e,mtr:e,music:e,nab:e,nagoya:e,natura:e,navy:e,nba:e,nec:e,netbank:e,netflix:e,network:e,
neustar:e,new:e,news:e,next:e,nextdirect:e,nexus:e,nfl:e,ngo:e,nhk:e,nico:e,nike:e,nikon:e,ninja:e,nissan:e,nissay:e,nokia:e,norton:e,now:e,nowruz:e,nowtv:e,nra:e,nrw:e,ntt:e,nyc:e,obi:e,observer:e,office:e,okinawa:e,olayan:e,olayangroup:e,ollo:e,omega:e,one:e,ong:e,onl:e,online:e,ooo:e,open:e,oracle:e,orange:e,organic:e,origins:e,osaka:e,otsuka:e,ott:e,ovh:e,page:e,panasonic:e,paris:e,pars:e,partners:e,parts:e,party:e,pay:e,pccw:e,pet:e,pfizer:e,pharmacy:e,phd:e,philips:e,phone:e,photo:e,photography:e,photos:e,physio:e,pics:e,pictet:e,pictures:e,pid:e,pin:e,ping:e,pink:e,pioneer:e,pizza:e,place:e,play:e,playstation:e,plumbing:e,plus:e,pnc:e,pohl:e,poker:e,politie:e,porn:e,pramerica:e,praxi:e,press:e,prime:e,prod:e,productions:e,prof:e,progressive:e,promo:e,properties:e,property:e,protection:e,pru:e,prudential:e,pub:e,pwc:e,qpon:e,quebec:e,quest:e,racing:e,radio:e,read:e,realestate:e,realtor:e,realty:e,recipes:e,red:e,redstone:e,redumbrella:e,rehab:e,reise:e,reisen:e,reit:e,reliance:e,
ren:e,rent:e,rentals:e,repair:e,report:e,republican:e,rest:e,restaurant:e,review:e,reviews:e,rexroth:e,rich:e,richardli:e,ricoh:e,ril:e,rio:e,rip:e,rocks:e,rodeo:e,rogers:e,room:e,rsvp:e,rugby:e,ruhr:e,run:e,rwe:e,ryukyu:e,saarland:e,safe:e,safety:e,sakura:e,sale:e,salon:e,samsclub:e,samsung:e,sandvik:e,sandvikcoromant:e,sanofi:e,sap:e,sarl:e,sas:e,save:e,saxo:e,sbi:e,sbs:e,scb:e,schaeffler:e,schmidt:e,scholarships:e,school:e,schule:e,schwarz:e,science:e,scot:e,search:e,seat:e,secure:e,security:e,seek:e,select:e,sener:e,services:e,seven:e,sew:e,sex:e,sexy:e,sfr:e,shangrila:e,sharp:e,shaw:e,shell:e,shia:e,shiksha:e,shoes:e,shop:e,shopping:e,shouji:e,show:e,silk:e,sina:e,singles:e,site:e,ski:e,skin:e,sky:e,skype:e,sling:e,smart:e,smile:e,sncf:e,soccer:e,social:e,softbank:e,software:e,sohu:e,solar:e,solutions:e,song:e,sony:e,soy:e,spa:e,space:e,sport:e,spot:e,srl:e,stada:e,staples:e,star:e,statebank:e,statefarm:e,stc:e,stcgroup:e,stockholm:e,storage:e,store:e,stream:e,studio:e,study:e,style:e,
sucks:e,supplies:e,supply:e,support:e,surf:e,surgery:e,suzuki:e,swatch:e,swiss:e,sydney:e,systems:e,tab:e,taipei:e,talk:e,taobao:e,target:e,tatamotors:e,tatar:e,tattoo:e,tax:e,taxi:e,tci:e,tdk:e,team:e,tech:e,technology:e,temasek:e,tennis:e,teva:e,thd:e,theater:e,theatre:e,tiaa:e,tickets:e,tienda:e,tips:e,tires:e,tirol:e,tjmaxx:e,tjx:e,tkmaxx:e,tmall:e,today:e,tokyo:e,tools:e,top:e,toray:e,toshiba:e,total:e,tours:e,town:e,toyota:e,toys:e,trade:e,trading:e,training:e,travel:e,travelers:e,travelersinsurance:e,trust:e,trv:e,tube:e,tui:e,tunes:e,tushu:e,tvs:e,ubank:e,ubs:e,unicom:e,university:e,uno:e,uol:e,ups:e,vacations:e,vana:e,vanguard:e,vegas:e,ventures:e,verisign:e,versicherung:e,vet:e,viajes:e,video:e,vig:e,viking:e,villas:e,vin:e,vip:e,virgin:e,visa:e,vision:e,viva:e,vivo:e,vlaanderen:e,vodka:e,volvo:e,vote:e,voting:e,voto:e,voyage:e,wales:e,walmart:e,walter:e,wang:e,wanggou:e,watch:e,watches:e,weather:e,weatherchannel:e,webcam:e,weber:e,website:e,wed:e,wedding:e,weibo:e,weir:e,whoswho:e,
wien:e,wiki:e,williamhill:e,win:e,windows:e,wine:e,winners:e,wme:e,wolterskluwer:e,woodside:e,work:e,works:e,world:e,wow:e,wtc:e,wtf:e,xbox:e,xerox:e,xihuan:e,xin:e,"xn--11b4c3d":e,कॉम:e,"xn--1ck2e1b":e,セール:e,"xn--1qqw23a":e,佛山:e,"xn--30rr7y":e,慈善:e,"xn--3bst00m":e,集团:e,"xn--3ds443g":e,在线:e,"xn--3pxu8k":e,点看:e,"xn--42c2d9a":e,คอม:e,"xn--45q11c":e,八卦:e,"xn--4gbrim":e,موقع:e,"xn--55qw42g":e,公益:e,"xn--55qx5d":e,公司:e,"xn--5su34j936bgsg":e,香格里拉:e,"xn--5tzm5g":e,网站:e,"xn--6frz82g":e,移动:e,"xn--6qq986b3xl":e,我爱你:e,"xn--80adxhks":e,москва:e,"xn--80aqecdr1a":e,католик:e,"xn--80asehdb":e,онлайн:e,"xn--80aswg":e,сайт:e,"xn--8y0a063a":e,联通:e,"xn--9dbq2a":e,קום:e,"xn--9et52u":e,时尚:e,"xn--9krt00a":e,微博:e,"xn--b4w605ferd":e,淡马锡:e,"xn--bck1b9a5dre4c":e,ファッション:e,"xn--c1avg":e,орг:e,"xn--c2br7g":e,नेट:e,"xn--cck2b3b":e,ストア:e,"xn--cckwcxetd":e,アマゾン:e,"x\
n--cg4bki":e,삼성:e,"xn--czr694b":e,商标:e,"xn--czrs0t":e,商店:e,"xn--czru2d":e,商城:e,"xn--d1acj3b":e,дети:e,"xn--eckvdtc9d":e,ポイント:e,"xn--efvy88h":e,新闻:e,"xn--fct429k":e,家電:e,"xn--fhbei":e,كوم:e,"xn--fiq228c5hs":e,中文网:e,"xn--fiq64b":e,中信:e,"xn--fjq720a":e,娱乐:e,"xn--flw351e":e,谷歌:e,"xn--fzys8d69uvgm":e,電訊盈科:e,"xn--g2xx48c":e,购物:e,"xn--gckr3f0f":e,クラウド:e,"xn--gk3at1e":e,通販:e,"xn--hxt814e":e,网店:e,"xn--i1b6b1a6a2e":e,संगठन:e,"xn--imr513n":e,餐厅:e,"xn--io0a7i":e,网络:e,"xn--j1aef":e,ком:e,"xn--jlq480n2rg":e,亚马逊:e,"xn--jvr189m":e,食品:e,"xn--kcrx77d1x4a":e,飞利浦:e,"xn--kput3i":e,手机:e,"xn--mgba3a3ejt":e,ارامكو:e,"xn--mgba7c0bbn0a":e,العليان:e,"xn--mgbab2bd":e,بازار:e,"xn--mgbca7dzdo":e,ابوظبي:e,"xn--mgbi4ecexp":e,كاثوليك:e,"xn--mgbt3dhd":e,همراه:e,"xn--mk1bu44c":e,닷컴:e,"xn--mxtq1m":e,政府:e,"xn--ngbc5azd":e,شبكة:e,"xn--ngbe9e0a":e,بيتك:e,
"xn--ngbrx":e,عرب:e,"xn--nqv7f":e,机构:e,"xn--nqv7fs00ema":e,组织机构:e,"xn--nyqy26a":e,健康:e,"xn--otu796d":e,招聘:e,"xn--p1acf":e,рус:e,"xn--pssy2u":e,大拿:e,"xn--q9jyb4c":e,みんな:e,"xn--qcka1pmc":e,グーグル:e,"xn--rhqv96g":e,世界:e,"xn--rovu88b":e,書籍:e,"xn--ses554g":e,网址:e,"xn--t60b56a":e,닷넷:e,"xn--tckwe":e,コム:e,"xn--tiq49xqyj":e,天主教:e,"xn--unup4y":e,游戏:e,"xn--vermgensberater-ctb":e,vermögensberater:e,"xn--vermgensberatung-pwb":e,vermögensberatung:e,"xn--vhquv":e,企业:e,"xn--vuq861b":e,信息:e,"xn--w4r85el8fhu5dnra":e,嘉里大酒店:e,"xn--w4rs40l":e,嘉里:e,"xn--xhq521b":e,广东:e,"xn--zfr164b":e,政务:e,xyz:e,yachts:e,yahoo:e,yamaxun:e,yandex:e,yodobashi:e,yoga:e,yokohama:e,you:e,youtube:e,yun:e,zappos:e,zara:e,zero:e,zip:e,zone:e,zuerich:e}]}()});function TM(e,t,n){let r=null,a=t;for(;a!==void 0&&(a[0]===1&&(r={index:n+1}),n!==-1);){let o=a[1];a=Object.prototype.hasOwnProperty.call(o,e[n])?o[e[n]]:o["*"],n-=1}return r}function vy(e,t,n){var r;if(lp(e,t,n))return;let a=e.split("."),o=TM(a,wM,a.length-1);if(o!==null){n.publicSuffix=a.slice(o.index+1).join(".");return}let i=TM(a,DM,a.length-1);if(i!==null){n.publicSuffix=a.slice(i.index).join(".");return}n.publicSuffix=(r=a[a.length-1])!==null&&r!==void 0?r:null}var xM=y(()=>{l();yy();EM();s(TM,"lookupInTrie");s(vy,"suffixLookup")});function CM(e,t={}){return hy(SM),gy(e,3,vy,t,SM).domain}var SM,kM=y(()=>{l();yy();xM();SM=fy();s(CM,"getDomain")});var rt,YJ,FM,RM,H,KJ,Ut=y(()=>{"use strict";l();A();rt={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and \
that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The pa\
ge provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results.",targetCrashed:"Browser tab has unexpectedly crashed."},YJ=D("core/lib/lh-error.js",rt),FM="__LighthouseErrorSentinel",RM="__ErrorSentinel",H=class e extends Error{static{s(this,"LighthouseError")}constructor(t,n,r){
super(t.code,r),this.name="LighthouseError",this.code=t.code,this.friendlyMessage=YJ(t.message,{errorCode:this.code,...n}),this.lhrRuntimeError=!!t.lhrRuntimeError,n&&Object.assign(this,n),Error.captureStackTrace(this,e)}static fromProtocolMessage(t,n){let r=Object.values(e.errors).filter(i=>i.pattern).find(i=>i.pattern&&i.pattern.test(n.message));if(r)return new e(r);let a=`(${t}): ${n.message}`;n.data&&(a+=` (${n.data})`);let o=new Error(`Protocol error ${a}`);return Object.assign(o,{protocolMethod:t,protocolError:n.message})}static stringifyReplacer(t){if(t instanceof e){let{name:n,code:r,message:a,friendlyMessage:o,lhrRuntimeError:i,stack:c,cause:u,...d}=t;return{sentinel:FM,code:r,stack:c,cause:u,properties:d}}if(t instanceof Error){let{message:n,stack:r,cause:a}=t,o=t.code;return{sentinel:RM,message:n,code:o,stack:r,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(t,n){if(typeof n=="object"&&n!==null){if(n.sentinel===FM){let{code:r,
stack:a,cause:o,properties:i}=n,c=e.errors[r],u=new e(c,i,{cause:o});return u.stack=a,u}if(n.sentinel===RM){let{message:r,code:a,stack:o,cause:i}=n,c=i?{cause:i}:void 0,u=new Error(r,c);return Object.assign(u,{code:a,stack:o}),u}}return n}},KJ={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:rt.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:rt.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:rt.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:rt.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:rt.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:rt.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:rt.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:rt.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:rt.
badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:rt.badTraceRecording},NO_LCP:{code:"NO_LCP",message:rt.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:rt.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:rt.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:rt.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:rt.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:rt.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:rt.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:rt.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:rt.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:rt.pageLoadFailedInterstitial,
lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:rt.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:rt.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:rt.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:rt.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:rt.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:rt.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:rt.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:rt.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:rt.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:rt.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:rt.erroredRequiredArtifact},
TARGET_CRASHED:{code:"TARGET_CRASHED",message:rt.targetCrashed,lhrRuntimeError:!0}};H.errors=KJ;H.NO_ERROR="NO_ERROR";H.UNKNOWN_ERROR="UNKNOWN_ERROR"});function eQ(e){return!e||!e.startsWith("chrome://")?e:(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://"))}var XJ,ZJ,JJ,QJ,dp,Y,ot=y(()=>{"use strict";l();kM();Pn();Ut();XJ=["https:","http:","chrome:","chrome-extension:"],ZJ=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],JJ=["localhost","127.0.0.1"],QJ=["blob","data","intent","file","filesystem","chrome-extension"];s(eQ,"rewriteChromeInternalUrl");dp=class e{static{s(this,"UrlUtils")}static isValid(t){try{return new URL(t),!0}catch{return!1}}static hostsMatch(t,n){try{return new URL(t).host===new URL(n).host}catch{return!1}}static originsMatch(t,n){try{return new URL(t).origin===new URL(n).origin}catch{return!1}}static getOrigin(t){try{let n=new URL(t);return n.protocol==="chrome-extension:"?_e.getChromeExtensionOrigin(t):n.host&&n.origin||null}catch{return null}}static getRootDomain(t){let n=_e.createOrReturnURL(t);return CM(n.href)||n.hostname}static rootDomainsMatch(t,n){
let r,a;try{r=_e.createOrReturnURL(t),a=_e.createOrReturnURL(n)}catch{return!1}if(!r.hostname||!a.hostname)return!1;let o=e.getRootDomain(r),i=e.getRootDomain(a);return o===i}static getURLDisplayName(t,n){return _e.getURLDisplayName(new URL(t),n)}static elideDataURI(t){try{return new URL(t).protocol==="data:"?_e.truncate(t,100):t}catch{return t}}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(eQ);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}static isProtocolAllowed(t){try{let n=new URL(t);return XJ.includes(n.protocol)}catch{return!1}}static isLikeLocalhost(t){return JJ.includes(t)||t.endsWith(".localhost")}static isSecureScheme(t){return ZJ.includes(t)}static isNonNetworkProtocol(t){let n=t.includes(":")?t.slice(0,t.indexOf(":")):t;return QJ.includes(n)}static guessMimeType(t){let n;try{n=new URL(t)}catch{return}if(n.protocol==="data:"){let o=n.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);return o?o[1]:void 0}
let r=n.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!r)return;let a=r[1];return a==="svg"?"image/svg+xml":a==="jpg"?"image/jpeg":`image/${a}`}static normalizeUrl(t){if(t&&this.isValid(t)&&this.isProtocolAllowed(t))return new URL(t).href;throw new H(H.errors.INVALID_URL)}};dp.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";Y=dp});var AM,tQ,nQ,Wo,by=y(()=>{"use strict";l();Oe();ot();AM=14*1024,tQ=.4,nQ={Document:.9,XHR:.9,Fetch:.9},Wo=class e{static{s(this,"NetworkAnalyzer")}static get SUMMARY(){return"__SUMMARY__"}static groupByOrigin(t){let n=new Map;return t.forEach(r=>{let a=r.parsedURL.securityOrigin,o=n.get(a)||[];o.push(r),n.set(a,o)}),n}static getSummary(t){t.sort((r,a)=>r-a);let n;if(t.length===0)n=t[0];else if(t.length%2===0){let r=t[Math.floor((t.length-1)/2)],a=t[Math.floor((t.length-1)/2)+1];n=(r+a)/2}else n=t[Math.floor((t.length-1)/2)];return{min:t[0],max:t[t.length-1],avg:t.reduce((r,a)=>r+a,0)/t.length,median:n}}static summarize(t){let n=new Map,r=[];for(let[a,o]of t)n.set(a,e.getSummary(o)),r.push(...o);return n.set(e.SUMMARY,e.getSummary(r)),n}static _estimateValueByOrigin(t,n){let r=e.estimateIfConnectionWasReused(t),a=e.groupByOrigin(t),o=new Map;for(let[i,c]of a.entries()){let u=[];for(let d of c){let m=d.timing;if(!m)continue;let p=n({request:d,timing:m,connectionReused:r.get(d.requestId)});
typeof p<"u"&&(u=u.concat(p))}u.length&&o.set(i,u)}return o}static _estimateRTTViaConnectionTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r)return;let{connectStart:o,sslStart:i,sslEnd:c,connectEnd:u}=n;if(u>=0&&o>=0&&a.protocol.startsWith("h3"))return u-o;if(i>=0&&c>=0&&i!==o)return[u-i,i-o];if(o>=0&&u>=0)return u-o}static _estimateRTTViaDownloadTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r||a.transferSize<=AM||!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;let i=a.networkEndTime-a.networkRequestTime-n.receiveHeadersEnd,c=Math.log2(a.transferSize/AM);if(!(c>5))return i/c}static _estimateRTTViaSendStartTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r||!Number.isFinite(n.sendStart)||n.sendStart<0)return;let o=1;return a.protocol.startsWith("h3")||(o+=1),a.parsedURL.scheme==="https"&&(o+=1),n.sendStart/o}static _estimateRTTViaHeadersEndTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(!Number.isFinite(n.receiveHeadersEnd)||
n.receiveHeadersEnd<0||!a.resourceType)return;let o=nQ[a.resourceType]||tQ,i=n.receiveHeadersEnd*o,c=1;return r||(c+=1,a.protocol.startsWith("h3")||(c+=1),a.parsedURL.scheme==="https"&&(c+=1)),Math.max((n.receiveHeadersEnd-i)/c,3)}static _estimateResponseTimeByOrigin(t,n){return e._estimateValueByOrigin(t,({request:r,timing:a})=>{if(r.serverResponseTime!==void 0)return r.serverResponseTime;if(!Number.isFinite(a.receiveHeadersEnd)||a.receiveHeadersEnd<0||!Number.isFinite(a.sendEnd)||a.sendEnd<0)return;let o=a.receiveHeadersEnd-a.sendEnd,i=r.parsedURL.securityOrigin,c=n.get(i)||n.get(e.SUMMARY)||0;return Math.max(o-c,0)})}static canTrustConnectionInformation(t){let n=new Map;for(let r of t){let a=n.get(r.connectionId)||!r.connectionReused;n.set(r.connectionId,a)}return n.size<=1?!1:Array.from(n.values()).every(r=>r)}static estimateIfConnectionWasReused(t,n){let{forceCoarseEstimates:r=!1}=n||{};if(!r&&e.canTrustConnectionInformation(t))return new Map(t.map(i=>[i.requestId,!!i.connectionReused]));
let a=new Map,o=e.groupByOrigin(t);for(let[i,c]of o.entries()){let u=c.map(m=>m.networkEndTime).reduce((m,p)=>Math.min(m,p),1/0);for(let m of c)a.set(m.requestId,m.networkRequestTime>=u||m.protocol==="h2");let d=c.reduce((m,p)=>m.networkRequestTime>p.networkRequestTime?p:m);a.set(d.requestId,!1)}return a}static estimateRTTByOrigin(t,n){let{forceCoarseEstimates:r=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:o=!0,useSendStartEstimates:i=!0,useHeadersEndEstimates:c=!0}=n||{},u=e.estimateIfConnectionWasReused(t),d=e.groupByOrigin(t),m=new Map;for(let[h,f]of d.entries()){let v=function(w,E=1){for(let T of f){let S=T.timing;if(!S)continue;let C=w({request:T,timing:S,connectionReused:u.get(T.requestId)});C!==void 0&&(Array.isArray(C)?g.push(...C.map(F=>F*E)):g.push(C*E))}};var p=v;s(v,"collectEstimates");let g=[];r||v(this._estimateRTTViaConnectionTiming),g.length||(o&&v(this._estimateRTTViaDownloadTiming,a),i&&v(this._estimateRTTViaSendStartTiming,a),c&&v(this._estimateRTTViaHeadersEndTiming,
a)),g.length&&m.set(h,g)}if(!m.size)throw new Error("No timing information available");return e.summarize(m)}static estimateServerResponseTimeByOrigin(t,n){let r=(n||{}).rttByOrigin;if(!r){r=new Map;let o=e.estimateRTTByOrigin(t,n);for(let[i,c]of o.entries())r.set(i,c.min)}let a=e._estimateResponseTimeByOrigin(t,r);return e.summarize(a)}static estimateThroughput(t){let n=0,r=t.reduce((c,u)=>(u.parsedURL?.scheme==="data"||u.failed||!u.finished||u.statusCode>300||!u.transferSize||(n+=u.transferSize,c.push({time:u.responseHeadersEndTime/1e3,isStart:!0}),c.push({time:u.networkEndTime/1e3,isStart:!1})),c),[]).sort((c,u)=>c.time-u.time);if(!r.length)return 1/0;let a=0,o=0,i=0;return r.forEach(c=>{c.isStart?(a===0&&(o=c.time),a++):(a--,a===0&&(i+=c.time-o))}),n*8/i}static computeRTTAndServerResponseTime(t){let n=new Map;for(let[c,u]of e.estimateRTTByOrigin(t).entries())n.set(c,u.min);let r=Math.min(...Array.from(n.values())),a=e.estimateServerResponseTimeByOrigin(t,{rttByOrigin:n}),o=new Map,
i=new Map;for(let[c,u]of a.entries()){let d=n.get(c)||r;o.set(c,d-r),i.set(c,u.median)}return{rtt:r,additionalRttByOrigin:o,serverResponseTimeByOrigin:i}}static analyze(t){return{throughput:e.estimateThroughput(t),...e.computeRTTAndServerResponseTime(t)}}static findResourceForUrl(t,n){return t.find(r=>n.startsWith(r.url)&&Y.equalWithExcludedFragments(r.url,n))}static findLastDocumentForUrl(t,n){let r=t.filter(a=>a.resourceType==="Document"&&n.startsWith(a.url)&&Y.equalWithExcludedFragments(a.url,n));return r[r.length-1]}static resolveRedirects(t){for(;t.redirectDestination;)t=t.redirectDestination;return t}}});var za,mp=y(()=>{"use strict";l();za=class e{static{s(this,"TcpConnection")}constructor(t,n,r=0,a=!0,o=!1){this._warmed=!1,this._ssl=a,this._h2=o,this._rtt=t,this._throughput=n,this._serverLatency=r,this._congestionWindow=10,this._h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(t,n){let i=1e3/t*1460*8;return Math.floor(n/i)}_computeMaximumCongestionWindowInSegments(){let t=this._throughput/8,n=this._rtt/1e3,r=t*n;return Math.floor(r/1460)}setThroughput(t){this._throughput=t}setCongestionWindow(t){this._congestionWindow=t}setWarmed(t){this._warmed=t}isWarm(){return this._warmed}isH2(){return this._h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(t){this._h2&&(this._h2OverflowBytesDownloaded=t)}clone(){return Object.assign(new e(this._rtt,this._throughput),this)}simulateDownloadUntil(t,n){let{timeAlreadyElapsed:r=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:o=0}=n||{};this._warmed&&this._h2&&(t-=this._h2OverflowBytesDownloaded);let i=this.
_rtt,c=i/2,u=this._computeMaximumCongestionWindowInSegments(),d=c;this._warmed||(d=o+c+c+c+(this._ssl?i:0));let m=Math.ceil(d/i),p=d+this._serverLatency+c;this._warmed&&this._h2&&(p=0);let h=Math.max(p-r,0),f=a-h,g=Math.min(this._congestionWindow,u),v=0;h>0?v=g*1460:m=0;let w=0,E=t-v;for(;E>0&&w<=f;){m++,w+=i,g=Math.max(Math.min(u,g*2),1);let L=g*1460;v+=L,E-=L}let T=h+w,S=this._h2?Math.max(v-t,0):0,C=Math.max(Math.min(v,t),0),F;return this._warmed?this._h2?F={timeToFirstByte:p}:F={connectionTime:d,timeToFirstByte:p}:F={dnsResolutionTime:o,connectionTime:d-o,sslTime:this._ssl?i:void 0,timeToFirstByte:p},{roundTrips:m,timeElapsed:T,bytesDownloaded:C,extraBytesDownloaded:S,congestionWindow:g,connectionTiming:F}}}});var rQ,aQ,oQ,os,wy=y(()=>{"use strict";l();Oe();by();mp();rQ=30,aQ=["https","wss"],oQ=6,os=class{static{s(this,"ConnectionPool")}constructor(t,n){this._options=n,this._records=t,this._connectionsByOrigin=new Map,this._connectionsByRequest=new Map,this._connectionsInUse=new Set,this._connectionReusedByRequestId=Wo.estimateIfConnectionWasReused(t,{forceCoarseEstimates:!0}),this._initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}_initializeConnections(){let t=this._connectionReusedByRequestId,n=this._options.additionalRttByOrigin,r=this._options.serverResponseTimeByOrigin,a=Wo.groupByOrigin(this._records);for(let[o,i]of a.entries()){let c=[],u=n.get(o)||0,d=r.get(o)||rQ;for(let p of i){if(t.get(p.requestId))continue;let h=aQ.includes(p.parsedURL.scheme),f=p.protocol==="h2",g=new za(this._options.rtt+u,this._options.throughput,d,h,f);c.push(g)}if(!c.length)throw new Error(`Could not find a connection for origin: ${o}`);let m=c[0].isH2()?1:oQ;for(;c.length<
m;)c.push(c[0].clone());this._connectionsByOrigin.set(o,c)}}_findAvailableConnectionWithLargestCongestionWindow(t){let n=null;for(let r=0;r<t.length;r++){let a=t[r];if(this._connectionsInUse.has(a))continue;let o=n?.congestionWindow||-1/0;a.congestionWindow>o&&(n=a)}return n}acquire(t){if(this._connectionsByRequest.has(t))throw new Error("Record already has a connection");let n=t.parsedURL.securityOrigin,r=this._connectionsByOrigin.get(n)||[],a=this._findAvailableConnectionWithLargestCongestionWindow(r);return a?(this._connectionsInUse.add(a),this._connectionsByRequest.set(t,a),a):null}acquireActiveConnectionFromRequest(t){let n=this._connectionsByRequest.get(t);if(!n)throw new Error("Could not find an active connection for request");return n}release(t){let n=this._connectionsByRequest.get(t);this._connectionsByRequest.delete(t),this._connectionsInUse.delete(n)}}});var iQ,_M,IM=y(()=>{"use strict";l();iQ={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},_M={throttling:iQ}});var sQ,Ha,Dy=y(()=>{"use strict";l();Oe();sQ=2,Ha=class e{static{s(this,"DNSCache")}constructor({rtt:t}){this._rtt=t,this._resolvedDomainNames=new Map}getTimeUntilResolution(t,n){let{requestedAt:r=0,shouldUpdateCache:a=!1}=n||{},o=t.parsedURL.host,i=this._resolvedDomainNames.get(o),c=this._rtt*e.RTT_MULTIPLIER;if(i){let d=Math.max(i.resolvedAt-r,0);c=Math.min(d,c)}let u=r+c;return a&&this._updateCacheResolvedAtIfNeeded(t,u),c}_updateCacheResolvedAtIfNeeded(t,n){let r=t.parsedURL.host,a=this._resolvedDomainNames.get(r)||{resolvedAt:n};a.resolvedAt=Math.min(a.resolvedAt,n),this._resolvedDomainNames.set(r,a)}setResolvedAt(t,n){this._resolvedDomainNames.set(t,{resolvedAt:n})}};Ha.RTT_MULTIPLIER=sQ});var Go,Ey=y(()=>{"use strict";l();Oe();Go=class{static{s(this,"SimulatorTimingMap")}constructor(){this._nodeTimings=new Map}getNodes(){return Array.from(this._nodeTimings.keys())}setReadyToStart(t,n){this._nodeTimings.set(t,n)}setInProgress(t,n){let r={...this.getQueued(t),startTime:n.startTime,timeElapsed:0};this._nodeTimings.set(t,t.type===Le.TYPES.NETWORK?{...r,timeElapsedOvershoot:0,bytesDownloaded:0}:r)}setCompleted(t,n){let r={...this.getInProgress(t),endTime:n.endTime,connectionTiming:n.connectionTiming};this._nodeTimings.set(t,r)}setCpu(t,n){let r={...this.getCpuStarted(t),timeElapsed:n.timeElapsed};this._nodeTimings.set(t,r)}setCpuEstimated(t,n){let r={...this.getCpuStarted(t),estimatedTimeElapsed:n.estimatedTimeElapsed};this._nodeTimings.set(t,r)}setNetwork(t,n){let r={...this.getNetworkStarted(t),timeElapsed:n.timeElapsed,timeElapsedOvershoot:n.timeElapsedOvershoot,bytesDownloaded:n.bytesDownloaded};this._nodeTimings.set(t,r)}setNetworkEstimated(t,n){let r={...this.getNetworkStarted(
t),estimatedTimeElapsed:n.estimatedTimeElapsed};this._nodeTimings.set(t,r)}getQueued(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);return n}getCpuStarted(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if("bytesDownloaded"in n)throw new Error(`Node ${t.id} timing not valid`);return n}getNetworkStarted(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("bytesDownloaded"in n))throw new Error(`Node ${t.id} timing not valid`);return n}getInProgress(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Error(`Node ${t.id} not yet in progress`);return n}getCompleted(t){let n=this._nodeTimings.
get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Error(`Node ${t.id} not yet in progress`);if(!("endTime"in n))throw new Error(`Node ${t.id} not yet completed`);return n}}});var xy,Ty,cQ,uQ,lQ,zn,dQ,NM,pp,MM=y(()=>{"use strict";l();Oe();mp();wy();Dy();Ey();xy=zt.Constants,Ty=xy.throttling.mobileSlow4G,cQ=10,uQ=.5,lQ=1e4,zn={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},dQ={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},NM=new Map,pp=class e{static{s(this,"Simulator")}static createSimulator(t){let{throttlingMethod:n,throttling:r,precomputedLanternData:a,networkAnalysis:o}=t,i={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(a&&(i.additionalRttByOrigin=new Map(Object.entries(a.additionalRttByOrigin)),i.serverResponseTimeByOrigin=new Map(Object.entries(a.serverResponseTimeByOrigin))),n){case"provided":i.rtt=o.rtt,i.throughput=o.throughput,i.cpuSlowdownMultiplier=1,i.layoutTaskMultiplier=1;break;case"devtools":r&&(i.rtt=r.requestLatencyMs/xy.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,i.throughput=r.downloadThroughputKbps*1024/xy.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),
i.cpuSlowdownMultiplier=1,i.layoutTaskMultiplier=1;break;case"simulate":r&&(i.rtt=r.rttMs,i.throughput=r.throughputKbps*1024,i.cpuSlowdownMultiplier=r.cpuSlowdownMultiplier);break;default:break}return new e(i)}constructor(t){if(this._options=Object.assign({rtt:Ty.rttMs,throughput:Ty.throughputKbps*1024,maximumConcurrentRequests:cQ,cpuSlowdownMultiplier:Ty.cpuSlowdownMultiplier,layoutTaskMultiplier:uQ,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},t),this._rtt=this._options.rtt,this._throughput=this._options.throughput,this._maximumConcurrentRequests=Math.max(Math.min(za.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1),this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier,this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier,this._cachedNodeListByStartPosition=[],this._nodeTimings=new Go,this._numberInProgressByType=new Map,this._nodes={},this._dns=new Ha({rtt:this._rtt}),
this._connectionPool=null,!Number.isFinite(this._rtt))throw new Error(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this._throughput))throw new Error(`Invalid rtt ${this._throughput}`)}get rtt(){return this._rtt}_initializeConnectionPool(t){let n=[];t.getRootNode().traverse(r=>{r.type===Le.TYPES.NETWORK&&n.push(r.request)}),this._connectionPool=new os(n,this._options)}_initializeAuxiliaryData(){this._nodeTimings=new Go,this._numberInProgressByType=new Map,this._nodes={},this._cachedNodeListByStartPosition=[];for(let t of Object.values(zn))this._nodes[t]=new Set}_numberInProgress(t){return this._numberInProgressByType.get(t)||0}_markNodeAsReadyToStart(t,n){let r=e._computeNodeStartPosition(t),a=this._cachedNodeListByStartPosition.findIndex(i=>e._computeNodeStartPosition(i)>r),o=a===-1?this._cachedNodeListByStartPosition.length:a;this._cachedNodeListByStartPosition.splice(o,0,t),this._nodes[zn.ReadyToStart].add(t),this._nodes[zn.NotReadyToStart].delete(t),this._nodeTimings.setReadyToStart(
t,{queuedTime:n})}_markNodeAsInProgress(t,n){let r=this._cachedNodeListByStartPosition.indexOf(t);this._cachedNodeListByStartPosition.splice(r,1),this._nodes[zn.InProgress].add(t),this._nodes[zn.ReadyToStart].delete(t),this._numberInProgressByType.set(t.type,this._numberInProgress(t.type)+1),this._nodeTimings.setInProgress(t,{startTime:n})}_markNodeAsComplete(t,n,r){this._nodes[zn.Complete].add(t),this._nodes[zn.InProgress].delete(t),this._numberInProgressByType.set(t.type,this._numberInProgress(t.type)-1),this._nodeTimings.setCompleted(t,{endTime:n,connectionTiming:r});for(let a of t.getDependents())a.getDependencies().some(i=>!this._nodes[zn.Complete].has(i))||this._markNodeAsReadyToStart(a,n)}_acquireConnection(t){return this._connectionPool.acquire(t)}_getNodesSortedByStartPosition(){return Array.from(this._cachedNodeListByStartPosition)}_startNodeIfPossible(t,n){if(t.type===Le.TYPES.CPU){this._numberInProgress(t.type)===0&&this._markNodeAsInProgress(t,n);return}if(t.type!==Le.TYPES.
NETWORK)throw new Error("Unsupported");!t.isConnectionless&&(this._numberInProgress(t.type)>=this._maximumConcurrentRequests||!this._acquireConnection(t.request))||this._markNodeAsInProgress(t,n)}_updateNetworkCapacity(){let t=this._numberInProgress(Le.TYPES.NETWORK);if(t!==0)for(let n of this._connectionPool.connectionsInUse())n.setThroughput(this._throughput/t)}_estimateTimeRemaining(t){if(t.type===Le.TYPES.CPU)return this._estimateCPUTimeRemaining(t);if(t.type===Le.TYPES.NETWORK)return this._estimateNetworkTimeRemaining(t);throw new Error("Unsupported")}_estimateCPUTimeRemaining(t){let n=this._nodeTimings.getCpuStarted(t),r=t.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier,o=Math.min(Math.round(t.duration/1e3*r),lQ)-n.timeElapsed;return this._nodeTimings.setCpuEstimated(t,{estimatedTimeElapsed:o}),o}_estimateNetworkTimeRemaining(t){let n=t.request,r=this._nodeTimings.getNetworkStarted(t),a=0;if(t.fromDiskCache)a=8+20*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else if(t.
isNonNetworkProtocol)a=2+10*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else{let i=this._connectionPool.acquireActiveConnectionFromRequest(n),c=this._dns.getTimeUntilResolution(n,{requestedAt:r.startTime,shouldUpdateCache:!0}),u=r.timeElapsed;a=i.simulateDownloadUntil(n.transferSize-r.bytesDownloaded,{timeAlreadyElapsed:u,dnsResolutionTime:c,maximumTimeToElapse:1/0}).timeElapsed}let o=a+r.timeElapsedOvershoot;return this._nodeTimings.setNetworkEstimated(t,{estimatedTimeElapsed:o}),o}_findNextNodeCompletionTime(){let t=1/0;for(let n of this._nodes[zn.InProgress])t=Math.min(t,this._estimateTimeRemaining(n));return t}_updateProgressMadeInTimePeriod(t,n,r){let a=this._nodeTimings.getInProgress(t),o=a.estimatedTimeElapsed===n;if(t.type===Le.TYPES.CPU||t.isConnectionless)return o?this._markNodeAsComplete(t,r):a.timeElapsed+=n;if(t.type!==Le.TYPES.NETWORK)throw new Error("Unsupported");if(!("bytesDownloaded"in a))throw new Error("Invalid timing data");let i=t.request,c=this._connectionPool.
acquireActiveConnectionFromRequest(i),u=this._dns.getTimeUntilResolution(i,{requestedAt:a.startTime,shouldUpdateCache:!0}),d=c.simulateDownloadUntil(i.transferSize-a.bytesDownloaded,{dnsResolutionTime:u,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:n-a.timeElapsedOvershoot});c.setCongestionWindow(d.congestionWindow),c.setH2OverflowBytesDownloaded(d.extraBytesDownloaded),o?(c.setWarmed(!0),this._connectionPool.release(i),this._markNodeAsComplete(t,r,d.connectionTiming)):(a.timeElapsed+=d.timeElapsed,a.timeElapsedOvershoot+=d.timeElapsed-n,a.bytesDownloaded+=d.bytesDownloaded)}_computeFinalNodeTimings(){let t=this._nodeTimings.getNodes().map(r=>[r,this._nodeTimings.getCompleted(r)]);t.sort((r,a)=>r[1].startTime-a[1].startTime);let n=t.map(([r,a])=>[r,{startTime:a.startTime,endTime:a.endTime,duration:a.endTime-a.startTime}]);return{nodeTimings:new Map(n),completeNodeTimings:new Map(t)}}getOptions(){return this._options}simulate(t,n){if(Le.hasCycle(t))throw new Error("Cannot simulat\
e graph with cycle");n=Object.assign({label:void 0},n),this._dns=new Ha({rtt:this._rtt}),this._initializeConnectionPool(t),this._initializeAuxiliaryData();let r=this._nodes[zn.NotReadyToStart],a=this._nodes[zn.ReadyToStart],o=this._nodes[zn.InProgress],i=t.getRootNode();i.traverse(p=>r.add(p));let c=0,u=0;for(this._markNodeAsReadyToStart(i,c);a.size||o.size;){for(let h of this._getNodesSortedByStartPosition())this._startNodeIfPossible(h,c);if(!o.size)throw new Error("Failed to start a node");this._updateNetworkCapacity();let p=this._findNextNodeCompletionTime();if(c+=p,!Number.isFinite(p)||u>1e5)throw new Error("Simulation failed, depth exceeded");u++;for(let h of o)this._updateProgressMadeInTimePeriod(h,p,c)}let{nodeTimings:d,completeNodeTimings:m}=this._computeFinalNodeTimings();return NM.set(n.label||"unlabeled",m),{timeInMs:c,nodeTimings:d}}computeWastedMsFromWastedBytes(t){let{throughput:n,observedThroughput:r}=this._options,a=n===0?r:n;if(a===0)return 0;let i=t*8/a*1e3;return Math.
round(i/10)*10}static get ALL_NODE_TIMINGS(){return NM}static _computeNodeStartPosition(t){return t.type==="cpu"?t.startTime:t.startTime+(dQ[t.request.priority]*1e3*1e3||0)}}});var zt={};x(zt,{ConnectionPool:()=>os,Constants:()=>_M,DNSCache:()=>Ha,NetworkAnalyzer:()=>Wo,Simulator:()=>pp,SimulatorTimingMap:()=>Go,TcpConnection:()=>za});var PM=y(()=>{"use strict";l();tp();wy();IM();Dy();by();MM();Ey();mp();});var ia={};x(ia,{BLOCKING_TIME_THRESHOLD:()=>mQ,calculateSumOfBlockingTime:()=>pQ,calculateTbtImpactForEvent:()=>LM});function LM(e,t,n,r){let a=50;if(r&&(a*=e.duration/r.duration),e.duration<a||e.end<t||e.start>n)return 0;let o=Math.max(e.start,t),c=Math.min(e.end,n)-o;return c<a?0:c-a}function pQ(e,t,n){if(n<=t)return 0;let r=0;for(let a of e)r+=LM(a,t,n);return r}var mQ,OM=y(()=>{"use strict";l();mQ=50;s(LM,"calculateTbtImpactForEvent");s(pQ,"calculateSumOfBlockingTime")});var Ht={};x(Ht,{DEFAULT_COMPARATOR:()=>wQ,arrayDoesNotContainNullOrUndefined:()=>xQ,binaryIndexOf:()=>yQ,intersectOrdered:()=>vQ,lowerBound:()=>UM,mergeOrdered:()=>bQ,nearestIndexFromBeginning:()=>EQ,nearestIndexFromEnd:()=>TQ,removeElement:()=>fQ,sortRange:()=>gQ,upperBound:()=>DQ});function Sy(e,t,n){let r=e[t];e[t]=e[n],e[n]=r}function hQ(e,t,n,r,a){let o=e[a];Sy(e,r,a);let i=n;for(let c=n;c<r;++c)t(e[c],o)<0&&(Sy(e,i,c),++i);return Sy(e,r,i),i}function Cy(e,t,n,r,a,o){if(r<=n)return;let i=Math.floor(Math.random()*(r-n))+n,c=hQ(e,t,n,r,i);a<c&&Cy(e,t,n,c-1,a,o),c<o&&Cy(e,t,c+1,r,a,o)}function gQ(e,t,n,r,a,o){return n===0&&r===e.length-1&&a===0&&o>=r?e.sort(t):Cy(e,t,n,r,a,o),e}function BM(e,t,n,r){let a=[],o=0,i=0;for(;o<e.length&&i<t.length;){let c=n(e[o],t[i]);(r||!c)&&a.push(c<=0?e[o]:t[i]),c<=0&&o++,c>=0&&i++}if(r){for(;o<e.length;)a.push(e[o++]);for(;i<t.length;)a.push(t[i++])}return a}function UM(e,t,n,r,a){let o=r||0,i=a!==void 0?a:e.length;for(;o<i;){let c=o+i>>1;n(t,e[c])>0?
o=c+1:i=c}return i}function DQ(e,t,n,r,a){let o=r||0,i=a!==void 0?a:e.length;for(;o<i;){let c=o+i>>1;n(t,e[c])>=0?o=c+1:i=c}return i}function jM(e,t,n){let r=n==="END";if(e.length===0)return null;let a=0,o=e.length-1,i=0,c=!1,u=!1,d=0;do d=a+(o-a)/2,i=r?Math.ceil(d):Math.floor(d),c=t(e[i]),u=c===r,u?a=Math.min(o,i+(a===i?1:0)):o=Math.max(a,i+(o===i?-1:0));while(o!==a);return t(e[a])?a:null}function EQ(e,t){return jM(e,t,"BEGINNING")}function TQ(e,t){return jM(e,t,"END")}function xQ(e){return!e.includes(null)&&!e.includes(void 0)}var fQ,yQ,vQ,bQ,wQ,qM=y(()=>{l();fQ=s((e,t,n)=>{let r=e.indexOf(t);if(r===-1)return!1;if(n)return e.splice(r,1),!0;for(let a=r+1,o=e.length;a<o;++a)e[a]!==t&&(e[r++]=e[a]);return e.length=r,!0},"removeElement");s(Sy,"swap");s(hQ,"partition");s(Cy,"quickSortRange");s(gQ,"sortRange");yQ=s((e,t,n)=>{let r=UM(e,t,n);return r<e.length&&n(t,e[r])===0?r:-1},"binaryIndexOf");s(BM,"mergeOrIntersect");vQ=s((e,t,n)=>BM(e,t,n,!1),"intersectOrdered"),bQ=s((e,t,n)=>BM(e,t,n,
!0),"mergeOrdered"),wQ=s((e,t)=>e<t?-1:e>t?1:0,"DEFAULT_COMPARATOR");s(UM,"lowerBound");s(DQ,"upperBound");s(jM,"nearestIndex");s(EQ,"nearestIndexFromBeginning");s(TQ,"nearestIndexFromEnd");s(xQ,"arrayDoesNotContainNullOrUndefined")});var zM=y(()=>{l()});var HM=y(()=>{l()});var WM=y(()=>{l()});var GM=y(()=>{l()});var VM=y(()=>{l()});var he={};x(he,{Multimap:()=>fp,getWithDefault:()=>AQ,inverse:()=>RQ});function AQ(e,t,n){let r=e.get(t);return r||(r=n(t),e.set(t,r)),r}var RQ,fp,$M=y(()=>{l();RQ=s(function(e){let t=new fp;for(let[n,r]of e.entries())t.set(r,n);return t},"inverse"),fp=class{static{s(this,"Multimap")}map=new Map;set(t,n){let r=this.map.get(t);r||(r=new Set,this.map.set(t,r)),r.add(n)}get(t){return this.map.get(t)||new Set}has(t){return this.map.has(t)}hasValue(t,n){let r=this.map.get(t);return r?r.has(n):!1}get size(){return this.map.size}delete(t,n){let r=this.get(t);if(!r)return!1;let a=r.delete(n);return r.size||this.map.delete(t),a}deleteAll(t){this.map.delete(t)}keysArray(){return[...this.map.keys()]}keys(){return this.map.keys()}valuesArray(){let t=[];for(let n of this.map.values())t.push(...n.values());return t}clear(){this.map.clear()}};s(AQ,"getWithDefault")});var YM=y(()=>{l()});var hp={};x(hp,{aspectRatio:()=>BQ,bytesToString:()=>MQ,clamp:()=>IQ,floor:()=>LQ,greatestCommonDivisor:()=>KM,mod:()=>NQ,toFixedIfFloating:()=>PQ,withThousandsSeparator:()=>UQ});var IQ,NQ,MQ,PQ,LQ,KM,OQ,BQ,UQ,XM=y(()=>{l();IQ=s((e,t,n)=>{let r=e;return e<t?r=t:e>n&&(r=n),r},"clamp"),NQ=s((e,t)=>(e%t+t)%t,"mod"),MQ=s(e=>{if(e<1e3)return`${e.toFixed(0)} B`;let t=e/1e3;if(t<100)return`${t.toFixed(1)} kB`;if(t<1e3)return`${t.toFixed(0)} kB`;let n=t/1e3;return n<100?`${n.toFixed(1)} MB`:`${n.toFixed(0)} MB`},"bytesToString"),PQ=s(e=>{if(!e||Number.isNaN(Number(e)))return e;let t=Number(e);return t%1?t.toFixed(3):String(t)},"toFixedIfFloating"),LQ=s((e,t=0)=>{let n=Math.pow(10,t);return Math.floor(e*n)/n},"floor"),KM=s((e,t)=>{for(e=Math.round(e),t=Math.round(t);t!==0;){let n=t;t=e%t,e=n}return e},"greatestCommonDivisor"),OQ=new Map([["8∶5","16∶10"]]),BQ=s((e,t)=>{let n=KM(e,t);n!==0&&(e/=n,t/=n);let r=`${e}∶${t}`;return OQ.get(r)||r},"aspectRatio"),UQ=s(function(e){let t=String(
e),n=/(\d+)(\d{3})/;for(;t.match(n);)t=t.replace(n,"$1 $2");return t},"withThousandsSeparator")});var ZM=y(()=>{l()});var JM=y(()=>{l()});var QM=y(()=>{l()});var e3=y(()=>{l()});var t3=y(()=>{l()});function is(e,t){throw new Error(t)}var ky=y(()=>{l();s(is,"assertNever")});var n3=y(()=>{l()});var r3=y(()=>{l()});var tn=y(()=>{l();qM();zM();HM();WM();GM();VM();$M();YM();XM();ZM();JM();QM();e3();t3();ky();n3();r3();ky()});var Rr={};x(Rr,{configToCacheKey:()=>KQ,defaults:()=>YQ});function KQ(e){return JSON.stringify(e)}var YQ,a3=y(()=>{l();YQ=s(()=>({includeRuntimeCallStats:!1,showAllEvents:!1,debugMode:!1}),"defaults");s(KQ,"configToCacheKey")});var pu={};x(pu,{colorIsValid:()=>o3,isExtensionPayloadFlameChartEntry:()=>JQ,isExtensionPayloadMarker:()=>ZQ,isSyntheticExtensionEntry:()=>QQ,validateColorInPayload:()=>Fy});function o3(e){return XQ.includes(e)}function Fy(e){if(!("color"in e)||!e.color)return!1;let t=e.color;return o3(t)}function ZQ(e){let t=Fy(e);return e.metadata.dataType==="marker"&&t}function JQ(e){let t=Fy(e),n="track"in e&&!!e.track;return e.metadata.dataType==="track-entry"&&n&&t}function QQ(e){return e.cat==="devtools.extension"}var XQ,i3=y(()=>{l();XQ=["primary","primary-light","primary-dark","secondary","secondary-light","secondary-dark","tertiary","tertiary-light","tertiary-dark","error"];s(o3,"colorIsValid");s(Fy,"validateColorInPayload");s(ZQ,"isExtensionPayloadMarker");s(JQ,"isExtensionPayloadFlameChartEntry");s(QQ,"isSyntheticExtensionEntry")});var s3=y(()=>{l()});var I={};x(I,{MicroSeconds:()=>eee,MilliSeconds:()=>tee,Seconds:()=>nee});function eee(e){return e}function tee(e){return e}function nee(e){return e}var c3=y(()=>{l();s(eee,"MicroSeconds");s(tee,"MilliSeconds");s(nee,"Seconds")});var R={};x(R,{CallFrameID:()=>Wee,Categories:()=>Jte,MarkerName:()=>lee,ProcessID:()=>Gee,ProfileID:()=>Hee,ThreadID:()=>Vee,WorkerId:()=>$ee,eventIsPageLoadEvent:()=>pee,isAsyncPhase:()=>ree,isFlowPhase:()=>aee,isJSInvocationEvent:()=>Zte,isLegacyTraceEventDrawFrameBegin:()=>See,isNestableAsyncPhase:()=>u3,isProcessName:()=>nte,isProfileCall:()=>D3,isSyntheticConsoleTiming:()=>Fte,isSyntheticCpuProfile:()=>fte,isSyntheticEvent:()=>Dee,isSyntheticInteractionEvent:()=>Eee,isSyntheticInvalidation:()=>Pee,isSyntheticLayoutShift:()=>Pte,isSyntheticNetworkRequestDetailsEvent:()=>Tte,isSyntheticTraceEntry:()=>Tee,isSyntheticUserTiming:()=>kte,isThreadName:()=>tte,isTraceEventActivateLayerTree:()=>Mee,isTraceEventAnimation:()=>ite,isTraceEventAsyncPhase:()=>_y,isTraceEventAuctionWorkletDoneWithProcess:()=>cee,isTraceEventAuctionWorkletRunningInProcess:()=>see,isTraceEventBegin:()=>Yee,isTraceEventBeginCommitCompositorFrame:()=>vee,isTraceEventBeginFrame:()=>Cee,isTraceEventBeginMainThreadFrame:()=>Ree,
isTraceEventCommit:()=>_ee,isTraceEventCommitLoad:()=>ote,isTraceEventComplete:()=>d3,isTraceEventCompositeLayers:()=>Nee,isTraceEventConsoleTime:()=>_te,isTraceEventDecodeImage:()=>Bee,isTraceEventDecodeLazyPixelRef:()=>Oee,isTraceEventDispatch:()=>Xee,isTraceEventDisplayListItemListSnapshot:()=>qte,isTraceEventDrawFrame:()=>xee,isTraceEventDrawLazyPixelRef:()=>Lee,isTraceEventDroppedFrame:()=>kee,isTraceEventEnd:()=>Kee,isTraceEventEventTiming:()=>Ay,isTraceEventEventTimingEnd:()=>lte,isTraceEventEventTimingStart:()=>dte,isTraceEventFireAnimationFrame:()=>Hte,isTraceEventFireIdleCallback:()=>Zee,isTraceEventFirstContentfulPaint:()=>h3,isTraceEventFirstPaint:()=>v3,isTraceEventFrameCommittedInBrowser:()=>ate,isTraceEventFunctionCall:()=>Xte,isTraceEventGPUTask:()=>mte,isTraceEventHandlePostMessage:()=>Qee,isTraceEventInstant:()=>m3,isTraceEventInteractiveTime:()=>w3,isTraceEventInvalidateLayout:()=>zee,isTraceEventLargestContentfulPaintCandidate:()=>g3,isTraceEventLargestImagePaintCandidate:()=>cte,
isTraceEventLargestTextPaintCandidate:()=>ute,isTraceEventLayerTreeHostImplSnapshot:()=>zte,isTraceEventLayout:()=>qee,isTraceEventLayoutInvalidationTracking:()=>ste,isTraceEventLayoutShift:()=>f3,isTraceEventMainFrameViewport:()=>Cte,isTraceEventMarkDOMContent:()=>b3,isTraceEventMarkLoad:()=>y3,isTraceEventMarkerEvent:()=>dee,isTraceEventNavigationStart:()=>Ry,isTraceEventNavigationStartWithURL:()=>Ste,isTraceEventNeedsBeginFrameChanged:()=>Aee,isTraceEventPaint:()=>Lte,isTraceEventPaintImage:()=>Ote,isTraceEventParseHTML:()=>Nte,isTraceEventPerformanceMark:()=>Ate,isTraceEventPerformanceMeasure:()=>Rte,isTraceEventPipelineReporter:()=>wee,isTraceEventPrePaint:()=>xte,isTraceEventProfile:()=>pte,isTraceEventProfileChunk:()=>hte,isTraceEventRasterTask:()=>Iee,isTraceEventRendererEvent:()=>p3,isTraceEventRequestAnimationFrame:()=>Wte,isTraceEventRequestIdleCallback:()=>$te,isTraceEventRequestMainThreadFrame:()=>Fee,isTraceEventResourceChangePriority:()=>gte,isTraceEventResourceFinish:()=>wte,
isTraceEventResourceMarkAsCached:()=>bte,isTraceEventResourceReceiveResponse:()=>vte,isTraceEventResourceReceivedData:()=>Ete,isTraceEventResourceSendRequest:()=>yte,isTraceEventResourceWillSendRequest:()=>Dte,isTraceEventRunTask:()=>iee,isTraceEventSchedulePostMessage:()=>Jee,isTraceEventScheduleStyleInvalidationTracking:()=>hee,isTraceEventScheduleStyleRecalculation:()=>bee,isTraceEventScreenshot:()=>uee,isTraceEventScrollLayer:()=>Bte,isTraceEventSelectorStats:()=>Uee,isTraceEventSetLayerId:()=>Ute,isTraceEventStyleInvalidatorInvalidationTracking:()=>yee,isTraceEventStyleRecalcInvalidationTracking:()=>gee,isTraceEventTimeStamp:()=>Ite,isTraceEventTimerFire:()=>Vte,isTraceEventTimerInstall:()=>Gte,isTraceEventTracingSessionIdForWorker:()=>fee,isTraceEventTracingStartedInBrowser:()=>rte,isTraceEventUpdateCounters:()=>ete,isTraceEventUpdateLayer:()=>jte,isTraceEventUpdateLayoutTree:()=>jee,isTraceEventV8Compile:()=>Kte,isTraceEventWebSocketCreate:()=>E3,isTraceEventWebSocketDestroy:()=>S3,
isTraceEventWebSocketReceiveHandshakeResponse:()=>x3,isTraceEventWebSocketSendHandshakeRequest:()=>T3,isWebSocketTraceEvent:()=>Yte,objectIsTraceEventCallFrame:()=>oee});function u3(e){return e==="b"||e==="e"||e==="n"}function ree(e){return u3(e)||e==="S"||e==="T"||e==="F"||e==="p"}function aee(e){return e==="s"||e==="t"||e==="f"}function oee(e){return"functionName"in e&&typeof e.functionName=="string"&&"scriptId"in e&&(typeof e.scriptId=="string"||typeof e.scriptId=="number")&&"columnNumber"in e&&typeof e.columnNumber=="number"&&"lineNumber"in e&&typeof e.lineNumber=="number"&&"url"in e&&typeof e.url=="string"}function iee(e){return e.name==="RunTask"}function see(e){return e.name==="AuctionWorkletRunningInProcess"}function cee(e){return e.name==="AuctionWorkletDoneWithProcess"}function uee(e){return e.name==="Screenshot"}function dee(e){return l3.some(t=>t(e))}function pee(e){return mee.some(t=>t(e))}function fee(e){return e.name==="TracingSessionIdForWorker"}function hee(e){return e.
name==="ScheduleStyleInvalidationTracking"}function gee(e){return e.name==="StyleRecalcInvalidationTracking"}function yee(e){return e.name==="StyleInvalidatorInvalidationTracking"}function vee(e){return e.name==="BeginCommitCompositorFrame"}function bee(e){return e.name==="ScheduleStyleRecalculation"}function wee(e){return e.name==="PipelineReporter"}function Dee(e){return"rawSourceEvent"in e}function Eee(e){return!!("interactionId"in e&&e.args?.data&&"beginEvent"in e.args.data&&"endEvent"in e.args.data)}function Tee(e){return p3(e)||D3(e)}function xee(e){return e.name==="DrawFrame"&&e.ph==="I"}function See(e){return e.name==="DrawFrame"&&e.ph==="b"}function Cee(e){return!!(e.name==="BeginFrame"&&e.args&&"frameSeqId"in e.args)}function kee(e){return!!(e.name==="DroppedFrame"&&e.args&&"frameSeqId"in e.args)}function Fee(e){return e.name==="RequestMainThreadFrame"}function Ree(e){return e.name==="BeginMainThreadFrame"}function Aee(e){return e.name==="NeedsBeginFrameChanged"}function _ee(e){
return!!(e.name==="Commit"&&e.args&&"frameSeqId"in e.args)}function Iee(e){return e.name==="RasterTask"}function Nee(e){return e.name==="CompositeLayers"}function Mee(e){return e.name==="ActivateLayerTree"}function Pee(e){return e.name==="SyntheticInvalidation"}function Lee(e){return e.name==="Draw LazyPixelRef"}function Oee(e){return e.name==="Decode LazyPixelRef"}function Bee(e){return e.name==="Decode Image"}function Uee(e){return e.name==="SelectorStats"}function jee(e){return e.name==="UpdateLayoutTree"}function qee(e){return e.name==="Layout"}function zee(e){return e.name==="InvalidateLayout"}function Hee(e){return e}function Wee(e){return e}function Gee(e){return e}function Vee(e){return e}function $ee(e){return e}function d3(e){return e.ph==="X"}function Yee(e){return e.ph==="B"}function Kee(e){return e.ph==="E"}function Xee(e){return e.name==="EventDispatch"}function m3(e){return e.ph==="I"}function p3(e){return m3(e)||d3(e)}function Zee(e){return e.name==="FireIdleCallback"}function Jee(e){
return e.name==="SchedulePostMessage"}function Qee(e){return e.name==="HandlePostMessage"}function ete(e){return e.name==="UpdateCounters"}function tte(e){return e.name==="thread_name"}function nte(e){return e.name==="process_name"}function rte(e){return e.name==="TracingStartedInBrowser"}function ate(e){return e.name==="FrameCommittedInBrowser"}function ote(e){return e.name==="CommitLoad"}function Ry(e){return e.name==="navigationStart"}function ite(e){return e.name==="Animation"&&e.cat.includes("devtools.timeline")}function f3(e){return e.name==="LayoutShift"}function ste(e){return e.name==="LayoutInvalidationTracking"}function h3(e){return e.name==="firstContentfulPaint"}function g3(e){return e.name==="largestContentfulPaint::Candidate"}function cte(e){return e.name==="LargestImagePaint::Candidate"}function ute(e){return e.name==="LargestTextPaint::Candidate"}function y3(e){return e.name==="MarkLoad"}function v3(e){return e.name==="firstPaint"}function b3(e){return e.name==="MarkDOM\
Content"}function w3(e){return e.name==="InteractiveTime"}function Ay(e){return e.name==="EventTiming"}function lte(e){return Ay(e)&&e.ph==="e"}function dte(e){return Ay(e)&&e.ph==="b"}function mte(e){return e.name==="GPUTask"}function pte(e){return e.name==="Profile"}function fte(e){return e.name==="CpuProfile"}function hte(e){return e.name==="ProfileChunk"}function gte(e){return e.name==="ResourceChangePriority"}function yte(e){return e.name==="ResourceSendRequest"}function vte(e){return e.name==="ResourceReceiveResponse"}function bte(e){return e.name==="ResourceMarkAsCached"}function wte(e){return e.name==="ResourceFinish"}function Dte(e){return e.name==="ResourceWillSendRequest"}function Ete(e){return e.name==="ResourceReceivedData"}function Tte(e){return e.name==="SyntheticNetworkRequest"}function xte(e){return e.name==="PrePaint"}function Ste(e){return!!(Ry(e)&&e.args.data&&e.args.data.documentLoaderURL!=="")}function Cte(e){return e.name==="PaintTimingVisualizer::Viewport"}function kte(e){
if(e.cat!=="blink.user_timing")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function Fte(e){if(e.cat!=="blink.console")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function Rte(e){return e.cat==="blink.user_timing"&&_y(e)}function Ate(e){return e.cat==="blink.user_timing"&&(e.ph==="R"||e.ph==="I")}function _te(e){return e.cat==="blink.console"&&_y(e)}function Ite(e){return e.ph==="I"&&e.name==="TimeStamp"}function Nte(e){return e.name==="ParseHTML"}function _y(e){return Mte.has(e.ph)}function Pte(e){return!f3(e)||!e.args.data?!1:"rawEvent"in e.args.data}function D3(e){return"callFrame"in e}function Lte(e){return e.name==="Paint"}function Ote(e){return e.name==="PaintImage"}function Bte(e){return e.name==="ScrollLayer"}function Ute(e){return e.name==="SetLayerTreeId"}function jte(e){return e.name==="UpdateLayer"}function qte(e){return e.name==="cc::DisplayItemList"}function zte(e){return e.name==="cc::LayerTreeHostImpl"}function Hte(e){
return e.name==="FireAnimationFrame"}function Wte(e){return e.name==="RequestAnimationFrame"}function Gte(e){return e.name==="TimerInstall"}function Vte(e){return e.name==="TimerFire"}function $te(e){return e.name==="RequestIdleCallback"}function E3(e){return e.name==="WebSocketCreate"}function T3(e){return e.name==="WebSocketSendHandshakeRequest"}function x3(e){return e.name==="WebSocketReceiveHandshakeResponse"}function S3(e){return e.name==="WebSocketDestroy"}function Yte(e){return E3(e)||S3(e)||x3(e)||T3(e)}function Kte(e){return e.name==="v8.compile"}function Xte(e){return e.name==="FunctionCall"}function Zte(e){switch(e.name){case"RunMicrotasks":case"FunctionCall":case"EvaluateScript":case"v8.evaluateModule":case"EventDispatch":case"V8.Execute":return!0}return!!(e.name.startsWith("v8")||e.name.startsWith("V8"))}var l3,lee,mee,Mte,Jte,C3=y(()=>{l();s(u3,"isNestableAsyncPhase");s(ree,"isAsyncPhase");s(aee,"isFlowPhase");s(oee,"objectIsTraceEventCallFrame");s(iee,"isTraceEventRunTas\
k");s(see,"isTraceEventAuctionWorkletRunningInProcess");s(cee,"isTraceEventAuctionWorkletDoneWithProcess");s(uee,"isTraceEventScreenshot");l3=[b3,y3,v3,h3,g3,Ry],lee=["MarkDOMContent","MarkLoad","firstPaint","firstContentfulPaint","largestContentfulPaint::Candidate"];s(dee,"isTraceEventMarkerEvent");mee=[...l3,w3];s(pee,"eventIsPageLoadEvent");s(fee,"isTraceEventTracingSessionIdForWorker");s(hee,"isTraceEventScheduleStyleInvalidationTracking");s(gee,"isTraceEventStyleRecalcInvalidationTracking");s(yee,"isTraceEventStyleInvalidatorInvalidationTracking");s(vee,"isTraceEventBeginCommitCompositorFrame");s(bee,"isTraceEventScheduleStyleRecalculation");s(wee,"isTraceEventPipelineReporter");s(Dee,"isSyntheticEvent");s(Eee,"isSyntheticInteractionEvent");s(Tee,"isSyntheticTraceEntry");s(xee,"isTraceEventDrawFrame");s(See,"isLegacyTraceEventDrawFrameBegin");s(Cee,"isTraceEventBeginFrame");s(kee,"isTraceEventDroppedFrame");s(Fee,"isTraceEventRequestMainThreadFrame");s(Ree,"isTraceEventBeginMainTh\
readFrame");s(Aee,"isTraceEventNeedsBeginFrameChanged");s(_ee,"isTraceEventCommit");s(Iee,"isTraceEventRasterTask");s(Nee,"isTraceEventCompositeLayers");s(Mee,"isTraceEventActivateLayerTree");s(Pee,"isSyntheticInvalidation");s(Lee,"isTraceEventDrawLazyPixelRef");s(Oee,"isTraceEventDecodeLazyPixelRef");s(Bee,"isTraceEventDecodeImage");s(Uee,"isTraceEventSelectorStats");s(jee,"isTraceEventUpdateLayoutTree");s(qee,"isTraceEventLayout");s(zee,"isTraceEventInvalidateLayout");s(Hee,"ProfileID");s(Wee,"CallFrameID");s(Gee,"ProcessID");s(Vee,"ThreadID");s($ee,"WorkerId");s(d3,"isTraceEventComplete");s(Yee,"isTraceEventBegin");s(Kee,"isTraceEventEnd");s(Xee,"isTraceEventDispatch");s(m3,"isTraceEventInstant");s(p3,"isTraceEventRendererEvent");s(Zee,"isTraceEventFireIdleCallback");s(Jee,"isTraceEventSchedulePostMessage");s(Qee,"isTraceEventHandlePostMessage");s(ete,"isTraceEventUpdateCounters");s(tte,"isThreadName");s(nte,"isProcessName");s(rte,"isTraceEventTracingStartedInBrowser");s(ate,"isTrac\
eEventFrameCommittedInBrowser");s(ote,"isTraceEventCommitLoad");s(Ry,"isTraceEventNavigationStart");s(ite,"isTraceEventAnimation");s(f3,"isTraceEventLayoutShift");s(ste,"isTraceEventLayoutInvalidationTracking");s(h3,"isTraceEventFirstContentfulPaint");s(g3,"isTraceEventLargestContentfulPaintCandidate");s(cte,"isTraceEventLargestImagePaintCandidate");s(ute,"isTraceEventLargestTextPaintCandidate");s(y3,"isTraceEventMarkLoad");s(v3,"isTraceEventFirstPaint");s(b3,"isTraceEventMarkDOMContent");s(w3,"isTraceEventInteractiveTime");s(Ay,"isTraceEventEventTiming");s(lte,"isTraceEventEventTimingEnd");s(dte,"isTraceEventEventTimingStart");s(mte,"isTraceEventGPUTask");s(pte,"isTraceEventProfile");s(fte,"isSyntheticCpuProfile");s(hte,"isTraceEventProfileChunk");s(gte,"isTraceEventResourceChangePriority");s(yte,"isTraceEventResourceSendRequest");s(vte,"isTraceEventResourceReceiveResponse");s(bte,"isTraceEventResourceMarkAsCached");s(wte,"isTraceEventResourceFinish");s(Dte,"isTraceEventResourceWillSe\
ndRequest");s(Ete,"isTraceEventResourceReceivedData");s(Tte,"isSyntheticNetworkRequestDetailsEvent");s(xte,"isTraceEventPrePaint");s(Ste,"isTraceEventNavigationStartWithURL");s(Cte,"isTraceEventMainFrameViewport");s(kte,"isSyntheticUserTiming");s(Fte,"isSyntheticConsoleTiming");s(Rte,"isTraceEventPerformanceMeasure");s(Ate,"isTraceEventPerformanceMark");s(_te,"isTraceEventConsoleTime");s(Ite,"isTraceEventTimeStamp");s(Nte,"isTraceEventParseHTML");Mte=new Set(["b","n","e","T","S","F","p"]);s(_y,"isTraceEventAsyncPhase");s(Pte,"isSyntheticLayoutShift");s(D3,"isProfileCall");s(Lte,"isTraceEventPaint");s(Ote,"isTraceEventPaintImage");s(Bte,"isTraceEventScrollLayer");s(Ute,"isTraceEventSetLayerId");s(jte,"isTraceEventUpdateLayer");s(qte,"isTraceEventDisplayListItemListSnapshot");s(zte,"isTraceEventLayerTreeHostImplSnapshot");s(Hte,"isTraceEventFireAnimationFrame");s(Wte,"isTraceEventRequestAnimationFrame");s(Gte,"isTraceEventTimerInstall");s(Vte,"isTraceEventTimerFire");s($te,"isTraceEventR\
equestIdleCallback");s(E3,"isTraceEventWebSocketCreate");s(T3,"isTraceEventWebSocketSendHandshakeRequest");s(x3,"isTraceEventWebSocketReceiveHandshakeResponse");s(S3,"isTraceEventWebSocketDestroy");s(Yte,"isWebSocketTraceEvent");s(Kte,"isTraceEventV8Compile");s(Xte,"isTraceEventFunctionCall");s(Zte,"isJSInvocationEvent");Jte={Console:"blink.console",UserTiming:"blink.user_timing",Loading:"loading"}});var Ke=y(()=>{l();a3();i3();s3();c3();C3()});var me={};x(me,{detectBestTimeUnit:()=>F3,eventTimingsMicroSeconds:()=>Vo,eventTimingsMilliSeconds:()=>nne,eventTimingsSeconds:()=>rne,formatMicrosecondsTime:()=>ene,microSecondsToMilliseconds:()=>Wa,microSecondsToSeconds:()=>fu,millisecondsToMicroseconds:()=>cr,secondsToMicroseconds:()=>Qte,secondsToMilliseconds:()=>k3,timeStampForEventAdjustedByClosestNavigation:()=>tne,traceWindowFromMicroSeconds:()=>sne,traceWindowFromMilliSeconds:()=>ine,traceWindowMilliSeconds:()=>ane,traceWindowMillisecondsToMicroSeconds:()=>one});function F3(e){if(e<1e3)return 0;let t=e/1e3;return t<1e3?1:t/1e3<60?2:3}function ene(e,t={}){t.format||(t.format=F3(e));let n=e/1e3,r=n/1e3,a={...gp,...t};switch(t.format){case 0:return`${he.getWithDefault(ua,sa({style:"decimal"}),ca).format(e)}μs`;case 1:return he.getWithDefault(ua,sa(a),ca).format(n);case 2:return he.getWithDefault(ua,sa({...a,unit:"second"}),ca).format(r);default:{let o=he.getWithDefault(ua,sa({...a,unit:"minute"}),ca),i=he.getWithDefault(ua,sa({...a,
unit:"second"}),ca),c=r/60,[u,d,m]=o.formatToParts(c),p=0;return d&&m&&(p=Math.round(+`0.${m.value}`*60)),`${o.format(Number(u.value))} ${i.format(p)}`}}}function tne(e,t,n,r){let a=e.ts-t.min;if(e.args?.data?.navigationId){let o=n.get(e.args.data.navigationId);o&&(a=e.ts-o.ts)}else if(e.args?.data?.frame){let o=Iy(e,e.args.data.frame,r);o&&(a=e.ts-o.ts)}return I.MicroSeconds(a)}function Vo(e){return{startTime:e.ts,endTime:I.MicroSeconds(e.ts+(e.dur||I.MicroSeconds(0))),duration:I.MicroSeconds(e.dur||0),selfTime:R.isSyntheticTraceEntry(e)?I.MicroSeconds(e.selfTime||0):I.MicroSeconds(e.dur||0)}}function nne(e){let t=Vo(e);return{startTime:Wa(t.startTime),endTime:Wa(t.endTime),duration:Wa(t.duration),selfTime:Wa(t.selfTime)}}function rne(e){let t=Vo(e);return{startTime:fu(t.startTime),endTime:fu(t.endTime),duration:fu(t.duration),selfTime:fu(t.selfTime)}}function ane(e){return{min:Wa(e.min),max:Wa(e.max),range:Wa(e.range)}}function one(e){return{min:cr(e.min),max:cr(e.max),range:cr(e.range)}}
function ine(e,t){return{min:cr(e),max:cr(t),range:I.MicroSeconds(cr(t)-cr(e))}}function sne(e,t){return{min:e,max:t,range:I.MicroSeconds(t-e)}}var cr,k3,Qte,Wa,fu,gp,sa,ca,ua,yp=y(()=>{l();tn();Ke();hu();cr=s(e=>I.MicroSeconds(e*1e3),"millisecondsToMicroseconds"),k3=s(e=>I.MilliSeconds(e*1e3),"secondsToMilliseconds"),Qte=s(e=>cr(k3(e)),"secondsToMicroseconds"),Wa=s(e=>I.MilliSeconds(e/1e3),"microSecondsToMilliseconds"),fu=s(e=>I.Seconds(e/1e3/1e3),"microSecondsToSeconds");s(F3,"detectBestTimeUnit");gp={style:"unit",unit:"millisecond",unitDisplay:"narrow"},sa=s(e=>JSON.stringify(e),"serialize"),ca=s(e=>new Intl.NumberFormat(void 0,e?JSON.parse(e):{}),"formatterFactory"),ua=new Map;he.getWithDefault(ua,sa({style:"decimal"}),ca);he.getWithDefault(ua,sa(gp),ca);he.getWithDefault(ua,sa({...gp,unit:"second"}),ca);he.getWithDefault(ua,sa({...gp,unit:"minute"}),ca);s(ene,"formatMicrosecondsTime");s(tne,"timeStampForEventAdjustedByClosestNavigation");s(Vo,"eventTimingsMicroSeconds");s(nne,"eve\
ntTimingsMilliSeconds");s(rne,"eventTimingsSeconds");s(ane,"traceWindowMilliSeconds");s(one,"traceWindowMillisecondsToMicroSeconds");s(ine,"traceWindowFromMilliSeconds");s(sne,"traceWindowFromMicroSeconds")});var Be={};x(Be,{activeURLForFrameAtTime:()=>dne,addEventToProcessThread:()=>lne,createMatchedSortedSyntheticEvents:()=>pne,createSortedSyntheticEvents:()=>_3,eventHasCategory:()=>Ene,eventTimeComparator:()=>My,extractId:()=>R3,extractOriginFromTrace:()=>une,findUpdateLayoutTreeEvents:()=>bne,forEachEvent:()=>wne,frameIDForEvent:()=>yne,getNavigationForTraceEvent:()=>Iy,getZeroIndexedLineAndColumnForEvent:()=>fne,getZeroIndexedStackTraceForEvent:()=>hne,isTopLevelEvent:()=>I3,makeProfileCall:()=>vp,makeSyntheticTraceEntry:()=>mne,matchEvents:()=>A3,mergeEventsInOrder:()=>Ly,sortTraceEventsInPlace:()=>Py});function cne(e){return R.isSyntheticInvalidation(e)?e.stackTrace||null:e.args?.data?.stackTrace?e.args.data.stackTrace:R.isTraceEventUpdateLayoutTree(e)&&e.args.beginData?.stackTrace||null}function une(e){let t=new URL(e);return t?t.host.startsWith("www.")?t.host.slice(4):t.host:null}function lne(e,t){let{tid:n,pid:r}=e,a=t.get(r);a||(a=new Map);let o=a.get(n);o||(o=[]),o.push(e),a.set(
e.tid,o),t.set(e.pid,a)}function My(e,t){let n=e.ts,r=t.ts;if(n<r)return-1;if(n>r)return 1;let a=e.dur??0,o=t.dur??0,i=n+a,c=r+o;return i>c?-1:i<c?1:0}function Py(e){e.sort(My)}function Ly(e,t){let n=[],r=0,a=0;for(;r<e.length&&a<t.length;){let o=e[r],i=t[a],c=My(o,i);c<=0&&(n.push(o),r++),c===1&&(n.push(i),a++)}for(;r<e.length;)n.push(e[r++]);for(;a<t.length;)n.push(t[a++]);return n}function Iy(e,t,n){let r=n.get(t);if(!r||t==="")return null;let a=Ht.nearestIndexFromEnd(r,o=>o.ts<=e.ts);return a===null?null:r[a]}function R3(e){return e.id??e.id2?.global??e.id2?.local}function dne(e,t,n){let r=n.get(e);if(!r)return null;for(let a of r.values())for(let o of a)if(!(o.window.min>t||o.window.max<t))return o.frame.url;return null}function vp(e,t,n,r,a,o){return{cat:"",name:"ProfileCall",nodeId:e.id,args:{},ph:"X",pid:a,tid:o,ts:r,dur:I.MicroSeconds(0),selfTime:I.MicroSeconds(0),callFrame:e.callFrame,sampleIndex:n,profileId:t}}function mne(e,t,n,r){return{cat:"",name:e,args:{},ph:"X",pid:n,tid:r,
ts:t,dur:I.MicroSeconds(0),selfTime:I.MicroSeconds(0)}}function A3(e){let t=new Map;for(let n of e){let r=Ny(n);if(r===void 0)continue;let a=he.getWithDefault(t,r,()=>({begin:null,end:null,instant:[]})),o=n.ph==="b",i=n.ph==="e",c=n.ph==="n";o?a.begin=n:i?a.end=n:c&&(a.instant||(a.instant=[]),a.instant.push(n))}return t}function Ny(e){let t=R3(e);return t&&`${e.cat}:${t}:${e.name}`}function _3(e,t){let n=[];for(let[r,a]of e.entries()){let d=function(h){let f=h.instantEvents?h.instantEvents.some(v=>r===Ny(v)):!1,g=h.endEvent?r===Ny(h.endEvent):!1;return!!r&&(f||g)};s(d,"eventsArePairable");let o=a.begin,i=a.end,c=a.instant;if(!o||!(i||c))continue;let u={beginEvent:o,endEvent:i,instantEvents:c};if(!d(u))continue;let m=i||o,p={rawSourceEvent:o,cat:m.cat,ph:m.ph,pid:m.pid,tid:m.tid,id:r,name:o.name,dur:I.MicroSeconds(m.ts-o.ts),ts:o.ts,args:{data:u}};p.dur<0||(t?.(p),n.push(p))}return n.sort((r,a)=>r.ts-a.ts)}function pne(e,t){let n=A3(e);return _3(n,t)}function fne(e){let t=gne(e),{lineNumber:n,
columnNumber:r}=t;switch(e.name){case"FunctionCall":case"EvaluateScript":case"v8.compile":case"v8.produceCache":return{lineNumber:typeof n=="number"?n-1:void 0,columnNumber:typeof r=="number"?r-1:void 0};default:return t}}function hne(e){let t=cne(e);return t?t.map(n=>{let r={...n};switch(e.name){case"ScheduleStyleRecalculation":case"InvalidateLayout":case"UpdateLayoutTree":r.lineNumber=n.lineNumber&&n.lineNumber-1,r.columnNumber=n.columnNumber&&n.columnNumber-1}return r}):null}function gne(e){if(!e.args?.data)return{lineNumber:void 0,columnNumber:void 0};let t,n;return"lineNumber"in e.args.data&&typeof e.args.data.lineNumber=="number"&&(t=e.args.data.lineNumber),"columnNumber"in e.args.data&&typeof e.args.data.columnNumber=="number"&&(n=e.args.data.columnNumber),{lineNumber:t,columnNumber:n}}function yne(e){return e.args&&"beginData"in e.args&&typeof e.args.beginData=="object"&&e.args.beginData!==null&&"frame"in e.args.beginData&&typeof e.args.beginData.frame=="string"?e.args.beginData.
frame:e.args?.data?.frame?e.args.data.frame:null}function I3(e){return e.name==="JSRoot"&&e.cat==="toplevel"?!0:e.cat.includes(vne)&&e.name==="RunTask"}function N3(e,t){let n=Ht.upperBound(e,t,(r,a)=>r-a.ts)-1;for(;n>0&&!I3(e[n]);)n--;return Math.max(n,0)}function bne(e,t,n){let r=[],a=N3(e,t);for(let o=a;o<e.length;o++){let i=e[o];R.isTraceEventUpdateLayoutTree(i)&&(i.ts>=(n||1/0)||r.push(i))}return r}function wne(e,t){let n=t.startTime||I.MicroSeconds(0),r=t.endTime||I.MicroSeconds(1/0),a=t.ignoreAsyncEvents!==!1,o=[],i=N3(e,n);for(let c=i;c<e.length;c++){let u=e[c],d=Vo(u);if(d.endTime<n)continue;if(d.startTime>r)break;if(a&&R.isAsyncPhase(u.ph)||R.isFlowPhase(u.ph))continue;let p=o.at(-1),h=p?Vo(p).endTime:null;for(;p&&h&&h<=d.startTime;)o.pop(),t.onEndEvent(p),p=o.at(-1),h=p?Vo(p).endTime:null;t.eventFilter&&!t.eventFilter(u)||(d.duration?(t.onStartEvent(u),o.push(u)):t.onInstantEvent&&t.onInstantEvent(u))}for(;o.length;){let c=o.pop();c&&t.onEndEvent(c)}}function Ene(e,t){let n=Dne.
get(e.cat);return n||(n=new Set(e.cat.split(",")||[])),n.has(t)}var vne,Dne,hu=y(()=>{l();tn();Ke();yp();s(cne,"stackTraceForEvent");s(une,"extractOriginFromTrace");s(lne,"addEventToProcessThread");s(My,"eventTimeComparator");s(Py,"sortTraceEventsInPlace");s(Ly,"mergeEventsInOrder");s(Iy,"getNavigationForTraceEvent");s(R3,"extractId");s(dne,"activeURLForFrameAtTime");s(vp,"makeProfileCall");s(mne,"makeSyntheticTraceEntry");s(A3,"matchEvents");s(Ny,"getSyntheticId");s(_3,"createSortedSyntheticEvents");s(pne,"createMatchedSortedSyntheticEvents");s(fne,"getZeroIndexedLineAndColumnForEvent");s(hne,"getZeroIndexedStackTraceForEvent");s(gne,"getRawLineAndColumnNumbersForEvent");s(yne,"frameIDForEvent");vne="disabled-by-default-devtools.timeline";s(I3,"isTopLevelEvent");s(N3,"topLevelEventIndexEndingAfter");s(bne,"findUpdateLayoutTreeEvents");s(wne,"forEachEvent");Dne=new Map;s(Ene,"eventHasCategory")});var Ga={};x(Ga,{canBuildTreesFromEvents:()=>jy,makeEmptyTraceEntryNode:()=>L3,makeEmptyTraceEntryTree:()=>P3,makeTraceEntryNodeId:()=>M3,treify:()=>By,walkEntireTree:()=>xne,walkTreeFromEntry:()=>Tne});function By(e,t){let n=new Map,r=[];Oy=-1;let a=P3();for(let o=0;o<e.length;o++){let i=e[o];if(t&&!t.filter.has(i.name))continue;let c=i.dur||0,u=M3(),d=L3(i,u);if(r.length===0){a.roots.add(d),i.selfTime=I.MicroSeconds(c),r.push(d),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(i,d);continue}let m=r.at(-1);if(m===void 0)throw new Error("Impossible: no parent node found in the stack");let p=m.entry,h=i.ts,f=p.ts,g=p.dur||0,v=h+c,w=f+g;if(h<f)throw new Error("Impossible: current event starts before the parent event");if(h>=w){r.pop(),o--,Oy--;continue}v>w||(d.depth=r.length,d.parent=m,m.children.push(d),i.selfTime=I.MicroSeconds(c),p.selfTime!==void 0&&(p.selfTime=I.MicroSeconds(p.selfTime-(i.dur||0))),r.push(d),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(i,d))}return{tree:a,entryToNode:n}}
function Tne(e,t,n,r){let a=e.get(t);a&&Uy(e,a,n,r)}function xne(e,t,n,r,a,o){for(let i of t.roots)Uy(e,i,n,r,a,o)}function Uy(e,t,n,r,a,o){if(!(a&&!Sne(t,a))&&!(typeof o<"u"&&I.MicroSeconds(t.entry.ts+I.MicroSeconds(t.entry.dur||0))<o)){n(t.entry);for(let i of t.children)Uy(e,i,n,r,a,o);r(t.entry)}}function Sne(e,t){let n=e.entry.ts,r=e.entry.ts+(e.entry.dur||0);return n>=t.min&&n<t.max||r>t.min&&r<=t.max||n<=t.min&&r>=t.max}function jy(e){let t=[];for(let n of e){let r=n.ts,a=n.ts+(n.dur||0),o=t.at(-1);if(o===void 0){t.push(n);continue}let i=o.ts+(o.dur||0);for(;t.length&&r>=i&&(t.pop(),o=t.at(-1),o!==void 0);)i=o.ts+(o.dur||0);if(t.length&&a>i)return!1;t.push(n)}return!0}var Oy,M3,P3,L3,qy=y(()=>{l();Ke();Oy=0,M3=s(()=>++Oy,"makeTraceEntryNodeId"),P3=s(()=>({roots:new Set,maxDepth:0}),"makeEmptyTraceEntryTree"),L3=s((e,t)=>({entry:e,id:t,parent:null,children:[],depth:0}),"makeEmptyTraceEntryNode");s(By,"treify");s(Tne,"walkTreeFromEntry");s(xne,"walkEntireTree");s(Uy,"walkTreeByNode");
s(Sne,"treeNodeIsInWindow");s(jy,"canBuildTreesFromEvents")});var bp={};x(bp,{buildTrackDataFromExtensionEntries:()=>Cne});function Cne(e,t){let n=new Map;for(let r of e)he.getWithDefault(n,`${r.args.metadata.extensionName}.${r.args.track}`,()=>({name:r.args.track,extensionName:r.args.metadata.extensionName,flameChartEntries:[]})).flameChartEntries.push(r);for(let r of n.values())Py(r.flameChartEntries),jy(r.flameChartEntries)&&By(r.flameChartEntries),t.push(r);return t}var O3=y(()=>{l();tn();hu();qy();s(Cne,"buildTrackDataFromExtensionEntries")});var gu={};x(gu,{SamplesIntegrator:()=>zy});var zy,B3=y(()=>{l();Ke();yp();hu();zy=class e{static{s(this,"SamplesIntegrator")}#e=[];#t=[];#a;#n;#r=[];#i=!1;#o;#s=new Map;#c;#f;jsSampleEvents=[];constructor(t,n,r,a,o){this.#o=t,this.#n=a,this.#a=r,this.#c=o||Rr.defaults(),this.#f=n}buildProfileCalls(t){let n=Ly(t,this.callsFromProfileSamples()),r=[];for(let a=0;a<n.length;a++){let o=n[a];if(o.ph==="I")continue;if(r.length===0){if(R.isProfileCall(o)){this.#h(o);continue}r.push(o),this.#u(o);continue}let i=r.at(-1);if(i===void 0)continue;let c=o.ts,u=i.ts,d=i.dur||0,m=u+d;if(c>=m){this.#d(i),r.pop(),a--;continue}if(R.isProfileCall(o)){this.#h(o,i);continue}this.#u(o),r.push(o)}for(;r.length;){let a=r.pop();a&&this.#d(a)}return this.#e}#u(t){(t.name==="RunMicrotasks"||t.name==="RunTask")&&(this.#r=[],this.#p(0,t.ts),this.#i=!1),this.#i&&(this.#p(this.#r.pop()||0,t.ts),this.#i=!1),this.#l(t),this.#r.push(this.#t.length)}#h(t,n){if(n&&R.isJSInvocationEvent(n)||this.#i)this.#l(t);else if(R.isProfileCall(
t)&&this.#t.length===0){this.#i=!0;let r=this.#t.length;this.#l(t),this.#r.push(r)}}#d(t){let n=I.MicroSeconds(t.ts+(t.dur||0));this.#p(this.#r.pop()||0,n)}callsFromProfileSamples(){let t=this.#o.samples,n=this.#o.timestamps,r=this.#c.debugMode;if(!t)return[];let a=[],o;for(let i=0;i<t.length;i++){let c=this.#o.nodeByIndex(i),u=cr(I.MilliSeconds(n[i]));if(!c)continue;let d=vp(c,this.#f,i,u,this.#a,this.#n);if(a.push(d),r&&this.jsSampleEvents.push(this.#y(d,u)),c.id===this.#o.gcNode?.id&&o){this.#s.set(d,o);continue}o=c}return a}#m(t){let n=this.#o.nodeById(t.nodeId),r=n?.id===this.#o.gcNode?.id;if(r&&(n=this.#s.get(t)||null),!n)return[];let a=new Array(n.depth+1+Number(r)),o=a.length-1;for(r&&(a[o--]=t);n;)a[o--]=vp(n,t.profileId,t.sampleIndex,t.ts,this.#a,this.#n),n=n.parent;return a}#l(t){let n=R.isProfileCall(t)?this.#m(t):this.#t;e.filterStackFrames(n,this.#c);let r=t.ts+(t.dur||0),a=Math.min(n.length,this.#t.length),o;for(o=this.#r.at(-1)||0;o<a;++o){let i=n[o].callFrame,c=this.#t[o].
callFrame;if(!e.framesAreEqual(i,c))break;this.#t[o].dur=I.MicroSeconds(Math.max(this.#t[o].dur||0,r-this.#t[o].ts))}for(this.#p(o,t.ts);o<n.length;++o){let i=n[o];i.nodeId===this.#o.programNode?.id||i.nodeId===this.#o.root?.id||i.nodeId===this.#o.idleNode?.id||i.nodeId===this.#o.gcNode?.id||(this.#t.push(i),this.#e.push(i))}}#p(t,n){if(this.#r.length){let r=this.#r.at(-1);r&&t<r&&(console.error(`Child stack is shallower (${t}) than the parent stack (${r}) at ${n}`),t=r)}this.#t.length<t&&(console.error(`Trying to truncate higher than the current stack size at ${n}`),t=this.#t.length);for(let r=0;r<this.#t.length;++r)this.#t[r].dur=I.MicroSeconds(Math.max(n-this.#t[r].ts,0));this.#t.length=t}#y(t,n){return{name:"JSSample",cat:"devtools.timeline",args:{data:{stackTrace:this.#m(t).map(a=>a.callFrame)}},ph:"I",ts:n,dur:I.MicroSeconds(0),pid:this.#a,tid:this.#n}}static framesAreEqual(t,n){return t.scriptId===n.scriptId&&t.functionName===n.functionName&&t.lineNumber===n.lineNumber}static showNativeName(t,n){
return n&&!!e.nativeGroup(t)}static nativeGroup(t){return t.startsWith("Parse")?"Parse":t.startsWith("Compile")||t.startsWith("Recompile")?"Compile":null}static isNativeRuntimeFrame(t){return t.url==="native V8Runtime"}static filterStackFrames(t,n){if(n.showAllEvents)return;let a=null,o=0;for(let i=0;i<t.length;++i){let c=t[i].callFrame,u=e.isNativeRuntimeFrame(c);if(u&&!e.showNativeName(c.functionName,n.includeRuntimeCallStats))continue;let d=u?e.nativeGroup(c.functionName):null;a&&a===d||(a=d,t[o++]=t[i])}t.length=o}}});var Et=y(()=>{l();O3();B3();yp();hu();qy()});var U3=y(()=>{l();tn();Et();Ke()});var j3=y(()=>{l()});var Gy={};x(Gy,{data:()=>_ne,finalize:()=>Ane,handleEvent:()=>Rne,reset:()=>Fne});function Fne(){Hy.length=0,Wy.length=0}function Rne(e){if(R.isTraceEventAnimation(e)){Hy.push(e);return}}async function Ane(){let e=Be.createMatchedSortedSyntheticEvents(Hy);Wy.push(...e),q3=3}function _ne(){if(q3!==3)throw new Error("Animation handler is not finalized");return{animations:Wy}}var Hy,Wy,q3,z3=y(()=>{l();Et();Ke();Hy=[],Wy=[],q3=1;s(Fne,"reset");s(Rne,"handleEvent");s(Ane,"finalize");s(_ne,"data")});var Zy={};x(Zy,{data:()=>yu,finalize:()=>Pne,handleEvent:()=>Nne,reset:()=>Ine});function Ine(){Vy.clear(),$y.clear(),Yy.clear(),Ky.clear(),Xy.clear()}function Nne(e){if(R.isTraceEventAuctionWorkletRunningInProcess(e)){Vy.set(e.args.data.pid,e);return}if(R.isTraceEventAuctionWorkletDoneWithProcess(e)){$y.set(e.args.data.pid,e);return}if(R.isThreadName(e)){if(e.args.name==="auction_worklet.CrUtilityMain"){Ky.set(e.pid,e);return}e.args.name==="AuctionV8HelperThread"&&Xy.set(e.pid,e)}}function Mne(e){switch(e){case"seller":return"seller";case"bidder":return"bidder";default:return"unknown"}}function H3(e){return{rawSourceEvent:e,name:"SyntheticAuctionWorkletEvent",s:"t",cat:e.cat,tid:e.tid,ts:e.ts,ph:"I",pid:e.args.data.pid,host:e.args.data.host,target:e.args.data.target,type:Mne(e.args.data.type)}}async function Pne(){for(let[e,t]of Ky){let n=Xy.get(e);if(!n)continue;let r=Vy.get(e),a=$y.get(e),o=null;r?(o={...H3(r),args:{data:{runningInProcessEvent:r,utilityThread:t,v8HelperThread:n}}},a&&
(o.args.data.doneWithProcessEvent=a)):a&&(o={...H3(a),args:{data:{doneWithProcessEvent:a,utilityThread:t,v8HelperThread:n}}},r&&(o.args.data.runningInProcessEvent=r)),o!==null&&Yy.set(e,o)}}function yu(){return{worklets:new Map(Yy)}}var Vy,$y,Yy,Ky,Xy,wp=y(()=>{l();Ke();Vy=new Map,$y=new Map,Yy=new Map,Ky=new Map,Xy=new Map;s(Ine,"reset");s(Nne,"handleEvent");s(Mne,"workletType");s(H3,"makeSyntheticEventBase");s(Pne,"finalize");s(yu,"data")});var nv={};x(nv,{data:()=>Ep,finalize:()=>jne,handleEvent:()=>Une,reset:()=>Lne});function Lne(){Dp.length=0,Jy.length=0,Qy.length=0,ev.length=0,tv.length=0,vu=2}function Une(e){if(vu!==2)throw new Error("UserTimings handler is not initialized");if(![...One,...Bne].includes(e.name)){if(R.isTraceEventPerformanceMeasure(e)){Jy.push(e);return}R.isTraceEventPerformanceMark(e)&&Qy.push(e),R.isTraceEventConsoleTime(e)&&ev.push(e),R.isTraceEventTimeStamp(e)&&tv.push(e)}}async function jne(){if(vu!==2)throw new Error("UserTimings handler is not initialized");let e=[...Jy,...ev];Dp=Be.createMatchedSortedSyntheticEvents(e),vu=3}function Ep(){if(vu!==3)throw new Error("UserTimings handler is not finalized");return{performanceMeasures:Dp.filter(e=>e.cat==="blink.user_timing"),consoleTimings:Dp.filter(e=>e.cat==="blink.console"),performanceMarks:[...Qy],timestampEvents:[...tv]}}var Dp,Jy,Qy,ev,tv,vu,One,Bne,rv=y(()=>{l();Et();Ke();Dp=[],Jy=[],Qy=[],ev=[],tv=[],vu=1;s(Lne,"reset");One=["workerStart",
"redirectStart","redirectEnd","fetchStart","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd"],Bne=["navigationStart","unloadEventStart","unloadEventEnd","redirectStart","redirectEnd","fetchStart","commitNavigationEnd","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd","domLoading","domInteractive","domContentLoadedEventStart","domContentLoadedEventEnd","domComplete","loadEventStart","loadEventEnd"];s(Une,"handleEvent");s(jne,"finalize");s(Ep,"data")});var sv={};x(sv,{data:()=>Gne,deps:()=>Vne,extensionDataInTiming:()=>G3,extractExtensionEntries:()=>W3,finalize:()=>Hne,handleEvent:()=>qne,reset:()=>zne});function qne(e){}function zne(){Tp=2,av.length=0,ov.length=0,iv.length=0}async function Hne(){if(Tp!==2)throw new Error("ExtensionTraceData handler is not initialized");Wne(),Tp=3}function Wne(){let e=Ep().performanceMeasures,t=Ep().performanceMarks,n=Be.mergeEventsInOrder(e,t);W3(n),bp.buildTrackDataFromExtensionEntries(av,ov)}function W3(e){for(let t of e){let n=G3(t);if(!n||!n.metadata.extensionName)continue;let a={name:t.name,ph:"X",pid:R.ProcessID(0),tid:R.ThreadID(0),ts:t.ts,selfTime:I.MicroSeconds(0),dur:t.dur,cat:"devtools.extension",args:n};if(pu.isExtensionPayloadMarker(n)){iv.push(a);continue}if(pu.isExtensionPayloadFlameChartEntry(n)){av.push(a);continue}}}function G3(e){let t=R.isTraceEventPerformanceMark(e)?e.args.data?.detail:e.args.data.beginEvent.args.detail;if(!t)return null;try{let n=JSON.parse(t);return!("devtools"in
n)||!("metadata"in n.devtools)?null:n.devtools}catch{return null}}function Gne(){if(Tp!==3)throw new Error("ExtensionTraceData handler is not finalized");return{extensionTrackData:[...ov],extensionMarkers:[...iv]}}function Vne(){return["UserTimings"]}var av,ov,iv,Tp,V3=y(()=>{l();Et();Ke();rv();av=[],ov=[],iv=[],Tp=1;s(qne,"handleEvent");s(zne,"reset");s(Hne,"finalize");s(Wne,"createExtensionFlameChartEntries");s(W3,"extractExtensionEntries");s(G3,"extensionDataInTiming");s(Gne,"data");s(Vne,"deps")});var hv={};x(hv,{data:()=>Rt,finalize:()=>Jne,handleEvent:()=>Zne,initialize:()=>Xne,reset:()=>Kne});function Kne(){ss.clear(),wu.clear(),pv.clear(),_p.length=0,lv=R.ProcessID(-1),dv=R.ThreadID(-1),mv=R.ProcessID(-1),Cp=R.ThreadID(-1),kp=null,Fp.clear(),fv.clear(),bu.clear(),uv.clear(),wn.min=I.MicroSeconds(Number.POSITIVE_INFINITY),wn.max=I.MicroSeconds(Number.NEGATIVE_INFINITY),wn.range=I.MicroSeconds(Number.POSITIVE_INFINITY),Rp=I.MicroSeconds(-1),Ap=!0,$o=1}function Xne(){if($o!==1)throw new Error("Meta Handler was not reset");$o=2}function cv(e,t){he.getWithDefault(uv,t.processId,()=>new Map).set(t.frame,t);let r=he.getWithDefault(bu,t.frame,()=>new Map),a=he.getWithDefault(r,t.processId,()=>[]),o=a.at(-1);o&&o.frame.url===t.url||a.push({frame:t,window:{min:e.ts,max:I.MicroSeconds(0),range:I.MicroSeconds(0)}})}function Zne(e){if($o!==2)throw new Error("Meta Handler is not initialized");if(Ap&&Yne.has(e.name)&&(Ap=!1),R.isProcessName(e)&&pv.set(e.pid,e),e.ts!==0&&!e.name.endsWith(":\
:UMA")&&$ne.has(e.ph)){wn.min=I.MicroSeconds(Math.min(e.ts,wn.min));let t=e.dur||I.MicroSeconds(0);wn.max=I.MicroSeconds(Math.max(e.ts+t,wn.max))}if(R.isProcessName(e)&&(e.args.name==="Browser"||e.args.name==="HeadlessBrowser")){lv=e.pid;return}if(R.isProcessName(e)&&(e.args.name==="Gpu"||e.args.name==="GPU Process")){mv=e.pid;return}if(R.isThreadName(e)&&e.args.name==="CrGpuMain"){Cp=e.tid;return}if(R.isThreadName(e)&&e.args.name==="CrBrowserMain"&&(dv=e.tid),R.isTraceEventMainFrameViewport(e)&&kp===null){let t=e.args.data.viewport_rect,n=t[0],r=t[1],a=t[2],o=t[5];kp=new DOMRect(n,r,a,o)}if(R.isTraceEventTracingStartedInBrowser(e)){if(Rp=e.ts,!e.args.data)throw new Error("No frames found in trace data");for(let t of e.args.data.frames??[])cv(e,t),t.parent||Fp.add(t.processId),"isOutermostMainFrame"in t?t.isOutermostMainFrame&&(xp=t.frame,Sp=t.url):!t.parent&&t.url&&(xp=t.frame,Sp=t.url);return}if(R.isTraceEventFrameCommittedInBrowser(e)){let t=e.args.data;if(!t||(cv(e,t),t.parent))return;
Fp.add(t.processId);return}if(R.isTraceEventCommitLoad(e)){let t=e.args.data;if(!t)return;let{frame:n,name:r,url:a}=t;cv(e,{processId:e.pid,frame:n,name:r,url:a});return}if(R.isThreadName(e)){he.getWithDefault(fv,e.pid,()=>new Map).set(e.tid,e);return}if(R.isTraceEventNavigationStartWithURL(e)&&e.args.data){let t=e.args.data.navigationId;if(wu.has(t))return;wu.set(t,e);let n=e.args.frame,r=ss.get(n)||[];r.push(e),ss.set(n,r),n===xp&&_p.push(e);return}}async function Jne(){if($o!==2)throw new Error("Handler is not initialized");Rp>=0&&(wn.min=Rp),wn.range=I.MicroSeconds(wn.max-wn.min);for(let[,n]of bu){let r=[...n.values()].flat();for(let a=0;a<r.length;a++){let o=r[a],i=r[a+1];i?(o.window.max=I.MicroSeconds(i.window.min-1),o.window.range=I.MicroSeconds(o.window.max-o.window.min)):(o.window.max=I.MicroSeconds(wn.max),o.window.range=I.MicroSeconds(wn.max-o.window.min))}}for(let[n,r]of ss)if(!bu.has(n)){ss.delete(n);for(let a of r)a.args.data&&wu.delete(a.args.data.navigationId)}let e=_p.
at(0),t=me.secondsToMicroseconds(I.Seconds(.5));if(e){let n=e.ts-wn.min<t;e.args.data?.isOutermostMainFrame&&e.args.data?.documentLoaderURL&&n&&(Sp=e.args.data.documentLoaderURL)}$o=3}function Rt(){if($o!==3)throw new Error("Meta Handler is not finalized");return{traceBounds:{...wn},browserProcessId:lv,browserThreadId:dv,processNames:pv,gpuProcessId:mv,gpuThreadId:Cp===R.ThreadID(-1)?void 0:Cp,viewportRect:kp||void 0,mainFrameId:xp,mainFrameURL:Sp,navigationsByFrameId:ss,navigationsByNavigationId:wu,threadsInProcess:fv,rendererProcessesByFrame:bu,topLevelRendererIds:Fp,frameByProcessId:uv,mainFrameNavigations:_p,traceIsGeneric:Ap}}var bu,xp,Sp,uv,lv,dv,mv,Cp,kp,pv,Fp,wn,ss,wu,_p,fv,Rp,$ne,$o,Ap,Yne,Ar=y(()=>{l();tn();Et();Ke();bu=new Map,xp="",Sp="",uv=new Map,lv=R.ProcessID(-1),dv=R.ThreadID(-1),mv=R.ProcessID(-1),Cp=R.ThreadID(-1),kp=null,pv=new Map,Fp=new Set,wn={min:I.MicroSeconds(Number.POSITIVE_INFINITY),max:I.MicroSeconds(Number.NEGATIVE_INFINITY),range:I.MicroSeconds(Number.POSITIVE_INFINITY)},
ss=new Map,wu=new Map,_p=[],fv=new Map,Rp=I.MicroSeconds(-1),$ne=new Set(["B","E","X","I"]),$o=1,Ap=!0,Yne=new Set(["TracingStartedInPage","TracingSessionIdForWorker","TracingStartedInBrowser"]);s(Kne,"reset");s(Xne,"initialize");s(cv,"updateRendererProcessByFrame");s(Zne,"handleEvent");s(Jne,"finalize");s(Rt,"data")});var Ev={};x(Ev,{data:()=>Dv,deps:()=>rre,finalize:()=>nre,handleEvent:()=>tre,initialize:()=>ere,reset:()=>Qne});function Qne(){Du=1,vv.length=0,bv.length=0,wv.clear(),gv={},yv=null,Ip.length=0,Np.length=0}function ere(){if(Du!==1)throw new Error("LayerTree Handler was not reset before being initialized");Du=2}function tre(e){(R.isTraceEventPaint(e)||R.isTraceEventDisplayListItemListSnapshot(e)||R.isTraceEventUpdateLayer(e)||R.isTraceEventSetLayerId(e))&&Np.push(e)}async function nre(){if(Du!==2)throw new Error("LayerTree Handler is not initialized");let e=Rt();Be.sortTraceEventsInPlace(Np);for(let t of Np)if(R.isTraceEventSetLayerId(t)){if(e.mainFrameId!==t.args.data.frame)continue;yv=t.args.data.layerTreeId}else if(R.isTraceEventUpdateLayer(t))Ip.push(t);else if(R.isTraceEventPaint(t)){if(!t.args.data.layerId)continue;vv.push(t),gv[t.args.data.layerId]=t;continue}else if(R.isTraceEventDisplayListItemListSnapshot(t)){let n=null;for(let a=Ip.length-1;a>-1;a--){let o=Ip[a];if(o.pid===t.
pid&&o.tid===t.tid){n=o;break}}if(!n||n.args.layerTreeId!==yv)continue;let r=gv[n.args.layerId];if(!r)continue;bv.push(t),wv.set(r,t)}Du=3}function Dv(){return{paints:vv,snapshots:bv,paintsToSnapshots:wv}}function rre(){return["Meta"]}var Du,vv,bv,wv,gv,yv,Ip,Np,Tv=y(()=>{l();Et();Ke();Ar();Du=1,vv=[],bv=[],wv=new Map,gv={},yv=null,Ip=[],Np=[];s(Qne,"reset");s(ere,"initialize");s(tre,"handleEvent");s(nre,"finalize");s(Dv,"data");s(rre,"deps")});var Mp,Pp,xv=y(()=>{l();Mp=class{static{s(this,"ProfileNode")}callFrame;callUID;self;total;id;parent;children;functionName;depth;deoptReason;constructor(t){this.callFrame=t,this.callUID=`${t.functionName}@${t.scriptId}:${t.lineNumber}:${t.columnNumber}`,this.self=0,this.total=0,this.id=0,this.functionName=t.functionName,this.parent=null,this.children=[]}get scriptId(){return String(this.callFrame.scriptId)}get url(){return this.callFrame.url}get lineNumber(){return this.callFrame.lineNumber}get columnNumber(){return this.callFrame.columnNumber}setFunctionName(t){t!==null&&(this.functionName=t)}},Pp=class{static{s(this,"ProfileTreeModel")}root;total;maxDepth;constructor(){}initialize(t){this.root=t,this.assignDepthsAndParents(),this.total=this.calculateTotals(this.root)}assignDepthsAndParents(){let t=this.root;t.depth=-1,t.parent=null,this.maxDepth=0;let n=[t];for(;n.length;){let r=n.pop(),a=r.depth+1;a>this.maxDepth&&(this.maxDepth=a);let o=r.children;for(let i of o)i.depth=a,i.parent=
r,n.push(i)}}calculateTotals(t){let n=[t],r=[];for(;n.length;){let a=n.pop();a.total=a.self,r.push(a),n.push(...a.children)}for(;r.length>1;){let a=r.pop();a.parent&&(a.parent.total+=a.total)}return t.total}}});var Lp={};x(Lp,{CPUProfileDataModel:()=>Sv,CPUProfileNode:()=>Eu});var Eu,Sv,$3=y(()=>{l();tn();xv();Eu=class extends Mp{static{s(this,"CPUProfileNode")}id;self;positionTicks;deoptReason;constructor(t,n){let r=t.callFrame||{functionName:t.functionName,scriptId:t.scriptId,url:t.url,lineNumber:t.lineNumber-1,columnNumber:t.columnNumber-1};super(r),this.id=t.id,this.self=(t.hitCount||0)*n,this.positionTicks=t.positionTicks,this.deoptReason=t.deoptReason&&t.deoptReason!=="no reason"?t.deoptReason:null}},Sv=class extends Pp{static{s(this,"CPUProfileDataModel")}profileStartTime;profileEndTime;timestamps;samples;lines;totalHitCount;profileHead;#e;gcNode;programNode;idleNode;#t;#a;constructor(t){super(),!!t.head?(this.profileStartTime=t.startTime*1e3,this.profileEndTime=t.endTime*1e3,this.timestamps=t.timestamps,this.compatibilityConversionHeadToNodes(t)):(this.profileStartTime=t.startTime/1e3,this.profileEndTime=t.endTime/1e3,this.timestamps=this.convertTimeDeltas(t)),this.samples=t.samples,this.
lines=t.lines,this.totalHitCount=0,this.profileHead=this.translateProfileTree(t.nodes),this.initialize(this.profileHead),this.extractMetaNodes(),this.samples?.length&&(this.sortSamples(),this.normalizeTimestamps(),this.fixMissingSamples())}compatibilityConversionHeadToNodes(t){if(!t.head||t.nodes)return;let n=[];r(t.head),t.nodes=n,delete t.head;function r(a){return n.push(a),a.children=a.children.map(r),a.id}s(r,"convertNodesTree")}convertTimeDeltas(t){if(!t.timeDeltas)return[];let n=t.startTime,r=new Array(t.timeDeltas.length);for(let a=0;a<t.timeDeltas.length;++a)n+=t.timeDeltas[a],r[a]=n;return r}translateProfileTree(t){function n(p){if(!p[0].children){p[0].children=[];for(let h=1;h<p.length;++h){let f=p[h],g=a.get(f.parent);g&&(g.children?g.children.push(f.id):g.children=[f.id])}}}s(n,"buildChildrenFromParents");function r(p,h){if(typeof p[0].hitCount!="number"){if(!h)throw new Error("Error: Neither hitCount nor samples are present in profile.");for(let f=0;f<p.length;++f)p[f].hitCount=
0;for(let f=0;f<h.length;++f){let g=a.get(h[f]);!g||g.hitCount===void 0||g.hitCount++}}}s(r,"buildHitCountFromSamples");let a=new Map;for(let p=0;p<t.length;++p){let h=t[p];a.set(h.id,h)}r(t,this.samples),n(t),this.totalHitCount=t.reduce((p,h)=>p+(h.hitCount||0),0);let o=(this.profileEndTime-this.profileStartTime)/this.totalHitCount,i=t[0],c=new Map([[i.id,i.id]]);this.#e=new Map;let u=new Eu(i,o);if(this.#e.set(i.id,u),!i.children)throw new Error("Missing children for root");let d=i.children.map(()=>u),m=i.children.map(p=>a.get(p));for(;m.length;){let p=d.pop(),h=m.pop();if(!h||!p)continue;h.children||(h.children=[]);let f=new Eu(h,o);p.children.push(f),p=f,c.set(h.id,p.id),d.push.apply(d,h.children.map(()=>p)),m.push.apply(m,h.children.map(g=>a.get(g))),this.#e.set(h.id,f)}return this.samples&&(this.samples=this.samples.map(p=>c.get(p))),u}sortSamples(){if(!this.timestamps||!this.samples)return;let t=this.timestamps,n=this.samples,r=t.map((a,o)=>o);r.sort((a,o)=>t[a]-t[o]),this.timestamps=
[],this.samples=[];for(let a=0;a<r.length;a++){let o=r[a];this.timestamps.push(t[o]),this.samples.push(n[o])}}normalizeTimestamps(){if(!this.samples)return;let t=this.timestamps;if(!t){let n=this.profileStartTime,r=(this.profileEndTime-n)/this.samples.length;t=new Array(this.samples.length+1);for(let a=0;a<t.length;++a)t[a]=n+a*r;this.timestamps=t;return}for(let n=0;n<t.length;++n)t[n]/=1e3;if(this.samples.length===t.length){let n=t.at(-1)||0,r=(n-t[0])/(t.length-1);this.timestamps.push(n+r)}this.profileStartTime=t.at(0)||this.profileStartTime,this.profileEndTime=t.at(-1)||this.profileEndTime}extractMetaNodes(){let t=this.profileHead.children;for(let n=0;n<t.length&&!(this.gcNode&&this.programNode&&this.idleNode);n++){let r=t[n];r.functionName==="(garbage collector)"?this.gcNode=r:r.functionName==="(program)"?this.programNode=r:r.functionName==="(idle)"&&(this.idleNode=r)}}fixMissingSamples(){let t=this.samples;if(!t)return;let n=t.length;if(!this.programNode||n<3)return;let r=this.#e,
a=this.programNode.id,o=this.gcNode?this.gcNode.id:-1,i=this.idleNode?this.idleNode.id:-1,c=t[0],u=t[1];for(let p=1;p<n-1;p++){let h=t[p+1],f=r.get(c),g=r.get(h);if(c===void 0||h===void 0||!f||!g){console.error(`Unexpectedly found undefined nodes: ${c} ${h}`);continue}u===a&&!m(c)&&!m(h)&&d(f)===d(g)&&(t[p]=c),c=u,u=h}function d(p){for(;p.parent&&p.parent.parent;)p=p.parent;return p}s(d,"bottomNode");function m(p){return p===a||p===o||p===i}s(m,"isSystemNode")}forEachFrame(t,n,r,a){if(!this.profileHead||!this.samples)return;r=r||0,a=a||1/0;let o=this.samples,i=this.timestamps,c=this.#e,u=this.gcNode,d=o.length,m=Ht.lowerBound(i,r,Ht.DEFAULT_COMPARATOR),p=0,h=[],f=this.profileHead.id,g,v=null,w=this.maxDepth+3;this.#t||(this.#t=new Array(w));let E=this.#t;this.#a||(this.#a=new Array(w));let T=this.#a,S,C;for(C=m;C<d&&(g=i[C],!(g>=a));C++){let F=o[C];if(F===f)continue;S=c.get(F);let L=c.get(f)||null;if(L){if(u&&S===u){v=L,t(v.depth+1,u,C,g),E[++p]=g,T[p]=0,f=F;continue}if(u&&L===u&&v){let M=E[p],
W=g-M;T[p-1]+=W,n(v.depth+1,u,C,M,W,W-T[p]),--p,L=v,f=L.id,v=null}for(;S&&S.depth>L.depth;)h.push(S),S=S.parent;for(;L&&L!==S;){let M=E[p],W=g-M;T[p-1]+=W,n(L.depth,L,C,M,W,W-T[p]),--p,S&&S.depth===L.depth&&(h.push(S),S=S.parent),L=L.parent}for(;h.length;){let M=h.pop();if(!M)break;S=M,t(M.depth,M,C,g),E[++p]=g,T[p]=0}f=F}}if(g=i[C]||this.profileEndTime,S&&v&&c.get(f)===u){let F=E[p],L=g-F;T[p-1]+=L,n(v.depth+1,S,C,F,L,L-T[p]),--p,f=v.id}for(let F=c.get(f);F&&F.parent;F=F.parent){let L=E[p],M=g-L;T[p-1]+=M,n(F.depth,F,C,L,M,M-T[p]),--p}}nodeByIndex(t){return this.samples&&this.#e.get(this.samples[t])||null}nodeById(t){return this.#e.get(t)||null}nodes(){return this.#e?[...this.#e.values()]:null}}});var Y3=y(()=>{l();$3();xv()});var Av={};x(Av,{data:()=>Rv,finalize:()=>dre,getProfileCallFunctionName:()=>mre,handleEvent:()=>lre,initialize:()=>ure,reset:()=>cre});function sre(){for(let[e,t]of Fv)for(let[n,r]of t){let m=function(h,f,g,v){if(a===void 0)return;let w=me.millisecondsToMicroseconds(I.MilliSeconds(v)),E=f.id,T=Be.makeProfileCall(f,n,g,w,e,a);u.profileCalls.push(T),o.push(u.profileCalls.length-1);let S=Ga.makeEmptyTraceEntryNode(T,E);Tu.set(T,S),S.depth=h,o.length===1&&u.profileTree?.roots.add(S)},p=function(h,f,g,v,w,E){let T=o.pop(),S=T!==void 0&&u.profileCalls[T];if(!S)return;let{callFrame:C,ts:F,pid:L,tid:M}=S,W=Tu.get(S);if(C===void 0||F===void 0||L===void 0||n===void 0||M===void 0||W===void 0)return;let te=me.millisecondsToMicroseconds(I.MilliSeconds(w)),K=me.millisecondsToMicroseconds(I.MilliSeconds(E));S.dur=te,S.selfTime=K;let oe=o.at(-1),ye=oe!==void 0&&u.profileCalls.at(oe),se=ye&&Tu.get(ye);se&&(W.parent=se,se.children.push(W))};s(m,"openFrameCallback"),s(p,"closeFrameCallback");let a=r.threadId;
if(!r.rawProfile.nodes.length||a===void 0)continue;let o=[],i=new Lp.CPUProfileDataModel(r.rawProfile),c=Ga.makeEmptyTraceEntryTree();c.maxDepth=i.maxDepth;let u={rawProfile:r.rawProfile,parsedProfile:i,profileCalls:[],profileTree:c,profileId:n},d=he.getWithDefault(kv,e,()=>new Map);i.forEachFrame(m,p),d.set(a,u)}}function cre(){ire.clear(),Fv.clear(),kv.clear(),Tu.clear(),Yo=1}function ure(){if(Yo!==1)throw new Error("Samples Handler was not reset");Yo=2}function lre(e){if(Yo!==2)throw new Error("Samples Handler is not initialized");if(R.isSyntheticCpuProfile(e)){let t=e.pid,n=e.tid,a=Cv(t,"0x1");a.rawProfile=e.args.data.cpuProfile,a.threadId=n;return}if(R.isTraceEventProfile(e)){let t=Cv(e.pid,e.id);t.rawProfile.startTime=e.ts,t.threadId=e.tid;return}if(R.isTraceEventProfileChunk(e)){let n=Cv(e.pid,e.id).rawProfile,r=e.args?.data?.cpuProfile||{samples:[]},a=r?.samples||[],o=[];for(let u of r?.nodes||[]){let d=typeof u.callFrame.lineNumber>"u"?-1:u.callFrame.lineNumber,m=typeof u.callFrame.
columnNumber>"u"?-1:u.callFrame.columnNumber,p=String(u.callFrame.scriptId),h=u.callFrame.url||"",f={...u,callFrame:{...u.callFrame,url:h,lineNumber:d,columnNumber:m,scriptId:p}};o.push(f)}let i=e.args.data?.timeDeltas||[],c=e.args.data?.lines||Array(a.length).fill(0);if(n.nodes.push(...o),n.samples?.push(...a),n.timeDeltas?.push(...i),n.lines?.push(...c),n.samples&&n.timeDeltas&&n.samples.length!==n.timeDeltas.length){console.error("Failed to parse CPU profile.");return}if(!n.endTime&&n.timeDeltas){let u=n.timeDeltas;n.endTime=u.reduce((d,m)=>d+m,n.startTime)}return}}async function dre(){if(Yo!==2)throw new Error("Samples Handler is not initialized");sre(),Yo=3}function Rv(){if(Yo!==3)throw new Error("Samples Handler is not finalized");return{profilesInProcess:kv,entryToNode:Tu}}function Cv(e,t){let n=he.getWithDefault(Fv,e,()=>new Map);return he.getWithDefault(n,t,()=>({rawProfile:{startTime:0,endTime:0,nodes:[],samples:[],timeDeltas:[],lines:[]},profileId:t}))}function mre(e,t){let r=e.
profilesInProcess.get(t.pid)?.get(t.tid)?.parsedProfile.nodeById(t.nodeId);return r?.functionName?r.functionName:t.callFrame.functionName}var ire,kv,Tu,Fv,Yo,_v=y(()=>{l();tn();Y3();Et();Ke();ire=new Map,kv=new Map,Tu=new Map,Fv=new Map,Yo=1;s(sre,"buildProfileCalls");s(cre,"reset");s(ure,"initialize");s(lre,"handleEvent");s(dre,"finalize");s(Rv,"data");s(Cv,"getOrCreatePreProcessedData");s(mre,"getProfileCallFunctionName")});var Ov={};x(Ov,{assignIsMainFrame:()=>J3,assignMeta:()=>X3,assignOrigin:()=>Z3,assignThreadName:()=>Q3,buildHierarchy:()=>nP,data:()=>Lv,deps:()=>Dre,finalize:()=>bre,handleEvent:()=>vre,handleUserConfig:()=>hre,initialize:()=>yre,makeCompleteEvent:()=>rP,reset:()=>gre,sanitizeProcesses:()=>eP,sanitizeThreads:()=>tP});function hre(e){K3=e}function gre(){Va.clear(),Pv.clear(),la.length=0,Iv.length=0,Mv.length=0,Ko=1}function yre(){if(Ko!==1)throw new Error("Renderer Handler was not reset");Ko=2}function vre(e){if(Ko!==2)throw new Error("Renderer Handler is not initialized");if(R.isThreadName(e)&&e.args.name?.startsWith("CompositorTileWorker")&&Mv.push({pid:e.pid,tid:e.tid}),R.isTraceEventBegin(e)||R.isTraceEventEnd(e)){let t=Op(Va,e.pid),n=Nv(t,e.tid),r=rP(e);if(!r)return;n.entries.push(r),la.push(r);return}if(R.isTraceEventInstant(e)||R.isTraceEventComplete(e)){let t=Op(Va,e.pid);Nv(t,e.tid).entries.push(e),la.push(e)}}async function bre(){if(Ko!==2)throw new Error("Renderer Handler is\
 not initialized");let{mainFrameId:e,rendererProcessesByFrame:t,threadsInProcess:n}=Rt();X3(Va,e,t,n),eP(Va),nP(Va),tP(Va),Be.sortTraceEventsInPlace(la),Ko=3}function Lv(){if(Ko!==3)throw new Error("Renderer Handler is not finalized");return{processes:new Map(Va),compositorTileWorkers:new Map(wre()),entryToNode:new Map(Pv),allTraceEntries:[...la]}}function wre(){let e=new Map;for(let t of Mv){let n=e.get(t.pid)||[];n.push(t.tid),e.set(t.pid,n)}return e}function X3(e,t,n,r){Z3(e,n),J3(e,t,n),Q3(e,n,r)}function Z3(e,t){for(let n of t.values())for(let[r,a]of n)for(let o of a.flat()){let i=Op(e,r);if(i.url===null||i.url==="about:blank")try{new URL(o.frame.url),i.url=o.frame.url}catch{i.url=null}}}function J3(e,t,n){for(let[r,a]of n)for(let[o]of a){let i=Op(e,o);r===t&&(i.isOnMainFrame=!0)}}function Q3(e,t,n){for(let[r,a]of e)for(let[o,i]of n.get(r)??[]){let c=Nv(a,o);c.name=i?.args.name??`${o}`}}function eP(e){let t=yu().worklets;if(!Rt().traceIsGeneric){for(let[r,a]of e)if(a.url===null){let o=t.
get(r);o?a.url=o.host:e.delete(r);continue}}}function tP(e){for(let[,t]of e)for(let[n,r]of t.threads)r.tree?.roots.size||t.threads.delete(n)}function nP(e,t){let n=Rv();for(let[r,a]of e)for(let[o,i]of a.threads){if(!i.entries.length){i.tree=Ga.makeEmptyTraceEntryTree();continue}Be.sortTraceEventsInPlace(i.entries);let c=n.profilesInProcess.get(r)?.get(o);if(c){let d=c.parsedProfile,m=d&&new gu.SamplesIntegrator(d,c.profileId,r,o,K3),p=m?.buildProfileCalls(i.entries);if(m&&p){la=[...la,...p],i.entries=Be.mergeEventsInOrder(i.entries,p);let h=m.jsSampleEvents;h&&(la=[...la,...h],i.entries=Be.mergeEventsInOrder(i.entries,h))}}let u=Ga.treify(i.entries,t);i.tree=u.tree;for(let[d,m]of u.entryToNode)Pv.set(d,m)}}function rP(e){if(R.isTraceEventEnd(e)){let n=Iv.pop();return n?n.name!==e.name||n.cat!==e.cat?(console.error("Begin/End events mismatch at "+n.ts+" ("+n.name+") vs. "+e.ts+" ("+e.name+")"),null):(n.dur=I.MicroSeconds(e.ts-n.ts),null):null}let t={...e,ph:"X",dur:I.MicroSeconds(0)};return Iv.
push(t),t}function Dre(){return["Meta","Samples","AuctionWorklets"]}var Va,Mv,Pv,la,Iv,Ko,K3,pre,fre,Op,Nv,Bv=y(()=>{l();tn();Et();Ke();wp();Ar();_v();Va=new Map,Mv=Array(),Pv=new Map,la=[],Iv=[],Ko=1,K3=Rr.defaults(),pre=s(()=>({url:null,isOnMainFrame:!1,threads:new Map}),"makeRendererProcess"),fre=s(()=>({name:null,entries:[]}),"makeRendererThread"),Op=s((e,t)=>he.getWithDefault(e,t,pre),"getOrCreateRendererProcess"),Nv=s((e,t)=>he.getWithDefault(e.threads,t,fre),"getOrCreateRendererThread");s(hre,"handleUserConfig");s(gre,"reset");s(yre,"initialize");s(vre,"handleEvent");s(bre,"finalize");s(Lv,"data");s(wre,"gatherCompositorThreads");s(X3,"assignMeta");s(Z3,"assignOrigin");s(J3,"assignIsMainFrame");s(Q3,"assignThreadName");s(eP,"sanitizeProcesses");s(tP,"sanitizeThreads");s(nP,"buildHierarchy");s(rP,"makeCompleteEvent");s(Dre,"deps")});var Up={};x(Up,{threadsInRenderer:()=>Bp,threadsInTrace:()=>Tre});function Ere(e,t,n){let r="OTHER";return t.name==="CrRendererMain"?r="MAIN_THREAD":t.name==="DedicatedWorker thread"?r="WORKER":t.name?.startsWith("CompositorTileWorker")?r="RASTERIZER":n.worklets.has(e)?r="AUCTION_WORKLET":t.name?.startsWith("ThreadPool")&&(r="THREAD_POOL"),r}function Bp(e,t){let n=[];if(e.processes.size)for(let[r,a]of e.processes)for(let[o,i]of a.threads){if(!i.tree)continue;let c=Ere(r,i,t);n.push({name:i.name,pid:r,tid:o,processIsOnMainFrame:a.isOnMainFrame,entries:i.entries,tree:i.tree,type:c,entryToNode:e.entryToNode})}return n}function Tre(e){let t=Bp(e.Renderer,e.AuctionWorklets);if(t.length)return t;let n=[];if(e.Samples.profilesInProcess.size)for(let[r,a]of e.Samples.profilesInProcess)for(let[o,i]of a)i.profileTree&&n.push({pid:r,tid:o,name:null,entries:i.profileCalls,processIsOnMainFrame:!1,tree:i.profileTree,type:"CPU_PROFILE",entryToNode:e.Samples.entryToNode});return n}var Uv=y(()=>{l();s(Ere,
"getThreadTypeForRendererThread");s(Bp,"threadsInRenderer");s(Tre,"threadsInTrace")});var qv={};x(qv,{LayerPaintEvent:()=>Wp,PendingFrame:()=>Gp,TimelineFrame:()=>Hp,TimelineFrameBeginFrameQueue:()=>Vp,TimelineFrameModel:()=>zp,data:()=>Fre,deps:()=>Rre,finalize:()=>kre,framesWithinWindow:()=>Nre,handleEvent:()=>Cre,initialize:()=>Sre,reset:()=>xre});function xre(){jp=1,qp.length=0}function Sre(){if(jp!==1)throw new Error("FramesHandler was not reset before being initialized");jp=2}function Cre(e){qp.push(e)}async function kre(){if(jp!==2)throw new Error("FramesHandler is not initialized");Be.sortTraceEventsInPlace(qp),xu=new zp(qp,Lv(),yu(),Rt(),Dv())}function Fre(){return{frames:xu?Array.from(xu.frames()):[],framesById:xu?{...xu.framesById()}:{}}}function Rre(){return["Meta","Renderer","AuctionWorklets","LayerTree"]}function Are(e){return R.isTraceEventSetLayerId(e)||R.isTraceEventBeginFrame(e)||R.isTraceEventDroppedFrame(e)||R.isTraceEventRequestMainThreadFrame(e)||R.isTraceEventBeginMainThreadFrame(e)||R.isTraceEventNeedsBeginFrameChanged(e)||R.isTraceEventCommit(e)||
R.isTraceEventCompositeLayers(e)||R.isTraceEventActivateLayerTree(e)||R.isTraceEventDrawFrame(e)}function _re(e){return e.name==="RunTask"&&e.cat.includes("disabled-by-default-devtools.timeline")}function Nre(e,t,n){let r=Ht.lowerBound(e,t||0,(o,i)=>o-i.endTime),a=Ht.lowerBound(e,n||1/0,(o,i)=>o-i.startTime);return e.slice(r,a)}var jp,qp,xu,zp,Ire,Hp,Wp,Gp,jv,Vp,aP=y(()=>{l();tn();Et();Ke();wp();Tv();Ar();Bv();Uv();jp=1,qp=[],xu=null;s(xre,"reset");s(Sre,"initialize");s(Cre,"handleEvent");s(kre,"finalize");s(Fre,"data");s(Rre,"deps");s(Are,"isFrameEvent");s(_re,"entryIsTopLevel");zp=class{static{s(this,"TimelineFrameModel")}#e=[];#t={};#a=new Vp;#n=null;#r=!1;#i=!1;#o=null;#s=null;#c=null;#f=null;#u=null;#h=null;#d=null;#m=null;#l=null;#p;constructor(t,n,r,a,o){let c=Bp(n,r).filter(u=>u.type==="MAIN_THREAD"&&u.processIsOnMainFrame).map(u=>({tid:u.tid,pid:u.pid,startTime:u.entries[0].ts}));this.#p=o,this.#k(t,c,a.mainFrameId)}framesById(){return this.#t}frames(){return this.#e}#y(t,n){this.#n||
this.#g(t,n),this.#f=t,this.#a.addFrameIfNotExists(n,t,!1,!1)}#b(t,n,r){this.#n||this.#g(t,n),this.#a.addFrameIfNotExists(n,t,!0,r),this.#a.setDropped(n,!0),this.#a.setPartial(n,r)}#w(t,n){if(!this.#n){this.#g(t,n);return}if(this.#r||!this.#i){this.#u&&((this.#s?this.#s.triggerTime:this.#f||this.#u)>this.#n.startTime&&(this.#n.idle=!0,this.#f=null),this.#u=null);let r=this.#a.processPendingBeginFramesOnDrawFrame(n);for(let a of r){let o=this.#n.idle;this.#g(a.startTime,n),o&&this.#s&&this.#v(),a.isDropped&&(this.#n.dropped=!0),a.isPartial&&(this.#n.isPartial=!0)}}this.#r=!1}#D(){this.#n&&this.#s&&!this.#u&&this.#v()}#E(){this.#n&&(this.#i=!0)}#T(){this.#c&&(this.#s=this.#c,this.#c=null,this.#i=!1,this.#r=!0)}#x(t){this.#o=t}#S(t,n){n&&(this.#u=t)}#g(t,n){this.#n&&this.#C(this.#n,t),this.#n=new Hp(n,t,I.MicroSeconds(t-Rt().traceBounds.min))}#C(t,n){t.setLayerTree(this.#o),t.setEndTime(n),this.#o&&(this.#o.paints=t.paints);let r=this.#e[this.#e.length-1];this.#e.length&&r&&(t.startTime!==
r.endTime||t.startTime>t.endTime)&&console.assert(!1,`Inconsistent frame time for frame ${this.#e.length} (${t.startTime} - ${t.endTime})`),this.#e.push(t),typeof t.mainFrameId=="number"&&(this.#t[t.mainFrameId]=t)}#v(){!this.#s||!this.#n||(this.#n.paints=this.#s.paints,this.#n.mainFrameId=this.#s.mainFrameId,this.#s=null)}#k(t,n,r){let a=0;this.#l=n.length&&n[0].tid||null,this.#m=n.length&&n[0].pid||null;for(let o=0;o<t.length;++o){for(;a+1<n.length&&n[a+1].startTime<=t[o].ts;)this.#l=n[++a].tid,this.#m=n[a].pid;this.#F(t[o],r)}this.#l=null,this.#m=null}#F(t,n){R.isTraceEventSetLayerId(t)&&t.args.data.frame===n?this.#d=t.args.data.layerTreeId:R.isTraceEventLayerTreeHostImplSnapshot(t)&&Number(t.id)===this.#d?this.#x({entry:t,paints:[]}):(Are(t)&&this.#R(t),t.tid===this.#l&&t.pid===this.#m&&this.#A(t))}#R(t){t.args.layerTreeId===this.#d&&(R.isTraceEventBeginFrame(t)?this.#y(t.ts,t.args.frameSeqId):R.isTraceEventDrawFrame(t)?this.#w(t.ts,t.args.frameSeqId):R.isTraceEventActivateLayerTree(
t)?this.#D():R.isTraceEventRequestMainThreadFrame(t)?this.#E():R.isTraceEventNeedsBeginFrameChanged(t)?this.#S(t.ts,t.args.data&&!!t.args.data.needsBeginFrame):R.isTraceEventDroppedFrame(t)&&this.#b(t.ts,t.args.frameSeqId,!!t.args.hasPartialUpdate))}#A(t){if(_re(t)&&(this.#h=t.ts),!this.#c&&Ire.has(t.name)&&(this.#c=new Gp(this.#h||t.ts)),!!this.#c){if(R.isTraceEventBeginMainThreadFrame(t)&&t.args.data.frameId&&(this.#c.mainFrameId=t.args.data.frameId),R.isTraceEventPaint(t)){let n=this.#p.paintsToSnapshots.get(t);n&&this.#c.paints.push(new Wp(t,n))}(R.isTraceEventCompositeLayers(t)||R.isTraceEventCommit(t))&&t.args.layerTreeId===this.#d&&this.#T()}}},Ire=new Set(["ScheduleStyleRecalculation","InvalidateLayout","BeginMainThreadFrame","ScrollLayer"]),Hp=class{static{s(this,"TimelineFrame")}startTime;startTimeOffset;endTime;duration;idle;dropped;isPartial;layerTree;paints;mainFrameId;seqId;constructor(t,n,r){this.seqId=t,this.startTime=n,this.startTimeOffset=r,this.endTime=this.startTime,
this.duration=I.MicroSeconds(0),this.idle=!1,this.dropped=!1,this.isPartial=!1,this.layerTree=null,this.paints=[],this.mainFrameId=void 0}setEndTime(t){this.endTime=t,this.duration=I.MicroSeconds(this.endTime-this.startTime)}setLayerTree(t){this.layerTree=t}},Wp=class{static{s(this,"LayerPaintEvent")}#e;#t;constructor(t,n){this.#e=t,this.#t=n}layerId(){return this.#e.args.data.layerId}event(){return this.#e}picture(){let t=this.#t.args.snapshot.params?.layer_rect,n=this.#t.args.snapshot.skp64;return t&&n?{rect:t,serializedPicture:n}:null}},Gp=class{static{s(this,"PendingFrame")}paints;mainFrameId;triggerTime;constructor(t){this.paints=[],this.mainFrameId=void 0,this.triggerTime=t}},jv=class{static{s(this,"BeginFrameInfo")}seqId;startTime;isDropped;isPartial;constructor(t,n,r,a){this.seqId=t,this.startTime=n,this.isDropped=r,this.isPartial=a}},Vp=class{static{s(this,"TimelineFrameBeginFrameQueue")}queueFrames=[];mapFrames={};addFrameIfNotExists(t,n,r,a){t in this.mapFrames||(this.mapFrames[t]=
new jv(t,n,r,a),this.queueFrames.push(t))}setDropped(t,n){t in this.mapFrames&&(this.mapFrames[t].isDropped=n)}setPartial(t,n){t in this.mapFrames&&(this.mapFrames[t].isPartial=n)}processPendingBeginFramesOnDrawFrame(t){let n=[];if(t in this.mapFrames){for(;this.queueFrames[0]!==t;){let r=this.queueFrames[0];this.mapFrames[r].isDropped&&n.push(this.mapFrames[r]),delete this.mapFrames[r],this.queueFrames.shift()}n.push(this.mapFrames[t]),delete this.mapFrames[t],this.queueFrames.shift()}return n}};s(Nre,"framesWithinWindow")});var Wv={};x(Wv,{data:()=>Bre,deps:()=>Ure,finalize:()=>Ore,handleEvent:()=>Lre,initialize:()=>Pre,reset:()=>Mre});function Mre(){zv.clear(),Hv=[],Xo=1}function Pre(){if(Xo!==1)throw new Error("GPU Handler was not reset before being initialized");Xo=2}function Lre(e){if(Xo!==2)throw new Error("GPU Handler is not initialized");R.isTraceEventGPUTask(e)&&Be.addEventToProcessThread(e,zv)}async function Ore(){if(Xo!==2)throw new Error("GPU Handler is not initialized");let{gpuProcessId:e,gpuThreadId:t}=Rt(),n=zv.get(e);n&&t&&(Hv=n.get(t)||[]),Xo=3}function Bre(){if(Xo!==3)throw new Error("GPU Handler is not finalized");return{mainGPUThreadTasks:Hv}}function Ure(){return["Meta"]}var Xo,zv,Hv,oP=y(()=>{l();Ar();Ke();Et();Xo=1,zv=new Map,Hv=[];s(Mre,"reset");s(Pre,"initialize");s(Lre,"handleEvent");s(Ore,"finalize");s(Bre,"data");s(Ure,"deps")});var Gv={};x(Gv,{data:()=>zre,handleEvent:()=>qre,reset:()=>jre});function jre(){Su.clear(),$p.clear(),Yp.clear(),Kp.clear()}function qre(e){if(R.isTraceEventPaintImage(e)){let t=Su.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),Su.set(e.pid,t);return}if(R.isTraceEventDecodeLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=$p.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),$p.set(e.pid,t)}if(R.isTraceEventDrawLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=Su.get(e.pid)?.get(e.tid)?.at(-1);if(!t)return;Yp.set(e.args.LazyPixelRef,t);return}if(R.isTraceEventDecodeImage(e)){let t=Su.get(e.pid)?.get(e.tid)?.at(-1);if(t){Kp.set(e,t);return}let n=$p.get(e.pid)?.get(e.tid)?.at(-1);if(!n||typeof n.args?.LazyPixelRef>"u")return;let r=Yp.get(n.args.LazyPixelRef);if(!r)return;Kp.set(e,r)}}function zre(){return{paintImageByDrawLazyPixelRef:Yp,paintImageForEvent:Kp}}var Su,$p,Yp,Kp,iP=y(()=>{l();Ke();Su=new Map,$p=new Map,Yp=new Map,Kp=new Map;s(jre,"re\
set");s(qre,"handleEvent");s(zre,"data")});var Qv={};x(Qv,{data:()=>Yre,finalize:()=>$re,handleEvent:()=>Gre,initialize:()=>Wre,reset:()=>Hre});function Hre(){Vv.clear(),Cu.clear(),$v.clear(),Kv.clear(),Jp.clear(),Zp.clear(),Yv.clear(),Xv.clear(),Xp.clear(),Jv.clear(),Zv.length=0,ku=1}function Wre(){if(ku!==1)throw new Error("InitiatorsHandler was not reset before being initialized");ku=2}function $a(e){Jp.set(e.event,e.initiator);let t=Zp.get(e.initiator)||[];t.push(e.event),Zp.set(e.initiator,t)}function Gre(e){if(R.isTraceEventScheduleStyleRecalculation(e))Vv.set(e.args.data.frame,e);else if(R.isTraceEventUpdateLayoutTree(e)){if(e.args.beginData){$v.set(e.args.beginData.frame,e);let t=Vv.get(e.args.beginData.frame);t&&$a({event:e,initiator:t})}}else if(R.isTraceEventInvalidateLayout(e)){let t=e;if(!Cu.has(e.args.data.frame)){let n=$v.get(e.args.data.frame);if(n){let{endTime:r}=me.eventTimingsMicroSeconds(n),a=Jp.get(n);a&&r&&r>e.ts&&(t=a)}}Cu.set(e.args.data.frame,t)}else if(R.isTraceEventLayout(e)){let t=Cu.get(e.args.beginData.
frame);t&&$a({event:e,initiator:t}),Cu.delete(e.args.beginData.frame)}else if(R.isTraceEventRequestAnimationFrame(e))Yv.set(e.args.data.id,e);else if(R.isTraceEventFireAnimationFrame(e)){let t=Yv.get(e.args.data.id);t&&$a({event:e,initiator:t})}else if(R.isTraceEventTimerInstall(e))Kv.set(e.args.data.timerId,e);else if(R.isTraceEventTimerFire(e)){let t=Kv.get(e.args.data.timerId);t&&$a({event:e,initiator:t})}else if(R.isTraceEventRequestIdleCallback(e))Xv.set(e.args.data.id,e);else if(R.isTraceEventFireIdleCallback(e)){let t=Xv.get(e.args.data.id);t&&$a({event:e,initiator:t})}else if(R.isTraceEventWebSocketCreate(e))Xp.set(e.args.data.identifier,e);else if(R.isTraceEventWebSocketSendHandshakeRequest(e)){let t=Xp.get(e.args.data.identifier);t&&$a({event:e,initiator:t})}else if(R.isTraceEventWebSocketSendHandshakeRequest(e)||R.isTraceEventWebSocketReceiveHandshakeResponse(e)||R.isTraceEventWebSocketDestroy(e)){let t=Xp.get(e.args.data.identifier);t&&$a({event:e,initiator:t})}else if(R.isTraceEventHandlePostMessage(
e))Zv.push(e);else if(R.isTraceEventSchedulePostMessage(e)){let t=e.args.data?.traceId;t&&Jv.set(t,e)}}function Vre(){for(let e of Zv){let t=e.args.data?.traceId,n=Jv.get(t);n&&$a({event:e,initiator:n})}}async function $re(){if(ku!==2)throw new Error("InitiatorsHandler is not initialized");Vre(),ku=3}function Yre(){return{eventToInitiator:Jp,initiatorToEvents:Zp}}var ku,Vv,Cu,$v,Zv,Jv,Jp,Zp,Yv,Kv,Xv,Xp,sP=y(()=>{l();Et();Ke();ku=1,Vv=new Map,Cu=new Map,$v=new Map,Zv=[],Jv=new Map,Jp=new Map,Zp=new Map,Yv=new Map,Kv=new Map,Xv=new Map,Xp=new Map;s(Hre,"reset");s(Wre,"initialize");s($a,"storeInitiator");s(Gre,"handleEvent");s(Vre,"finalizeInitiatorRelationship");s($re,"finalize");s(Yre,"data")});var tb={};x(tb,{data:()=>Qre,finalize:()=>Jre,handleEvent:()=>Zre,initialize:()=>Xre,reset:()=>Kre});function Kre(){Ru=1,ef.clear(),_r=null,Fu.length=0,Qp=!1}function Xre(){if(Ru!==1)throw new Error("InvalidationsHandler was not reset before being initialized");Ru=2}function eb(e,t){let n=ef.get(e)||[],r={...t,name:"SyntheticInvalidation",frame:t.args.data.frame,nodeId:t.args.data.nodeId,rawEvent:t};t.args.data.nodeName&&(r.nodeName=t.args.data.nodeName),t.args.data.reason&&(r.reason=t.args.data.reason),t.args.data.stackTrace&&(r.stackTrace=t.args.data.stackTrace),n.push(r),ef.set(e,n)}function Zre(e){if(R.isTraceEventUpdateLayoutTree(e)){_r=e;for(let t of Fu){if(R.isTraceEventLayoutInvalidationTracking(t))continue;let n=_r.args.beginData?.frame;n&&t.args.data.frame===n&&eb(e,t)}return}if(R.isTraceEventScheduleStyleInvalidationTracking(e)||R.isTraceEventStyleRecalcInvalidationTracking(e)||R.isTraceEventStyleInvalidatorInvalidationTracking(e)||R.isTraceEventLayoutInvalidationTracking(e)){
if(Qp&&(Fu.length=0,_r=null,Qp=!1),_r&&(R.isTraceEventScheduleStyleInvalidationTracking(e)||R.isTraceEventStyleRecalcInvalidationTracking(e)||R.isTraceEventStyleInvalidatorInvalidationTracking(e))){let t=_r.ts+(_r.dur||0);e.ts>=_r.ts&&e.ts<=t&&_r.args.beginData?.frame===e.args.data.frame&&eb(_r,e)}Fu.push(e);return}if(R.isTraceEventPaint(e)){Qp=!0;return}if(R.isTraceEventLayout(e)){let t=e.args.beginData.frame;for(let n of Fu)R.isTraceEventLayoutInvalidationTracking(n)&&n.args.data.frame===t&&eb(e,n)}}async function Jre(){if(Ru!==2)throw new Error("InvalidationsHandler is not initialized");Ru=3}function Qre(){return{invalidationsForEvent:ef}}var Ru,ef,_r,Qp,Fu,cP=y(()=>{l();Ke();Ru=1,ef=new Map,_r=null,Qp=!1,Fu=[];s(Kre,"reset");s(Xre,"initialize");s(eb,"addInvalidationToEvent");s(Zre,"handleEvent");s(Jre,"finalize");s(Qre,"data")});var rb={};x(rb,{data:()=>nae,handleEvent:()=>tae,reset:()=>eae});function eae(){nb.clear()}function tae(e){R.isTraceEventLargestImagePaintCandidate(e)&&e.args.data&&nb.set(e.args.data.DOMNodeId,e)}function nae(){return nb}var nb,uP=y(()=>{l();Ke();nb=new Map;s(eae,"reset");s(tae,"handleEvent");s(nae,"data")});var ob={};x(ob,{data:()=>oae,handleEvent:()=>aae,reset:()=>rae});function rae(){ab.clear()}function aae(e){R.isTraceEventLargestTextPaintCandidate(e)&&e.args.data&&ab.set(e.args.data.DOMNodeId,e)}function oae(){return ab}var ab,lP=y(()=>{l();Ke();ab=new Map;s(rae,"reset");s(aae,"handleEvent");s(oae,"data")});var sb={};x(sb,{MAX_CLUSTER_DURATION:()=>nf,MAX_SHIFT_TIME_DELTA:()=>rf,data:()=>pae,deps:()=>fae,finalize:()=>dae,handleEvent:()=>cae,initialize:()=>iae,reset:()=>sae,stateForLayoutShiftScore:()=>hae});function iae(){if(ls!==1)throw new Error("LayoutShifts Handler was not reset");ls=2}function sae(){ls=1,Ya.length=0,Au.length=0,of.length=0,dP.length=0,sf.length=0,cs.clear(),Fn.length=0,af=0,us.length=0,ib=-1}function cae(e){if(ls!==2)throw new Error("Handler is not initialized");if(R.isTraceEventLayoutShift(e)&&!e.args.data?.had_recent_input){Ya.push(e);return}if(R.isTraceEventLayoutInvalidationTracking(e)){Au.push(e);return}if(R.isTraceEventScheduleStyleInvalidationTracking(e)&&of.push(e),R.isTraceEventStyleRecalcInvalidationTracking(e)&&dP.push(e),R.isTraceEventPrePaint(e)){sf.push(e);return}}function tf(e){return{min:e,max:e,range:I.MicroSeconds(0)}}function Hn(e,t){e.max=t,e.range=I.MicroSeconds(e.max-e.min)}function uae(){let{traceBounds:e}=Rt();us.push({ts:e.min,score:0});for(let t of Fn){
let n=0;t.events[0].args.data&&us.push({ts:t.clusterWindow.min,score:t.events[0].args.data.weighted_score_delta});for(let r=0;r<t.events.length;r++){let a=t.events[r];a.args.data&&(n+=a.args.data.weighted_score_delta,us.push({ts:a.ts,score:n}))}us.push({ts:t.clusterWindow.max,score:0})}}function lae(){cs.clear();for(let e of Ya)if(e.args.data?.impacted_nodes)for(let t of e.args.data.impacted_nodes)cs.add(t.node_id);for(let e of Au)e.args.data?.nodeId&&cs.add(e.args.data.nodeId);for(let e of of)e.args.data?.nodeId&&cs.add(e.args.data.nodeId)}async function dae(){Ya.sort((e,t)=>e.ts-t.ts),sf.sort((e,t)=>e.ts-t.ts),Au.sort((e,t)=>e.ts-t.ts),await mae(),uae(),lae(),ls=3}async function mae(){let{navigationsByFrameId:e,mainFrameId:t,traceBounds:n}=Rt(),r=e.get(t)||[];if(Ya.length===0)return;let a=Ya[0].ts,o=Ya[0].ts,i=null;for(let c of Ya){let u=c.ts-a>nf,d=c.ts-o>rf,m=Ht.nearestIndexFromEnd(r,v=>v.ts<c.ts),p=i!==m&&m!==null;if(u||d||p||!Fn.length){let v=c.ts,w=u?a+nf:1/0,E=d?o+rf:1/0,T=p?r[m].
ts:1/0,S=Math.min(w,E,T);if(Fn.length>0){let C=Fn[Fn.length-1];Hn(C.clusterWindow,I.MicroSeconds(S))}Fn.push({events:[],clusterWindow:tf(v),clusterCumulativeScore:0,scoreWindows:{good:tf(v),needsImprovement:null,bad:null}}),a=v}let h=Fn[Fn.length-1],f=m!==null?I.MicroSeconds(c.ts-r[m].ts):void 0;if(h.clusterCumulativeScore+=c.args.data?c.args.data.weighted_score_delta:0,!c.args.data)continue;let g={rawSourceEvent:c,...c,args:{frame:c.args.frame,data:{...c.args.data,rawEvent:c}},parsedData:{timeFromNavigation:f,cumulativeWeightedScoreInWindow:h.clusterCumulativeScore,sessionWindowData:{cumulativeWindowScore:0,id:Fn.length}}};h.events.push(g),Hn(h.clusterWindow,c.ts),o=c.ts,i=m}for(let c of Fn){let u=0,d=-1;if(c===Fn[Fn.length-1]){let m=nf+c.clusterWindow.min,p=c.clusterWindow.max+rf,h=Ht.nearestIndexFromBeginning(r,v=>v.ts>c.clusterWindow.max),f=h?r[h].ts:1/0,g=Math.min(m,p,n.max,f);Hn(c.clusterWindow,I.MicroSeconds(g))}for(let m of c.events){u+=m.args.data?m.args.data.weighted_score_delta:
0,d=m.parsedData.sessionWindowData.id;let p=m.ts;m.parsedData.sessionWindowData.cumulativeWindowScore=c.clusterCumulativeScore,u<.1?Hn(c.scoreWindows.good,p):u>=.1&&u<.25?(c.scoreWindows.needsImprovement||(Hn(c.scoreWindows.good,I.MicroSeconds(p-1)),c.scoreWindows.needsImprovement=tf(p)),Hn(c.scoreWindows.needsImprovement,p)):u>=.25&&(c.scoreWindows.bad||(c.scoreWindows.needsImprovement?Hn(c.scoreWindows.needsImprovement,I.MicroSeconds(p-1)):Hn(c.scoreWindows.good,I.MicroSeconds(p-1)),c.scoreWindows.bad=tf(m.ts)),Hn(c.scoreWindows.bad,p)),c.scoreWindows.bad?Hn(c.scoreWindows.bad,c.clusterWindow.max):c.scoreWindows.needsImprovement?Hn(c.scoreWindows.needsImprovement,c.clusterWindow.max):Hn(c.scoreWindows.good,c.clusterWindow.max)}u>af&&(ib=d,af=u)}}function pae(){if(ls!==3)throw new Error("Layout Shifts Handler is not finalized");return{clusters:Fn,sessionMaxScore:af,clsWindowID:ib,prePaintEvents:sf,layoutInvalidationEvents:Au,scheduleStyleInvalidationEvents:of,styleRecalcInvalidationEvents:[],
scoreRecords:us,backendNodeIds:[...cs]}}function fae(){return["Screenshots","Meta"]}function hae(e){let t="good";return e>=.1&&(t="ok"),e>=.25&&(t="bad"),t}var nf,rf,Ya,Au,of,dP,cs,sf,af,ib,Fn,us,ls,mP=y(()=>{l();tn();Et();Ke();Ar();nf=me.millisecondsToMicroseconds(I.MilliSeconds(5e3)),rf=me.millisecondsToMicroseconds(I.MilliSeconds(1e3)),Ya=[],Au=[],of=[],dP=[],cs=new Set,sf=[],af=0,ib=-1,Fn=[],us=[],ls=1;s(iae,"initialize");s(sae,"reset");s(cae,"handleEvent");s(tf,"traceWindowFromTime");s(Hn,"updateTraceWindowMax");s(uae,"buildScoreRecords");s(lae,"collectNodes");s(dae,"finalize");s(mae,"buildLayoutShiftsClusters");s(pae,"data");s(fae,"deps");s(hae,"stateForLayoutShiftScore")});var cb={};x(cb,{data:()=>vae,handleEvent:()=>yae,reset:()=>gae});function gae(){cf.clear()}function yae(e){if(R.isTraceEventUpdateCounters(e)){let t=he.getWithDefault(cf,e.pid,()=>[]);t.push(e),cf.set(e.pid,t)}}function vae(){return{updateCountersByProcess:cf}}var cf,pP=y(()=>{l();tn();Ke();cf=new Map;s(gae,"reset");s(yae,"handleEvent");s(vae,"data")});var db={};x(db,{data:()=>xae,deps:()=>Sae,finalize:()=>Tae,handleEvent:()=>Eae,initialize:()=>Dae,reset:()=>wae});function Zo(e,t,n){_u.has(e)||_u.set(e,{});let r=_u.get(e);if(!r)throw new Error(`Unable to locate trace events for request ID ${e}`);if(Array.isArray(r[t])){let a=r[t],o=n;a.push(...o)}else r[t]=n}function bae(e){for(let t of e)if(t>0)return t;return 0}function wae(){ub.clear(),_u.clear(),lb.length=0,ds=1}function Dae(){ds=2}function Eae(e){if(ds!==2)throw new Error("Network Request handler is not initialized");if(R.isTraceEventResourceChangePriority(e)){Zo(e.args.data.requestId,"changePriority",e);return}if(R.isTraceEventResourceWillSendRequest(e)){Zo(e.args.data.requestId,"willSendRequests",[e]);return}if(R.isTraceEventResourceSendRequest(e)){Zo(e.args.data.requestId,"sendRequests",[e]);return}if(R.isTraceEventResourceReceiveResponse(e)){Zo(e.args.data.requestId,"receiveResponse",e);return}if(R.isTraceEventResourceReceivedData(e)){Zo(e.args.data.requestId,"receivedData",
[e]);return}if(R.isTraceEventResourceFinish(e)){Zo(e.args.data.requestId,"resourceFinish",e);return}if(R.isTraceEventResourceMarkAsCached(e)){Zo(e.args.data.requestId,"resourceMarkAsCached",e);return}}async function Tae(){if(ds!==2)throw new Error("Network Request handler is not initialized");let{rendererProcessesByFrame:e}=Rt();for(let[t,n]of _u.entries()){if(!n.sendRequests||!n.receiveResponse)continue;let r=[];for(let ze=0;ze<n.sendRequests.length-1;ze++){let Je=n.sendRequests[ze],He=n.sendRequests[ze+1],Me=Je.ts,Ce=I.MicroSeconds(He.ts-Je.ts);if(n.willSendRequests&&n.willSendRequests[ze]&&n.willSendRequests[ze+1]){let ee=n.willSendRequests[ze],Z=n.willSendRequests[ze+1];Me=ee.ts,Ce=I.MicroSeconds(Z.ts-ee.ts)}r.push({url:Je.args.data.url,priority:Je.args.data.priority,requestMethod:Je.args.data.requestMethod,ts:Me,dur:Ce})}let a=n.resourceFinish?.args.data.encodedDataLength!==0,o=n.receiveResponse.args.data.fromCache&&!n.receiveResponse.args.data.fromServiceWorker&&!a,i=n.resourceMarkAsCached!==
void 0,c=i||o,u=n.receiveResponse.args.data.timing;if(!u&&!c)continue;let d=n.sendRequests[0],m=n.sendRequests[n.sendRequests.length-1],p=m.args.data.priority,h=p;n.changePriority&&(h=n.changePriority.args.data.priority);let f=n.willSendRequests&&n.willSendRequests.length?I.MicroSeconds(n.willSendRequests[0].ts):I.MicroSeconds(d.ts),g=n.willSendRequests&&n.willSendRequests.length?I.MicroSeconds(n.willSendRequests[n.willSendRequests.length-1].ts):I.MicroSeconds(m.ts),v=n.resourceFinish?n.resourceFinish.ts:g,w=n.resourceFinish?.args.data.finishTime?I.MicroSeconds(n.resourceFinish.args.data.finishTime*uf):I.MicroSeconds(v),E=c?I.MicroSeconds(0):I.MicroSeconds((w||g)-g),T=I.MicroSeconds(v-(w||v)),S=I.MicroSeconds(g-f),C=c?I.MicroSeconds(0):I.MicroSeconds(hp.clamp(u.requestTime*uf-g,0,Number.MAX_VALUE)),F=c?I.MicroSeconds(n.receiveResponse.ts-f):I.MicroSeconds(bae([u.dnsStart*ur,u.connectStart*ur,u.sendStart*ur,n.receiveResponse.ts-g])),L=c?f:I.MicroSeconds(u.requestTime*uf+u.sendStart*ur),
M=c?I.MicroSeconds(0):I.MicroSeconds((u.receiveHeadersEnd-u.sendEnd)*ur),W=c?f:I.MicroSeconds(u.requestTime*uf+u.receiveHeadersEnd*ur),te=c?I.MicroSeconds(v-n.receiveResponse.ts):I.MicroSeconds((w||W)-W),K=I.MicroSeconds(E+T),oe=c?I.MicroSeconds(0):I.MicroSeconds((u.dnsEnd-u.dnsStart)*ur),ye=c?I.MicroSeconds(0):I.MicroSeconds((u.sslEnd-u.sslStart)*ur),se=c?I.MicroSeconds(0):I.MicroSeconds((u.proxyEnd-u.proxyStart)*ur),ht=c?I.MicroSeconds(0):I.MicroSeconds((u.sendEnd-u.sendStart)*ur),le=c?I.MicroSeconds(0):I.MicroSeconds((u.connectEnd-u.connectStart)*ur),{frame:ve,url:ut,renderBlocking:et}=m.args.data,{encodedDataLength:Ne,decodedBodyLength:_t}=n.resourceFinish?n.resourceFinish.args.data:{encodedDataLength:0,decodedBodyLength:0},Xe=new URL(ut),qe=Xe.protocol==="https:",Se=Be.activeURLForFrameAtTime(ve,m.ts,e)||"",U={rawSourceEvent:m,args:{data:{syntheticData:{dnsLookup:oe,download:te,downloadStart:W,finishTime:w,initialConnection:le,isDiskCached:o,isHttps:qe,isMemoryCached:i,isPushedResource:a,
networkDuration:E,processingDuration:T,proxyNegotiation:se,queueing:C,redirectionDuration:S,requestSent:ht,sendStartTime:L,ssl:ye,stalled:F,totalTime:K,waiting:M},decodedBodyLength:_t,encodedDataLength:Ne,frame:ve,fromServiceWorker:n.receiveResponse.args.data.fromServiceWorker,isLinkPreload:n.receiveResponse.args.data.isLinkPreload||!1,mimeType:n.receiveResponse.args.data.mimeType,priority:h,initialPriority:p,protocol:n.receiveResponse.args.data.protocol??"unknown",redirects:r,renderBlocking:et||"non_blocking",requestId:t,requestingFrameUrl:Se,requestMethod:m.args.data.requestMethod,resourceType:m.args.data.resourceType,statusCode:n.receiveResponse.args.data.statusCode,responseHeaders:n.receiveResponse.args.data.headers||[],fetchPriorityHint:m.args.data.fetchPriorityHint,initiator:m.args.data.initiator,stackTrace:m.args.data.stackTrace,timing:u,url:ut,failed:n.resourceFinish?.args.data.didFail??!1,finished:!!n.resourceFinish,connectionId:n.receiveResponse.args.data.connectionId,connectionReused:n.
receiveResponse.args.data.connectionReused}},cat:"loading",name:"SyntheticNetworkRequest",ph:"X",dur:I.MicroSeconds(v-f),tdur:I.MicroSeconds(v-f),ts:I.MicroSeconds(f),tts:I.MicroSeconds(f),pid:m.pid,tid:m.tid},ce=he.getWithDefault(ub,Xe.host,()=>({renderBlocking:[],nonRenderBlocking:[],all:[]}));U.args.data.renderBlocking==="non_blocking"?ce.nonRenderBlocking.push(U):ce.renderBlocking.push(U),ce.all.push(U),lb.push(U)}ds=3}function xae(){if(ds!==3)throw new Error("Network Request handler is not finalized");return{byOrigin:ub,byTime:lb}}function Sae(){return["Meta"]}var ur,uf,_u,ub,lb,ds,fP=y(()=>{l();tn();Et();Ke();Ar();ur=1e3,uf=1e6,_u=new Map,ub=new Map,lb=[];s(Zo,"storeTraceEventWithRequestId");s(bae,"firstPositiveValueInList");ds=1;s(wae,"reset");s(Dae,"initialize");s(Eae,"handleEvent");s(Tae,"finalize");s(xae,"data");s(Sae,"deps")});var mb={};x(mb,{data:()=>Fae,handleEvent:()=>kae,reset:()=>Cae});function Cae(){Iu.clear()}function kae(e){if(R.isTraceEventTracingStartedInBrowser(e)){for(let t of e.args.data?.frames??[])Iu.set(t.frame,t);return}if(R.isTraceEventCommitLoad(e)){let t=e.args.data;if(!t)return;let n=Iu.get(t.frame);if(!n)return;Iu.set(t.frame,{...n,url:t.url||n.url,name:t.name||t.name})}}function Fae(){return{frames:Iu}}var Iu,hP=y(()=>{l();Ke();Iu=new Map;s(Cae,"reset");s(kae,"handleEvent");s(Fae,"data")});var fb={};x(fb,{data:()=>Pae,deps:()=>Lae,finalize:()=>Mae,getFrameIdForPageLoadEvent:()=>df,handleEvent:()=>Aae,reset:()=>Rae,scoreClassificationForDOMContentLoaded:()=>bP,scoreClassificationForFirstContentfulPaint:()=>gP,scoreClassificationForLargestContentfulPaint:()=>vP,scoreClassificationForTimeToInteractive:()=>yP,scoreClassificationForTotalBlockingTime:()=>wP});function Rae(){Mu.clear(),Nu=[],pb=[],lf.clear()}function Aae(e){R.eventIsPageLoadEvent(e)&&Nu.push(e)}function _ae(e,t){let n=e.args.data?.navigationId;if(!n)throw new Error("Navigation event unexpectedly had no navigation ID.");let r=df(t),{rendererProcessesByFrame:a}=Rt(),o=a.get(r);if(!(!o||!o.get(t.pid))&&!R.isTraceEventNavigationStart(t)){if(R.isTraceEventFirstContentfulPaint(t)){let c=I.MicroSeconds(t.ts-e.ts),u=me.formatMicrosecondsTime(c,{format:2,maximumFractionDigits:2}),d=gP(c);Ka(r,n,{event:t,score:u,metricName:"FCP",classification:d,navigation:e,timing:c});return}if(R.isTraceEventFirstPaint(t)){let c=I.MicroSeconds(
t.ts-e.ts),u=me.formatMicrosecondsTime(c,{format:2,maximumFractionDigits:2});Ka(r,n,{event:t,score:u,metricName:"FP",classification:"unclassified",navigation:e,timing:c});return}if(R.isTraceEventMarkDOMContent(t)){let c=I.MicroSeconds(t.ts-e.ts),u=me.formatMicrosecondsTime(c,{format:2,maximumFractionDigits:2}),d={event:t,score:u,metricName:"DCL",classification:bP(c),navigation:e,timing:c};Ka(r,n,d);return}if(R.isTraceEventInteractiveTime(t)){let c=I.MicroSeconds(t.ts-e.ts),u=me.formatMicrosecondsTime(c,{format:2,maximumFractionDigits:2}),d={event:t,score:u,metricName:"TTI",classification:yP(c),navigation:e,timing:c};Ka(r,n,d);let m=me.millisecondsToMicroseconds(I.MilliSeconds(t.args.args.total_blocking_time_ms)),p=me.formatMicrosecondsTime(m,{format:1,maximumFractionDigits:2}),h={event:t,score:p,metricName:"TBT",classification:wP(m),navigation:e,timing:m};Ka(r,n,h);return}if(R.isTraceEventMarkLoad(t)){let c=I.MicroSeconds(t.ts-e.ts),u=me.formatMicrosecondsTime(c,{format:2,maximumFractionDigits:2});
Ka(r,n,{event:t,score:u,metricName:"L",classification:"unclassified",navigation:e,timing:c});return}if(R.isTraceEventLargestContentfulPaintCandidate(t)){let c=t.args.data?.candidateIndex;if(!c)throw new Error("Largest Contentful Paint unexpectedly had no candidateIndex.");let u=I.MicroSeconds(t.ts-e.ts),d=me.formatMicrosecondsTime(u,{format:2,maximumFractionDigits:2}),m={event:t,score:d,metricName:"LCP",classification:vP(u),navigation:e,timing:u},p=he.getWithDefault(Mu,r,()=>new Map),f=he.getWithDefault(p,n,()=>new Map).get("LCP");if(f===void 0){lf.add(m.event),Ka(r,n,m);return}let g=f.event;if(!R.isTraceEventLargestContentfulPaintCandidate(g))return;let v=g.args.data?.candidateIndex;if(!v)return;v<c&&(lf.delete(g),lf.add(m.event),Ka(r,n,m));return}if(!R.isTraceEventLayoutShift(t))return is(t,`Unexpected event type: ${t}`)}}function Ka(e,t,n){let r=he.getWithDefault(Mu,e,()=>new Map),a=he.getWithDefault(r,t,()=>new Map);a.delete(n.metricName),a.set(n.metricName,n)}function df(e){if(R.isTraceEventFirstContentfulPaint(
e)||R.isTraceEventInteractiveTime(e)||R.isTraceEventLargestContentfulPaintCandidate(e)||R.isTraceEventNavigationStart(e)||R.isTraceEventLayoutShift(e)||R.isTraceEventFirstPaint(e))return e.args.frame;if(R.isTraceEventMarkDOMContent(e)||R.isTraceEventMarkLoad(e)){let t=e.args.data?.frame;if(!t)throw new Error("MarkDOMContent unexpectedly had no frame ID.");return t}is(e,`Unexpected event type: ${e}`)}function Iae(e){if(R.isTraceEventFirstContentfulPaint(e)||R.isTraceEventLargestContentfulPaintCandidate(e)||R.isTraceEventFirstPaint(e)){let t=e.args.data?.navigationId;if(!t)throw new Error("Trace event unexpectedly had no navigation ID.");let{navigationsByNavigationId:n}=Rt(),r=n.get(t);return r||null}if(R.isTraceEventMarkDOMContent(e)||R.isTraceEventInteractiveTime(e)||R.isTraceEventLayoutShift(e)||R.isTraceEventMarkLoad(e)){let t=df(e),{navigationsByFrameId:n}=Rt();return Be.getNavigationForTraceEvent(e,t,n)}return R.isTraceEventNavigationStart(e)?null:is(e,`Unexpected event type: ${e}`)}
function gP(e){let t=me.secondsToMicroseconds(I.Seconds(1.8)),n=me.secondsToMicroseconds(I.Seconds(3)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function yP(e){let t=me.secondsToMicroseconds(I.Seconds(3.8)),n=me.secondsToMicroseconds(I.Seconds(7.3)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function vP(e){let t=me.secondsToMicroseconds(I.Seconds(2.5)),n=me.secondsToMicroseconds(I.Seconds(4)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function bP(e){return"unclassified"}function wP(e){let t=me.millisecondsToMicroseconds(I.MilliSeconds(200)),n=me.millisecondsToMicroseconds(I.MilliSeconds(600)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function Nae(){let e=[],n=[...Mu.values()].flatMap(r=>[...r.values()]);for(let r=0;r<n.length;r++){let o=n[r].get("LCP");!o||!o.event||e.push(o.event)}return e}async function Mae(){Nu.sort((a,o)=>a.ts-o.ts);for(let a of Nu){let o=Iae(a);o&&_ae(o,a)}let e=Nae(),t=Rt().mainFrameId,n=Nu.filter(a=>!R.isTraceEventLargestContentfulPaintCandidate(
a));pb=[...e,...n].filter(R.isTraceEventMarkerEvent).filter(a=>df(a)===t).sort((a,o)=>a.ts-o.ts)}function Pae(){return{metricScoresByFrameId:Mu,allMarkerEvents:pb}}function Lae(){return["Meta"]}var Mu,pb,Nu,lf,DP=y(()=>{l();tn();Et();Ke();Ar();Mu=new Map,pb=[];s(Rae,"reset");Nu=[],lf=new Set;s(Aae,"handleEvent");s(_ae,"storePageLoadMetricAgainstNavigationId");s(Ka,"storeMetricScore");s(df,"getFrameIdForPageLoadEvent");s(Iae,"getNavigationForPageLoadEvent");s(gP,"scoreClassificationForFirstContentfulPaint");s(yP,"scoreClassificationForTimeToInteractive");s(vP,"scoreClassificationForLargestContentfulPaint");s(bP,"scoreClassificationForDOMContentLoaded");s(wP,"scoreClassificationForTotalBlockingTime");s(Nae,"gatherFinalLCPEvents");s(Mae,"finalize");s(Pae,"data");s(Lae,"deps")});var bb={};x(bb,{data:()=>qae,deps:()=>zae,finalize:()=>Uae,handleEvent:()=>Bae,reset:()=>Oae});function Oae(){hb.length=0,gb.length=0,yb.length=0,vb={}}function Bae(e){R.isTraceEventScreenshot(e)?gb.push(e):R.isTraceEventPipelineReporter(e)&&hb.push(e)}async function Uae(){let e=Be.createMatchedSortedSyntheticEvents(hb);vb=Object.fromEntries(e.map(t=>{let n=t.args.data.beginEvent.args.chrome_frame_reporter.frame_sequence,r=I.MicroSeconds(t.ts+t.dur);return[n,r]}));for(let t of gb){let{cat:n,name:r,ph:a,pid:o,tid:i}=t,c={rawSourceEvent:t,cat:n,name:r,ph:a,pid:o,tid:i,ts:jae(t),args:{dataUri:`data:image/jpg;base64,${t.args.snapshot}`}};yb.push(c)}}function jae(e){let t=parseInt(e.id,16);return t===1?e.ts:vb[t]??e.ts}function qae(){return yb}function zae(){return["Meta"]}var hb,gb,yb,vb,EP=y(()=>{l();Et();Ke();hb=[],gb=[],yb=[],vb={};s(Oae,"reset");s(Bae,"handleEvent");s(Uae,"finalize");s(jae,"getPresentationTimestamp");s(qae,"data");s(zae,"deps")});var Db={};x(Db,{data:()=>Gae,handleEvent:()=>Wae,reset:()=>Hae});function Hae(){mf=null,wb.clear()}function Wae(e){if(R.isTraceEventSelectorStats(e)&&mf&&e.args.selector_stats){wb.set(mf,{timings:e.args.selector_stats.selector_timings});return}if(R.isTraceEventUpdateLayoutTree(e)){mf=e;return}}function Gae(){return{dataForUpdateLayoutEvent:wb}}var mf,wb,TP=y(()=>{l();Ke();mf=null,wb=new Map;s(Hae,"reset");s(Wae,"handleEvent");s(Gae,"data")});var Rb={};x(Rb,{LONG_INTERACTION_THRESHOLD:()=>xP,categoryOfInteraction:()=>SP,data:()=>Fb,deps:()=>Zae,finalize:()=>Xae,handleEvent:()=>$ae,removeNestedInteractions:()=>CP,reset:()=>Vae});function Vae(){Tb.length=0,xb.length=0,Lu.length=0,Cb.length=0,Sb.clear(),pf.length=0,Pu=null,kb=2}function $ae(e){if(kb!==2)throw new Error("Handler is not initialized");if(R.isTraceEventBeginCommitCompositorFrame(e)){xb.push(e);return}if(!R.isTraceEventEventTiming(e)||(R.isTraceEventEventTimingEnd(e)&&Sb.set(e.id,e),Tb.push(e),!e.args.data||!R.isTraceEventEventTimingStart(e)))return;let{duration:t,interactionId:n}=e.args.data;t<1||n===void 0||n===0||Cb.push(e)}function SP(e){return Yae.has(e.type)?"POINTER":Kae.has(e.type)?"KEYBOARD":"OTHER"}function CP(e){let t={POINTER:new Map,KEYBOARD:new Map,OTHER:new Map};function n(a){let o=SP(a),i=t[o],c=I.MicroSeconds(a.ts+a.dur),u=i.get(c);if(!u){i.set(c,a);return}if(a.ts<u.ts)i.set(c,a);else if(a.ts===u.ts&&a.interactionId===u.interactionId){let d=u.processingEnd-
u.processingStart;a.processingEnd-a.processingStart>d&&i.set(c,a)}a.processingStart<u.processingStart&&(u.processingStart=a.processingStart,Eb(u)),a.processingEnd>u.processingEnd&&(u.processingEnd=a.processingEnd,Eb(u))}s(n,"storeEventIfEarliestForCategoryAndEndTime");for(let a of e)n(a);let r=Object.values(t).flatMap(a=>Array.from(a.values()));return r.sort((a,o)=>a.ts-o.ts),r}function Eb(e){let t=e.args.data.beginEvent,n=e.args.data.endEvent;e.inputDelay=I.MicroSeconds(e.processingStart-t.ts),e.mainThreadHandling=I.MicroSeconds(e.processingEnd-e.processingStart),e.presentationDelay=I.MicroSeconds(n.ts-e.processingEnd)}async function Xae(){let{navigationsByFrameId:e}=Rt();for(let t of Cb){let n=Sb.get(t.id);if(!n||!t.args.data?.type||!t.args.data?.interactionId)continue;let r=I.MicroSeconds(me.millisecondsToMicroseconds(t.args.data.processingStart)-me.millisecondsToMicroseconds(t.args.data.timeStamp)+t.ts),a=I.MicroSeconds(me.millisecondsToMicroseconds(t.args.data.processingEnd)-me.millisecondsToMicroseconds(
t.args.data.timeStamp)+t.ts),o=t.args.frame??t.args.data.frame,c=Be.getNavigationForTraceEvent(t,o,e)?.args.data?.navigationId,u={rawSourceEvent:t,cat:t.cat,name:t.name,pid:t.pid,tid:t.tid,ph:t.ph,processingStart:r,processingEnd:a,inputDelay:I.MicroSeconds(-1),mainThreadHandling:I.MicroSeconds(-1),presentationDelay:I.MicroSeconds(-1),args:{data:{beginEvent:t,endEvent:n,frame:o,navigationId:c}},ts:t.ts,dur:I.MicroSeconds(n.ts-t.ts),type:t.args.data.type,interactionId:t.args.data.interactionId};Eb(u),Lu.push(u)}kb=3,pf.push(...CP(Lu));for(let t of pf)(!Pu||Pu.dur<t.dur)&&(Pu=t)}function Fb(){return{allEvents:Tb,beginCommitCompositorFrameEvents:xb,interactionEvents:Lu,interactionEventsWithNoNesting:pf,longestInteractionEvent:Pu,interactionsOverThreshold:new Set(Lu.filter(e=>e.dur>xP))}}function Zae(){return["Meta"]}var Tb,xb,xP,Pu,Lu,pf,Sb,Cb,kb,Yae,Kae,Ab=y(()=>{l();Et();Ke();Ar();Tb=[],xb=[],xP=me.millisecondsToMicroseconds(I.MilliSeconds(200)),Pu=null,Lu=[],pf=[],Sb=new Map,Cb=[],kb=1;
s(Vae,"reset");s($ae,"handleEvent");Yae=new Set(["pointerdown","touchstart","pointerup","touchend","mousedown","mouseup","click"]),Kae=new Set(["keydown","keypress","keyup"]);s(SP,"categoryOfInteraction");s(CP,"removeNestedInteractions");s(Eb,"writeSyntheticTimespans");s(Xae,"finalize");s(Fb,"data");s(Zae,"deps")});var Nb={};x(Nb,{FORCED_REFLOW_THRESHOLD:()=>FP,LONG_MAIN_THREAD_TASK_THRESHOLD:()=>RP,data:()=>roe,deps:()=>toe,finalize:()=>noe,handleEvent:()=>Qae,reset:()=>Jae});function Jae(){ff.clear(),hf.clear(),_b.length=0,Ib.length=0,Ou.length=0}function gf(e,t){let n=he.getWithDefault(ff,e,()=>[]);n.push(t),ff.set(e,n);let r=he.getWithDefault(hf,t,()=>[]);r.push(e),hf.set(t,r)}function Qae(e){if(eoe(e),e.name==="RunTask"){let{duration:t}=me.eventTimingsMicroSeconds(e);t>RP&&gf(e,"LONG_TASK");return}if(R.isTraceEventFireIdleCallback(e)){let{duration:t}=me.eventTimingsMilliSeconds(e);t>e.args.data.allottedMilliseconds&&gf(e,"IDLE_CALLBACK_OVER_TIME");return}}function eoe(e){if(kP(e,_b),kP(e,Ib,R.isJSInvocationEvent(e)),Ib.length&&(e.name==="Layout"||e.name==="UpdateLayoutTree")){Ou.push(e);return}_b.length===1&&(Ou.reduce((n,r)=>n+(r.dur||0),0)>=FP&&Ou.forEach(n=>gf(n,"FORCED_REFLOW")),Ou.length=0)}function kP(e,t,n=!0){let r=t.at(-1);for(;r&&e.ts>r.ts+(r.dur||0);)t.pop(),r=t.at(-1);n&&t.push(e)}
function toe(){return["UserInteractions"]}async function noe(){let e=Fb().interactionsOverThreshold;for(let t of e)gf(t,"LONG_INTERACTION")}function roe(){return{perEvent:ff,perWarning:hf}}var ff,hf,_b,Ib,Ou,FP,RP,AP=y(()=>{l();tn();Et();Ke();Ab();ff=new Map,hf=new Map,_b=[],Ib=[],Ou=[],FP=me.millisecondsToMicroseconds(I.MilliSeconds(30)),RP=me.millisecondsToMicroseconds(I.MilliSeconds(50));s(Jae,"reset");s(gf,"storeWarning");s(Qae,"handleEvent");s(eoe,"processForcedReflowWarning");s(kP,"accomodateEventInStack");s(toe,"deps");s(noe,"finalize");s(roe,"data")});var Lb={};x(Lb,{data:()=>coe,finalize:()=>soe,handleEvent:()=>ioe,initialize:()=>aoe,reset:()=>ooe});function aoe(){if(Jo!==1)throw new Error("Workers Handler was not reset");Jo=2}function ooe(){yf.length=0,Mb.clear(),Pb.clear(),Jo=1}function ioe(e){if(Jo!==2)throw new Error("Workers Handler is not initialized");R.isTraceEventTracingSessionIdForWorker(e)&&yf.push(e)}async function soe(){if(Jo!==2)throw new Error("Handler is not initialized");for(let e of yf)e.args.data&&(Mb.set(e.args.data.workerThreadId,e.args.data.workerId),Pb.set(e.args.data.workerId,e.args.data.url));Jo=3}function coe(){if(Jo!==3)throw new Error("Workers Handler is not finalized");return{workerSessionIdEvents:yf,workerIdByThread:Mb,workerURLById:Pb}}var Jo,yf,Mb,Pb,_P=y(()=>{l();Ke();Jo=1,yf=[],Mb=new Map,Pb=new Map;s(aoe,"initialize");s(ooe,"reset");s(ioe,"handleEvent");s(soe,"finalize");s(coe,"data")});var Ir={};x(Ir,{Animations:()=>Gy,AuctionWorklets:()=>Zy,ExtensionTraceData:()=>sv,Frames:()=>qv,GPU:()=>Wv,ImagePainting:()=>Gv,Initiators:()=>Qv,Invalidations:()=>tb,LargestImagePaint:()=>rb,LargestTextPaint:()=>ob,LayerTree:()=>Ev,LayoutShifts:()=>sb,Memory:()=>cb,Meta:()=>hv,NetworkRequests:()=>db,PageFrames:()=>mb,PageLoadMetrics:()=>fb,Renderer:()=>Ov,Samples:()=>Av,Screenshots:()=>bb,SelectorStats:()=>Db,UserInteractions:()=>Rb,UserTimings:()=>nv,Warnings:()=>Nb,Workers:()=>Lb});var Ob=y(()=>{l();z3();wp();V3();aP();oP();iP();sP();cP();uP();lP();Tv();mP();pP();Ar();fP();hP();DP();Bv();_v();EP();TP();Ab();rv();AP();_P()});var Bb={};x(Bb,{handlerDataHasAllHandlers:()=>uoe});function uoe(e){let t=!1;for(let n of Object.keys(Ir))if(!(n in e)){t=!0;break}return!t}var IP=y(()=>{l();Ob();s(uoe,"handlerDataHasAllHandlers")});var ms={};x(ms,{ModelHandlers:()=>Ir,Threads:()=>Up,Types:()=>Bb});var ps=y(()=>{l();Ob();Uv();IP()});var Ub={};x(Ub,{deps:()=>loe,generateInsight:()=>poe});function loe(){return["Meta","Animations"]}function moe(e){let t=[];for(let n of e){let r=n.args.data.beginEvent,a=n.args.data.instantEvents||[];for(let o of a){let i=o.args.data.compositeFailed,c=o.args.data.unsupportedProperties;if(!i||!c)continue;let u=doe.filter(m=>i&m.flag).map(m=>m.failure),d={name:r.args.data.displayName,failureReasons:u,unsupportedProperties:c};t.push(d)}}return t}function poe(e,t){let n=e.Animations.animations.filter(a=>Be.getNavigationForTraceEvent(a,t.frameId,e.Meta.navigationsByFrameId)?.args.data?.navigationId===t.navigationId);return{animationFailures:moe(n)}}var doe,NP=y(()=>{l();Et();s(loe,"deps");doe=[{flag:8192,failure:"UNSUPPORTED_CSS_PROPERTY"},{flag:2048,failure:"TRANSFROM_BOX_SIZE_DEPENDENT"},{flag:4096,failure:"FILTER_MAY_MOVE_PIXELS"},{flag:16,failure:"NON_REPLACE_COMPOSITE_MODE"},{flag:64,failure:"INCOMPATIBLE_ANIMATIONS"},{flag:8,failure:"UNSUPPORTED_TIMING_PARAMS"}];s(moe,"getNonComposite\
dAnimations");s(poe,"generateInsight")});var jb={};x(jb,{deps:()=>foe,generateInsight:()=>hoe});function foe(){return["UserInteractions"]}function hoe(e,t){let n=e.UserInteractions.interactionEvents.filter(i=>i.args.data.navigationId===t.navigationId);if(!n.length)return{};let r=new Map;for(let i of n){let c=i.interactionId,u=r.get(c);(!u||i.dur>u.dur)&&r.set(c,i)}let a=[...r.values()];a.sort((i,c)=>c.dur-i.dur);let o=Math.min(9,Math.floor(a.length/50));return{longestInteractionEvent:a[0],highPercentileInteractionEvent:a[o]}}var MP=y(()=>{l();s(foe,"deps");s(hoe,"generateInsight")});var da,Bu=y(()=>{l();(function(e){e.NO_FP="NO_FP",e.NO_LCP="NO_LCP",e.NO_DOCUMENT_REQUEST="NO_DOCUMENT_REQUEST",e.NO_LAYOUT="NO_LAYOUT"})(da||(da={}))});var qb={};x(qb,{deps:()=>yoe,generateInsight:()=>boe});function yoe(){return["NetworkRequests","PageLoadMetrics","LargestImagePaint","Meta"]}function PP(e,t,n,r){let a=t.args.data.timing;if(!a)throw new Error("no timing for main resource");let o=me.secondsToMicroseconds(a.requestTime)+me.millisecondsToMicroseconds(a.receiveHeadersStart),i=I.MicroSeconds(o-e.ts),c=me.microSecondsToMilliseconds(i),u=I.MilliSeconds(n-c);if(!r)return{ttfb:c,renderDelay:u};let d=I.MicroSeconds(r.ts-e.ts),m=me.microSecondsToMilliseconds(d),p=I.MicroSeconds(r.args.data.syntheticData.finishTime-e.ts),h=me.microSecondsToMilliseconds(p),f=I.MilliSeconds(m-c),g=I.MilliSeconds(h-m);return u=I.MilliSeconds(n-h),{ttfb:c,loadDelay:f,loadTime:g,renderDelay:u}}function voe(e,t,n){let r=n.args.data?.nodeId;if(!r)throw new Error("no lcp node id");let a=e.LargestImagePaint.get(r);if(!a)return null;let o=a.args.data?.imageUrl;if(!o)throw new Error("no lcp url");let i=e.NetworkRequests.byTime.find(c=>Be.getNavigationForTraceEvent(
c,t.frameId,e.Meta.navigationsByFrameId)?.args.data?.navigationId===t.navigationId&&c.args.data.url===o);if(!i)throw new Error("no lcp resource found");return i}function boe(e,t){let n=e.NetworkRequests,r=e.Meta.navigationsByNavigationId.get(t.navigationId);if(!r)throw new Error("no trace navigation");let a=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!a)throw new Error("no frame metrics");let o=a.get(t.navigationId);if(!o)throw new Error("no navigation metrics");let i=o.get("LCP"),c=i?.event;if(!c||!R.isTraceEventLargestContentfulPaintCandidate(c))return{warnings:[da.NO_LCP]};let u=i.timing,d=me.microSecondsToMilliseconds(u),m=voe(e,t,c),p=n.byTime.find(v=>v.args.data.requestId===t.navigationId);if(!p)return{lcpMs:d,warnings:[da.NO_DOCUMENT_REQUEST]};if(!m)return{lcpMs:d,phases:PP(r,p,d,m)};let h=c.args.data?.loadingAttr,f=m?.args.data.isLinkPreload||m?.args.data.initiator?.type==="preload",g=m?.args.data.fetchPriorityHint;return{lcpMs:d,phases:PP(r,p,d,m),shouldRemoveLazyLoading:h===
"lazy",shouldIncreasePriorityHint:g!=="high",shouldPreloadImage:!f}}var LP=y(()=>{l();ps();Et();Ke();Bu();s(yoe,"deps");s(PP,"breakdownPhases");s(voe,"findLCPRequest");s(boe,"generateInsight")});var zb={};x(zb,{deps:()=>woe,generateInsight:()=>Doe});function woe(){return["NetworkRequests","PageLoadMetrics"]}function Doe(e,t){let n=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId)?.get(t.navigationId)?.get("FP")?.event?.ts;if(!n)return{renderBlockingRequests:[],warnings:[da.NO_FP]};let r=[];for(let a of e.NetworkRequests.byTime){if(a.args.data.frame!==t.frameId||a.args.data.renderBlocking!=="blocking"&&a.args.data.renderBlocking!=="in_body_parser_blocking"||a.args.data.syntheticData.finishTime>n)continue;if(a.args.data.renderBlocking==="in_body_parser_blocking"){let i=a.args.data.priority,u=a.args.data.resourceType==="Script"&&i==="High";if(i!=="VeryHigh"&&!u)continue}Be.getNavigationForTraceEvent(a,t.frameId,e.Meta.navigationsByFrameId)?.args.data?.navigationId===t.navigationId&&r.push(a)}return{renderBlockingRequests:r}}var OP=y(()=>{l();ps();Et();Bu();s(woe,"deps");s(Doe,"generateInsight")});var Hb={};x(Hb,{deps:()=>Eoe,generateInsight:()=>Toe});function Eoe(){return["Meta","UserInteractions"]}function Toe(e,t){let n=e.UserInteractions.beginCommitCompositorFrameEvents.filter(r=>!(r.args.frame!==t.frameId||Be.getNavigationForTraceEvent(r,t.frameId,e.Meta.navigationsByFrameId)?.args.data?.navigationId!==t.navigationId));if(!n.length)return{mobileOptimized:null,warnings:[da.NO_LAYOUT]};for(let r of n)if(!r.args.is_mobile_optimized)return{mobileOptimized:!1};return{mobileOptimized:!0}}var BP=y(()=>{l();Et();Bu();s(Eoe,"deps");s(Toe,"generateInsight")});var vf={};x(vf,{CumulativeLayoutShift:()=>Ub,InteractionToNextPaint:()=>jb,LargestContentfulPaint:()=>qb,RenderBlocking:()=>zb,Viewport:()=>Hb});var UP=y(()=>{l();NP();MP();LP();OP();BP()});var Wb=y(()=>{l();UP();Bu()});var wf={};x(wf,{TraceParseProgressEvent:()=>Uu,TraceProcessor:()=>bf,sortHandlers:()=>qP});function qP(e){let t=new Map,n=new Set,r=s(a=>{if(t.has(a))return;if(n.has(a)){let c="";for(let u of n)(c||u===a)&&(c+=`${u}->`);throw c+=a,new Error(`Found dependency cycle in trace event handlers: ${c}`)}n.add(a);let o=e[a];if(!o)return;let i=o.deps?.();i&&i.forEach(r),t.set(a,o)},"visitHandler");for(let a of Object.keys(e))r(a);return t}var Uu,bf,Gb=y(()=>{l();ps();Wb();Ke();Uu=class e extends Event{static{s(this,"TraceParseProgressEvent")}data;static eventName="traceparseprogress";constructor(t,n={bubbles:!0}){super(e.eventName,n),this.data=t}},bf=class e extends EventTarget{static{s(this,"TraceProcessor")}#e;#t="IDLE";#a=Rr.defaults();#n=null;#r=null;static createWithAllHandlers(){return new e(Ir,Rr.defaults())}constructor(t,n){super(),this.#o(t),this.#e={Meta:Ir.Meta,...t},n&&(this.#a=n),this.#i()}#i(){for(let t of Object.values(this.#e))"handleUserConfig"in t&&t.handleUserConfig&&t.handleUserConfig(
this.#a)}#o(t){if(Object.keys(t).length===Object.keys(Ir).length)return;let n=new Set;for(let[a,o]of Object.entries(t)){n.add(a);for(let i of o.deps?.()||[])n.add(i)}let r=new Set(Object.keys(t));n.delete("Meta");for(let a of n)if(!r.has(a))throw new Error(`Required handler ${a} not provided.`)}reset(){if(this.#t==="PARSING")throw new Error("Trace processor can't reset while parsing.");let t=Object.values(this.#e);for(let n of t)n.reset();this.#n=null,this.#r=null,this.#t="IDLE"}async parse(t,n=!1){if(this.#t!=="IDLE")throw new Error(`Trace processor can't start parsing when not idle. Current state: ${this.#t}`);try{this.#t="PARSING",await this.#s(t,n),this.#t="FINISHED_PARSING"}catch(r){throw this.#t="ERRORED_WHILE_PARSING",r}}async#s(t,n){let a=[...qP(this.#e).values()];for(let o of a)o.reset();for(let o of a)o.initialize?.(n);for(let o=0;o<t.length;++o){o%5e4===0&&o&&(this.dispatchEvent(new Uu({index:o,total:t.length})),await new Promise(c=>setTimeout(c,0)));let i=t[o];for(let c=0;c<
a.length;++c)a[c].handleEvent(i)}for(let o of a)await o.finalize?.()}get traceParsedData(){if(this.#t!=="FINISHED_PARSING")return null;if(this.#n)return this.#n;let t=s((r,a=!0)=>{if(r instanceof Map)return new Map(r);if(r instanceof Set)return new Set(r);if(Array.isArray(r))return[...r];if(typeof r=="object"&&r&&a){let o={};for(let[i,c]of Object.entries(r))o[i]=t(c,!1);return o}return r},"shallowClone"),n={};for(let[r,a]of Object.entries(this.#e)){let o=t(a.data());Object.assign(n,{[r]:o})}return this.#n=n,this.#n}#c(t){let n={};for(let[r,a]of Object.entries(vf))a.deps().some(i=>!t[i])||Object.assign(n,{[r]:a.generateInsight});return n}get insights(){if(!this.traceParsedData)return null;if(this.#r)return this.#r;this.#r=new Map;let t=this.#c(this.traceParsedData);for(let n of this.traceParsedData.Meta.mainFrameNavigations){if(!n.args.frame||!n.args.data?.navigationId)continue;let r={frameId:n.args.frame,navigationId:n.args.data.navigationId},a={};for(let[o,i]of Object.entries(t)){let c;
try{c=i(this.traceParsedData,r)}catch(u){c=u}Object.assign(a,{[o]:c})}this.#r.set(r.navigationId,a)}return this.#r}};s(qP,"sortHandlers")});var zP=y(()=>{l();tn();ps();Et();Gb();Ke()});function Soe(e,t){he.getWithDefault(e,t,()=>({unsizedMedia:[],iframes:[],fontChanges:[],renderBlockingRequests:[],scriptStackTrace:[]}))}function koe(e,t){return!Coe.has(e.args.data.renderBlocking)&&e.args.data.frame===t}function Foe(e){let t=[];for(let n=0;n<e.length;n++){let r=e[n].request.args.data.frame;koe(e[n].request,r)&&t.push(e[n])}return t}function $P(e){if(e.nodeName==="IFRAME")return e;let t=e.children;if(!t)return null;for(let n of t){let r=$P(n);if(r)return r}return null}function Vb(e){return!["auto","initial","unset","inherit"].includes(e)}function GP(e){return parseInt(e.value,10)>=0}function Roe(e){let t=/^url\("([^"]+)"\)$/,n=e.get("background-image");return n?t.test(n):!1}function Aoe(e){let t=e.get("position");return t?t==="fixed"||t==="absolute":!1}function _oe(e){let t={};return t.height=e.get("height"),t.width=e.get("width"),t.aspectRatio=e.get("aspect-ratio"),t}async function Ioe(e,t){let n=e.localName,r=Roe(t);return n!=="img"&&n!=="video"&&!r?!1:!Aoe(t)}function Noe(e){
let{height:t,width:n,aspectRatio:r}=e,a=!!(t&&Vb(t)),o=!!(n&&Vb(n)),i=!!(r&&Vb(r));return a&&o||(a||o)&&i}function VP(e,t){let n=new Map;for(let r of t){let a=Ht.nearestIndexFromBeginning(e,o=>o.ts>=r.ts);if(a!==null)for(let o=a;o<e.length;o++){let i=e[o];if(i.ts>=r.ts&&i.ts<=r.ts+r.dur&&he.getWithDefault(n,r,()=>[]).push(i),i.ts>r.ts+r.dur)break}}return n}var HP,WP,Coe,fs,$b=y(()=>{l();tn();Et();Ke();HP=new Map,WP=new Map;s(Soe,"setDefaultValue");Coe=new Set(["non_blocking","potentially_blocking"]);s(koe,"networkRequestIsRenderBlockingInFrame");fs=class{static{s(this,"LayoutShiftRootCauses")}#e;#t=new Map;#a=new Map;#n;constructor(t,n){this.#e=t,this.#n=n?.enableIframeRootCauses??!1}async rootCausesForEvent(t,n){let r=this.#t.get(n);if(r)return r;let a=t.LayoutShifts.clusters.flatMap(i=>i.events);a.forEach(i=>Soe(this.#t,i)),await this.blameShifts(a,t);let o=this.#t.get(n);return o||null}async blameShifts(t,n){await this.linkShiftsToLayoutInvalidations(t,n),this.linkShiftsToLayoutEvents(
t,n)}async linkShiftsToLayoutInvalidations(t,n){let{prePaintEvents:r,layoutInvalidationEvents:a,scheduleStyleInvalidationEvents:o,backendNodeIds:i}=n.LayoutShifts,c=[...a,...o],u=await this.#e.pushNodesByBackendIdsToFrontend(i),d=new Map;for(let p=0;p<i.length;p++)d.set(i[p],u[p]);let m=VP(t,r);for(let p of c){let h=Ht.nearestIndexFromBeginning(r,C=>C.ts>p.ts);if(h===null)continue;let f=r[h],g=m.get(f);if(!g)continue;let v=this.getFontChangeRootCause(p,f,n),w=this.getRenderBlockRootCause(p,f,n),E=d.get(p.args.data.nodeId),T=null,S=null;if(E!==void 0&&R.isTraceEventLayoutInvalidationTracking(p)&&(T=await this.getUnsizedMediaRootCause(p,E),S=await this.getIframeRootCause(p,E)),!(!T&&!S&&!v&&!w))for(let C of g){let F=he.getWithDefault(this.#t,C,()=>({unsizedMedia:[],iframes:[],fontChanges:[],renderBlockingRequests:[],scriptStackTrace:[]}));T&&!F.unsizedMedia.some(L=>L.node.nodeId===T?.node.nodeId)&&C.args.frame===p.args.data.frame&&F.unsizedMedia.push(T),S&&!F.iframes.some(L=>L.iframe.nodeId===
S?.iframe.nodeId)&&F.iframes.push(S),v&&(F.fontChanges=v),w&&(F.renderBlockingRequests=w)}}}linkShiftsToLayoutEvents(t,n){let{prePaintEvents:r}=n.LayoutShifts,a=VP(t,r),o=s(({name:c})=>c==="Layout","eventTriggersLayout"),i=n.Renderer.allTraceEntries.filter(o);for(let c of i){let u=Ht.nearestIndexFromBeginning(r,g=>g.ts>c.ts+(c.dur||0));if(u===null)continue;let d=r[u],m=a.get(d);if(!m)continue;let p=n.Renderer.entryToNode.get(c),f=(p?n.Initiators.eventToInitiator.get(p.entry):null)?.args?.data?.stackTrace;if(f)for(let g of m){let v=he.getWithDefault(this.#t,g,()=>({unsizedMedia:[],iframes:[],fontChanges:[],renderBlockingRequests:[],scriptStackTrace:[]}));v.scriptStackTrace.length===0&&(v.scriptStackTrace=f)}}}async getUnsizedMediaRootCause(t,n){if(t.args.data.reason!=="Size changed")return null;let r=await this.getNodeDetails(n);if(!r)return null;let a=await this.#e.getComputedStyleForNode(r.nodeId),o=new Map(a.map(u=>[u.name,u.value]));if(o&&!await Ioe(r,o))return null;let i=await this.
getNodeAuthoredDimensions(r);if(Noe(i))return null;let c=o?_oe(o):{};return{node:r,authoredDimensions:i,computedDimensions:c}}async getIframeRootCause(t,n){if(!this.#n||!t.args.data.nodeName?.startsWith("IFRAME")&&t.args.data.reason!=="Style changed"&&t.args.data.reason!=="Added to layout")return null;let r=await this.getNodeDetails(n);if(!r)return null;let a=$P(r);return a?{iframe:a}:null}async getNodeDetails(t){let n=this.#a.get(t);return n!==void 0||(n=await this.#e.getNode(t),this.#a.set(t,n)),n}requestsInInvalidationWindow(t,n){let r=n.NetworkRequests.byTime.sort((c,u)=>{let d=c.ts+c.dur,m=u.ts+u.dur;return d-m}),a=Ht.nearestIndexFromEnd(r,c=>c.ts+c.dur<t.ts);if(a===null)return[];let o=me.secondsToMicroseconds(I.Seconds(.5)),i=[];for(let c=a;c>-1;c--){let u=r[c],d=u.ts+u.dur;if(t.ts-d<o){let m={request:u},p=this.#e.getInitiatorForRequest(u.args.data.url);m.initiator=p||void 0,i.push(m)}else break}return i}getFontChangeRootCause(t,n,r){if(t.args.data.reason!=="Fonts changed")return null;
let a=HP.get(n);if(a!==void 0)return a;let o=this.getFontRequestsInInvalidationWindow(this.requestsInInvalidationWindow(t,r));return HP.set(n,o),o}getFontRequestsInInvalidationWindow(t){let n=[];for(let r=0;r<t.length;r++){let a=t[r];if(!a.request.args.data.mimeType.startsWith("font"))continue;let o=this.#e.fontFaceForSource(a.request.args.data.url);!o||o.fontDisplay==="optional"||(a.fontFace=o,n.push(a))}return n}getRenderBlockRootCause(t,n,r){let a=WP.get(n);if(a!==void 0)return a;let o=Foe(this.requestsInInvalidationWindow(t,r));return WP.set(n,o),o}async nodeMatchedStylesPropertyGetter(t){let n=await this.#e.getMatchedStylesForNode(t.nodeId);function r(a){let o=n.inlineStyle?.cssProperties.find(i=>i.name===a);if(o)return o.value;for(let{rule:i}of n.matchedCSSRules||[]){let c=i.style.cssProperties.find(u=>u.name===a);if(c)return c.value}return o=n.attributesStyle?.cssProperties.find(i=>i.name===a),o?o.value:null}return s(r,"cssPropertyValueGetter"),r}async getNodeAuthoredDimensions(t){
let n={},r=await this.nodeMatchedStylesPropertyGetter(t);if(!r)return n;let a=t.attributes||[],o=[];for(let p=0;p<a.length;p+=2)o.push({name:a[p],value:a[p+1]});let i=o.find(p=>p.name==="height"&&GP(p)),c=o.find(p=>p.name==="width"&&GP(p)),u=r("aspect-ratio")||void 0;if(i&&c&&u)return{height:i.value,width:c.value,aspectRatio:u};let d=r("height")||void 0,m=r("width")||void 0;return{height:d,width:m,aspectRatio:u}}};s(Foe,"getRenderBlockRequestsInInvalidationWindow");s($P,"firstIframeInDOMTree");s(Vb,"cssPropertyIsExplicitlySet");s(GP,"htmlAttributeIsExplicit");s(Roe,"computedStyleHasBackroundImage");s(Aoe,"computedStyleHasFixedPosition");s(_oe,"getNodeComputedDimensions");s(Ioe,"nodeIsUnfixedMedia");s(Noe,"dimensionsAreExplicit");s(VP,"getShiftsByPrePaintEvents")});var Kb={};x(Kb,{LayoutShiftRootCauses:()=>fs,RootCauses:()=>Yb});var Yb,YP=y(()=>{l();$b();$b();Yb=class{static{s(this,"RootCauses")}layoutShifts;constructor(t){this.layoutShifts=new fs(t)}}});var Df={};x(Df,{RootCauses:()=>Kb});var KP=y(()=>{l();YP()});var XP=y(()=>{l()});var Xb=y(()=>{l();U3();j3();ps();Et();Wb();zP();Gb();KP();XP();Ke()});var ZP=y(()=>{l()});var Qo={};x(Qo,{createGraph:()=>zoe,createNetworkRequests:()=>joe,createProcessedNavigation:()=>Poe});function Poe(e){let t=e.Meta,n=t.mainFrameId,r=e.PageLoadMetrics.metricScoresByFrameId.get(n);if(!r)throw new Error("missing metric scores for main frame");let a=t.mainFrameNavigations.at(-1)?.args.data?.navigationId,o=a&&r.get(a);if(!o)throw new Error("missing metric scores for specified navigation");let i=s(m=>{let p=o.get(m);if(p?.event)return p.event.ts},"getTimestampOrUndefined");return{timestamps:{firstContentfulPaint:s(m=>{let p=o.get(m);if(!p?.event)throw new Error(`missing metric: ${m}`);return p.event.ts},"getTimestamp")("FCP"),largestContentfulPaint:i("LCP")}}}function JP(e){return typeof e=="string"&&(e=new URL(e)),{scheme:e.protocol.split(":")[0],host:e.hostname,securityOrigin:e.origin}}function Loe(e){let t=new Map,n=["ServiceWorker thread","DedicatedWorker thread"];for(let r of e.traceEvents){if(r.name!=="thread_name"||!r.args.name||!n.includes(r.args.name))continue;let a=t.
get(r.pid);a?a.push(r.tid):t.set(r.pid,[r.tid])}return t}function Ooe(e,t,n){if(n.args.data.connectionId===void 0||n.args.data.connectionReused===void 0)throw new Error("Trace is too old");let r;try{r=new URL(n.args.data.url)}catch{return}let a=n.args.data.timing?{workerFetchStart:-1,workerRespondWithSettled:-1,...n.args.data.timing}:void 0,o=a?a.requestTime*1e3:n.args.data.syntheticData.downloadStart/1e3,i=!1;t.get(n.pid)?.includes(n.tid)&&(i=!0),e.Workers.workerIdByThread.has(n.tid)&&(i=!0);let d=n.args.data.initiator??{type:"other"};if(n.args.data.stackTrace){let h=n.args.data.stackTrace.map(f=>({scriptId:String(f.scriptId),url:f.url,lineNumber:f.lineNumber-1,columnNumber:f.columnNumber-1,functionName:f.functionName}));d.stack={callFrames:h}}let m=n.args.data.resourceType;n.args.data.initiator?.fetchType==="xmlhttprequest"?m="XHR":n.args.data.initiator?.fetchType==="fetch"&&(m="Fetch");let p=n.args.data.decodedBodyLength??0;if(r.protocol==="data:"&&p===0){let h="base64,",f=r.pathname.
indexOf(h);f!==-1&&(p=atob(r.pathname.substring(f+h.length)).length)}return{rawRequest:n,requestId:n.args.data.requestId,connectionId:n.args.data.connectionId,connectionReused:n.args.data.connectionReused,url:n.args.data.url,protocol:n.args.data.protocol,parsedURL:JP(r),documentURL:n.args.data.requestingFrameUrl,rendererStartTime:n.ts/1e3,networkRequestTime:o,responseHeadersEndTime:n.args.data.syntheticData.downloadStart/1e3,networkEndTime:n.args.data.syntheticData.finishTime/1e3,transferSize:n.args.data.encodedDataLength,resourceSize:p,fromDiskCache:n.args.data.syntheticData.isDiskCached,fromMemoryCache:n.args.data.syntheticData.isMemoryCached,isLinkPreload:n.args.data.isLinkPreload,finished:n.args.data.finished,failed:n.args.data.failed,statusCode:n.args.data.statusCode,initiator:d,timing:a,resourceType:m,mimeType:n.args.data.mimeType,priority:n.args.data.priority,frameId:n.args.data.frame,fromWorker:i,redirects:void 0,redirectSource:void 0,redirectDestination:void 0,initiatorRequest:void 0}}
function Boe(e,t){if(e.redirectSource)return e.redirectSource;let n=Fr.getNetworkInitiators(e)[0],r=t.get(n)||[];if(r=r.filter(a=>a.responseHeadersEndTime<=e.rendererStartTime&&a.finished&&!a.failed),r.length>1){let a=r.filter(o=>o.resourceType!==ln.Other);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.frameId===e.frameId);a.length&&(r=a)}if(r.length>1&&e.initiator.type==="parser"){let a=r.filter(o=>o.resourceType===ln.Document);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.isLinkPreload);if(a.length){let o=r.filter(c=>!c.isLinkPreload),i=o.every(c=>c.fromDiskCache||c.fromMemoryCache);o.length&&i&&(r=a)}}return r.length===1?r[0]:null}function Uoe(e){let t=new Map;for(let n of e){let r=t.get(n.url)||[];r.push(n),t.set(n.url,r)}for(let n of e){let r=Boe(n,t);r&&(n.initiatorRequest=r)}}function joe(e,t){let n=Loe(e),r=[];for(let a of t.NetworkRequests.byTime){let o=Ooe(t,n,a);o&&r.push(o)}for(let a of[...r]){if(!a.rawRequest)continue;let o=a.rawRequest.args.data.redirects;if(!o.length)
continue;let i=[];for(let c of o){let u=structuredClone(a);u.networkRequestTime=c.ts/1e3,u.rendererStartTime=u.networkRequestTime,u.networkEndTime=(c.ts+c.dur)/1e3,u.responseHeadersEndTime=u.networkEndTime,u.timing={requestTime:u.networkRequestTime/1e3,receiveHeadersStart:u.responseHeadersEndTime,receiveHeadersEnd:u.responseHeadersEndTime,proxyStart:-1,proxyEnd:-1,dnsStart:-1,dnsEnd:-1,connectStart:-1,connectEnd:-1,sslStart:-1,sslEnd:-1,sendStart:-1,sendEnd:-1,workerStart:-1,workerReady:-1,workerFetchStart:-1,workerRespondWithSettled:-1,pushStart:-1,pushEnd:-1},u.url=c.url,u.parsedURL=JP(c.url),u.statusCode=302,u.resourceType=void 0,u.transferSize=400,i.push(u),r.push(u)}i.push(a);for(let c=0;c<i.length;c++){let u=i[c];c>0&&(u.redirectSource=i[c-1],u.redirects=i.slice(0,c)),c!==i.length-1&&(u.redirectDestination=i[c+1])}for(let c=1;c<i.length;c++)i[c].requestId=`${i[c-1].requestId}:redirect`}return Uoe(r),r.sort((a,o)=>a.rendererStartTime-o.rendererStartTime)}function qoe(e,t){let n=t.
Meta,r=n.mainFrameNavigations.length?new Set(n.mainFrameNavigations.map(o=>o.pid)):n.topLevelRendererIds,a=new Map;for(let o of r){let i=n.threadsInProcess.get(o)??[],c=!1;for(let[u,d]of i)if(d.args.name==="CrRendererMain"){a.set(o,u),c=!0;break}if(!c){for(let[u,d]of i)if(d.args.name==="CrBrowserMain"){a.set(o,u),c=!0;break}}}return e.traceEvents.filter(o=>a.get(o.pid)===o.tid)}function zoe(e,t,n,r){let a=qoe(t,n);if(!r){r={requestedUrl:e[0].url,mainDocumentUrl:""};let o=e[0];for(;o.redirectDestination;)o=o.redirectDestination;r.mainDocumentUrl=o.url}return Fr.createGraph(a,e,r)}var QP=y(()=>{"use strict";l();Xb();ZP();Oe();s(Poe,"createProcessedNavigation");s(JP,"createParsedUrl");s(Loe,"findWorkerThreads");s(Ooe,"createLanternRequest");s(Boe,"chooseInitiatorRequest");s(Uoe,"linkInitiators");s(joe,"createNetworkRequests");s(qoe,"collectMainThreadEvents");s(zoe,"createGraph")});var ln,Oe=y(()=>{"use strict";l();tp();JN();iy();QN();eM();sy();nM();uM();PM();OM();QP();ln={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"}});var eL=y(()=>{"use strict";l();});var tL=y(()=>{"use strict";l();Ae();Jr();});var nL,Ef,rL=y(()=>{"use strict";l();nL=Bt(zc(),1);Ef=class e{static{s(this,"ArbitraryEqualityMap")}constructor(){this._equalsFn=e.deepEquals,this._entries=[]}setEqualityFn(t){this._equalsFn=t}has(t){return this._findIndexOf(t)!==-1}get(t){return this._entries[this._findIndexOf(t)]?.value}set(t,n){let r=this._findIndexOf(t);r===-1&&(r=this._entries.length),this._entries[r]={key:t,value:n}}_findIndexOf(t){for(let n=0;n<this._entries.length;n++)if(this._equalsFn(t,this._entries[n].key))return n;return-1}static deepEquals(t,n){return(0,nL.default)(t,n)}}});function V(e,t){return Object.assign(e,{request:s((r,a)=>{let o=t?Object.fromEntries(t.map(h=>[h,r[h]])):r,i=a.computedCache,c=e.name,u=i.get(c)||new Ef;i.set(c,u);let d=u.get(o);if(d)return d;let m={msg:`Computing artifact: ${c}`,id:`lh:computed:${c}`};N.time(m,"verbose");let p=e.compute_(o,a);return u.set(o,p),p.then(()=>N.timeEnd(m)).catch(()=>N.timeEnd(m)),p},"request")})}var De=y(()=>{"use strict";l();Ae();rL();s(V,"makeComputedArtifact")});var aL,oL,iL,sL,cL,uL,lL,Tf,X,Mt=y(()=>{"use strict";l();on();Oe();ot();aL="X-TCPMs",oL="X-SSLMs",iL="X-RequestMs",sL="X-ResponseMs",cL="X-TotalMs",uL="X-TotalFetchedSize",lL="X-ProtocolIsH2",Tf={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"},X=class e{static{s(this,"NetworkRequest")}constructor(){this.requestId="",this.connectionId=0,this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,this.responseHeadersTransferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=
!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.fromWorker=!1,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(t){this.initiatorRequest=t}onRequestWillBeSent(t){this.requestId=t.requestId;let n;try{n=new URL(t.request.url)}catch{return}this.url=t.request.url,this.documentURL=t.documentURL,this.parsedURL={scheme:n.protocol.split(":")[0],host:n.hostname,securityOrigin:n.origin},this.isSecure=Y.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=t.timestamp*
1e3,this.networkRequestTime=this.rendererStartTime,this.responseHeadersEndTime=this.rendererStartTime,this.requestMethod=t.request.method,this.initiator=t.initiator,this.resourceType=t.type&&Tf[t.type],this.priority=t.request.initialPriority,this.frameId=t.frameId,this.isLinkPreload=t.initiator.type==="preload"||!!t.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(t){this._onResponse(t.response,t.timestamp,t.type),this._updateProtocolForLightrider(),this.frameId=t.frameId}onResponseReceivedExtraInfo(t){this.responseHeadersText=t.headersText||""}onDataReceived(t){this.resourceSize+=t.dataLength,t.encodedDataLength!==-1&&(this.transferSize+=t.encodedDataLength)}onLoadingFinished(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,t.encodedDataLength>=0&&(this.transferSize=t.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),
this._updateTimingsForLightrider())}onLoadingFailed(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,this.failed=!0,this.resourceType=t.type&&Tf[t.type],this.localizedFailDescription=t.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(t){this.priority=t.newPriority}onRedirectResponse(t){if(!t.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(t.redirectResponse,t.timestamp,t.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=t.timestamp*1e3,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming()}setSession(t){this.sessionId=t}get isOutOfProcessIframe(){return this.sessionTargetType==="iframe"}_onResponse(t,n,r){this.url=t.url,this.connectionId=t.connectionId,this.connectionReused=t.connectionReused,t.protocol&&(this.protocol=t.protocol),
this.responseTimestamp=n*1e3,this.transferSize=t.encodedDataLength,this.responseHeadersTransferSize=t.encodedDataLength,typeof t.fromDiskCache=="boolean"&&(this.fromDiskCache=t.fromDiskCache),typeof t.fromPrefetchCache=="boolean"&&(this.fromPrefetchCache=t.fromPrefetchCache),this.statusCode=t.status,this.timing=t.timing,r&&(this.resourceType=Tf[r]),this.mimeType=t.mimeType,this.responseHeaders=e._headersDictToHeadersArray(t.headers),this.fetchedViaServiceWorker=!!t.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(t){if(t.requestTime===-1||t.receiveHeadersEnd===-1)return;this.networkRequestTime=t.requestTime*1e3;let n=this.networkRequestTime+t.receiveHeadersEnd;this.responseHeadersEndTime=n,this.responseTimestamp!==void 0&&(this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,this.responseTimestamp)),this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.
networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(r=>r.name===uL);if(!t)return;let n=parseFloat(t.value);isNaN(n)||(this.transferSize=n)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some(t=>t.name===lL)&&(this.protocol="h2")}_backfillReceiveHeaderStartTiming(){!this.timing||this.timing.receiveHeadersStart!==void 0||(this.timing.receiveHeadersStart=this.timing.receiveHeadersEnd)}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(p=>p.name===cL);if(!t)return;let n=parseInt(t.value),r=this.responseHeaders.find(p=>p.name===aL),a=this.responseHeaders.find(p=>p.name===oL),o=this.responseHeaders.find(p=>p.name===iL),i=this.responseHeaders.find(
p=>p.name===sL),c=r?Math.max(0,parseInt(r.value)):0,u=a?Math.max(0,parseInt(a.value)):0,d=o?Math.max(0,parseInt(o.value)):0,m=i?Math.max(0,parseInt(i.value)):0;if(!Number.isNaN(c+d+m+n)){if(c+d+m!==n){if(Math.abs(c+d+m-n)>=25)return;n=c+d+m}u>c||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-(this.networkRequestTime+n),TCPMs:c,requestMs:d,responseMs:m},this.serverResponseTime=m)}}static getRequestIdForBackend(t){return t.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(t){let n=[];for(let r of Object.keys(t)){let a=t[r].split(`
`);for(let o=0;o<a.length;++o)n.push({name:r,value:a[o]})}return n}static get TYPES(){return Tf}static asLanternNetworkRequest(t){let n=t.timing,r;return globalThis.isLightrider&&t.lrStatistics&&(t.protocol.startsWith("h3")?n={connectStart:0,connectEnd:t.lrStatistics.TCPMs}:(n={connectStart:0,sslStart:t.lrStatistics.TCPMs/2,connectEnd:t.lrStatistics.TCPMs,sslEnd:t.lrStatistics.TCPMs},r=t.lrStatistics.requestMs)),t.fromWorker=t.sessionTargetType==="worker",{rawRequest:t,...t,timing:n,serverResponseTime:r}}static isNonNetworkRequest(t){return Y.isNonNetworkProtocol(t.protocol)||Y.isNonNetworkProtocol(t.parsedURL.scheme)}static isSecureRequest(t){return Y.isSecureScheme(t.parsedURL.scheme)||Y.isSecureScheme(t.protocol)||Y.isLikeLocalhost(t.parsedURL.host)||e.isHstsRequest(t)}static isHstsRequest(t){let n=t.redirectDestination;return n?t.responseHeaders.find(o=>o.name==="Non-Authoritative-Reason")?.value==="HSTS"&&e.isSecureRequest(n):!1}static isContentEncoded(t){let n=globalThis.isLightrider?
[/^x-original-content-encoding$/i]:[/^content-encoding$/i,/^x-content-encoding-over-network$/i],r=["gzip","br","deflate","zstd"];return t.responseHeaders.some(a=>n.some(o=>a.name.match(o))&&r.includes(a.value))}static getResourceSizeOnNetwork(t){return Math.min(t.resourceSize||0,t.transferSize||1/0)}};X.HEADER_TCP=aL;X.HEADER_SSL=oL;X.HEADER_REQ=iL;X.HEADER_RES=sL;X.HEADER_TOTAL=cL;X.HEADER_FETCHED_SIZE=uL;X.HEADER_PROTOCOL_IS_H2=lL});var Hoe,hs,Zb=y(()=>{"use strict";l();Zr();Ae();on();Oe();Mt();Hoe=We,hs=class e extends Hoe{static{s(this,"NetworkRecorder")}constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)}onRequestStarted(t){this._records.push(t),this._recordsById.set(t.requestId,t),this.emit("requeststarted",t)}onRequestFinished(t){this.emit("requestfinished",t)}onRequestWillBeSent(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);if(!r){let i=new X;i.onRequestWillBeSent(n),i.sessionId=t.sessionId,i.sessionTargetType=t.targetType,this.onRequestStarted(i),N.verbose("network",`request will be sent to ${i.url}`);return}if(!n.redirectResponse)return;let a={...n,initiator:r.initiator,requestId:`${r.requestId}:redirect`},o=new X;o.onRequestWillBeSent(a),r.onRedirectResponse(n),N.verbose("network",`${r.url} redirected to ${o.url}`),r.redirectDestination=o,o.redirectSource=r,this.onRequestStarted(o),this.onRequestFinished(
r)}onRequestServedFromCache(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} served from cache`),r.onRequestServedFromCache())}onResponseReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} response received`),r.onResponseReceived(n))}onResponseReceivedExtraInfo(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} response received extra info`),r.onResponseReceivedExtraInfo(n))}onDataReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} data received`),r.onDataReceived(n))}onLoadingFinished(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} loading finished`),r.onLoadingFinished(n),this.onRequestFinished(
r))}onLoadingFailed(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(N.verbose("network",`${r.url} loading failed`),r.onLoadingFailed(n),this.onRequestFinished(r))}onResourceChangedPriority(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&r.onResourceChangedPriority(n)}dispatch(t){switch(t.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(t);case"Network.requestServedFromCache":return this.onRequestServedFromCache(t);case"Network.responseReceived":return this.onResponseReceived(t);case"Network.responseReceivedExtraInfo":return this.onResponseReceivedExtraInfo(t);case"Network.dataReceived":return this.onDataReceived(t);case"Network.loadingFinished":return this.onLoadingFinished(t);case"Network.loadingFailed":return this.onLoadingFailed(t);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(t);default:return}}_findRealRequestAndSetSession(t,n,r){let a=this.
_recordsById.get(t);if(!(!a||!a.isValid)){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(r),a.sessionTargetType=n,a}}static _chooseInitiatorRequest(t,n){if(t.redirectSource)return t.redirectSource;let r=Fr.getNetworkInitiators(t)[0],a=n.get(r)||[];if(a=a.filter(o=>o.responseHeadersEndTime<=t.rendererStartTime&&o.finished&&!o.failed),a.length>1){let o=a.filter(i=>i.resourceType!==X.TYPES.Other);o.length&&(a=o)}if(a.length>1){let o=a.filter(i=>i.frameId===t.frameId);o.length&&(a=o)}if(a.length>1&&t.initiator.type==="parser"){let o=a.filter(i=>i.resourceType===X.TYPES.Document);o.length&&(a=o)}if(a.length>1){let o=a.filter(i=>i.isLinkPreload);if(o.length){let i=a.filter(u=>!u.isLinkPreload),c=i.every(u=>u.fromDiskCache||u.fromMemoryCache);i.length&&c&&(a=o)}}return a.length===1?a[0]:null}static recordsFromLogs(t){let n=new e;t.forEach(o=>n.dispatch(o));let r=n.getRawRecords().filter(o=>o.isValid),a=new Map;for(let o of r){let i=a.get(o.url)||[];i.push(o),a.set(o.url,
i)}for(let o of r){let i=e._chooseInitiatorRequest(o,a);i&&o.setInitiatorRequest(i);let c=o;for(;c.redirectDestination;)c=c.redirectDestination;if(c===o||c.redirects)continue;let u=[];for(let d=c.redirectSource;d;d=d.redirectSource)u.unshift(d);c.redirects=u}return r}}});var Jb,ae,it=y(()=>{"use strict";l();on();De();Zb();Jb=class{static{s(this,"NetworkRecords")}static async compute_(t){return hs.recordsFromLogs(t)}},ae=V(Jb,null)});var Qb,lr,ei=y(()=>{"use strict";l();Oe();De();it();Qb=class{static{s(this,"NetworkAnalysis")}static async compute_(t,n){let r=await ae.request(t,n);return zt.NetworkAnalyzer.analyze(r)}},lr=V(Qb,null)});var e0,$t,Nr=y(()=>{"use strict";l();De();Oe();ei();e0=class{static{s(this,"LoadSimulator")}static async compute_(t,n){let r=await lr.request(t.devtoolsLog,n);return zt.Simulator.createSimulator({...t.settings,networkAnalysis:r})}static convertAnalysisToSaveableLanternData(t){let n={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(let[r,a]of t.additionalRttByOrigin.entries())r.startsWith("http")&&(n.additionalRttByOrigin[r]=a);for(let[r,a]of t.serverResponseTimeByOrigin.entries())r.startsWith("http")&&(n.serverResponseTimeByOrigin[r]=a);return n}},$t=V(e0,["devtoolsLog","settings"])});async function n0(e,t,n){let r=qn.createWriteStream(n?t+".gz":t);n?await Rg.promises.pipeline(e,KN(),r):await Rg.promises.pipeline(e,r)}function t0(e,t){if(qn.existsSync(e+".gz")&&(e=e+".gz"),!e.endsWith(".json.gz"))return JSON.parse(qn.readFileSync(e,"utf8"),t);let n=ZN(qn.readFileSync(e));return JSON.parse(n.toString("utf8"),t)}function dL(e,t){return e.endsWith(t)||e.endsWith(t+".gz")}function fL(e){if(N.log("Reading artifacts from disk:",e),!qn.existsSync(e))throw new Error("No saved artifacts found at "+e);let t=t0(xt.join(e,xf),H.parseReviver),n=qn.readdirSync(e);return n.filter(r=>dL(r,ni)).forEach(r=>{t.devtoolsLogs||(t.devtoolsLogs={});let a=r.replace(ni+".gz","").replace(ni,""),o=t0(xt.join(e,r));t.devtoolsLogs[a]=o,a===Sf&&(t.DevtoolsLog=o),a===Cf&&(t.DevtoolsLogError=o)}),n.filter(r=>dL(r,ti)).forEach(r=>{t.traces||(t.traces={});let a=t0(xt.join(e,r)),o=r.replace(ti+".gz","").replace(ti,"");t.traces[o]=Array.isArray(a)?{traceEvents:a}:a,o===Sf&&(t.Trace=t.traces[o]),o===Cf&&
(t.TraceError=t.traces[o])}),Array.isArray(t.Timing)&&t.Timing.forEach(r=>r.gather=!0),t}function Woe(e,t){return t instanceof Error?H.stringifyReplacer(t):t}async function hL(e,t,n={}){let r={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};N.time(r),qn.mkdirSync(t,{recursive:!0});let a=qn.readdirSync(t);for(let f of a)(f.endsWith(ti)||f.endsWith(ni)||f.endsWith(ti+".gz")||f.endsWith(ni+".gz")||f===xf||f===xf+".gz")&&qn.unlinkSync(`${t}/${f}`);let{traces:o,devtoolsLogs:i,DevtoolsLog:c,Trace:u,DevtoolsLogError:d,TraceError:m,...p}=e;u&&await mL(u,`${t}/${Sf}${ti}`,n),m&&await mL(m,`${t}/${Cf}${ti}`,n),c&&await pL(c,`${t}/${Sf}${ni}`,n),d&&await pL(d,`${t}/${Cf}${ni}`,n);let h=JSON.stringify(p,Woe,2);await n0(function*(){yield h,yield`
`},`${t}/${xf}`,!!n.gzip),N.log("Artifacts saved to disk in folder:",t),N.timeEnd(r)}function gL(e,t){qn.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}function*yL(e){if(yield`[
`,e.length>0){let n=e[Symbol.iterator](),r=n.next().value;yield`  ${JSON.stringify(r)}`;let a=500,o="";for(let i of n)o+=`,
  ${JSON.stringify(i)}`,a--,a===0&&(yield o,a=500,o="");yield o}yield`
]`}function*Goe(e){let{traceEvents:t,...n}=e;yield`{
`,yield'"traceEvents": ',yield*yL(t);for(let[r,a]of Object.entries(n))yield`,
"${r}": ${JSON.stringify(a,null,2)}`;yield`}
`}function mL(e,t,n={}){let r=Goe(e);return n0(r,t,!!n.gzip)}function pL(e,t,n={}){return n0(function*(){yield*yL(e),yield`
`},t,!!n.gzip)}var xf,ti,ni,Sf,Cf,vL=y(()=>{"use strict";l();Qr();_a();Ag();Yc();oy();Ae();Oe();eL();tL();ei();Nr();Ut();Kc();xf="artifacts.json",ti=".trace.json",ni=".devtoolslog.json",Sf="defaultPass",Cf="pageLoadError-defaultPass";s(n0,"writeJson");s(t0,"readJson");s(dL,"endsWithSuffix");s(fL,"loadArtifacts");s(Woe,"stringifyReplacer");s(hL,"saveArtifacts");s(gL,"saveLhr");s(yL,"arrayOfObjectsJsonGenerator");s(Goe,"traceJsonGenerator");s(mL,"saveTrace");s(pL,"saveDevtoolsLog")});var Za={};x(Za,{defaultSettings:()=>Wn,nonSimulatedSettingsOverrides:()=>ys,screenEmulationMetrics:()=>kf,throttling:()=>gs,userAgents:()=>Xa});var gs,$oe,Yoe,kf,Koe,Xoe,Xa,Wn,ys,ma=y(()=>{"use strict";l();Oe();gs=zt.Constants.throttling,$oe={mobile:!0,width:412,height:823,deviceScaleFactor:1.75,disabled:!1},Yoe={mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1},kf={mobile:$oe,desktop:Yoe},Koe="Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36",Xoe="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36",Xa={mobile:Koe,desktop:Xoe},Wn={output:"json",maxWaitForFcp:30*1e3,maxWaitForLoad:45*1e3,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,formFactor:"mobile",throttling:gs.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:kf.mobile,emulatedUserAgent:Xa.mobile,auditMode:!1,gatherMode:!1,
clearStorageTypes:["file_systems","shader_cache","service_workers","cache_storage"],disableStorageReset:!1,debugNavigation:!1,channel:"node",usePassiveGathering:!1,disableFullPageScreenshot:!1,skipAboutBlank:!1,blankPage:"about:blank",ignoreStatusCode:!1,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null},ys={pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250}});var Ie,Ve,bL,Ff,r0=y(()=>{"use strict";l();on();ma();A();Ie={performanceCategoryTitle:"Performance",metricGroupTitle:"Metrics",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportunities to [improve the accessib\
ility of your web app](https://developer.chrome.com/docs/lighthouse/accessibility/). Automatic detection can only detect a subset of issues and does not guarantee the accessibility of your web app, so [manual testing](https://web.dev/articles/how-to-review) is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://web.dev/articles/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology,\
 like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive te\
chnology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is following basic search engine optimization advice. There are many additional factors Lighthouse does not score here that may affect your search ranking, including performance on [Core Web Vitals](https://web.dev/explore/vitals). [Learn more about Google Search Essentials](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn how to make pages mobile-friendly](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",
seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General"},Ve=D("core/config/default-config.js",Ie),bL={settings:Wn,artifacts:[{id:"DevtoolsLog",gatherer:"devtools-log"},{id:"Trace",gatherer:"trace"},{id:"RootCauses",gatherer:"root-causes"},{id:"Accessibility",gatherer:"accessibility"},{id:"AnchorElements",gatherer:"anchor-elements"},{id:"CacheContents",gatherer:"cache-contents"},{id:"ConsoleMessages",gatherer:"console-messages"},{id:"CSSUsage",gatherer:"css-usage"},{id:"Doctype",gatherer:"dobetterweb/doctype"},{id:"DOMStats",gatherer:"dobetterweb/domstats"},{id:"FontSize",gatherer:"seo/font-size"},{id:"Inputs",gatherer:"inputs"},{id:"IFrameElements",gatherer:"iframe\
-elements"},{id:"ImageElements",gatherer:"image-elements"},{id:"InspectorIssues",gatherer:"inspector-issues"},{id:"JsUsage",gatherer:"js-usage"},{id:"LinkElements",gatherer:"link-elements"},{id:"MainDocumentContent",gatherer:"main-document-content"},{id:"MetaElements",gatherer:"meta-elements"},{id:"NetworkUserAgent",gatherer:"network-user-agent"},{id:"OptimizedImages",gatherer:"dobetterweb/optimized-images"},{id:"ResponseCompression",gatherer:"dobetterweb/response-compression"},{id:"RobotsTxt",gatherer:"seo/robots-txt"},{id:"Scripts",gatherer:"scripts"},{id:"SourceMaps",gatherer:"source-maps"},{id:"Stacks",gatherer:"stacks"},{id:"Stylesheets",gatherer:"stylesheets"},{id:"TraceElements",gatherer:"trace-elements"},{id:"ViewportDimensions",gatherer:"viewport-dimensions"},{id:"devtoolsLogs",gatherer:"devtools-log-compat"},{id:"traces",gatherer:"trace-compat"},{id:"FullPageScreenshot",gatherer:"full-page-screenshot"},{id:"BFCacheFailures",gatherer:"bf-cache-failures"}],audits:["is-on-https",
"redirects-http","viewport","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","metrics/interaction-to-next-paint","errors-in-console","server-response-time","metrics/interactive","user-timings","critical-request-chains","redirects","image-aspect-ratio","image-size-responsive","deprecations","third-party-cookies","mainthread-work-breakdown","bootup-time","uses-rel-preconnect","font-display","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","resource-summary","third-party-summary","third-party-facades","largest-contentful-paint-element","lcp-lazy-loaded","layout-shifts","long-tasks","non-composited-animations","unsized-images","valid-source-maps","prioritize-lcp-image","csp-xss","script-treemap-data","accessibility/accesskeys","acce\
ssibility/aria-allowed-attr","accessibility/aria-allowed-role","accessibility/aria-command-name","accessibility/aria-conditional-attr","accessibility/aria-deprecated-role","accessibility/aria-dialog-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-prohibited-attr","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-text","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-aria","accessibility/empty-heading","accessib\
ility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/html-xml-lang-mismatch","accessibility/identical-links-same-purpose","accessibility/image-alt","accessibility/image-redundant-alt","accessibility/input-button-name","accessibility/input-image-alt","accessibility/label-content-name-mismatch","accessibility/label","accessibility/landmark-one-main","accessibility/link-name","accessibility/link-in-text-block","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/select-name","accessibility/skip-link","accessibility/tabindex","accessibility/table-duplicate-name","accessibility/table-fake-caption","accessibility/target-size","accessibility/td-has-header","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessib\
ility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/modern-image-formats","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicated-javascript","byte-efficiency/legacy-javascript",
"byte-efficiency/uses-responsive-images-snapshot","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/no-document-write","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/paste-preventing-inputs","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/hreflang","seo/canonical","seo/manual/structured-data","work-during-interaction","bf-cache"],groups:{metrics:{title:Ve(Ie.metricGroupTitle)},diagnostics:{title:Ve(Ie.diagnosticsGroupTitle),description:Ve(Ie.diagnosticsGroupDescription)},"a11y-best-practices":{title:Ve(Ie.a11yBestPracticesGroupTitle),description:Ve(Ie.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:Ve(Ie.a11yColorContrastGroupTitle),description:Ve(Ie.a11yColorContrastGroupDescription)},
"a11y-names-labels":{title:Ve(Ie.a11yNamesLabelsGroupTitle),description:Ve(Ie.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:Ve(Ie.a11yNavigationGroupTitle),description:Ve(Ie.a11yNavigationGroupDescription)},"a11y-aria":{title:Ve(Ie.a11yAriaGroupTitle),description:Ve(Ie.a11yAriaGroupDescription)},"a11y-language":{title:Ve(Ie.a11yLanguageGroupTitle),description:Ve(Ie.a11yLanguageGroupDescription)},"a11y-audio-video":{title:Ve(Ie.a11yAudioVideoGroupTitle),description:Ve(Ie.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:Ve(Ie.a11yTablesListsVideoGroupTitle),description:Ve(Ie.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:Ve(Ie.seoMobileGroupTitle),description:Ve(Ie.seoMobileGroupDescription)},"seo-content":{title:Ve(Ie.seoContentGroupTitle),description:Ve(Ie.seoContentGroupDescription)},"seo-crawl":{title:Ve(Ie.seoCrawlingGroupTitle),description:Ve(Ie.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:Ve(Ie.bestPracticesTrustSafetyGroupTitle)},
"best-practices-ux":{title:Ve(Ie.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:Ve(Ie.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:Ve(Ie.bestPracticesGeneralGroupTitle)},hidden:{title:""}},categories:{performance:{title:Ve(Ie.performanceCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"first-contentful-paint",weight:10,group:"metrics",acronym:"FCP"},{id:"largest-contentful-paint",weight:25,group:"metrics",acronym:"LCP"},{id:"total-blocking-time",weight:30,group:"metrics",acronym:"TBT"},{id:"cumulative-layout-shift",weight:25,group:"metrics",acronym:"CLS"},{id:"speed-index",weight:10,group:"metrics",acronym:"SI"},{id:"interaction-to-next-paint",weight:0,group:"metrics",acronym:"INP"},{id:"interactive",weight:0,group:"hidden",acronym:"TTI"},{id:"max-potential-fid",weight:0,group:"hidden"},{id:"first-meaningful-paint",weight:0,acronym:"FMP",group:"hidden"},{id:"render-blocking-resources",weight:0,group:"diagnos\
tics"},{id:"uses-responsive-images",weight:0,group:"diagnostics"},{id:"offscreen-images",weight:0,group:"diagnostics"},{id:"unminified-css",weight:0,group:"diagnostics"},{id:"unminified-javascript",weight:0,group:"diagnostics"},{id:"unused-css-rules",weight:0,group:"diagnostics"},{id:"unused-javascript",weight:0,group:"diagnostics"},{id:"uses-optimized-images",weight:0,group:"diagnostics"},{id:"modern-image-formats",weight:0,group:"diagnostics"},{id:"uses-text-compression",weight:0,group:"diagnostics"},{id:"uses-rel-preconnect",weight:0,group:"diagnostics"},{id:"server-response-time",weight:0,group:"diagnostics"},{id:"redirects",weight:0,group:"diagnostics"},{id:"uses-http2",weight:0,group:"diagnostics"},{id:"efficient-animated-content",weight:0,group:"diagnostics"},{id:"duplicated-javascript",weight:0,group:"diagnostics"},{id:"legacy-javascript",weight:0,group:"diagnostics"},{id:"prioritize-lcp-image",weight:0,group:"diagnostics"},{id:"total-byte-weight",weight:0,group:"diagnostics"},
{id:"uses-long-cache-ttl",weight:0,group:"diagnostics"},{id:"dom-size",weight:0,group:"diagnostics"},{id:"critical-request-chains",weight:0,group:"diagnostics"},{id:"user-timings",weight:0,group:"diagnostics"},{id:"bootup-time",weight:0,group:"diagnostics"},{id:"mainthread-work-breakdown",weight:0,group:"diagnostics"},{id:"font-display",weight:0,group:"diagnostics"},{id:"third-party-summary",weight:0,group:"diagnostics"},{id:"third-party-facades",weight:0,group:"diagnostics"},{id:"largest-contentful-paint-element",weight:0,group:"diagnostics"},{id:"lcp-lazy-loaded",weight:0,group:"diagnostics"},{id:"layout-shifts",weight:0,group:"diagnostics"},{id:"uses-passive-event-listeners",weight:0,group:"diagnostics"},{id:"no-document-write",weight:0,group:"diagnostics"},{id:"long-tasks",weight:0,group:"diagnostics"},{id:"non-composited-animations",weight:0,group:"diagnostics"},{id:"unsized-images",weight:0,group:"diagnostics"},{id:"viewport",weight:0,group:"diagnostics"},{id:"uses-responsive-ima\
ges-snapshot",weight:0,group:"diagnostics"},{id:"work-during-interaction",weight:0,group:"diagnostics"},{id:"bf-cache",weight:0,group:"diagnostics"},{id:"network-requests",weight:0,group:"hidden"},{id:"network-rtt",weight:0,group:"hidden"},{id:"network-server-latency",weight:0,group:"hidden"},{id:"main-thread-tasks",weight:0,group:"hidden"},{id:"diagnostics",weight:0,group:"hidden"},{id:"metrics",weight:0,group:"hidden"},{id:"screenshot-thumbnails",weight:0,group:"hidden"},{id:"final-screenshot",weight:0,group:"hidden"},{id:"script-treemap-data",weight:0,group:"hidden"},{id:"resource-summary",weight:0,group:"hidden"}]},accessibility:{title:Ve(Ie.a11yCategoryTitle),description:Ve(Ie.a11yCategoryDescription),manualDescription:Ve(Ie.a11yCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"accesskeys",weight:7,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-allowed-role",weight:1,group:"a11y-aria"},{id:"aria-command-nam\
e",weight:7,group:"a11y-aria"},{id:"aria-conditional-attr",weight:7,group:"a11y-aria"},{id:"aria-deprecated-role",weight:1,group:"a11y-aria"},{id:"aria-dialog-name",weight:7,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:7,group:"a11y-aria"},{id:"aria-input-field-name",weight:7,group:"a11y-aria"},{id:"aria-meter-name",weight:7,group:"a11y-aria"},{id:"aria-progressbar-name",weight:7,group:"a11y-aria"},{id:"aria-prohibited-attr",weight:7,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:7,group:"a11y-aria"},{id:"aria-text",weight:7,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:7,group:"a11y-aria"},{id:"aria-tooltip-name",weight:7,group:"a11y-aria"},{id:"aria-treeitem-name",weight:7,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-\
valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:7,group:"a11y-navigation"},{id:"color-contrast",weight:7,group:"a11y-color-contrast"},{id:"definition-list",weight:7,group:"a11y-tables-lists"},{id:"dlitem",weight:7,group:"a11y-tables-lists"},{id:"document-title",weight:7,group:"a11y-names-labels"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:3,group:"a11y-names-labels"},{id:"frame-title",weight:7,group:"a11y-names-labels"},{id:"heading-order",weight:3,group:"a11y-navigation"},{id:"html-has-lang",weight:7,group:"a11y-language"},{id:"html-lang-valid",weight:7,group:"a11y-language"},{id:"html-xml-lang-mismatch",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"image-redundant-alt",weight:1,group:"a11y-names-labels"},{id:"input-button-name",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"\
label",weight:7,group:"a11y-names-labels"},{id:"link-in-text-block",weight:7,group:"a11y-color-contrast"},{id:"link-name",weight:7,group:"a11y-names-labels"},{id:"list",weight:7,group:"a11y-tables-lists"},{id:"listitem",weight:7,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:7,group:"a11y-names-labels"},{id:"select-name",weight:7,group:"a11y-names-labels"},{id:"skip-link",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:7,group:"a11y-navigation"},{id:"table-duplicate-name",weight:1,group:"a11y-tables-lists"},{id:"target-size",weight:7,group:"a11y-best-practices"},{id:"td-headers-attr",weight:7,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:7,group:"a11y-tables-lists"},{id:"valid-lang",weight:7,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},
{id:"logical-tab-order",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"focus-traps",weight:0},{id:"managed-focus",weight:0},{id:"use-landmarks",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"empty-heading",weight:0,group:"hidden"},{id:"identical-links-same-purpose",weight:0,group:"hidden"},{id:"landmark-one-main",weight:0,group:"hidden"},{id:"label-content-name-mismatch",weight:0,group:"hidden"},{id:"table-fake-caption",weight:0,group:"hidden"},{id:"td-has-header",weight:0,group:"hidden"}]},"best-practices":{title:Ve(Ie.bestPracticesCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"is-on-https",weight:5,group:"best-practices-trust-safety"},{id:"redirects-http",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"csp-x\
ss",weight:0,group:"best-practices-trust-safety"},{id:"paste-preventing-inputs",weight:3,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"viewport",weight:1,group:"best-practices-ux"},{id:"font-size",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:5,group:"best-practices-general"},{id:"third-party-cookies",weight:5,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:Ve(Ie.seoCategoryTitle),description:Ve(Ie.seoCategoryDescription),manualDescription:Ve(Ie.seoCategoryManualDescription),supportedModes:["n\
avigation","snapshot"],auditRefs:[{id:"is-crawlable",weight:93/23,group:"seo-crawl"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"structured-data",weight:0}]}}};Object.defineProperty(bL,"UIStrings",{enumerable:!1,get:()=>Ie});Ff=bL});function wL(e,t){let n={timespan:0,snapshot:1,navigation:2},r=Math.min(...e.instance.meta.supportedModes.map(o=>n[o])),a=Math.min(...t.instance.meta.supportedModes.map(o=>n[o]));return r===n.timespan?a===n.timespan:r===n.snapshot?a===n.snapshot:!0}function DL(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories?.[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}function Zoe(e){let t=e.gatherer.instance;if(typeof t.meta!="object")throw new Error(`Gatherer for ${e.id} did not provide a meta object.`);if(t.meta.supportedModes.length===0)throw new Error(`Gatherer for ${e.id} did not support any gather modes.`);if(typeof t.getArtifact!="function"||t.getArtifact===J.prototype.getArtifact)throw new Error(`Gatherer for ${e.id} did not define a "getArtifact" method.`)}function a0(e){let{implementation:t,path:n}=e,r=n||t?.meta?.id||"Unknown audit";if(typeof t.
audit!="function"||t.audit===b.audit)throw new Error(`${r} has no audit() method.`);if(typeof t.meta.id!="string")throw new Error(`${r} has no meta.id property, or the property is not a string.`);if(!Tr(t.meta.title))throw new Error(`${r} has no meta.title property, or the property is not a string.`);let a=t.meta.scoreDisplayMode||b.SCORING_MODES.BINARY;if(!Tr(t.meta.failureTitle)&&a===b.SCORING_MODES.BINARY)throw new Error(`${r} has no meta.failureTitle and should.`);if(Tr(t.meta.description)){if(t.meta.description==="")throw new Error(`${r} has an empty meta.description string. Please add a description for the UI.`)}else throw new Error(`${r} has no meta.description property, or the property is not a string.`);if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${r} has no meta.requiredArtifacts property, or the property is not an array.`)}function Joe(e,t,n){if(!e)return;let r=new Map((t||[]).map(a=>[a.implementation.meta.id,a]));Object.keys(e).forEach(a=>{e[a].auditRefs.forEach(
(o,i)=>{if(!o.id)throw new Error(`missing an audit id at ${a}[${i}]`);let c=r.get(o.id);if(!c)throw new Error(`could not find ${o.id} audit for category ${a}`);let d=c.implementation.meta.scoreDisplayMode==="manual";if(a==="accessibility"&&!o.group&&!d)throw new Error(`${o.id} accessibility audit does not have a group`);if(o.weight>0&&d)throw new Error(`${o.id} is manual but has a positive weight`);if(o.group&&(!n||!n[o.group]))throw new Error(`${o.id} references unknown group ${o.group}`)})})}function o0(e){if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md");if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==(e.formFactor==="mobile"))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md`);let t=e.skipAudits?.
find(n=>e.onlyAudits?.includes(n));if(t)throw new Error(`${t} appears in both skipAudits and onlyAudits`)}function Qoe(e){let t=new Set;for(let n of e){if(Zoe(n),t.has(n.id))throw new Error(`Config defined multiple artifacts with id '${n.id}'`);if(t.add(n.id),!!n.dependencies)for(let[r,{id:a}]of Object.entries(n.dependencies))t.has(a)||i0(n.id,r)}}function EL(e){Qoe(e.artifacts||[]);for(let t of e.audits||[])a0(t);Joe(e.categories,e.audits,e.groups),o0(e.settings)}function i0(e,t){throw new Error([`Failed to find dependency "${t}" for "${e}" artifact`,"Check that...",`  1. A gatherer exposes a matching Symbol that satisfies "${t}".`,`  2. "${t}" is configured to run before "${e}"`].join(`
`))}function TL(e,t){throw new Error([`Dependency "${t}" for "${e}" artifact is invalid.`,"The dependency must be collected before the dependent."].join(`
`))}var s0=y(()=>{"use strict";l();$();Ye();A();s(wL,"isValidArtifactDependency");s(DL,"assertValidPluginName");s(Zoe,"assertValidArtifact");s(a0,"assertValidAudit");s(Joe,"assertValidCategories");s(o0,"assertValidSettings");s(Qoe,"assertValidArtifacts");s(EL,"assertValidConfig");s(i0,"throwInvalidDependencyOrder");s(TL,"throwInvalidArtifactDependency")});function xL(e,t){if(!e)return new Set;t=t||Object.keys(e);let r=t.map(a=>e[a]).flatMap(a=>a?.auditRefs||[]);return new Set(r.map(a=>a.id))}function oie(e,t){if(!e)return null;if(!t)return e;let n=new Map(e.map(o=>[o.id,o])),r=new Set([...aie,...t.flatMap(o=>o.implementation.meta.requiredArtifacts)]),a=0;for(;a!==r.size;){a=r.size;for(let o of r){let i=n.get(o);if(i&&i.dependencies)for(let c of Object.values(i.dependencies))r.add(c.id)}}return e.filter(o=>r.has(o.id))}function iie(e,t){return e?e.filter(n=>n.gatherer.instance.meta.supportedModes.includes(t)):null}function sie(e,t){if(!e)return null;let n=new Set(t.map(r=>r.id).concat(nie));return e.filter(r=>r.implementation.meta.requiredArtifacts.every(o=>n.has(o)))}function cie(e,t){return e?e.filter(n=>{let r=n.implementation.meta;return!r.supportedModes||r.supportedModes.includes(t)}):null}function uie(e,t){if(!e)return null;let n=Object.entries(e).filter(([r,a])=>!a.supportedModes||a.supportedModes.includes(t));return Object.fromEntries(
n)}function lie(e,t){if(!e||!t)return e;let n=Object.entries(e).filter(([r])=>t.includes(r));return Object.fromEntries(n)}function die(e,t){if(t)for(let n of t)e?.[n]||N.warn("config",`unrecognized category in 'onlyCategories': ${n}`)}function SL(e,t){if(!e)return e;let n=new Map(t.map(a=>[a.implementation.meta.id,a.implementation.meta])),r=Object.entries(e).map(([a,o])=>{let i={...o,auditRefs:o.auditRefs.filter(d=>n.has(d.id))},c=i.auditRefs.length<o.auditRefs.length,u=i.auditRefs.every(d=>{let m=n.get(d.id);return m?m.scoreDisplayMode===b.SCORING_MODES.MANUAL:!1});return c&&u&&(i.auditRefs=[]),[a,i]}).filter(a=>typeof a[1]=="object"&&a[1].auditRefs.length);return Object.fromEntries(r)}function CL(e,t){let n=iie(e.artifacts,t),r=cie(e.audits,t),a=sie(r,n||[]),o=uie(e.categories,t),i=SL(o,a||[]);return{...e,artifacts:n,audits:a,categories:i}}function kL(e,t){let{onlyAudits:n,onlyCategories:r,skipAudits:a}=t;die(e.categories,r);let o=xL(e.categories,void 0);r?o=xL(e.categories,r):n?o=new Set:
(!e.categories||!Object.keys(e.categories).length)&&(o=new Set(e.audits?.map(p=>p.implementation.meta.id)));let i=new Set([...o,...n||[],...rie].filter(p=>!a||!a.includes(p))),c=i.size&&e.audits?e.audits.filter(p=>i.has(p.implementation.meta.id)):e.audits,u=SL(e.categories,c||[]),d=lie(u,r),m=oie(e.artifacts,c);return m&&e.settings.disableFullPageScreenshot&&(m=m.filter(({id:p})=>p!=="FullPageScreenshot")),{...e,artifacts:m,audits:c,categories:d}}var tie,nie,rie,aie,FL=y(()=>{"use strict";l();Ae();$();tie={fetchTime:"",LighthouseRunWarnings:"",BenchmarkIndex:"",settings:"",Timing:"",URL:"",PageLoadError:"",HostFormFactor:"",HostUserAgent:"",HostProduct:"",GatherContext:""},nie=Object.keys(tie),rie=[],aie=["Stacks","NetworkUserAgent","FullPageScreenshot"];s(xL,"getAuditIdsInCategories");s(oie,"filterArtifactsByAvailableAudits");s(iie,"filterArtifactsByGatherMode");s(sie,"filterAuditsByAvailableArtifacts");s(cie,"filterAuditsByGatherMode");s(uie,"filterCategoriesByGatherMode");s(lie,"fil\
terCategoriesByExplicitFilters");s(die,"warnOnUnknownOnlyCategories");s(SL,"filterCategoriesByAvailableAudits");s(CL,"filterConfigByGatherMode");s(kL,"filterConfigByExplicitFilters")});function RL(e){return Array.isArray(e)&&e.every(qu)}function qu(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function mie(e){return typeof e!="string"?!1:e==="navigation"||e==="timespan"||e==="snapshot"}function pie(e){return Array.isArray(e)?e.every(mie):!1}function ju(e,t,n=""){n&&(n+=" ");let r=Object.keys(e);if(r.length>0){let a=r.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${a}]`)}}var c0,AL,_L=y(()=>{"use strict";l();A();s(RL,"isArrayOfUnknownObjects");s(qu,"isObjectOfUnknownProperties");s(mie,"objectIsGatherMode");s(pie,"isArrayOfGatherModes");s(ju,"assertNoExcessProperties");c0=class e{static{s(this,"ConfigPlugin")}static _parseAuditsList(t,n){if(t!==void 0){if(!RL(t))throw new Error(`${n} has an invalid audits array.`);return t.map(r=>{let{path:a,...o}=r;if(ju(o,n,"audit"),typeof a!="string")throw new Error(`${n} has a missing audit path.`);return{path:a}})}}static _parseAuditRefsList(t,n){if(!RL(t))throw new Error(`${n} has no valid auditsR\
efs.`);return t.map(r=>{let{id:a,weight:o,group:i,...c}=r;if(ju(c,n,"auditRef"),typeof a!="string")throw new Error(`${n} has an invalid auditRef id.`);if(typeof o!="number")throw new Error(`${n} has an invalid auditRef weight.`);if(typeof i!="string"&&typeof i<"u")throw new Error(`${n} has an invalid auditRef group.`);let u=i&&`${n}-${i}`;return{id:a,weight:o,group:u}})}static _parseCategory(t,n){if(!qu(t))throw new Error(`${n} has no valid category.`);let{title:r,description:a,manualDescription:o,auditRefs:i,supportedModes:c,...u}=t;if(ju(u,n,"category"),!Tr(r))throw new Error(`${n} has an invalid category tile.`);if(!Tr(a)&&a!==void 0)throw new Error(`${n} has an invalid category description.`);if(!Tr(o)&&o!==void 0)throw new Error(`${n} has an invalid category manualDescription.`);if(!pie(c)&&c!==void 0)throw new Error(`${n} supportedModes must be an array, valid array values are "navigation", "timespan", and "snapshot".`);let d=e._parseAuditRefsList(i,n);return{title:r,auditRefs:d,
description:a,manualDescription:o,supportedModes:c}}static _parseGroups(t,n){if(t===void 0)return;if(!qu(t))throw new Error(`${n} groups json is not defined as an object.`);let r=Object.entries(t),a={};return r.forEach(([o,i])=>{if(!qu(i))throw new Error(`${n} has a group not defined as an object.`);let{title:c,description:u,...d}=i;if(ju(d,n,"group"),!Tr(c))throw new Error(`${n} has an invalid group title.`);if(!Tr(u)&&u!==void 0)throw new Error(`${n} has an invalid group description.`);a[`${n}-${o}`]={title:c,description:u}}),a}static parsePlugin(t,n){if(t=JSON.parse(JSON.stringify(t)),!qu(t))throw new Error(`${n} is not defined as an object.`);let{audits:r,category:a,groups:o,...i}=t;return ju(i,n),{audits:e._parseAuditsList(r,n),categories:{[n]:e._parseCategory(a,n)},groups:e._parseGroups(o,n)}}},AL=c0});var IL,NL=y(()=>{"use strict";l();Qr();Gi();IL=`/*! axe v4.9.1
 * Copyright (c) 2015 - 2024 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
!function e(t){var n=t,r=t.document;function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=o||{};function u(e){this.name="SupportError",this.cause=e.cause,this.message="\`".concat(e.cause,"\` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}o.version="4.9.1","function"==typeof define&&define.amd&&define("axe-core",[],(function(){return o})),"object"===("undefined"==typeof module?"undefined":a(module))&&module.exports&&"function"==typeof e.toString&&(o.source="("+e.toString()+')(typeof window === "object" ? window : this);',module.exports=o),"function"==typeof t.getComputedStyle&&(t.axe=o),(u.prototype=Object.create(Error.prototype)).constructor=u;var i=["node"],s=["relatedNodes"],l=["node"],c=["vari\
ant"],d=["matches"],p=["chromium"],f=["noImplicit"],D=["noPresentational"],m=["precision","format","inGamut"],h=["space"],g=["algorithm"],b=["method"],v=["maxDeltaE","deltaEMethod","steps","maxSteps"],y=["node"],F=["environmentData"],w=["environmentData"],E=["environmentData"],C=["environmentData"],x=["environmentData"];function A(e,t,n){t=B(t);var r=e;if((t=k()?Reflect.construct(t,n||[],B(e).constructor):t.apply(e,n))&&("object"===a(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");if(void 0!==(e=r))return e;throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}function k(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(e){}return(k=function(){return!!e})()}function B(e){return(B=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function N(e,t){if("function"!=typeof t\
&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&T(e,t)}function T(e,t){return(T=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}function R(e,t,n){_(e,t),t.set(e,n)}function O(e,t){_(e,t),t.add(e)}function _(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function S(e,t){return e.get(P(e,t))}function M(e,t,n){e.set(P(e,t),n)}function P(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function I(e,t){if(null==e)return{};var n,r=function(e,t){if(null==e)return{};var n,r,a={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],0<=t.indexOf(n)||(a[n]=e[n]);return a}(e,t);if(Object.getOwnPropertySymbols)for(var a=Object.\
getOwnPropertySymbols(e),o=0;o<a.length;o++)n=a[o],0<=t.indexOf(n)||Object.prototype.propertyIsEnumerable.call(e,n)&&(r[n]=e[n]);return r}function j(e){return function(e){if(Array.isArray(e))return X(e)}(e)||L(e)||K(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function L(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function q(){return(q=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n,r=arguments[t];for(n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function z(e,t){return $(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,o,u,i=[],s=!0,l=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;s=!1}else for(;!(s=(r=o.call(n)).done)&&(i.push\
(r.value),i.length!==t);s=!0);}catch(e){l=!0,a=e}finally{try{if(!s&&null!=n.return&&(u=n.return(),Object(u)!==u))return}finally{if(l)throw a}}return i}}(e,t)||K(e,t)||V()}function V(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function $(e){if(Array.isArray(e))return e}function H(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function U(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,W(r.key),r)}}function G(e,t,n){return t&&U(e.prototype,t),n&&U(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function W(e){return e=function(e,t){if("object"!=a(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return String(e);if(n=n.call(e,"string"),"object"==a(n))throw new TypeError("@@toPrimitive must return a primitive value.");return \
n}(e),"symbol"==a(e)?e:e+""}function Y(e,t){var n,r,a,o,u="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(u)return r=!(n=!0),{s:function(){u=u.call(e)},n:function(){var e=u.next();return n=e.done,e},e:function(e){r=!0,a=e},f:function(){try{n||null==u.return||u.return()}finally{if(r)throw a}}};if(Array.isArray(e)||(u=K(e))||t&&e&&"number"==typeof e.length)return u&&(e=u),o=0,{s:t=function(){},n:function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function K(e,t){var n;if(e)return"string"==typeof e?X(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?X(e,t):void 0}function X(e,t){(null==t||t>e.length)&&(t=e.length);for(var \
n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var Z,J,Q,ee,te,ne,re,ae,oe=void 0,ue=void 0;function ie(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function se(e,t){for(var n in t)pe(e,n,{get:t[n],enumerable:!0})}function le(e){return function(e,t,n){if(t&&"object"===a(t)||"function"==typeof t){var r,o=Y(me(t));try{for(o.s();!(r=o.n()).done;)!function(){var a=r.value;De.call(e,a)||"default"===a||pe(e,a,{get:function(){return t[a]},enumerable:!(n=he(t,a))||n.enumerable})}()}catch(e){o.e(e)}finally{o.f()}}return e}((t=pe(null!=e?de(fe(e)):{},"default",e&&e.__esModule&&"default"in e?{get:function(){return e.default},enumerable:!0}:{value:e,enumerable:!0}),pe(t,"__esModule",{value:!0})),e);var t}function ce(e,t,n){(t="symbol"!==a(t)?t+"\
":t)in e?pe(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n}var de=Object.create,pe=Object.defineProperty,fe=Object.getPrototypeOf,De=Object.prototype.hasOwnProperty,me=Object.getOwnPropertyNames,he=Object.getOwnPropertyDescriptor,ge=ie((function(e,t){"use strict";t.exports=function(){}})),be=ie((function(e,t){"use strict";var n=ge()();t.exports=function(e){return e!==n&&null!==e}})),ve=ie((function(e,t){"use strict";var n=be(),r=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return r.call(arguments,(function(e){if(n(e)){var r,a=Object(e),o=t;for(r in a)o[r]=a[r]}})),t}})),ye=ie((function(e,t){"use strict";t.exports=function(){var e=Math.sign;return"function"==typeof e&&1===e(10)&&-1===e(-20)}})),Fe=ie((function(e,t){"use strict";t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}})),we=ie((function(e,t){"use strict";t.exports=ye()()?Math.sign:Fe()})),Ee=ie((function(e,t){"use strict";var n=we(),r=Math.abs,a=Math.floor;t.exp\
orts=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?n(e)*a(r(e)):e}})),Ce=ie((function(e,t){"use strict";var n=Ee(),r=Math.max;t.exports=function(e){return r(0,n(e))}})),xe=ie((function(e,t){"use strict";var n=Ce();t.exports=function(e,t,r){return isNaN(e)?0<=t?r&&t?t-1:t:1:!1!==e&&n(e)}})),Ae=ie((function(e,t){"use strict";t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}})),ke=ie((function(e,t){"use strict";var n=be();t.exports=function(e){if(n(e))return e;throw new TypeError("Cannot use null or undefined")}})),Be=ie((function(e,t){"use strict";var n=Ae(),r=ke(),a=Function.prototype.bind,o=Function.prototype.call,u=Object.keys,i=Object.prototype.propertyIsEnumerable;t.exports=function(e,t){return function(s,l){var c,d=arguments[2],p=arguments[3];return s=Object(r(s)),n(l),c=u(s),p&&c.sort("function"==typeof p?a.call(p,s):void 0),"function"!=typeof e&&(e=c[e]),o.call(e,c,(function(e,n){return i.call(s,e)?o.call(l,d,s[e],e\
,s,n):t}))}}})),Ne=ie((function(e,t){"use strict";t.exports=Be()("forEach")})),Te=ie((function(){})),Re=ie((function(e,t){"use strict";t.exports=function(){var e=Object.assign;return"function"==typeof e&&(e(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}})),Oe=ie((function(e,t){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}})),_e=ie((function(e,t){"use strict";var n=be(),r=Object.keys;t.exports=function(e){return r(n(e)?Object(e):e)}})),Se=ie((function(e,t){"use strict";t.exports=Oe()()?Object.keys:_e()})),Me=ie((function(e,t){"use strict";var n=Se(),r=ke(),a=Math.max;t.exports=function(e,t){var o,u,i,s=a(arguments.length,2);for(e=Object(r(e)),i=function(n){try{e[n]=t[n]}catch(n){o=o||n}},u=1;u<s;++u)n(t=arguments[u]).forEach(i);if(void 0!==o)throw o;return e}})),Pe=ie((function(e,t){"use strict";t.exports=Re()()?Object.assign:Me()})),Ie=ie((function(e,t){"use strict";var n=be(),r={function:!0,object:!0};t.expor\
ts=function(e){return n(e)&&r[a(e)]||!1}})),je=ie((function(e,t){"use strict";var n=Pe(),r=Ie(),a=be(),o=Error.captureStackTrace;t.exports=function(e){e=new Error(e);var u=arguments[1],i=arguments[2];return a(i)||r(u)&&(i=u,u=null),a(i)&&n(e,i),a(u)&&(e.code=u),o&&o(e,t.exports),e}})),Le=ie((function(e,t){"use strict";var n=ke(),r=Object.defineProperty,a=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,u=Object.getOwnPropertySymbols;t.exports=function(e,t){var i,s=Object(n(t));if(e=Object(n(e)),o(s).forEach((function(n){try{r(e,n,a(t,n))}catch(n){i=n}})),"function"==typeof u&&u(s).forEach((function(n){try{r(e,n,a(t,n))}catch(n){i=n}})),void 0!==i)throw i;return e}})),qe=ie((function(e,t){"use strict";function n(e,t){return t}var r,a,o,u,i,s=Ce();try{Object.defineProperty(n,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===n.length?(r={configurable:!0,writable:!1,enumerable:!1},a=Object.defineProperty,t.exports=function(e,t){return t=s(t),e.length==\
=t?e:(r.value=t,a(e,"length",r))}):(u=Le(),i=[],o=function(e){var t,n=0;if(i[e])return i[e];for(t=[];e--;)t.push("a"+(++n).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){if(t=s(t),e.length===t)return e;t=o(t)(e);try{u(t,e)}catch(e){}return t})})),ze=ie((function(e,t){"use strict";t.exports=function(e){return null!=e}})),Ve=ie((function(e,t){"use strict";var n=ze(),r={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!n(e)&&hasOwnProperty.call(r,a(e))}})),$e=ie((function(e,t){"use strict";var n=Ve();t.exports=function(e){if(!n(e))return!1;try{return!!e.constructor&&e.constructor.prototype===e}catch(e){return!1}}})),He=ie((function(e,t){"use strict";var n=$e();t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch\
(e){return!1}return!n(e)}})),Ue=ie((function(e,t){"use strict";var n=He(),r=/^\\s*class[\\s{/}]/,a=Function.prototype.toString;t.exports=function(e){return!!n(e)&&!r.test(a.call(e))}})),Ge=ie((function(e,t){"use strict";var n="razdwatrzy";t.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}})),We=ie((function(e,t){"use strict";var n=String.prototype.indexOf;t.exports=function(e){return-1<n.call(this,e,arguments[1])}})),Ye=ie((function(e,t){"use strict";t.exports=Ge()()?String.prototype.contains:We()})),Ke=ie((function(e,t){"use strict";var n=ze(),r=Ue(),a=Pe(),o=ve(),u=Ye();(t.exports=function(e,t){var r,i,s,l;return arguments.length<2||"string"!=typeof e?(l=t,t=e,e=null):l=arguments[2],n(e)?(r=u.call(e,"c"),i=u.call(e,"e"),s=u.call(e,"w")):i=!(r=s=!0),e={value:t,configurable:r,enumerable:i,writable:s},l?a(o(l),e):e}).gs=function(e,t,i){var s,l;return"string"!=typeof e?(l=i,i=t,t=e,e=null):l=arguments[3],n(t)?r(t)?n(i)?r(i)||(l=i,i=voi\
d 0):i=void 0:(l=t,t=i=void 0):t=void 0,e=n(e)?(s=u.call(e,"c"),u.call(e,"e")):!(s=!0),t={get:t,set:i,configurable:s,enumerable:e},l?a(o(l),t):t}})),Xe=ie((function(e,t){"use strict";var n=Ke(),r=Ae(),o=Function.prototype.apply,u=Function.prototype.call,i=Object.create,s=Object.defineProperty,l=Object.defineProperties,c=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0},p=function(e,t){var n;return r(t),c.call(this,"__ee__")?n=this.__ee__:(n=d.value=i(null),s(this,"__ee__",d),d.value=null),n[e]?"object"===a(n[e])?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},f=function(e,t){var n,a;return r(t),a=this,p.call(this,e,n=function(){D.call(a,e,n),o.call(t,this,arguments)}),n.__eeOnceListener__=t,this},D=function(e,t){var n,o,u,i;if(r(t),c.call(this,"__ee__")&&(n=this.__ee__)[e])if(o=n[e],"object"===a(o))for(i=0;u=o[i];++i)u!==t&&u.__eeOnceListener__!==t||(2===o.length?n[e]=o[i?0:1]:o.splice(i,1));else o!==t&&o.__eeOnceListener__!==t||delete n[e];return this},m=function(e\
){var t,n,r,i,s;if(c.call(this,"__ee__")&&(i=this.__ee__[e]))if("object"===a(i)){for(n=arguments.length,s=new Array(n-1),t=1;t<n;++t)s[t-1]=arguments[t];for(i=i.slice(),t=0;r=i[t];++t)o.call(r,this,s)}else switch(arguments.length){case 1:u.call(i,this);break;case 2:u.call(i,this,arguments[1]);break;case 3:u.call(i,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,s=new Array(n-1),t=1;t<n;++t)s[t-1]=arguments[t];o.call(i,this,s)}},h={on:p,once:f,off:D,emit:m},g={on:n(p),once:n(f),off:n(D),emit:n(m)},b=l({},g);t.exports=e=function(e){return null==e?i(b):l(Object(e),g)},e.methods=h})),Ze=ie((function(e,t){"use strict";t.exports=function(){var e,t=Array.from;return"function"==typeof t&&(e=t(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}})),Je=ie((function(e,t){"use strict";t.exports=function(){return"object"===("undefined"==typeof globalThis?"undefined":a(globalThis))&&!!globalThis&&globalThis.Array===Array}})),Qe=ie((function(e,n){function r(){if("object"===("undefi\
ned"==typeof self?"undefined":a(self))&&self)return self;if("object"===(void 0===t?"undefined":a(t))&&t)return t;throw new Error("Unable to resolve global \`this\`")}n.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()})),et=ie((function(e,t){"use strict";t.exports=Je()()?globalThis:Qe()})),tt=ie((function(e,t){"use strict";var n=et(),r={object:!0,symbol:!0};t.exports=function(){var e,t=n.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!r[a(t.iterator)]&&!!r[a(t.toPrimitive)]&&!!r[a(t.toStringTag)]}})),nt=ie((function(e,t){"use strict";t.exports=function(e){return!!e&&("symbol"===a(e)||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}})),rt=ie((function(e,t){"use strict";var n=nt();t.exports=function(e){if(n(e))return\
 e;throw new TypeError(e+" is not a symbol")}})),at=ie((function(e,t){"use strict";var n=Ke(),r=Object.create,a=Object.defineProperty,o=Object.prototype,u=r(null);t.exports=function(e){for(var t,r,i=0;u[e+(i||"")];)++i;return u[e+=i||""]=!0,a(o,t="@@"+e,n.gs(null,(function(e){r||(r=!0,a(this,t,n(e)),r=!1)}))),t}})),ot=ie((function(e,t){"use strict";var n=Ke(),r=et().Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:n("",r&&r.hasInstance||e("hasInstance")),isConcatSpreadable:n("",r&&r.isConcatSpreadable||e("isConcatSpreadable")),iterator:n("",r&&r.iterator||e("iterator")),match:n("",r&&r.match||e("match")),replace:n("",r&&r.replace||e("replace")),search:n("",r&&r.search||e("search")),species:n("",r&&r.species||e("species")),split:n("",r&&r.split||e("split")),toPrimitive:n("",r&&r.toPrimitive||e("toPrimitive")),toStringTag:n("",r&&r.toStringTag||e("toStringTag")),unscopables:n("",r&&r.unscopables||e("unscopables"))})}})),ut=ie((function(e,t){"use strict";var n=Ke\
(),r=rt(),a=Object.create(null);t.exports=function(e){return Object.defineProperties(e,{for:n((function(t){return a[t]||(a[t]=e(String(t)))})),keyFor:n((function(e){for(var t in r(e),a)if(a[t]===e)return t}))})}})),it=ie((function(e,t){"use strict";var n,r,o,u=Ke(),i=rt(),s=et().Symbol,l=at(),c=ot(),d=ut(),p=Object.create,f=Object.defineProperties,D=Object.defineProperty;if("function"==typeof s)try{String(s()),o=!0}catch(e){}else s=null;r=function(e){if(this instanceof r)throw new TypeError("Symbol is not a constructor");return n(e)},t.exports=n=function e(t){var n;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return o?s(t):(n=p(r.prototype),t=void 0===t?"":String(t),f(n,{__description__:u("",t),__name__:u("",l(t))}))},c(n),d(n),f(r.prototype,{constructor:u(n),toString:u("",(function(){return this.__name__}))}),f(n.prototype,{toString:u((function(){return"Symbol ("+i(this).__description__+")"})),valueOf:u((function(){return i(this)}))}),D(n.prototype,n.toPrimi\
tive,u("",(function(){var e=i(this);return"symbol"===a(e)?e:e.toString()}))),D(n.prototype,n.toStringTag,u("c","Symbol")),D(r.prototype,n.toStringTag,u("c",n.prototype[n.toStringTag])),D(r.prototype,n.toPrimitive,u("c",n.prototype[n.toPrimitive]))})),st=ie((function(e,t){"use strict";t.exports=tt()()?et().Symbol:it()})),lt=ie((function(e,t){"use strict";var n=Object.prototype.toString,r=n.call(function(){return arguments}());t.exports=function(e){return n.call(e)===r}})),ct=ie((function(e,t){"use strict";var n=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&r(n.call(e))}})),dt=ie((function(e,t){"use strict";var n=Object.prototype.toString,r=n.call("");t.exports=function(e){return"string"==typeof e||e&&"object"===a(e)&&(e instanceof String||n.call(e)===r)||!1}})),pt=ie((function(e,t){"use strict";var n=st().iterator,r=lt(),a=ct(),o=Ce(),u=Ae(),i=ke(),s=be(),l=dt(),c=Array.isArray,d=Function.proto\
type.call,p={configurable:!0,enumerable:!0,writable:!0,value:null},f=Object.defineProperty;t.exports=function(e){var t,D,m,h,g,b,v,y,F,w,E=arguments[1],C=arguments[2];if(e=Object(i(e)),s(E)&&u(E),this&&this!==Array&&a(this))t=this;else{if(!E){if(r(e))return 1!==(g=e.length)?Array.apply(null,e):((h=new Array(1))[0]=e[0],h);if(c(e)){for(h=new Array(g=e.length),D=0;D<g;++D)h[D]=e[D];return h}}h=[]}if(!c(e))if(void 0!==(F=e[n])){for(v=u(F).call(e),t&&(h=new t),y=v.next(),D=0;!y.done;)w=E?d.call(E,C,y.value,D):y.value,t?(p.value=w,f(h,D,p)):h[D]=w,y=v.next(),++D;g=D}else if(l(e)){for(g=e.length,t&&(h=new t),m=D=0;D<g;++D)w=e[D],D+1<g&&55296<=(b=w.charCodeAt(0))&&b<=56319&&(w+=e[++D]),w=E?d.call(E,C,w,m):w,t?(p.value=w,f(h,m,p)):h[m]=w,++m;g=m}if(void 0===g)for(g=o(e.length),t&&(h=new t(g)),D=0;D<g;++D)w=E?d.call(E,C,e[D],D):e[D],t?(p.value=w,f(h,D,p)):h[D]=w;return t&&(p.value=null,h.length=g),h}})),ft=ie((function(e,t){"use strict";t.exports=Ze()()?Array.from:pt()})),Dt=ie((function(e,t){"\
use strict";var n=ft(),r=Array.isArray;t.exports=function(e){return r(e)?e:n(e)}})),mt=ie((function(e,t){"use strict";var n=Dt(),r=be(),a=Ae(),o=Array.prototype.slice,u=function(e){return this.map((function(t,n){return t?t(e[n]):e[n]})).concat(o.call(e,this.length))};t.exports=function(e){return(e=n(e)).forEach((function(e){r(e)&&a(e)})),u.bind(e)}})),ht=ie((function(e,t){"use strict";var n=Ae();t.exports=function(e){var t;return"function"==typeof e?{set:e,get:e}:(t={get:n(e.get)},void 0!==e.set?(t.set=n(e.set),e.delete&&(t.delete=n(e.delete)),e.clear&&(t.clear=n(e.clear))):t.set=t.get,t)}})),gt=ie((function(e,t){"use strict";var n=je(),r=qe(),a=Ke(),o=Xe().methods,u=mt(),i=ht(),s=Function.prototype.apply,l=Function.prototype.call,c=Object.create,d=Object.defineProperties,p=o.on,f=o.emit;t.exports=function(e,t,o){var D,m,h,g,b,v,y,F,w,E,C,x=c(null),A=!1!==t?t:isNaN(e.length)?1:e.length;return o.normalizer&&(E=i(o.normalizer),m=E.get,h=E.set,g=E.delete,b=E.clear),null!=o.resolvers&&(C=u\
(o.resolvers)),E=m?r((function(t){var r,a,o=arguments;if(C&&(o=C(o)),null!==(r=m(o))&&hasOwnProperty.call(x,r))return y&&D.emit("get",r,o,this),x[r];if(a=1===o.length?l.call(e,this,o[0]):s.call(e,this,o),null===r){if(null!==(r=m(o)))throw n("Circular invocation","CIRCULAR_INVOCATION");r=h(o)}else if(hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[r]=a,F&&D.emit("set",r,null,a),a}),A):0===t?function(){var t;if(hasOwnProperty.call(x,"data"))return y&&D.emit("get","data",arguments,this),x.data;if(t=arguments.length?s.call(e,this,arguments):l.call(e,this),hasOwnProperty.call(x,"data"))throw n("Circular invocation","CIRCULAR_INVOCATION");return x.data=t,F&&D.emit("set","data",null,t),t}:function(t){var r,a=arguments;if(C&&(a=C(arguments)),r=String(a[0]),hasOwnProperty.call(x,r))return y&&D.emit("get",r,a,this),x[r];if(a=1===a.length?l.call(e,this,a[0]):s.call(e,this,a),hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return\
 x[r]=a,F&&D.emit("set",r,null,a),a},D={original:e,memoized:E,profileName:o.profileName,get:function(e){return C&&(e=C(e)),m?m(e):String(e[0])},has:function(e){return hasOwnProperty.call(x,e)},delete:function(e){var t;hasOwnProperty.call(x,e)&&(g&&g(e),t=x[e],delete x[e],w)&&D.emit("delete",e,t)},clear:function(){var e=x;b&&b(),x=c(null),D.emit("clear",e)},on:function(e,t){return"get"===e?y=!0:"set"===e?F=!0:"delete"===e&&(w=!0),p.call(this,e,t)},emit:f,updateEnv:function(){e=D.original}},o=m?r((function(e){var t=arguments;C&&(t=C(t)),null!==(t=m(t))&&D.delete(t)}),A):0===t?function(){return D.delete("data")}:function(e){return C&&(e=C(arguments)[0]),D.delete(e)},A=r((function(){var e=arguments;return 0===t?x.data:(C&&(e=C(e)),e=m?m(e):String(e[0]),x[e])})),v=r((function(){var e=arguments;return 0===t?D.has("data"):(C&&(e=C(e)),null!==(e=m?m(e):String(e[0]))&&D.has(e))})),d(E,{__memoized__:a(!0),delete:a(o),clear:a(D.clear),_get:a(A),_has:a(v)}),D}})),bt=ie((function(e,t){"use strict";\
var n=Ae(),r=Ne(),a=Te(),o=gt(),u=xe();t.exports=function e(t){var i,s,l;if(n(t),(i=Object(arguments[1])).async&&i.promise)throw new Error("Options 'async' and 'promise' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!i.force?t:(s=u(i.length,t.length,i.async&&a.async),l=o(t,s,i),r(a,(function(e,t){i[t]&&e(i[t],l,i)})),e.__profiler__&&e.__profiler__(l),l.updateEnv(),l.memoized)}})),vt=ie((function(e,t){"use strict";t.exports=function(e){var t,n,r=e.length;if(!r)return"";for(t=String(e[n=0]);--r;)t+=""+e[++n];return t}})),yt=ie((function(e,t){"use strict";t.exports=function(e){return e?function(t){for(var n=String(t[0]),r=0,a=e;--a;)n+=""+t[++r];return n}:function(){return""}}})),Ft=ie((function(e,t){"use strict";t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&!e({})&&e(NaN)&&!e(34)}})),wt=ie((function(e,t){"use strict";t.exports=function(e){return e!=e}})),Et=ie((function(e,t){"use strict";t.exports=Ft()()?Number.isNaN:wt()})),Ct=ie((funct\
ion(e,t){"use strict";var n=Et(),r=Ce(),a=ke(),o=Array.prototype.indexOf,u=Object.prototype.hasOwnProperty,i=Math.abs,s=Math.floor;t.exports=function(e){var t,l,c;if(!n(e))return o.apply(this,arguments);for(l=r(a(this).length),e=arguments[1],t=e=isNaN(e)?0:0<=e?s(e):r(this.length)-s(i(e));t<l;++t)if(u.call(this,t)&&(c=this[t],n(c)))return t;return-1}})),xt=ie((function(e,t){"use strict";var n=Ct(),r=Object.create;t.exports=function(){var e=0,t=[],a=r(null);return{get:function(e){var r,a=0,o=t,u=e.length;if(0===u)return o[u]||null;if(o=o[u]){for(;a<u-1;){if(-1===(r=n.call(o[0],e[a])))return null;o=o[1][r],++a}return-1===(r=n.call(o[0],e[a]))?null:o[1][r]||null}return null},set:function(r){var o,u=0,i=t,s=r.length;if(0===s)i[s]=++e;else{for(i[s]||(i[s]=[[],[]]),i=i[s];u<s-1;)-1===(o=n.call(i[0],r[u]))&&(o=i[0].push(r[u])-1,i[1].push([[],[]])),i=i[1][o],++u;-1===(o=n.call(i[0],r[u]))&&(o=i[0].push(r[u])-1),i[1][o]=++e}return a[e]=r,e},delete:function(e){var r,o=0,u=t,i=a[e],s=i.length,l=[\
];if(0===s)delete u[s];else if(u=u[s]){for(;o<s-1;){if(-1===(r=n.call(u[0],i[o])))return;l.push(u,r),u=u[1][r],++o}if(-1===(r=n.call(u[0],i[o])))return;for(e=u[1][r],u[0].splice(r,1),u[1].splice(r,1);!u[0].length&&l.length;)r=l.pop(),(u=l.pop())[0].splice(r,1),u[1].splice(r,1)}delete a[e]},clear:function(){t=[],a=r(null)}}}})),At=ie((function(e,t){"use strict";var n=Ct();t.exports=function(){var e=0,t=[],r=[];return{get:function(e){return-1===(e=n.call(t,e[0]))?null:r[e]},set:function(n){return t.push(n[0]),r.push(++e),e},delete:function(e){-1!==(e=n.call(r,e))&&(t.splice(e,1),r.splice(e,1))},clear:function(){t=[],r=[]}}}})),kt=ie((function(e,t){"use strict";var n=Ct(),r=Object.create;t.exports=function(e){var t=0,a=[[],[]],o=r(null);return{get:function(t){for(var r,o=0,u=a;o<e-1;){if(-1===(r=n.call(u[0],t[o])))return null;u=u[1][r],++o}return-1!==(r=n.call(u[0],t[o]))&&u[1][r]||null},set:function(r){for(var u,i=0,s=a;i<e-1;)-1===(u=n.call(s[0],r[i]))&&(u=s[0].push(r[i])-1,s[1].push([[\
],[]])),s=s[1][u],++i;return-1===(u=n.call(s[0],r[i]))&&(u=s[0].push(r[i])-1),s[1][u]=++t,o[t]=r,t},delete:function(t){for(var r,u=0,i=a,s=[],l=o[t];u<e-1;){if(-1===(r=n.call(i[0],l[u])))return;s.push(i,r),i=i[1][r],++u}if(-1!==(r=n.call(i[0],l[u]))){for(t=i[1][r],i[0].splice(r,1),i[1].splice(r,1);!i[0].length&&s.length;)r=s.pop(),(i=s.pop())[0].splice(r,1),i[1].splice(r,1);delete o[t]}},clear:function(){a=[[],[]],o=r(null)}}}})),Bt=ie((function(e,t){"use strict";var n=Ae(),r=Ne(),a=Function.prototype.call;t.exports=function(e,t){var o={},u=arguments[2];return n(t),r(e,(function(e,n,r,i){o[n]=a.call(t,u,e,n,r,i)})),o}})),Nt=ie((function(e,t){"use strict";function n(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}function o(e){var t,a,o=r.createTextNode(""),u=0;return new e((function(){var e;if(t)a&&(t=a.concat(t));else{if(!a)return;t=a}if(a=t,t=null,"function"==typeof a)e=a,a=null,e();else for(o.data=u=++u%2;a;)e=a.shift(),a.length||(a=null),e()})).obser\
ve(o,{characterData:!0}),function(e){n(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,o.data=u=++u%2)}}t.exports=function(){if("object"===("undefined"==typeof process?"undefined":a(process))&&process&&"function"==typeof process.nextTick)return process.nextTick;if("function"==typeof queueMicrotask)return function(e){queueMicrotask(n(e))};if("object"===(void 0===r?"undefined":a(r))&&r){if("function"==typeof MutationObserver)return o(MutationObserver);if("function"==typeof WebKitMutationObserver)return o(WebKitMutationObserver)}return"function"==typeof setImmediate?function(e){setImmediate(n(e))}:"function"==typeof setTimeout||"object"===("undefined"==typeof setTimeout?"undefined":a(setTimeout))?function(e){setTimeout(n(e),0)}:null}()})),Tt=ie((function(){"use strict";var e=ft(),t=Bt(),n=Le(),r=qe(),a=Nt(),o=Array.prototype.slice,u=Function.prototype.apply,i=Object.create;Te().async=function(s,l){var c,d,p,f=i(null),D=i(null),m=l.memoized,h=l.original;l.memoized=r((function(e){var t=arg\
uments,n=t[t.length-1];return"function"==typeof n&&(c=n,t=o.call(t,0,-1)),m.apply(d=this,p=t)}),m);try{n(l.memoized,m)}catch(s){}l.on("get",(function(e){var t,n,r;c&&(f[e]?("function"==typeof f[e]?f[e]=[f[e],c]:f[e].push(c),c=null):(t=c,n=d,r=p,c=d=p=null,a((function(){var a;hasOwnProperty.call(D,e)?(a=D[e],l.emit("getasync",e,r,n),u.call(t,a.context,a.args)):(c=t,d=n,p=r,m.apply(n,r))}))))})),l.original=function(){var t,n,r,o;return c?(t=e(arguments),r=c,c=d=p=null,t.push(n=function t(n){var r,i,s=t.id;if(null==s)a(u.bind(t,this,arguments));else if(delete t.id,r=f[s],delete f[s],r)return i=e(arguments),l.has(s)&&(n?l.delete(s):(D[s]={context:this,args:i},l.emit("setasync",s,"function"==typeof r?1:r.length))),"function"==typeof r?o=u.call(r,this,i):r.forEach((function(e){o=u.call(e,this,i)}),this),o}),o=u.call(h,this,t),n.cb=r,c=n,o):u.call(h,this,arguments)},l.on("set",(function(e){c?(f[e]?"function"==typeof f[e]?f[e]=[f[e],c.cb]:f[e].push(c.cb):f[e]=c.cb,delete c.cb,c.id=e,c=null):l.\
delete(e)})),l.on("delete",(function(e){var t;hasOwnProperty.call(f,e)||D[e]&&(t=D[e],delete D[e],l.emit("deleteasync",e,o.call(t.args,1)))})),l.on("clear",(function(){var e=D;D=i(null),l.emit("clearasync",t(e,(function(e){return o.call(e.args,1)})))}))}})),Rt=ie((function(e,t){"use strict";var n=Array.prototype.forEach,r=Object.create;t.exports=function(e){var t=r(null);return n.call(arguments,(function(e){t[e]=!0})),t}})),Ot=ie((function(e,t){"use strict";t.exports=function(e){return"function"==typeof e}})),_t=ie((function(e,t){"use strict";var n=Ot();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}})),St=ie((function(e,t){"use strict";var n=ke(),r=_t();t.exports=function(e){return r(n(e))}})),Mt=ie((function(e,t){"use strict";var n=Ot();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}})),Pt=ie((function(e,t){"use st\
rict";var n=Mt(),r=/[\\n\\r\\u2028\\u2029]/g;t.exports=function(e){return(e=100<(e=n(e)).length?e.slice(0,99)+"…":e).replace(r,(function(e){return JSON.stringify(e).slice(1,-1)}))}})),It=ie((function(e,t){function n(e){return!!e&&("object"===a(e)||"function"==typeof e)&&"function"==typeof e.then}t.exports=n,t.exports.default=n})),jt=ie((function(){"use strict";var e=Bt(),t=Rt(),n=St(),r=Pt(),a=It(),o=Nt(),u=Object.create,i=t("then","then:finally","done","done:finally");Te().promise=function(t,s){var l=u(null),c=u(null),d=u(null);if(!0===t)t=null;else if(t=n(t),!i[t])throw new TypeError("'"+r(t)+"' is not valid promise mode");s.on("set",(function(e,n,r){var u=!1;if(a(r)){l[e]=1,d[e]=r;var i=function(t){var n=l[e];if(u)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in 'done:finally' mode)\\nConsider to rely on 'then' or 'done' mode instead.");n&&(delete l[e],c[e]=t,s.emit("setasync",e\
,n))},p=function(){u=!0,l[e]&&(delete l[e],delete d[e],s.delete(e))},f=t;if("then"===(f=f||"then")){var D=function(){o(p)};"function"==typeof(r=r.then((function(e){o(i.bind(this,e))}),D)).finally&&r.finally(D)}else if("done"===f){if("function"!=typeof r.done)throw new Error("Memoizee error: Retrieved promise does not implement 'done' in 'done' mode");r.done(i,p)}else if("done:finally"===f){if("function"!=typeof r.done)throw new Error("Memoizee error: Retrieved promise does not implement 'done' in 'done:finally' mode");if("function"!=typeof r.finally)throw new Error("Memoizee error: Retrieved promise does not implement 'finally' in 'done:finally' mode");r.done(i),r.finally(p)}}else c[e]=r,s.emit("setasync",e,1)})),s.on("get",(function(e,t,n){var r,u;l[e]?++l[e]:(r=d[e],u=function(){s.emit("getasync",e,t,n)},a(r)?"function"==typeof r.done?r.done(u):r.then((function(){o(u)})):u())})),s.on("delete",(function(e){var t;delete d[e],l[e]?delete l[e]:hasOwnProperty.call(c,e)&&(t=c[e],delete c[e\
],s.emit("deleteasync",e,[t]))})),s.on("clear",(function(){var t=c;c=u(null),l=u(null),d=u(null),s.emit("clearasync",e(t,(function(e){return[e]})))}))}})),Lt=ie((function(){"use strict";var e=Ae(),t=Ne(),n=Te(),r=Function.prototype.apply;n.dispose=function(a,o,u){var i;e(a),u.async&&n.async||u.promise&&n.promise?(o.on("deleteasync",i=function(e,t){r.call(a,null,t)}),o.on("clearasync",(function(e){t(e,(function(e,t){i(t,e)}))}))):(o.on("delete",i=function(e,t){a(t)}),o.on("clear",(function(e){t(e,(function(e,t){i(t,e)}))})))}})),qt=ie((function(e,t){"use strict";t.exports=2147483647})),zt=ie((function(e,t){"use strict";var n=Ce(),r=qt();t.exports=function(e){if(e=n(e),r<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}})),Vt=ie((function(){"use strict";var e=ft(),t=Ne(),n=Nt(),r=It(),a=zt(),o=Te(),u=Function.prototype,i=Math.max,s=Math.min,l=Object.create;o.maxAge=function(c,d,p){var f,D,m,h;(c=a(c))&&(f=l(null),D=p.async&&o.async||p.promise&&o.promise?"async":"",d.\
on("set"+D,(function(e){f[e]=setTimeout((function(){d.delete(e)}),c),"function"==typeof f[e].unref&&f[e].unref(),h&&(h[e]&&"nextTick"!==h[e]&&clearTimeout(h[e]),h[e]=setTimeout((function(){delete h[e]}),m),"function"==typeof h[e].unref)&&h[e].unref()})),d.on("delete"+D,(function(e){clearTimeout(f[e]),delete f[e],h&&("nextTick"!==h[e]&&clearTimeout(h[e]),delete h[e])})),p.preFetch&&(m=!0===p.preFetch||isNaN(p.preFetch)?.333:i(s(Number(p.preFetch),1),0))&&(h={},m=(1-m)*c,d.on("get"+D,(function(t,a,o){h[t]||(h[t]="nextTick",n((function(){var n;"nextTick"===h[t]&&(delete h[t],d.delete(t),p.async&&(a=e(a)).push(u),n=d.memoized.apply(o,a),p.promise)&&r(n)&&("function"==typeof n.done?n.done(u,u):n.then(u,u))})))}))),d.on("clear"+D,(function(){t(f,(function(e){clearTimeout(e)})),f={},h&&(t(h,(function(e){"nextTick"!==e&&clearTimeout(e)})),h={})})))}})),$t=ie((function(e,t){"use strict";var n=Ce(),r=Object.create,a=Object.prototype.hasOwnProperty;t.exports=function(e){var t,o=0,u=1,i=r(null),s=\
r(null),l=0;return e=n(e),{hit:function(n){var r=s[n],c=++l;if(i[c]=n,s[n]=c,!r)return++o<=e?void 0:(n=i[u],t(n),n);if(delete i[r],u===r)for(;!a.call(i,++u););},delete:t=function(e){var t=s[e];if(t&&(delete i[t],delete s[e],--o,u===t))if(o)for(;!a.call(i,++u););else l=0,u=1},clear:function(){o=0,u=1,i=r(null),s=r(null),l=0}}}})),Ht=ie((function(){"use strict";var e=Ce(),t=$t(),n=Te();n.max=function(r,a,o){var u;(r=e(r))&&(u=t(r),r=o.async&&n.async||o.promise&&n.promise?"async":"",a.on("set"+r,o=function(e){void 0!==(e=u.hit(e))&&a.delete(e)}),a.on("get"+r,o),a.on("delete"+r,u.delete),a.on("clear"+r,u.clear))}})),Ut=ie((function(){"use strict";var e=Ke(),t=Te(),n=Object.create,r=Object.defineProperties;t.refCounter=function(a,o,u){var i=n(null);u=u.async&&t.async||u.promise&&t.promise?"async":"";o.on("set"+u,(function(e,t){i[e]=t||1})),o.on("get"+u,(function(e){++i[e]})),o.on("delete"+u,(function(e){delete i[e]})),o.on("clear"+u,(function(){i={}})),r(o.memoized,{deleteRef:e((function(){\
var e=o.get(arguments);return null!==e&&i[e]?!--i[e]&&(o.delete(e),!0):null})),getRefCount:e((function(){var e=o.get(arguments);return null!==e&&i[e]||0}))})}})),Gt=ie((function(e,t){"use strict";var n=ve(),r=xe(),a=bt();t.exports=function(e){var t,o=n(arguments[1]);return o.normalizer||0!==(t=o.length=r(o.length,e.length,o.async))&&(o.primitive?!1===t?o.normalizer=vt():1<t&&(o.normalizer=yt()(t)):o.normalizer=!1===t?xt()():1===t?At()():kt()(t)),o.async&&Tt(),o.promise&&jt(),o.dispose&&Lt(),o.maxAge&&Vt(),o.max&&Ht(),o.refCounter&&Ut(),a(e,o)}})),Wt=ie((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.isIdentStart=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"-"===e||"_"===e},e.isIdent=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"0"<=e&&e<="9"||"-"===e||"_"===e},e.isHex=function(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"},e.escapeIdentifier=function(t){for(var n=t.length,r="",a=0;a<n;){var o=t.charAt(a);if(e.identSpecialChars[o])r+="\\\\\
"+o;else if("_"===o||"-"===o||"A"<=o&&o<="Z"||"a"<=o&&o<="z"||0!==a&&"0"<=o&&o<="9")r+=o;else{if(55296==(63488&(o=o.charCodeAt(0)))){var u=t.charCodeAt(a++);if(55296!=(64512&o)||56320!=(64512&u))throw Error("UCS-2(decode): illegal sequence");o=((1023&o)<<10)+(1023&u)+65536}r+="\\\\"+o.toString(16)+" "}a++}return r},e.escapeStr=function(t){for(var n,r=t.length,a="",o=0;o<r;){var u=t.charAt(o);'"'===u?u='\\\\"':"\\\\"===u?u="\\\\\\\\":void 0!==(n=e.strReplacementsRev[u])&&(u=n),a+=u,o++}return'"'+a+'"'},e.identSpecialChars={"!":!0,'"':!0,"#":!0,$:!0,"%":!0,"&":!0,"'":!0,"(":!0,")":!0,"*":!0,"+":!0,",":!0,".":!0,"/":!0,";":!0,"<":!0,"=":!0,">":!0,"?":!0,"@":!0,"[":!0,"\\\\":!0,"]":!0,"^":!0,"\`":!0,"{":!0,"|":!0,"}":!0,"~":!0},e.strReplacementsRev={"\\n":"\\\\n","\\r":"\\\\r","\\t":"\\\\t","\\f":"\\\\f","\\v":"\\\\v"},e.singleQuoteEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\","'":"'"},e.doubleQuotesEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\",'"':'"'}})),Yt=ie((function(e){"use strict";Object.defineProper\
ty(e,"__esModule",{value:!0});var t=Wt();e.parseCssSelector=function(e,n,r,a,o,u){var i=e.length,s="";function l(r,a){var o="";for(n++,s=e.charAt(n);n<i;){if(s===r)return n++,o;var u;if("\\\\"===s)if(n++,(s=e.charAt(n))===r)o+=r;else if(void 0!==(u=a[s]))o+=u;else{if(t.isHex(s)){var l=s;for(n++,s=e.charAt(n);t.isHex(s);)l+=s,n++,s=e.charAt(n);" "===s&&(n++,s=e.charAt(n)),o+=String.fromCharCode(parseInt(l,16));continue}o+=s}else o+=s;n++,s=e.charAt(n)}return o}function c(){var r="";for(s=e.charAt(n);n<i;){if(!t.isIdent(s)){if("\\\\"!==s)return r;if(i<=++n)throw Error("Expected symbol but end of file reached.");if(s=e.charAt(n),!t.identSpecialChars[s]&&t.isHex(s)){var a=s;for(n++,s=e.charAt(n);t.isHex(s);)a+=s,n++,s=e.charAt(n);" "===s&&(n++,s=e.charAt(n)),r+=String.fromCharCode(parseInt(a,16));continue}}r+=s,n++,s=e.charAt(n)}return r}function d(){for(s=e.charAt(n);" "===s||"\\t"===s||"\\n"===s||"\\r"===s||"\\f"===s;)n++,s=e.charAt(n)}function p(){var t=f();if(!t)return null;var r=t;for(s=e.cha\
rAt(n);","===s;){if(n++,d(),"selectors"!==r.type&&(r={type:"selectors",selectors:[t]}),!(t=f()))throw Error('Rule expected after ",".');r.selectors.push(t)}return r}function f(){d();var t={type:"ruleSet"},r=D();if(!r)return null;for(var a=t;r&&(r.type="rule",a.rule=r,a=r,d(),s=e.charAt(n),!(i<=n||","===s||")"===s));)if(o[s]){var u=s;if(n++,d(),!(r=D()))throw Error('Rule expected after "'+u+'".');r.nestingOperator=u}else(r=D())&&(r.nestingOperator=null);return t}function D(){for(var o=null;n<i;)if("*"===(s=e.charAt(n)))n++,(o=o||{}).tagName="*";else if(t.isIdentStart(s)||"\\\\"===s)(o=o||{}).tagName=c();else if("."===s)n++,((o=o||{}).classNames=o.classNames||[]).push(c());else if("#"===s)n++,(o=o||{}).id=c();else if("["===s){n++,d();var f={name:c()};if(d(),"]"===s)n++;else{var D="";if(a[s]&&(D=s,n++,s=e.charAt(n)),i<=n)throw Error('Expected "=" but end of file reached.');if("="!==s)throw Error('Expected "=" but "'+s+'" found.');f.operator=D+"=",n++,d();var m="";if(f.valueType="string",'"'\
===s)m=l('"',t.doubleQuotesEscapeChars);else if("'"===s)m=l("'",t.singleQuoteEscapeChars);else if(u&&"$"===s)n++,m=c(),f.valueType="substitute";else{for(;n<i&&"]"!==s;)m+=s,n++,s=e.charAt(n);m=m.trim()}if(d(),i<=n)throw Error('Expected "]" but end of file reached.');if("]"!==s)throw Error('Expected "]" but "'+s+'" found.');n++,f.value=m}((o=o||{}).attrs=o.attrs||[]).push(f)}else{if(":"!==s)break;if(n++,f={name:D=c()},"("===s){n++;var h="";if(d(),"selector"===r[D])f.valueType="selector",h=p();else{if(f.valueType=r[D]||"string",'"'===s)h=l('"',t.doubleQuotesEscapeChars);else if("'"===s)h=l("'",t.singleQuoteEscapeChars);else if(u&&"$"===s)n++,h=c(),f.valueType="substitute";else{for(;n<i&&")"!==s;)h+=s,n++,s=e.charAt(n);h=h.trim()}d()}if(i<=n)throw Error('Expected ")" but end of file reached.');if(")"!==s)throw Error('Expected ")" but "'+s+'" found.');n++,f.value=h}((o=o||{}).pseudos=o.pseudos||[]).push(f)}return o}var m=p();if(n<i)throw Error('Rule expected but "'+e.charAt(n)+'" found.');\
return m}})),Kt=ie((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=Wt();e.renderEntity=function e(n){var r="";switch(n.type){case"ruleSet":for(var a=n.rule,o=[];a;)a.nestingOperator&&o.push(a.nestingOperator),o.push(e(a)),a=a.rule;r=o.join(" ");break;case"selectors":r=n.selectors.map(e).join(", ");break;case"rule":n.tagName&&(r="*"===n.tagName?"*":t.escapeIdentifier(n.tagName)),n.id&&(r+="#"+t.escapeIdentifier(n.id)),n.classNames&&(r+=n.classNames.map((function(e){return"."+t.escapeIdentifier(e)})).join("")),n.attrs&&(r+=n.attrs.map((function(e){return"operator"in e?"substitute"===e.valueType?"["+t.escapeIdentifier(e.name)+e.operator+"$"+e.value+"]":"["+t.escapeIdentifier(e.name)+e.operator+t.escapeStr(e.value)+"]":"["+t.escapeIdentifier(e.name)+"]"})).join("")),n.pseudos&&(r+=n.pseudos.map((function(n){return n.valueType?"selector"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+e(n.value)+")":"substitute"===n.valueType?":"+t.escapeIdentifier(n.name)+\
"($"+n.value+")":"numeric"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+n.value+")":":"+t.escapeIdentifier(n.name)+"("+t.escapeIdentifier(n.value)+")":":"+t.escapeIdentifier(n.name)})).join(""));break;default:throw Error('Unknown entity type: "'+n.type+'".')}return r}})),Xt=ie((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=Yt(),n=Kt();function r(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}r.prototype.registerSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.pseudos[r[n]]="selector";return this},r.prototype.unregisterSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.pseudos[r[n]];return this},r.prototype.registerNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.pseudos[r[n]]="nume\
ric";return this},r.prototype.unregisterNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.pseudos[r[n]];return this},r.prototype.registerNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.ruleNestingOperators[r[n]]=!0;return this},r.prototype.unregisterNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.ruleNestingOperators[r[n]];return this},r.prototype.registerAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.attrEqualityMods[r[n]]=!0;return this},r.prototype.unregisterAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.attrEqualityMods[r[n]];return this},r.prototype.enableSubstitutes=function(){return this.substitut\
esEnabled=!0,this},r.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this},r.prototype.parse=function(e){return t.parseCssSelector(e,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled)},r.prototype.render=function(e){return n.renderEntity(e).trim()},e.CssSelectorParser=r})),Zt=ie((function(e,o){var u;u=function(){"use strict";function e(e){return"function"==typeof e}var o=Array.isArray||function(e){return"[object Array]"===Object.prototype.toString.call(e)},u=0,i=void 0,s=void 0,l=function(e,t){m[u]=e,m[u+1]=t,2===(u+=2)&&(s?s(h):y())},c=void 0!==t?t:void 0,d=(d=c||{}).MutationObserver||d.WebKitMutationObserver,p="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),f="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function D(){var e=setTimeout;return function(){return e(h,1)}}var m=new Array(1e3);function h(){for(var\
 e=0;e<u;e+=2)(0,m[e])(m[e+1]),m[e]=void 0,m[e+1]=void 0;u=0}var g,b,v,y=void 0;function F(e,t){var n,r=this,a=new this.constructor(C),o=(void 0===a[E]&&I(a),r._state);return o?(n=arguments[o-1],l((function(){return M(o,a,n,r._result)}))):_(r,a,e,t),a}function w(e){var t;return e&&"object"===a(e)&&e.constructor===this?e:(N(t=new this(C),e),t)}y=p?function(){return process.nextTick(h)}:d?(b=0,p=new d(h),v=r.createTextNode(""),p.observe(v,{characterData:!0}),function(){v.data=b=++b%2}):f?((g=new MessageChannel).port1.onmessage=h,function(){return g.port2.postMessage(0)}):(void 0===c?function(){try{var e=Function("return this")().require("vertx");return void 0!==(i=e.runOnLoop||e.runOnContext)?function(){i(h)}:D()}catch(e){return D()}}:D)();var E=Math.random().toString(36).substring(2);function C(){}var x=void 0,A=1,k=2;function B(t,n,r){var a,o;n.constructor===t.constructor&&r===F&&n.constructor.resolve===w?(a=t,(o=n)._state===A?R(a,o._result):o._state===k?O(a,o._result):_(o,void 0,(func\
tion(e){return N(a,e)}),(function(e){return O(a,e)}))):void 0!==r&&e(r)?function(e,t,n){l((function(e){var r=!1,a=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(n,t,(function(n){r||(r=!0,(t!==n?N:R)(e,n))}),(function(t){r||(r=!0,O(e,t))}),e._label);!r&&a&&(r=!0,O(e,a))}),e)}(t,n,r):R(t,n)}function N(e,t){if(e===t)O(e,new TypeError("You cannot resolve a promise with itself"));else if(r=a(n=t),null===n||"object"!==r&&"function"!==r)R(e,t);else{n=void 0;try{n=t.then}catch(t){return void O(e,t)}B(e,t,n)}var n,r}function T(e){e._onerror&&e._onerror(e._result),S(e)}function R(e,t){e._state===x&&(e._result=t,e._state=A,0!==e._subscribers.length)&&l(S,e)}function O(e,t){e._state===x&&(e._state=k,e._result=t,l(T,e))}function _(e,t,n,r){var a=e._subscribers,o=a.length;e._onerror=null,a[o]=t,a[o+A]=n,a[o+k]=r,0===o&&e._state&&l(S,e)}function S(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,a=void 0,o=e._result,u=0;u<t.length;u+=3)r=t[u],a=t[u+n],r?M(n,r,a,o):a(o);e._subscr\
ibers.length=0}}function M(t,n,r,a){var o=e(r),u=void 0,i=void 0,s=!0;if(o){try{u=r(a)}catch(t){s=!1,i=t}if(n===u)return void O(n,new TypeError("A promises callback cannot return that same promise."))}else u=a;n._state===x&&(o&&s?N(n,u):!1===s?O(n,i):t===A?R(n,u):t===k&&O(n,u))}var P=0;function I(e){e[E]=P++,e._state=void 0,e._result=void 0,e._subscribers=[]}L.prototype._enumerate=function(e){for(var t=0;this._state===x&&t<e.length;t++)this._eachEntry(e[t],t)},L.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,r=n.resolve;if(r===w){var a,o=void 0,u=void 0,i=!1;try{o=e.then}catch(t){i=!0,u=t}o===F&&e._state!==x?this._settledAt(e._state,t,e._result):"function"!=typeof o?(this._remaining--,this._result[t]=e):n===q?(a=new n(C),i?O(a,u):B(a,e,o),this._willSettleAt(a,t)):this._willSettleAt(new n((function(t){return t(e)})),t)}else this._willSettleAt(r(e),t)},L.prototype._settledAt=function(e,t,n){var r=this.promise;r._state===x&&(this._remaining--,e===k?O(r,n):this._result[\
t]=n),0===this._remaining&&R(r,this._result)},L.prototype._willSettleAt=function(e,t){var n=this;_(e,void 0,(function(e){return n._settledAt(A,t,e)}),(function(e){return n._settledAt(k,t,e)}))};var j=L;function L(e,t){this._instanceConstructor=e,this.promise=new e(C),this.promise[E]||I(this.promise),o(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0!==this.length&&(this.length=this.length||0,this._enumerate(t),0!==this._remaining)||R(this.promise,this._result)):O(this.promise,new Error("Array Methods must be provided an Array"))}z.prototype.catch=function(e){return this.then(null,e)},z.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)};var q=z;function z(e){if(this[E]=P++,this._result=this._state=void 0,this._subscribers=[],C!==e){if("function"!=typeof e)throw new TypeError("You\
 must pass a resolver function as the first argument to the promise constructor");if(!(this instanceof z))throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");var t=this;try{e((function(e){N(t,e)}),(function(e){O(t,e)}))}catch(e){O(t,e)}}}return q.prototype.then=F,q.all=function(e){return new j(this,e).promise},q.race=function(e){var t=this;return o(e)?new t((function(n,r){for(var a=e.length,o=0;o<a;o++)t.resolve(e[o]).then(n,r)})):new t((function(e,t){return t(new TypeError("You must pass an array to race."))}))},q.resolve=w,q.reject=function(e){var t=new this(C);return O(t,e),t},q._setScheduler=function(e){s=e},q._setAsap=function(e){l=e},q._asap=l,q.polyfill=function(){var e=void 0;if(void 0!==n)e=n;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){\
var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=q},q.Promise=q},"object"===a(e)&&void 0!==o?o.exports=u():"function"==typeof define&&define.amd?define(u):e.ES6Promise=u()})),Jt=ie((function(e){var t,n,r=1e5,o=(t=Object.prototype.toString,n=Object.prototype.hasOwnProperty,{Class:function(e){return t.call(e).replace(/^\\[object *|\\]$/g,"")},HasProperty:function(e,t){return t in e},HasOwnProperty:function(e,t){return n.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return e>>0},ToUint32:function(e){return e>>>0}}),u=Math.LN2,i=Math.abs,s=Math.floor,l=Math.log,c=Math.min,d=Math.pow,p=Math.round;function f(e,t,n){return e<t?t:n<e?n:e}var D,m,h,g,b,v,y,F,w,E,C,x=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,n=[];for(t in e)o.HasOwnProperty(e,t)&&n.push(t);return n};function A(e){if(x&&D)for(var t=x\
(e),n=0;n<t.length;n+=1)D(e,t[n],{value:e[t[n]],writable:!1,enumerable:!1,configurable:!1})}function k(e){if(D){if(e.length>r)throw new RangeError("Array too large for polyfill");for(var t=0;t<e.length;t+=1)!function(t){D(e,t,{get:function(){return e._getter(t)},set:function(n){e._setter(t,n)},enumerable:!0,configurable:!1})}(t)}}function B(e,t){return e<<(t=32-t)>>t}function N(e,t){return e<<(t=32-t)>>>t}function T(e){return N(e[0],8)}function R(e,t,n){var r,a,o,p,f,D,m,h=(1<<t-1)-1;function g(e){var t=s(e);return(e=e-t)<.5||!(.5<e||t%2)?t:t+1}for(e!=e?(a=(1<<t)-1,o=d(2,n-1),r=0):e===1/0||e===-1/0?(a=(1<<t)-1,r=e<(o=0)?1:0):0===e?r=1/e==-1/(o=a=0)?1:0:(r=e<0,(e=i(e))>=d(2,1-h)?(a=c(s(l(e)/u),1023),2<=(o=g(e/d(2,a)*d(2,n)))/d(2,n)&&(a+=1,o=1),h<a?(a=(1<<t)-1,o=0):(a+=h,o-=d(2,n))):(a=0,o=g(e/d(2,1-h-n)))),f=[],p=n;p;--p)f.push(o%2?1:0),o=s(o/2);for(p=t;p;--p)f.push(a%2?1:0),a=s(a/2);for(f.push(r?1:0),f.reverse(),D=f.join(""),m=[];D.length;)m.push(parseInt(D.substring(0,8),2)),D=D.subst\
ring(8);return m}function O(e,t,n){for(var r,a,o,u,i,s,l=[],c=e.length;c;--c)for(a=e[c-1],r=8;r;--r)l.push(a%2?1:0),a>>=1;return l.reverse(),s=l.join(""),o=(1<<t-1)-1,u=parseInt(s.substring(0,1),2)?-1:1,i=parseInt(s.substring(1,1+t),2),s=parseInt(s.substring(1+t),2),i===(1<<t)-1?0===s?1/0*u:NaN:0<i?u*d(2,i-o)*(1+s/d(2,n)):0!==s?u*d(2,-(o-1))*(s/d(2,n)):u<0?-0:0}function _(e){if((e=o.ToInt32(e))<0)throw new RangeError("ArrayBuffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;A(this)}function S(){}function M(e,t,n){var r=function(e,t,n){var u,i,s,l;if(arguments.length&&"number"!=typeof e)if("object"===a(e)&&e.constructor===r)for(this.length=(u=e).length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(this.byteLength),s=this.byteOffset=0;s<this.length;s+=1)this._setter(s,u._getter(s));else if("object"!==a(e)||e instanceof _||"ArrayBuffer"===o.Class(e)){if("obje\
ct"!==a(e)||!(e instanceof _||"ArrayBuffer"===o.Class(e)))throw new TypeError("Unexpected argument type(s)");if(this.buffer=e,this.byteOffset=o.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=o.ToUint32(n),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(this.length=o.ToUint32((i=e).length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(\
this.byteLength),s=this.byteOffset=0;s<this.length;s+=1)l=i[s],this._setter(s,Number(l));else{if(this.length=o.ToInt32(e),n<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(this.byteLength),this.byteOffset=0}this.constructor=r,A(this),k(this)};return(r.prototype=new S).BYTES_PER_ELEMENT=e,r.prototype._pack=t,r.prototype._unpack=n,r.BYTES_PER_ELEMENT=e,r.prototype.get=r.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if(!((e=o.ToUint32(e))>=this.length)){for(var t=[],n=0,r=this.byteOffset+e*this.BYTES_PER_ELEMENT;n<this.BYTES_PER_ELEMENT;n+=1,r+=1)t.push(this.buffer._bytes[r]);return this._unpack(t)}},r.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if((e=o.ToUint32(e))<this.length)for(var n=this._pack(t),r=0,a=this.byteOffset+e*this.BYTES_PER_ELEMENT;r<this.BYTES_PER_ELEMENT;r+=1,\
a+=1)this.buffer._bytes[a]=n[r]},r.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var n,r,u,i,s,l,c,d,p,f;if("object"===a(e)&&e.constructor===this.constructor){if(n=e,(u=o.ToUint32(t))+n.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(d=this.byteOffset+u*this.BYTES_PER_ELEMENT,p=n.length*this.BYTES_PER_ELEMENT,n.buffer===this.buffer){for(f=[],s=0,l=n.byteOffset;s<p;s+=1,l+=1)f[s]=n.buffer._bytes[l];for(s=0,c=d;s<p;s+=1,c+=1)this.buffer._bytes[c]=f[s]}else for(s=0,l=n.byteOffset,c=d;s<p;s+=1,l+=1,c+=1)this.buffer._bytes[c]=n.buffer._bytes[l]}else{if("object"!==a(e)||void 0===e.length)throw new TypeError("Unexpected argument type(s)");if(i=o.ToUint32((r=e).length),(u=o.ToUint32(t))+i>this.length)throw new RangeError("Offset plus length of array is out of range");for(s=0;s<i;s+=1)l=r[s],this._setter(u+s,Number(l))}},r.prototype.subarray=function(e,t){e=o.ToInt32(e),t=o.ToInt32(t),arguments.length<1&\
&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=f(e,0,this.length);var n=(t=f(t,0,this.length))-e;return new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,n=n<0?0:n)},r}function P(e,t){return o.IsCallable(e.get)?e.get(t):e[t]}function I(t,n,r){if(0===arguments.length)t=new e.ArrayBuffer(0);else if(!(t instanceof e.ArrayBuffer||"ArrayBuffer"===o.Class(t)))throw new TypeError("TypeError");if(this.buffer=t||new e.ArrayBuffer(0),this.byteOffset=o.ToUint32(n),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:o.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");A(this)}function j(t){return function(n,r){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range")\
;n+=this.byteOffset;for(var a=new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT),u=[],i=0;i<t.BYTES_PER_ELEMENT;i+=1)u.push(P(a,i));return Boolean(r)===Boolean(C)&&u.reverse(),P(new t(new e.Uint8Array(u).buffer),0)}}function L(t){return function(n,r,a){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");r=new t([r]);for(var u=new e.Uint8Array(r.buffer),i=[],s=0;s<t.BYTES_PER_ELEMENT;s+=1)i.push(P(u,s));Boolean(a)===Boolean(C)&&i.reverse(),new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT).set(i)}}D=Object.defineProperty&&function(){try{return Object.defineProperty({},"x",{}),1}catch(e){}}()?Object.defineProperty:function(e,t,n){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return o.HasProperty(n,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,n.get),o.HasProperty(n,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,n.set)\
,o.HasProperty(n,"value")&&(e[t]=n.value),e},e.ArrayBuffer=e.ArrayBuffer||_,E=M(1,(function(e){return[255&e]}),(function(e){return B(e[0],8)})),m=M(1,(function(e){return[255&e]}),T),h=M(1,(function(e){return[(e=p(Number(e)))<0?0:255<e?255:255&e]}),T),g=M(2,(function(e){return[e>>8&255,255&e]}),(function(e){return B(e[0]<<8|e[1],16)})),b=M(2,(function(e){return[e>>8&255,255&e]}),(function(e){return N(e[0]<<8|e[1],16)})),v=M(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return B(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),y=M(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return N(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),F=M(4,(function(e){return R(e,8,23)}),(function(e){return O(e,8,23)})),w=M(8,(function(e){return R(e,11,52)}),(function(e){return O(e,11,52)})),e.Int8Array=e.Int8Array||E,e.Uint8Array=e.Uint8Array||m,e.Uint8ClampedArray=e.Uint8ClampedArray||h,e.Int16Array=e.Int16Array||g,e.Uint16Array=e.Uint16Array||b,e.Int32Array=e.Int32Array|\
|v,e.Uint32Array=e.Uint32Array||y,e.Float32Array=e.Float32Array||F,e.Float64Array=e.Float64Array||w,E=new e.Uint16Array([4660]),C=18===P(new e.Uint8Array(E.buffer),0),I.prototype.getUint8=j(e.Uint8Array),I.prototype.getInt8=j(e.Int8Array),I.prototype.getUint16=j(e.Uint16Array),I.prototype.getInt16=j(e.Int16Array),I.prototype.getUint32=j(e.Uint32Array),I.prototype.getInt32=j(e.Int32Array),I.prototype.getFloat32=j(e.Float32Array),I.prototype.getFloat64=j(e.Float64Array),I.prototype.setUint8=L(e.Uint8Array),I.prototype.setInt8=L(e.Int8Array),I.prototype.setUint16=L(e.Uint16Array),I.prototype.setInt16=L(e.Int16Array),I.prototype.setUint32=L(e.Uint32Array),I.prototype.setInt32=L(e.Int32Array),I.prototype.setFloat32=L(e.Float32Array),I.prototype.setFloat64=L(e.Float64Array),e.DataView=e.DataView||I})),Qt=ie((function(e){!function(e){"use strict";var t,n,r;function o(){if(void 0===this)throw new TypeError("Constructor WeakMap requires 'new'");if(r(this,"_id","_WeakMap_"+i()+"."+i()),0<argumen\
ts.length)throw new TypeError("WeakMap iterable is not supported")}function u(e,n){if(!s(e)||!t.call(e,"_id"))throw new TypeError(n+" method called on incompatible receiver "+a(e))}function i(){return Math.random().toString().substring(2)}function s(e){return Object(e)===e}e.WeakMap||(t=Object.prototype.hasOwnProperty,n=Object.defineProperty&&function(){try{return 1===Object.defineProperty({},"x",{value:1}).x}catch(e){}}(),e.WeakMap=((r=function(e,t,r){n?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:r}):e[t]=r})(o.prototype,"delete",(function(e){var t;return u(this,"delete"),!!s(e)&&!(!(t=e[this._id])||t[0]!==e||(delete e[this._id],0))})),r(o.prototype,"get",(function(e){var t;return u(this,"get"),s(e)&&(t=e[this._id])&&t[0]===e?t[1]:void 0})),r(o.prototype,"has",(function(e){var t;return u(this,"has"),!!s(e)&&!(!(t=e[this._id])||t[0]!==e)})),r(o.prototype,"set",(function(e,t){var n;if(u(this,"set"),s(e))return(n=e[this._id])&&n[0]===e?n[1]=t:r(e,this._id,[e,t]),this;thr\
ow new TypeError("Invalid value used as weak map key")})),r(o,"_polyfill",!0),o))}("undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:void 0!==t?t:void 0!==n?n:e)})),en=ie((function(e,r){"use strict";function o(e){return e&&e.Math===Math&&e}r.exports=o("object"==("undefined"==typeof globalThis?"undefined":a(globalThis))&&globalThis)||o("object"==(void 0===t?"undefined":a(t))&&t)||o("object"==("undefined"==typeof self?"undefined":a(self))&&self)||o("object"==(void 0===n?"undefined":a(n))&&n)||function(){return this}()||e||Function("return this")()})),tn=ie((function(e,t){"use strict";t.exports=function(e){try{return!!e()}catch(e){return!0}}})),nn=ie((function(e,t){"use strict";var n=tn();t.exports=!n((function(){var e=function(){}.bind();return"function"!=typeof e||e.hasOwnProperty("prototype")}))})),rn=ie((function(e,t){"use strict";var n=nn(),r=Function.prototype,o=r.apply,u=r.call;t.exports="object"==("undefined"==typeof Reflect?"undefined":a(Reflect))&&Reflect.a\
pply||(n?u.bind(o):function(){return u.apply(o,arguments)})})),an=ie((function(e,t){"use strict";var n=nn(),r=(a=Function.prototype).call,a=n&&a.bind.bind(r,r);t.exports=n?a:function(e){return function(){return r.apply(e,arguments)}}})),on=ie((function(e,t){"use strict";var n=an(),r=n({}.toString),a=n("".slice);t.exports=function(e){return a(r(e),8,-1)}})),un=ie((function(e,t){"use strict";var n=on(),r=an();t.exports=function(e){if("Function"===n(e))return r(e)}})),sn=ie((function(e,t){"use strict";var n="object"==(void 0===r?"undefined":a(r))&&r.all;t.exports={all:n,IS_HTMLDDA:void 0===n&&void 0!==n}})),ln=ie((function(e,t){"use strict";var n=sn(),r=n.all;t.exports=n.IS_HTMLDDA?function(e){return"function"==typeof e||e===r}:function(e){return"function"==typeof e}})),cn=ie((function(e,t){"use strict";var n=tn();t.exports=!n((function(){return 7!==Object.defineProperty({},1,{get:function(){return 7}})[1]}))})),dn=ie((function(e,t){"use strict";var n=nn(),r=Function.prototype.call;t.expo\
rts=n?r.bind(r):function(){return r.apply(r,arguments)}})),pn=ie((function(e){"use strict";var t={}.propertyIsEnumerable,n=Object.getOwnPropertyDescriptor,r=n&&!t.call({1:2},1);e.f=r?function(e){return!!(e=n(this,e))&&e.enumerable}:t})),fn=ie((function(e,t){"use strict";t.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}})),Dn=ie((function(e,t){"use strict";var n=an(),r=tn(),a=on(),o=Object,u=n("".split);t.exports=r((function(){return!o("z").propertyIsEnumerable(0)}))?function(e){return"String"===a(e)?u(e,""):o(e)}:o})),mn=ie((function(e,t){"use strict";t.exports=function(e){return null==e}})),hn=ie((function(e,t){"use strict";var n=mn(),r=TypeError;t.exports=function(e){if(n(e))throw new r("Can't call method on "+e);return e}})),gn=ie((function(e,t){"use strict";var n=Dn(),r=hn();t.exports=function(e){return n(r(e))}})),bn=ie((function(e,t){"use strict";var n=ln(),r=sn(),o=r.all;t.exports=r.IS_HTMLDDA?function(e){return"object"==a(e)?null!==e\
:n(e)||e===o}:function(e){return"object"==a(e)?null!==e:n(e)}})),vn=ie((function(e,t){"use strict";t.exports={}})),yn=ie((function(e,t){"use strict";function n(e){return o(e)?e:void 0}var r=vn(),a=en(),o=ln();t.exports=function(e,t){return arguments.length<2?n(r[e])||n(a[e]):r[e]&&r[e][t]||a[e]&&a[e][t]}})),Fn=ie((function(e,t){"use strict";var n=an();t.exports=n({}.isPrototypeOf)})),wn=ie((function(e,t){"use strict";t.exports="undefined"!=typeof navigator&&String(navigator.userAgent)||""})),En=ie((function(e,t){"use strict";var n,r,a=en(),o=wn(),u=a.process;a=a.Deno;!(r=(a=(u=u&&u.versions||a&&a.version)&&u.v8)?0<(n=a.split("."))[0]&&n[0]<4?1:+(n[0]+n[1]):r)&&o&&(!(n=o.match(/Edge\\/(\\d+)/))||74<=n[1])&&(n=o.match(/Chrome\\/(\\d+)/))&&(r=+n[1]),t.exports=r})),Cn=ie((function(e,t){"use strict";var n=En(),r=tn(),a=en().String;t.exports=!!Object.getOwnPropertySymbols&&!r((function(){var e=Symbol("symbol detection");return!a(e)||!(Object(e)instanceof Symbol)||!Symbol.sham&&n&&n<41}))})),xn=i\
e((function(e,t){"use strict";var n=Cn();t.exports=n&&!Symbol.sham&&"symbol"==a(Symbol.iterator)})),An=ie((function(e,t){"use strict";var n=yn(),r=ln(),o=Fn(),u=xn(),i=Object;t.exports=u?function(e){return"symbol"==a(e)}:function(e){var t=n("Symbol");return r(t)&&o(t.prototype,i(e))}})),kn=ie((function(e,t){"use strict";var n=String;t.exports=function(e){try{return n(e)}catch(e){return"Object"}}})),Bn=ie((function(e,t){"use strict";var n=ln(),r=kn(),a=TypeError;t.exports=function(e){if(n(e))return e;throw new a(r(e)+" is not a function")}})),Nn=ie((function(e,t){"use strict";var n=Bn(),r=mn();t.exports=function(e,t){return e=e[t],r(e)?void 0:n(e)}})),Tn=ie((function(e,t){"use strict";var n=dn(),r=ln(),a=bn(),o=TypeError;t.exports=function(e,t){var u,i;if("string"===t&&r(u=e.toString)&&!a(i=n(u,e)))return i;if(r(u=e.valueOf)&&!a(i=n(u,e)))return i;if("string"!==t&&r(u=e.toString)&&!a(i=n(u,e)))return i;throw new o("Can't convert object to primitive value")}})),Rn=ie((function(e,t){"use \
strict";t.exports=!0})),On=ie((function(e,t){"use strict";var n=en(),r=Object.defineProperty;t.exports=function(e,t){try{r(n,e,{value:t,configurable:!0,writable:!0})}catch(r){n[e]=t}return t}})),_n=ie((function(e,t){"use strict";var n=en(),r=On(),a="__core-js_shared__";n=n[a]||r(a,{});t.exports=n})),Sn=ie((function(e,t){"use strict";var n=Rn(),r=_n();(t.exports=function(e,t){return r[e]||(r[e]=void 0!==t?t:{})})("versions",[]).push({version:"3.33.0",mode:n?"pure":"global",copyright:"© 2014-2023 Denis Pushkarev (zloirock.ru)",license:"https://github.com/zloirock/core-js/blob/v3.33.0/LICENSE",source:"https://github.com/zloirock/core-js"})})),Mn=ie((function(e,t){"use strict";var n=hn(),r=Object;t.exports=function(e){return r(n(e))}})),Pn=ie((function(e,t){"use strict";var n=an(),r=Mn(),a=n({}.hasOwnProperty);t.exports=Object.hasOwn||function(e,t){return a(r(e),t)}})),In=ie((function(e,t){"use strict";var n=an(),r=0,a=Math.random(),o=n(1..toString);t.exports=function(e){return"Symbol("+(v\
oid 0===e?"":e)+")_"+o(++r+a,36)}})),jn=ie((function(e,t){"use strict";var n=en(),r=Sn(),a=Pn(),o=In(),u=Cn(),i=xn(),s=n.Symbol,l=r("wks"),c=i?s.for||s:s&&s.withoutSetter||o;t.exports=function(e){return a(l,e)||(l[e]=u&&a(s,e)?s[e]:c("Symbol."+e)),l[e]}})),Ln=ie((function(e,t){"use strict";var n=dn(),r=bn(),a=An(),o=Nn(),u=Tn(),i=jn(),s=TypeError,l=i("toPrimitive");t.exports=function(e,t){if(!r(e)||a(e))return e;var i=o(e,l);if(i){if(i=n(i,e,t=void 0===t?"default":t),!r(i)||a(i))return i;throw new s("Can't convert object to primitive value")}return u(e,t=void 0===t?"number":t)}})),qn=ie((function(e,t){"use strict";var n=Ln(),r=An();t.exports=function(e){return e=n(e,"string"),r(e)?e:e+""}})),zn=ie((function(e,t){"use strict";var n=en(),r=bn(),a=n.document,o=r(a)&&r(a.createElement);t.exports=function(e){return o?a.createElement(e):{}}})),Vn=ie((function(e,t){"use strict";var n=cn(),r=tn(),a=zn();t.exports=!n&&!r((function(){return 7!==Object.defineProperty(a("div"),"a",{get:function(){\
return 7}}).a}))})),$n=ie((function(e){"use strict";var t=cn(),n=dn(),r=pn(),a=fn(),o=gn(),u=qn(),i=Pn(),s=Vn(),l=Object.getOwnPropertyDescriptor;e.f=t?l:function(e,t){if(e=o(e),t=u(t),s)try{return l(e,t)}catch(e){}if(i(e,t))return a(!n(r.f,e,t),e[t])}})),Hn=ie((function(e,t){"use strict";function n(e,t){return(e=i[u(e)])===l||e!==s&&(a(t)?r(t):!!t)}var r=tn(),a=ln(),o=/#|\\.prototype\\./,u=n.normalize=function(e){return String(e).replace(o,".").toLowerCase()},i=n.data={},s=n.NATIVE="N",l=n.POLYFILL="P";t.exports=n})),Un=ie((function(e,t){"use strict";var n=un(),r=Bn(),a=nn(),o=n(n.bind);t.exports=function(e,t){return r(e),void 0===t?e:a?o(e,t):function(){return e.apply(t,arguments)}}})),Gn=ie((function(e,t){"use strict";var n=cn(),r=tn();t.exports=n&&r((function(){return 42!==Object.defineProperty((function(){}),"prototype",{value:42,writable:!1}).prototype}))})),Wn=ie((function(e,t){"use strict";var n=bn(),r=String,a=TypeError;t.exports=function(e){if(n(e))return e;throw new a(r(e)+" i\
s not an object")}})),Yn=ie((function(e){"use strict";var t=cn(),n=Vn(),r=Gn(),a=Wn(),o=qn(),u=TypeError,i=Object.defineProperty,s=Object.getOwnPropertyDescriptor,l="enumerable",c="configurable",d="writable";e.f=t?r?function(e,t,n){var r;return a(e),t=o(t),a(n),"function"==typeof e&&"prototype"===t&&"value"in n&&d in n&&!n[d]&&(r=s(e,t))&&r[d]&&(e[t]=n.value,n={configurable:(c in n?n:r)[c],enumerable:(l in n?n:r)[l],writable:!1}),i(e,t,n)}:i:function(e,t,r){if(a(e),t=o(t),a(r),n)try{return i(e,t,r)}catch(e){}if("get"in r||"set"in r)throw new u("Accessors not supported");return"value"in r&&(e[t]=r.value),e}})),Kn=ie((function(e,t){"use strict";var n=cn(),r=Yn(),a=fn();t.exports=n?function(e,t,n){return r.f(e,t,a(1,n))}:function(e,t,n){return e[t]=n,e}})),Xn=ie((function(e,t){"use strict";function n(e){function t(n,r,a){if(this instanceof t){switch(arguments.length){case 0:return new e;case 1:return new e(n);case 2:return new e(n,r)}return new e(n,r,a)}return o(e,this,arguments)}return t\
.prototype=e.prototype,t}var r=en(),o=rn(),u=un(),i=ln(),s=$n().f,l=Hn(),c=vn(),d=Un(),p=Kn(),f=Pn();t.exports=function(e,t){var o,D,m,h,g,b,v=e.target,y=e.global,F=e.stat,w=e.proto,E=y?r:F?r[v]:(r[v]||{}).prototype,C=y?c:c[v]||p(c,v,{})[v],x=C.prototype;for(D in t)g=!(o=l(y?D:v+(F?".":"#")+D,e.forced))&&E&&f(E,D),h=C[D],g&&(b=e.dontCallGetSet?(b=s(E,D))&&b.value:E[D]),m=g&&b?b:t[D],g&&a(h)==a(m)||(g=e.bind&&g?d(m,r):e.wrap&&g?n(m):w&&i(m)?u(m):m,(e.sham||m&&m.sham||h&&h.sham)&&p(g,"sham",!0),p(C,D,g),w&&(f(c,h=v+"Prototype")||p(c,h,{}),p(c[h],D,m),e.real)&&x&&(o||!x[D])&&p(x,D,m))}})),Zn=ie((function(){"use strict";Xn()({target:"Object",stat:!0},{hasOwn:Pn()})})),Jn=ie((function(e,t){"use strict";Zn();var n=vn();t.exports=n.Object.hasOwn})),Qn=ie((function(e,t){"use strict";var n=Jn();t.exports=n})),er=ie((function(e,t){"use strict";var n=Qn();t.exports=n})),tr=ie((function(e,t){"use strict";var n=Sn(),r=In(),a=n("keys");t.exports=function(e){return a[e]||(a[e]=r(e))}})),nr=ie((functi\
on(e,t){"use strict";var n=tn();t.exports=!n((function(){function e(){}return e.prototype.constructor=null,Object.getPrototypeOf(new e)!==e.prototype}))})),rr=ie((function(e,t){"use strict";var n=Pn(),r=ln(),a=Mn(),o=tr(),u=nr(),i=o("IE_PROTO"),s=Object,l=s.prototype;t.exports=u?s.getPrototypeOf:function(e){var t;e=a(e);return n(e,i)?e[i]:(t=e.constructor,r(t)&&e instanceof t?t.prototype:e instanceof s?l:null)}})),ar=ie((function(e,t){"use strict";var n=Math.ceil,r=Math.floor;t.exports=Math.trunc||function(e){return(0<(e=+e)?r:n)(e)}})),or=ie((function(e,t){"use strict";var n=ar();t.exports=function(e){return(e=+e)!=e||0==e?0:n(e)}})),ur=ie((function(e,t){"use strict";var n=or(),r=Math.max,a=Math.min;t.exports=function(e,t){return(e=n(e))<0?r(e+t,0):a(e,t)}})),ir=ie((function(e,t){"use strict";var n=or(),r=Math.min;t.exports=function(e){return 0<e?r(n(e),9007199254740991):0}})),sr=ie((function(e,t){"use strict";var n=ir();t.exports=function(e){return n(e.length)}})),lr=ie((function(e,t\
){"use strict";function n(e){return function(t,n,u){var i,s=r(t),l=o(s),c=a(u,l);if(e&&n!=n){for(;c<l;)if((i=s[c++])!=i)return!0}else for(;c<l;c++)if((e||c in s)&&s[c]===n)return e||c||0;return!e&&-1}}var r=gn(),a=ur(),o=sr();t.exports={includes:n(!0),indexOf:n(!1)}})),cr=ie((function(e,t){"use strict";t.exports={}})),dr=ie((function(e,t){"use strict";var n=an(),r=Pn(),a=gn(),o=lr().indexOf,u=cr(),i=n([].push);t.exports=function(e,t){var n,s=a(e),l=0,c=[];for(n in s)!r(u,n)&&r(s,n)&&i(c,n);for(;t.length>l;)!r(s,n=t[l++])||~o(c,n)||i(c,n);return c}})),pr=ie((function(e,t){"use strict";t.exports=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"]})),fr=ie((function(e,t){"use strict";var n=dr(),r=pr();t.exports=Object.keys||function(e){return n(e,r)}})),Dr=ie((function(e,t){"use strict";function n(e){return function(t){for(var n,a=s(t),o=i(a),p=d&&null===u(a),f=o.length,D=0,m=[];D<f;)n=o[D++],r&&!(p?n in a:l(a,n))||c(m,e?[n,a[n]]:a\
[n]);return m}}var r=cn(),a=tn(),o=an(),u=rr(),i=fr(),s=gn(),l=o(pn().f),c=o([].push),d=r&&a((function(){var e=Object.create(null);return e[2]=2,!l(e,2)}));t.exports={entries:n(!0),values:n(!1)}})),mr=ie((function(){"use strict";var e=Xn(),t=Dr().values;e({target:"Object",stat:!0},{values:function(e){return t(e)}})})),hr=ie((function(e,t){"use strict";mr();var n=vn();t.exports=n.Object.values})),gr=ie((function(e,t){"use strict";var n=hr();t.exports=n})),br=ie((function(e,t){"use strict";var n=gr();t.exports=n})),vr=ie((function(e,t){"use strict";var n={};n[jn()("toStringTag")]="z",t.exports="[object z]"===String(n)})),yr=ie((function(e,t){"use strict";var n=vr(),r=ln(),a=on(),o=jn()("toStringTag"),u=Object,i="Arguments"===a(function(){return arguments}());t.exports=n?a:function(e){var t;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(t=function(e,t){try{return e[t]}catch(e){}}(e=u(e),o))?t:i?a(e):"Object"===(t=a(e))&&r(e.callee)?"Arguments":t}})),Fr=ie((function(e,t){"u\
se strict";var n=yr(),r=String;t.exports=function(e){if("Symbol"===n(e))throw new TypeError("Cannot convert a Symbol value to a string");return r(e)}})),wr=ie((function(e,t){"use strict";function n(e){return function(t,n){t=o(u(t)),n=a(n);var r,c=t.length;return n<0||c<=n?e?"":void 0:(r=s(t,n))<55296||56319<r||n+1===c||(c=s(t,n+1))<56320||57343<c?e?i(t,n):r:e?l(t,n,n+2):c-56320+(r-55296<<10)+65536}}var r=an(),a=or(),o=Fr(),u=hn(),i=r("".charAt),s=r("".charCodeAt),l=r("".slice);t.exports={codeAt:n(!1),charAt:n(!0)}})),Er=ie((function(e,t){"use strict";var n=en(),r=ln();n=n.WeakMap;t.exports=r(n)&&/native code/.test(String(n))})),Cr=ie((function(e,t){"use strict";var n,r,a,o,u=Er(),i=en(),s=bn(),l=Kn(),c=Pn(),d=_n(),p=tr(),f=cr(),D="Object already initialized",m=i.TypeError,h=(i=i.WeakMap,u||d.state?((a=d.state||(d.state=new i)).get=a.get,a.has=a.has,a.set=a.set,n=function(e,t){if(a.has(e))throw new m(D);return t.facade=e,a.set(e,t),t},r=function(e){return a.get(e)||{}},function(e){retur\
n a.has(e)}):(f[o=p("state")]=!0,n=function(e,t){if(c(e,o))throw new m(D);return t.facade=e,l(e,o,t),t},r=function(e){return c(e,o)?e[o]:{}},function(e){return c(e,o)}));t.exports={set:n,get:r,has:h,enforce:function(e){return h(e)?r(e):n(e,{})},getterFor:function(e){return function(t){if(s(t)&&(t=r(t)).type===e)return t;throw new m("Incompatible receiver, "+e+" required")}}}})),xr=ie((function(e,t){"use strict";var n=cn(),r=Pn(),a=Function.prototype,o=n&&Object.getOwnPropertyDescriptor,u=(r=r(a,"name"))&&"something"===function(){}.name;n=r&&(!n||o(a,"name").configurable);t.exports={EXISTS:r,PROPER:u,CONFIGURABLE:n}})),Ar=ie((function(e){"use strict";var t=cn(),n=Gn(),r=Yn(),a=Wn(),o=gn(),u=fr();e.f=t&&!n?Object.defineProperties:function(e,t){a(e);for(var n,i=o(t),s=u(t),l=s.length,c=0;c<l;)r.f(e,n=s[c++],i[n]);return e}})),kr=ie((function(e,t){"use strict";var n=yn();t.exports=n("document","documentElement")})),Br=ie((function(e,t){"use strict";function n(){}var a,o=Wn(),u=Ar(),i=pr(),\
s=cr(),l=kr(),c=zn(),d=tr(),p="prototype",f="script",D=d("IE_PROTO"),m=function(e){return"<"+f+">"+e+"</"+f+">"},h=function(){try{a=new ActiveXObject("htmlfile")}catch(e){}h=void 0===r||r.domain&&a?function(e){e.write(m("")),e.close();var t=e.parentWindow.Object;return e=null,t}(a):(e=c("iframe"),t="java"+f+":",e.style.display="none",l.appendChild(e),e.src=String(t),(t=e.contentWindow.document).open(),t.write(m("document.F=Object")),t.close(),t.F);for(var e,t,n=i.length;n--;)delete h[p][i[n]];return h()};s[D]=!0,t.exports=Object.create||function(e,t){var r;return null!==e?(n[p]=o(e),r=new n,n[p]=null,r[D]=e):r=h(),void 0===t?r:u.f(r,t)}})),Nr=ie((function(e,t){"use strict";var n=Kn();t.exports=function(e,t,r,a){return a&&a.enumerable?e[t]=r:n(e,t,r),e}})),Tr=ie((function(e,t){"use strict";var n,r,a=tn(),o=ln(),u=bn(),i=Br(),s=rr(),l=Nr(),c=jn(),d=Rn(),p=c("iterator");c=!1;[].keys&&("next"in(r=[].keys())?(s=s(s(r)))!==Object.prototype&&(n=s):c=!0),!u(n)||a((function(){var e={};return n[\
p].call(e)!==e}))?n={}:d&&(n=i(n)),o(n[p])||l(n,p,(function(){return this})),t.exports={IteratorPrototype:n,BUGGY_SAFARI_ITERATORS:c}})),Rr=ie((function(e,t){"use strict";var n=vr(),r=yr();t.exports=n?{}.toString:function(){return"[object "+r(this)+"]"}})),Or=ie((function(e,t){"use strict";var n=vr(),r=Yn().f,a=Kn(),o=Pn(),u=Rr(),i=jn()("toStringTag");t.exports=function(e,t,s,l){e&&(s=s?e:e.prototype,o(s,i)||r(s,i,{configurable:!0,value:t}),l)&&!n&&a(s,"toString",u)}})),_r=ie((function(e,t){"use strict";t.exports={}})),Sr=ie((function(e,t){"use strict";function n(){return this}var r=Tr().IteratorPrototype,a=Br(),o=fn(),u=Or(),i=_r();t.exports=function(e,t,s,l){return t+=" Iterator",e.prototype=a(r,{next:o(+!l,s)}),u(e,t,!1,!0),i[t]=n,e}})),Mr=ie((function(e,t){"use strict";var n=an(),r=Bn();t.exports=function(e,t,a){try{return n(r(Object.getOwnPropertyDescriptor(e,t)[a]))}catch(e){}}})),Pr=ie((function(e,t){"use strict";var n=ln(),r=String,o=TypeError;t.exports=function(e){if("object"=\
=a(e)||n(e))return e;throw new o("Can't set "+r(e)+" as a prototype")}})),Ir=ie((function(e,t){"use strict";var n=Mr(),r=Wn(),a=Pr();t.exports=Object.setPrototypeOf||("__proto__"in{}?function(){var e,t=!1,o={};try{(e=n(Object.prototype,"__proto__","set"))(o,[]),t=o instanceof Array}catch(o){}return function(n,o){return r(n),a(o),t?e(n,o):n.__proto__=o,n}}():void 0)})),jr=ie((function(e,t){"use strict";function n(){return this}var r=Xn(),a=dn(),o=Rn(),u=xr(),i=ln(),s=Sr(),l=rr(),c=Ir(),d=Or(),p=Kn(),f=Nr(),D=jn(),m=_r(),h=Tr(),g=u.PROPER,b=u.CONFIGURABLE,v=h.IteratorPrototype,y=h.BUGGY_SAFARI_ITERATORS,F=D("iterator"),w="values";t.exports=function(e,t,u,D,h,E,C){function x(e){if(e===h&&R)return R;if(!y&&e&&e in N)return N[e];switch(e){case"keys":case w:case"entries":return function(){return new u(this,e)}}return function(){return new u(this)}}s(u,t,D);D=t+" Iterator";var A,k,B=!1,N=e.prototype,T=N[F]||N["@@iterator"]||h&&N[h],R=!y&&T||x(h),O="Array"===t&&N.entries||T;if(O&&(O=l(O.call(n\
ew e)))!==Object.prototype&&O.next&&(o||l(O)===v||(c?c(O,v):i(O[F])||f(O,F,n)),d(O,D,!0,!0),o)&&(m[D]=n),g&&h===w&&T&&T.name!==w&&(!o&&b?p(N,"name",w):(B=!0,R=function(){return a(T,this)})),h)if(A={values:x(w),keys:E?R:x("keys"),entries:x("entries")},C)for(k in A)!y&&!B&&k in N||f(N,k,A[k]);else r({target:t,proto:!0,forced:y||B},A);return o&&!C||N[F]===R||f(N,F,R,{name:h}),m[t]=R,A}})),Lr=ie((function(e,t){"use strict";t.exports=function(e,t){return{value:e,done:t}}})),qr=ie((function(){"use strict";var e=wr().charAt,t=Fr(),n=Cr(),r=jr(),a=Lr(),o="String Iterator",u=n.set,i=n.getterFor(o);r(String,"String",(function(e){u(this,{type:o,string:t(e),index:0})}),(function(){var t=i(this),n=t.string,r=t.index;return r>=n.length?a(void 0,!0):(n=e(n,r),t.index+=n.length,a(n,!1))}))})),zr=ie((function(e,t){"use strict";var n=dn(),r=Wn(),a=Nn();t.exports=function(e,t,o){var u,i;r(e);try{if(!(u=a(e,"return"))){if("throw"===t)throw o;return o}u=n(u,e)}catch(e){i=!0,u=e}if("throw"===t)throw o;if(i)\
throw u;return r(u),o}})),Vr=ie((function(e,t){"use strict";var n=Wn(),r=zr();t.exports=function(e,t,a,o){try{return o?t(n(a)[0],a[1]):t(a)}catch(t){r(e,"throw",t)}}})),$r=ie((function(e,t){"use strict";var n=jn(),r=_r(),a=n("iterator"),o=Array.prototype;t.exports=function(e){return void 0!==e&&(r.Array===e||o[a]===e)}})),Hr=ie((function(e,t){"use strict";var n=an(),r=ln(),a=_n(),o=n(Function.toString);r(a.inspectSource)||(a.inspectSource=function(e){return o(e)}),t.exports=a.inspectSource})),Ur=ie((function(e,t){"use strict";function n(){}function r(e){if(!i(e))return!1;try{return p(n,d,e),!0}catch(e){return!1}}function a(e){if(!i(e))return!1;switch(s(e)){case"AsyncFunction":case"GeneratorFunction":case"AsyncGeneratorFunction":return!1}try{return m||!!D(f,c(e))}catch(e){return!0}}var o=an(),u=tn(),i=ln(),s=yr(),l=yn(),c=Hr(),d=[],p=l("Reflect","construct"),f=/^\\s*(?:class|function)\\b/,D=o(f.exec),m=!f.test(n);a.sham=!0,t.exports=!p||u((function(){var e;return r(r.call)||!r(Object)||!r\
((function(){e=!0}))||e}))?a:r})),Gr=ie((function(e,t){"use strict";var n=qn(),r=Yn(),a=fn();t.exports=function(e,t,o){(t=n(t))in e?r.f(e,t,a(0,o)):e[t]=o}})),Wr=ie((function(e,t){"use strict";var n=yr(),r=Nn(),a=mn(),o=_r(),u=jn()("iterator");t.exports=function(e){if(!a(e))return r(e,u)||r(e,"@@iterator")||o[n(e)]}})),Yr=ie((function(e,t){"use strict";var n=dn(),r=Bn(),a=Wn(),o=kn(),u=Wr(),i=TypeError;t.exports=function(e,t){if(t=arguments.length<2?u(e):t,r(t))return a(n(t,e));throw new i(o(e)+" is not iterable")}})),Kr=ie((function(e,t){"use strict";var n=Un(),r=dn(),a=Mn(),o=Vr(),u=$r(),i=Ur(),s=sr(),l=Gr(),c=Yr(),d=Wr(),p=Array;t.exports=function(e){var t,f,D,m,h,g,b,v=a(e),y=(e=i(this),1<(b=arguments.length)?arguments[1]:void 0),F=void 0!==y,w=0;if(!(b=(F&&(y=n(y,2<b?arguments[2]:void 0)),d(v)))||this===p&&u(b))for(t=s(v),f=e?new this(t):p(t);w<t;w++)g=F?y(v[w],w):v[w],l(f,w,g);else for(h=(m=c(v,b)).next,f=e?new this:[];!(D=r(h,m)).done;w++)g=F?o(m,y,[D.value,w],!0):D.value,l(f,w,\
g);return f.length=w,f}})),Xr=ie((function(e,t){"use strict";var n,r,a=jn()("iterator"),o=!1;try{n=0,(r={next:function(){return{done:!!n++}},return:function(){o=!0}})[a]=function(){return this},Array.from(r,(function(){throw 2}))}catch(e){}t.exports=function(e,t){try{if(!t&&!o)return!1}catch(e){return!1}var n=!1;try{var r={};r[a]=function(){return{next:function(){return{done:n=!0}}}},e(r)}catch(e){}return n}})),Zr=ie((function(){"use strict";var e=Xn(),t=Kr();e({target:"Array",stat:!0,forced:!Xr()((function(e){Array.from(e)}))},{from:t})})),Jr=ie((function(e,t){"use strict";qr(),Zr();var n=vn();t.exports=n.Array.from})),Qr=ie((function(e,t){"use strict";var n=Jr();t.exports=n})),ea=ie((function(e,t){"use strict";var n=Qr();t.exports=n})),ta=ie((function(e,r){!function(){"use strict";var e={name:"doT",version:"1.1.1",templateSettings:{evaluate:/\\{\\{([\\s\\S]+?(\\}?)+)\\}\\}/g,interpolate:/\\{\\{=([\\s\\S]+?)\\}\\}/g,encode:/\\{\\{!([\\s\\S]+?)\\}\\}/g,use:/\\{\\{#([\\s\\S]+?)\\}\\}/g,useParams:/(^|[^\\w$])def(\
?:\\.|\\[[\\'\\"])([\\w$\\.]+)(?:[\\'\\"]\\])?\\s*\\:\\s*([\\w$\\.]+|\\"[^\\"]+\\"|\\'[^\\']+\\'|\\{[^\\}]+\\})/g,define:/\\{\\{##\\s*([\\w\\.$]+)\\s*(\\:|=)([\\s\\S]+?)#\\}\\}/g,defineParams:/^\\s*([\\w$]+):([\\s\\S]+)/,conditional:/\\{\\{\\?(\\?)?\\s*([\\s\\S]*?)\\s*\\}\\}/g,iterate:/\\{\\{~\\s*(?:\\}\\}|([\\s\\S]+?)\\s*\\:\\s*([\\w$]+)\\s*(?:\\:\\s*([\\w$]+))?\\s*\\}\\})/g,varname:"it",strip:!0,append:!0,selfcontained:!1,doNotSkipEncoded:!1},template:void 0,compile:void 0,log:!0};if("object"!==("undefined"==typeof globalThis?"undefined":a(globalThis)))try{Object.defineProperty(Object.prototype,"__magic__",{get:function(){return this},configurable:!0}),__magic__.globalThis=__magic__,delete Object.prototype.__magic__}catch(e){t.globalThis=function(){if("undefined"!=typeof self)return self;if(void 0!==t)return t;if(void 0!==n)return n;if(void 0!==this)return this;throw new Error("Unable to locate global \`this\`")}()}e.encodeHTMLSource=function(e){var t={"&":"&#38;","<":"&#60;",">":"&#62;",'"':"&#34;","'":"&#39;","/":"&#47;"},n=e?/[&<>"'\\/]/g:/&(?!#?\\w\
+;)|<|>|"|'|\\//g;return function(e){return e?e.toString().replace(n,(function(e){return t[e]||e})):""}},void 0!==r&&r.exports?r.exports=e:"function"==typeof define&&define.amd?define((function(){return e})):globalThis.doT=e;var o={append:{start:"'+(",end:")+'",startencode:"'+encodeHTML("},split:{start:"';out+=(",end:");out+='",startencode:"';out+=encodeHTML("}},u=/$^/;function i(e){return e.replace(/\\\\('|\\\\)/g,"$1").replace(/[\\r\\t\\n]/g," ")}e.template=function(t,n,r){var a,s,l=(n=n||e.templateSettings).append?o.append:o.split,c=0;r=n.use||n.define?function e(t,n,r){return("string"==typeof n?n:n.toString()).replace(t.define||u,(function(e,n,a,o){return(n=0===n.indexOf("def.")?n.substring(4):n)in r||(":"===a?(t.defineParams&&o.replace(t.defineParams,(function(e,t,a){r[n]={arg:t,text:a}})),n in r||(r[n]=o)):new Function("def","def['"+n+"']="+o)(r)),""})).replace(t.use||u,(function(n,a){return t.useParams&&(a=a.replace(t.useParams,(function(e,t,n,a){var o;if(r[n]&&r[n].arg&&a)return o=(n+"\
:"+a).replace(/'|\\\\/g,"_"),r.__exp=r.__exp||{},r.__exp[o]=r[n].text.replace(new RegExp("(^|[^\\\\w$])"+r[n].arg+"([^\\\\w$])","g"),"$1"+a+"$2"),t+"def.__exp['"+o+"']"}))),(a=new Function("def","return "+a)(r))&&e(t,a,r)}))}(n,t,r||{}):t,r=("var out='"+(n.strip?r.replace(/(^|\\r|\\n)\\t* +| +\\t*(\\r|\\n|$)/g," ").replace(/\\r|\\n|\\t|\\/\\*[\\s\\S]*?\\*\\//g,""):r).replace(/'|\\\\/g,"\\\\$&").replace(n.interpolate||u,(function(e,t){return l.start+i(t)+l.end})).replace(n.encode||u,(function(e,t){return a=!0,l.startencode+i(t)+l.end})).replace(n.conditional||u,(function(e,t,n){return t?n?"';}else if("+i(n)+"){out+='":"';}else{out+='":n?"';if("+i(n)+"){out+='":"';}out+='"})).replace(n.iterate||u,(function(e,t,n,r){return t?(c+=1,s=r||"i"+c,t=i(t),"';var arr"+c+"="+t+";if(arr"+c+"){var "+n+","+s+"=-1,l"+c+"=arr"+c+".length-1;while("+s+"<l"+c+"){"+n+"=arr"+c+"["+s+"+=1];out+='"):"';} } out+='"})).replace(n.evaluate||u,(function(e,t){return"';"+i(t)+"out+='"}))+"';return out;").replace(/\\n/g,"\\\\n").replace(/\\t/g,"\
\\\\t").replace(/\\r/g,"\\\\r").replace(/(\\s|;|\\}|^|\\{)out\\+='';/g,"$1").replace(/\\+''/g,"");a&&(n.selfcontained||!globalThis||globalThis._encodeHTML||(globalThis._encodeHTML=e.encodeHTMLSource(n.doNotSkipEncoded)),r="var encodeHTML = typeof _encodeHTML !== 'undefined' ? _encodeHTML : ("+e.encodeHTMLSource.toString()+"("+(n.doNotSkipEncoded||"")+"));"+r);try{return new Function(n.varname,r)}catch(t){throw"undefined"!=typeof console&&console.log("Could not create a template function: "+r),t}},e.compile=function(t,n){return e.template(t,null,n)}}()})),na={helpUrlBase:"https://dequeuniversity.com/rules/",gridSize:200,results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze(["minor","moderate","serious","critical"]),preload:Object.freeze({assets:["cssom","media"],timeout:1e4}),allOrigins:"<unsafe_all_origins>",sameOrigin:"<same_origin>"},ra=([{name:"NA",value:"inapplicable",priority:0,group:"inapplicable"},{name:"PASS",value:"passed",priority:1,group:"passes"},{name:"CANTTELL",value:"c\
antTell",priority:2,group:"incomplete"},{name:"FAIL",value:"failed",priority:3,group:"violations"}].forEach((function(e){var t=e.name,n=e.value,r=e.priority;e=e.group;na[t]=n,na[t+"_PRIO"]=r,na[t+"_GROUP"]=e,na.results[r]=n,na.resultGroups[r]=e,na.resultGroupMap[n]=e})),Object.freeze(na.results),Object.freeze(na.resultGroups),Object.freeze(na.resultGroupMap),Object.freeze(na),na),aa=function(){"object"===("undefined"==typeof console?"undefined":a(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},oa=/[\\t\\r\\n\\f]/g,ua=G((function e(){H(this,e),this.parent=void 0}),[{key:"props",get:function(){throw new Error('VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties')}},{key:"attrNames",get:function(){throw new Error('VirtualNode class must have an "attrNames" property')}},{key:"attr",value:function(){throw new Error('VirtualNode class must have an "attr" function')}},{key:"hasAttr",value:function(){throw new Error(\
'VirtualNode class must have a "hasAttr" function')}},{key:"hasClass",value:function(e){var t=this.attr("class");return!!t&&(e=" "+e+" ",0<=(" "+t+" ").replace(oa," ").indexOf(e))}}]),ia={},sa=(se(ia,{DqElement:function(){return eo},aggregate:function(){return sa},aggregateChecks:function(){return Da},aggregateNodeResults:function(){return ha},aggregateResult:function(){return ba},areStylesSet:function(){return va},assert:function(){return ya},checkHelper:function(){return to},clone:function(){return no},closest:function(){return fo},collectResultsFromFrames:function(){return iu},contains:function(){return su},convertSelector:function(){return co},cssParser:function(){return ro},deepMerge:function(){return lu},escapeSelector:function(){return wa},extendMetaData:function(){return cu},filterHtmlAttrs:function(){return dD},finalizeRuleResult:function(){return ma},findBy:function(){return au},getAllChecks:function(){return ru},getAncestry:function(){return Wa},getBaseLang:function(){return\
 nf},getCheckMessage:function(){return pf},getCheckOption:function(){return ff},getEnvironmentData:function(){return Df},getFlattenedTree:function(){return ef},getFrameContexts:function(){return Af},getFriendlyUriEnd:function(){return Aa},getNodeAttributes:function(){return ka},getNodeFromTree:function(){return Za},getPreloadConfig:function(){return oD},getRootNode:function(){return Du},getRule:function(){return kf},getScroll:function(){return Nf},getScrollState:function(){return Tf},getSelector:function(){return Ua},getSelectorData:function(){return za},getShadowSelector:function(){return Oa},getStandards:function(){return Rf},getStyleSheetFactory:function(){return _f},getXpath:function(){return Ya},injectStyle:function(){return Sf},isHidden:function(){return Mf},isHtmlElement:function(){return Pf},isNodeInContext:function(){return If},isShadowRoot:function(){return pu},isValidLang:function(){return yD},isXHTML:function(){return Ra},matchAncestry:function(){return Lf},matches:function\
(){return ao},matchesExpression:function(){return po},matchesSelector:function(){return Ba},memoize:function(){return Ta},mergeResults:function(){return uu},nodeLookup:function(){return zf},nodeSerializer:function(){return nu},nodeSorter:function(){return qf},parseCrossOriginStylesheet:function(){return Gf},parseSameOriginStylesheet:function(){return Hf},parseStylesheet:function(){return Uf},performanceTimer:function(){return Yf},pollyfillElementsFromPoint:function(){return Kf},preload:function(){return rD},preloadCssom:function(){return Qf},preloadMedia:function(){return nD},processMessage:function(){return df},publishMetaData:function(){return uD},querySelectorAll:function(){return sD},querySelectorAllFilter:function(){return Jf},queue:function(){return vo},respondable:function(){return Ko},ruleShouldRun:function(){return cD},select:function(){return fD},sendCommandToFrame:function(){return Zo},setScrollState:function(){return DD},shadowSelect:function(){return mD},shadowSelectAll:fu\
nction(){return hD},shouldPreload:function(){return aD},toArray:function(){return Fa},tokenList:function(){return Wp},uniqueArray:function(){return Xf},uuid:function(){return Oo},validInputTypes:function(){return gD},validLangs:function(){return vD}}),function(e,t,n){return t=t.slice(),n&&t.push(n),n=t.map((function(t){return e.indexOf(t)})).sort(),e[n.pop()]}),la=ra.CANTTELL_PRIO,ca=ra.FAIL_PRIO,da=[],pa=(da[ra.PASS_PRIO]=!0,da[ra.CANTTELL_PRIO]=null,da[ra.FAIL_PRIO]=!1,["any","all","none"]);function fa(e,t){pa.reduce((function(n,r){return n[r]=(e[r]||[]).map((function(e){return t(e,r)})),n}),{})}var Da=function(e){var t=Object.assign({},e),n=(fa(t,(function(e,t){var n=void 0===e.result?-1:da.indexOf(e.result);e.priority=-1!==n?n:ra.CANTTELL_PRIO,"none"===t&&(e.priority===ra.PASS_PRIO?e.priority=ra.FAIL_PRIO:e.priority===ra.FAIL_PRIO&&(e.priority=ra.PASS_PRIO))})),{all:t.all.reduce((function(e,t){return Math.max(e,t.priority)}),0),none:t.none.reduce((function(e,t){return Math.max(e,t.\
priority)}),0),any:t.any.reduce((function(e,t){return Math.min(e,t.priority)}),4)%4}),r=(t.priority=Math.max(n.all,n.none,n.any),[]);return pa.forEach((function(e){t[e]=t[e].filter((function(r){return r.priority===t.priority&&r.priority===n[e]})),t[e].forEach((function(e){return r.push(e.impact)}))})),[la,ca].includes(t.priority)?t.impact=sa(ra.impact,r):t.impact=null,fa(t,(function(e){delete e.result,delete e.priority})),t.result=ra.results[t.priority],delete t.priority,t};function ma(e){var t=o._audit.rules.find((function(t){return t.id===e.id}));return t&&t.impact&&e.nodes.forEach((function(e){["any","all","none"].forEach((function(n){(e[n]||[]).forEach((function(e){e.impact=t.impact}))}))})),Object.assign(e,ha(e.nodes)),delete e.nodes,e}var ha=function(e){var t={},n=((e=e.map((function(e){if(e.any&&e.all&&e.none)return Da(e);if(Array.isArray(e.node))return ma(e);throw new TypeError("Invalid Result type")})))&&e.length?(n=e.map((function(e){return e.result})),t.result=sa(ra.results,\
n,t.result)):t.result="inapplicable",ra.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){var n=ra.resultGroupMap[e.result];t[n].push(e)})),ra.FAIL_GROUP);return 0===t[n].length&&(n=ra.CANTTELL_GROUP),0<t[n].length?(e=t[n].map((function(e){return e.impact})),t.impact=sa(ra.impact,e)||null):t.impact=null,t};function ga(e,t,n){var r=Object.assign({},t);r.nodes=(r[n]||[]).concat(),ra.resultGroups.forEach((function(e){delete r[e]})),e[n].push(r)}var ba=function(e){var t={};return ra.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){e.error?ga(t,e,ra.CANTTELL_GROUP):e.result===ra.NA?ga(t,e,ra.NA_GROUP):ra.resultGroups.forEach((function(n){Array.isArray(e[n])&&0<e[n].length&&ga(t,e,n)}))})),t},va=function e(n,r,a){var o=t.getComputedStyle(n,null);if(!o)return!1;for(var u=0;u<r.length;++u){var i=r[u];if(o.getPropertyValue(i.property)===i.value)return!0}return!(!n.parentNode||n.nodeName.toUpperCase()===a.toUpperCase())&&e(n.parentNode,r,a)},ya=\
function(e,t){if(!e)throw new Error(t)},Fa=function(e){return Array.prototype.slice.call(e)},wa=function(e){for(var t,n=String(e),r=n.length,a=-1,o="",u=n.charCodeAt(0);++a<r;)0==(t=n.charCodeAt(a))?o+="�":o+=1<=t&&t<=31||127==t||0==a&&48<=t&&t<=57||1==a&&48<=t&&t<=57&&45==u?"\\\\"+t.toString(16)+" ":0==a&&1==r&&45==t||!(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?"\\\\"+n.charAt(a):n.charAt(a);return o};function Ea(e,t){return[e.substring(0,t),e.substring(t)]}function Ca(e){return e.replace(/\\s+$/,"")}var xa,Aa=function(){var e,t,n,r,a,o,u,i,s=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"",l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!(s.length<=1||"data:"===s.substr(0,5)||"javascript:"===s.substr(0,11)||s.includes("?")))return e=l.currentDomain,l=void 0===(l=l.maxLength)?25:l,u=o=i=a=r="",(n=s).includes("#")&&(s=(t=z(Ea(s,s.indexOf("#")),2))[0],u=t[1]),s.includes("?")&&(s=(t=z(Ea(s,s.indexOf("?")),2))[0],o=t[1]),s.includes("://")?(r=(t=z(\
s.split("://"),2))[0],a=(t=z(Ea(s=t[1],s.indexOf("/")),2))[0],s=t[1]):"//"===s.substr(0,2)&&(a=(t=z(Ea(s=s.substr(2),s.indexOf("/")),2))[0],s=t[1]),(a="www."===a.substr(0,4)?a.substr(4):a)&&a.includes(":")&&(a=(t=z(Ea(a,a.indexOf(":")),2))[0],i=t[1]),n=(t={original:n,protocol:r,domain:a,port:i,path:s,query:o,hash:u}).domain,r=t.hash,i=(a=t.path).substr(a.substr(0,a.length-2).lastIndexOf("/")+1),r?i&&(i+r).length<=l?Ca(i+r):i.length<2&&2<r.length&&r.length<=l?Ca(r):void 0:n&&n.length<l&&a.length<=1||a==="/"+i&&n&&e&&n!==e&&(n+a).length<=l?Ca(n+a):(-1===(s=i.lastIndexOf("."))||1<s)&&(-1!==s||2<i.length)&&i.length<=l&&!i.match(/index(\\.[a-zA-Z]{2-4})?/)&&!function(e){var t=0<arguments.length&&void 0!==e?e:"";return 0!==t.length&&(t.match(/[0-9]/g)||"").length>=t.length/2}(i)?Ca(i):void 0},ka=function(e){return(e.attributes instanceof t.NamedNodeMap?e:e.cloneNode(!1)).attributes},Ba=function(e,t){return!!e[xa=xa&&e[xa]?xa:function(e){for(var t,n=["matches","matchesSelector","mozMatchesSele\
ctor","webkitMatchesSelector","msMatchesSelector"],r=n.length,a=0;a<r;a++)if(e[t=n[a]])return t}(e)]&&e[xa](t)},Na=le(Gt()),Ta=(o._memoizedFns=[],function(e){return e=(0,Na.default)(e),o._memoizedFns.push(e),e}),Ra=Ta((function(e){return!(null==e||!e.createElement)&&"A"===e.createElement("A").localName}));function Oa(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};if(!t)return"";var a=t.getRootNode&&t.getRootNode()||r;if(11!==a.nodeType)return e(t,n,a);for(var o=[];11===a.nodeType;){if(!a.host)return"";o.unshift({elm:t,doc:a}),a=(t=a.host).getRootNode()}return o.unshift({elm:t,doc:a}),o.map((function(t){return e(t.elm,n,t.doc)}))}var _a=["class","style","id","selected","checked","disabled","tabindex","aria-checked","aria-selected","aria-invalid","aria-activedescendant","aria-busy","aria-disabled","aria-expanded","aria-grabbed","aria-pressed","aria-valuenow","xmlns"],Sa=31,Ma=/([\\\\"])/g,Pa=/(\\r\\n|\\r|\\n)/g;function Ia(e){return e.replace(Ma,"\\\\$1").replace(Pa,"\\\\a ")\
}function ja(e,t){var n,r=t.name;return-1!==r.indexOf("href")||-1!==r.indexOf("src")?(n=Aa(e.getAttribute(r)))?wa(t.name)+'$="'+Ia(n)+'"':wa(t.name)+'="'+Ia(e.getAttribute(r))+'"':wa(r)+'="'+Ia(t.value)+'"'}function La(e,t){return e.count<t.count?-1:e.count===t.count?0:1}function qa(e){return!_a.includes(e.name)&&-1===e.name.indexOf(":")&&(!e.value||e.value.length<Sa)}function za(e){for(var t={classes:{},tags:{},attributes:{}},n=(e=Array.isArray(e)?e:[e]).slice(),r=[];n.length;)!function(){var e,a=n.pop(),o=a.actualNode;for(o.querySelectorAll&&(e=o.nodeName,t.tags[e]?t.tags[e]++:t.tags[e]=1,o.classList&&Array.from(o.classList).forEach((function(e){e=wa(e),t.classes[e]?t.classes[e]++:t.classes[e]=1})),o.hasAttributes())&&Array.from(ka(o)).filter(qa).forEach((function(e){(e=ja(o,e))&&(t.attributes[e]?t.attributes[e]++:t.attributes[e]=1)})),a.children.length&&(r.push(n),n=a.children.slice());!n.length&&r.length;)n=r.pop()}();return t}function Va(e){var t=Ra(r);return wa(t?e.localName:e.no\
deName.toLowerCase())}function $a(e,t){var n,r,a,o,u,i,s,l,c,d="",p=(r=e,a=[],o=t.classes,u=t.tags,r.classList&&Array.from(r.classList).forEach((function(e){e=wa(e),o[e]<u[r.nodeName]&&a.push({name:e,count:o[e],species:"class"})})),a.sort(La));i=e,s=[],l=t.attributes,c=t.tags,i.hasAttributes()&&Array.from(ka(i)).filter(qa).forEach((function(e){(e=ja(i,e))&&l[e]<c[i.nodeName]&&s.push({name:e,count:l[e],species:"attribute"})})),t=s.sort(La);return p.length&&1===p[0].count?n=[p[0]]:t.length&&1===t[0].count?(n=[t[0]],d=Va(e)):((n=p.concat(t)).sort(La),(n=n.slice(0,3)).some((function(e){return"class"===e.species}))?n.sort((function(e,t){return e.species!==t.species&&"class"===e.species?-1:e.species===t.species?0:1})):d=Va(e)),d+n.reduce((function(e,t){switch(t.species){case"class":return e+"."+t.name;case"attribute":return e+"["+t.name+"]"}return e}),"")}function Ha(e,t,n){if(!o._selectorData)throw new Error("Expect axe._selectorData to be set up");var a,u,i=void 0!==(t=t.toRoot)&&t;do{var \
s=function(e){var t;if(e.getAttribute("id"))return t=e.getRootNode&&e.getRootNode()||r,(e="#"+wa(e.getAttribute("id")||"")).match(/player_uid_/)||1!==t.querySelectorAll(e).length?void 0:e}(e);s||(s=$a(e,o._selectorData),s+=function(e,t){var n=e.parentNode&&Array.from(e.parentNode.children||"")||[];return n.find((function(n){return n!==e&&Ba(n,t)}))?":nth-child("+(1+n.indexOf(e))+")":""}(e,s)),a=a?s+" > "+a:s,u=u?u.filter((function(e){return Ba(e,a)})):Array.from(n.querySelectorAll(a)),e=e.parentElement}while((1<u.length||i)&&e&&11!==e.nodeType);return 1===u.length?a:-1!==a.indexOf(" > ")?":root"+a.substring(a.indexOf(" > ")):":root"}function Ua(e,t){return Oa(Ha,e,t)}function Ga(e){var t,n=e.nodeName.toLowerCase(),r=e.parentElement;return r?(t="","head"!==n&&"body"!==n&&1<r.children.length&&(e=Array.prototype.indexOf.call(r.children,e)+1,t=":nth-child(".concat(e,")")),Ga(r)+" > "+n+t):n}function Wa(e,t){return Oa(Ga,e,t)}var Ya=function(e){return function e(t,n){var r,a,o,u;if(!t)retur\
n[];if(!n&&9===t.nodeType)return[{str:"html"}];if(n=n||[],t.parentNode&&t.parentNode!==t&&(n=e(t.parentNode,n)),t.previousSibling){for(a=1,r=t.previousSibling;1===r.nodeType&&r.nodeName===t.nodeName&&a++,r=r.previousSibling;);1===a&&(a=null)}else if(t.nextSibling)for(r=t.nextSibling;r=1===r.nodeType&&r.nodeName===t.nodeName?(a=1,null):(a=null,r.previousSibling););return 1===t.nodeType&&((o={}).str=t.nodeName.toLowerCase(),(u=t.getAttribute&&wa(t.getAttribute("id")))&&1===t.ownerDocument.querySelectorAll("#"+u).length&&(o.id=t.getAttribute("id")),1<a&&(o.count=a),n.push(o)),n}(e).reduce((function(e,t){return t.id?"/".concat(t.str,"[@id='").concat(t.id,"']"):e+"/".concat(t.str)+(0<t.count?"[".concat(t.count,"]"):"")}),"")},Ka={},Xa={set:function(e,t){var n;ya("string"==typeof(n=e),"key must be a string, "+a(n)+" given"),ya(""!==n,"key must not be empty"),Ka[e]=t},get:function(e,t){var n;return ya("function"==typeof(n=t)||void 0===n,"creator must be a function or undefined, "+a(n)+" given\
"),e in Ka?Ka[e]:"function"==typeof t?(n=t(),ya(void 0!==n,"Cache creator function should not return undefined"),this.set(e,n),Ka[e]):void 0},clear:function(){Ka={}}},Za=function(e,t){return t=t||e,Xa.get("nodeMap")?Xa.get("nodeMap").get(t):null},Ja="DqElm.RunOptions";function Qa(e){var n,r,a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,u=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};a=a||(null!=(n=Xa.get(Ja))?n:{}),this.spec=u,e instanceof ua?(this._virtualNode=e,this._element=e.actualNode):(this._element=e,this._virtualNode=Za(e)),this.fromFrame=1<(null==(n=this.spec.selector)?void 0:n.length),this._includeElementInJson=a.elementRef,a.absolutePaths&&(this._options={toRoot:!0}),this.nodeIndexes=[],Array.isArray(this.spec.nodeIndexes)?this.nodeIndexes=this.spec.nodeIndexes:"number"==typeof(null==(u=this._virtualNode)?void 0:u.nodeIndex)&&(this.nodeIndexes=[this._virtualNode.nodeIndex]),this.source=null,o._audit.noHtml||(this.source=null!=(n=this.spec.source)?\
n:null!=(a=this._element)&&a.outerHTML?((u=a.outerHTML)||"function"!=typeof t.XMLSerializer||(u=(new t.XMLSerializer).serializeToString(a)),(a=u||"").length>(r=r||300)&&(r=a.indexOf(">"),a=a.substring(0,r+1)),a):"")}Qa.prototype={get selector(){return this.spec.selector||[Ua(this.element,this._options)]},get ancestry(){return this.spec.ancestry||[Wa(this.element)]},get xpath(){return this.spec.xpath||[Ya(this.element)]},get element(){return this._element},toJSON:function(){var e={selector:this.selector,source:this.source,xpath:this.xpath,ancestry:this.ancestry,nodeIndexes:this.nodeIndexes,fromFrame:this.fromFrame};return this._includeElementInJson&&(e.element=this._element),e}},Qa.fromFrame=function(e,t,n){return e=Qa.mergeSpecs(e,n),new Qa(n.element,t,e)},Qa.mergeSpecs=function(e,t){return q({},e,{selector:[].concat(j(t.selector),j(e.selector)),ancestry:[].concat(j(t.ancestry),j(e.ancestry)),xpath:[].concat(j(t.xpath),j(e.xpath)),nodeIndexes:[].concat(j(t.nodeIndexes),j(e.nodeIndexes)\
),fromFrame:!0})},Qa.setRunOptions=function(e){var t=e.elementRef;e=e.absolutePaths;Xa.set(Ja,{elementRef:t,absolutePaths:e})};var eo=Qa,to=function(e,n,r,a){return{isAsync:!1,async:function(){return this.isAsync=!0,function(t){t instanceof Error==0?(e.result=t,r(e)):a(t)}},data:function(t){e.data=t},relatedNodes:function(n){t.Node&&(n=n instanceof t.Node||n instanceof ua?[n]:Fa(n),e.relatedNodes=[],n.forEach((function(n){(n=n instanceof ua?n.actualNode:n)instanceof t.Node&&(n=new eo(n),e.relatedNodes.push(n))})))}}};function no(e){return function e(n,r){var o,u;if(null===n||"object"!==a(n))return n;if(null!=(o=t)&&o.Node&&n instanceof t.Node||null!=(o=t)&&o.HTMLCollection&&n instanceof t.HTMLCollection||"nodeName"in n&&"nodeType"in n&&"ownerDocument"in n)return n;if(r.has(n))return r.get(n);if(Array.isArray(n))return u=[],r.set(n,u),n.forEach((function(t){u.push(e(t,r))})),u;var i={};for(var s in r.set(n,i),n)i[s]=e(n[s],r);return i}(e,new Map)}(Wi=new(le(Xt()).CssSelectorParser)).reg\
isterSelectorPseudos("not"),Wi.registerSelectorPseudos("is"),Wi.registerNestingOperators(">"),Wi.registerAttrEqualityMods("^","$","*","~");var ro=Wi;function ao(e,t){return co(t).some((function(t){return po(e,t)}))}function oo(e,t){return u=t,1===(o=e).props.nodeType&&("*"===u.tag||o.props.nodeName===u.tag)&&(a=e,!(o=t).classes||o.classes.every((function(e){return a.hasClass(e.value)})))&&(r=e,!(u=t).attributes||u.attributes.every((function(e){var t=r.attr(e.key);return null!==t&&e.test(t)})))&&(o=e,!(u=t).id||o.props.id===u.id)&&(n=e,!((o=t).pseudos&&!o.pseudos.every((function(e){if("not"===e.name)return!e.expressions.some((function(e){return po(n,e)}));if("is"===e.name)return e.expressions.some((function(e){return po(n,e)}));throw new Error("the pseudo selector "+e.name+" has not yet been implemented")}))));var n,r,a,o,u}uo=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g;var uo,io=function(e){return e.replace(uo,"\\\\")},so=/\\\\/g;function lo(e){return e.map((function(e){for(var t=[],n=e.rule;n;)t.pu\
sh({tag:n.tagName?n.tagName.toLowerCase():"*",combinator:n.nestingOperator||" ",id:n.id,attributes:function(e){if(e)return e.map((function(e){var t,n,r=e.name.replace(so,""),a=(e.value||"").replace(so,"");switch(e.operator){case"^=":n=new RegExp("^"+io(a));break;case"$=":n=new RegExp(io(a)+"$");break;case"~=":n=new RegExp("(^|\\\\s)"+io(a)+"(\\\\s|$)");break;case"|=":n=new RegExp("^"+io(a)+"(-|$)");break;case"=":t=function(e){return a===e};break;case"*=":t=function(e){return e&&e.includes(a)};break;case"!=":t=function(e){return a!==e};break;default:t=function(e){return null!==e}}return""===a&&/^[*$^]=$/.test(e.operator)&&(t=function(){return!1}),{key:r,value:a,type:void 0===e.value?"attrExist":"attrValue",test:t=t||function(e){return e&&n.test(e)}}}))}(n.attrs),classes:function(e){if(e)return e.map((function(e){return{value:e=e.replace(so,""),regexp:new RegExp("(^|\\\\s)"+io(e)+"(\\\\s|$)")}}))}(n.classNames),pseudos:function(e){if(e)return e.map((function(e){var t;return["is","not"].includes(\
e.name)&&(t=lo(t=(t=e.value).selectors||[t])),{name:e.name,expressions:t,value:e.value}}))}(n.pseudos)}),n=n.rule;return t}))}function co(e){return lo((e=ro.parse(e)).selectors||[e])}function po(e,t,n){return function e(t,n,r,a){if(!t)return!1;for(var o=Array.isArray(n)?n[r]:n,u=oo(t,o);!u&&a&&t.parent;)u=oo(t=t.parent,o);if(0<r){if(!1===[" ",">"].includes(o.combinator))throw new Error("axe.utils.matchesExpression does not support the combinator: "+o.combinator);u=u&&e(t.parent,n,r-1," "===o.combinator)}return u}(e,t,t.length-1,n)}var fo=function(e,t){for(;e;){if(ao(e,t))return e;if(void 0===e.parent)throw new TypeError("Cannot resolve parent for non-DOM nodes");e=e.parent}return null};function Do(){}function mo(e){if("function"!=typeof e)throw new TypeError("Queue methods require functions as arguments")}for(var ho,go,bo,vo=function(){function e(e){t=e,setTimeout((function(){null!=t&&aa("Uncaught error (of queue)",t)}),1)}var t,n=[],r=0,o=0,u=Do,i=!1,s=e;function l(e){return u=Do,s(e)\
,n}function c(){for(var e=n.length;r<e;r++){var t=n[r];try{t.call(null,function(e){return function(t){n[e]=t,--o||u===Do||(i=!0,u(n))}}(r),l)}catch(e){l(e)}}}var d={defer:function(e){var r;if("object"===a(e)&&e.then&&e.catch&&(r=e,e=function(e,t){r.then(e).catch(t)}),mo(e),void 0===t){if(i)throw new Error("Queue already completed");return n.push(e),++o,c(),d}},then:function(e){if(mo(e),u!==Do)throw new Error("queue \`then\` already set");return t||(u=e,o)||(i=!0,u(n)),d},catch:function(n){if(mo(n),s!==e)throw new Error("queue \`catch\` already set");return t?(n(t),t=null):s=n,d},abort:l};return d},yo=t.crypto||t.msCrypto,Fo=(!ho&&yo&&yo.getRandomValues&&(go=new Uint8Array(16),ho=function(){return yo.getRandomValues(go),go}),ho||(bo=new Array(16),ho=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),bo[t]=e>>>((3&t)<<3)&255;return bo}),"function"==typeof t.Buffer?t.Buffer:Array),wo=[],Eo={},Co=0;Co<256;Co++)wo[Co]=(Co+256).toString(16).substr(1),Eo[wo[Co]]=Co;function \
xo(e,t){return t=t||0,wo[e[t++]]+wo[e[t++]]+wo[e[t++]]+wo[e[t++]]+"-"+wo[e[t++]]+wo[e[t++]]+"-"+wo[e[t++]]+wo[e[t++]]+"-"+wo[e[t++]]+wo[e[t++]]+"-"+wo[e[t++]]+wo[e[t++]]+wo[e[t++]]+wo[e[t++]]+wo[e[t++]]+wo[e[+t]]}var Ao=[1|(Wi=ho())[0],Wi[1],Wi[2],Wi[3],Wi[4],Wi[5]],ko=16383&(Wi[6]<<8|Wi[7]),Bo=0,No=0;function To(e,t,n){var r=t&&n||0,a=t||[],o=(n=null!=(e=e||{}).clockseq?e.clockseq:ko,null!=e.msecs?e.msecs:(new Date).getTime()),u=null!=e.nsecs?e.nsecs:No+1;if((i=o-Bo+(u-No)/1e4)<0&&null==e.clockseq&&(n=n+1&16383),1e4<=(u=(i<0||Bo<o)&&null==e.nsecs?0:u))throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");Bo=o,ko=n;for(var i=(1e4*(268435455&(o+=122192928e5))+(No=u))%4294967296,s=(u=(a[r++]=i>>>24&255,a[r++]=i>>>16&255,a[r++]=i>>>8&255,a[r++]=255&i,o/4294967296*1e4&268435455),a[r++]=u>>>8&255,a[r++]=255&u,a[r++]=u>>>24&15|16,a[r++]=u>>>16&255,a[r++]=n>>>8|128,a[r++]=255&n,e.node||Ao),l=0;l<6;l++)a[r+l]=s[l];return t||xo(a)}function Ro(e,t,n){var r=t&&n||0,a=("string"==typeo\
f e&&(t="binary"==e?new Fo(16):null,e=null),(e=e||{}).random||(e.rng||ho)());if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t)for(var o=0;o<16;o++)t[r+o]=a[o];return t||xo(a)}(Wi=Ro).v1=To,Wi.v4=Ro,Wi.parse=function(e,t,n){var r=t&&n||0,a=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,(function(e){a<16&&(t[r+a++]=Eo[e])}));a<16;)t[r+a++]=0;return t},Wi.unparse=xo,Wi.BufferClass=Fo,o._uuid=To();var Oo=Ro,_o=Object.freeze(["EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"]);function So(){var e="axeAPI",t="";return(e=void 0!==o&&o._audit&&o._audit.application?o._audit.application:e)+"."+(void 0!==o?o.version:t)}function Mo(e){Io(e),ya(t.parent===e,"Source of the response must be the parent window.")}function Po(e){Io(e),ya(e.parent===t,"Respondable target must be a frame in the current window")}function Io(e){ya(t!==e,"Messages can not be sent to the same window.")}var jo={},Lo=[];function qo(){var e="".concat(Ro(),":").concat(Ro());return Lo.includes(e)?qo():(Lo.p\
ush(e),e)}function zo(e,t,n,r){var a,u,i,s,l;return(n?Mo:Po)(e),t.message instanceof Error&&!n?(o.log(t.message),!1):(l=(u=q({messageId:qo()},t)).topic,i=u.channelId,s=u.message,i={channelId:i,topic:l,messageId:u.messageId,keepalive:!!u.keepalive,source:So()},s instanceof Error?i.error={name:s.name,message:s.message,stack:s.stack}:i.payload=s,a=JSON.stringify(i),!(!(l=o._audit.allowedOrigins)||!l.length||("function"==typeof r&&function(e,t,n){var r=!(2<arguments.length&&void 0!==n)||n;ya(!jo[e],"A replyHandler already exists for this message channel."),jo[e]={replyHandler:t,sendToParent:r}}(t.channelId,r,n),l.forEach((function(t){try{e.postMessage(a,t)}catch(n){if(n instanceof e.DOMException)throw new Error('allowedOrigins value "'.concat(t,'" is not a valid origin'));throw n}})),0)))}function Vo(e,t,n){var r=!(2<arguments.length&&void 0!==n)||n;return function(n,a,o){zo(e,{channelId:t,message:n,keepalive:a},r,o)}}function $o(e,n){var r,u,i,s=e.origin,l=e.data;e=e.source;try{var c=func\
tion(e){var n,r,o,u;try{n=JSON.parse(e)}catch(e){return}if(null!==(e=n)&&"object"===a(e)&&"string"==typeof e.channelId&&e.source===So())return r=(e=n).topic,o=e.channelId,u=e.messageId,e=e.keepalive,{topic:r,message:"object"===a(n.error)?function(e){var n=e.message||"Unknown error occurred",r=_o.includes(e.name)?e.name:"Error";return r=t[r]||Error,e.stack&&(n+="\\n"+e.stack.replace(e.message,"")),new r(n)}(n.error):n.payload,messageId:u,channelId:o,keepalive:!!e}}(l)||{},d=c.channelId,p=c.message,f=c.messageId;if(u=s,((i=o._audit.allowedOrigins)&&i.includes("*")||i.includes(u))&&(r=f,!Lo.includes(r))&&(Lo.push(r),1))if(p instanceof Error&&e.parent!==t)o.log(p);else try{if(c.topic){var D=Vo(e,d);Mo(e),n(c,D)}else{var m=e,h=(b=c).channelId,g=b.message,b=b.keepalive,v=(y=function(e){return jo[e]}(h)||{}).replyHandler,y=y.sendToParent;if(v){(y?Mo:Po)(m),m=Vo(m,h,y),!b&&h&&function(e){delete jo[e]}(h);try{v(g,b,m)}catch(n){o.log(n),m(n,b)}}}}catch(n){var F=e,w=n,E=d;if(!F.parent!==t)o.log(w)\
;else try{zo(F,{topic:null,channelId:E,message:w,messageId:qo(),keepalive:!0},!0)}catch(n){return void o.log(n)}}}catch(n){o.log(n)}}var Ho,Uo,Go={open:function(e){var n;if("function"==typeof t.addEventListener)return t.addEventListener("message",n=function(t){$o(t,e)},!1),function(){t.removeEventListener("message",n,!1)}},post:function(e,n,r){return"function"==typeof t.addEventListener&&zo(e,n,!1,r)}};function Wo(e){e.updateMessenger(Go)}var Yo={};function Ko(e,t,n,r,a){return t={topic:t,message:n,channelId:"".concat(Ro(),":").concat(Ro()),keepalive:r},Uo(e,t,a)}function Xo(e,t){var n=e.topic,r=e.message;e=e.keepalive;if(n=Yo[n])try{n(r,e,t)}catch(n){o.log(n),t(n,e)}}function Zo(e,t,n,r){var a,o=e.contentWindow,u=null!=(u=null==(u=t.options)?void 0:u.pingWaitTime)?u:500;o?0===u?Jo(e,t,n,r):(a=setTimeout((function(){a=setTimeout((function(){t.debug?r(Qo("No response from frame",e)):n(null)}),0)}),u),Ko(o,"axe.ping",null,void 0,(function(){clearTimeout(a),Jo(e,t,n,r)}))):(aa("Frame does\
 not have a content window",e),n(null))}function Jo(e,t,n,r){var a=null!=(a=null==(a=t.options)?void 0:a.frameWaitTime)?a:6e4,o=e.contentWindow,u=setTimeout((function(){r(Qo("Axe in frame timed out",e))}),a);Ko(o,"axe.start",t,void 0,(function(e){clearTimeout(u),(e instanceof Error==0?n:r)(e)}))}function Qo(e,t){var n;return o._tree&&(n=Ua(t)),new Error(e+": "+(n||t))}Ko.updateMessenger=function(e){var t=e.open;e=e.post,ya("function"==typeof t,"open callback must be a function"),ya("function"==typeof e,"post callback must be a function"),Ho&&Ho(),t=t(Xo);Ho=t?(ya("function"==typeof t,"open callback must return a cleanup function"),t):null,Uo=e},Ko.subscribe=function(e,t){ya("function"==typeof t,"Subscriber callback must be a function"),ya(!Yo[e],"Topic ".concat(e," is already registered to.")),Yo[e]=t},Ko.isInFrame=function(){return!!(0<arguments.length&&void 0!==arguments[0]?arguments[0]:t).frameElement},Wo(Ko);var eu=null,tu={update:function(e){ya("object"===a(e),"serializer must be \
an object"),eu=e},toSpec:function(e){return tu.dqElmToSpec(new eo(e))},dqElmToSpec:function(e,t){var n,r,a,o,u;return e instanceof eo==0?e:(t&&(r=(n=e).fromFrame,a=t.ancestry,o=t.xpath,u=!1!==t.selectors||r,(n=new eo(n.element,t,{source:n.source,nodeIndexes:n.nodeIndexes,selector:u?n.selector:[":root"],ancestry:a?n.ancestry:[":root"],xpath:o?n.xpath:"/"})).fromFrame=r,e=n),"function"==typeof(null==(t=eu)?void 0:t.toSpec)?eu.toSpec(e):e.toJSON())},mergeSpecs:function(e,t){var n;return("function"==typeof(null==(n=eu)?void 0:n.mergeSpecs)?eu:eo).mergeSpecs(e,t)},mapRawResults:function(e){return e.map((function(e){return q({},e,{nodes:tu.mapRawNodeResults(e.nodes)})}))},mapRawNodeResults:function(e){return null==e?void 0:e.map((function(e){var t=e.node,n=I(e,i);n.node=tu.dqElmToSpec(t);for(var r=0,a=["any","all","none"];r<a.length;r++){var o=a[r];n[o]=n[o].map((function(e){var t=e.relatedNodes;return(e=I(e,s)).relatedNodes=t.map(tu.dqElmToSpec),e}))}return n}))}},nu=tu,ru=function(e){retur\
n[].concat(e.any||[]).concat(e.all||[]).concat(e.none||[])},au=function(e,t,n){if(Array.isArray(e))return e.find((function(e){return null!==e&&"object"===a(e)&&Object.hasOwn(e,t)&&e[t]===n}))};function ou(e,t){for(var n=0<arguments.length&&void 0!==e?e:[],r=1<arguments.length&&void 0!==t?t:[],a=Math.max(null==n?void 0:n.length,null==r?void 0:r.length),o=0;o<a;o++){var u=null==n?void 0:n[o],i=null==r?void 0:r[o];if("number"!=typeof u||isNaN(u))return 0===o?1:-1;if("number"!=typeof i||isNaN(i))return 0===o?-1:1;if(u!==i)return u-i}return 0}var uu=function(e,t){var n=[];return e.forEach((function(e){var t,r=(r=e)&&r.results?Array.isArray(r.results)?r.results.length?r.results:null:[r.results]:null;r&&r.length&&(t=function(e){return e.frameElement?nu.toSpec(e.frameElement):e.frameSpec?e.frameSpec:null}(e),r.forEach((function(e){e.nodes&&t&&(a=e.nodes,r=t,a.forEach((function(e){e.node=nu.mergeSpecs(e.node,r),ru(e).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){return nu.\
mergeSpecs(e,r)}))}))})));var r,a=au(n,"id",e.id);if(a){if(e.nodes.length){for(var o=a.nodes,u=e.nodes,i=u[0].node,s=0;s<o.length;s++){var l=o[s].node,c=ou(l.nodeIndexes,i.nodeIndexes);if(0<c||0===c&&i.selector.length<l.selector.length)return void o.splice.apply(o,[s,0].concat(j(u)))}o.push.apply(o,j(u))}}else n.push(e)})))})),n.forEach((function(e){e.nodes&&e.nodes.sort((function(e,t){return ou(e.node.nodeIndexes,t.node.nodeIndexes)}))})),n};function iu(e,t,n,r,a,o){t=q({},t,{elementRef:!1});var u=vo();e.frames.forEach((function(e){var a=e.node,o=I(e,l);u.defer((function(e,u){Zo(a,{options:t,command:n,parameter:r,context:o},(function(t){return e(t?{results:t,frameElement:a}:null)}),u)}))})),u.then((function(e){a(uu(e,t))})).catch(o)}function su(e,t){if(!e.shadowId&&!t.shadowId&&e.actualNode&&"function"==typeof e.actualNode.contains)return e.actualNode.contains(t.actualNode);do{if(e===t)return!0;if(t.nodeIndex<e.nodeIndex)return!1}while(t=t.parent);return!1}var lu=function e(){for(var \
t={},n=arguments.length,r=new Array(n),o=0;o<n;o++)r[o]=arguments[o];return r.forEach((function(n){if(n&&"object"===a(n)&&!Array.isArray(n))for(var r=0,o=Object.keys(n);r<o.length;r++){var u=o[r];!t.hasOwnProperty(u)||"object"!==a(n[u])||Array.isArray(t[u])?t[u]=n[u]:t[u]=e(t[u],n[u])}})),t},cu=function(e,t){Object.assign(e,t),Object.keys(t).filter((function(e){return"function"==typeof t[e]})).forEach((function(n){e[n]=null;try{e[n]=t[n](e)}catch(n){}}))},du=["article","aside","blockquote","body","div","footer","h1","h2","h3","h4","h5","h6","header","main","nav","p","section","span"],pu=function(e){return!!(e.shadowRoot&&(e=e.nodeName.toLowerCase(),du.includes(e)||/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(e)))},fu={},Du=(se(fu,{createGrid:function(){return di},findElmsInContext:function(){return hu},findNearbyElms:function(){return bi},findUp:function(){return bu},findUpVirtual:function(){return gu},focusDisabled:function(){return xi},getComposedParent:function(){return Lu},getElementByR\
eference:function(){return Ni},getElementCoordinates:function(){return zu},getElementStack:function(){return _i},getModalDialog:function(){return yi},getOverflowHiddenAncestors:function(){return Fu},getRootNode:function(){return mu},getScrollOffset:function(){return qu},getTabbableElements:function(){return Si},getTargetRects:function(){return ji},getTargetSize:function(){return Li},getTextElementStack:function(){return wl},getViewportSize:function(){return Vu},getVisibleChildTextRects:function(){return yl},hasContent:function(){return Bl},hasContentVirtual:function(){return kl},hasLangText:function(){return Nl},idrefs:function(){return zi},insertedIntoFocusOrder:function(){return Tl},isCurrentPageLink:function(){return Bi},isFocusable:function(){return Pi},isHTML5:function(){return Sl},isHiddenForEveryone:function(){return Pu},isHiddenWithCSS:function(){return _l},isInTabOrder:function(){return Ii},isInTextBlock:function(){return jl},isInert:function(){return Fi},isModalOpen:function(\
){return Ll},isMultiline:function(){return ql},isNativelyFocusable:function(){return Mi},isNode:function(){return zl},isOffscreen:function(){return $u},isOpaque:function(){return Rp},isSkipLink:function(){return Op},isVisible:function(){return Pp},isVisibleOnScreen:function(){return Uu},isVisibleToScreenReaders:function(){return Ps},isVisualContent:function(){return Cl},reduceToElementsBelowFloating:function(){return Ip},shadowElementsFromPoint:function(){return qp},urlPropsFromAttribute:function(){return zp},visuallyContains:function(){return jp},visuallyOverlaps:function(){return Vp},visuallySort:function(){return Ti}}),function(e){var t=e.getRootNode&&e.getRootNode()||r;return t===e?r:t}),mu=Du,hu=function(e){var t=e.context,n=e.value,r=e.attr;e=void 0===(e=e.elm)?"":e,n=wa(n),t=9===t.nodeType||11===t.nodeType?t:mu(t);return Array.from(t.querySelectorAll(e+"["+r+"="+n+"]"))},gu=function(e,t){var n=e.actualNode;if(!e.shadowId&&"function"==typeof e.actualNode.closest)return e.actualNo\
de.closest(t)||null;for(;(n=(n=n.assignedSlot||n.parentNode)&&11===n.nodeType?n.host:n)&&!Ba(n,t)&&n!==r.documentElement;);return n&&Ba(n,t)?n:null},bu=function(e,t){return gu(Za(e),t)};function vu(e,t){return(0|e.left)<(0|t.right)&&(0|e.right)>(0|t.left)&&(0|e.top)<(0|t.bottom)&&(0|e.bottom)>(0|t.top)}var yu=Ta((function(e){var t=[];return e?("hidden"===e.getComputedStylePropertyValue("overflow")&&t.push(e),t.concat(yu(e.parent))):t})),Fu=yu,wu=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,Eu=/(\\w+)\\((\\d+)/;function Cu(e){return["style","script","noscript","template"].includes(e.props.nodeName)}function xu(e){return"area"!==e.props.nodeName&&"none"===e.getComputedStylePropertyValue("display")}function Au(e){return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&["hidden","collapse"].includes(e.getComputedStylePropertyValue("visibility"))}function ku(e){return!!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&"hid\
den"===e.getComputedStylePropertyValue("content-visibility")}function Bu(e){return"true"===e.attr("aria-hidden")}function Nu(e){return"0"===e.getComputedStylePropertyValue("opacity")}function Tu(e){var t=Nf(e.actualNode),n=parseInt(e.getComputedStylePropertyValue("height"));e=parseInt(e.getComputedStylePropertyValue("width"));return!!t&&(0===n||0===e)}function Ru(e){var t,n,r;return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&"fixed"!==(t=e.getComputedStylePropertyValue("position"))&&!!(n=Fu(e)).length&&(r=e.boundingClientRect,n.some((function(n){return!("absolute"===t&&!function(e,t){for(var n=e.parent;n&&n!==t;){if(["relative","sticky"].includes(n.getComputedStylePropertyValue("position")))return 1;n=n.parent}}(e,n)&&"static"===n.getComputedStylePropertyValue("position"))&&((n=n.boundingClientRect).width<2||n.height<2||!vu(r,n))})))}function Ou(e){var t=e.getComputedStylePropertyValue("clip").match(wu),n=e.getComputedStylePropertyValue("clip-path").match(E\
u);if(t&&5===t.length&&(e=e.getComputedStylePropertyValue("position"),["fixed","absolute"].includes(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var r=parseInt(n[2],10);switch(e){case"inset":return 50<=r;case"circle":return 0===r}}return!1}function _u(e,t){var n,r=fo(e,"map");return!r||!((r=r.attr("name"))&&(e=Du(e.actualNode))&&9===e.nodeType&&(n=sD(o._tree,'img[usemap="#'.concat(wa(r),'"]')))&&n.length)||n.some((function(e){return!t(e)}))}function Su(e){var t;return"details"===(null==(t=e.parent)?void 0:t.props.nodeName)&&(("summary"!==e.props.nodeName||e.parent.children.find((function(e){return"summary"===e.props.nodeName}))!==e)&&!e.parent.hasAttr("open"))}var Mu=[xu,Au,ku,Su];function Pu(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=void 0!==(n=n.isAncestor)&&n;return e=zf(e).vNode,(t?Iu:ju)(e,n)}var Iu=Ta((function(e,t){return!!Cu(e)||!(!e.actualNode||!Mu.some((function(n){return n(e,{isAncestor:t})}))&&e.actualNode.isConnected)})),j\
u=Ta((function(e,t){return!!Iu(e,t)||!!e.parent&&ju(e.parent,!0)})),Lu=function e(t){if(t.assignedSlot)return e(t.assignedSlot);if(t.parentNode){if(1===(t=t.parentNode).nodeType)return t;if(t.host)return t.host}return null},qu=function(e){var t,n;return 9===(e=!e.nodeType&&e.document?e.document:e).nodeType?(t=e.documentElement,n=e.body,{left:t&&t.scrollLeft||n&&n.scrollLeft||0,top:t&&t.scrollTop||n&&n.scrollTop||0}):{left:e.scrollLeft,top:e.scrollTop}},zu=function(e){var t=(n=qu(r)).left,n=n.top;return{top:(e=e.getBoundingClientRect()).top+n,right:e.right+t,bottom:e.bottom+n,left:e.left+t,width:e.right-e.left,height:e.bottom-e.top}},Vu=function(e){var t=e.document,n=t.documentElement;return e.innerWidth?{width:e.innerWidth,height:e.innerHeight}:n?{width:n.clientWidth,height:n.clientHeight}:{width:(e=t.body).clientWidth,height:e.clientHeight}},$u=function(e){if((1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor)return!1;var n=zf(e).domNode;if(n){var a=r.documentEleme\
nt,o=t.getComputedStyle(n),u=t.getComputedStyle(r.body||a).getPropertyValue("direction"),i=zu(n);if(i.bottom<0&&(function(e,t){for(e=Lu(e);e&&"html"!==e.nodeName.toLowerCase();){if(e.scrollTop&&0<=(t+=e.scrollTop))return;e=Lu(e)}return 1}(n,i.bottom)||"absolute"===o.position))return!0;if(0!==i.left||0!==i.right)if("ltr"===u){if(i.right<=0)return!0}else if(n=Math.max(a.scrollWidth,Vu(t).width),i.left>=n)return!0;return!1}},Hu=[Nu,Tu,Ru,Ou,$u];function Uu(e){return e=zf(e).vNode,Gu(e)}var Gu=Ta((function(e,t){return e.actualNode&&"area"===e.props.nodeName?!_u(e,Gu):!(Pu(e,{skipAncestors:!0,isAncestor:t})||e.actualNode&&Hu.some((function(n){return n(e,{isAncestor:t})})))&&(!e.parent||Gu(e.parent,!0))}));function Wu(e,n){var r=Math.min(e.top,n.top),a=Math.max(e.right,n.right),o=Math.max(e.bottom,n.bottom);e=Math.min(e.left,n.left);return new t.DOMRect(e,r,a-e,o-r)}function Yu(e,t){var n=e.x,r=(e=e.y,t.top),a=t.right,o=t.bottom;t=t.left;return r<=e&&n<=a&&e<=o&&t<=n}var Ku={};function Xu(e,\
n){var r=Math.max(e.left,n.left),a=Math.min(e.right,n.right),o=Math.max(e.top,n.top);e=Math.min(e.bottom,n.bottom);return a<=r||e<=o?null:new t.DOMRect(r,o,a-r,e-o)}function Zu(e){var n=e.left,r=e.top,a=e.width;e=e.height;return new t.DOMPoint(n+a/2,r+e/2)}se(Ku,{getBoundingRect:function(){return Wu},getIntersectionRect:function(){return Xu},getOffset:function(){return ei},getRectCenter:function(){return Zu},hasVisualOverlap:function(){return ni},isPointInRect:function(){return Yu},rectHasMinimumSize:function(){return Qu},rectsOverlap:function(){return vu},splitRects:function(){return ri}});var Ju=.05;function Qu(e,t){var n=t.width;t=t.height;return e<=n+Ju&&e<=t+Ju}function ei(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:12,r=ji(e),a=ji(t);if(!r.length||!a.length)return null;var o,u=Zu(r.reduce(Wu)),i=1/0,s=Y(a);try{for(s.s();!(o=s.n()).done;){var l=o.value;if(Yu(u,l))return 0;var c=ti(u,function(e,t){return{x:e.x<t.left?t.left:e.x>t.right?t.right:e.x,y:t=e.y<t.to\
p?t.top:e.y>t.bottom?t.bottom:e.y}}(u,l));i=Math.min(i,c)}}catch(e){s.e(e)}finally{s.f()}return Qu(2*n,Li(t))?i:(r=ti(u,Zu(a.reduce(Wu)))-n,Math.max(0,Math.min(i,r)))}function ti(e,t){return Math.hypot(e.x-t.x,e.y-t.y)}function ni(e,t){var n=e.boundingClientRect,r=t.boundingClientRect;return!(n.left>=r.right||n.right<=r.left||n.top>=r.bottom||n.bottom<=r.top)&&0<Ti(e,t)}function ri(e,t){var n,r=[e],a=Y(t);try{function o(){var e=n.value;if(4e3<(r=r.reduce((function(t,n){return t.concat(function(e,t){var n=e.top,r=e.left,a=e.bottom,o=e.right,u=n<t.bottom&&a>t.top,i=r<t.right&&o>t.left,s=[];if(ai(t.top,n,a)&&i&&s.push({top:n,left:r,bottom:t.top,right:o}),ai(t.right,r,o)&&u&&s.push({top:n,left:t.right,bottom:a,right:o}),ai(t.bottom,n,a)&&i&&s.push({top:t.bottom,right:o,bottom:a,left:r}),ai(t.left,r,o)&&u&&s.push({top:n,left:r,bottom:a,right:t.left}),0===s.length){if(function(e,t){return e.top>=t.top&&e.left>=t.left&&e.bottom<=t.bottom&&e.right<=t.right}(e,t))return[];s.push(e)}return s.map\
(oi)}(n,e))}),[])).length)throw new Error("splitRects: Too many rects")}for(a.s();!(n=a.n()).done;)o()}catch(e){a.e(e)}finally{a.f()}return r}var ai=function(e,t,n){return t<e&&e<n};function oi(e){return new t.DOMRect(e.left,e.top,e.right-e.left,e.bottom-e.top)}var ui=0,ii=.1,si=.2,li=.3,ci=0;function di(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:r.body,n=1<arguments.length?arguments[1]:void 0,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!Xa.get("gridCreated")||a){Xa.set("gridCreated",!0),a||(i=(i=Za(r.documentElement))||new Gp(r.documentElement),ci=0,i._stackingOrder=[Di(ui,ci++,null)],mi(n=null!=n?n:new hi,i),Nf(i.actualNode)&&(u=new hi(i),i._subGrid=u));for(var u,i,s=r.createTreeWalker(e,t.NodeFilter.SHOW_ELEMENT,null,!1),l=a?s.nextNode():s.currentNode;l;){var c=Za(l),d=(c&&c.parent?a=c.parent:l.assignedSlot?a=Za(l.assignedSlot):l.parentElement?a=Za(l.parentElement):l.parentNode&&Za(l.parentNode)&&(a=Za(l.parentNode)),(c=c||new o.VirtualNode(l\
,a))._stackingOrder=function(e,t,n){var r=t._stackingOrder.slice();pi(e,t)&&-1!==(a=r.findIndex((function(e){return e=e.stackLevel,[ui,si,li].includes(e)})))&&r.splice(a,r.length-a);var a=function(e,t){var n=function(e,t){return"static"!==e.getComputedStylePropertyValue("position")||fi(t)?e.getComputedStylePropertyValue("z-index"):"auto"}(e,t);return["auto","0"].includes(n)?"static"!==e.getComputedStylePropertyValue("position")?li:"none"!==e.getComputedStylePropertyValue("float")?si:pi(e,t)?ii:null:parseInt(n)}(e,t);return null!==a&&r.push(Di(a,n,e)),r}(c,a,ci++),function(e,t){for(var n=null,r=[e];t;){if(Nf(t.actualNode)){n=t;break}if(t._scrollRegionParent){n=t._scrollRegionParent;break}r.push(t),t=Za(t.actualNode.parentElement||t.actualNode.parentNode)}return r.forEach((function(e){return e._scrollRegionParent=n})),n}(c,a)),p=(d=d?d._subGrid:n,Nf(c.actualNode)&&(p=new hi(c),c._subGrid=p),c.boundingClientRect);0!==p.width&&0!==p.height&&Uu(l)&&mi(d,c),pu(l)&&di(l.shadowRoot,d,c),l=s.ne\
xtNode()}}return ra.gridSize}function pi(e,t){var n=e.getComputedStylePropertyValue("position"),r=e.getComputedStylePropertyValue("z-index");return"fixed"===n||"sticky"===n||"auto"!==r&&"static"!==n||"1"!==e.getComputedStylePropertyValue("opacity")||"none"!==(e.getComputedStylePropertyValue("-webkit-transform")||e.getComputedStylePropertyValue("-ms-transform")||e.getComputedStylePropertyValue("transform")||"none")||(n=e.getComputedStylePropertyValue("mix-blend-mode"))&&"normal"!==n||(n=e.getComputedStylePropertyValue("filter"))&&"none"!==n||(n=e.getComputedStylePropertyValue("perspective"))&&"none"!==n||(n=e.getComputedStylePropertyValue("clip-path"))&&"none"!==n||"none"!==(e.getComputedStylePropertyValue("-webkit-mask")||e.getComputedStylePropertyValue("mask")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-image")||e.getComputedStylePropertyValue("mask-image")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-border")||e.getComputedStylePropertyValue\
("mask-border")||"none")||"isolate"===e.getComputedStylePropertyValue("isolation")||"transform"===(n=e.getComputedStylePropertyValue("will-change"))||"opacity"===n||"touch"===e.getComputedStylePropertyValue("-webkit-overflow-scrolling")||(n=e.getComputedStylePropertyValue("contain"),["layout","paint","strict","content"].includes(n))||!("auto"===r||!fi(t))}function fi(e){if(e)return e=e.getComputedStylePropertyValue("display"),["flex","inline-flex","grid","inline-grid"].includes(e)}function Di(e,t,n){return{stackLevel:e,treeOrder:t,vNode:n}}function mi(e,t){var n=Fu(t);t.clientRects.forEach((function(r){r=n.reduce((function(e,t){return e&&Xu(e,t.boundingClientRect)}),r);r&&(null==t._grid&&(t._grid=e),r=e.getGridPositionOfRect(r),e.loopGridPosition(r,(function(e){e.includes(t)||e.push(t)})))}))}var hi=G((function e(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;H(this,e),this.container=t,this.cells=[]}),[{key:"toGridIndex",value:function(e){return Math.floor(e/ra.gri\
dSize)}},{key:"getCellFromPoint",value:function(e){var t=e.x;e=e.y,ya(this.boundaries,"Grid does not have cells added"),e=this.toGridIndex(e),t=this.toGridIndex(t);return null!=(t=(e=(ya(Yu({y:e,x:t},this.boundaries),"Element midpoint exceeds the grid bounds"),null!=(e=this.cells[e-this.cells._negativeIndex])?e:[]))[t-e._negativeIndex])?t:[]}},{key:"loopGridPosition",value:function(e,t){var n=(o=e).left,r=o.right,a=o.top,o=o.bottom;this.boundaries&&(e=Wu(this.boundaries,e)),this.boundaries=e,gi(this.cells,a,o,(function(e,a){gi(e,n,r,(function(e,n){t(e,{row:a,col:n})}))}))}},{key:"getGridPositionOfRect",value:function(e){var n=e.top,r=e.right,a=e.bottom,o=e.left,u=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;n=this.toGridIndex(n-u),r=this.toGridIndex(r+u-1),a=this.toGridIndex(a+u-1),o=this.toGridIndex(o-u);return new t.DOMRect(o,n,r-o,a-n)}}]);function gi(e,t,n,r){if(null!=e._negativeIndex||(e._negativeIndex=0),t<e._negativeIndex){for(var a=0;a<e._negativeIndex-t;a++)e.splic\
e(0,0,[]);e._negativeIndex=t}for(var o,u=t-e._negativeIndex,i=n-e._negativeIndex,s=u;s<=i;s++)null==e[o=s]&&(e[o]=[]),r(e[s],s+e._negativeIndex)}function bi(e){var t,n,r,a,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return di(),null!=(r=e._grid)&&null!=(r=r.cells)&&r.length?(r=e.boundingClientRect,t=e._grid,n=vi(e),r=t.getGridPositionOfRect(r,o),a=[],t.loopGridPosition(r,(function(t){var r,o=Y(t);try{for(o.s();!(r=o.n()).done;){var u=r.value;u&&u!==e&&!a.includes(u)&&n===vi(u)&&a.push(u)}}catch(t){o.e(t)}finally{o.f()}})),a):[]}var vi=Ta((function(e){return!!e&&("fixed"===e.getComputedStylePropertyValue("position")||vi(e.parent))})),yi=Ta((function(){var e;return o._tree&&(e=Jf(o._tree[0],"dialog[open]",(function(e){var t=e.boundingClientRect;return r.elementsFromPoint(t.left+1,t.top+1).includes(e.actualNode)&&Uu(e)}))).length?e.find((function(e){var t=e.boundingClientRect;return r.elementsFromPoint(t.left-10,t.top-10).includes(e.actualNode)}))||(null!=(e=e.find((functio\
n(e){e=null!=(e=function(e){di();var n=o._tree[0]._grid,r=new t.DOMRect(0,0,t.innerWidth,t.innerHeight);if(n)for(var a=0;a<n.cells.length;a++){var u=n.cells[a];if(u)for(var i=0;i<u.length;i++){var s=u[i];if(s)for(var l=0;l<s.length;l++){var c=s[l],d=Xu(c.boundingClientRect,r);if("html"!==c.props.nodeName&&c!==e&&"none"!==c.getComputedStylePropertyValue("pointer-events")&&d)return{vNode:c,rect:d}}}}}(e))?e:{};var n=e.vNode;e=e.rect;return!!n&&!r.elementsFromPoint(e.left+1,e.top+1).includes(n.actualNode)})))?e:null):null}));function Fi(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=n.isAncestor;return(t?wi:Ei)(e,n)}var wi=Ta((function(e,t){return!!e.hasAttr("inert")||!(t||!e.actualNode||!(t=yi())||su(t,e))})),Ei=Ta((function(e,t){return!!wi(e,t)||!!e.parent&&Ei(e.parent,!0)})),Ci=["button","command","fieldset","keygen","optgroup","option","select","textarea","input"],xi=function(e){var t=zf(e).vNode;if(e=t.props.nodeName,Ci.includes(e)&&t.hasAttr("\
disabled")||Fi(t))return!0;for(var n=t.parent,r=[],a=!1;n&&n.shadowId===t.shadowId&&!a&&(r.push(n),"legend"!==n.props.nodeName);){if(void 0!==n._inDisabledFieldset){a=n._inDisabledFieldset;break}"fieldset"===n.props.nodeName&&n.hasAttr("disabled")&&(a=!0),n=n.parent}return r.forEach((function(e){return e._inDisabledFieldset=a})),!!a||"area"!==t.props.nodeName&&!!t.actualNode&&Pu(t)},Ai=/^\\/\\#/,ki=/^#[!/]/;function Bi(e){var n,r,a,o,u=e.getAttribute("href");return!(!u||"#"===u)&&(!!Ai.test(u)||(o=e.hash,n=e.protocol,r=e.hostname,a=e.port,e=e.pathname,!ki.test(o)&&("#"===u.charAt(0)||("string"!=typeof(null==(o=t.location)?void 0:o.origin)||-1===t.location.origin.indexOf("://")?null:(u=t.location.origin+t.location.pathname,o=r?"".concat(n,"//").concat(r).concat(a?":".concat(a):""):t.location.origin,(o+=e?("/"!==e[0]?"/":"")+e:t.location.pathname)===u)))))}var Ni=function(e,t){var n=e.getAttribute(t);return n&&("href"!==t||Bi(e))?(-1!==n.indexOf("#")&&(n=decodeURIComponent(n.substr(n.index\
Of("#")+1))),(t=r.getElementById(n))||((t=r.getElementsByName(n)).length?t[0]:null)):null};function Ti(e,n){di();for(var r=Math.max(e._stackingOrder.length,n._stackingOrder.length),a=0;a<r;a++){if(void 0===n._stackingOrder[a])return-1;if(void 0===e._stackingOrder[a])return 1;if(n._stackingOrder[a].stackLevel>e._stackingOrder[a].stackLevel)return 1;if(n._stackingOrder[a].stackLevel<e._stackingOrder[a].stackLevel)return-1;if(n._stackingOrder[a].treeOrder!==e._stackingOrder[a].treeOrder)return n._stackingOrder[a].treeOrder-e._stackingOrder[a].treeOrder}var o=e.actualNode,u=n.actualNode;if(o.getRootNode&&o.getRootNode()!==u.getRootNode()){for(var i=[];o;)i.push({root:o.getRootNode(),node:o}),o=o.getRootNode().host;for(;u&&!i.find((function(e){return e.root===u.getRootNode()}));)u=u.getRootNode().host;if((o=i.find((function(e){return e.root===u.getRootNode()})).node)===u)return e.actualNode.getRootNode()!==o.getRootNode()?-1:1}var s,l=(d=t.Node).DOCUMENT_POSITION_FOLLOWING,c=d.DOCUMENT_POSI\
TION_CONTAINS,d=d.DOCUMENT_POSITION_CONTAINED_BY;l=(s=o.compareDocumentPosition(u))&l?1:-1,c=s&c||s&d;return(s=Ri(e))===(d=Ri(n))||c?l:d-s}function Ri(e){return-1!==e.getComputedStylePropertyValue("display").indexOf("inline")?2:function e(t){if(!t)return!1;if(void 0!==t._isFloated)return t._isFloated;var n=t.getComputedStylePropertyValue("float");return"none"!==n?t._isFloated=!0:(n=e(t.parent),t._isFloated=n,n)}(e)?1:0}function Oi(e,t,n){var a=2<arguments.length&&void 0!==n&&n,o=Zu(t),u=e.getCellFromPoint(o)||[],i=Math.floor(o.x),s=Math.floor(o.y);o=u.filter((function(e){return e.clientRects.some((function(e){var t=e.left,n=e.top;return i<Math.floor(t+e.width)&&i>=Math.floor(t)&&s<Math.floor(n+e.height)&&s>=Math.floor(n)}))}));return(u=e.container)&&(o=Oi(u._grid,u.boundingClientRect,!0).concat(o)),a?o:o.sort(Ti).map((function(e){return e.actualNode})).concat(r.documentElement).filter((function(e,t,n){return n.indexOf(e)===t}))}var _i=function(e){di();var t=(e=Za(e))._grid;return t?Oi(\
t,e.boundingClientRect):[]},Si=function(e){return sD(e,"*").filter((function(e){var t=e.isFocusable;return(e=(e=e.actualNode.getAttribute("tabindex"))&&!isNaN(parseInt(e,10))?parseInt(e):null)?t&&0<=e:t}))},Mi=function(e){var t=zf(e).vNode;if(t&&!xi(t))switch(t.props.nodeName){case"a":case"area":if(t.hasAttr("href"))return!0;break;case"input":return"hidden"!==t.props.type;case"textarea":case"select":case"summary":case"button":return!0;case"details":return!sD(t,"summary").length}return!1};function Pi(e){return 1===(e=zf(e).vNode).props.nodeType&&!(xi(e)||!Mi(e)&&(!(e=e.attr("tabindex"))||isNaN(parseInt(e,10))))}function Ii(e){return 1===(e=zf(e).vNode).props.nodeType&&!(parseInt(e.attr("tabindex",10))<=-1)&&Pi(e)}var ji=Ta((function(e){var t=e.boundingClientRect,n=bi(e).filter((function(t){return ni(e,t)&&"none"!==t.getComputedStylePropertyValue("pointer-events")&&!(su(e,t)&&!Ii(t))}));return n.length?(n=n.map((function(e){return e.boundingClientRect})),ri(t,n)):[t]})),Li=Ta((function(e\
,t){return function(e,t){return e.reduce((function(e,n){var r=Qu(t,e);return r!==Qu(t,n)?r?e:n:(r=e.width*e.height,n.width*n.height<r?e:n)}))}(ji(e),t)})),qi={},zi=(se(qi,{accessibleText:function(){return Vi},accessibleTextVirtual:function(){return sl},autocomplete:function(){return pl},formControlValue:function(){return Xs},formControlValueMethods:function(){return Ys},hasUnicode:function(){return ul},isHumanInterpretable:function(){return dl},isIconLigature:function(){return il},isValidAutocomplete:function(){return fl},label:function(){return gl},labelText:function(){return Qs},labelVirtual:function(){return hl},nativeElementType:function(){return bl},nativeTextAlternative:function(){return al},nativeTextMethods:function(){return rl},removeUnicode:function(){return cl},sanitize:function(){return ls},subtreeText:function(){return Js},titleText:function(){return Os},unsupported:function(){return Ms},visible:function(){return ml},visibleTextNodes:function(){return vl},visibleVirtual:fu\
nction(){return js}}),function(e,t){e=e.actualNode||e;try{var n=mu(e),r=[];if(a=e.getAttribute(t))for(var a=Wp(a),o=0;o<a.length;o++)r.push(n.getElementById(a[o]));return r}catch(e){throw new TypeError("Cannot resolve id references for non-DOM nodes")}}),Vi=function(e,t){return sl(Za(e),t)},$i=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=zf(e).vNode;return 1!==(null==n?void 0:n.props.nodeType)||1!==n.props.nodeType||t.inLabelledByContext||t.inControlContext||!n.attr("aria-labelledby")?"":zi(n,"aria-labelledby").filter((function(e){return e})).reduce((function(e,r){return r=Vi(r,q({inLabelledByContext:!0,startNode:t.startNode||n},t)),e?"".concat(e," ").concat(r):r}),"")};function Hi(e){return 1===(null==(e=zf(e).vNode)?void 0:e.props.nodeType)&&e.attr("aria-label")||""}var Ui={"aria-activedescendant":{type:"idref",allowEmpty:!0},"aria-atomic":{type:"boolean",global:!0},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"]},"aria-brai\
llelabel":{type:"string",allowEmpty:!0,global:!0},"aria-brailleroledescription":{type:"string",allowEmpty:!0,global:!0},"aria-busy":{type:"boolean",global:!0},"aria-checked":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-colcount":{type:"int",minValue:-1},"aria-colindex":{type:"int",minValue:1},"aria-colspan":{type:"int",minValue:1},"aria-controls":{type:"idrefs",allowEmpty:!0,global:!0},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],global:!0},"aria-describedby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-description":{type:"string",allowEmpty:!0,global:!0},"aria-details":{type:"idref",allowEmpty:!0,global:!0},"aria-disabled":{type:"boolean",global:!0},"aria-dropeffect":{type:"nmtokens",values:["copy","execute","link","move","none","popup"],global:!0},"aria-errormessage":{type:"idref",allowEmpty:!0,global:!0},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"]},"aria-flowto":{type:"idref\
s",allowEmpty:!0,global:!0},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],global:!0},"aria-hidden":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-invalid":{type:"nmtoken",values:["grammar","false","spelling","true"],global:!0},"aria-keyshortcuts":{type:"string",allowEmpty:!0,global:!0},"aria-label":{type:"string",allowEmpty:!0,global:!0},"aria-labelledby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-level":{type:"int",minValue:1},"aria-live":{type:"nmtoken",values:["assertive","off","polite"],global:!0},"aria-modal":{type:"boolean"},"aria-multiline":{type:"boolean"},"aria-multiselectable":{type:"boolean"},"aria-orientation":{type:"nmtoken",values:["horizontal","undefined","vertical"]},"aria-owns":{type:"idrefs",allowEmpty:!0,global:!0},"aria-placeholder":{type:"string",allowEmpty:!0},"aria-posinset":{type:"int",minValue:1},\
"aria-pressed":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-readonly":{type:"boolean"},"aria-relevant":{type:"nmtokens",values:["additions","all","removals","text"],global:!0},"aria-required":{type:"boolean"},"aria-roledescription":{type:"string",allowEmpty:!0,global:!0},"aria-rowcount":{type:"int",minValue:-1},"aria-rowindex":{type:"int",minValue:1},"aria-rowspan":{type:"int",minValue:0},"aria-selected":{type:"nmtoken",values:["false","true","undefined"]},"aria-setsize":{type:"int",minValue:-1},"aria-sort":{type:"nmtoken",values:["ascending","descending","none","other"]},"aria-valuemax":{type:"decimal"},"aria-valuemin":{type:"decimal"},"aria-valuenow":{type:"decimal"},"aria-valuetext":{type:"string",allowEmpty:!0}},Gi={alert:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},alertdialog:{type:"window",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["alert","dialog"],accessibleNameRequired:!0},application:{type:"landmark",allo\
wedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["structure"],accessibleNameRequired:!0},article:{type:"structure",allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["document"]},banner:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},blockquote:{type:"structure",superclassRole:["section"]},button:{type:"widget",allowedAttrs:["aria-expanded","aria-pressed"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},caption:{type:"structure",requiredContext:["figure","table","grid","treegrid"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},cell:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-expanded"],superclassRole:["section"],nameFromContent:!0},checkbox:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-readonly","aria-expanded","aria-required"],supercl\
assRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},code:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},columnheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},combobox:{type:"widget",requiredAttrs:["aria-expanded","aria-controls"],allowedAttrs:["aria-owns","aria-autocomplete","aria-readonly","aria-required","aria-activedescendant","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},command:{type:"abstract",superclassRole:["widget"]},complementary:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},composite:{type:"abstract",superclassRole:["widget"]},contentinfo:{type:"landmark",allowedAttrs:["aria-expanded"],sup\
erclassRole:["landmark"]},comment:{type:"structure",allowedAttrs:["aria-level","aria-posinset","aria-setsize"],superclassRole:["article"]},definition:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},deletion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},dialog:{type:"window",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["window"],accessibleNameRequired:!0},directory:{type:"structure",deprecated:!0,allowedAttrs:["aria-expanded"],superclassRole:["list"],nameFromContent:!0},document:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["structure"]},emphasis:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},feed:{type:"structure",requiredOwned:["article"],allowedAttrs:["aria-expanded"],superclassRole:["list"]},figure:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},form:{type:"landmark",allowedAttr\
s:["aria-expanded"],superclassRole:["landmark"]},grid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-level","aria-multiselectable","aria-readonly","aria-activedescendant","aria-colcount","aria-expanded","aria-rowcount"],superclassRole:["composite","table"],accessibleNameRequired:!1},gridcell:{type:"widget",requiredContext:["row"],allowedAttrs:["aria-readonly","aria-required","aria-selected","aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan"],superclassRole:["cell","widget"],nameFromContent:!0},group:{type:"structure",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["section"]},heading:{type:"structure",requiredAttrs:["aria-level"],allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},img:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!0,childrenPresentational:!0},input:{type:"abstract",superclassRole:["widget"\
]},insertion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},landmark:{type:"abstract",superclassRole:["section"]},link:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},list:{type:"structure",requiredOwned:["listitem"],allowedAttrs:["aria-expanded"],superclassRole:["section"]},listbox:{type:"widget",requiredOwned:["group","option"],allowedAttrs:["aria-multiselectable","aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},listitem:{type:"structure",requiredContext:["list"],allowedAttrs:["aria-level","aria-posinset","aria-setsize","aria-expanded"],superclassRole:["section"],nameFromContent:!0},log:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},main:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},marquee:{type:"structure",allo\
wedAttrs:["aria-expanded"],superclassRole:["section"]},math:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],childrenPresentational:!0},menu:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"]},menubar:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["menu"]},menuitem:{type:"widget",requiredContext:["menu","menubar","group"],allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},menuitemcheckbox:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["checkbo\
x","menuitem"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},menuitemradio:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["menuitemcheckbox","radio"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},meter:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],accessibleNameRequired:!0,childrenPresentational:!0},mark:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},navigation:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},none:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},note:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},option:{type:"widget",requiredContext:["group"\
,"listbox"],allowedAttrs:["aria-selected","aria-checked","aria-posinset","aria-setsize"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},paragraph:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},presentation:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},progressbar:{type:"widget",allowedAttrs:["aria-expanded","aria-valuemax","aria-valuemin","aria-valuenow","aria-valuetext"],superclassRole:["range"],accessibleNameRequired:!0,childrenPresentational:!0},radio:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-posinset","aria-setsize","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},radiogroup:{type:"composite",allowedAttrs:["aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1}\
,range:{type:"abstract",superclassRole:["widget"]},region:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"],accessibleNameRequired:!1},roletype:{type:"abstract",superclassRole:[]},row:{type:"structure",requiredContext:["grid","rowgroup","table","treegrid"],requiredOwned:["cell","columnheader","gridcell","rowheader"],allowedAttrs:["aria-colindex","aria-level","aria-rowindex","aria-selected","aria-activedescendant","aria-expanded","aria-posinset","aria-setsize"],superclassRole:["group","widget"],nameFromContent:!0},rowgroup:{type:"structure",requiredContext:["grid","table","treegrid"],requiredOwned:["row"],superclassRole:["structure"],nameFromContent:!0},rowheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},scrollbar:{ty\
pe:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-controls","aria-orientation","aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],childrenPresentational:!0},search:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},searchbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["textbox"],accessibleNameRequired:!0},section:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},sectionhead:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},select:{type:"abstract",superclassRole:["composite","group"]},separator:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-valuetext"],superclassRole:["structure","widget"],childrenPresentational:!0},slider:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-val\
uemin","aria-orientation","aria-readonly","aria-required","aria-valuetext"],superclassRole:["input","range"],accessibleNameRequired:!0,childrenPresentational:!0},spinbutton:{type:"widget",allowedAttrs:["aria-valuemax","aria-valuemin","aria-readonly","aria-required","aria-activedescendant","aria-valuetext","aria-valuenow"],superclassRole:["composite","input","range"],accessibleNameRequired:!0},status:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},strong:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},structure:{type:"abstract",superclassRole:["roletype"]},subscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},superscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},switch:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-readonly","aria-required"],superclassRole:["checkbox"],access\
ibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},suggestion:{type:"structure",requiredOwned:["insertion","deletion"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},tab:{type:"widget",requiredContext:["tablist"],allowedAttrs:["aria-posinset","aria-selected","aria-setsize","aria-expanded"],superclassRole:["sectionhead","widget"],nameFromContent:!0,childrenPresentational:!0},table:{type:"structure",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-colcount","aria-rowcount","aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1,nameFromContent:!0},tablist:{type:"composite",requiredOwned:["tab"],allowedAttrs:["aria-level","aria-multiselectable","aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["composite"]},tabpanel:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1},term:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFro\
mContent:!0},text:{type:"structure",superclassRole:["section"],nameFromContent:!0},textbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0},time:{type:"structure",superclassRole:["section"]},timer:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["status"]},toolbar:{type:"structure",allowedAttrs:["aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["group"],accessibleNameRequired:!0},tooltip:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},tree:{type:"composite",requiredOwned:["group","treeitem"],allowedAttrs:["aria-multiselectable","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},treegrid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-activedescendant","ari\
a-colcount","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-readonly","aria-required","aria-rowcount"],superclassRole:["grid","tree"],accessibleNameRequired:!1},treeitem:{type:"widget",requiredContext:["group","tree"],allowedAttrs:["aria-checked","aria-expanded","aria-level","aria-posinset","aria-selected","aria-setsize"],superclassRole:["listitem","option"],accessibleNameRequired:!0,nameFromContent:!0},widget:{type:"abstract",superclassRole:["roletype"]},window:{type:"abstract",superclassRole:["roletype"]}},Wi={a:{variant:{href:{matches:"[href]",contentTypes:["interactive","phrasing","flow"],allowedRoles:["button","checkbox","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab","treeitem","doc-backlink","doc-biblioref","doc-glossref","doc-noteref"],namingMethods:["subtreeText"]},default:{contentTypes:["phrasing","flow"],allowedRoles:!0}}},abbr:{contentTypes:["phrasing","flow"],allowedRoles:!0},address:{contentTypes:["flow"],allowedR\
oles:!0},area:{variant:{href:{matches:"[href]",allowedRoles:!1},default:{allowedRoles:["button","link"]}},contentTypes:["phrasing","flow"],namingMethods:["altText"]},article:{contentTypes:["sectioning","flow"],allowedRoles:["feed","presentation","none","document","application","main","region"],shadowRoot:!0},aside:{contentTypes:["sectioning","flow"],allowedRoles:["feed","note","presentation","none","region","search","doc-dedication","doc-example","doc-footnote","doc-glossary","doc-pullquote","doc-tip"]},audio:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"Audio"},b:{contentTypes:["phrasing","flow"],allowedRoles:!0},base:{allowedRoles:!1,noAriaAttrs:!0},bdi:{contentTypes:["phrasing","flow"],allowedRoles:!0},bdo:{contentTypes:["phrasing","flow"],allowedRoles:!0},blockquote:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},body:{allowed\
Roles:!1,shadowRoot:!0},br:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"],namingMethods:["titleText","singleSpace"]},button:{contentTypes:["interactive","phrasing","flow"],allowedRoles:["checkbox","combobox","gridcell","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","separator","slider","switch","tab","treeitem"],namingMethods:["subtreeText"]},canvas:{allowedRoles:!0,contentTypes:["embedded","phrasing","flow"],chromiumRole:"Canvas"},caption:{allowedRoles:!1},cite:{contentTypes:["phrasing","flow"],allowedRoles:!0},code:{contentTypes:["phrasing","flow"],allowedRoles:!0},col:{allowedRoles:!1,noAriaAttrs:!0},colgroup:{allowedRoles:!1,noAriaAttrs:!0},data:{contentTypes:["phrasing","flow"],allowedRoles:!0},datalist:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0,implicitAttrs:{"aria-multiselectable":"false"}},dd:{allowedRoles:!1},del:{contentTypes:["phrasing","flow"],allowedRoles:!0},dfn:{contentTypes:["phrasing","flow"],allowedR\
oles:!0},details:{contentTypes:["interactive","flow"],allowedRoles:!1},dialog:{contentTypes:["flow"],allowedRoles:["alertdialog"]},div:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},dl:{contentTypes:["flow"],allowedRoles:["group","list","presentation","none"],chromiumRole:"DescriptionList"},dt:{allowedRoles:["listitem"]},em:{contentTypes:["phrasing","flow"],allowedRoles:!0},embed:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","presentation","none"],chromiumRole:"EmbeddedObject"},fieldset:{contentTypes:["flow"],allowedRoles:["none","presentation","radiogroup"],namingMethods:["fieldsetLegendText"]},figcaption:{allowedRoles:["group","none","presentation"]},figure:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["figureText","titleText"]},footer:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},form:{contentTypes:["flow"],allowedRoles:["search","none","presentation"]},h1:{co\
ntentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"1"}},h2:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"2"}},h3:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"3"}},h4:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"4"}},h5:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"5"}},h6:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"6"}},head:{allowedRoles:!1,noAriaAttrs:!0},header:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},hgroup:{con\
tentTypes:["heading","flow"],allowedRoles:!0},hr:{contentTypes:["flow"],allowedRoles:["none","presentation","doc-pagebreak"],namingMethods:["titleText","singleSpace"]},html:{allowedRoles:!1,noAriaAttrs:!0},i:{contentTypes:["phrasing","flow"],allowedRoles:!0},iframe:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","none","presentation"],chromiumRole:"Iframe"},img:{variant:{nonEmptyAlt:{matches:[{attributes:{alt:"/.+/"}},{hasAccessibleName:!0}],allowedRoles:["button","checkbox","link","menuitem","menuitemcheckbox","menuitemradio","meter","option","progressbar","radio","scrollbar","separator","slider","switch","tab","treeitem","doc-cover"]},usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","flow"]},default:{allowedRoles:["presentation","none"],contentTypes:["embedded","flow"]}},namingMethods:["altText"]},input:{variant:{button:{matches:{properties:{type:"button"}},allowedRoles:["checkbox","combobox","link","menuitem","\
menuitemcheckbox","menuitemradio","option","radio","switch","tab"]},buttonType:{matches:{properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},checkboxPressed:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":"/.*/"}},allowedRoles:["button","menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},checkbox:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":null}},allowedRoles:["menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},noRoles:{matches:{properties:{type:["color","date","datetime-local","file","month","number","password","range","reset","submit","time","week"]}},allowedRoles:!1},hidden:{matches:{properties:{type:"hidden"}},contentTypes:["flow"],allowedRoles:!1,noAriaAttrs:!0},image:{matches:{properties:{type:"image"}},allowedRoles:["link","menuitem","menuitemcheckbox","menuitemradio","radio","switch"],namingMethods:["altText","valueText","labelText"\
,"titleText","buttonDefaultText"]},radio:{matches:{properties:{type:"radio"}},allowedRoles:["menuitemradio"],implicitAttrs:{"aria-checked":"false"}},textWithList:{matches:{properties:{type:"text"},attributes:{list:"/.*/"}},allowedRoles:!1},default:{contentTypes:["interactive","flow"],allowedRoles:["combobox","searchbox","spinbutton"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText","placeholderText"]}}},ins:{contentTypes:["phrasing","flow"],allowedRoles:!0},kbd:{contentTypes:["phrasing","flow"],allowedRoles:!0},label:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,chromiumRole:"Label"},legend:{allowedRoles:!1},li:{allowedRoles:["menuitem","menuitemcheckbox","menuitemradio","option","none","presentation","radio","separator","tab","treeitem","doc-biblioentry","doc-endnote"],implicitAttrs:{"aria-setsize":"1","aria-posinset":"1"}},link:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},main:{contentTypes:["flow"],allowedRoles:!1,shadowRoot:!0},ma\
p:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},math:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!1},mark:{contentTypes:["phrasing","flow"],allowedRoles:!0},menu:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},meta:{variant:{itemprop:{matches:"[itemprop]",contentTypes:["phrasing","flow"]}},allowedRoles:!1,noAriaAttrs:!0},meter:{contentTypes:["phrasing","flow"],allowedRoles:!1,chromiumRole:"progressbar"},nav:{contentTypes:["sectioning","flow"],allowedRoles:["doc-index","doc-pagelist","doc-toc","menu","menubar","none","presentation","tablist"],shadowRoot:!0},noscript:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},object:{variant:{usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application","document","img"],chromiumRole:"PluginObje\
ct"},ol:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},optgroup:{allowedRoles:!1},option:{allowedRoles:!1,implicitAttrs:{"aria-selected":"false"}},output:{contentTypes:["phrasing","flow"],allowedRoles:!0,namingMethods:["subtreeText"]},p:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},param:{allowedRoles:!1,noAriaAttrs:!0},picture:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},pre:{contentTypes:["flow"],allowedRoles:!0},progress:{contentTypes:["phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuemax":"100","aria-valuemin":"0","aria-valuenow":"0"}},q:{contentTypes:["phrasing","flow"],allowedRoles:!0},rp:{allowedRoles:!0},rt:{allowedRoles:!0},ruby:{contentTypes:["phrasing","flow"],allowedRoles:!0},s:{contentTypes:["phrasing","flow"],allowedRoles:!0},samp:{contentTypes:["phrasing","flow"],allowedRoles:!0},script:{contentTypes:["phrasing","flow"],allowedRoles\
:!1,noAriaAttrs:!0},search:{contentTypes:["flow"],allowedRoles:["form","group","none","presentation","region","search"]},section:{contentTypes:["sectioning","flow"],allowedRoles:["alert","alertdialog","application","banner","complementary","contentinfo","dialog","document","feed","group","log","main","marquee","navigation","none","note","presentation","search","status","tabpanel","doc-abstract","doc-acknowledgments","doc-afterword","doc-appendix","doc-bibliography","doc-chapter","doc-colophon","doc-conclusion","doc-credit","doc-credits","doc-dedication","doc-endnotes","doc-epigraph","doc-epilogue","doc-errata","doc-example","doc-foreword","doc-glossary","doc-index","doc-introduction","doc-notice","doc-pagelist","doc-part","doc-preface","doc-prologue","doc-pullquote","doc-qna","doc-toc"],shadowRoot:!0},select:{variant:{combobox:{matches:{attributes:{multiple:null,size:[null,"1"]}},allowedRoles:["menu"]},default:{allowedRoles:!1}},contentTypes:["interactive","phrasing","flow"],implicitAt\
trs:{"aria-valuenow":""},namingMethods:["labelText"]},slot:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},small:{contentTypes:["phrasing","flow"],allowedRoles:!0},source:{allowedRoles:!1,noAriaAttrs:!0},span:{contentTypes:["phrasing","flow"],allowedRoles:!0,shadowRoot:!0},strong:{contentTypes:["phrasing","flow"],allowedRoles:!0},style:{allowedRoles:!1,noAriaAttrs:!0},svg:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!0,chromiumRole:"SVGRoot",namingMethods:["svgTitleText"]},sub:{contentTypes:["phrasing","flow"],allowedRoles:!0},summary:{allowedRoles:!1,namingMethods:["subtreeText"]},sup:{contentTypes:["phrasing","flow"],allowedRoles:!0},table:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["tableCaptionText","tableSummaryText"]},tbody:{allowedRoles:!0},template:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},textarea:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuenow":"","aria-multiline":"t\
rue"},namingMethods:["labelText","placeholderText"]},tfoot:{allowedRoles:!0},thead:{allowedRoles:!0},time:{contentTypes:["phrasing","flow"],allowedRoles:!0},title:{allowedRoles:!1,noAriaAttrs:!0},td:{allowedRoles:!0},th:{allowedRoles:!0},tr:{allowedRoles:!0},track:{allowedRoles:!1,noAriaAttrs:!0},u:{contentTypes:["phrasing","flow"],allowedRoles:!0},ul:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},var:{contentTypes:["phrasing","flow"],allowedRoles:!0},video:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"video"},wbr:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"]}},Yi={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,1\
96],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248\
,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,\
104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblu\
e:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},Ki={ariaAttrs:Ui,ariaRoles:q({},Gi,{"doc-abstract":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-acknowledgments":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-afterword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-appendix":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-backlink":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-biblioentry":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-bibliography":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landm\
ark"]},"doc-biblioref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-chapter":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-colophon":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-conclusion":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-cover":{type:"img",allowedAttrs:["aria-expanded"],superclassRole:["img"]},"doc-credit":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-credits":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-dedication":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-endnote":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-endnotes":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-epigraph":{type:"s\
ection",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-epilogue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-errata":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-example":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-footnote":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-foreword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossary":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-index":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-introduction":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-noteref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["li\
nk"]},"doc-notice":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-pagebreak":{type:"separator",allowedAttrs:["aria-expanded","aria-orientation"],superclassRole:["separator"],childrenPresentational:!0},"doc-pagelist":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-part":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-preface":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-prologue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-pullquote":{type:"none",superclassRole:["none"]},"doc-qna":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-subtitle":{type:"sectionhead",allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"]},"doc-tip":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-toc":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]\
}},{"graphics-document":{type:"structure",superclassRole:["document"],accessibleNameRequired:!0},"graphics-object":{type:"structure",superclassRole:["group"],nameFromContent:!0},"graphics-symbol":{type:"structure",superclassRole:["img"],accessibleNameRequired:!0,childrenPresentational:!0}}),htmlElms:Wi,cssColors:Yi},Xi=q({},Ki),Zi=Xi,Ji=function(e){return!!(e=Zi.ariaRoles[e])&&!!e.unsupported},Qi=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).allowAbstract,n=void 0!==(n=n.flagUnsupported)&&n,r=Zi.ariaRoles[e],a=Ji(e);return!(!r||n&&a||!t&&"abstract"===r.type)},es=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=t.fallback,r=t.abstracts,a=t.dpub;return 1===(e=e instanceof ua?e:Za(e)).props.nodeType&&(t=(e.attr("role")||"").trim().toLowerCase(),(n?Wp(t):[t]).find((function(e){return!(!a&&"doc-"===e.substr(0,4))&&Qi(e,{allowAbstract:r})})))||null},ts=function(e){return Object.keys(Zi.htmlElms).filter((function(t){return(t=Zi.ht\
mlElms[t]).contentTypes?t.contentTypes.includes(e):!!t.variant&&!(!t.variant.default||!t.variant.default.contentTypes)&&t.variant.default.contentTypes.includes(e)}))},ns=function(){return Xa.get("globalAriaAttrs",(function(){return Object.keys(Zi.ariaAttrs).filter((function(e){return Zi.ariaAttrs[e].global}))}))},rs=Ta((function(e){for(var t=[],n=e.rows,r=0,a=n.length;r<a;r++)for(var o=n[r].cells,u=(t[r]=t[r]||[],0),i=0,s=o.length;i<s;i++)for(var l=0;l<o[i].colSpan;l++){for(var c=o[i].getAttribute("rowspan"),d=0===parseInt(c)||0===o[i].rowspan?n.length:o[i].rowSpan,p=0;p<d;p++){for(t[r+p]=t[r+p]||[];t[r+p][u];)u++;t[r+p][u]=o[i]}u++}return t})),as=Ta((function(e,t){var n,r;for(t=t||rs(bu(e,"table")),n=0;n<t.length;n++)if(t[n]&&-1!==(r=t[n].indexOf(e)))return{x:r,y:n}}));function os(e){var t,n=(e=zf(e)).vNode,r=(e=e.domNode,n.attr("scope")),a=n.attr("role");if(["td","th"].includes(n.props.nodeName))return"columnheader"===a?"col":"rowheader"===a?"row":"col"===r||"row"===r?r:"th"===n.prop\
s.nodeName&&(n.actualNode?(a=rs(bu(e,"table")))[(t=as(e,a)).y].every((function(e){return"TH"===e.nodeName.toUpperCase()}))?"col":a.map((function(e){return e[t.x]})).every((function(e){return e&&"TH"===e.nodeName.toUpperCase()}))?"row":"auto":"auto");throw new TypeError("Expected TD or TH element")}var us=function(e){return-1!==["col","auto"].indexOf(os(e))},is=function(e){return["row","auto"].includes(os(e))};function ss(){return Xa.get("sectioningElementSelector",(function(){return ts("sectioning").map((function(e){return"".concat(e,":not([role])")})).join(", ")+" , main:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]"}))}var ls=function(e){return e?e.replace(/\\r\\n/g,"\\n").replace(/\\u00A0/g," ").replace(/[\\s]{2,}/g," ").trim():""};function cs(e){var t=ls($i(e));e=ls(Hi(e));return t||e}var ds={a:function(e){return e.hasAttr("href")?"link":null},area:function(e){return e.hasAttr("href")?"link":null},article:"article",aside:"complementary"\
,body:"document",button:"button",datalist:"listbox",dd:"definition",dfn:"term",details:"group",dialog:"dialog",dt:"term",fieldset:"group",figure:"figure",footer:function(e){return fo(e,ss())?null:"contentinfo"},form:function(e){return cs(e)?"form":null},h1:"heading",h2:"heading",h3:"heading",h4:"heading",h5:"heading",h6:"heading",header:function(e){return fo(e,ss())?null:"banner"},hr:"separator",img:function(e){var t=e.hasAttr("alt")&&!e.attr("alt"),n=ns().find((function(t){return e.hasAttr(t)}));return!t||n||Pi(e)?"img":"presentation"},input:function(e){var t,n;switch(e.hasAttr("list")&&(n=(t=zi(e.actualNode,"list").filter((function(e){return!!e}))[0])&&"datalist"===t.nodeName.toLowerCase()),e.props.type){case"checkbox":return"checkbox";case"number":return"spinbutton";case"radio":return"radio";case"range":return"slider";case"search":return n?"combobox":"searchbox";case"button":case"image":case"reset":case"submit":return"button";case"text":case"tel":case"url":case"email":case"":return \
n?"combobox":"textbox";default:return"textbox"}},li:"listitem",main:"main",math:"math",menu:"list",meter:"meter",nav:"navigation",ol:"list",optgroup:"group",option:"option",output:"status",progress:"progressbar",search:"search",section:function(e){return cs(e)?"region":null},select:function(e){return e.hasAttr("multiple")||1<parseInt(e.attr("size"))?"listbox":"combobox"},summary:"button",table:"table",tbody:"rowgroup",td:function(e){return e=fo(e,"table"),e=es(e),["grid","treegrid"].includes(e)?"gridcell":"cell"},textarea:"textbox",tfoot:"rowgroup",th:function(e){return us(e)?"columnheader":is(e)?"rowheader":void 0},thead:"rowgroup",tr:"row",ul:"list"},ps=function(e,t){var n=a(t);if(Array.isArray(t)&&void 0!==e)return t.includes(e);if("function"===n)return!!t(e);if(null!=e){if(t instanceof RegExp)return t.test(e);if(/^\\/.*\\/$/.test(t))return n=t.substring(1,t.length-1),new RegExp(n).test(e)}return t===e};function fs(e,t){return ps(!!sl(e),t)}var Ds=function(e,t){if("object"!==a(t)||Arr\
ay.isArray(t)||t instanceof RegExp)throw new Error("Expect matcher to be an object");return Object.keys(t).every((function(n){return ps(e(n),t[n])}))};function ms(e,t){return e=zf(e).vNode,Ds((function(t){return e.attr(t)}),t)}function hs(e,t){return!!t(e)}function gs(e,t){return ps(es(e),t)}function bs(e,t){return ps(ks(e),t)}function vs(e,t){return e=zf(e).vNode,ps(e.props.nodeName,t)}function ys(e,t){return e=zf(e).vNode,Ds((function(t){return e.props[t]}),t)}function Fs(e,t){return ps(Ts(e),t)}var ws={hasAccessibleName:fs,attributes:ms,condition:hs,explicitRole:gs,implicitRole:bs,nodeName:vs,properties:ys,semanticRole:Fs},Es=function e(t,n){return t=zf(t).vNode,Array.isArray(n)?n.some((function(n){return e(t,n)})):"string"==typeof n?ao(t,n):Object.keys(n).every((function(e){var r;if(ws[e])return r=n[e],(0,ws[e])(t,r);throw new Error('Unknown matcher type "'.concat(e,'"'))}))},Cs=function(e,t){return Es(e,t)},xs=(Cs.hasAccessibleName=fs,Cs.attributes=ms,Cs.condition=hs,Cs.explicitRo\
le=gs,Cs.fromDefinition=Es,Cs.fromFunction=Ds,Cs.fromPrimative=ps,Cs.implicitRole=bs,Cs.nodeName=vs,Cs.properties=ys,Cs.semanticRole=Fs,Cs),As=function(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noMatchAccessibleName,n=void 0!==t&&t,r=Zi.htmlElms[e.props.nodeName];if(!r)return{};if(!r.variant)return r;var a,o,u=r.variant,i=I(r,c);for(a in u)if(u.hasOwnProperty(a)&&"default"!==a){for(var s=u[a],l=s.matches,p=I(s,d),f=Array.isArray(l)?l:[l],D=0;D<f.length&&n;D++)if(f[D].hasOwnProperty("hasAccessibleName"))return r;if(xs(e,l))for(var m in p)p.hasOwnProperty(m)&&(i[m]=p[m])}for(o in u.default)u.default.hasOwnProperty(o)&&void 0===i[o]&&(i[o]=u.default[o]);return i},ks=function(e){var t,n=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).chromium,r=e instanceof ua?e:Za(e);if(e=r.actualNode,r)return t=r.props.nodeName,!(t=ds[t])&&n?As(r).chromiumRole||null:"function"==typeof t?t(r):t||null;throw new ReferenceError("Cannot get implicit role of a node outsid\
e the current scope.")},Bs={td:["tr"],th:["tr"],tr:["thead","tbody","tfoot","table"],thead:["table"],tbody:["table"],tfoot:["table"],li:["ol","ul"],dt:["dl","div"],dd:["dl","div"],div:["dl"]};function Ns(e){return ns().some((function(t){return e.hasAttr(t)}))||Pi(e)}var Ts=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noPresentational,n=function(e,t){var n,r=(a=1<arguments.length&&void 0!==t?t:{}).noImplicit,a=I(a,f),o=zf(e).vNode;return 1!==o.props.nodeType?null:!(n=es(o,a))||["presentation","none"].includes(n)&&Ns(o)?r?null:function(e,t){var n=t.chromium;return t=I(t,p),(n=ks(e,{chromium:n}))?function e(t,n){var r=Bs[t.props.nodeName];if(r){if(t.parent)return r.includes(t.parent.props.nodeName)?(r=es(t.parent,n),["none","presentation"].includes(r)&&!Ns(t.parent)?r:r?null:e(t.parent,n)):null;if(t.actualNode)throw new ReferenceError("Cannot determine role presentational inheritance of a required parent outside the current scope.")}return null}(e,t)||n:\
null}(o,a):n}(e,I(n,D));return t&&["presentation","none"].includes(n)?null:n},Rs=["iframe"],Os=function(e){var t=zf(e).vNode;return 1!==t.props.nodeType||!e.hasAttr("title")||!Cs(t,Rs)&&["none","presentation"].includes(Ts(t))?"":t.attr("title")},_s=function(e){var t,n,r=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).strict;return 1===(e=e instanceof ua?e:Za(e)).props.nodeType&&(t=Ts(e),!(!(n=Zi.ariaRoles[t])||!n.nameFromContent)||!r&&(!n||["presentation","none"].includes(t)))},Ss=function(e){var t=e.actualNode,n=e.children;if(n)return e.hasAttr("aria-owns")?(e=zi(t,"aria-owns").filter((function(e){return!!e})).map((function(e){return o.utils.getNodeFromTree(e)})),[].concat(j(n),j(e))):j(n);throw new Error("getOwnedVirtual requires a virtual node")},Ms={accessibleNameFromFieldValue:["progressbar"]};function Ps(e){return e=zf(e).vNode,Is(e)}var Is=Ta((function(e,t){return!Bu(e)&&!Fi(e,{skipAncestors:!0,isAncestor:t})&&(e.actualNode&&"area"===e.props.nodeName?!_u(e,Is):!Pu(e,\
{skipAncestors:!0,isAncestor:t})&&(!e.parent||Is(e.parent,!0)))})),js=function e(t,n,r){var a=zf(t).vNode,o=n?Ps:Uu,u=!t.actualNode||t.actualNode&&o(t);o=a.children.map((function(t){var a=(o=t.props).nodeType,o=o.nodeValue;if(3===a){if(o&&u)return o}else if(!r)return e(t,n)})).join("");return ls(o)},Ls=["button","checkbox","color","file","hidden","image","password","radio","reset","submit"],qs=function(e){var t=(e=e instanceof ua?e:Za(e)).props.nodeName;return"textarea"===t||"input"===t&&!Ls.includes((e.attr("type")||"").toLowerCase())},zs=function(e){return"select"===(e=e instanceof ua?e:Za(e)).props.nodeName},Vs=function(e){return"textbox"===es(e)},$s=function(e){return"listbox"===es(e)},Hs=function(e){return"combobox"===es(e)},Us=["progressbar","scrollbar","slider","spinbutton"],Gs=function(e){return e=es(e),Us.includes(e)},Ws=["textbox","progressbar","scrollbar","slider","spinbutton","combobox","listbox"],Ys={nativeTextboxValue:function(e){return e=zf(e).vNode,qs(e)&&e.props.value|\
|""},nativeSelectValue:function(e){if(e=zf(e).vNode,!zs(e))return"";var t=(e=sD(e,"option")).filter((function(e){return e.props.selected}));return t.length||t.push(e[0]),t.map((function(e){return js(e)})).join(" ")||""},ariaTextboxValue:function(e){var t=(e=zf(e)).vNode;e=e.domNode;return Vs(t)?e&&Pu(e)?e.textContent:js(t,!0):""},ariaListboxValue:Ks,ariaComboboxValue:function(e,t){e=zf(e).vNode;return Hs(e)&&(e=Ss(e).filter((function(e){return"listbox"===Ts(e)}))[0])?Ks(e,t):""},ariaRangeValue:function(e){e=zf(e).vNode;return Gs(e)&&e.hasAttr("aria-valuenow")?(e=+e.attr("aria-valuenow"),isNaN(e)?"0":String(e)):""}};function Ks(e,t){e=zf(e).vNode;return $s(e)&&0!==(e=Ss(e).filter((function(e){return"option"===Ts(e)&&"true"===e.attr("aria-selected")}))).length?sl(e[0],t):""}var Xs=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=e.actualNode,r=Ms.accessibleNameFromFieldValue||[],a=Ts(e);return t.startNode===e||!Ws.includes(a)||r.includes(a)?"":(r=Object.keys(\
Ys).map((function(e){return Ys[e]})).reduce((function(n,r){return n||r(e,t)}),""),t.debug&&aa(r||"{empty-value}",n,t),r)},Zs=ts("phrasing").concat(["#text"]),Js=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=sl.alreadyProcessed;t.startNode=t.startNode||e;var r=(o=t).strict,a=o.inControlContext,o=o.inLabelledByContext,u=Ts(e),i=As(e,{noMatchAccessibleName:!0}).contentTypes;return n(e,t)||1!==e.props.nodeType||null!=i&&i.includes("embedded")||Ws.includes(u)||!(t.subtreeDescendant||t.inLabelledByContext||_s(e,{strict:r}))?"":(r||(t=q({subtreeDescendant:!a&&!o},t)),Ss(e).reduce((function(e,n){var r=t,a=n.props.nodeName;return(n=sl(n,r))?(Zs.includes(a)||(" "!==n[0]&&(n+=" "),e&&" "!==e[e.length-1]&&(n=" "+n)),e+n):e}),""))},Qs=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=sl.alreadyProcessed;if(t.inControlContext||t.inLabelledByContext||n(e,t))return"";t.startNode||(t.startNode=e);var r,a=q({inControlContext:!0},t);n=function(e\
){if(!e.attr("id"))return[];if(e.actualNode)return hu({elm:"label",attr:"for",value:e.attr("id"),context:e.actualNode});throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes")}(e);return(t=fo(e,"label"))?(r=[].concat(j(n),[t.actualNode])).sort(qf):r=n,r.map((function(e){return Vi(e,a)})).filter((function(e){return""!==e})).join(" ")},el={submit:"Submit",image:"Submit",reset:"Reset",button:""};function tl(e,t){return t.attr(e)||""}function nl(e,t,n){t=t.actualNode;var r=[e=e.toLowerCase(),t.nodeName.toLowerCase()].join(",");return(t=t.querySelector(r))&&t.nodeName.toLowerCase()===e?Vi(t,n):""}var rl={valueText:function(e){return e.actualNode.value||""},buttonDefaultText:function(e){return e=e.actualNode,el[e.type]||""},tableCaptionText:nl.bind(null,"caption"),figureText:nl.bind(null,"figcaption"),svgTitleText:nl.bind(null,"title"),fieldsetLegendText:nl.bind(null,"legend"),altText:tl.bind(null,"alt"),tableSummaryText:tl.bind(null,"summary"),titleText:Os,subtreeTe\
xt:Js,labelText:Qs,singleSpace:function(){return" "},placeholderText:tl.bind(null,"placeholder")};function al(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=e.actualNode;return 1!==e.props.nodeType||["presentation","none"].includes(Ts(e))?"":(t=(As(e,{noMatchAccessibleName:!0}).namingMethods||[]).map((function(e){return rl[e]})).reduce((function(t,r){return t||r(e,n)}),""),n.debug&&o.log(t||"{empty-value}",r,n),t)}function ol(){return/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\\
u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26D3\\uFE0F?(?:\\u200D\\uD83D\\uDCA5)?|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uD\
F00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF43\\uDF45-\\uDF4A\\uDF4C-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE\
6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDF44(?:\\u200D\\uD83D\\uDFEB)?|\\uDF4B(?:\\u200D\\uD83D\\uDFE9)?|\\uDFC3(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D\
(?:[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4\\uDEB5](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE41\\uDE43\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uD\
ED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC08(?:\\u200D\\u2B1B)?|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC26(?:\\u200D(?:\\u2B1B|\\uD83D\\uDD25))?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\u\
DC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u2\
7A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\
\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFF\
B\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?|\\uDE42(?:\\\
u200D[\\u2194\\u2195]\\uFE0F?)?|\\uDEB6(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDCE(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\u\
DD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1|\\uDDD1\\u200D\\uD83E\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?|\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D\
)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(\
?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g}var ul=function(e,t){var n=t.emoji,r=t.nonBmp,a=(t=t.punctuations,!1);return n&&(a=a||/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\
\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26D3\\uFE0F?(?:\\u200D\\uD83D\\uDCA5)?|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF43\\uDF45-\\uDF4A\\uDF4C-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\u\
DFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\\
uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDF44(?:\\u200D\\uD83D\\uDFEB)?|\\uDF4B(?:\\u200D\\uD83D\\uDFE9)?|\\uDFC3(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\
\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4\\uDEB5](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE41\\uDE43\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC08(?:\\u200D\\u2B1B)?|\\uDC\
15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC26(?:\\u200D(?:\\u2B1B|\\uD83D\\uDD25))?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\\
u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFF\
F(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD\
83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\
\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?|\\uDE42(?:\\u200D[\\u2194\\u2195]\\uFE0F?)?|\\uDEB6(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uF\
E0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDCE(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDD\
B3]|\\uDD1D\\u200D\\uD83E\\uDDD1|\\uDDD1\\u200D\\uD83E\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?|\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\
\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uD\
FFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g.test(e)),r&&(a=a||/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g.test(e)||/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g.test(e)||/[\\xAD\\u0600-\\u0605\\u061C\\u06DD\\u070F\\u08E2\\u180E\\u200B-\\u200F\\u202A-\\u202E\\u2060-\\u2064\\u2066-\\u206F\\uFEFF\\uFFF9-\\uFFFB]|\\uD804[\\uDCBD\\uDCCD]|\\uD80D[\\uDC30-\\uDC38]|\\uD82F[\\uDCA0-\\uDCA3]|\\uD834[\\uDD73-\\uDD7A]|\\uDB40[\\uDC01\\uDC20-\\uDC7F]/g.test(e)),t?a||/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_\`{|}~\\xb1]/g.test(e):a};function il(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.15,a=2<arguments.length&&void 0!==arguments[2\
]?arguments[2]:3,o=e.actualNode.nodeValue.trim();if(!ls(o)||ul(o,{emoji:!0,nonBmp:!0}))return!1;var u,i=Xa.get("canvasContext",(function(){return r.createElement("canvas").getContext("2d",{willReadFrequently:!0})})),s=i.canvas;if((u=((u=Xa.get("fonts",(function(){return{}})))[D=t.getComputedStyle(e.parent.actualNode).getPropertyValue("font-family")]||(u[D]={occurrences:0,numLigatures:0}),u[D])).occurrences>=a){if(u.numLigatures/u.occurrences==1)return!0;if(0===u.numLigatures)return!1}u.occurrences++;var l="".concat(a=30,"px ").concat(D),c=(i.font=l,o.charAt(0)),d=i.measureText(c).width;if(0===d)return u.numLigatures++,!0;d<30&&(d*=p=30/d,l="".concat(a*=p,"px ").concat(D)),s.width=d,s.height=a,i.font=l,i.textAlign="left",i.textBaseline="top",i.fillText(c,0,0);var p=new Uint32Array(i.getImageData(0,0,d,a).data.buffer);if(!p.some((function(e){return e})))return u.numLigatures++,!0;i.clearRect(0,0,d,a),i.fillText(o,0,0);var f=new Uint32Array(i.getImageData(0,0,d,a).data.buffer),D=p.reduce(\
(function(e,t,n){return 0===t&&0===f[n]||0!==t&&0!==f[n]?e:++e}),0);s=o.split("").reduce((function(e,t){return e+i.measureText(t).width}),0),l=i.measureText(o).width;return n<=D/p.length&&n<=1-l/s&&(u.numLigatures++,!0)}function sl(e){var t,n,r,a,u,i=function(e,t){return t.startNode||(t=q({startNode:e},t)),1===e.props.nodeType&&t.inLabelledByContext&&void 0===t.includeHidden&&(t=q({includeHidden:!Ps(e)},t)),t}(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:{});return function(e,t){if(e&&1===e.props.nodeType&&!t.includeHidden)return!Ps(e)}(e,i)||(t=e,n=(u=i).ignoreIconLigature,r=u.pixelThreshold,a=null!=(a=u.occurrenceThreshold)?a:u.occuranceThreshold,3===t.props.nodeType&&n&&il(t,r,a))?"":(u=[$i,Hi,al,Xs,Js,ll,Os].reduce((function(t,n){return""!==(t=i.startNode===e?ls(t):t)?t:n(e,i)}),""),i.debug&&o.log(u||"{empty-value}",e.actualNode,i),u)}function ll(e){return 3!==e.props.nodeType?"":e.props.nodeValue}sl.alreadyProcessed=function(e,t){return t.processed=t.processed||[],!!t.\
processed.includes(e)||(t.processed.push(e),!1)};var cl=function(e,t){var n=t.emoji,r=t.nonBmp;t=t.punctuations;return n&&(e=e.replace(/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u272\
8\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26D3\\uFE0F?(?:\\u200D\\uD83D\\uDCA5)?|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF43\\uDF45-\\uDF4A\\uDF4C-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\u\
DDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDD\
EB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDF44(?:\\u200D\\uD83D\\uDFEB)?|\\uDF4B(?:\\u200D\\uD83D\\uDFE9)?|\\uDFC3(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uD\
C83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4\\uDEB5](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE41\\uDE43\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC08(?:\\u200D\\u2B1B)?|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC26(?:\\u200D(?:\\u2B1B|\\uD83D\\uDD25))?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\\
uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uD\
D1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\u\
DDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\u\
D83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\\
uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?|\\uDE42(?:\\u200D[\\u2194\\u2195]\\uFE0F?)?|\\uDEB6(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\u\
DD3E\\uDDB8\\uDDB9\\uDDCD\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDCE(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1|\\uDDD1\\u200D\\uD83E\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?|\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFF\
F]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\
\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g,"")),r&&(e=e.replace(/[\\u1D00-\\u1D7F\\u1D8\
0-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g,"").replace(/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g,"").replace(/[\\xAD\\u0600-\\u0605\\u061C\\u06DD\\u070F\\u08E2\\u180E\\u200B-\\u200F\\u202A-\\u202E\\u2060-\\u2064\\u2066-\\u206F\\uFEFF\\uFFF9-\\uFFFB]|\\uD804[\\uDCBD\\uDCCD]|\\uD80D[\\uDC30-\\uDC38]|\\uD82F[\\uDCA0-\\uDCA3]|\\uD834[\\uDD73-\\uDD7A]|\\uDB40[\\uDC01\\uDC20-\\uDC7F]/g,"")),t?e.replace(/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_\`{|}~\\xb1]/g,""):e},dl=function(e){var t;return 0===ls(e).length||1===(t=e).length&&t.match(/\\D/)||["aa","abc"].includes(e.toLowerCase())||function(e){return e=cl(e,{emoji:!0,nonBmp:!0,punctuations:!0}),!ls(e)}(e)?0:1},pl={stateTerms:["on","off"],standaloneTerms:["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","usern\
ame","new-password","current-password","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","one-time-code"],qualifiers:["home","work","mobile","fax","pager"],qualifiedTerms:["tel","tel-country-code","tel-national","tel-area-code","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp"],locations:["billing","shipping"]},fl=function(e){var t=void 0!==(t=(u=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).looseTyped)&&t,n=void 0===(n=u.stateTerms)?[]:n,r=void 0===(r=u.locations)?[]:r,a=void 0===(a=u.qualifiers)?[]:a,o=void 0===(o=u.standaloneTerms)?[]:o,u\
=void 0===(u=u.qualifiedTerms)?[]:u;return e=e.toLowerCase().trim(),!(!(n=n.concat(pl.stateTerms)).includes(e)&&""!==e)||(a=a.concat(pl.qualifiers),r=r.concat(pl.locations),o=o.concat(pl.standaloneTerms),u=u.concat(pl.qualifiedTerms),!("webauthn"===(n=e.split(/\\s+/g))[n.length-1]&&(n.pop(),0===n.length)||!t&&(8<n[0].length&&"section-"===n[0].substr(0,8)&&n.shift(),r.includes(n[0])&&n.shift(),a.includes(n[0])&&(n.shift(),o=[]),1!==n.length))&&(t=n[n.length-1],o.includes(t)||u.includes(t)))},Dl=function(e){var t;return e.attr("aria-labelledby")&&(t=zi(e.actualNode,"aria-labelledby").map((function(e){return(e=Za(e))?js(e):""})).join(" ").trim())?t:(t=(t=e.attr("aria-label"))&&ls(t))||null},ml=function(e,t,n){return e=Za(e),js(e,t,n)},hl=function(e){if(t=Dl(e))return t;if(e.attr("id")){if(!e.actualNode)throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes");var t,n=wa(e.attr("id"));if(t=(n=mu(e.actualNode).querySelector('label[for="'+n+'"]'))&&ml(n,!0))return t}ret\
urn(t=(n=fo(e,"label"))&&js(n,!0))||null},gl=function(e){return e=Za(e),hl(e)},bl=[{matches:[{nodeName:"textarea"},{nodeName:"input",properties:{type:["text","password","search","tel","email","url"]}}],namingMethods:"labelText"},{matches:{nodeName:"input",properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},{matches:{nodeName:"input",properties:{type:"image"}},namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},{matches:"button",namingMethods:"subtreeText"},{matches:"fieldset",namingMethods:"fieldsetLegendText"},{matches:"OUTPUT",namingMethods:"subtreeText"},{matches:[{nodeName:"select"},{nodeName:"input",properties:{type:/^(?!text|password|search|tel|email|url|button|submit|reset)/}}],namingMethods:"labelText"},{matches:"summary",namingMethods:"subtreeText"},{matches:"figure",namingMethods:["figureText","titleText"]},{matches:"img",namingMethods:"altText"},{matches:"table",namingMethods:["tableCaptio\
nText","tableSummaryText"]},{matches:["hr","br"],namingMethods:["titleText","singleSpace"]}],vl=function e(t){var n=Uu(t),r=[];return t.children.forEach((function(t){3===t.actualNode.nodeType?n&&r.push(t):r=r.concat(e(t))})),r},yl=Ta((function(e){var t=Za(e),n=t.boundingClientRect,a=[],o=Fu(t);return e.childNodes.forEach((function(e){var t,u;3!==e.nodeType||""===ls(e.nodeValue)||((t=r.createRange()).selectNodeContents(e),e=Array.from(t.getClientRects()),u=n,e.some((function(e){return!Yu(Zu(e),u)})))||a.push.apply(a,j(Fl(e,o)))})),a.length?a:Fl([n],o)}));function Fl(e,t){var n=[];return e.forEach((function(e){e.width<1||e.height<1||(e=t.reduce((function(e,t){return e&&Xu(e,t.boundingClientRect)}),e))&&n.push(e)})),n}var wl=function(e){di();var t=Za(e)._grid;return t?yl(e).map((function(e){return Oi(t,e)})):[]},El=["checkbox","img","meter","progressbar","scrollbar","radio","slider","spinbutton","textbox"],Cl=function(e){var t=zf(e).vNode;if(e=o.commons.aria.getExplicitRole(t))return-1!==\
El.indexOf(e);switch(t.props.nodeName){case"img":case"iframe":case"object":case"video":case"audio":case"canvas":case"svg":case"math":case"button":case"select":case"textarea":case"keygen":case"progress":case"meter":return!0;case"input":return"hidden"!==t.props.type;default:return!1}},xl=["head","title","template","script","style","iframe","object","video","audio","noscript"];function Al(e){return!xl.includes(e.props.nodeName)&&e.children.some((function(e){return 3===(e=e.props).nodeType&&e.nodeValue.trim()}))}var kl=function e(t,n,r){return Al(t)||Cl(t.actualNode)||!r&&!!Dl(t)||!n&&t.children.some((function(t){return 1===t.actualNode.nodeType&&e(t)}))},Bl=function(e,t,n){return e=Za(e),kl(e,t,n)};function Nl(e){return!(void 0!==e.children&&!Al(e))||(1===e.props.nodeType&&Cl(e)?!!o.commons.text.accessibleTextVirtual(e):e.children.some((function(e){return!e.attr("lang")&&Nl(e)&&!Pu(e)})))}var Tl=function(e){return-1<parseInt(e.getAttribute("tabindex"),10)&&Pi(e)&&!Mi(e)};function Rl(e,t){\
var n=(e=zf(e)).vNode;e=e.domNode;return n?(void 0===n._isHiddenWithCSS&&(n._isHiddenWithCSS=Ol(e,t)),n._isHiddenWithCSS):Ol(e,t)}function Ol(e,n){if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),["STYLE","SCRIPT"].includes(e.nodeName.toUpperCase()))return!1;var r,a=t.getComputedStyle(e,null);if(a)return"none"===a.getPropertyValue("display")||(r=["hidden","collapse"],a=a.getPropertyValue("visibility"),!(!r.includes(a)||n))||!!(r.includes(a)&&n&&r.includes(n))||!(!(n=Lu(e))||r.includes(a))&&Rl(n,a);throw new Error("Style does not exist for the given element.")}var _l=Rl,Sl=function(e){return null!==(e=e.doctype)&&"html"===e.name&&!e.publicId&&!e.systemId},Ml=function(e){(e instanceof ua||null!=(n=t)&&n.Node&&e instanceof t.Node)&&(e=o.commons.aria.getRole(e));var n=Zi.ariaRoles[e];return(null==n?void 0:n.type)||null},Pl=["block","list-item","table","flex","grid","inline-block"];function Il(e){return e=t.getComputedStyle(e).getPropertyValue("display"),Pl.includes(e)||"table-"===\
e.substr(0,6)}var jl=function(e,t){var n,r,a,o;return!Il(e)&&(n=function(e){for(var t=Lu(e);t&&!Il(t);)t=Lu(t);return Za(t)}(e),a=r="",o=0,function e(t,n){!1!==n(t.actualNode)&&t.children.forEach((function(t){return e(t,n)}))}(n,(function(t){if(2===o)return!1;if(3===t.nodeType&&(r+=t.nodeValue),1===t.nodeType){var n=(t.nodeName||"").toUpperCase();if(t===e&&(o=1),!["BR","HR"].includes(n))return!("none"===t.style.display||"hidden"===t.style.overflow||!["",null,"none"].includes(t.style.float)||!["",null,"relative"].includes(t.style.position))&&("widget"===Ml(t)?(a+=t.textContent,!1):void 0);0===o?a=r="":o=2}})),r=ls(r),null!=t&&t.noLengthCompare?0!==r.length:(a=ls(a),r.length>a.length))},Ll=function(e){if(e=(e=e||{}).modalPercent||.75,Xa.get("isModalOpen"))return Xa.get("isModalOpen");if(Jf(o._tree[0],"dialog, [role=dialog], [aria-modal=true]",Uu).length)return Xa.set("isModalOpen",!0),!0;for(var n,a=Vu(t),u=a.width*e,i=a.height*e,s=(e=(a.width-u)/2,(a.height-i)/2),l=[{x:e,y:s},{x:a.width\
-e,y:s},{x:a.width/2,y:a.height/2},{x:e,y:a.height-s},{x:a.width-e,y:a.height-s}].map((function(e){return Array.from(r.elementsFromPoint(e.x,e.y))})),c=0;c<l.length;c++)if(n=function(){var e=l[c].find((function(e){return e=t.getComputedStyle(e),parseInt(e.width,10)>=u&&parseInt(e.height,10)>=i&&"none"!==e.getPropertyValue("pointer-events")&&("absolute"===e.position||"fixed"===e.position)}));if(e&&l.every((function(t){return t.includes(e)})))return Xa.set("isModalOpen",!0),{v:!0}}())return n.v;Xa.set("isModalOpen",void 0)};function ql(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:2,r=e.ownerDocument.createRange(),a=(r.setStart(e,0),r.setEnd(e,e.childNodes.length),0),o=0,u=Y(r.getClientRects());try{for(u.s();!(t=u.n()).done;){var i=t.value;if(!(i.height<=n))if(a>i.top+n)a=Math.max(a,i.bottom);else{if(0!==o)return!0;a=i.bottom,o++}}}catch(e){u.e(e)}finally{u.f()}return!1}var zl=function(e){return e instanceof t.Node},Vl="color.incompleteData",$l={set:function(e,t){if("\
string"!=typeof e)throw new Error("Incomplete data: key must be a string");var n=Xa.get(Vl,(function(){return{}}));return t&&(n[e]=t),n[e]},get:function(e){var t=Xa.get(Vl);return null==t?void 0:t[e]},clear:function(){Xa.set(Vl,{})}},Hl=function(e,n){var r=e.nodeName.toUpperCase();return["IMG","CANVAS","OBJECT","IFRAME","VIDEO","SVG"].includes(r)?($l.set("bgColor","imgNode"),!0):((e="none"!==(r=(n=n||t.getComputedStyle(e)).getPropertyValue("background-image")))&&(n=/gradient/.test(r),$l.set("bgColor",n?"bgGradient":"bgImage")),e)},Ul=(Yi=(se(Wi={},{ArrayFrom:function(){return wp.default},Colorjs:function(){return mp},CssSelectorParser:function(){return Ul.CssSelectorParser},doT:function(){return Gl.default},emojiRegexText:function(){return ol},memoize:function(){return Wl.default}}),le(Zt())),Zt=le(Jt()),Jt=(le(Qt()),le(er())),Qt=le(br()),er=le(ea()),"hasOwn"in Object||(Object.hasOwn=Jt.default),"values"in Object||(Object.values=Qt.default),"Promise"in t||Yi.default.polyfill(),"Uint32A\
rray"in t||(t.Uint32Array=Zt.Uint32Array),t.Uint32Array&&("some"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"some",{value:Array.prototype.some}),"reduce"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"reduce",{value:Array.prototype.reduce})),"function"!=typeof Object.assign&&(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),n=1;n<arguments.length;n++){var r=arguments[n];if(null!=r)for(var a in r)r.hasOwnProperty(a)&&(t[a]=r[a])}return t}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var t,n=Object(this),r=n.length>>>0,a=arguments[1],o=0;o<r;o++)if(t=n[o],e.call(a,t,o,n))return t}}),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIn\
dex",{value:function(e,t){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var n,r=Object(this),a=r.length>>>0,o=0;o<a;o++)if(n=r[o],e.call(t,n,o,r))return o;return-1}}),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(e){var t=Object(this),n=parseInt(t.length,10)||0;if(0!==n){var r,a,o=parseInt(arguments[1],10)||0;for(0<=o?r=o:(r=n+o)<0&&(r=0);r<n;){if(e===(a=t[r])||e!=e&&a!=a)return!0;r++}}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,"some",{value:function(e){if(null==this)throw new TypeError("Array.prototype.some called on null or undefined");if("function"!=typeof e)throw new TypeError;for(var t=Object(this),n=t.length>>>0,r=2<=arguments.length?arguments[1]:void 0,a=0;a<n;a++)if(a in t&&e.call(r,t[a],a,t))return!0;return!1}}),Array.from||(Array.from=er.default),String.prototype.includes||(String.pro\
totype.includes=function(e,t){return!((t="number"!=typeof t?0:t)+e.length>this.length)&&-1!==this.indexOf(e,t)}),Array.prototype.flat||Object.defineProperty(Array.prototype,"flat",{configurable:!0,value:function e(){var t=isNaN(arguments[0])?1:Number(arguments[0]);return t?Array.prototype.reduce.call(this,(function(n,r){return Array.isArray(r)?n.push.apply(n,e.call(r,t-1)):n.push(r),n}),[]):Array.prototype.slice.call(this)},writable:!0}),!t.Node||"isConnected"in t.Node.prototype||Object.defineProperty(t.Node.prototype,"isConnected",{get:function(){return!(this.ownerDocument&&this.ownerDocument.compareDocumentPosition(this)&this.DOCUMENT_POSITION_DISCONNECTED)}}),le(Xt())),Gl=le(ta()),Wl=le(Gt());function Yl(e,t){var n=e.length,r=(Array.isArray(e[0])||(e=[e]),(t=Array.isArray(t[0])?t:t.map((function(e){return[e]})))[0].length),a=t[0].map((function(e,n){return t.map((function(e){return e[n]}))}));e=e.map((function(e){return a.map((function(t){var n=0;if(Array.isArray(e))for(var r=0;r<e.l\
ength;r++)n+=e[r]*(t[r]||0);else{var a,o=Y(t);try{for(o.s();!(a=o.n()).done;){var u=a.value;n+=e*u}}catch(t){o.e(t)}finally{o.f()}}return n}))}));return 1===n&&(e=e[0]),1===r?e.map((function(e){return e[0]})):e}function Kl(e){return"string"===Xl(e)}function Xl(e){return(Object.prototype.toString.call(e).match(/^\\[object\\s+(.*?)\\]$/)[1]||"").toLowerCase()}function Zl(e,t){e=+e,t=+t;var n=(Math.floor(e)+"").length;return n<t?+e.toFixed(t-n):(n=Math.pow(10,n-t),Math.round(e/n)*n)}function Jl(e){var t,n;if(e)return e=e.trim(),t=/^-?[\\d.]+$/,(e=e.match(/^([a-z]+)\\((.+?)\\)$/i))?(n=[],e[2].replace(/\\/?\\s*([-\\w.]+(?:%|deg)?)/g,(function(e,r){/%$/.test(r)?(r=new Number(r.slice(0,-1)/100)).type="<percentage>":/deg$/.test(r)?((r=new Number(+r.slice(0,-3))).type="<angle>",r.unit="deg"):t.test(r)&&((r=new Number(r)).type="<number>"),e.startsWith("/")&&((r=r instanceof Number?r:new Number(r)).alpha=!0),n.push(r)})),{name:e[1].toLowerCase(),rawName:e[1],rawArgs:e[2],args:n}):void 0}function Ql(e){ret\
urn e[e.length-1]}function ec(e,t,n){return isNaN(e)?t:isNaN(t)?e:e+(t-e)*n}function tc(e,t,n){return(n-e)/(t-e)}function nc(e,t,n){return ec(t[0],t[1],tc(e[0],e[1],n))}function rc(e){return e.map((function(e){return e.split("|").map((function(e){var t,n=(e=e.trim()).match(/^(<[a-z]+>)\\[(-?[.\\d]+),\\s*(-?[.\\d]+)\\]?$/);return n?((t=new String(n[1])).range=[+n[2],+n[3]],t):e}))}))}br=Object.freeze({__proto__:null,isString:Kl,type:Xl,toPrecision:Zl,parseFunction:Jl,last:Ql,interpolate:ec,interpolateInv:tc,mapRange:nc,parseCoordGrammar:rc,multiplyMatrices:Yl});var ac=new(G((function e(){H(this,e)}),[{key:"add",value:function(e,t,n){if("string"!=typeof arguments[0])for(var e in arguments[0])this.add(e,arguments[0][e],t);else(Array.isArray(e)?e:[e]).forEach((function(e){this[e]=this[e]||[],t&&this[e][n?"unshift":"push"](t)}),this)}},{key:"run",value:function(e,t){this[e]=this[e]||[],this[e].forEach((function(e){e.call(t&&t.context?t.context:t,t)}))}}])),oc={gamut_mapping:"lch.c",precision:5,d\
eltaE:"76"},uc={D50:[.3457/.3585,1,.2958/.3585],D65:[.3127/.329,1,.3583/.329]};function ic(e){return Array.isArray(e)?e:uc[e]}function sc(e,t,n,r){var a=3<arguments.length&&void 0!==r?r:{};if(e=ic(e),t=ic(t),!e||!t)throw new TypeError("Missing white point to convert ".concat(e?"":"from").concat(e||t?"":"/").concat(t?"":"to"));if(e===t)return n;if(a={W1:e,W2:t,XYZ:n,options:a},ac.run("chromatic-adaptation-start",a),a.M||(a.W1===uc.D65&&a.W2===uc.D50?a.M=[[1.0479298208405488,.022946793341019088,-.05019222954313557],[.029627815688159344,.990434484573249,-.01707382502938514],[-.009243058152591178,.015055144896577895,.7518742899580008]]:a.W1===uc.D50&&a.W2===uc.D65&&(a.M=[[.9554734527042182,-.023098536874261423,.0632593086610217],[-.028369706963208136,1.0099954580058226,.021041398966943008],[.012314001688319899,-.020507696433477912,1.3303659366080753]])),ac.run("chromatic-adaptation-end",a),a.M)return Yl(a.M,a.XYZ);throw new TypeError("Only Bradford CAT with white points D50 and D65 support\
ed for now.")}function lc(e){H(this,lc),O(this,oe),R(this,ue,void 0),this.id=e.id,this.name=e.name,this.base=e.base?lc.get(e.base):null,this.aliases=e.aliases,this.base&&(this.fromBase=e.fromBase,this.toBase=e.toBase);var t,n=null!=(n=e.coords)?n:this.base.coords;this.coords=n,n=null!=(n=null!=(n=e.white)?n:this.base.white)?n:"D65";for(t in this.white=ic(n),this.formats=null!=(n=e.formats)?n:{},this.formats){var r=this.formats[t];r.type||(r.type="function"),r.name||(r.name=t)}!e.cssId||null!=(n=this.formats.functions)&&n.color?null==(n=this.formats)||!n.color||null!=(n=this.formats)&&n.color.id||(this.formats.color.id=this.id):(this.formats.color={id:e.cssId},Object.defineProperty(this,"cssId",{value:e.cssId})),this.referred=e.referred,M(ue,this,P(oe,this,dc).call(this).reverse()),ac.run("colorspace-init-end",this)}function cc(e){var t;return e.coords&&!e.coordGrammar&&(e.type||(e.type="function"),e.name||(e.name="color"),e.coordGrammar=rc(e.coords),t=Object.entries(this.coords).map((f\
unction(t,n){(t=z(t,2))[0],t=t[1],n=e.coordGrammar[n][0],t=t.range||t.refRange;var r=n.range,a="";return"<percentage>"==n?(r=[0,100],a="%"):"<angle>"==n&&(a="deg"),{fromRange:t,toRange:r,suffix:a}})),e.serializeCoords=function(e,n){return e.map((function(e,r){var a=(r=t[r]).fromRange,o=r.toRange;r=r.suffix;return e=Zl(e=a&&o?nc(a,o,e):e,n),r&&(e+=r),e}))}),e}function dc(){for(var e=[this],t=this;t=t.base;)e.push(t);return e}oe=new WeakSet,ue=new WeakMap;var pc=G(lc,[{key:"inGamut",value:function(e){var t,n=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).epsilon,r=void 0===n?75e-6:n;return this.isPolar?(e=this.toBase(e),this.base.inGamut(e,{epsilon:r})):(t=Object.values(this.coords),e.every((function(e,n){var a;return"angle"===(n=t[n]).type||!n.range||!!Number.isNaN(e)||(a=(n=z(n.range,2))[0],n=n[1],(void 0===a||a-r<=e)&&(void 0===n||e<=n+r))})))}},{key:"cssId",get:function(){var e;return(null==(e=this.formats.functions)||null==(e=e.color)?void 0:e.id)||this.id}},{key:"isPol\
ar",get:function(){for(var e in this.coords)if("angle"===this.coords[e].type)return!0;return!1}},{key:"getFormat",value:function(e){return"object"===a(e)||(e="default"===e?Object.values(this.formats)[0]:this.formats[e])?P(oe,this,cc).call(this,e):null}},{key:"to",value:function(e,t){var n;if(1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),this!==(e=lc.get(e))){t=t.map((function(e){return Number.isNaN(e)?0:e}));for(var r,a,o=S(ue,this),u=S(ue,e),i=0;i<o.length&&o[i]===u[i];i++)r=o[i],a=i;if(!r)throw new Error("Cannot convert between color spaces ".concat(this," and ").concat(e,": no connection space was found"));for(var s=o.length-1;a<s;s--)t=o[s].toBase(t);for(var l=a+1;l<u.length;l++)t=u[l].fromBase(t)}return t}},{key:"from",value:function(e,t){var n;return 1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),(e=lc.get(e)).to(this,t)}},{key:"toString",value:function(){return"".concat(this.name," (").concat(this.id,")")}},{key:"getMinCoords",value:function(){var e,t=[]\
;for(e in this.coords){var n=(n=this.coords[e]).range||n.refRange;t.push(null!=(n=null==n?void 0:n.min)?n:0)}return t}}],[{key:"all",get:function(){return j(new Set(Object.values(lc.registry)))}},{key:"register",value:function(e,t){if(1===arguments.length&&(e=(t=arguments[0]).id),t=this.get(t),this.registry[e]&&this.registry[e]!==t)throw new Error("Duplicate color space registration: '".concat(e,"'"));if(this.registry[e]=t,1===arguments.length&&t.aliases){var n,r=Y(t.aliases);try{for(r.s();!(n=r.n()).done;){var a=n.value;this.register(a,t)}}catch(e){r.e(e)}finally{r.f()}}return t}},{key:"get",value:function(e){if(!e||e instanceof lc)return e;if("string"===Xl(e)){var t=lc.registry[e.toLowerCase()];if(t)return t;throw new TypeError('No color space found with id = "'.concat(e,'"'))}for(var n=arguments.length,r=new Array(1<n?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];if(r.length)return lc.get.apply(lc,r);throw new TypeError("".concat(e," is not a valid color space"))}},{key:"resolveCoord",valu\
e:function(e,t){var n,r;if(r="string"===Xl(e)?e.includes(".")?(n=(r=z(e.split("."),2))[0],r[1]):(n=void 0,e):Array.isArray(e)?(n=(r=z(e,2))[0],r[1]):(n=e.space,e.coordId),!(n=(n=lc.get(n))||t))throw new TypeError("Cannot resolve coordinate reference ".concat(e,": No color space specified and relative references are not allowed here"));if(("number"===(t=Xl(r))||"string"===t&&0<=r)&&(e=Object.entries(n.coords)[r]))return q({space:n,id:e[0],index:r},e[1]);n=lc.get(n);var a,o=r.toLowerCase(),u=0;for(a in n.coords){var i,s=n.coords[a];if(a.toLowerCase()===o||(null==(i=s.name)?void 0:i.toLowerCase())===o)return q({space:n,id:a,index:u},s);u++}throw new TypeError('No "'.concat(r,'" coordinate found in ').concat(n.name,". Its coordinates are: ").concat(Object.keys(n.coords).join(", ")))}}]),fc=(ce(pc,"registry",{}),ce(pc,"DEFAULT_FORMAT",{type:"functions",name:"color"}),new pc({id:"xyz-d65",name:"XYZ D65",coords:{x:{name:"X"},y:{name:"Y"},z:{name:"Z"}},white:"D65",formats:{color:{ids:["xyz-d65\
","xyz"]}},aliases:["xyz"]}));N(Dc,pc),Jt=G(Dc);function Dc(e){var t;return H(this,Dc),e.coords||(e.coords={r:{range:[0,1],name:"Red"},g:{range:[0,1],name:"Green"},b:{range:[0,1],name:"Blue"}}),e.base||(e.base=fc),e.toXYZ_M&&e.fromXYZ_M&&(null==e.toBase&&(e.toBase=function(n){return n=Yl(e.toXYZ_M,n),t.white!==t.base.white?sc(t.white,t.base.white,n):n}),null==e.fromBase)&&(e.fromBase=function(n){return n=sc(t.base.white,t.white,n),Yl(e.fromXYZ_M,n)}),null==e.referred&&(e.referred="display"),t=A(this,Dc,[e])}function mc(e){var t={str:null==(l=String(e))?void 0:l.trim()};if(ac.run("parse-start",t),t.color)return t.color;if(t.parsed=Jl(t.str),t.parsed){var n=t.parsed.name;if("color"===n){var r,a=t.parsed.args.shift(),o=0<t.parsed.rawArgs.indexOf("/")?t.parsed.args.pop():1,u=Y(pc.all);try{var i;for(u.s();!(r=u.n()).done;)if(i=function(){var e,n=r.value,u=n.getFormat("color");if(u&&(a===u.id||null!=(u=u.ids)&&u.includes(a)))return u=Object.keys(n.coords).length,(e=Array(u).fill(0)).forEach(\
(function(n,r){return e[r]=t.parsed.args[r]||0})),{v:{spaceId:n.id,coords:e,alpha:o}}}())return i.v}catch(e){u.e(e)}finally{u.f()}var s,l="";throw a in pc.registry&&(s=null==(s=pc.registry[a].formats)||null==(s=s.functions)||null==(s=s.color)?void 0:s.id)&&(l="Did you mean color(".concat(s,")?")),new TypeError("Cannot parse color(".concat(a,"). ")+(l||"Missing a plugin?"))}var c,d=Y(pc.all);try{var p;for(d.s();!(c=d.n()).done;)if(p=function(){var e,r,a=c.value,o=a.getFormat(n);if(o&&"function"===o.type)return e=1,(o.lastAlpha||Ql(t.parsed.args).alpha)&&(e=t.parsed.args.pop()),r=t.parsed.args,o.coordGrammar&&Object.entries(a.coords).forEach((function(e,t){var a=(e=z(e,2))[0],u=(e=e[1],o.coordGrammar[t]),i=null==(s=r[t])?void 0:s.type;if(!(u=u.find((function(e){return e==i}))))throw s=e.name||a,new TypeError("".concat(i," not allowed for ").concat(s," in ").concat(n,"()"));a=u.range;var s=e.range||e.refRange;(a="<percentage>"===i?a||[0,1]:a)&&s&&(r[t]=nc(a,s,r[t]))})),{v:{spaceId:a.id,co\
ords:r,alpha:e}}}())return p.v}catch(e){d.e(e)}finally{d.f()}}else{var f,D=Y(pc.all);try{for(D.s();!(f=D.n()).done;){var m,h=f.value;for(m in h.formats){var g=h.formats[m];if("custom"===g.type&&(!g.test||g.test(t.str))){var b=g.parse(t.str);if(b)return null==b.alpha&&(b.alpha=1),b}}}}catch(e){D.e(e)}finally{D.f()}}throw new TypeError("Could not parse ".concat(e," as a color. Missing a plugin?"))}function hc(e){var t;if(e)return(t=(e=Kl(e)?mc(e):e).space||e.spaceId)instanceof pc||(e.space=pc.get(t)),void 0===e.alpha&&(e.alpha=1),e;throw new TypeError("Empty color reference")}function gc(e,t){return(t=pc.get(t)).from(e)}function bc(e,t){var n=(t=pc.resolveCoord(t,e.space)).space;t=t.index;return gc(e,n)[t]}function vc(e,t,n){return t=pc.get(t),e.coords=t.to(e.space,n),e}function yc(e,t,n){if(e=hc(e),2===arguments.length&&"object"===Xl(t)){var r,a=t;for(r in a)yc(e,r,a[r])}else{"function"==typeof n&&(n=n(bc(e,t)));var o=(u=pc.resolveCoord(t,e.space)).space,u=u.index,i=gc(e,o);i[u]=n,vc(e,\
o,i)}return e}Qt=new pc({id:"xyz-d50",name:"XYZ D50",white:"D50",base:fc,fromBase:function(e){return sc(fc.white,"D50",e)},toBase:function(e){return sc("D50",fc.white,e)},formats:{color:{}}});var Fc=24389/27,wc=uc.D50,Ec=new pc({id:"lab",name:"Lab",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:wc,base:Qt,fromBase:function(e){return e=e.map((function(e,t){return e/wc[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(Fc*e+16)/116})),[116*e[1]-16,500*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/Fc,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/Fc,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/Fc].map((function(e,t){return e*wc[t]}))},formats:{lab:{coords:["<number> | <percentage>","<number>","<number>"]}}});function Cc(e){return(e%360+360)%360}var xc=new pc({id:"lch",name:"LCH",coords:{l:{refRange:[0,100],name:"Lightness"},c:{refR\
ange:[0,150],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},base:Ec,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1],r=(e=e[2],Math.abs(n)<.02&&Math.abs(e)<.02?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),Cc(r)]},toBase:function(e){var t=(e=z(e,3))[0],n=e[1];e=e[2];return n<0&&(n=0),isNaN(e)&&(e=0),[t,n*Math.cos(e*Math.PI/180),n*Math.sin(e*Math.PI/180)]},formats:{lch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),Ac=Math.pow(25,7),kc=Math.PI,Bc=180/kc,Nc=kc/180;function Tc(e,t){var n=void 0===(n=(a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).kL)?1:n,r=void 0===(r=a.kC)?1:r,a=void 0===(a=a.kH)?1:a,o=(i=z(Ec.from(e),3))[0],u=i[1],i=i[2],s=xc.from(Ec,[o,u,i])[1],l=(d=z(Ec.from(t),3))[0],c=d[1],d=d[2],p=(s=((s=s<0?0:s)+(p=(p=xc.from(Ec,[l,c,d])[1])<0?0:p))/2,Math.pow(s,7)),f=(p=(1+(s=.5*(1-Math.sqrt(p/(p+Ac)))))*u,u=(1+s)*c,s=Math.sqrt(Math.pow(p,2)+Math.pow(i,2)),c=Math.sqrt(Math.pow(u,2)+Math.pow(d,2\
)),i=0==p&&0===i?0:Math.atan2(i,p),p=0==u&&0===d?0:Math.atan2(d,u),d=(i<0&&(i+=2*kc),p<0&&(p+=2*kc),l-o),u=c-s,(p*=Bc)-(i*=Bc)),D=(i=i+p,p=Math.abs(f),f=(s*c==0?D=0:p<=180?D=f:180<f?D=f-360:f<-180?D=360+f:console.log("the unthinkable has happened"),2*Math.sqrt(c*s)*Math.sin(D*Nc/2)),(o+l)/2);o=(s+c)/2,l=Math.pow(o,7),s=s*c==0?i:p<=180?i/2:i<360?(i+360)/2:(i-360)/2,p=1+.015*(c=Math.pow(D-50,2))/Math.sqrt(20+c),i=1+.045*o,D=1,c=1+.015*o*((D-=.17*Math.cos((s-30)*Nc))+.24*Math.cos(2*s*Nc)+.32*Math.cos((3*s+6)*Nc)-.2*Math.cos((4*s-63)*Nc)),o=30*Math.exp(-1*Math.pow((s-275)/25,2)),D=2*Math.sqrt(l/(l+Ac)),s=-1*Math.sin(2*o*Nc)*D,l=Math.pow(d/(n*p),2),l=(l+=Math.pow(u/(r*i),2))+Math.pow(f/(a*c),2)+u/(r*i)*s*(f/(a*c));return Math.sqrt(l)}var Rc=75e-6;function Oc(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:e.space,n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).epsilon)?Rc:n,r=(e=hc(e),t=pc.get(t),e.coords);return t!==e.space&&(r=t.from(e)),t.inGamut\
(r,{epsilon:n})}function _c(e){return{space:e.space,coords:e.coords.slice(),alpha:e.alpha}}function Sc(e){var t=void 0===(t=(a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).method)?oc.gamut_mapping:t,n=void 0===(a=a.space)?e.space:a;if(Kl(arguments[1])&&(n=arguments[1]),!Oc(e,n=pc.get(n),{epsilon:0})){var r,a=Mc(e,n);if("clip"!==t&&!Oc(e,n)){var o=Sc(_c(a),{method:"clip",space:n});if(2<Tc(e,o)){for(var u=pc.resolveCoord(t),i=u.space,s=u.id,l=Mc(a,i),c=(u.range||u.refRange)[0],d=bc(l,s);.01<d-c;)Tc(l,Sc(_c(l),{space:n,method:"clip"}))-2<.01?c=bc(l,s):d=bc(l,s),yc(l,s,(c+d)/2);a=Mc(l,n)}else a=o}"clip"!==t&&Oc(a,n,{epsilon:0})||(r=Object.values(n.coords).map((function(e){return e.range||[]})),a.coords=a.coords.map((function(e,t){var n=(t=z(r[t],2))[0];t=t[1];return void 0!==n&&(e=Math.max(n,e)),void 0!==t?Math.min(e,t):e}))),n!==e.space&&(a=Mc(a,e.space)),e.coords=a.coords}return e}function Mc(e,t){var n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).inGamut,r=(\
e=hc(e),(t=pc.get(t)).from(e));r={space:t,coords:r,alpha:e.alpha};return n?Sc(r):r}function Pc(e){var t=void 0===(n=(a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).precision)?oc.precision:n,n=void 0===(n=a.format)?"default":n,r=void 0===(r=a.inGamut)||r,a=I(a,m),o=n,u=(n=null!=(u=null!=(u=(e=hc(e)).space.getFormat(n))?u:e.space.getFormat("default"))?u:pc.DEFAULT_FORMAT,r=r||n.toGamut,(u=e.coords).map((function(e){return e||0})));if(r&&!Oc(e)&&(u=Sc(_c(e),!0===r?void 0:r).coords),"custom"===n.type){if(a.precision=t,!n.serialize)throw new TypeError("format ".concat(o," can only be used to parse colors, not for serialization"));i=n.serialize(u,e.alpha,a)}else{r=n.name||"color",o=(n.serializeCoords?u=n.serializeCoords(u,t):null!==t&&(u=u.map((function(e){return Zl(e,t)}))),j(u)),a=("color"===r&&(u=n.id||(null==(a=n.ids)?void 0:a[0])||e.space.id,o.unshift(u)),e.alpha),u=(null!==t&&(a=Zl(a,t)),e.alpha<1&&!n.noAlpha?"".concat(n.commas?",":" /"," ").concat(a):"");var i="".concat(\
r,"(").concat(o.join(n.commas?", ":" ")).concat(u,")")}return i}Mc.returns=Sc.returns="color";Yi=new Jt({id:"rec2020-linear",name:"Linear REC.2020",white:"D65",toXYZ_M:[[.6369580483012914,.14461690358620832,.1688809751641721],[.2627002120112671,.6779980715188708,.05930171646986196],[0,.028072693049087428,1.060985057710791]],fromXYZ_M:[[1.716651187971268,-.355670783776392,-.25336628137366],[-.666684351832489,1.616481236634939,.0157685458139111],[.017639857445311,-.042770613257809,.942103121235474]],formats:{color:{}}});var Ic=1.09929682680944,jc=.018053968510807,Lc=(Zt=new Jt({id:"rec2020",name:"REC.2020",base:Yi,toBase:function(e){return e.map((function(e){return e<4.5*jc?e/4.5:Math.pow((e+Ic-1)/Ic,1/.45)}))},fromBase:function(e){return e.map((function(e){return jc<=e?Ic*Math.pow(e,.45)-(Ic-1):4.5*e}))},formats:{color:{}}}),er=new Jt({id:"p3-linear",name:"Linear P3",white:"D65",toXYZ_M:[[.4865709486482162,.26566769316909306,.1982172852343625],[.2289745640697488,.6917385218365064,.07928\
6914093745],[0,.04511338185890264,1.043944368900976]],fromXYZ_M:[[2.493496911941425,-.9313836179191239,-.40271078445071684],[-.8294889695615747,1.7626640603183463,.023624685841943577],[.03584583024378447,-.07617238926804182,.9568845240076872]]}),Xt=new Jt({id:"srgb-linear",name:"Linear sRGB",white:"D65",toXYZ_M:[[.41239079926595934,.357584339383878,.1804807884018343],[.21263900587151027,.715168678767756,.07219231536073371],[.01933081871559182,.11919477979462598,.9505321522496607]],fromXYZ_M:[[3.2409699419045226,-1.537383177570094,-.4986107602930034],[-.9692436362808796,1.8759675015077202,.04155505740717559],[.05563007969699366,-.20397695888897652,1.0569715142428786]],formats:{color:{}}}),{aliceblue:[240/255,248/255,1],antiquewhite:[250/255,235/255,215/255],aqua:[0,1,1],aquamarine:[127/255,1,212/255],azure:[240/255,1,1],beige:[245/255,245/255,220/255],bisque:[1,228/255,196/255],black:[0,0,0],blanchedalmond:[1,235/255,205/255],blue:[0,0,1],blueviolet:[138/255,43/255,226/255],brown:[165/2\
55,42/255,42/255],burlywood:[222/255,184/255,135/255],cadetblue:[95/255,158/255,160/255],chartreuse:[127/255,1,0],chocolate:[210/255,105/255,30/255],coral:[1,127/255,80/255],cornflowerblue:[100/255,149/255,237/255],cornsilk:[1,248/255,220/255],crimson:[220/255,20/255,60/255],cyan:[0,1,1],darkblue:[0,0,139/255],darkcyan:[0,139/255,139/255],darkgoldenrod:[184/255,134/255,11/255],darkgray:[169/255,169/255,169/255],darkgreen:[0,100/255,0],darkgrey:[169/255,169/255,169/255],darkkhaki:[189/255,183/255,107/255],darkmagenta:[139/255,0,139/255],darkolivegreen:[85/255,107/255,47/255],darkorange:[1,140/255,0],darkorchid:[.6,50/255,.8],darkred:[139/255,0,0],darksalmon:[233/255,150/255,122/255],darkseagreen:[143/255,188/255,143/255],darkslateblue:[72/255,61/255,139/255],darkslategray:[47/255,79/255,79/255],darkslategrey:[47/255,79/255,79/255],darkturquoise:[0,206/255,209/255],darkviolet:[148/255,0,211/255],deeppink:[1,20/255,147/255],deepskyblue:[0,191/255,1],dimgray:[105/255,105/255,105/255],dimgr\
ey:[105/255,105/255,105/255],dodgerblue:[30/255,144/255,1],firebrick:[178/255,34/255,34/255],floralwhite:[1,250/255,240/255],forestgreen:[34/255,139/255,34/255],fuchsia:[1,0,1],gainsboro:[220/255,220/255,220/255],ghostwhite:[248/255,248/255,1],gold:[1,215/255,0],goldenrod:[218/255,165/255,32/255],gray:[128/255,128/255,128/255],green:[0,128/255,0],greenyellow:[173/255,1,47/255],grey:[128/255,128/255,128/255],honeydew:[240/255,1,240/255],hotpink:[1,105/255,180/255],indianred:[205/255,92/255,92/255],indigo:[75/255,0,130/255],ivory:[1,1,240/255],khaki:[240/255,230/255,140/255],lavender:[230/255,230/255,250/255],lavenderblush:[1,240/255,245/255],lawngreen:[124/255,252/255,0],lemonchiffon:[1,250/255,205/255],lightblue:[173/255,216/255,230/255],lightcoral:[240/255,128/255,128/255],lightcyan:[224/255,1,1],lightgoldenrodyellow:[250/255,250/255,210/255],lightgray:[211/255,211/255,211/255],lightgreen:[144/255,238/255,144/255],lightgrey:[211/255,211/255,211/255],lightpink:[1,182/255,193/255],light\
salmon:[1,160/255,122/255],lightseagreen:[32/255,178/255,170/255],lightskyblue:[135/255,206/255,250/255],lightslategray:[119/255,136/255,.6],lightslategrey:[119/255,136/255,.6],lightsteelblue:[176/255,196/255,222/255],lightyellow:[1,1,224/255],lime:[0,1,0],limegreen:[50/255,205/255,50/255],linen:[250/255,240/255,230/255],magenta:[1,0,1],maroon:[128/255,0,0],mediumaquamarine:[.4,205/255,170/255],mediumblue:[0,0,205/255],mediumorchid:[186/255,85/255,211/255],mediumpurple:[147/255,112/255,219/255],mediumseagreen:[60/255,179/255,113/255],mediumslateblue:[123/255,104/255,238/255],mediumspringgreen:[0,250/255,154/255],mediumturquoise:[72/255,209/255,.8],mediumvioletred:[199/255,21/255,133/255],midnightblue:[25/255,25/255,112/255],mintcream:[245/255,1,250/255],mistyrose:[1,228/255,225/255],moccasin:[1,228/255,181/255],navajowhite:[1,222/255,173/255],navy:[0,0,128/255],oldlace:[253/255,245/255,230/255],olive:[128/255,128/255,0],olivedrab:[107/255,142/255,35/255],orange:[1,165/255,0],orangered:\
[1,69/255,0],orchid:[218/255,112/255,214/255],palegoldenrod:[238/255,232/255,170/255],palegreen:[152/255,251/255,152/255],paleturquoise:[175/255,238/255,238/255],palevioletred:[219/255,112/255,147/255],papayawhip:[1,239/255,213/255],peachpuff:[1,218/255,185/255],peru:[205/255,133/255,63/255],pink:[1,192/255,203/255],plum:[221/255,160/255,221/255],powderblue:[176/255,224/255,230/255],purple:[128/255,0,128/255],rebeccapurple:[.4,.2,.6],red:[1,0,0],rosybrown:[188/255,143/255,143/255],royalblue:[65/255,105/255,225/255],saddlebrown:[139/255,69/255,19/255],salmon:[250/255,128/255,114/255],sandybrown:[244/255,164/255,96/255],seagreen:[46/255,139/255,87/255],seashell:[1,245/255,238/255],sienna:[160/255,82/255,45/255],silver:[192/255,192/255,192/255],skyblue:[135/255,206/255,235/255],slateblue:[106/255,90/255,205/255],slategray:[112/255,128/255,144/255],slategrey:[112/255,128/255,144/255],snow:[1,250/255,250/255],springgreen:[0,1,127/255],steelblue:[70/255,130/255,180/255],tan:[210/255,180/255,\
140/255],teal:[0,128/255,128/255],thistle:[216/255,191/255,216/255],tomato:[1,99/255,71/255],turquoise:[64/255,224/255,208/255],violet:[238/255,130/255,238/255],wheat:[245/255,222/255,179/255],white:[1,1,1],whitesmoke:[245/255,245/255,245/255],yellow:[1,1,0],yellowgreen:[154/255,205/255,50/255]}),qc=(Gt=new Jt({id:"srgb",name:"sRGB",base:Xt,fromBase:function(e){return e.map((function(e){var t=e<0?-1:1,n=e*t;return.0031308<n?t*(1.055*Math.pow(n,1/2.4)-.055):12.92*e}))},toBase:function(e){return e.map((function(e){var t=e<0?-1:1,n=e*t;return n<.04045?e/12.92:t*Math.pow((.055+n)/1.055,2.4)}))},formats:{rgb:{coords:Gt=Array(3).fill("<percentage> | <number>[0, 255]")},rgb_number:{name:"rgb",commas:!0,coords:qc=Array(3).fill("<number>[0, 255]"),noAlpha:!0},color:{},rgba:{coords:Gt,commas:!0,lastAlpha:!0},rgba_number:{name:"rgba",commas:!0,coords:qc},hex:{type:"custom",toGamut:!0,test:function(e){return/^#([a-f0-9]{3,4}){1,2}$/i.test(e)},parse:function(e){e.length<=5&&(e=e.replace(/[a-f0-9]/g\
i,"$&$&"));var t=[];return e.replace(/[a-f0-9]{2}/gi,(function(e){t.push(parseInt(e,16)/255)})),{spaceId:"srgb",coords:t.slice(0,3),alpha:t.slice(3)[0]}},serialize:function(e,t){var n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).collapse)||n,r=(t<1&&e.push(t),e=e.map((function(e){return Math.round(255*e)})),n&&e.every((function(e){return e%17==0})));return"#"+e.map((function(e){return r?(e/17).toString(16):e.toString(16).padStart(2,"0")})).join("")}},keyword:{type:"custom",test:function(e){return/^[a-z]+$/i.test(e)},parse:function(e){var t={spaceId:"srgb",coords:null,alpha:1};if("transparent"===(e=e.toLowerCase())?(t.coords=Lc.black,t.alpha=0):t.coords=Lc[e],t.coords)return t}}}}),new Jt({id:"p3",name:"P3",base:er,fromBase:Gt.fromBase,toBase:Gt.toBase,formats:{color:{id:"display-p3"}}}));if(oc.display_space=Gt,"undefined"!=typeof CSS&&CSS.supports)for(var zc=0,Vc=[Ec,Zt,qc];zc<Vc.length;zc++){var $c=Vc[zc],Hc=$c.getMinCoords();Hc=Pc({space:$c,coords:Hc,alpha:\
1});if(CSS.supports("color",Hc)){oc.display_space=$c;break}}function Uc(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"lab",r=(n=pc.get(n)).from(e),a=n.from(t);return Math.sqrt(r.reduce((function(e,t,n){return n=a[n],isNaN(t)||isNaN(n)?e:e+Math.pow(n-t,2)}),0))}function Gc(e){return bc(e,[fc,"y"])}function Wc(e,t){yc(e,[fc,"y"],t)}var Yc=Object.freeze({__proto__:null,getLuminance:Gc,setLuminance:Wc,register:function(e){Object.defineProperty(e.prototype,"luminance",{get:function(){return Gc(this)},set:function(e){Wc(this,e)}})}});function Kc(e){return.022<=e?e:e+Math.pow(.022-e,1.414)}function Xc(e){var t=e<0?-1:1;e=Math.abs(e);return t*Math.pow(e,2.4)}var Zc=24389/27,Jc=uc.D65,Qc=new pc({id:"lab-d65",name:"Lab D65",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:Jc,base:fc,fromBase:function(e){return e=e.map((function(e,t){return e/Jc[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(Zc*e+16)/116})),[116*e[1]-16,500\
*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/Zc,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/Zc,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/Zc].map((function(e,t){return e*Jc[t]}))},formats:{"lab-d65":{coords:["<number> | <percentage>","<number>","<number>"]}}}),ed=.5*Math.pow(5,.5)+.5,td=Object.freeze({__proto__:null,contrastWCAG21:function(e,t){var n;return e=hc(e),t=hc(t),(e=Math.max(Gc(e),0))<(t=Math.max(Gc(t),0))&&(e=(n=[t,e])[0],t=n[1]),(e+.05)/(t+.05)},contrastAPCA:function(e,t){t=hc(t),e=hc(e);var n=(t=z((t=Mc(t,"srgb")).coords,3))[0],r=t[1],a=(t=t[2],.2126729*Xc(n)+.7151522*Xc(r)+.072175*Xc(t));n=(e=z((e=Mc(e,"srgb")).coords,3))[0],r=e[1],t=e[2],e=.2126729*Xc(n)+.7151522*Xc(r)+.072175*Xc(t),t=(n=Kc(a))<(r=Kc(e)),a=Math.abs(r-n)<5e-4?0:t?1.14*(Math.pow(r,.56)-Math.pow(n,.57)):1.14*(Math.pow(r,.65)-Math.pow(n,.62));return 100*(Math.abs(a)<.1?0:0<a?a-.027:a+.027)},con\
trastMichelson:function(e,t){e=hc(e),t=hc(t);var n=((e=Math.max(Gc(e),0))<(t=Math.max(Gc(t),0))&&(e=(n=[t,e])[0],t=n[1]),e+t);return 0===n?0:(e-t)/n},contrastWeber:function(e,t){var n;return e=hc(e),t=hc(t),(e=Math.max(Gc(e),0))<(t=Math.max(Gc(t),0))&&(e=(n=[t,e])[0],t=n[1]),0===t?5e4:(e-t)/t},contrastLstar:function(e,t){return e=hc(e),t=hc(t),e=bc(e,[Ec,"l"]),t=bc(t,[Ec,"l"]),Math.abs(e-t)},contrastDeltaPhi:function(e,t){return e=hc(e),t=hc(t),e=bc(e,[Qc,"l"]),t=bc(t,[Qc,"l"]),e=Math.abs(Math.pow(e,ed)-Math.pow(t,ed)),(t=Math.pow(e,1/ed)*Math.SQRT2-40)<7.5?0:t}});function nd(e){var t=(e=z(gc(e,fc),3))[0],n=e[1];return[4*t/(e=t+15*n+3*e[2]),9*n/e]}function rd(e){var t=(e=z(gc(e,fc),3))[0],n=e[1];return[t/(e=t+n+e[2]),n/e]}var ad=Object.freeze({__proto__:null,uv:nd,xy:rd,register:function(e){Object.defineProperty(e.prototype,"uv",{get:function(){return nd(this)}}),Object.defineProperty(e.prototype,"xy",{get:function(){return rd(this)}})}}),od=Math.PI/180,ud=new pc({id:"xyz-abs-d65",name\
:"Absolute XYZ D65",coords:{x:{refRange:[0,9504.7],name:"Xa"},y:{refRange:[0,1e4],name:"Ya"},z:{refRange:[0,10888.3],name:"Za"}},base:fc,fromBase:function(e){return e.map((function(e){return Math.max(203*e,0)}))},toBase:function(e){return e.map((function(e){return Math.max(e/203,0)}))}}),id=2610/Math.pow(2,14),sd=Math.pow(2,14)/2610,ld=3424/Math.pow(2,12),cd=2413/Math.pow(2,7),dd=2392/Math.pow(2,7),pd=1.7*2523/Math.pow(2,5),fd=Math.pow(2,5)/(1.7*2523),Dd=16295499532821565e-27,md=[[.41478972,.579999,.014648],[-.20151,1.120649,.0531008],[-.0166008,.2648,.6684799]],hd=[[1.9242264357876067,-1.0047923125953657,.037651404030618],[.35031676209499907,.7264811939316552,-.06538442294808501],[-.09098281098284752,-.3127282905230739,1.5227665613052603]],gd=[[.5,.5,0],[3.524,-4.066708,.542708],[.199076,1.096799,-1.295875]],bd=[[1,.1386050432715393,.05804731615611886],[.9999999999999999,-.1386050432715393,-.05804731615611886],[.9999999999999998,-.09601924202631895,-.8118918960560388]],vd=new pc({id:"\
jzazbz",name:"Jzazbz",coords:{jz:{refRange:[0,1],name:"Jz"},az:{refRange:[-.5,.5]},bz:{refRange:[-.5,.5]}},base:ud,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1];e=e[2],n=Yl(md,[1.15*t-(1.15-1)*e,.66*n-(.66-1)*t,e]).map((function(e){var t=ld+cd*Math.pow(e/1e4,id);e=1+dd*Math.pow(e/1e4,id);return Math.pow(t/e,pd)})),e=(t=z(Yl(gd,n),3))[0],n=t[1],t=t[2];return[(1-.56)*e/(1+-.56*e)-Dd,n,t]},toBase:function(e){var t=(e=z(e,3))[0],n=e[1];e=e[2],t=Yl(bd,[(t+Dd)/(1-.56- -.56*(t+Dd)),n,e]).map((function(e){var t=ld-Math.pow(e,fd);e=dd*Math.pow(e,fd)-cd;return 1e4*Math.pow(t/e,sd)})),e=(n=z(Yl(hd,t),3))[0],t=n[1];return[e=(e+(1.15-1)*(n=n[2]))/1.15,(t+(.66-1)*e)/.66,n]},formats:{color:{}}}),yd=new pc({id:"jzczhz",name:"JzCzHz",coords:{jz:{refRange:[0,1],name:"Jz"},cz:{refRange:[0,1],name:"Chroma"},hz:{refRange:[0,360],type:"angle",name:"Hue"}},base:vd,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1],r=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt\
(Math.pow(n,2)+Math.pow(e,2)),Cc(r)]},toBase:function(e){return[e[0],e[1]*Math.cos(e[2]*Math.PI/180),e[1]*Math.sin(e[2]*Math.PI/180)]},formats:{color:{}}}),Fd=2610/16384,wd=[[.3592,.6976,-.0358],[-.1922,1.1004,.0755],[.007,.0749,.8434]],Ed=[[.5,.5,0],[6610/4096,-13613/4096,7003/4096],[17933/4096,-17390/4096,-543/4096]],Cd=[[.9999888965628402,.008605050147287059,.11103437159861648],[1.00001110343716,-.008605050147287059,-.11103437159861648],[1.0000320633910054,.56004913547279,-.3206339100541203]],xd=[[2.0701800566956137,-1.326456876103021,.20661600684785517],[.3649882500326575,.6804673628522352,-.04542175307585323],[-.04959554223893211,-.04942116118675749,1.1879959417328034]],Ad=new pc({id:"ictcp",name:"ICTCP",coords:{i:{refRange:[0,1],name:"I"},ct:{refRange:[-.5,.5],name:"CT"},cp:{refRange:[-.5,.5],name:"CP"}},base:ud,fromBase:function(e){var t=e=Yl(wd,e);return t=e.map((function(e){var t=.8359375+2413/128*Math.pow(e/1e4,Fd);e=1+18.6875*Math.pow(e/1e4,Fd);return Math.pow(t/e,2523/32)})\
),Yl(Ed,t)},toBase:function(e){return e=Yl(Cd,e).map((function(e){var t=Math.max(Math.pow(e,32/2523)-.8359375,0);e=2413/128-18.6875*Math.pow(e,32/2523);return 1e4*Math.pow(t/e,16384/2610)})),Yl(xd,e)},formats:{color:{}}}),kd=[[.8190224432164319,.3619062562801221,-.12887378261216414],[.0329836671980271,.9292868468965546,.03614466816999844],[.048177199566046255,.26423952494422764,.6335478258136937]],Bd=[[1.2268798733741557,-.5578149965554813,.28139105017721583],[-.04057576262431372,1.1122868293970594,-.07171106666151701],[-.07637294974672142,-.4214933239627914,1.5869240244272418]],Nd=[[.2104542553,.793617785,-.0040720468],[1.9779984951,-2.428592205,.4505937099],[.0259040371,.7827717662,-.808675766]],Td=[[.9999999984505198,.39633779217376786,.2158037580607588],[1.0000000088817609,-.10556134232365635,-.06385417477170591],[1.0000000546724108,-.08948418209496575,-1.2914855378640917]],Rd=new pc({id:"oklab",name:"OKLab",coords:{l:{refRange:[0,1],name:"L"},a:{refRange:[-.4,.4]},b:{refRange:[-.4\
,.4]}},white:"D65",base:fc,fromBase:function(e){return e=Yl(kd,e).map((function(e){return Math.cbrt(e)})),Yl(Nd,e)},toBase:function(e){return e=Yl(Td,e).map((function(e){return Math.pow(e,3)})),Yl(Bd,e)},formats:{oklab:{coords:["<number> | <percentage>","<number>","<number>"]}}}),Od=Object.freeze({__proto__:null,deltaE76:function(e,t){return Uc(e,t,"lab")},deltaECMC:function(e,t){var n=void 0===(n=(r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).l)?2:n,r=void 0===(r=r.c)?1:r,a=(u=z(Ec.from(e),3))[0],o=u[1],u=u[2],i=(s=z(xc.from(Ec,[a,o,u]),3))[1],s=s[2],l=(d=z(Ec.from(t),3))[0],c=d[1],d=d[2],p=xc.from(Ec,[l,c,d])[1];l=a-l,p=(i=i<0?0:i)-(p=p<0?0:p),u-=d,d=Math.pow(o-c,2)+Math.pow(u,2)-Math.pow(p,2),o=.511,16<=a&&(o=.040975*a/(1+.01765*a)),c=.0638*i/(1+.0131*i)+.638,u=164<=(s=Number.isNaN(s)?0:s)&&s<=345?.56+Math.abs(.2*Math.cos((s+168)*od)):.36+Math.abs(.4*Math.cos((s+35)*od)),a=Math.pow(i,4),i=c*((s=Math.sqrt(a/(a+1900)))*u+1-s),a=Math.pow(l/(n*o),2),a=(a+=Math.pow(p/(r*c)\
,2))+d/Math.pow(i,2);return Math.sqrt(a)},deltaE2000:Tc,deltaEJz:function(e,t){var n=(e=z(yd.from(e),3))[0],r=e[1],a=(e=e[2],(t=z(yd.from(t),3))[0]),o=t[1];t=t[2],n-=a,a=r-o,Number.isNaN(e)&&Number.isNaN(t)?t=e=0:Number.isNaN(e)?e=t:Number.isNaN(t)&&(t=e),e-=t,t=2*Math.sqrt(r*o)*Math.sin(e/2*(Math.PI/180));return Math.sqrt(Math.pow(n,2)+Math.pow(a,2)+Math.pow(t,2))},deltaEITP:function(e,t){var n=(e=z(Ad.from(e),3))[0],r=e[1],a=(e=e[2],(t=z(Ad.from(t),3))[0]),o=t[1];t=t[2];return 720*Math.sqrt(Math.pow(n-a,2)+.25*Math.pow(r-o,2)+Math.pow(e-t,2))},deltaEOK:function(e,t){var n=(e=z(Rd.from(e),3))[0],r=e[1],a=(e=e[2],(t=z(Rd.from(t),3))[0]);r-=t[1],e-=t[2];return Math.sqrt(Math.pow(n-a,2)+Math.pow(r,2)+Math.pow(e,2))}});function _d(e,t){var n,r,a=(r=r=Kl(r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{})?{method:r}:r).method,o=void 0===a?oc.deltaE:a,u=I(r,b);for(n in e=hc(e),t=hc(t),Od)if("deltae"+o.toLowerCase()===n.toLowerCase())return Od[n](e,t,u);throw new TypeError("Unknown \
deltaE method: ".concat(o))}var Sd=Object.freeze({__proto__:null,lighten:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return yc(e,[pc.get("oklch","lch"),"l"],(function(e){return e*(1+t)}))},darken:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return yc(e,[pc.get("oklch","lch"),"l"],(function(e){return e*(1-t)}))}});function Md(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:.5,r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},a=(e=(a=[hc(e),hc(t)])[0],t=a[1],"object"===Xl(n)&&(n=(a=[.5,n])[0],r=a[1]),r);return Id(e,t,{space:a.space,outputSpace:a.outputSpace,premultiplied:a.premultiplied})(n)}function Pd(e,t){var n,r,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},o=(l=(jd(e)&&(a=t,e=(l=z((n=e).rangeArgs.colors,2))[0],t=l[1]),a)).maxDeltaE,u=l.deltaEMethod,i=(a=void 0===(a=l.steps)?2:a,void 0===(s=l.maxSteps)?1e3:s),s=I(l,v),l=(n||(e=(l=[hc(e),hc(t)])[0],t=l[1],n=Id(e,t,s)),_d(e,t)),c=\
(s=0<o?Math.max(a,Math.ceil(l/o)+1):a,[]);if(void 0!==i&&(s=Math.min(s,i)),c=1===s?[{p:.5,color:n(.5)}]:(r=1/(s-1),Array.from({length:s},(function(e,t){return{p:t*=r,color:n(t)}}))),0<o)for(var d=c.reduce((function(e,t,n){return 0===n?0:(t=_d(t.color,c[n-1].color,u),Math.max(e,t))}),0);o<d;){d=0;for(var p=1;p<c.length&&c.length<i;p++){var f=c[p-1],D=c[p],m=(D.p+f.p)/2,h=n(m);d=Math.max(d,_d(h,f.color),_d(h,D.color));c.splice(p,0,{p:m,color:n(m)}),p++}}return c=c.map((function(e){return e.color}))}function Id(e,t){var n,r,a,o,u,i,s,l,c,d,p,f,D=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};return jd(e)?(a=e,o=t,Id.apply(void 0,j(a.rangeArgs.colors).concat([q({},a.rangeArgs.options,o)]))):(p=D.space,f=D.outputSpace,n=D.progression,r=D.premultiplied,e=hc(e),t=hc(t),e=_c(e),t=_c(t),a={colors:[e,t],options:D},p=p?pc.get(p):pc.registry[oc.interpolationSpace]||e.space,f=f?pc.get(f):p,e=Mc(e,p),t=Mc(t,p),e=Sc(e),t=Sc(t),p.coords.h&&"angle"===p.coords.h.type&&(o=D.hue=D.hue||"shorter\
",l=[(i=[bc(e,D=[p,"h"]),bc(t,D)])[0],i=i[1]],s="raw"===(s=o)?l:(c=(l=z(l.map(Cc),2))[0],d=(l=l[1])-c,"increasing"===s?d<0&&(l+=360):"decreasing"===s?0<d&&(c+=360):"longer"===s?-180<d&&d<180&&(0<d?l+=360:c+=360):"shorter"===s&&(180<d?c+=360:d<-180&&(l+=360)),[c,l]),u=(d=z(s,2))[0],i=d[1],yc(e,D,u),yc(t,D,i)),r&&(e.coords=e.coords.map((function(t){return t*e.alpha})),t.coords=t.coords.map((function(e){return e*t.alpha}))),Object.assign((function(a){a=n?n(a):a;var o=e.coords.map((function(e,n){return ec(e,t.coords[n],a)})),u=ec(e.alpha,t.alpha,a);o={space:p,coords:o,alpha:u};return r&&(o.coords=o.coords.map((function(e){return e/u}))),f!==p?Mc(o,f):o}),{rangeArgs:a}))}function jd(e){return"function"===Xl(e)&&!!e.rangeArgs}oc.interpolationSpace="lab";var Ld=Object.freeze({__proto__:null,mix:Md,steps:Pd,range:Id,isRange:jd,register:function(e){e.defineFunction("mix",Md,{returns:"color"}),e.defineFunction("range",Id,{returns:"function<color>"}),e.defineFunction("steps",Pd,{returns:"array<co\
lor>"})}}),qd=new pc({id:"hsl",name:"HSL",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},l:{range:[0,100],name:"Lightness"}},base:Gt,fromBase:function(e){var t=Math.max.apply(Math,j(e)),n=Math.min.apply(Math,j(e)),r=(e=z(e,3))[0],a=e[1],o=e[2],u=NaN,i=(e=0,(n+t)/2),s=t-n;if(0!=s){switch(e=0==i||1==i?0:(t-i)/Math.min(i,1-i),t){case r:u=(a-o)/s+(a<o?6:0);break;case a:u=(o-r)/s+2;break;case o:u=(r-a)/s+4}u*=60}return[u,100*e,100*i]},toBase:function(e){var t=(e=z(e,3))[0],n=e[1],r=e[2];function a(e){e=(e+t/30)%12;var a=n*Math.min(r,1-r);return r-a*Math.max(-1,Math.min(e-3,9-e,1))}return(t%=360)<0&&(t+=360),n/=100,r/=100,[a(0),a(8),a(4)]},formats:{hsl:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]},hsla:{coords:["<number> | <angle>","<percentage>","<percentage>"],commas:!0,lastAlpha:!0}}}),zd=new pc({id:"hsv",name:"HSV",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},v:{range:[0,100],\
name:"Value"}},base:qd,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)+(n/=100)*Math.min(e,1-e))?0:200*(1-e/n),100*n]},toBase:function(e){var t=(e=z(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)*(1-(n/=100)/2))||1==n?0:(e-n)/Math.min(n,1-n)*100,100*n]},formats:{color:{toGamut:!0}}}),Vd=new pc({id:"hwb",name:"HWB",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},w:{range:[0,100],name:"Whiteness"},b:{range:[0,100],name:"Blackness"}},base:zd,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1];return[t,(e=e[2])*(100-n)/100,100-e]},toBase:function(e){var t=(e=z(e,3))[0],n=e[1],r=(e=e[2],(n/=100)+(e/=100));return 1<=r?[t,0,n/r*100]:[t,100*(0==(r=1-e)?0:1-n/r),100*r]},formats:{hwb:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]}}}),$d=new Jt({id:"a98rgb-linear",name:"Linear Adobe® 98 RGB compatible",white:"D65",toXYZ_M:[[.5766690429101305,.1855582379065463,.1882286462349947],[.29734497525053605,.6273635662554661,.07529145849399788],[.027\
03136138641234,.07068885253582723,.9913375368376388]],fromXYZ_M:[[2.0415879038107465,-.5650069742788596,-.34473135077832956],[-.9692436362808795,1.8759675015077202,.04155505740717557],[.013444280632031142,-.11836239223101838,1.0151749943912054]]}),Hd=new Jt({id:"a98rgb",name:"Adobe® 98 RGB compatible",base:$d,toBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),563/256)*Math.sign(e)}))},fromBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),256/563)*Math.sign(e)}))},formats:{color:{id:"a98-rgb"}}}),Ud=new Jt({id:"prophoto-linear",name:"Linear ProPhoto",white:"D50",base:Qt,toXYZ_M:[[.7977604896723027,.13518583717574031,.0313493495815248],[.2880711282292934,.7118432178101014,8565396060525902e-20],[0,0,.8251046025104601]],fromXYZ_M:[[1.3457989731028281,-.25558010007997534,-.05110628506753401],[-.5446224939028347,1.5082327413132781,.02053603239147973],[0,0,1.2119675456389454]]}),Gd=new Jt({id:"prophoto",name:"ProPhoto",base:Ud,toBase:function(e){retu\
rn e.map((function(e){return e<.03125?e/16:Math.pow(e,1.8)}))},fromBase:function(e){return e.map((function(e){return 1/512<=e?Math.pow(e,1/1.8):16*e}))},formats:{color:{id:"prophoto-rgb"}}}),Wd=new pc({id:"oklch",name:"OKLCh",coords:{l:{refRange:[0,1],name:"Lightness"},c:{refRange:[0,.4],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},white:"D65",base:Rd,fromBase:function(e){var t=(e=z(e,3))[0],n=e[1],r=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),Cc(r)]},toBase:function(e){var t,n=(e=z(e,3))[0],r=e[1];e=e[2],r=isNaN(e)?t=0:(t=r*Math.cos(e*Math.PI/180),r*Math.sin(e*Math.PI/180));return[n,t,r]},formats:{oklch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),Yd=2610/Math.pow(2,14),Kd=Math.pow(2,14)/2610,Xd=2523/Math.pow(2,5),Zd=Math.pow(2,5)/2523,Jd=3424/Math.pow(2,12),Qd=2413/Math.pow(2,7),ep=2392/Math.pow(2,7),tp=new Jt({id:"rec2100pq",name:"REC.2100-PQ",base:Yi,toBase:fun\
ction(e){return e.map((function(e){return 1e4*Math.pow(Math.max(Math.pow(e,Zd)-Jd,0)/(Qd-ep*Math.pow(e,Zd)),Kd)/203}))},fromBase:function(e){return e.map((function(e){e=Math.max(203*e/1e4,0);var t=Jd+Qd*Math.pow(e,Yd);e=1+ep*Math.pow(e,Yd);return Math.pow(t/e,Xd)}))},formats:{color:{id:"rec2100-pq"}}}),np=.17883277,rp=.28466892,ap=.55991073,op=3.7743,up=new Jt({id:"rec2100hlg",cssid:"rec2100-hlg",name:"REC.2100-HLG",referred:"scene",base:Yi,toBase:function(e){return e.map((function(e){return e<=.5?Math.pow(e,2)/3*op:Math.exp((e-ap)/np+rp)/12*op}))},fromBase:function(e){return e.map((function(e){return(e/=op)<=1/12?Math.sqrt(3*e):np*Math.log(12*e-rp)+ap}))},formats:{color:{id:"rec2100-hlg"}}}),ip={};function sp(e){var t=e.id;e.toCone_M,e.fromCone_M,ip[t]=e}function lp(e,t,n){var r=ip[2<arguments.length&&void 0!==n?n:"Bradford"],a=(u=z(Yl(r.toCone_M,e),3))[0],o=u[1],u=u[2],i=z(Yl(r.toCone_M,t),3);a=Yl([[i[0]/a,0,0],[0,i[1]/o,0],[0,0,i[2]/u]],r.toCone_M);return Yl(r.fromCone_M,a)}ac.add("\
chromatic-adaptation-start",(function(e){e.options.method&&(e.M=lp(e.W1,e.W2,e.options.method))})),ac.add("chromatic-adaptation-end",(function(e){e.M||(e.M=lp(e.W1,e.W2,e.options.method))})),sp({id:"von Kries",toCone_M:[[.40024,.7076,-.08081],[-.2263,1.16532,.0457],[0,0,.91822]],fromCone_M:[[1.8599364,-1.1293816,.2198974],[.3611914,.6388125,-64e-7],[0,0,1.0890636]]}),sp({id:"Bradford",toCone_M:[[.8951,.2664,-.1614],[-.7502,1.7135,.0367],[.0389,-.0685,1.0296]],fromCone_M:[[.9869929,-.1470543,.1599627],[.4323053,.5183603,.0492912],[-.0085287,.0400428,.9684867]]}),sp({id:"CAT02",toCone_M:[[.7328,.4296,-.1624],[-.7036,1.6975,.0061],[.003,.0136,.9834]],fromCone_M:[[1.0961238,-.278869,.1827452],[.454369,.4735332,.0720978],[-.0096276,-.005698,1.0153256]]}),sp({id:"CAT16",toCone_M:[[.401288,.650173,-.051461],[-.250268,1.204414,.045854],[-.002079,.048952,.953127]],fromCone_M:[[1.862067855087233,-1.011254630531685,.1491867754444518],[.3875265432361372,.6214474419314753,-.008973985167612518],[-.0\
1584149884933386,-.03412293802851557,1.04996443687785]]}),Object.assign(uc,{A:[1.0985,1,.35585],C:[.98074,1,1.18232],D55:[.95682,1,.92149],D75:[.94972,1,1.22638],E:[1,1,1],F2:[.99186,1,.67393],F7:[.95041,1,1.08747],F11:[1.00962,1,.6435]}),uc.ACES=[.32168/.33767,1,.34065/.33767];var cp=new Jt({id:"acescg",name:"ACEScg",coords:{r:{range:[0,65504],name:"Red"},g:{range:[0,65504],name:"Green"},b:{range:[0,65504],name:"Blue"}},referred:"scene",white:uc.ACES,toXYZ_M:[[.6624541811085053,.13400420645643313,.1561876870049078],[.27222871678091454,.6740817658111484,.05368951740793705],[-.005574649490394108,.004060733528982826,1.0103391003129971]],fromXYZ_M:[[1.6410233796943257,-.32480329418479,-.23642469523761225],[-.6636628587229829,1.6153315916573379,.016756347685530137],[.011721894328375376,-.008284441996237409,.9883948585390215]],formats:{color:{}}}),dp=Math.pow(2,-16),pp=-.35828683,fp=(Math.log2(65504)+9.72)/17.52,Dp=(Jt=new Jt({id:"acescc",name:"ACEScc",coords:{r:{range:[pp,fp],name:"Red"},g\
:{range:[pp,fp],name:"Green"},b:{range:[pp,fp],name:"Blue"}},referred:"scene",base:cp,toBase:function(e){return e.map((function(e){return e<=(9.72-15)/17.52?2*(Math.pow(2,17.52*e-9.72)-dp):e<fp?Math.pow(2,17.52*e-9.72):65504}))},fromBase:function(e){return e.map((function(e){return e<=0?(Math.log2(dp)+9.72)/17.52:e<dp?(Math.log2(dp+.5*e)+9.72)/17.52:(Math.log2(e)+9.72)/17.52}))},formats:{color:{}}}),Object.freeze({__proto__:null,XYZ_D65:fc,XYZ_D50:Qt,XYZ_ABS_D65:ud,Lab_D65:Qc,Lab:Ec,LCH:xc,sRGB_Linear:Xt,sRGB:Gt,HSL:qd,HWB:Vd,HSV:zd,P3_Linear:er,P3:qc,A98RGB_Linear:$d,A98RGB:Hd,ProPhoto_Linear:Ud,ProPhoto:Gd,REC_2020_Linear:Yi,REC_2020:Zt,OKLab:Rd,OKLCH:Wd,Jzazbz:vd,JzCzHz:yd,ICTCP:Ad,REC_2100_PQ:tp,REC_2100_HLG:up,ACEScg:cp,ACEScc:Jt})),mp=(Z=new WeakMap,G(hp,[{key:"space",get:function(){return S(Z,this)}},{key:"spaceId",get:function(){return S(Z,this).id}},{key:"clone",value:function(){return new hp(this.space,this.coords,this.alpha)}},{key:"toJSON",value:function(){return{spaceId:th\
is.spaceId,coords:this.coords,alpha:this.alpha}}},{key:"display",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];var r=function(e){var t=void 0===(t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).space)?oc.display_space:t,n=I(n,h),r=Pc(e,n);return"undefined"==typeof CSS||CSS.supports("color",r)||!oc.display_space?(r=new String(r)).color=e:(t=Mc(e,t),(r=new String(Pc(t,n))).color=t),r}.apply(void 0,[this].concat(t));return r.color=new hp(r.color),r}}],[{key:"get",value:function(e){if(e instanceof hp)return e;for(var t=arguments.length,n=new Array(1<t?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return function(e,t,n){var r;return k()?Reflect.construct.apply(null,arguments):((r=[null]).push.apply(r,t),r=new(e.bind.apply(e,r)),n&&T(r,n.prototype),r)}(hp,[e].concat(n))}},{key:"defineFunction",value:function(e,t){function n(){var e,n=t.apply(void 0,arguments);return"color"===o?n=hp.get(n):"function<color>"===o?(e=n,n=function(){var t=e.apply\
(void 0,arguments);return hp.get(t)},Object.assign(n,e)):"array<color>"===o&&(n=n.map((function(e){return hp.get(e)}))),n}var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:t,a=void 0===(a=r.instance)||a,o=r.returns;e in hp||(hp[e]=n),a&&(hp.prototype[e]=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.apply(void 0,[this].concat(t))})}},{key:"defineFunctions",value:function(e){for(var t in e)hp.defineFunction(t,e[t],e[t])}},{key:"extend",value:function(e){if(e.register)e.register(hp);else for(var t in e)hp.defineFunction(t,e[t])}}]));function hp(){var e=this;H(this,hp),R(this,Z,void 0);for(var t,n,r,a=arguments.length,o=new Array(a),u=0;u<a;u++)o[u]=arguments[u];r=(r=1===o.length?hc(o[0]):r)?(t=r.space||r.spaceId,n=r.coords,r.alpha):(t=o[0],n=o[1],o[2]),M(Z,this,pc.get(t)),this.coords=n?n.slice():[0,0,0],this.alpha=r<1?r:1;for(var i=0;i<this.coords.length;i++)"NaN"===this.coords[i]&&(this.coords[i]=NaN);for(var s in S(Z,this).coords)\
!function(t){Object.defineProperty(e,t,{get:function(){return e.get(t)},set:function(n){return e.set(t,n)}})}(s)}mp.defineFunctions({get:bc,getAll:gc,set:yc,setAll:vc,to:Mc,equals:function(e,t){return e=hc(e),t=hc(t),e.space===t.space&&e.alpha===t.alpha&&e.coords.every((function(e,n){return e===t.coords[n]}))},inGamut:Oc,toGamut:Sc,distance:Uc,toString:Pc}),Object.assign(mp,{util:br,hooks:ac,WHITES:uc,Space:pc,spaces:pc.registry,parse:mc,defaults:oc});for(var gp,bp=0,vp=Object.keys(Dp);bp<vp.length;bp++){var yp=vp[bp];pc.register(Dp[yp])}for(gp in pc.registry)Fp(gp,pc.registry[gp]);function Fp(e,t){Object.keys(t.coords),Object.values(t.coords).map((function(e){return e.name}));var n=e.replace(/-/g,"_");Object.defineProperty(mp.prototype,n,{get:function(){var n=this,r=this.getAll(e);return"undefined"==typeof Proxy?r:new Proxy(r,{has:function(e,n){try{return pc.resolveCoord([t,n]),!0}catch(e){}return Reflect.has(e,n)},get:function(e,n,r){if(n&&"symbol"!==a(n)&&!(n in e)){var o=pc.resolve\
Coord([t,n]).index;if(0<=o)return e[o]}return Reflect.get(e,n,r)},set:function(r,o,u,i){if(o&&"symbol"!==a(o)&&!(o in r)||0<=o){var s=pc.resolveCoord([t,o]).index;if(0<=s)return r[s]=u,n.setAll(e,r),!0}return Reflect.set(r,o,u,i)}})},set:function(t){this.setAll(e,t)},configurable:!0,enumerable:!0})}ac.add("colorspace-init-end",(function(e){var t;Fp(e.id,e),null!=(t=e.aliases)&&t.forEach((function(t){Fp(t,e)}))})),mp.extend(Od),mp.extend({deltaE:_d}),mp.extend(Sd),mp.extend({contrast:function(e,t){var n,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},a=(r=r=Kl(r)?{algorithm:r}:r).algorithm,o=I(r,g);if(!a)throw r=Object.keys(td).map((function(e){return e.replace(/^contrast/,"")})).join(", "),new TypeError("contrast() function needs a contrast algorithm. Please specify one of: ".concat(r));for(n in e=hc(e),t=hc(t),td)if("contrast"+a.toLowerCase()===n.toLowerCase())return td[n](e,t,o);throw new TypeError("Unknown contrast algorithm: ".concat(a))}}),mp.extend(ad),mp.extend(Yc),m\
p.extend(Ld),mp.extend(td);var wp=le(ea()),Ep=(Gl.default.templateSettings.strip=!1,/^#[0-9a-f]{3,8}$/i),Cp=/hsl\\(\\s*([-\\d.]+)(rad|turn)/,xp=(J=new WeakMap,Q=new WeakMap,ee=new WeakMap,te=new WeakMap,ne=new WeakMap,re=new WeakMap,ae=new WeakSet,G(Ap,[{key:"r",get:function(){return S(J,this)},set:function(e){M(J,this,e),M(te,this,Math.round(255*Np(e,0,1)))}},{key:"g",get:function(){return S(Q,this)},set:function(e){M(Q,this,e),M(ne,this,Math.round(255*Np(e,0,1)))}},{key:"b",get:function(){return S(ee,this)},set:function(e){M(ee,this,e),M(re,this,Math.round(255*Np(e,0,1)))}},{key:"red",get:function(){return S(te,this)},set:function(e){M(J,this,e/255),M(te,this,Np(e,0,255))}},{key:"green",get:function(){return S(ne,this)},set:function(e){M(Q,this,e/255),M(ne,this,Np(e,0,255))}},{key:"blue",get:function(){return S(re,this)},set:function(e){M(ee,this,e/255),M(re,this,Np(e,0,255))}},{key:"toHexString",value:function(){var e=Math.round(this.red).toString(16),t=Math.round(this.green).toString(\
16),n=Math.round(this.blue).toString(16);return"#"+(15.5<this.red?e:"0"+e)+(15.5<this.green?t:"0"+t)+(15.5<this.blue?n:"0"+n)}},{key:"toJSON",value:function(){return{red:this.red,green:this.green,blue:this.blue,alpha:this.alpha}}},{key:"parseString",value:function(e){e=e.replace(Cp,(function(e,t,n){var r=t+n;switch(n){case"rad":return e.replace(r,180*t/Math.PI);case"turn":return e.replace(r,360*t)}}));try{"Prototype"in t&&"Version"in t.Prototype&&(n=Array.from,Array.from=wp.default);var n,r=new mp(e).to("srgb");n&&(Array.from=n,n=null),this.r=r.r,this.g=r.g,this.b=r.b,this.alpha=+r.alpha}catch(n){throw new Error('Unable to parse color "'.concat(e,'"'))}return this}},{key:"parseRgbString",value:function(e){this.parseString(e)}},{key:"parseHexString",value:function(e){e.match(Ep)&&![6,8].includes(e.length)&&this.parseString(e)}},{key:"parseColorFnString",value:function(e){this.parseString(e)}},{key:"getRelativeLuminance",value:function(){var e=this.r,t=this.g,n=this.b;return.2126*(e<=.03\
928?e/12.92:Math.pow((e+.055)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4))}},{key:"getLuminosity",value:function(){return.3*this.r+.59*this.g+.11*this.b}},{key:"setLuminosity",value:function(e){return e-=this.getLuminosity(),P(ae,this,kp).call(this,e).clip()}},{key:"getSaturation",value:function(){return Math.max(this.r,this.g,this.b)-Math.min(this.r,this.g,this.b)}},{key:"setSaturation",value:function(e){var t=new Ap(this),n=z([{name:"r",value:t.r},{name:"g",value:t.g},{name:"b",value:t.b}].sort((function(e,t){return e.value-t.value})),3),r=n[0],a=n[1];return(n=n[2]).value>r.value?(a.value=(a.value-r.value)*e/(n.value-r.value),n.value=e):a.value=n.value=0,r.value=0,t[n.name]=n.value,t[r.name]=r.value,t[a.name]=a.value,t}},{key:"clip",value:function(){var e=new Ap(this),t=e.getLuminosity(),n=Math.min(e.r,e.g,e.b),r=Math.max(e.r,e.g,e.b);return n<0&&(e.r=t+(e.r-t)*t/(t-n),e.g=t+(e.g-t)*t/(t-n),e.b=t+(e.b-t)*t/(\
t-n)),1<r&&(e.r=t+(e.r-t)*(1-t)/(r-t),e.g=t+(e.g-t)*(1-t)/(r-t),e.b=t+(e.b-t)*(1-t)/(r-t)),e}}]));function Ap(e,t,n){var r,a,o,u=3<arguments.length&&void 0!==arguments[3]?arguments[3]:1;H(this,Ap),O(this,ae),R(this,J,void 0),R(this,Q,void 0),R(this,ee,void 0),R(this,te,void 0),R(this,ne,void 0),R(this,re,void 0),e instanceof Ap?(r=e.r,a=e.g,o=e.b,this.r=r,this.g=a,this.b=o,this.alpha=e.alpha):(this.red=e,this.green=t,this.blue=n,this.alpha=u)}function kp(e){var t=new xp(this);return t.r+=e,t.g+=e,t.b+=e,t}var Bp=xp;function Np(e,t,n){return Math.min(Math.max(t,e),n)}var Tp=function(e){var t=new Bp;return t.parseString(e.getPropertyValue("background-color")),0!==t.alpha&&(e=e.getPropertyValue("opacity"),t.alpha=t.alpha*e),t},Rp=function(e){var n=t.getComputedStyle(e);return Hl(e,n)||1===Tp(n).alpha};function Op(e){var t;return!(!e.href||(t=Xa.get("firstPageLink",_p))&&e.compareDocumentPosition(t.actualNode)!==e.DOCUMENT_POSITION_FOLLOWING)}function _p(){return(t.location.origin?sD(o._tr\
ee,'a[href]:not([href^="javascript:"])').find((function(e){return!Bi(e.actualNode)})):sD(o._tree,'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript:"])')[0])||null}var Sp=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,Mp=/(\\w+)\\((\\d+)/;var Pp=function e(n,r,a){if(!n)throw new TypeError("Cannot determine if element is visible for non-DOM nodes");var u,i,s,l=n instanceof ua?n:Za(n),c=(n=l?l.actualNode:n,"_isVisible"+(r?"ScreenReader":"")),d=(p=null!=(p=t.Node)?p:{}).DOCUMENT_NODE,p=p.DOCUMENT_FRAGMENT_NODE,f=(l?l.props:n).nodeType,D=l?l.props.nodeName:n.nodeName.toLowerCase();return l&&void 0!==l[c]?l[c]:f===d||!["style","script","noscript","template"].includes(D)&&(n&&f===p&&(n=n.host),(!r||"true"!==(l?l.attr("aria-hidden"):n.getAttribute("aria-hidden")))&&(n?null!==(d=t.getComputedStyle(n,null))&&("area"===D?(u=r,i=a,!!(p=bu(f=n,"map"))&&!!(p=p.getAttribute("name"))&&!(!(f=mu(f))||9!==f.nodeType||!(s=sD(o._tree,'img[usemap="#'.concat(wa(p),'"]')))||!s\
.length)&&s.some((function(t){return e(t.actualNode,u,i)}))):"none"!==d.getPropertyValue("display")&&(D=parseInt(d.getPropertyValue("height")),f=parseInt(d.getPropertyValue("width")),s=(p=Nf(n))&&0===D,p=p&&0===f,D="absolute"===d.getPropertyValue("position")&&(D<2||f<2)&&"hidden"===d.getPropertyValue("overflow"),!(!r&&(function(e){var t=e.getPropertyValue("clip").match(Sp),n=e.getPropertyValue("clip-path").match(Mp);if(t&&5===t.length&&(e=e.getPropertyValue("position"),["fixed","absolute"].includes(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var r=parseInt(n[2],10);switch(e){case"inset":return 50<=r;case"circle":return 0===r}}}(d)||"0"===d.getPropertyValue("opacity")||s||p||D)||!a&&("hidden"===d.getPropertyValue("visibility")||!r&&$u(n))))&&(f=!1,(p=n.assignedSlot||n.parentNode)&&(f=e(p,r,!0)),l&&(l[c]=f),f)):(D=!0,(a=l.parent)&&(D=e(a,r,!0)),l&&(l[c]=D),D)))},Ip=function(e,n){for(var r=["fixed","sticky"],a=[],o=!1,u=0;u<e.length;++u){var i=e[u],s=(i===n&&(o=!0),t.getComputedSty\
le(i));o||-1===r.indexOf(s.position)?a.push(i):a=[]}return a};function jp(e,n){var r=Lp(n);do{var a,o,u,i,s,l,c=Lp(e);if(c===r||c===n)return i=e,a=n,u=(o=t.getComputedStyle(a)).getPropertyValue("overflow"),"inline"===o.getPropertyValue("display")||(i=Array.from(i.getClientRects()),s=a.getBoundingClientRect(),l={left:s.left,top:s.top,width:s.width,height:s.height},(["scroll","auto"].includes(u)||a instanceof t.HTMLHtmlElement)&&(l.width=a.scrollWidth,l.height=a.scrollHeight),1===i.length&&"hidden"===u&&"nowrap"===o.getPropertyValue("white-space")&&(i[0]=l),i.some((function(e){return!(Math.ceil(e.left)<Math.floor(l.left)||Math.ceil(e.top)<Math.floor(l.top)||Math.floor(e.left+e.width)>Math.ceil(l.left+l.width)||Math.floor(e.top+e.height)>Math.ceil(l.top+l.height))})))}while(e=c);return!1}function Lp(e){for(var t=Za(e).parent;t;){if(Nf(t.actualNode))return t.actualNode;t=t.parent}}var qp=function e(t,n){var a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:r,o=3<arguments.length&&vo\
id 0!==arguments[3]?arguments[3]:0;if(999<o)throw new Error("Infinite loop detected");return Array.from(a.elementsFromPoint(t,n)||[]).filter((function(e){return mu(e)===a})).reduce((function(r,a){var u;return pu(a)&&(u=e(t,n,a.shadowRoot,o+1),!(r=r.concat(u)).length||!jp(r[0],a))||r.push(a),r}),[])},zp=function(e,t){var n,a;if(e.hasAttribute(t))return a=e.nodeName.toUpperCase(),n=e,["A","AREA"].includes(a)&&!e.ownerSVGElement||((n=r.createElement("a")).href=e.getAttribute(t)),a=["https:","ftps:"].includes(n.protocol)?n.protocol.replace(/s:$/,":"):n.protocol,t=(e=(e=(t=e=/^\\//.test(n.pathname)?n.pathname:"/".concat(n.pathname)).split("/").pop())&&-1!==e.indexOf(".")?{pathname:t.replace(e,""),filename:/index./.test(e)?"":e}:{pathname:t,filename:""}).pathname,e=e.filename,{protocol:a,hostname:n.hostname,port:(a=n.port,["443","80"].includes(a)?"":a),pathname:/\\/$/.test(t)?t:"".concat(t,"/"),search:function(e){var t={};if(e&&e.length){var n=e.substring(1).split("&");if(n&&n.length)for(var r\
=0;r<n.length;r++){var a=(o=z(n[r].split("="),2))[0],o=void 0===(o=o[1])?"":o;t[decodeURIComponent(a)]=decodeURIComponent(o)}}return t}(n.search),hash:(a=n.hash)&&(t=a.match(/#!?\\/?/g))&&"#"!==z(t,1)[0]?a:"",filename:e}},Vp=function(e,n){var r=n.getBoundingClientRect(),a=r.top,o=r.left,u=a-n.scrollTop,i=(a=a-n.scrollTop+n.scrollHeight,o-n.scrollLeft);o=o-n.scrollLeft+n.scrollWidth;return!(e.left>o&&e.left>r.right||e.top>a&&e.top>r.bottom||e.right<i&&e.right<r.left||e.bottom<u&&e.bottom<r.top)&&(o=t.getComputedStyle(n),!(e.left>r.right||e.top>r.bottom)||"scroll"===o.overflow||"auto"===o.overflow||n instanceof t.HTMLBodyElement||n instanceof t.HTMLHtmlElement)},$p=0;function Hp(e,t,n){var r;return H(this,Hp),(r=A(this,Hp)).shadowId=n,r.children=[],r.actualNode=e,(r.parent=t)||($p=0),r.nodeIndex=$p++,r._isHidden=null,r._cache={},r._isXHTML=Ra(e.ownerDocument),"input"===e.nodeName.toLowerCase()&&(n=e.getAttribute("type"),n=r._isXHTML?n:(n||"").toLowerCase(),gD().includes(n)||(n="text"),r._\
type=n),Xa.get("nodeMap")&&Xa.get("nodeMap").set(e,r),r}N(Hp,ua);var Up,Gp=G(Hp,[{key:"props",get:function(){var e,t,n,r;return this._cache.hasOwnProperty("props")||(e=(r=this.actualNode).nodeType,t=r.nodeName,n=r.id,r=r.nodeValue,this._cache.props={nodeType:e,nodeName:this._isXHTML?t:t.toLowerCase(),id:n,type:this._type,nodeValue:r},1===e&&(this._cache.props.multiple=this.actualNode.multiple,this._cache.props.value=this.actualNode.value,this._cache.props.selected=this.actualNode.selected,this._cache.props.checked=this.actualNode.checked,this._cache.props.indeterminate=this.actualNode.indeterminate)),this._cache.props}},{key:"attr",value:function(e){return"function"!=typeof this.actualNode.getAttribute?null:this.actualNode.getAttribute(e)}},{key:"hasAttr",value:function(e){return"function"==typeof this.actualNode.hasAttribute&&this.actualNode.hasAttribute(e)}},{key:"attrNames",get:function(){var e;return this._cache.hasOwnProperty("attrNames")||(e=(this.actualNode.attributes instanceof\
 t.NamedNodeMap?this.actualNode:this.actualNode.cloneNode(!1)).attributes,this._cache.attrNames=Array.from(e).map((function(e){return e.name}))),this._cache.attrNames}},{key:"getComputedStylePropertyValue",value:function(e){var n="computedStyle_"+e;return this._cache.hasOwnProperty(n)||(this._cache.hasOwnProperty("computedStyle")||(this._cache.computedStyle=t.getComputedStyle(this.actualNode)),this._cache[n]=this._cache.computedStyle.getPropertyValue(e)),this._cache[n]}},{key:"isFocusable",get:function(){return this._cache.hasOwnProperty("isFocusable")||(this._cache.isFocusable=Pi(this.actualNode)),this._cache.isFocusable}},{key:"tabbableElements",get:function(){return this._cache.hasOwnProperty("tabbableElements")||(this._cache.tabbableElements=Si(this)),this._cache.tabbableElements}},{key:"clientRects",get:function(){return this._cache.hasOwnProperty("clientRects")||(this._cache.clientRects=Array.from(this.actualNode.getClientRects()).filter((function(e){return 0<e.width}))),this._ca\
che.clientRects}},{key:"boundingClientRect",get:function(){return this._cache.hasOwnProperty("boundingClientRect")||(this._cache.boundingClientRect=this.actualNode.getBoundingClientRect()),this._cache.boundingClientRect}}]),Wp=function(e){return(e||"").trim().replace(/\\s{2,}/g," ").split(" ")},Yp=" [idsMap]";function Kp(e,t,n){var r=e[0]._selectorMap;if(r){for(var a=e[0].shadowId,o=0;o<t.length;o++)if(1<t[o].length&&t[o].some(Xp))return;var u=new Set,i=(t.forEach((function(e){var t,n=function(e,t,n){var r=e[e.length-1],a=null,o=1<e.length||!!r.pseudos||!!r.classes;if(Xp(r))a=t["*"];else{if(r.id){if(!t[Yp]||!Object.hasOwn(t[Yp],r.id)||null==(e=t[Yp][r.id])||!e.length)return;a=t[Yp][r.id].filter((function(e){return e.shadowId===n}))}if(r.tag&&"*"!==r.tag){if(null==(e=t[r.tag])||!e.length)return;e=t[r.tag];a=a?Zp(e,a):e}if(r.classes){if(null==(e=t["[class]"])||!e.length)return;e=t["[class]"],a=a?Zp(e,a):e}if(r.attributes)for(var u=0;u<r.attributes.length;u++){var i=r.attributes[u];if("att\
rValue"===i.type&&(o=!0),null==(s=t["[".concat(i.key,"]")])||!s.length)return;var s=t["[".concat(i.key,"]")];a=a?Zp(s,a):s}}return{nodes:a,isComplexSelector:o}}(e,r,a);null!=n&&null!=(t=n.nodes)&&t.forEach((function(t){n.isComplexSelector&&!po(t,e)||u.add(t)}))})),[]);return u.forEach((function(e){return i.push(e)})),(i=n?i.filter(n):i).sort((function(e,t){return e.nodeIndex-t.nodeIndex}))}}function Xp(e){return"*"===e.tag&&!e.attributes&&!e.id&&!e.classes}function Zp(e,t){return e.filter((function(e){return t.includes(e)}))}function Jp(e,t,n){Object.hasOwn(n,e)||(n[e]=[]),n[e].push(t)}function Qp(e,t){1===e.props.nodeType&&(Jp(e.props.nodeName,e,t),Jp("*",e,t),e.attrNames.forEach((function(n){"id"===n&&(t[Yp]=t[Yp]||{},Wp(e.attr(n)).forEach((function(n){Jp(n,e,t[Yp])}))),Jp("[".concat(n,"]"),e,t)})))}function ef(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:r.documentElement,n=1<arguments.length?arguments[1]:void 0,a=(Up=!1,{});Xa.set("nodeMap",new WeakMap),Xa.set("se\
lectorMap",a),e=function e(n,r,a){var o,u,i;function s(t,n,a){return(n=e(n,r,a))?t.concat(n):t}return n.documentElement&&(n=n.documentElement),i=n.nodeName.toLowerCase(),pu(n)?(Up=!0,o=tf(n,a,r),r="a"+Math.random().toString().substring(2),u=Array.from(n.shadowRoot.childNodes),o.children=u.reduce((function(e,t){return s(e,t,o)}),[]),[o]):"content"===i&&"function"==typeof n.getDistributedNodes?(u=Array.from(n.getDistributedNodes())).reduce((function(e,t){return s(e,t,a)}),[]):"slot"===i&&"function"==typeof n.assignedNodes?((u=Array.from(n.assignedNodes())).length||(u=function(e){var t=[];for(e=e.firstChild;e;)t.push(e),e=e.nextSibling;return t}(n)),t.getComputedStyle(n),u.reduce((function(e,t){return s(e,t,a)}),[])):1===n.nodeType?(o=tf(n,a,r),u=Array.from(n.childNodes),o.children=u.reduce((function(e,t){return s(e,t,o)}),[]),[o]):3===n.nodeType?[tf(n,a)]:void 0}(e,n,null);return e[0]._selectorMap=a,e[0]._hasShadowRoot=Up,e}function tf(e,t,n){return Qp(e=new Gp(e,t,n),Xa.get("selectorMap\
")),e}var nf=function(e){return e?e.trim().split("-")[0].toLowerCase():""},rf=function(e){var t={};return t.none=e.none.concat(e.all),t.any=e.any,Object.keys(t).map((function(e){var n;return t[e].length&&(n=o._audit.data.failureSummaries[e])&&"function"==typeof n.failureMessage?n.failureMessage(t[e].map((function(e){return e.message||""}))):void 0})).filter((function(e){return void 0!==e})).join("\\n\\n")};function af(){var e=o._audit.data.incompleteFallbackMessage;return"string"!=typeof(e="function"==typeof e?e():e)?"":e}var of=ra.resultGroups;function uf(e,t){var n=o.utils.aggregateResult(e);return of.forEach((function(e){t.resultTypes&&!t.resultTypes.includes(e)&&(n[e]||[]).forEach((function(e){Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=[e.nodes[0]])})),n[e]=(n[e]||[]).map((function(e){return e=Object.assign({},e),Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=e.nodes.map((function(e){var n,r,o;return"object"===a(e.node)&&(n=sf(e.node,t),Object.assign(e,n)),delete e.result\
,delete e.node,r=e,o=t,["any","all","none"].forEach((function(e){Array.isArray(r[e])&&r[e].filter((function(e){return Array.isArray(e.relatedNodes)})).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){return sf(e,o)}))}))})),e}))),of.forEach((function(t){return delete e[t]})),delete e.pageLevel,delete e.result,e}))})),n}function sf(e,t){var n,r=0<arguments.length&&void 0!==e?e:{},a=1<arguments.length?t:void 0,u=(r=nu.dqElmToSpec(r,a),{});return o._audit.noHtml?u.html=null:u.html=null!=(n=r.source)?n:"Undefined",a.elementRef&&!r.fromFrame&&(u.element=null!=(n=r.element)?n:null),!1===a.selectors&&!r.fromFrame||(u.target=null!=(n=r.selector)?n:[":root"]),a.ancestry&&(u.ancestry=null!=(n=r.ancestry)?n:[":root"]),a.xpath&&(u.xpath=null!=(n=r.xpath)?n:["/"]),u}var lf=/\\$\\{\\s?data\\s?\\}/g;function cf(e,t){if("string"==typeof t)return e.replace(lf,t);for(var n in t){var r;t.hasOwnProperty(n)&&(r=new RegExp("\\\\\${\\\\s?data\\\\."+n+"\\\\s?}","g"),n=void 0===t[n]?"":String(t[n]),e=e.re\
place(r,n))}return e}var df=function e(t,n){var r;if(t)return Array.isArray(n)?(n.values=n.join(", "),"string"==typeof t.singular&&"string"==typeof t.plural?cf(1===n.length?t.singular:t.plural,n):cf(t,n)):"string"==typeof t?cf(t,n):"string"==typeof n?cf(t[n],n):(r=t.default||af(),e(r=n&&n.messageKey&&t[n.messageKey]?t[n.messageKey]:r,n))},pf=function(e,t,n){var r=o._audit.data.checks[e];if(!r)throw new Error("Cannot get message for unknown check: ".concat(e,"."));if(r.messages[t])return df(r.messages[t],n);throw new Error('Check "'.concat(e,'"" does not have a "').concat(t,'" message.'))},ff=function(e,t,n){t=((n.rules&&n.rules[t]||{}).checks||{})[e.id];var r=(n.checks||{})[e.id],a=e.enabled;e=e.options;return r&&(r.hasOwnProperty("enabled")&&(a=r.enabled),r.hasOwnProperty("options"))&&(e=r.options),t&&(t.hasOwnProperty("enabled")&&(a=t.enabled),t.hasOwnProperty("options"))&&(e=t.options),{enabled:a,options:e,absolutePaths:n.absolutePaths}};function Df(){var e,n,r,u,i=0<arguments.lengt\
h&&void 0!==arguments[0]?arguments[0]:null,s=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t;return i&&"object"===a(i)?i:"object"!==a(s)?{}:{testEngine:{name:"axe-core",version:o.version},testRunner:{name:o._audit.brand},testEnvironment:(i=s).navigator&&"object"===a(i.navigator)?(e=i.navigator,n=i.innerHeight,r=i.innerWidth,i=function(e){return(e=e.screen).orientation||e.msOrientation||e.mozOrientation}(i)||{},u=i.angle,i=i.type,{userAgent:e.userAgent,windowWidth:r,windowHeight:n,orientationAngle:u,orientationType:i}):{},timestamp:(new Date).toISOString(),url:null==(e=s.location)?void 0:e.href}}function mf(e,t){var n=t.focusable;t=t.page;return{node:e,include:[],exclude:[],initiator:!1,focusable:n&&(!(n=(n=e).getAttribute("tabindex"))||(n=parseInt(n,10),isNaN(n))||0<=n),size:function(e){var t=parseInt(e.getAttribute("width"),10),n=parseInt(e.getAttribute("height"),10);return(isNaN(t)||isNaN(n))&&(e=e.getBoundingClientRect(),t=isNaN(t)?e.width:t,n=isNaN(n)?e.height:n),{width:t,\
height:n}}(e),page:t}}function hf(e){var n=0<arguments.length&&void 0!==e?e:[],r=[];Ff(n)||(n=[n]);for(var a=0;a<n.length;a++){var o=function(e){return e instanceof t.Node?e:"string"==typeof e?[e]:(vf(e)?(function(e){wf(Array.isArray(e.fromFrames),"fromFrames property must be an array"),wf(e.fromFrames.every((function(e){return!Ef(e,"fromFrames")})),"Invalid context; fromFrames selector must be appended, rather than nested"),wf(!Ef(e,"fromShadowDom"),"fromFrames and fromShadowDom cannot be used on the same object")}(e),e=e.fromFrames):yf(e)&&(e=[e]),function(e){if(Array.isArray(e)){var t,n=[],r=Y(e);try{for(r.s();!(t=r.n()).done;){var a=t.value;if(yf(a)&&(function(e){wf(Array.isArray(e.fromShadowDom),"fromShadowDom property must be an array"),wf(e.fromShadowDom.every((function(e){return!Ef(e,"fromFrames")})),"shadow selector must be inside fromFrame instead"),wf(e.fromShadowDom.every((function(e){return!Ef(e,"fromShadowDom")})),"fromShadowDom selector must be appended, rather than nest\
ed")}(a),a=a.fromShadowDom),"string"!=typeof a&&!function(e){return Array.isArray(e)&&e.every((function(e){return"string"==typeof e}))}(a))return;n.push(a)}}catch(e){r.e(e)}finally{r.f()}return n}}(e))}(n[a]);o&&r.push(o)}return r}function gf(e){return["include","exclude"].some((function(t){return Ef(e,t)&&bf(e[t])}))}function bf(e){return"string"==typeof e||e instanceof t.Node||vf(e)||yf(e)||Ff(e)}function vf(e){return Ef(e,"fromFrames")}function yf(e){return Ef(e,"fromShadowDom")}function Ff(e){return e&&"object"===a(e)&&"number"==typeof e.length&&e instanceof t.Node==0}function wf(e,t){ya(e,"Invalid context; ".concat(t,"\\nSee: https://github.com/dequelabs/axe-core/blob/master/doc/context.md"))}function Ef(e,t){return!(!e||"object"!==a(e))&&Object.prototype.hasOwnProperty.call(e,t)}function Cf(e,n){for(var r=[],a=0,o=e[n].length;a<o;a++){var u=e[n][a];u instanceof t.Node?u.documentElement instanceof t.Node?r.push(e.flatTree[0]):r.push(Za(u)):u&&u.length&&(1<u.length?function(e,t,n){e\
.frames=e.frames||[],hD(n.shift()).forEach((function(r){var a=e.frames.find((function(e){return e.node===r}));a||(a=mf(r,e),e.frames.push(a)),a[t].push(n)}))}(e,n,u):(u=hD(u[0]),r.push.apply(r,j(u.map((function(e){return Za(e)}))))))}return r.filter((function(e){return e}))}function xf(e,n){var o=this,u=(e=no(e),this.frames=[],this.page="boolean"==typeof(null==(u=e)?void 0:u.page)?e.page:void 0,this.initiator="boolean"!=typeof(null==(u=e)?void 0:u.initiator)||e.initiator,this.focusable="boolean"!=typeof(null==(u=e)?void 0:u.focusable)||e.focusable,this.size="object"===a(null==(u=e)?void 0:u.size)?e.size:{},e=function(e){if(gf(e)){var t=" must be used inside include or exclude. It should not be on the same object.";wf(!Ef(e,"fromFrames"),"fromFrames"+t),wf(!Ef(e,"fromShadowDom"),"fromShadowDom"+t)}else{if(!bf(e))return{include:[r],exclude:[]};e={include:e,exclude:[]}}return 0===(t=hf(e.include)).length&&t.push(r),{include:t,exclude:e=hf(e.exclude)}}(e),this.flatTree=null!=n?n:ef(functio\
n(e){for(var n=e.include,a=(e=e.exclude,Array.from(n).concat(Array.from(e))),o=0;o<a.length;o++){var u=a[o];if(u instanceof t.Element)return u.ownerDocument.documentElement;if(u instanceof t.Document)return u.documentElement}return r.documentElement}(e)),this.exclude=e.exclude,this.include=e.include,this.include=Cf(this,"include"),this.exclude=Cf(this,"exclude"),fD("frame, iframe",this).forEach((function(e){var t;If(e,o)&&(t=o,Ps(e=e.actualNode))&&!au(t.frames,"node",e)&&t.frames.push(mf(e,t))})),void 0===this.page&&(this.page=function(e){return 1===(e=e.include).length&&e[0].actualNode===r.documentElement}(this),this.frames.forEach((function(e){e.page=o.page}))),this);if(0===u.include.length&&0===u.frames.length)throw u=Ko.isInFrame()?"frame":"page",new Error("No elements found for include in "+u+" Context");Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(qf)}function Af(e){return!1===(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).if\
rames?[]:new xf(e).frames.map((function(e){var t=e.node;return(e=I(e,y)).initiator=!1,{frameSelector:Wa(t),frameContext:e}}))}function kf(e){var t=o._audit.rules.find((function(t){return t.id===e}));if(t)return t;throw new Error("Cannot find rule by id: ".concat(e))}function Bf(e,t){return e=e.getPropertyValue(t),["scroll","auto"].includes(e)}var Nf=Ta((function(e){var n,r,a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,o=e.scrollWidth>e.clientWidth+a;a=e.scrollHeight>e.clientHeight+a;if(o||a)return n=Bf(r=t.getComputedStyle(e),"overflow-x"),r=Bf(r,"overflow-y"),o&&n||a&&r?{elm:e,top:e.scrollTop,left:e.scrollLeft}:void 0})),Tf=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:t,n=e.document.documentElement;return[void 0!==e.pageXOffset?{elm:e,top:e.pageYOffset,left:e.pageXOffset}:{elm:n,top:n.scrollTop,left:n.scrollLeft}].concat(function e(t){return Array.from(t.children||t.childNodes||[]).reduce((function(t,n){var r=Nf(n);return r&&t.push(r),t.concat(e\
(n))}),[])}(r.body))};function Rf(){return no(Zi)}var Of,_f=function(e){if(e)return function(t){var n=t.data,r=void 0!==(r=t.isCrossOrigin)&&r,a=t.shadowId,o=t.root,u=t.priority,i=(t=void 0!==(t=t.isLink)&&t,e.createElement("style"));return t?(t=e.createTextNode('@import "'.concat(n.href,'"')),i.appendChild(t)):i.appendChild(e.createTextNode(n)),e.head.appendChild(i),{sheet:i.sheet,isCrossOrigin:r,shadowId:a,root:o,priority:u}};throw new Error("axe.utils.getStyleSheetFactory should be invoked with an argument")},Sf=function(e){var t;return Of&&Of.parentNode?(void 0===Of.styleSheet?Of.appendChild(r.createTextNode(e)):Of.styleSheet.cssText+=e,Of):e?(t=r.head||r.getElementsByTagName("head")[0],(Of=r.createElement("style")).type="text/css",void 0===Of.styleSheet?Of.appendChild(r.createTextNode(e)):Of.styleSheet.cssText=e,t.appendChild(Of),Of):void 0},Mf=function e(n,r){var a,o=Za(n);return 9!==n.nodeType&&(11===n.nodeType&&(n=n.host),o&&null!==o._isHidden?o._isHidden:!(a=t.getComputedStyle\
(n,null))||!n.parentNode||"none"===a.getPropertyValue("display")||!r&&"hidden"===a.getPropertyValue("visibility")||"true"===n.getAttribute("aria-hidden")||(r=e(n.assignedSlot||n.parentNode,!0),o&&(o._isHidden=r),r))},Pf=function(e){var t=null!=(t=null==(t=e.props)?void 0:t.nodeName)?t:e.nodeName.toLowerCase();return"http://www.w3.org/2000/svg"!==e.namespaceURI&&!!Zi.htmlElms[t]};function If(e,t){var n=void 0===(n=t.include)?[]:n;t=void 0===(t=t.exclude)?[]:t,n=n.filter((function(t){return su(t,e)}));return 0!==n.length&&(0===(t=t.filter((function(t){return su(t,e)}))).length||(n=jf(n),su(jf(t),n)))}function jf(e){var t,n,r=Y(e);try{for(r.s();!(n=r.n()).done;){var a=n.value;t&&su(a,t)||(t=a)}}catch(e){r.e(e)}finally{r.f()}return t}function Lf(e,t){return e.length===t.length&&e.every((function(e,n){var r=t[n];return Array.isArray(e)?e.length===r.length&&e.every((function(e,t){return r[t]===e})):e===r}))}var qf=function(e,t){return(e=e.actualNode||e)===(t=t.actualNode||t)?0:4&e.compareDoc\
umentPosition(t)?-1:1};function zf(e){return e instanceof ua?{vNode:e,domNode:e.actualNode}:{vNode:Za(e),domNode:e}}var Vf,$f,Hf=function(e,t,n,r){var a,o=4<arguments.length&&void 0!==arguments[4]&&arguments[4],u=Array.from(e.cssRules);return u?(a=u.filter((function(e){return 3===e.type}))).length?(a=a.filter((function(e){return e.href})).map((function(e){return e.href})).filter((function(e){return!r.includes(e)})).map((function(e,a){a=[].concat(j(n),[a]);var o=/^https?:\\/\\/|^\\/\\//i.test(e);return Gf(e,t,a,r,o)})),(u=u.filter((function(e){return 3!==e.type}))).length&&a.push(Promise.resolve(t.convertDataToStylesheet({data:u.map((function(e){return e.cssText})).join(),isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId}))),Promise.all(a)):Promise.resolve({isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId,sheet:e}):Promise.resolve()},Uf=function(e,t,n,r){var a=4<arguments.length&&void 0!==arguments[4]&&arguments[4];return function(e){try{return!(!e.cssRules&&e.hre\
f)}catch(e){return!1}}(e)?Hf(e,t,n,r,a):Gf(e.href,t,n,r,!0)},Gf=function(e,n,r,a,o){return a.push(e),new Promise((function(n,r){var a=new t.XMLHttpRequest;a.open("GET",e),a.timeout=ra.preload.timeout,a.addEventListener("error",r),a.addEventListener("timeout",r),a.addEventListener("loadend",(function(e){if(e.loaded&&a.responseText)return n(a.responseText);r(a.responseText)})),a.send()})).then((function(e){return e=n.convertDataToStylesheet({data:e,isCrossOrigin:o,priority:r,root:n.rootNode,shadowId:n.shadowId}),Uf(e.sheet,n,r,a,e.isCrossOrigin)}))};function Wf(){if(t.performance&&t.performance)return t.performance.now()}Vf=null,$f=Wf();var Yf={start:function(){this.mark("mark_axe_start")},end:function(){this.mark("mark_axe_end"),this.measure("axe","mark_axe_start","mark_axe_end"),this.logMeasures("axe")},auditStart:function(){this.mark("mark_audit_start")},auditEnd:function(){this.mark("mark_audit_end"),this.measure("audit_start_to_end","mark_audit_start","mark_audit_end"),this.logMeasu\
res()},mark:function(e){t.performance&&void 0!==t.performance.mark&&t.performance.mark(e)},measure:function(e,n,r){t.performance&&void 0!==t.performance.measure&&t.performance.measure(e,n,r)},logMeasures:function(e){function n(e){aa("Measure "+e.name+" took "+e.duration+"ms")}if(t.performance&&void 0!==t.performance.getEntriesByType)for(var r=t.performance.getEntriesByName("mark_axe_start")[0],a=t.performance.getEntriesByType("measure").filter((function(e){return e.startTime>=r.startTime})),o=0;o<a.length;++o){var u=a[o];if(u.name===e)return void n(u);n(u)}},timeElapsed:function(){return Wf()-$f},reset:function(){Vf=Vf||Wf(),$f=Wf()}};function Kf(){var e,t,n,a;return r.elementsFromPoint||r.msElementsFromPoint||((e=r.createElement("x")).style.cssText="pointer-events:auto",e="auto"===e.style.pointerEvents,t=e?"pointer-events":"visibility",n=e?"none":"hidden",(a=r.createElement("style")).innerHTML=e?"* { pointer-events: all }":"* { visibility: visible }",function(e,o){var u,i,s,l=[],c=[];\
for(r.head.appendChild(a);(u=r.elementFromPoint(e,o))&&-1===l.indexOf(u);)l.push(u),c.push({value:u.style.getPropertyValue(t),priority:u.style.getPropertyPriority(t)}),u.style.setProperty(t,n,"important");for(l.indexOf(r.documentElement)<l.length-1&&(l.splice(l.indexOf(r.documentElement),1),l.push(r.documentElement)),i=c.length;s=c[--i];)l[i].style.setProperty(t,s.value||"",s.priority);return r.head.removeChild(a),l})}"function"==typeof t.addEventListener&&(r.elementsFromPoint=Kf());var Xf=function(e,t){return e.concat(t).filter((function(e,t,n){return n.indexOf(e)===t}))};function Zf(e,t,n,r,a){return(a=a||{}).vNodes=e,a.vNodesIndex=0,a.anyLevel=t,a.thisLevel=n,a.parentShadowId=r,a}var Jf=function(e,t,n){if(r=Kp(e=Array.isArray(e)?e:[e],t=co(t),n))return r;for(var r=e,a=(e=t,n),o=Xa.get("qsa.recycledLocalVariables",(function(){return[]})),u=[],i=Zf(Array.isArray(r)?r:[r],e,null,r[0].shadowId,o.pop()),s=[];i.vNodesIndex<i.vNodes.length;){for(var l,c=i.vNodes[i.vNodesIndex++],d=null,p=n\
ull,f=((null==(l=i.anyLevel)?void 0:l.length)||0)+((null==(l=i.thisLevel)?void 0:l.length)||0),D=!1,m=0;m<f;m++){var h=m<((null==(h=i.anyLevel)?void 0:h.length)||0)?i.anyLevel[m]:i.thisLevel[m-((null==(h=i.anyLevel)?void 0:h.length)||0)];if((!h[0].id||c.shadowId===i.parentShadowId)&&po(c,h[0]))if(1===h.length)D||a&&!a(c)||(s.push(c),D=!0);else{var g=h.slice(1);if(!1===[" ",">"].includes(g[0].combinator))throw new Error("axe.utils.querySelectorAll does not support the combinator: "+h[1].combinator);(">"===g[0].combinator?d=d||[]:p=p||[]).push(g)}h[0].id&&c.shadowId!==i.parentShadowId||null==(g=i.anyLevel)||!g.includes(h)||(p=p||[]).push(h)}for(c.children&&c.children.length&&(u.push(i),i=Zf(c.children,p,d,c.shadowId,o.pop()));i.vNodesIndex===i.vNodes.length&&u.length;)o.push(i),i=u.pop()}return s},Qf=function(e){var t,n,a,u;e=void 0===(e=e.treeRoot)?o._tree[0]:e;return t=[],e=Jf(e,"*",(function(e){return!t.includes(e.shadowId)&&(t.push(e.shadowId),!0)})).map((function(e){return{shadowId:\
e.shadowId,rootNode:Du(e.actualNode)}})),(e=Xf(e,[])).length?(n=r.implementation.createHTMLDocument("Dynamic document for loading cssom"),n=_f(n),a=n,u=[],e.forEach((function(e,t){var n=e.rootNode,r=function(e,t,n){return t=11===e.nodeType&&t?function(e,t){return Array.from(e.children).filter(eD).reduce((function(n,r){var a=r.nodeName.toUpperCase();r="STYLE"===a?r.textContent:r;return(r=t({data:r,isLink:"LINK"===a,root:e})).sheet&&n.push(r.sheet),n}),[])}(e,n):function(e){return Array.from(e.styleSheets).filter((function(e){return!!e.media&&tD(e.media.mediaText)}))}(e),function(e){var t=[];return e.filter((function(e){if(e.href){if(t.includes(e.href))return!1;t.push(e.href)}return!0}))}(t)}(n,e=e.shadowId,a);if(!r)return Promise.all(u);var o=t+1,i={rootNode:n,shadowId:e,convertDataToStylesheet:a,rootIndex:o},s=[];t=Promise.all(r.map((function(e,t){return Uf(e,i,[o,t],s)})));u.push(t)})),Promise.all(u).then((function e(t){return t.reduce((function(t,n){return Array.isArray(n)?t.concat(e\
(n)):t.concat(n)}),[])}))):Promise.resolve()};function eD(e){var t=e.nodeName.toUpperCase(),n=e.getAttribute("href"),r=e.getAttribute("rel");n="LINK"===t&&n&&r&&e.rel.toUpperCase().includes("STYLESHEET");return"STYLE"===t||n&&tD(e.media)}function tD(e){return!e||!e.toUpperCase().includes("PRINT")}var nD=function(e){return e=void 0===(e=e.treeRoot)?o._tree[0]:e,e=Jf(e,"video, audio",(function(e){return(e=e.actualNode).hasAttribute("src")?!!e.getAttribute("src"):!(Array.from(e.getElementsByTagName("source")).filter((function(e){return!!e.getAttribute("src")})).length<=0)})),Promise.all(e.map((function(e){var t;e=e.actualNode;return t=e,new Promise((function(e){0<t.readyState&&e(t),t.addEventListener("loadedmetadata",(function n(){t.removeEventListener("loadedmetadata",n),e(t)}))}))})))};function rD(e){var t={cssom:Qf,media:nD};return aD(e)?new Promise((function(n,r){var a=(o=oD(e)).assets,o=o.timeout,u=setTimeout((function(){return r(new Error("Preload assets timed out."))}),o);Promise.a\
ll(a.map((function(n){return t[n](e).then((function(e){return t={},(r=W(r=n))in t?Object.defineProperty(t,r,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[r]=e,t;var t,r}))}))).then((function(e){e=e.reduce((function(e,t){return q({},e,t)}),{}),clearTimeout(u),n(e)})).catch((function(e){clearTimeout(u),r(e)}))})):Promise.resolve()}function aD(e){return!e||void 0===e.preload||null===e.preload||("boolean"==typeof e.preload?e.preload:(e=e.preload,"object"===a(e)&&Array.isArray(e.assets)))}function oD(e){var t=(n=ra.preload).assets,n=n.timeout;n={assets:t,timeout:n};if(e.preload&&"boolean"!=typeof e.preload){if(!e.preload.assets.every((function(e){return t.includes(e.toLowerCase())})))throw new Error("Requested assets, not supported. Supported assets are: ".concat(t.join(", "),"."));n.assets=Xf(e.preload.assets.map((function(e){return e.toLowerCase()})),[]),e.preload.timeout&&"number"==typeof e.preload.timeout&&!isNaN(e.preload.timeout)&&(n.timeout=e.preload.timeout)}return n}functi\
on uD(e){var t=o._audit.data.checks||{},n=o._audit.data.rules||{},r=au(o._audit.rules,"id",e.id)||{},a=(e.tags=no(r.tags||[]),iD(t,!0,r)),u=iD(t,!1,r);e.nodes.forEach((function(e){e.any.forEach(a),e.all.forEach(a),e.none.forEach(u)})),cu(e,no(n[e.id]||{}))}function iD(e,t,n){return function(r){var o,u=(o=e[r.id]||{}).messages||{};delete(o=Object.assign({},o)).messages,n.reviewOnFail||void 0!==r.result?o.message=r.result===t?u.pass:u.fail:("object"!==a(u.incomplete)||Array.isArray(r.data)||(o.message=function(e,t){function n(e){return e.incomplete&&e.incomplete.default?e.incomplete.default:af()}if(!e||!e.missingData)return e&&e.messageKey?t.incomplete[e.messageKey]:n(t);try{var r=t.incomplete[e.missingData[0].reason];if(r)return r;throw new Error}catch(r){return"string"==typeof e.missingData?t.incomplete[e.missingData]:n(t)}}(r.data,u)),o.message||(o.message=u.incomplete)),"function"!=typeof o.message&&(o.message=df(o.message,r.data)),cu(r,o)}}var sD=function(e,t){return Jf(e,t)};functi\
on lD(e,t){var n,r=o._audit&&o._audit.tagExclude?o._audit.tagExclude:[],a=t.hasOwnProperty("include")||t.hasOwnProperty("exclude")?(n=t.include||[],n=Array.isArray(n)?n:[n],a=t.exclude||[],(a=Array.isArray(a)?a:[a]).concat(r.filter((function(e){return-1===n.indexOf(e)})))):(n=Array.isArray(t)?t:[t],r.filter((function(e){return-1===n.indexOf(e)})));return!!(n.some((function(t){return-1!==e.tags.indexOf(t)}))||0===n.length&&!1!==e.enabled)&&a.every((function(t){return-1===e.tags.indexOf(t)}))}var cD=function(e,t,n){var r=n.runOnly||{};n=(n.rules||{})[e.id];return!(e.pageLevel&&!t.page)&&("rule"===r.type?-1!==r.values.indexOf(e.id):n&&"boolean"==typeof n.enabled?n.enabled:"tag"===r.type&&r.values?lD(e,r.values):lD(e,[]))};function dD(e,t){var n,r,a;return t?(a=e.cloneNode(!1),n=ka(a),a=1===a.nodeType?(r=a.outerHTML,Xa.get(r,(function(){return pD(a,n,e,t)}))):pD(a,n,e,t),Array.from(e.childNodes).forEach((function(e){a.appendChild(dD(e,t))})),a):e}function pD(e,t,n,a){return t&&(e=r.createE\
lement(e.nodeName),Array.from(t).forEach((function(t){var r,o,u;r=n,o=t.name,void 0!==(u=a)[o]&&(!0===u[o]||Ba(r,u[o]))||e.setAttribute(t.name,t.value)}))),e}function fD(e,t){var n=[];if(o._selectCache)for(var r=0,a=o._selectCache.length;r<a;r++){var u=o._selectCache[r];if(u.selector===e)return u.result}for(var i,s=t.include.reduce((function(e,t){return e.length&&su(e[e.length-1],t)||e.push(t),e}),[]),l=(i=t).exclude&&0!==i.exclude.length?function(e){return If(e,i)}:null,c=0;c<s.length;c++){var d=s[c];n=function(e,t){if(0===e.length)return t;var n;e.length<t.length&&(n=e,e=t,t=n);for(var r=0,a=t.length;r<a;r++)e.includes(t[r])||e.push(t[r]);return e}(n,Jf(d,e,l))}return o._selectCache&&o._selectCache.push({selector:e,result:n}),n}var DD=function(e){e.forEach((function(e){var n=e.elm,r=e.top;e=e.left;if(n===t)return n.scroll(e,r);n.scrollTop=r,n.scrollLeft=e}))};function mD(e){return function e(t,n){var r=t.shift();return n=r?n.querySelector(r):null,0===t.length?n:null!=n&&n.shadowRoot?\
e(t,n.shadowRoot):null}(Array.isArray(e)?j(e):[e],r)}function hD(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:r,n=Array.isArray(e)?j(e):[e];return 0===e.length?[]:function e(t,n){t=function(e){return $(e)||L(e)||K(e)||V()}(t);var r=t[0],a=t.slice(1);if(t=n.querySelectorAll(r),0===a.length)return Array.from(t);var o,u=[],i=Y(t);try{for(i.s();!(o=i.n()).done;){var s=o.value;null!=s&&s.shadowRoot&&u.push.apply(u,j(e(a,s.shadowRoot)))}}catch(e){i.e(e)}finally{i.f()}return u}(n,t)}var gD=function(){return["hidden","text","search","tel","url","email","password","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]},bD=[,[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,,,,,1,1,1,1,,,1,1,1,,1,,1,,1,1],[1,1,1,,1,1,,1,1,1,,1,,\
,1,1,1,,,1,1,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,,,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1],[,1,,,,,,1,,1,,,,,1,,1,,,,1,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,,,1,,,,,1,1,1,,1,,1,,1,,,,,,1],[1,,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,,1,,1,,,,,1,,1,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,,1,1,1,,1,,1,1,1,,,1,1,1,1,1,1,1,1],[,,1,,,1,,1,,,,1,1,1,,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1,1,1,1,1,,,1,1,1],[1,1,1,1,1,,,1,,,1,,,1,1,1,,,,,1,,,,,,1]],[,[1,1,\
1,1,1,1,1,1,1,1,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1],[,1,,1,1,1,,1,1,,1,,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,,,1,1,1,,,1,1,,,,,,1,1],[1,1,1,,,,,1,,,,1,1,,1,,,,,,1,,,,,1],[,1,,,1,,,1,,,,,,1],[,1,,1,,,,1,,,,1],[1,,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,,1,,,1,1,1,1],[,1,1,1,1,1,,,1,,,1,,1,1,,1,,1,,,,,1,,1],[,1,,,,1,,,1,1,,1,,1,1,1,1,,1,1,,,1,,,1],[,1,1,,,,,,1,,,,1,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,,1,1,1,,,1,1,1,1,1,1,,1,,,,,1,1,,1,,1],[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,1,1],[,1,1,1,,,,1,1,1,,1,1,,,1,1,,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,\
1,,,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,,1,,,,,1,1,1,,,1,,1,,,1,1],[,,,,1,,,,,,,,,,,,,,,,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,,1,1,1,,1,1,,,,1,1,1,1,1,,,1,1,1,,,,,1],[1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,1,,,,,,,1],[,1,1,,1,1,,1,,,,,,,,,,,,,1],,[1,1,1,,,,,,,,,,,,,1],[,,,,,,,,1,,,1,,,1,1,,,,,1]],[,[1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,,1],[,,,1,,,,,,,,,,,,,,,1],[,1,,,1,1,,1,,1,1,,,,1,1,,,1,1,,,,1],[1,,,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,,,,1],,[,1,1,1,1,1,,1,1,1,,1,1,,1,1,,,1,1,1,1,,1,1,,1],[,1,,,1,,,1,,1,,,1,1,1,1,,,1,1,,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,,,1,1,1,1,1,1,1,,,1,,,1,,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,,,,1],[,,,,,,,1,,,,1,,1,1],[,1,1,1,1,1,1,1,,,,1,1,1,1,1,,,1,1,,1,1,1,1,1],[,1,,,1,1,,1,,1,1,1,,,1,1,,,1,,1,1,1,1,,1],[,1,1,1,,1,1,,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1],[,,,,,,,,,,,,,,,,1],\
,[,1,1,1,1,1,,1,1,1,,,1,,1,1,,1,1,1,1,1,,1,,1],[,,1,,,1,,,1,1,,,1,,1,1,,1],[,1,1,,1,,,,1,1,,1,,1,1,1,1,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,1,,1,,1,1],,[,1,1,,1,,,1,,1,,,,1,1,1,,,,,,1,,,,1],[1,1,,,1,1,,1,,,,,1,,1]],[,[,1],[,,,1,,,,1,,,,1,,,,1,,,1,,,1],[,,,,,,,,,,,,,,,,,,1,1,,,,,,1],,[1,,,,,1],[,1,,,,1,,,,1],[,1,,,,,,,,,,,1,,,1,,,,,,,,,1,1],[,,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,1,,1],[,1],[,1,,1,,1,,1,,1,,1,1,1,,1,1,,1,,,,,,,1],[1,,,,,1,,,1,1,,1,,1,,1,1,,,,,1,,,1],[,1,1,,,1,,1,,1,,1,,1,1,1,1,,,1,,1,,1,1,1],[1,1,1,1,1,,1,,1,,,,1,1,1,1,,1,1,,,1,1,1,1],[1,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],,[,1,,,,,,1,1,1,,1,,,,1,,,1,1,1,,,1],[1,,,,,1,,1,1,1,,1,1,1,1,1,,1,,1,,1,,,1,1],[1,,1,1,,,,,1,,,,,,1,1,,,1,1,1,1,,,1,,1],[1,,,,,,,,,,,,,,,,,1],[,,,,,1,,,1,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,,,1],[,1,,,,1]],[,[1,1,1,,1,,1,1,1,1,1,1,1,1,1,,1,,1,,1,1,,,1,1,1],[,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],,[,,,,\
,,,,,,,,,,,,,,1],[1,,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1],,[1,1,,,,1,1,,,,,,1,,,,1,,1,,1,1,,1],[1],[,,,,,,,,,,,1,,,,,,,,,,,1],[,1,,,,,,,1,1,,,1,,1,,,,1,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,,1],[,,1,,,,,1,,1],[1,,,,1,,,,,1,,,,1,1,,,,1,1,,,,,1],[,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[1,,,1,1,,,,,,,1,,1,,1,1,1,1,1,1],[,,,,,1,,,,,,,1,,,,,,,1],,[,,1,1,1,1,1,,1,1,1,,,1,1,,,1,1,,1,1,1,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,,,,1],,[1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,,,1,1,1,1,,,,,,1,,1,,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,,,,1,,1,,,1,1,1,1,1],[,,,,,,,,,,,1,,,,,,,,,1,,,,1],[,1,1,,1,1,,1,,,,1,1,,1,1,,,1,,1,1,,1],[,1,,1,,1,,,1,,,1,1,,1,1,,,1,1,1],[,1,1,1,1,1,,1,1,,,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,,,,,,,,,1,,1,,1,1,,,,1,,,1],[,1,,,1,1,,,,,,,,,1,1,1,,,,,1],[1,,,1,1,,,,1,1,1,1,1,,,1,,,1,,,1,,1,,1],[,1,1,,1,1,,1,1,,,,1,1,1,,,1,1,,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,,1,,,1\
],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,,,,1,,,,,,,,,1],[,1,,,,,,,,1,,,,,1,,,,1,,,1],[,1,1,1,1,,,1,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1],[,,,,,1,,1,,,,,1,1,1,1,1,,,1,,,,1],[,1,,,,,,,,1,,,,,,,,,,,,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,1,,,,1,,1,1,1,1,1,,1,1,,,,,,1],[,1,1,1,1,1,1,1,,1,1,,,1,1,,,,1,,1,1,,1,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,1,1,,1,,,1,1,1,1,,,1,,,,,,,1],[,1,,,,,,,,1,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1],[,1,1,,,,,,,,,,,,1,1,,,,,,1],[,1,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,,,,,1],[1,1,,,1,,,1,1,1,,,,1],,[,,,,,,,,,,,,,1,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,1,,,,,,,1],[1,1,1,,1,,1,1,1,1,1,1,1,1,,1,,,1,,1,,,1,1],[,,,,,,,,,1],[,1,,,,1,,,,,,1,,,1,,,,,1],[,1,1,,1,1,,,,,,,,,,,,,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,1,1,1,,,,1,1,,,,1,,1],[1,1,1,1,1,1,,,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,,1,1],[,,,,,,,,,,,,,,,1,,,,1],,[1,1,,1,,1,,,,,,1,,1,,1,1,,1,,1,1,,1,1,,1],[,,1,,,,,,1,,,,1,,1,,\
,,,1],[1,,,,,,,,,1,,,,,,1,,,,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,,1,,,,,,1,,,1,,,,,,,,1],[,1,,1,,,,,,,,,,,,1],,[1,1,,,,,,,,,,,,,,,,,,,,,,1,1],[1]],[,[1,,,,,,,,,1,,,,,1,,1,,1],[,1,1,,1,1,,1,1,1,,,1,1,1,,,,1,,,1,,,,1],[,1,,,,,,,1,,,,1,,,,,,1],[1,1,1,1,1,1,,,,1,,,,,,,,,1,1,1,1],[1],[,1,1,,,1,1,,,,,1,,1,,,,,,,,1,,,,1],[1,,1,,,1,,1,,,,,1,1,1,1,,,,1,,,,1],[,,1,,,,,,,1,,,,,,,1,,,,,,,1],[1,,,,,,,,,,,,,,1,,,,1],[,,,1,,1,,,,,1,,,,1,1,,,,1],[1,,,,,1,,,,1,,1,1,,,1,1,,1,1,1,,1,1,1,,1],[,1,1,,,,,1,,1,,1,1,1,,1,1,,,1,,1,1,1],[,1,,,,1,,,,1,,,1,,1,1,,,1,1,,,,,,1],[1,,1,1,,1,,1,1,,1,,1,1,1,1,1,,,1,1,,,,,,1],[1,,,,,,,,,,,,,,,,,,1,,,1,,1],[,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,,1,,1],[,1,,,,1,,,1,1,,1,,,1,1,,,1,,,1,,,1,1],[1,1,,1,1,1,,1,1,1,,1,,1,1,1,,,1,,1,1],[1,,1,1,1,1,,,,1,,1,1,1,,1,,,1,1,1,,1,1,1,1,1],[1,,,,,,,,,,,,,1],[,,1,,,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,,,1,,1,,1,,,,1],[,,,1,,,,,,,,,1],[,1,,,,,,,,,,,,,,1,,,,,,,,,1],[,,,,,,,,1,1,,,,,,,,,1,,,,,,,,1]],[,[1,1,1,1,1,\
1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,,,1,1,1],[,,,,,1,,,,1,1,1,,,1,1,,,1,,1,1,,1],[,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,1,,,,,,,,,,,,,1],[,,1,,,1,,1,1,1,,1,1,,1,,,,1,,1,1],,[,,1,,,1,,,,,,1,,,,1],[,,,,,,,,,1,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,,1,1,,1,,1,,,1,1,1,,,1],[,,,,,1,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,1,,1,1,,1,,,1],[,,,,,1,,,,,,,,,,,,,,1],[,1,1,1,1,,,,,1,,,1,,1,,,,1,1,,,,1,1],[,1,,,1,,,1,,1,1,,1,,,,,,,1],[,,1,,1,,,1,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,,,,,,,,,,1,,1,1],[,,,,,,,,,,,,1],,[,1,1,1,1,,,,1,1,,1,1,1,1,1,1,,1,1,1,1,,1,,1],[1,,,,1,,,,,,,,,,1],[1,,,,,,,,,1],,[,1,,,,1,,,,,,,,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,\
1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,,1,,,,1,1,,,1,1,,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,1],[1,1,1,,,,,1,1,1,,1,1,1,1,,,1,1,,1,1,,,,,1],[,1,,,,,,,1,1,,,1,1,1,,1,,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,,,1,,,,1,,,1,,,,1,,,,,,,1,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1],[1,1,1,,1,,,1,1,1,1,,1,1,1,1,,,,1,,1,,1,,,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,,1,1,,,,,,,,,1],,[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,,1,,1,,,,1],[,1,,,1,1,,1,1,1,,,1,1,1,1,1,,1,1,1,,1,,,1],[1,,,1,,,,1,1,1,,,,,1,1,,,,1,,1],[1,1,,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,,1,,1,,,,,,,,1,,1],[,1,,,,1,,1,1,,,,1,1,,1,,,,1,1,1,,1],,[,1,,,\
,,,1,,,,,,,1],[,,,,,,,,1,,,,1,,1,,,,,,,,,,,,1]],[,[,1,1,,1,1,1,1,,1,1,1,,1,1,,1,1,,1,1,1,1,1,1,,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,,,1,,,,,,,,1,,,,,,1,,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1\
,1,1,1,1,1,1,1,,1],[1,1,,1,,1,,1,,1,1,1,1,1,1,1,,1,1,,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1],[,1,1,,,,,1,1,1,,,1,,1,1,,,,1,,1,,,1,1],[,,,,,,,1,,,,1,1,1,1,1,,1,,,,,,,,1],[1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,,1,,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,1,1,,1,,1,1,1,,1,,1,1,,1,1,,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,,1,,,,,1,,1],[,1,1,1,,1,,1,,1,,,,1,,1,,,1,,,,,,1,1],[,1,,,1,1,,1,,1,,1,1,1,1,1,,1,1,,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,,1,,1,,1,,,,,,1,,1,,,,1,1]],[,[,1,,1,,,,,,,,,,,,,,,1,,,,1],[,,,,,,,,,1,,1,1,1,,1,,,1,,1,1],[1,1,,,,,,,1,,,,,,,1,,,,,,1],[,1,,,,,,,,,,1,,,,,,,,,1,1],,[,,,,,,,,,,,,,,,1,,,,1,,1],[,,1,1,,1,,1,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,,,,,,,,1],[1,,1,1,,,,1,,,,,,,,,1,,,1,,,1,1],[,1,1,,1,1,,1,1,1,1,1,1,1,1,1,,,1,1,,1,1\
,,1],[,1,,,1,1,,,,,,1,,1,,1,,,1,,1,1],[1,1,1,1,,1,,1,,1,,1,1,,1,1,1,1,1,,1,1,1,1,1],[,1,1,,,1,,1,,1,1,1,,,1,1,1,,1,1,1,1,,1,1],[,,,,1,,,1,,,,,,,1,,,,1,1],[,1,,,,,,,,,,1,,1,,1,,,,,1,,,,,1],,[1,1,,1,,1,,1,1,,,,,,1,1,,,1,1,1,1,1,1,1,1,1],[1,1,,1,,,,,,1,,,,,,1,1,,,,1,1,,,1],[,1,1,,1,1,,,,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,,,1,,,,1,,,,1,1],[,,,,1],[,,,,,,,,,1,,,1],,[,,1,,1,,,,,,,,,1,,,,,,,,,,,,1],[,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,,,1],[,1,,1,,,,,,1,,,,,1,1,,,,,1,1],[,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,,,1,,1,1,1],[,1,,,,1,,,,,,,1],[,1,,,1,,,1,,1,,1,1,,1,,,,,1,,1,,,,1,1],[,1,,,1,,,1,1,1,,1,1,1,1,1,,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,1,1,,,,1,1,,,,,,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1\
,1,1,1,1,1,1,1,1],[,,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,,1,1,,1,1,1,1,1],[,1,,,,1,,,,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,1,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,,1,1,1,,1,1,1,,,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,,,,,,,1,1,,,,,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,1,,1,1,1,1],,[,1,1,,,,,1,,1,,,,1,1,1,,,1,,,,,1],[,,,,,,,,,,,,,1],[,,,,,1,,,,,,,,1,1,,,,,1,,1,,,1,1],[,,,,,,,,,,,,,,1]],[,[,1],,,,,,,,,,,,,,,,,,,,[1,1,1,1,1,,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,1,1,1,1],[,1,,1,,1,,,1,1,1,,1,1,1,1,1,,,1,,,,1,,1,1],[,1,,1,,1,,,1,,,,,1,,,,,,1,1],[,1,,1,,,,,1,,,,1,,1,1,1,1,1,1,1,1,,1],[,1,,,,,,,,,,,,,,,1]],[,[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,,,,,,,,,1,1,,,,1],[,,,,,,1],[,,1],[,1,1,,,1,,1,,1,1,,1,1,1,,,,1,1,1,,,,,1],,[,1,,,,1,,,,,,1,,,1,,,,1,1,,1],[,,,,,,,1,,,,,,,,,1],[,1,,,,1,1,,,,,,1,1,1,,,,1,,1,1],[,,,,,,,1,,1,,,,,,,,,,1],[,1,1,,,,,,1,1,,,,1,,,,,,,1,,,1],,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,,1,,,1,,,,,\
1,,1,,1,,1,,,,,1],[1,1,1,1,1,1,1,1,,,,,1,1,,1,1,,1,,,1,,1],[,,,,,,,,,,,,,,1,,,,,,1],,[,,,,,,,,,1,,,,,,1,,,,,1],[,,1,,,,,,,1,,,1,1],[,,,1,,,,,1,,,,,1,,,,,,1,,,,1],[1,,1,1,,1,1,1,1,1,,1,,,,1,1,1,,,1,1,,,,1,1],,[1,1,,,,,,,,,,1,,1,,1,,,1],[,,,,1,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,1],[,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,,1,,,1,,,,,,,,1,,,,,,1,,,,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,1,,,,1,1,1,1,1,1,,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1\
,1,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,1,,1,1,,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,,1,,1,,1,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,,,,,,1,,1,,,,,1,1,,,,,1],[1,,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,,1,,,,1,1,1,1,1,,,1,1,,1,,1],[,1,1,1,1,,,,,1,,1,1,1,1,1,,,1,1,,,,1,1,1],[,1,1,1,1,1,,1,,,,,1,,1,,1,,,1,,,1,1,,1]],[,[1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,,,,,1,,,,,1,1,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1\
,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,,,,1,,1,1,,1,1,1,1,1,,,1,,1,,1],[1,1,1,,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,,1,,,,,,,,,,1,1,1,1,1,1,1,,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,1,1,,,,,,1,1,1,1,1,,,,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,,1,1,1],[,1,1,1,,1,,1,1,1,1,,,1,1,1,,1,1,1,1,1,,,1,1],[1,1,,,,1,,,1,1,1,,1,,1,,1,,1,1,1,1,1,,1,,1],[,1,,,,,,,1,,1,,1,1,1,1,,,,,,,,,1]],[,[,,,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,1,,,1,,,,,,1,,,1,,,,1],,[,1,,,,1,,1,,1,1,,1,1,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],[1,1,1,,,1,,,,,,\
,,,1,1,,,,,,,,,,1],[,1,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1,,,1],[,,,,,,,,,1],[1,1,,,,,,1,1,1,,1,1,,,,1,1,,1,,1,1,1,,1],[,1,1,1,,1,1,,,1,,1,1,1,1,,,,,,,1,,1],[,1,1,1,1,,,1,,1,,,,1,1,1,1,,1,1,,1],[,1,,,1,1,,1,,,,1,,1,1,,1,,1,,,1,,,1,,1],[,,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,,,,,1],,[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1],[,1,,,,,,,1,1,,1,,,,,1,,,1,,1],[,1,,,,1,,,1,,,,,,,,1,,1,,,1],[,,,,,,,,,,,,,1,1,,,,1,,,1],[,,,,,1,,,1,,,,1],[,1],,[,1],[1,,,,,,,,,,,,,,1,,,,,1]],[,[,1,,,,1,1,1,1,1,1,,1,1,1,1,1,,1,1,,1,1,,,1],[,,1,,,,,,,,,1],,,[1,,,1,1,,,,,,,,1,1,,1,1,,1],,[,,,,,,,,,,,,,,,,,,1,,1],,[1,,,1,1,,1,1,,,,,1,,1,,,,,1,1,,1],,[,1,,,,,,,,1,1,1,1,1,,1,1,,,,1,1],[,,,,,,,,,,,,,,,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,,1,1,1,1,1,1],[,,,,,,,,,,,1,,1,,,1],[1,,,,,,,,,,,,,,,,,,1,,1],,,[,1,,,,,,,,,,,,,,1,,,,1,1],[,,,,,,,,,1,,,1,,,,,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,1,1,,,,,,1],,[,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,1,1,,1,1,1,1,1,1,,,1,1,1,1,1,,1,1]\
,[,1,,,,,,,,1],[,,,,1,,,1,,,1,1,,,,,,,,,,1,,,,1],[,1,,1,1,,,1,1,1,,,,1,1,1,1,,1,1,1,1,,1],[,,,,,,,1],[,1,1,,,,,1,,1,,,,,,1,,,,,,1,,1,,1],[,1,,,,,,1,,,,1,,,,,,,,,,1],[,,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1,1,1,1,,1],[,1,,,,,,,,1],[,1,1,,1,,,,,,,,1,,,,,,1,,,1,,1,,1],[,1,,1,,1,,1,1,1,,1,1,1,,1,,,1,1,,1,1,1,1,1],[,1,1,1,1,1,,,1,1,,,,1,1,1,,,,1,1,,,1,1],[,,1,1,1,1,,1,,1,,1,,1,1,1,1,,,,,1,,1,,1],[1,1,1,1,1,1,1,1,,1,,1,,1,1,1,,,1,1,,,,1,,1],[,,,1],,[,1,1,,1,,,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1],[,1,,,,,,1,,1,,1,,,,,,,1,1,,1,1],[,,,,,,1,,1,1,,1,,1,,,,,,,,,,1],[,1,1,,1,,,,1,,,,1,1,1,,,,1,,1,1,1,,1,1],,[,1,1,,,,,,,,,,,,,1,,,1,,,,,1],[,1,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,1,,,,1,,,,,1,,,,,,,1]],[,[,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[,1,1,1,1,1,,1,,1,1,,,1,1,1,1,,1,,,,,1,1,1],[,,1,1,,1,,1,1,,,,1,1,1,1,,,1,,1,1,1,1,,1],[,1,,1,,,,,,,,1,,1,,1,,,,,,,,,,1],[,,1,,1,,,1,,,,,1,1,,,1,,1,1,1,1],[,1],[,1,1,,1,,1,1,,1,,,1,1,1,,,,1,,,1,,1],[1,1,,1,1,1,,,,,,,,,,,,,1,,1,1,1],[,1,1,,,,,,,1,,,1,,1,,1,\
,1,1,,,1,,,1],[,,1,,,,,,,,,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,,1,,,,,1,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,,1,,1,1,1,,,1,1,1,1,,,,1,1],[,,,1,1,,,1,,1,,1,,1,1,1,1,,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,,1,,1,,,,1,1,,,1,1,,1,1,,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1,,1,1,,,1],[,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,,1,,,1,,,1,,1,1,1,1,1,,1,,1,1],[,,,,,1,,,,1,,,,,1,1,,,,1],[,1,,1,1,1,,1,,,1,1,1,,,1,,,1,,1,,,1],[,,1,,,,,,,,,1,,1,,,,,1,,1],[,1,1,,,,,,,,1,1,1,,,,,,,,1,,,,,1],[,,,,,,,,1,,,,,1,,,1]],[,[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,,1,1,1,1,1,1,1,1,,,,,,,,,1,1],[,,,,,,,,1,,,,1,,1,,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,1,,1,,1,,,,1,1,,1,,1,,,,1,1,1,1,1,,,1],,[,1,,,,,,,,1,,,1,1,,,1,,1,1,,1,,1],[,1,,,1,,,,,,,,1,,,,,,,1],[1,1,,,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1],,[,1,,,,,,1,,1,,1,1,1\
,1,1,,,1,,1,1,,,,1],[,1,1,,,1,,1,,1,,,1,1,1,1,,,1,,,1,,,,1],[,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1],[,1,,,1,1,,1,1,,,1,1,,1,1,,1,,1,,1],[1,,1,,,,,1,,1,,1,1,1,1,,,,,1,1,,,,1,1],[,1,1,,,,,1,1,,,1,,1,1,1,1,,,,,,,,,,1],,[,1,1,,,1,,,,1,,1,1,1,1,1,,,,1,,,,1,,1],[,,,1,1,,,1,,,,,1,,1,1,1,,1,1,,,,,,1],[,1,,,,,,,,,,,1,,,,1,,,,,,,1,,1],[,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,1,,,,,1,,1,,,1,1,,1,1,,1],[,1,,,,,,1,,,,,1,1,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1,,,1,,,,,1],[,,,,,,,1,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,,1,,,,,,,1,,,,,,,,1,,,1],[,1,,,,,,,1],[,,,,,,,,,,1],[,1,,,,,,1,1,,,,,,1],,[,1,1,,,,,,1,,,,,1,1,,,,1],[1,,1,,1,,,,,1,,,,,1,,,,,,,,,1,1],[,1,1,,,,,,,,,1,1,1,1,,,,1,,,,,1,,,1],,[,1,1,,1,,,1,1,,,1,,,1,1,1,,1,,1,1,1,,,,1],[,,,,,1,,,,,1,,,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,,,1,,,,,1,,,,,1,,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,\
1,1,1,1,1],[,,,,,1],[,1,,,,,,1,,,,,,,1,1,1,,,1],[,1,,,,,,,,,,1,1,1,,,,,1,,,1],[,,,,,1,,1,,,,,1,1,1,,1,1,,1,1,1,,,1,1],[1,1,,,,,,,1,,,,,1,1,,,,,,,,,,,1],,[,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,,1,,,,,1,,,1,,,,1,,1],[,1,,,,,,,,,1]]];function vD(e){e=Array.isArray(e)?e:bD;var t=[];return e.forEach((function(e,n){var r=String.fromCharCode(n+96).replace("\`","");Array.isArray(e)?t=t.concat(vD(e).map((function(e){return r+e}))):t.push(r)})),t}var yD=function(e){for(var t=bD;e.length<3;)e+="\`";for(var n=0;n<=e.length-1;n++)if(!(t=t[e.charCodeAt(n)-96]))return!1;return!0};N(FD,ua),pp=G(FD,[{key:"props",get:function(){return this._props}},{key:"attr",value:function(e){return null!=(e=this._attrs[e])?e:null}},{key:"hasAttr",value:function(e){return void 0!==this._attrs[e]}},{key:"attrNames",get:function(){return Object.keys(this._attrs)}}]);function FD(e){var t,n,r;return H(this,FD),(t=A(this,FD))._props=function(e){var t=null!=(t=e.nodeName)?t:CD[e.nodeType],n=null!=(n=null!=(n=e.nodeType)?n:ED[e.no\
deName])?n:1,r=(ya("number"==typeof n,"nodeType has to be a number, got '".concat(n,"'")),ya("string"==typeof t,"nodeName has to be a string, got '".concat(t,"'")),t=t.toLowerCase(),null);return"input"===t&&(r=(e.type||e.attributes&&e.attributes.type||"").toLowerCase(),gD().includes(r)||(r="text")),e=q({},e,{nodeType:n,nodeName:t}),r&&(e.type=r),delete e.attributes,Object.freeze(e)}(e),t._attrs=(e=e.attributes,n=void 0===e?{}:e,r={htmlFor:"for",className:"class"},Object.keys(n).reduce((function(e,t){var o=n[t];return ya("object"!==a(o)||null===o,"expects attributes not to be an object, '".concat(t,"' was")),void 0!==o&&(e[r[t]||t]=null!==o?String(o):null),e}),{})),t}var wD,ED={"#cdata-section":2,"#text":3,"#comment":8,"#document":9,"#document-fragment":11},CD={},xD=(Object.keys(ED).forEach((function(e){CD[ED[e]]=e})),pp),AD=function(e,t){if(e=e||function(){},t=t||o.log,!o._audit)throw new Error("No audit configured");var n=o.utils.queue(),a=[],u=(Object.keys(o.plugins).forEach((functio\
n(e){n.defer((function(t){function n(e){a.push(e),t()}try{o.plugins[e].cleanup(t,n)}catch(e){n(e)}}))})),o.utils.getFlattenedTree(r.body));o.utils.querySelectorAll(u,"iframe, frame").forEach((function(e){n.defer((function(t,n){return o.utils.sendCommandToFrame(e.actualNode,{command:"cleanup-plugin"},t,n)}))})),n.then((function(n){0===a.length?e(n):t(a)})).catch(t)},kD={};function BD(e){return kD.hasOwnProperty(e)}function ND(e){return"string"==typeof e&&kD[e]?kD[e]:"function"==typeof e?e:wD}var TD={},RD=(se(TD,{getAllCells:function(){return RD},getCellPosition:function(){return as},getHeaders:function(){return _D},getScope:function(){return os},isColumnHeader:function(){return us},isDataCell:function(){return SD},isDataTable:function(){return MD},isHeader:function(){return PD},isRowHeader:function(){return is},toArray:function(){return rs},toGrid:function(){return rs},traverse:function(){return ID}}),function(e){for(var t,n,r=[],a=0,o=e.rows.length;a<o;a++)for(t=0,n=e.rows[a].cells.len\
gth;t<n;t++)r.push(e.rows[a].cells[t]);return r});function OD(e,t,n){for(var r,a="row"===e?"_rowHeaders":"_colHeaders",u="row"===e?is:us,i=(l=n[t.y][t.x]).colSpan-1,s=l.getAttribute("rowspan"),l=(s=0===parseInt(s)||0===l.rowspan?n.length:l.rowSpan,t.y+(s-1)),c=t.x+i,d="row"===e?t.y:0,p="row"===e?0:t.x,f=[],D=l;d<=D&&!r;D--)for(var m=c;p<=m;m--){var h=n[D]?n[D][m]:void 0;if(h){var g=o.utils.getNodeFromTree(h);if(g[a]){r=g[a];break}f.push(h)}}return r=(r||[]).concat(f.filter(u)),f.forEach((function(e){o.utils.getNodeFromTree(e)[a]=r})),r}var _D=function(e,t){if(e.getAttribute("headers")){var n=zi(e,"headers");if(n.filter((function(e){return e})).length)return n}return t=t||rs(bu(e,"table")),e=OD("row",n=as(e,t),t),n=OD("col",n,t),[].concat(e,n).reverse()},SD=function(e){var t;return!(!e.children.length&&!e.textContent.trim())&&(t=e.getAttribute("role"),Qi(t)?["cell","gridcell"].includes(t):"TD"===e.nodeName.toUpperCase())},MD=function(e){var n=(e.getAttribute("role")||"").toLowerCase();i\
f(("presentation"===n||"none"===n)&&!Pi(e))return!1;if("true"===e.getAttribute("contenteditable")||bu(e,'[contenteditable="true"]'))return!0;if("grid"===n||"treegrid"===n||"table"===n)return!0;if("landmark"===Ml(n))return!0;if("0"===e.getAttribute("datatable"))return!1;if(e.getAttribute("summary"))return!0;if(e.tHead||e.tFoot||e.caption)return!0;for(var r=0,a=e.children.length;r<a;r++)if("COLGROUP"===e.children[r].nodeName.toUpperCase())return!0;for(var o,u,i,s=0,l=e.rows.length,c=!1,d=0;d<l;d++)for(var p,f=0,D=(p=e.rows[d]).cells.length;f<D;f++){if("TH"===(o=p.cells[f]).nodeName.toUpperCase())return!0;if(c||o.offsetWidth===o.clientWidth&&o.offsetHeight===o.clientHeight||(c=!0),o.getAttribute("scope")||o.getAttribute("headers")||o.getAttribute("abbr"))return!0;if(["columnheader","rowheader"].includes((o.getAttribute("role")||"").toLowerCase()))return!0;if(1===o.children.length&&"ABBR"===o.children[0].nodeName.toUpperCase())return!0;s++}if(e.getElementsByTagName("table").length)return!1\
;if(l<2)return!1;if(1===(n=e.rows[Math.ceil(l/2)]).cells.length&&1===n.cells[0].colSpan)return!1;if(5<=n.cells.length)return!0;if(c)return!0;for(d=0;d<l;d++){if(p=e.rows[d],u&&u!==t.getComputedStyle(p).getPropertyValue("background-color"))return!0;if(u=t.getComputedStyle(p).getPropertyValue("background-color"),i&&i!==t.getComputedStyle(p).getPropertyValue("background-image"))return!0;i=t.getComputedStyle(p).getPropertyValue("background-image")}return 20<=l||!(zu(e).width>.95*Vu(t).width||s<10||e.querySelector("object, embed, iframe, applet"))},PD=function(e){return!(!us(e)&&!is(e))||!!e.getAttribute("id")&&(e=wa(e.getAttribute("id")),!!r.querySelector('[headers~="'.concat(e,'"]')))},ID=function(e,t,n,r){if(Array.isArray(t)&&(r=n,n=t,t={x:0,y:0}),"string"==typeof e)switch(e){case"left":e={x:-1,y:0};break;case"up":e={x:0,y:-1};break;case"right":e={x:1,y:0};break;case"down":e={x:0,y:1}}return function e(t,n,r,a){var o,u=r[n.y]?r[n.y][n.x]:void 0;return u?"function"==typeof a&&!0===(o=a(u,\
n,r))?[u]:((o=e(t,{x:n.x+t.x,y:n.y+t.y},r,a)).unshift(u),o):[]}(e,{x:t.x+e.x,y:t.y+e.y},n,r)};var jD={},LD=(se(jD,{allowedAttr:function(){return LD},arialabelText:function(){return Hi},arialabelledbyText:function(){return $i},getAccessibleRefs:function(){return zD},getElementUnallowedRoles:function(){return UD},getExplicitRole:function(){return es},getImplicitRole:function(){return ks},getOwnedVirtual:function(){return Ss},getRole:function(){return Ts},getRoleType:function(){return Ml},getRolesByType:function(){return WD},getRolesWithNameFromContents:function(){return ZD},implicitNodes:function(){return QD},implicitRole:function(){return ks},isAccessibleRef:function(){return em},isAriaRoleAllowedOnElement:function(){return VD},isComboboxPopup:function(){return tm},isUnsupportedRole:function(){return Ji},isValidRole:function(){return Qi},label:function(){return rm},labelVirtual:function(){return Dl},lookupTable:function(){return JD},namedFromContents:function(){return _s},requiredAttr:f\
unction(){return am},requiredContext:function(){return om},requiredOwned:function(){return um},validateAttr:function(){return sm},validateAttrValue:function(){return im}}),function(e){e=Zi.ariaRoles[e];var t=j(ns());return e&&(e.allowedAttrs&&t.push.apply(t,j(e.allowedAttrs)),e.requiredAttrs)&&t.push.apply(t,j(e.requiredAttrs)),t}),qD=/^idrefs?$/,zD=function(e){e=e.actualNode||e;var t=(t=mu(e)).documentElement||t,n=Xa.get("idRefsByRoot",(function(){return new Map})),r=n.get(t);return r||(r=new Map,n.set(t,r),function e(t,n,r){if(t.hasAttribute){var a;"LABEL"===t.nodeName.toUpperCase()&&t.hasAttribute("for")&&(a=t.getAttribute("for"),n.has(a)?n.get(a).push(t):n.set(a,[t]));for(var o=0;o<r.length;++o){var u=r[o];if(u=ls(t.getAttribute(u)||"")){var i,s=Y(Wp(u));try{for(s.s();!(i=s.n()).done;){var l=i.value;n.has(l)?n.get(l).push(t):n.set(l,[t])}}catch(e){s.e(e)}finally{s.f()}}}}for(var c=0;c<t.childNodes.length;c++)1===t.childNodes[c].nodeType&&e(t.childNodes[c],n,r)}(t,r,Object.keys(Zi.a\
riaAttrs).filter((function(e){return e=Zi.ariaAttrs[e].type,qD.test(e)})))),null!=(n=r.get(e.id))?n:[]},VD=function(e,t){e=e instanceof ua?e:Za(e);var n=ks(e);e=As(e);return Array.isArray(e.allowedRoles)?e.allowedRoles.includes(t):t!==n&&!!e.allowedRoles},$D=["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"],HD={header:"banner",footer:"contentinfo"},UD=function(e){var t,n,r,a=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],o=zf(e).vNode;return Pf(o)?(r=o.props.nodeName,t=ks(o)||HD[r],r=[],((n=o)?(n.hasAttr("role")&&(n=Wp(n.attr("role").toLowerCase()),r=r.concat(n)),r.filter((function(e){return Qi(e)}))):r).filter((function(e){var n=o,r=t;return!(a&&e===r||(!$D.includes(e)||Ml(e)===r)&&VD(n,e))}))):[]},GD=function(e){return Object.keys(Zi.ariaRoles).filter((function(t){return Zi.ariaRoles[t].type===e}))},WD=function(e){return GD(e)},YD=function(){return Xa.get("ariaRolesNameFromContent",(function(){return Object.keys(Zi.a\
riaRoles).filter((function(e){return Zi.ariaRoles[e].nameFromContent}))}))};function KD(e){return null===e}function XD(e){return null!==e}var ZD=function(){return YD()},JD=((Qt={attributes:{"aria-activedescendant":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-atomic":{type:"boolean",values:["true","false"],unsupported:!1},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"],unsupported:!1},"aria-busy":{type:"boolean",values:["true","false"],unsupported:!1},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-colcount":{type:"int",unsupported:!1},"aria-colindex":{type:"int",unsupported:!1},"aria-colspan":{type:"int",unsupported:!1},"aria-controls":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],unsupported:!1},"aria-describedby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-describedat":{unsupported:!0,unstand\
ardized:!0},"aria-details":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-disabled":{type:"boolean",values:["true","false"],unsupported:!1},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"],unsupported:!1},"aria-errormessage":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-flowto":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],unsupported:!1},"aria-hidden":{type:"boolean",values:["true","false"],unsupported:!1},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["true","false","spelling","grammar"],unsupported:!1},"aria-keyshortcuts":{type:"string",allowEmpty:!0,unsupported:!1},"aria-label":{type:"string",allowEmpty:!0,unsupported:!1},"aria-labelledby":{type:"idrefs\
",allowEmpty:!0,unsupported:!1},"aria-level":{type:"int",unsupported:!1},"aria-live":{type:"nmtoken",values:["off","polite","assertive"],unsupported:!1},"aria-modal":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiline":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiselectable":{type:"boolean",values:["true","false"],unsupported:!1},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"],unsupported:!1},"aria-owns":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-placeholder":{type:"string",allowEmpty:!0,unsupported:!1},"aria-posinset":{type:"int",unsupported:!1},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-readonly":{type:"boolean",values:["true","false"],unsupported:!1},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"],unsupported:!1},"aria-required":{type:"boolean",values:["true","false"],unsupported:!1},"aria-roledescription":{type:"string",allowEmpty\
:!0,unsupported:!1},"aria-rowcount":{type:"int",unsupported:!1},"aria-rowindex":{type:"int",unsupported:!1},"aria-rowspan":{type:"int",unsupported:!1},"aria-selected":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-setsize":{type:"int",unsupported:!1},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"],unsupported:!1},"aria-valuemax":{type:"decimal",unsupported:!1},"aria-valuemin":{type:"decimal",unsupported:!1},"aria-valuenow":{type:"decimal",unsupported:!1},"aria-valuetext":{type:"string",unsupported:!1}},globalAttributes:["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"]}).role={alert:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameF\
rom:["author"],context:null,unsupported:!1,allowedElements:["section"]},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["dialog","section"]},application:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage","aria-activedescendant"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","audio","embed","iframe","object","section","svg","video"]},article:{type:"structure",attributes:{allowed:["aria-expanded","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["article"],unsupported:!1},banner:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["header"],unsupported:!1,allowedElements:["section"]},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed","aria-errorm\
essage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["button",'input[type="button"]','input[type="image"]','input[type="reset"]','input[type="submit"]',"summary"],unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:XD}}]},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},checkbox:{type:"widget",attributes:{allowed:["aria-checked","aria-required","aria-readonly","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="checkbox"]'],unsupported:!1,allowedElements:["button"]},columnheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],impl\
icit:["th"],unsupported:!1},combobox:{type:"composite",attributes:{allowed:["aria-autocomplete","aria-required","aria-activedescendant","aria-orientation","aria-errormessage"],required:["aria-expanded"]},owned:{all:["listbox","tree","grid","dialog","textbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:"input",properties:{type:["text","search","tel","url","email"]}}]},command:{nameFrom:["author"],type:"abstract",unsupported:!1},complementary:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"],unsupported:!1,allowedElements:["section"]},composite:{nameFrom:["author"],type:"abstract",unsupported:!1},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["footer"],unsupported:!1,allowedElements:["section"]},definition:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormes\
sage"]},owned:null,nameFrom:["author"],context:null,implicit:["dd","dfn"],unsupported:!1},dialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"],unsupported:!1,allowedElements:["section"]},directory:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["ol","ul"]},document:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["body"],unsupported:!1,allowedElements:["article","embed","iframe","object","section","svg"]},"doc-abstract":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-acknowledgments":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,n\
ameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-afterword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-appendix":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-backlink":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:XD}}]},"doc-biblioentry":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:["doc-bibliography"],unsupported:!1,allowedElements:["li"]},"doc-bibliography":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-bibl\
ioentry"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-biblioref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:XD}}]},"doc-chapter":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-colophon":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-conclusion":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-cover":{type:"img",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-credit":{type:\
"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-credits":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-dedication":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-endnote":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,namefrom:["author"],context:["doc-endnotes"],unsupported:!1,allowedElements:["li"]},"doc-endnotes":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-endnote"]},namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-epigraph":{type:"section",attributes:{allowed:["aria-ex\
panded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-epilogue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-errata":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-example":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-footnote":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","footer","header"]},"doc-foreword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section\
"]},"doc-glossary":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:["term","definition"],namefrom:["author"],context:null,unsupported:!1,allowedElements:["dl"]},"doc-glossref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:XD}}]},"doc-index":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-introduction":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-noteref":{type:"link",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:XD}}]},"doc-notice":{type:"note",attribute\
s:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pagebreak":{type:"separator",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["hr"]},"doc-pagelist":{type:"navigation",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-part":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-preface":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-prologue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pullquote":{type:"none",attributes:{allowed:["aria-expanded"]}\
,owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-qna":{type:"section",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-subtitle":{type:"sectionhead",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["h1","h2","h3","h4","h5","h6"]}},"doc-tip":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},"doc-toc":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},feed:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["article"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","aside","section"]},figure:{type:"structure",a\
ttributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["figure"],unsupported:!1},form:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["form"],unsupported:!1},grid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-colcount","aria-level","aria-multiselectable","aria-readonly","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},gridcell:{type:"widget",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-selected","aria-readonly","aria-required","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:nu\
ll,nameFrom:["author"],context:null,implicit:["details","optgroup"],unsupported:!1,allowedElements:["dl","figcaption","fieldset","figure","footer","header","ol","ul"]},heading:{type:"structure",attributes:{required:["aria-level"],allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"],unsupported:!1},img:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["img"],unsupported:!1,allowedElements:["embed","iframe","object","svg"]},input:{nameFrom:["author"],type:"abstract",unsupported:!1},landmark:{nameFrom:["author"],type:"abstract",unsupported:!1},link:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]","area[href]"],unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["image","button"]}}]},list:{type:"str\
ucture",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul","dl"],unsupported:!1},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-readonly","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"],unsupported:!1,allowedElements:["ol","ul"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li","dt"],unsupported:!1},log:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},main:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["ma\
in"],unsupported:!1,allowedElements:["article","section"]},marquee:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},math:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["math"],unsupported:!1},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,implicit:['menu[type="context"]'],unsupported:!1,allowedElements:["ol","ul"]},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},menuitem:{type:"widget",attributes:{allowed:["aria\
-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="command"]'],unsupported:!1,allowedElements:["button","li",{nodeName:"iput",properties:{type:["image","button"]}},{nodeName:"a",attributes:{href:XD}}]},menuitemcheckbox:{type:"widget",attributes:{allowed:["aria-checked","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="checkbox"]'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:XD}}]},menuitemradio:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="radio"]'],unsupported:!1,allowedElements:[{nodeName:["button","li"]}\
,{nodeName:"input",properties:{type:["image","button","radio"]}},{nodeName:"a",attributes:{href:XD}}]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["nav"],unsupported:!1,allowedElements:["section"]},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:XD}}]},note:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["listbox"],implicit:["option"],uns\
upported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","button"]}},{nodeName:"a",attributes:{href:XD}}]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:XD}}]},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["progress"],unsupported:!1},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-required","aria-errormessage","aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="radio"]'],unsupported:!1,allowedElements:[{nodeName:["button"\
,"li"]},{nodeName:"input",properties:{type:["image","button"]}}]},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded","aria-readonly","aria-errormessage","aria-orientation"]},owned:{all:["radio"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["ol","ul","fieldset"]}},range:{nameFrom:["author"],type:"abstract",unsupported:!1},region:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["section[aria-label]","section[aria-labelledby]","section[title]"],unsupported:!1,allowedElements:{nodeName:["article","aside"]}},roletype:{type:"abstract",unsupported:!1},row:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-colindex","aria-expanded","aria-level","aria-selected","aria-rowindex","aria-errormessage"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid"\
,"treegrid","table"],implicit:["tr"],unsupported:!1},rowgroup:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table","treegrid"],implicit:["tbody","thead","tfoot"],unsupported:!1},rowheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-valuenow"],allowed:["aria-valuetext","aria-orientation","aria-errormessage","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},search:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:{no\
deName:["aside","form","section"]}},searchbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="search"]'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:"text"}}},section:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},sectionhead:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},select:{nameFrom:["author"],type:"abstract",unsupported:!1},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin","aria-valuetext","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["hr"],unsupported:!1,allowedElements:["li"]},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],requ\
ired:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="range"]'],unsupported:!1},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="number"]'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:["text","tel"]}}},status:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["output"],unsupported:!1,allowedElements:["section"]},structure:{type:"abstract",unsupported:!1},switch:{type:"widget",attributes:{allowed:["aria-errormessage"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:XD}}]},tab:{type:"widget",a\
ttributes:{allowed:["aria-selected","aria-expanded","aria-setsize","aria-posinset","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["tablist"],unsupported:!1,allowedElements:[{nodeName:["button","h1","h2","h3","h4","h5","h6","li"]},{nodeName:"input",properties:{type:"button"}},{nodeName:"a",attributes:{href:XD}}]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author","contents"],context:null,implicit:["table"],unsupported:!1},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-errormessage"]},owned:{all:["tab"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},term:{type:"structu\
re",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["dt"],unsupported:!1},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="text"]','input[type="email"]','input[type="password"]','input[type="tel"]','input[type="url"]',"input:not([type])","textarea"],unsupported:!1},timer:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['menu[type="toolbar"]'],unsupported:!1,allowedElements:["ol","ul"]},tooltip:{type:"structure",attributes:{allowed:["aria-expanded","aria-err\
ormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required","aria-rowcount","aria-orientation","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,unsupported:!1},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["group","tree"],unsupported:!1,allowedElements:["li",{nodeName:"a",attributes:{href:XD}}]},widget:{type:"abstract",unsupported:!1},w\
indow:{nameFrom:["author"],type:"abstract",unsupported:!1}},Qt.implicitHtmlRole=ds,Qt.elementsAllowedNoRole=[{nodeName:["base","body","caption","col","colgroup","datalist","dd","details","dt","head","html","keygen","label","legend","main","map","math","meta","meter","noscript","optgroup","param","picture","progress","script","source","style","template","textarea","title","track"]},{nodeName:"area",attributes:{href:XD}},{nodeName:"input",properties:{type:["color","data","datatime","file","hidden","month","number","password","range","reset","submit","time","week"]}},{nodeName:"link",attributes:{href:XD}},{nodeName:"menu",attributes:{type:"context"}},{nodeName:"menuitem",attributes:{type:["command","checkbox","radio"]}},{nodeName:"select",condition:function(e){return e instanceof o.AbstractVirtualNode||(e=o.utils.getNodeFromTree(e)),1<Number(e.attr("size"))},properties:{multiple:!0}},{nodeName:["clippath","cursor","defs","desc","feblend","fecolormatrix","fecomponenttransfer","fecomposite"\
,"feconvolvematrix","fediffuselighting","fedisplacementmap","fedistantlight","fedropshadow","feflood","fefunca","fefuncb","fefuncg","fefuncr","fegaussianblur","feimage","femerge","femergenode","femorphology","feoffset","fepointlight","fespecularlighting","fespotlight","fetile","feturbulence","filter","hatch","hatchpath","lineargradient","marker","mask","meshgradient","meshpatch","meshrow","metadata","mpath","pattern","radialgradient","solidcolor","stop","switch","view"]}],Qt.elementsAllowedAnyRole=[{nodeName:"a",attributes:{href:KD}},{nodeName:"img",attributes:{alt:KD}},{nodeName:["abbr","address","canvas","div","p","pre","blockquote","ins","del","output","span","table","tbody","thead","tfoot","td","em","strong","small","s","cite","q","dfn","abbr","time","code","var","samp","kbd","sub","sup","i","b","u","mark","ruby","rt","rp","bdi","bdo","br","wbr","th","tr"]}],Qt.evaluateRoleForElement={A:function(e){var t=e.node;e=e.out;return"http://www.w3.org/2000/svg"===t.namespaceURI||!t.href.le\
ngth||e},AREA:function(e){return!e.node.href},BUTTON:function(e){var t=e.node,n=e.role;e=e.out;return"menu"===t.getAttribute("type")?"menuitem"===n:e},IMG:function(e){var t=e.node,n=e.role,r=e.out;switch(t.alt){case null:return r;case"":return"presentation"===n||"none"===n;default:return"presentation"!==n&&"none"!==n}},INPUT:function(e){var t=e.node,n=e.role,r=e.out;switch(t.type){case"button":case"image":return r;case"checkbox":return!("button"!==n||!t.hasAttribute("aria-pressed"))||r;case"radio":return"menuitemradio"===n;case"text":return"combobox"===n||"searchbox"===n||"spinbutton"===n;case"tel":return"combobox"===n||"spinbutton"===n;case"url":case"search":case"email":return"combobox"===n;default:return!1}},LI:function(e){var t=e.node;e=e.out;return!o.utils.matchesSelector(t,"ol li, ul li")||e},MENU:function(e){return"context"!==e.node.getAttribute("type")},OPTION:function(e){return e=e.node,!o.utils.matchesSelector(e,"select > option, datalist > option, optgroup > option")},SELECT:\
function(e){var t=e.node;e=e.role;return!t.multiple&&t.size<=1&&"menu"===e},SVG:function(e){var t=e.node;e=e.out;return!(!t.parentNode||"http://www.w3.org/2000/svg"!==t.parentNode.namespaceURI)||e}},Qt.rolesOfType={widget:["button","checkbox","dialog","gridcell","link","log","marquee","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","searchbox","slider","spinbutton","status","switch","tab","tabpanel","textbox","timer","tooltip","tree","treeitem"]},Qt),QD=function(e){var t=null;return(e=JD.role[e])&&e.implicit?no(e.implicit):t},em=function(e){return!!zD(e).length};function tm(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).popupRoles,n=Ts(e);if(!(t=null!=t?t:Ui["aria-haspopup"].values).includes(n))return!1;if(t=function(e){for(;e=e.parent;)if(null!==Ts(e,{noPresentational:!0}))return e;return null}(e),nm(t))return!0;if(!(n=e.props.id))return!1;if(e.actualNode)return t=Du(e.actualNode).querySelectorAll('[aria-owns~="'.concat(n,\
'"][role~="combobox"]:not(select),\\n     [aria-controls~="').concat(n,'"][role~="combobox"]:not(select)')),Array.from(t).some(nm);throw new Error("Unable to determine combobox popup without an actualNode")}var nm=function(e){return e&&"combobox"===Ts(e)},rm=function(e){return e=Za(e),Dl(e)},am=function(e){return(e=Zi.ariaRoles[e])&&Array.isArray(e.requiredAttrs)?j(e.requiredAttrs):[]},om=function(e){return(e=Zi.ariaRoles[e])&&Array.isArray(e.requiredContext)?j(e.requiredContext):null},um=function(e){return(e=Zi.ariaRoles[e])&&Array.isArray(e.requiredOwned)?j(e.requiredOwned):null},im=function(e,t){var n,r=(e=e instanceof ua?e:Za(e)).attr(t),a=Zi.ariaAttrs[t];if(!a)return!0;if(a.allowEmpty&&(!r||""===r.trim()))return!0;switch(a.type){case"boolean":return["true","false"].includes(r.toLowerCase());case"nmtoken":return"string"==typeof r&&a.values.includes(r.toLowerCase());case"nmtokens":return(n=Wp(r)).reduce((function(e,t){return e&&a.values.includes(t)}),0!==n.length);case"idref":try{var\
 o=mu(e.actualNode);return!(!r||!o.getElementById(r))}catch(e){throw new TypeError("Cannot resolve id references for partial DOM")}case"idrefs":return zi(e,t).some((function(e){return!!e}));case"string":return""!==r.trim();case"decimal":return!(!(n=r.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!n[1]&&!n[2]);case"int":return o=void 0!==a.minValue?a.minValue:-1/0,/^[-+]?[0-9]+$/.test(r)&&parseInt(r)>=o}},sm=function(e){return!!Zi.ariaAttrs[e]};function lm(e){return"caption"===e.props.nodeName}var cm={};se(cm,{getAriaRolesByType:function(){return GD},getAriaRolesSupportingNameFromContent:function(){return YD},getElementSpec:function(){return As},getElementsByContentType:function(){return ts},getGlobalAriaAttrs:function(){return ns},implicitHtmlRoles:function(){return ds}}),ud=Uu;var dm=["alert","log","status"];function pm(e){return e=t.getComputedStyle(function(e){for(var t=e,n=e.textContent.trim(),r=n;r===n&&void 0!==t;){var a=-1;if(0===(e=t).children.length)return e;for(;a++,""===(r=e.childre\
n[a].textContent.trim())&&a+1<e.children.length;);t=e.children[a]}return e}(e)),{fontWeight:function(e){switch(e){case"lighter":return 100;case"normal":return 400;case"bold":return 700;case"bolder":return 900}return e=parseInt(e),isNaN(e)?400:e}(e.getPropertyValue("font-weight")),fontSize:parseInt(e.getPropertyValue("font-size")),isItalic:"italic"===e.getPropertyValue("font-style")}}function fm(e,t,n){return n.reduce((function(n,r){return n||(!r.size||e.fontSize/r.size>t.fontSize)&&(!r.weight||e.fontWeight-r.weight>t.fontWeight)&&(!r.italic||e.isItalic&&!t.isItalic)}),!1)}var Dm=/[;,\\s]/,mm=/^[0-9.]+$/;se(Xt={},{aria:function(){return jD},color:function(){return hm},dom:function(){return fu},forms:function(){return Wm},matches:function(){return xs},math:function(){return Ku},standards:function(){return cm},table:function(){return TD},text:function(){return qi},utils:function(){return ia}});var hm={},gm=(se(hm,{Color:function(){return Bp},centerPointOfRect:function(){return gm},elementH\
asImage:function(){return Hl},elementIsDistinct:function(){return vm},filteredRectStack:function(){return Fm},flattenColors:function(){return Cm},flattenShadowColors:function(){return Am},getBackgroundColor:function(){return zm},getBackgroundStack:function(){return km},getContrast:function(){return Hm},getForegroundColor:function(){return Um},getOwnBackgroundColor:function(){return Tp},getRectStack:function(){return ym},getStackingContext:function(){return Pm},getStrokeColorsFromShadows:function(){return Om},getTextShadowColors:function(){return Mm},hasValidContrastRatio:function(){return Gm},incompleteData:function(){return $l},parseTextShadows:function(){return Sm},stackingContextToColor:function(){return Im}}),function(e){if(!(e.left>t.innerWidth||e.top>t.innerHeight))return{x:Math.min(Math.ceil(e.left+e.width/2),t.innerWidth-1),y:Math.min(Math.ceil(e.top+e.height/2),t.innerHeight-1)}});function bm(e){return e.getPropertyValue("font-family").split(/[,;]/g).map((function(e){return e.\
trim().toLowerCase()}))}var vm=function(e,n){var r,a=t.getComputedStyle(e);return"none"!==a.getPropertyValue("background-image")||!!["border-bottom","border-top","outline"].reduce((function(e,t){var n=new Bp;return n.parseString(a.getPropertyValue(t+"-color")),e||"none"!==a.getPropertyValue(t+"-style")&&0<parseFloat(a.getPropertyValue(t+"-width"))&&0!==n.alpha}),!1)||(r=t.getComputedStyle(n),bm(a)[0]!==bm(r)[0])||(e=["text-decoration-line","text-decoration-style","font-weight","font-style","font-size"].reduce((function(e,t){return e||a.getPropertyValue(t)!==r.getPropertyValue(t)}),!1),(n=a.getPropertyValue("text-decoration")).split(" ").length<3?e||n!==r.getPropertyValue("text-decoration"):e)},ym=function(e){var t=_i(e);return!(e=wl(e))||e.length<=1?[t]:e.some((function(e){return void 0===e}))?null:(e.splice(0,0,t),e)},Fm=function(e){var t,n,r=ym(e);return r&&1===r.length?r[0]:r&&1<r.length?(t=r.shift(),r.forEach((function(a,o){var u,i;0!==o&&(u=r[o-1],i=r[o],n=u.every((function(e,t){r\
eturn e===i[t]}))||t.includes(e))})),n?r[0]:($l.set("bgColor","elmPartiallyObscuring"),null)):($l.set("bgColor","outsideViewport"),null)},wm=["hue","saturation","color","luminosity"],Em={normal:function(e,t){return t},multiply:function(e,t){return t*e},screen:function(e,t){return e+t-e*t},overlay:function(e,t){return this["hard-light"](t,e)},darken:function(e,t){return Math.min(e,t)},lighten:function(e,t){return Math.max(e,t)},"color-dodge":function(e,t){return 0===e?0:1===t?1:Math.min(1,e/(1-t))},"color-burn":function(e,t){return 1===e?1:0===t?0:1-Math.min(1,(1-e)/t)},"hard-light":function(e,t){return t<=.5?this.multiply(e,2*t):this.screen(e,2*t-1)},"soft-light":function(e,t){return t<=.5?e-(1-2*t)*e*(1-e):e+(2*t-1)*((e<=.25?((16*e-12)*e+4)*e:Math.sqrt(e))-e)},difference:function(e,t){return Math.abs(e-t)},exclusion:function(e,t){return e+t-2*e*t},hue:function(e,t){return t.setSaturation(e.getSaturation()).setLuminosity(e.getLuminosity())},saturation:function(e,t){return e.setSaturati\
on(t.getSaturation()).setLuminosity(e.getLuminosity())},color:function(e,t){return t.setLuminosity(e.getLuminosity())},luminosity:function(e,t){return e.setLuminosity(t.getLuminosity())}};function Cm(e,t){var n,r,a=function(e,t,n){if(wm.includes(n))return Em[n](e,t);var r=new Bp;return["r","g","b"].forEach((function(a){r[a]=Em[n](e[a],t[a])})),r}(t,e,2<arguments.length&&void 0!==arguments[2]?arguments[2]:"normal"),o=xm(e.red,e.alpha,t.red,t.alpha,255*a.r),u=xm(e.green,e.alpha,t.green,t.alpha,255*a.g),i=(a=xm(e.blue,e.alpha,t.blue,t.alpha,255*a.b),n=e.alpha+t.alpha*(1-e.alpha),i=0,r=1,Math.min(Math.max(i,n),r));return 0===i?new Bp(o,u,a,i):(n=Math.round(o/i),r=Math.round(u/i),o=Math.round(a/i),new Bp(n,r,o,i))}function xm(e,t,n,r,a){return t*(1-r)*e+t*r*a+(1-t)*r*n}function Am(e,t){var n=(1-(a=e.alpha))*t.red+a*e.red,r=(1-a)*t.green+a*e.green,a=(1-a)*t.blue+a*e.blue;t=e.alpha+t.alpha*(1-e.alpha);return new Bp(n,r,a,t)}function km(e){for(var n=wl(e).map((function(n){return function(e){va\
r n=e.indexOf(r.body),a=Tp(t.getComputedStyle(r.documentElement));return 1<n&&0===a.alpha&&!Hl(r.documentElement)&&(1<n&&(e.splice(n,1),e.push(r.body)),0<(a=e.indexOf(r.documentElement)))&&(e.splice(a,1),e.push(r.documentElement)),e}(n=Ip(n,e))})),a=0;a<n.length;a++){var o=n[a];if(o[0]!==e)return $l.set("bgColor","bgOverlap"),null;if(0!==a&&!function(e,t){if(e!==t){if(null===e||null===t)return;if(e.length!==t.length)return;for(var n=0;n<e.length;++n)if(e[n]!==t[n])return}return 1}(o,n[0]))return $l.set("bgColor","elmPartiallyObscuring"),null}return n[0]||null}var Bm=.54,Nm=.5,Tm=1.5,Rm=["top","right","bottom","left"];function Om(e){var t=void 0!==(t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).ignoreEdgeCount)&&t,n=function(e){var t,n={},r=Y(e);try{for(r.s();!(t=r.n()).done;){var a=t.value,o=a.colorStr,u=a.pixels,i=(null!=n[o]||(n[o]={top:[],right:[],bottom:[],left:[]}),n[o]),s=z(u,2),l=s[0],c=s[1];Nm<l?i.right.push(l):Nm<-l&&i.left.push(-l),Nm<c?i.bottom.push(c):Nm<-c&&\
i.top.push(-c)}}catch(e){r.e(e)}finally{r.f()}return n}(e);n=Object.entries(n).map((function(e){var t=(e=z(e,2))[0],n=e[1];e=Rm.filter((function(e){return 0!==n[e].length})).length;return{colorStr:t,sides:n,edgeCount:e}}));return!t&&n.some((function(e){return 1<(e=e.edgeCount)&&e<4}))?null:n.map(_m).filter((function(e){return null!==e}))}function _m(e){var t,n,r=e.colorStr,a=e.sides;return 4!==e.edgeCount?null:((e=new Bp).parseString(r),n=!(t=0),Rm.forEach((function(e){t+=a[e].length/4,n=n&&a[e].every((function(e){return Tm<e}))})),n||(e.alpha=1-Math.pow(Bm,t)),e)}function Sm(e){var t={pixels:[]},n=[t];if(!(o=e.trim()))return[];for(;o;){var r=o.match(/^[a-z]+(\\([^)]+\\))?/i)||o.match(/^#[0-9a-f]+/i),a=o.match(/^([0-9.-]+)px/i)||o.match(/^(0)/);if(r)ya(!t.colorStr,"Multiple colors identified in text-shadow: ".concat(e)),o=o.replace(r[0],"").trim(),t.colorStr=r[0];else if(a){ya(t.pixels.length<3,"Too many pixel units in text-shadow: ".concat(e));var o=o.replace(a[0],"").trim();r=parseFloa\
t(("."===a[1][0]?"0":"")+a[1]);t.pixels.push(r)}else{if(","!==o[0])throw new Error("Unable to process text-shadows: ".concat(o));ya(2<=t.pixels.length,"Missing pixel value in text-shadow: ".concat(e)),n.push(t={pixels:[]}),o=o.substr(1).trim()}}return n.forEach((function(e){2===(e=e.pixels).length&&e.push(0)})),n}function Mm(e){var n,r=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).minRatio,a=n.maxRatio,o=n.ignoreEdgeCount,u=[],i=t.getComputedStyle(e);if("none"!==(n=i.getPropertyValue("text-shadow"))){var s,l=i.getPropertyValue("font-size"),c=parseInt(l),d=(ya(!1===isNaN(c),"Unable to determine font-size value ".concat(l)),[]),p=Y(Sm(n));try{for(p.s();!(s=p.n()).done;){var f=s.value,D=f.colorStr||i.getPropertyValue("color"),m=z(f.pixels,3),h=m[0],g=m[1],b=m[2],v=void 0===b?0:b;if(!(a&&c*a<=v))if(r&&v<c*r)d.push({colorStr:D,pixels:f.pixels});else{if(0<d.length){var y=Om(d,{ignoreEdgeCount:o});if(null===y)return null;u.push.apply(u,j(y)),d.splice(0,d.length)}var F=function\
(e){var t=e.colorStr,n=e.offsetX,r=e.offsetY,a=e.blurRadius;e=e.fontSize;return a<n||a<r?new Bp(0,0,0,0):((n=new Bp).parseString(t),n.alpha*=function(e,t){return 0===e?1:.185/(e/t+.4)}(a,e),n)}({colorStr:D,offsetX:h,offsetY:g,blurRadius:v,fontSize:c});u.push(F)}}}catch(e){p.e(e)}finally{p.f()}if(0<d.length){if(null===(l=Om(d,{ignoreEdgeCount:o})))return null;u.push.apply(u,j(l))}}return u}function Pm(e,t){var n,r,a,o=Za(e);return o._stackingContext||(r=[],a=new Map,(t=null!=(n=t)?n:km(e)).forEach((function(e){var t=(t=e=Za(e),(o=new Bp).parseString(t.getComputedStylePropertyValue("background-color")),o),n=e._stackingOrder.filter((function(e){return!!e.vNode})),o=(n.forEach((function(e,t){e=e.vNode;var o=null==(o=n[t-1])?void 0:o.vNode;o=qm(a,e,o);0!==t||a.get(e)||r.unshift(o),a.set(e,o)})),null==(o=n[n.length-1])?void 0:o.vNode);e=qm(a,e,o);n.length||r.unshift(e),e.bgColor=t})),o._stackingContext=r)}function Im(e){var t;return null!=(t=e.descendants)&&t.length?(t=Cm(e.descendants.reduc\
e(jm,Lm()),e.bgColor,e.descendants[0].blendMode)).alpha*=e.opacity:(t=e.bgColor).alpha*=e.opacity,{color:t,blendMode:e.blendMode}}function jm(e,t){return e=e instanceof Bp?e:Im(e).color,Cm(Im(t).color,e,t.blendMode)}function Lm(e,t){return{vNode:e,ancestor:t,opacity:parseFloat(null!=(t=null==e?void 0:e.getComputedStylePropertyValue("opacity"))?t:1),bgColor:new Bp(0,0,0,0),blendMode:(null==e?void 0:e.getComputedStylePropertyValue("mix-blend-mode"))||void 0,descendants:[]}}function qm(e,t,n){var r=e.get(n);e=null!=(e=e.get(t))?e:Lm(t,r);return r&&n!==t&&!r.descendants.includes(e)&&r.descendants.unshift(e),e}function zm(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:[],a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:.1,o=Za(e),u=o._cache.getBackgroundColor;return u?(n.push.apply(n,j(u.bgElms)),$l.set("bgColor",u.incompleteData),u.bgColor):(u=function(e,n,a){var o=km(e);if(!o)return null;var u=yl(e);(a=null!=(a=Mm(e,{minRatio:a,ignoreEdgeCount:!0}))?a:[]).length&&\
(a=[{color:a.reduce(Am)}]);for(var i=0;i<o.length;i++){var s=o[i],l=t.getComputedStyle(s);if(Hl(s,l))return n.push(s),null;var c=Tp(l);if(0!==c.alpha){if("inline"!==l.getPropertyValue("display")&&!Vm(s,u))return n.push(s),$l.set("bgColor","elmPartiallyObscured"),null;if(n.push(s),1===c.alpha)break}}var d=(a=(d=Pm(e,o)).map(Im).concat(a),function(e,n){var a,o,u,i,s=[];return n||(n=r.documentElement,i=r.body,n=t.getComputedStyle(n),a=t.getComputedStyle(i),o=Tp(n),i=0!==(u=Tp(a)).alpha&&Vm(i,e.getBoundingClientRect()),(0!==u.alpha&&0===o.alpha||i&&1!==u.alpha)&&s.unshift({color:u,blendMode:$m(a.getPropertyValue("mix-blend-mode"))}),0===o.alpha)||i&&1===u.alpha||s.unshift({color:o,blendMode:$m(n.getPropertyValue("mix-blend-mode"))}),s}(e,o.includes(r.body)));return a.unshift.apply(a,j(d)),0===a.length?new Bp(255,255,255,1):(e=a.reduce((function(e,t){return Cm(t.color,e.color instanceof Bp?e.color:e,t.blendMode)})),Cm(e.color instanceof Bp?e.color:e,new Bp(255,255,255,1)))}(e,n,a),o._cache.\
getBackgroundColor={bgColor:u,bgElms:n,incompleteData:$l.get("bgColor")},u)}function Vm(e,n){n=Array.isArray(n)?n:[n];var r=e.getBoundingClientRect(),a=r.right,o=r.bottom,u=t.getComputedStyle(e).getPropertyValue("overflow");return(["scroll","auto"].includes(u)||e instanceof t.HTMLHtmlElement)&&(a=r.left+e.scrollWidth,o=r.top+e.scrollHeight),n.every((function(e){return e.top>=r.top&&e.bottom<=o&&e.left>=r.left&&e.right<=a}))}function $m(e){return e||void 0}var Hm=function(e,t){return t&&e?(t.alpha<1&&(t=Cm(t,e)),e=e.getRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(t,e)+.05)/(Math.min(t,e)+.05)):null};function Um(e,n,r){for(var a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},o=t.getComputedStyle(e),u=[],i=0,s=[function(){var e,t,n=o,r=void 0===(r=(r=a).textStrokeEmMin)?0:r;return 0===(t=parseFloat(n.getPropertyValue("-webkit-text-stroke-width")))||(e=n.getPropertyValue("font-size"),t/=parseFloat(e),isNaN(t))||t<r?null:(e=n.getPropertyValue("-webkit-text-stroke-colo\
r"),(new Bp).parseString(e))},function(){return e=o,(new Bp).parseString(e.getPropertyValue("-webkit-text-fill-color")||e.getPropertyValue("color"));var e},function(){return Mm(e,{minRatio:0})}];i<s.length;i++){var l=(0,s[i])();if(l&&(u=u.concat(l),1===l.alpha))break}var c,d=u.reduce((function(e,t){return Cm(e,t)}));return null===(r=null==r?zm(e,[]):r)?(c=$l.get("bgColor"),$l.set("fgColor",c),null):Cm(function(e,t,n){for(;t;){var r;1===t.opacity&&t.ancestor||(e.alpha*=t.opacity,r=(null==(r=t.ancestor)?void 0:r.descendants)||n,(r=(r=1!==t.opacity?r.slice(0,r.indexOf(t)):r).map(Im)).length&&(r=r.reduce((function(e,t){return Cm(t.color,e.color instanceof Bp?e.color:e)}),{color:new Bp(0,0,0,0),blendMode:"normal"}),e=Cm(e,r))),t=t.ancestor}return e}(d,function e(t,n){var r,a=Y(t);try{for(a.s();!(r=a.n()).done;){var o,u=r.value;if((null==(o=u.vNode)?void 0:o.actualNode)===n)return u;var i=e(u.descendants,n);if(i)return i}}catch(e){a.e(e)}finally{a.f()}}(c=Pm(e),e),c),new Bp(255,255,255,1))}v\
ar Gm=function(e,t,n,r){return e=Hm(e,t),{isValid:(t=r&&Math.ceil(72*n)/96<14||!r&&Math.ceil(72*n)/96<18?4.5:3)<e,contrastRatio:e,expectedContrastRatio:t}},Wm={},Ym=(se(Wm,{isAriaCombobox:function(){return Hs},isAriaListbox:function(){return $s},isAriaRange:function(){return Gs},isAriaTextbox:function(){return Vs},isDisabled:function(){return Km},isNativeSelect:function(){return zs},isNativeTextbox:function(){return qs}}),["fieldset","button","select","input","textarea"]),Km=function e(t){var n,r,a=t._isDisabled;return"boolean"!=typeof a&&(n=t.props.nodeName,r=t.attr("aria-disabled"),a=!(!Ym.includes(n)||!t.hasAttr("disabled"))||(r?"true"===r.toLowerCase():!!t.parent&&e(t.parent)),t._isDisabled=a),a};function Xm(e,t){var n=null==(n=t.data)?void 0:n.headingOrder,r=Jm(t.node.ancestry,1);return n&&(t=n.map((function(e){return q({},e,{ancestry:r.concat(e.ancestry)})})),-1===(n=function(e,t){for(;t.length;){var n=Zm(e,t);if(-1!==n)return n;t=Jm(t,1)}return-1}(e,r))?e.push.apply(e,j(t)):e.sp\
lice.apply(e,[n,0].concat(j(t)))),e}function Zm(e,t){return e.findIndex((function(e){return Lf(e.ancestry,t)}))}function Jm(e,t){return e.slice(0,e.length-t)}function Qm(e,t){return e=e.boundingClientRect,t=t.boundingClientRect,e.top>=t.top&&e.left>=t.left&&e.bottom<=t.bottom&&e.right<=t.right}function eh(e){return{width:Math.round(10*e.width)/10,height:Math.round(10*e.height)/10}}function th(e,t){return su(e,t)&&!Ii(t)}function nh(e){return e.map((function(e){return e.actualNode}))}function rh(e,t){var n=1<arguments.length&&void 0!==t&&t;return e.map((function(e){return{vChild:e,nested:n}}))}function ah(e){return""!==(e||"").trim()}function oh(e){return e=cl(e,{emoji:!0,nonBmp:!0,punctuations:!0}),ls(e)}function uh(e){return e=parseInt(e.attr("tabindex"),10),!isNaN(e)&&e<0}var ih=["block","list-item","table","flex","grid","inline-block"];function sh(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==ih.indexOf(e)||"table-"===e.substr(0,6)}function lh(e,t){return e=e.ge\
tRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(e,t)+.05)/(Math.min(e,t)+.05)}var ch=["block","list-item","table","flex","grid","inline-block"];function dh(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==ch.indexOf(e)||"table-"===e.substr(0,6)}var ph=Ta((function(e,n){function r(e,t){return a.getPropertyValue(e)===t}var a=t.getComputedStyle(e,n);return r("content","none")||r("display","none")||r("visibility","hidden")||!1===r("position","absolute")||0===Tp(a).alpha&&r("background-image","none")?0:(e=fh(a.getPropertyValue("width")),n=fh(a.getPropertyValue("height")),"px"!==e.unit||"px"!==n.unit?0===e.value||0===n.value?0:1/0:e.value*n.value)}));function fh(e){var t=(e=z(e.match(/^([0-9.]+)([a-z]+)$/i)||[],3))[1];e=void 0===(e=e[2])?"":e;return{value:parseFloat(void 0===t?"":t),unit:e.toLowerCase()}}var Dh={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},mh={alert:!0,alertdialog:!0,application:!0,article:!0,banner:!1,complementary:!0,contentinfo:!0,dialog:!0,form:!0,l\
og:!0,main:!0,navigation:!0,region:!0,search:!1,status:!0};function hh(e,t,n,r){var a=es(e);if(!(n=n||om(a)))return null;for(var o=n.includes("group"),u=r?e:e.parent;u;){var i=Ts(u,{noPresentational:!0});if(i){if("group"!==i||!o)return n.includes(i)?null:n;t.includes(a)&&n.push(a),n=n.filter((function(e){return"group"!==e}))}u=u.parent}return n}function gh(e){return 3===(e=e.vNode).props.nodeType?0<e.props.nodeValue.trim().length:kl(e,!1,!0)}function bh(e){var t,n,r=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).invalidTableRowAttrs,a=2<arguments.length?arguments[2]:void 0;r=null!=(t=null==r||null==(t=r.filter)?void 0:t.call(r,(function(e){return a.hasAttr(e)})))?t:[];return 0===r.length||!(t=(t=function(e){if(e.parent)return fo(e,'table:not([role]), [role~="treegrid"], [role~="table"], [role~="grid"]')}(a))&&Ts(t))||"treegrid"===t||(n="row".concat(1<r.length?"Plural":"Singular"),this.data({messageKey:n,invalidAttrs:r,ownerRole:t}),!1)}function vh(e,t,n){var r=(a=n.props).\
nodeName,a=a.type,o=function(e){return e?(e=e.toLowerCase(),["mixed","true"].includes(e)?e:"false"):""}(n.attr("aria-checked"));return"input"!==r||"checkbox"!==a||!o||o===(r=function(e){return e.props.indeterminate?"mixed":e.props.checked?"true":"false"}(n))||(this.data({messageKey:"checkbox",checkState:r}),!1)}var yh={row:bh,checkbox:vh};var Fh=function(e,t){try{return"svg"===t.props.nodeName||!!fo(t,"svg")}catch(e){return!1}},wh=[function(e,t){return Eh(t)},function(e,t){return"area"!==t.props.nodeName},function(e,t){return!Fh(0,t)},function(e,t){return Pi(t)},function(e,t){return Ii(t)||!Ch(t)},function(e){return!jl(e,{noLengthCompare:!0})}];function Eh(e){return"widget"===Ml(e)}var Ch=Ta((function e(t){return!(null==t||!t.parent)&&(!(!Eh(t.parent)||!Ii(t.parent))||e(t.parent))}));var xh=function(e,t){var n=es(t);return!(n&&!["none","presentation"].includes(n)&&!(Gi[n]||{}).accessibleNameRequired&&!Pi(t))};var Ah=["article","aside","main","nav","section"].join(","),kh=function(e,t,n\
){return n.initiator},Bh={emoji:!0,nonBmp:!1,punctuations:!0},Nh={"abstractrole-evaluate":function(e,t,n){return 0<(n=Wp(n.attr("role")).filter((function(e){return"abstract"===Ml(e)}))).length&&(this.data(n),!0)},"accesskeys-after":function(e){var t={};return e.filter((function(e){if(e.data){var n=e.data.toUpperCase();if(!t[n])return(t[n]=e).relatedNodes=[],!0;t[n].relatedNodes.push(e.relatedNodes[0])}return!1})).map((function(e){return e.result=!!e.relatedNodes.length,e}))},"accesskeys-evaluate":function(e,t,n){return Pu(n)||(this.data(n.attr("accesskey")),this.relatedNodes([e])),!0},"alt-space-value-evaluate":function(e,t,n){return"string"==typeof(n=n.attr("alt"))&&/^\\s+$/.test(n)},"aria-allowed-attr-evaluate":function(e,t,n){var r,a=[],o=Ts(n),u=LD(o),i=(Array.isArray(t[o])&&(u=Xf(t[o].concat(u))),Y(n.attrNames));try{for(i.s();!(r=i.n()).done;){var s=r.value;sm(s)&&!u.includes(s)&&a.push(s)}}catch(e){i.e(e)}finally{i.f()}return!a.length||(this.data(a.map((function(e){return e+'="'+n\
.attr(e)+'"'}))),!(o||Pf(n)||Pi(n))&&void 0)},"aria-allowed-attr-matches":function(e,t){var n=/^aria-/,r=t.attrNames;if(r.length)for(var a=0,o=r.length;a<o;a++)if(n.test(r[a]))return!0;return!1},"aria-allowed-role-evaluate":function(e){var t=2<arguments.length?arguments[2]:void 0,n=void 0===(n=(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).allowImplicit)||n,r=void 0===(r=r.ignoredTags)?[]:r,a=t.props.nodeName;return!!r.map((function(e){return e.toLowerCase()})).includes(a)||!(r=UD(t,n)).length||(this.data(r),!Ps(t)&&void 0)},"aria-allowed-role-matches":function(e,t){return null!==es(t,{dpub:!0,fallback:!0})},"aria-busy-evaluate":function(e,t,n){return"true"===n.attr("aria-busy")},"aria-conditional-attr-evaluate":function(e,t,n){var r=Ts(n);return!yh[r]||yh[r].call(this,e,t,n)},"aria-conditional-checkbox-attr-evaluate":vh,"aria-conditional-row-attr-evaluate":bh,"aria-errormessage-evaluate":function(e,t,n){t=Array.isArray(t)?t:[];var r=n.attr("aria-errormessage"),a=n.hasAt\
tr("aria-errormessage"),o=n.attr("aria-invalid");return!n.hasAttr("aria-invalid")||"false"===o||-1!==t.indexOf(r)||!a||(this.data(Wp(r)),function(e){if(""===e.trim())return Zi.ariaAttrs["aria-errormessage"].allowEmpty;var t;try{t=e&&zi(n,"aria-errormessage")[0]}catch(t){return void this.data({messageKey:"idrefs",values:Wp(e)})}return t?Ps(t)?"alert"===t.getAttribute("role")||"assertive"===t.getAttribute("aria-live")||"polite"===t.getAttribute("aria-live")||-1<Wp(n.attr("aria-describedby")).indexOf(e):(this.data({messageKey:"hidden",values:Wp(e)}),!1):void 0}.call(this,r))},"aria-has-attr-matches":function(e,t){var n=/^aria-/;return t.attrNames.some((function(e){return n.test(e)}))},"aria-hidden-body-evaluate":function(e,t,n){return"true"!==n.attr("aria-hidden")},"aria-hidden-focus-matches":function(e){return function e(t){return!t||"true"!==t.getAttribute("aria-hidden")&&e(Lu(t))}(Lu(e))},"aria-label-evaluate":function(e,t,n){return!!ls(Hi(n))},"aria-labelledby-evaluate":function(e,t,n\
){try{return!!ls($i(n))}catch(e){}},"aria-level-evaluate":function(e,t,n){if(n=n.attr("aria-level"),!(6<(n=parseInt(n,10))))return!0},"aria-prohibited-attr-evaluate":function(e){var t,n=2<arguments.length?arguments[2]:void 0,r=(null==(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{})?void 0:r.elementsAllowedAriaLabel)||[],a=n.props.nodeName,o=Ts(n,{chromium:!0});return 0!==(r=function(e,t,n){var r=Zi.ariaRoles[e];return r?r.prohibitedAttrs||[]:e||n.includes(t)?[]:["aria-label","aria-labelledby"]}(o,a,r).filter((function(e){return!!n.attrNames.includes(e)&&""!==ls(n.attr(e))}))).length&&(t=n.hasAttr("role")?"hasRole":"noRole",t+=1<r.length?"Plural":"Singular",this.data({role:o,nodeName:a,messageKey:t,prohibited:r}),o=Js(n,{subtreeDescendant:!0}),""===ls(o)||void 0)},"aria-required-attr-evaluate":function(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=2<arguments.length?arguments[2]:void 0,a=es(r),o=r.attrNames,u=am(a);return Array.isArray(n[a])&&(u=Xf(\
n[a],u)),!(a&&o.length&&u.length&&(n=r,"separator"!==a||Pi(n))&&(o=r,"combobox"!==a||"false"!==o.attr("aria-expanded"))&&(t=As(r),(n=u.filter((function(e){return!(r.attr(e)||void 0!==(null==(n=(n=t).implicitAttrs)?void 0:n[e]));var n}))).length&&(this.data(n),1)))},"aria-required-children-evaluate":function(e,t,n){t=t&&Array.isArray(t.reviewEmpty)?t.reviewEmpty:[];var r,a,o,u=es(n,{dpub:!0}),i=um(u);return null===i||((a=(r=function(e,t){function n(){if(3===r.props.nodeType&&a.push({vNode:r,role:null}),1!==r.props.nodeType||!Ps(r))return 1;var e,n=Ts(r,{noPresentational:!0}),u=(e=r,ns().find((function(t){return e.hasAttr(t)}))),i=!!u||Pi(r);!n&&!i||["group","rowgroup"].includes(n)&&t.some((function(e){return e===n}))?o.push.apply(o,j(r.children)):(n||i)&&a.push({role:n,attr:u||"tabindex",vNode:r})}for(var r,a=[],o=Ss(e);r=o.shift();)n();return a}(n,i)).filter((function(e){var t=e.role;return 1===e.vNode.props.nodeType&&!i.includes(t)}))).length?(this.relatedNodes(a.map((function(e){retu\
rn e.vNode}))),this.data({messageKey:"unallowed",values:a.map((function(e){var t=e.vNode,n=(e=e.attr,t.props),r=n.nodeName;return 3===n.nodeType?"#text":(n=es(t,{dpub:!0}))?"[role=".concat(n,"]"):e?r+"[".concat(e,"]"):r})).filter((function(e,t,n){return n.indexOf(e)===t})).join(", ")}),!1):(o=i,!!r.some((function(e){return(e=e.role)&&o.includes(e)}))||("true"===n.attr("aria-busy")?(this.data({messageKey:"aria-busy"}),!0):(this.data(i),!(!t.includes(u)||r.some(gh))&&void 0))))},"aria-required-children-matches":function(e,t){return t=es(t,{dpub:!0}),!!um(t)},"aria-required-parent-evaluate":function(e,t,n){var r=t&&Array.isArray(t.ownGroupRoles)?t.ownGroupRoles:[],a=hh(n,r);if(!a)return!0;var o=function(e){for(var t,n=[];e;)e.getAttribute("id")&&(t=wa(e.getAttribute("id")),t=mu(e).querySelector("[aria-owns~=".concat(t,"]")))&&n.push(t),e=e.parentElement;return n.length?n:null}(e);if(o)for(var u=0,i=o.length;u<i;u++)if(!(a=hh(Za(o[u]),r,a,!0)))return!0;return this.data(a),!1},"aria-require\
d-parent-matches":function(e,t){return t=es(t),!!om(t)},"aria-roledescription-evaluate":function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=Ts(2<arguments.length?arguments[2]:void 0);return!!(t.supportedRoles||[]).includes(n)||!(!n||"presentation"===n||"none"===n)&&void 0},"aria-unsupported-attr-evaluate":function(e,t,n){return!!(n=n.attrNames.filter((function(t){var n=Zi.ariaAttrs[t];return!!sm(t)&&(t=n.unsupported,"object"!==a(t)?!!t:!xs(e,t.exceptions))}))).length&&(this.data(n),!0)},"aria-valid-attr-evaluate":function(e,t,n){t=Array.isArray(t.value)?t.value:[];var r=[],a=/^aria-/;return n.attrNames.forEach((function(e){-1===t.indexOf(e)&&a.test(e)&&!sm(e)&&r.push(e)})),!r.length||(this.data(r),!1)},"aria-valid-attr-value-evaluate":function(e,t,n){t=Array.isArray(t.value)?t.value:[];var r="",a="",u=[],i=/^aria-/,s=["aria-errormessage"],l={"aria-controls":function(){var e=!1===["false",null].includes(n.attr("aria-haspopup"));return e&&(r='aria-controls="'.co\
ncat(n.attr("aria-controls"),'"'),a="controlsWithinPopup"),"false"!==n.attr("aria-expanded")&&"false"!==n.attr("aria-selected")&&0==e},"aria-current":function(e){e||(r='aria-current="'.concat(n.attr("aria-current"),'"'),a="ariaCurrent")},"aria-owns":function(){return"false"!==n.attr("aria-expanded")},"aria-describedby":function(e){e||(r='aria-describedby="'.concat(n.attr("aria-describedby"),'"'),a=o._tree&&o._tree[0]._hasShadowRoot?"noIdShadow":"noId")},"aria-labelledby":function(e){e||(r='aria-labelledby="'.concat(n.attr("aria-labelledby"),'"'),a=o._tree&&o._tree[0]._hasShadowRoot?"noIdShadow":"noId")}};return n.attrNames.forEach((function(e){if(!s.includes(e)&&!t.includes(e)&&i.test(e)){var o,c=n.attr(e);try{o=im(n,e)}catch(o){return r="".concat(e,'="').concat(c,'"'),void(a="idrefs")}l[e]&&!l[e](o)||o||(""===c&&(o=e,"string"!==(null==(o=Zi.ariaAttrs[e])?void 0:o.type))?(r=e,a="empty"):u.push("".concat(e,'="').concat(c,'"')))}})),u.length?(this.data(u),!1):!r||void this.data({messageK\
ey:a,needsReview:r})},"attr-non-space-content-evaluate":function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=2<arguments.length?arguments[2]:void 0;if(t.attribute&&"string"==typeof t.attribute)return n.hasAttr(t.attribute)?(n=n.attr(t.attribute),!!ls(n)||(this.data({messageKey:"emptyAttr"}),!1)):(this.data({messageKey:"noAttr"}),!1);throw new TypeError("attr-non-space-content requires options.attribute to be a string")},"autocomplete-appropriate-evaluate":function(e,t,n){var r,o,u;return"input"!==n.props.nodeName||(o={bday:["text","search","date"],email:["text","se