import React, { useState } from 'react';
import { View, Text, TextInput, TouchableOpacity, Alert, Image } from 'react-native';
import { useNavigation } from '@react-navigation/native';
import styles from '../styles/styles';

export default function SignupScreen() {
  const navigation = useNavigation();
  const [username, setUsername] = useState('');
  const [password, setPassword] = useState('');
  const [repeat, setRepeat] = useState('');

  const handleSignup = async () => {
    if (!username || !password || !repeat) return Alert.alert('Error', 'Please fill all the gaps');
    if (password !== repeat) return Alert.alert('Error', 'Password do not match');
    try {
      const response = await fetch('http://51.210.149.28:5000/api/signup', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ username, password }),
      });
      const data = await response.json();
      if (response.ok && data.success) {
        Alert.alert('Success', 'Account created');
        navigation.replace('Login');
      } else {
        Alert.alert('Erreur', data.message || 'Échec inscription');
      }
    } catch (e) {
      Alert.alert('Erreur', 'Impossible de contacter le serveur');
    }
  };

  return (
   <View style={styles.container}>
  <Image source={require('../assets/logo.png')} style={styles.logo} />
  <Text style={styles.title}>Registration</Text>

  <TextInput
    style={styles.input}
    placeholder="Username"
    onChangeText={setUsername}
    value={username}
  />
  <TextInput
    style={styles.input}
    placeholder="Password"
    secureTextEntry
    onChangeText={setPassword}
    value={password}
  />
  <TextInput
    style={styles.input}
    placeholder="Repeat password"
    secureTextEntry
    onChangeText={setRepeat}
    value={repeat}
  />

  <TouchableOpacity style={styles.button} onPress={handleSignup}>
    <Text style={styles.buttonText}>Sign Up</Text>
  </TouchableOpacity>

  <View style={{ flexDirection: 'row', marginTop: 20, justifyContent: 'center' }}>
    <Text style={{ color: 'black' }}>Already a LeftLovers? </Text>
    <TouchableOpacity onPress={() => navigation.navigate('Login')}>
      <Text style={styles.link}>Log In</Text>
    </TouchableOpacity>
  </View>
</View>

  );
}
