import React, { useEffect, useRef, useState } from 'react';
import { View, Text, TouchableOpacity, Image, Animated, Dimensions, ActivityIndicator } from 'react-native';
import { logout } from '../auth';
import styles from '../styles/styles';
import CompostProgressBar from './Bar';
import AsyncStorage from '@react-native-async-storage/async-storage';

export default function HomeScreen({ navigation }) {
  const scrollX = useRef(new Animated.Value(0)).current;
  const screenWidth = Dimensions.get('window').width;
  const [username, setUsername] = useState('anonymous');

  const [status, setStatus] = useState(null);
  const [loadingStatus, setLoadingStatus] = useState(true);

  useEffect(() => {
    const anim = Animated.loop(
      Animated.timing(scrollX, {
        toValue: -screenWidth,
        duration: 10000,
        useNativeDriver: true
      })
    );
    anim.start();
    return () => anim.stop();
  }, []);

  useEffect(() => {
    const fetchUsername = async () => {
      const storedUsername = await AsyncStorage.getItem('@username');
      if (storedUsername) setUsername(storedUsername);
    };
    fetchUsername();
  }, []);

  // Fetch status
  useEffect(() => {
    const fetchStatus = async () => {
      try {
        const res = await fetch('http://51.210.149.28:5000/api/home-status');
        const json = await res.json();
        setStatus(json);
      } catch (err) {
        console.error('Status fetch error:', err);
      } finally {
        setLoadingStatus(false);
      }
    };

    fetchStatus();
  }, []);

  const handleLogout = async () => {
    await AsyncStorage.removeItem('@username');
    await logout();
    navigation.replace('Login');
  };

  // Composant interne pour les boutons capteurs
  const SensorButton = ({ label, message, onPress }) => (
    <TouchableOpacity style={styles.card} onPress={onPress}>
      <Text style={styles.cardTitle}>{label}</Text>
      <Text style={styles.cardMessage}>{message}</Text>
    </TouchableOpacity>
  );

  return (
    <View style={styles.container}>
      <Image source={require('../assets/loopbin.png')} style={styles.logoSmall} />

      <TouchableOpacity style={styles.SUSButton} onPress={() => navigation.navigate('Survey', { username })}>
        <Text style={styles.logoutText}>SUS Test</Text>
      </TouchableOpacity>



      <View style={styles.buttonContainer}>
        <TouchableOpacity
          style={styles.mainButton}
          onPress={() => navigation.navigate('Sensors')}
        >
          <Text style={styles.buttonText}>Layer 1</Text>
          <Text style={styles.statusText}>
              {loadingStatus ? 'Loading' : status?.layer1_status || 'No data'}          
          </Text>
        </TouchableOpacity>

        <TouchableOpacity
          style={styles.BButton}
          onPress={() => navigation.navigate('Sensors2')}
        >
          <Text style={styles.buttonText}>Layer 2</Text>
          <Text style={styles.statusText}>
              {loadingStatus ? 'Loading' : status?.layer2_status || 'No data'}          
          </Text>
        </TouchableOpacity>

        <CompostProgressBar />
      </View>

      <TouchableOpacity style={styles.logoutButton} onPress={handleLogout}>
        <Text style={styles.logoutText}>Disconnect</Text>
      </TouchableOpacity>

      <View style={styles.banner}>
        <Animated.Text style={[styles.bannerText, { transform: [{ translateX: scrollX }], width: screenWidth * 2 }]}>
          Please test the app, then complete SUS Test :)
        </Animated.Text>
      </View>
    </View>
  );
}
