// screens/SensorScreen.js
import React, { useEffect, useState } from 'react';
import { View, Text, ScrollView, StyleSheet, RefreshControl } from 'react-native';

export default function SensorScreen() {
  const [data, setData] = useState(null);
  const [refreshing, setRefreshing] = useState(false);

  const fetchData = async () => {
    try {
      const response = await fetch('http://51.210.149.28:5000/api/data');
      const json = await response.json();
      setData(json);
    } catch (e) {
      console.error('Error loading sensors', e);
    }
  };

  useEffect(() => {
    fetchData();
    const interval = setInterval(fetchData, 5000); // rafraîchit toutes les 5s
    return () => clearInterval(interval);
  }, []);

  const onRefresh = async () => {
    setRefreshing(true);
    await fetchData();
    setRefreshing(false);
  };

const LABELS = {
  co2: "CO\u2082",
  humidity: "Moisture",
  temperature: "Temperature",
  // Ajoute autant de correspondances que nécessaire
};


  return (
    <View contentContainerStyle={styles.container} refreshControl={<RefreshControl refreshing={refreshing} onRefresh={onRefresh} />}>
      <Text style={styles.title}>Data sensors</Text>

      {data ? (
        Object.entries(data).map(([key, value]) => (
          <View key={key} style={styles.card}>
            <Text style={styles.cardTitle}>{LABELS[key] || key}</Text>
            <Text style={styles.cardValue}>{value}</Text>
          </View>
        ))
      ) : (
        <Text style={styles.loading}>Loading...</Text>
      )}
    </View>
  );
}

const styles = StyleSheet.create({
  container: { padding: 20, backgroundColor: '#F2F2F2', flexGrow: 1 },
  title: { fontSize: 24, fontWeight: 'bold', marginBottom: 150, textAlign: 'center',marginTop: 50 },
  card: { backgroundColor: '#BBBD9A', padding: 20, borderRadius: 10, marginBottom: 15,marginLeft: 15,marginRight: 15, shadowColor: '#000', shadowOpacity: 0.1, shadowRadius: 5, elevation: 2 },
  cardTitle: { fontSize: 18, fontWeight: 'bold', marginBottom: 5 },
  cardValue: { fontSize: 22, fontWeight: 'bold', color: '#FFF' },
  loading: { textAlign: 'center', marginTop: 40, fontSize: 16, color: '#999' }
});
