import React, { useEffect, useRef } from 'react';
import { View, Text, TouchableOpacity, Image, Animated, Dimensions } from 'react-native';
import { logout } from '../auth';
import styles from '../styles/styles';
import CompostProgressBar from './Bar'; 


export default function HomeScreen({ navigation }) {
  const scrollX = useRef(new Animated.Value(0)).current;
  const screenWidth = Dimensions.get('window').width;

  useEffect(() => {
    const anim = Animated.loop(
      Animated.timing(scrollX, { toValue: -screenWidth, duration: 10000, useNativeDriver: true })
    );
    anim.start();
    return () => anim.stop();
  }, []);

  const handleLogout = async () => {
    await logout();
    navigation.replace('Login');
  };

  return (
    <View style={styles.container}>
      <Image source={require('../assets/loopbin.png')} style={styles.logoSmall} />
      <TouchableOpacity style={styles.SUSButton} onPress={() => navigation.navigate('Survey', { username })}>
        <Text style={styles.logoutText}>SUS Test</Text>
      </TouchableOpacity>
      <View style={styles.buttonContainer}>
        <TouchableOpacity style={styles.mainButton} onPress={() => navigation.navigate('Sensors')}><Text style={styles.buttonText}>Layer 1</Text></TouchableOpacity>
        <TouchableOpacity style={styles.BButton} onPress={() => navigation.navigate('Sensors2')}><Text style={styles.buttonText}>Layer 2</Text></TouchableOpacity>
        <CompostProgressBar />
      </View>
      <TouchableOpacity style={styles.logoutButton} onPress={handleLogout}>
        <Text style={styles.logoutText}>Disconnect</Text>
      </TouchableOpacity>
      <View style={styles.banner}>
        <Animated.Text style={[styles.bannerText, { transform: [{ translateX: scrollX }], width: screenWidth * 2 }]}>
        Please test the app, then complete SUS Test :) 
        </Animated.Text>
      </View>
    </View>
  );
}
