#include <WiFi.h>
#include <HTTPClient.h>
#include <ArduinoJson.h>
#define FAN_PIN 32 

// Wi-Fi
const char* ssid = "iPhone de Nathan";
const char* password = "nat04072002";

// Serveur Flask
const char* serverUrl = "http://51.210.149.28:5000";

// Structure pour retourner les 3 valeurs ensemble
struct Capteurs {
  float temperature;
  float humidite;
  int co2;
};

// États initiaux des deux capteurs
Capteurs compost1 = {55.0, 60.0, 120};
Capteurs compost2 = {55.0, 60.0, 120};

String etat = "pause";

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);

  pinMode(FAN_PIN, OUTPUT); 
  digitalWrite(FAN_PIN, LOW);

  Serial.print("Connexion au Wi-Fi");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nConnecté au réseau !");
}

void loop() {
  if (WiFi.status() == WL_CONNECTED) {
    HTTPClient http;

    // 1. Vérifie l'état
    http.begin(String(serverUrl) + "/api/etat");
    int code = http.GET();
    if (code == 200) {
      String payload = http.getString();
      StaticJsonDocument<200> doc;
      DeserializationError error = deserializeJson(doc, payload);
      if (!error) {
        etat = doc["etat"].as<String>();
        Serial.print("État extrait : ");
        Serial.println(etat);
      } else {
        Serial.println("Erreur JSON état");
      }
    } else {
      Serial.print("Erreur GET état : ");
      Serial.println(code);
    }
    http.end();

    // 2. Si état = demande, mesure et envoie
    if (etat == "demande") {
      compost1 = SimulerCompost(compost1);
      compost2 = SimulerCompost(compost2); 
      float temperature = compost1.temperature;
      float humidity = compost1.humidite;
      int co2 = compost1.co2;
      float temperature2 = compost2.temperature;
      float humidity2 = compost2.humidite;
      int co22 = compost2.co2;

      StaticJsonDocument<200> doc;
      doc["temperature"] = temperature;
      doc["humidity"] = humidity;
      doc["co2"] = co2;
      doc["temperature2"] = temperature2;
      doc["humidity2"] = humidity2;
      doc["co22"] = co22;
      String jsonData;
      serializeJson(doc, jsonData);

      http.begin(String(serverUrl) + "/api/post-data");
      http.addHeader("Content-Type", "application/json");
      int postCode = http.POST(jsonData);
      String response = http.getString();

      Serial.print("POST code: ");
      Serial.println(postCode);
      Serial.print("Réponse POST: ");
      Serial.println(response);

      http.end();
    } else {
      Serial.println("En pause, pas de mesure");
    }

    // 3. Lire l'état du ventilateur
    http.begin(String(serverUrl) + "/api/fan");
    int fanCode = http.GET();
    if (fanCode == 200) {
      String fanPayload = http.getString();
      StaticJsonDocument<200> fanDoc;
      DeserializationError fanError = deserializeJson(fanDoc, fanPayload);
      if (!fanError) {
        String fanState = fanDoc["state"].as<String>();
        Serial.print("État du ventilateur reçu : ");
        Serial.println(fanState);

        if (fanState == "on") {
          digitalWrite(FAN_PIN, HIGH);
        } else {
          digitalWrite(FAN_PIN, LOW);
        }
      } else {
        Serial.println("Erreur JSON ventilateur");
      }
    } else {
      Serial.print("Erreur GET ventilateur : ");
      Serial.println(fanCode);
    }
    http.end();

  } else {
    Serial.println("WiFi non connecté");
  }

  delay(5000); // boucle toutes les 5 secondes
}



// Simulation basée sur un état passé
Capteurs SimulerCompost(Capteurs etat) {
  float tDelta = random(-20, 21) / 10.0;
  float hDelta = random(-15, 16) / 10.0;

  etat.humidite += hDelta;
  etat.humidite = constrain(etat.humidite, 30.0, 80.0);

  if (etat.humidite < 50) {
    tDelta -= (50 - etat.humidite) * 0.05;
  }

  etat.temperature += tDelta;
  etat.temperature = constrain(etat.temperature, 20.0, 80.0);

  etat.co2 += int((etat.temperature - 55.0) * 0.8);
  etat.co2 += random(-5, 6);
  etat.co2 = constrain(etat.co2, 50, 200);

  if (etat.co2 > 160) {
    etat.temperature -= (etat.co2 - 160) * 0.05;
    etat.temperature = constrain(etat.temperature, 20.0, 80.0);
  }
  etat.temperature = round(etat.temperature * 100.0) / 100.0;
  etat.humidite = round(etat.humidite * 100.0) / 100.0;
  
  return etat;
}